(function() {
  (function(factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery-extends'], function($) {
        return factory($);
      });
    } else if (typeof exports === 'object') {
      return factory(require('jquery-extends'));
    } else {
      return factory(jQuery);
    }
  })(function($) {
    'use strict';
    $.messages = $.extend($.messages || {}, {
      'am': 'AM',
      'pm': 'PM',
      'dayShortNames': ['SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT'],
      'dayLongNames': ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
      'monthShortNames': ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
      'monthLongNames': ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'Decomber']
    });
    return $.messages;
  });

}).call(this);

//# sourceMappingURL=jquery-extends-locale_en.js.map
