###!
# @name jQuery ajax success plugin
# @version 1.0.0
# @requires:
#   jquery >= 1.7
###

((factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery'], ($) -> factory $
  else if typeof exports is 'object'
    # CommonJS
    factory require('jquery')
  else
    # Browser globals
    factory jQuery
) ($) ->
  'use strict'

  ###*
  # @param {object} [options] Options
  # @param {function} [callback] Callback
  # @example
  #   <pre>
  #     $.ajax
  #       url: 'test.xml'
  #       dataType: 'xml'
  #       success: $.ajax.success
  #         statusCodeName: 'statusCode'
  #         xmlResponseSelector: ':first'
  #         xmlStatusCodeType: 'A' # A: attribute, E: element
  #       , (data, textStatus, jqXHR) ->
  #         # Success...
  #
  #       error: (jqXHR, textStatus, errorThrown) ->
  #         # Error...
  #
  #   </pre>
  ###
  $.ajax.success = (options, callback) ->
    if $.isFunction options
      [callback, options] = [options, null]
    else
      $.error options + " is not a plain object"  if options and not $.isPlainObject options
      $.error callback + " is not a function"  if callback and not $.isFunction callback

    options = $.extend
      statusCodeName: 'statusCode'
      xmlResponseSelector: ':first'
      xmlStatusCodeType: 'A'
    , options

    (data, textStatus, xhr) ->
      dataTypes = @dataType?.split?(' ') or @dataTypes or []
      statusCode = switch
        when 'json' in dataTypes
          parseInt(data[options.statusCodeName]) or 0
        when 'xml' in dataTypes
          xml = $(data).find(options.xmlResponseSelector)
          switch options.xmlStatusCodeType
            when 'A' then parseInt(xml.attr(options.statusCodeName)) or 0
            when 'E' then parseInt(xml.children(options.statusCodeName).text()) or 0
            else 0
        else 0

      if statusCode >= 400
        # change status code
        xhr.status = statusCode
        # process global error
        if @global
          globalEventContext = if @context?.nodeType or @context?.jquery then $(@context) else $.event
          globalEventContext.trigger('ajaxError', [xhr, @, 'usererror'])
        # process local error
        @error?.call?(@, xhr, 'usererror', null)
      else
        callback?.apply?(@, arguments)

      return undefined

  # Exports
  $.ajax.success
