###!
# @name jQuery Auto Grow plugin
# @version 1.0.0
# @requires:
#   jquery >= 1.7
###

((factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery'], ($) -> factory $
  else if typeof exports is 'object'
    # CommonJS
    factory require('jquery')
  else
    # Browser globals
    factory jQuery
) ($) ->
  'use strict'

  ###*
  # @param {boolean} [denyEnter] 엔터 방지 여부 (default is false)
  # @param {boolean} [autoSubmit] 자동 Submit 여부 (default is false)
  # @param {number} maxRows 최대열
  # @returns {$.fn}
  ###
  $.fn.autoGrow = (denyEnter, autoSubmit, maxRows) ->
    return @  unless @length > 0

    PROP_NAME = '$autoGrow'

    args = $.makeArray arguments
    denyEnter = if typeof args[0] is 'boolean' then args.shift() else false
    autoSubmit = if typeof args[0] is 'boolean' then args.shift() else false
    maxRows = args.shift()

    @filter('textarea').each ->
      $this = $(@)
      isHidden = $this.is(':hidden')
      originalStyleVisibility = @style.visibility

      $this.css('visibility', 'hidden').show()  if isHidden

      if $this.is ':hidden'
        console.log "Element is hidden, skip initialize", @
      else
        data = $this.data(PROP_NAME)
        unless data
          parent = $this.parent()
          originalValue = $this.val()
          $this.val('')
          data = $.data @, PROP_NAME,
            defaultStyleHeight: @style.height
            defaultStyleMaxHeight: @style.maxHeight
            defaultScrollHeight: @scrollHeight
            parent: parent
            parentStyleHeight: parent?[0]?.style?.height or ''
          $this.val(originalValue)

        if maxRows > 0
          originalRows = @rows
          @rows = maxRows
          $this.height('auto')
          $this.css('max-height', $this.height())
          $this.height(data.defaultStyleHeight)
          @rows = originalRows
        else
          $this.css('max-height', data.defaultStyleMaxHeight)

        eventHandler = (e) ->
          if e.type in ['keyup', 'keydown']
            keyCode = e.keyCode or e.charCode
            return  if keyCode is 20 or       # CAPS LOCK
                       keyCode is 27 or       # ESC
                       keyCode in [16..18] or # SHIFT,CTRL,ALT
                       keyCode in [33..40]    # HOME,END,PGUP,UPDN,CURSOR(LEFT, RIGHT, UP, DOWN)

          $this = $(@)

          if denyEnter
            switch e.type
              when 'keydown'
                if (e.keyCode or e.charCode) is 13 # ENTER
                  e.preventDefault()
                  $this.closest('form').submit()  if autoSubmit
                  return #nothing

              when 'change'
                $this.val($this.val().replace(/[\r\n]/g, ''))

          data = $this.data(PROP_NAME)
          scrollTop = $this.scrollTop()
          hasParent = data.parent.length > 0

          data.parent.height(data.parent.height())  if hasParent

          $this.css('overflow-y', 'hidden')
          $this.height(data.defaultStyleHeight)
          if data.defaultScrollHeight < @scrollHeight
            $this.height($this.height() + @scrollHeight - data.defaultScrollHeight)
            $this.scrollTop(scrollTop) # 스크롤 자동 추적

          maxHeight = $this.css('max-height')
          $this.css('overflow-y', 'auto')  unless maxHeight is 'none' or $this.height() < parseInt(maxHeight)

          data.parent.height(data.parentStyleHeight)  if hasParent
        #end of eventHandler = (e) ->

        $this.css 'overflow-y': 'hidden', 'resize': 'none'
        $this.off '.' + PROP_NAME
        $this.on 'change.{0} keyup.{0} keydown.{0}'.format(PROP_NAME), eventHandler
        $this.change()

      $this.css('visibility', originalStyleVisibility).hide()  if isHidden

      return undefined
    #end of @filter('textarea').each ->
    @
  #end of $.fn.autoGrow

  # Exports
  $.fn.autoGrow
