
/*!
 * @name jQuery Auto Grow plugin
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 */

(function() {
  var __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  (function(factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery'], function($) {
        return factory($);
      });
    } else if (typeof exports === 'object') {
      return factory(require('jquery'));
    } else {
      return factory(jQuery);
    }
  })(function($) {
    'use strict';

    /**
     * @param {boolean} [denyEnter] 엔터 방지 여부 (default is false)
     * @param {boolean} [autoSubmit] 자동 Submit 여부 (default is false)
     * @param {number} maxRows 최대열
     * @returns {$.fn}
     */
    $.fn.autoGrow = function(denyEnter, autoSubmit, maxRows) {
      var PROP_NAME, args;
      if (!(this.length > 0)) {
        return this;
      }
      PROP_NAME = '$autoGrow';
      args = $.makeArray(arguments);
      denyEnter = typeof args[0] === 'boolean' ? args.shift() : false;
      autoSubmit = typeof args[0] === 'boolean' ? args.shift() : false;
      maxRows = args.shift();
      this.filter('textarea').each(function() {
        var $this, data, eventHandler, isHidden, originalRows, originalStyleVisibility, originalValue, parent, _ref, _ref1;
        $this = $(this);
        isHidden = $this.is(':hidden');
        originalStyleVisibility = this.style.visibility;
        if (isHidden) {
          $this.css('visibility', 'hidden').show();
        }
        if ($this.is(':hidden')) {
          console.log("Element is hidden, skip initialize", this);
        } else {
          data = $this.data(PROP_NAME);
          if (!data) {
            parent = $this.parent();
            originalValue = $this.val();
            $this.val('');
            data = $.data(this, PROP_NAME, {
              defaultStyleHeight: this.style.height,
              defaultStyleMaxHeight: this.style.maxHeight,
              defaultScrollHeight: this.scrollHeight,
              parent: parent,
              parentStyleHeight: (parent != null ? (_ref = parent[0]) != null ? (_ref1 = _ref.style) != null ? _ref1.height : void 0 : void 0 : void 0) || ''
            });
            $this.val(originalValue);
          }
          if (maxRows > 0) {
            originalRows = this.rows;
            this.rows = maxRows;
            $this.height('auto');
            $this.css('max-height', $this.height());
            $this.height(data.defaultStyleHeight);
            this.rows = originalRows;
          } else {
            $this.css('max-height', data.defaultStyleMaxHeight);
          }
          eventHandler = function(e) {
            var hasParent, keyCode, maxHeight, scrollTop, _ref2;
            if ((_ref2 = e.type) === 'keyup' || _ref2 === 'keydown') {
              keyCode = e.keyCode || e.charCode;
              if (keyCode === 20 || keyCode === 27 || __indexOf.call([16, 17, 18], keyCode) >= 0 || __indexOf.call([33, 34, 35, 36, 37, 38, 39, 40], keyCode) >= 0) {
                return;
              }
            }
            $this = $(this);
            if (denyEnter) {
              switch (e.type) {
                case 'keydown':
                  if ((e.keyCode || e.charCode) === 13) {
                    e.preventDefault();
                    if (autoSubmit) {
                      $this.closest('form').submit();
                    }
                    return;
                  }
                  break;
                case 'change':
                  $this.val($this.val().replace(/[\r\n]/g, ''));
              }
            }
            data = $this.data(PROP_NAME);
            scrollTop = $this.scrollTop();
            hasParent = data.parent.length > 0;
            if (hasParent) {
              data.parent.height(data.parent.height());
            }
            $this.css('overflow-y', 'hidden');
            $this.height(data.defaultStyleHeight);
            if (data.defaultScrollHeight < this.scrollHeight) {
              $this.height($this.height() + this.scrollHeight - data.defaultScrollHeight);
              $this.scrollTop(scrollTop);
            }
            maxHeight = $this.css('max-height');
            if (!(maxHeight === 'none' || $this.height() < parseInt(maxHeight))) {
              $this.css('overflow-y', 'auto');
            }
            if (hasParent) {
              return data.parent.height(data.parentStyleHeight);
            }
          };
          $this.css({
            'overflow-y': 'hidden',
            'resize': 'none'
          });
          $this.off('.' + PROP_NAME);
          $this.on('change.{0} keyup.{0} keydown.{0}'.format(PROP_NAME), eventHandler);
          $this.change();
        }
        if (isHidden) {
          $this.css('visibility', originalStyleVisibility).hide();
        }
        return void 0;
      });
      return this;
    };
    return $.fn.autoGrow;
  });

}).call(this);

//# sourceMappingURL=jquery-autogrow.js.map
