
/*!
 * @name jQuery extends
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 */

(function() {
  var __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  (function(root, factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery'], function($) {
        return factory(root, $);
      });
    } else if (typeof exports === 'object') {
      return factory(root, require('jquery'));
    } else {
      return factory(root, jQuery);
    }
  })((typeof window !== "undefined" && window !== null ? window : this), function(window, $) {
    'use strict';
    var key, shortKey;
    $.messages = $.extend({
      am: 'AM',
      pm: 'PM',
      dayShortNames: ['SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT'],
      dayLongNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
      monthShortNames: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
      monthLongNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'Decomber']
    }, $.messages);
    $.extend({
      nextTick: function(callback) {
        return setTimeout(callback, 0);
      },
      namespace: function(name, props) {
        var nameFragment, obj, _i, _len, _ref;
        if (!name) {
          return this;
        }
        obj = this;
        _ref = $.split(name, '.', '/');
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          nameFragment = _ref[_i];
          if (obj[nameFragment] == null) {
            obj[nameFragment] = {};
          }
          obj = obj[nameFragment];
        }
        return $.extend(obj, props);
      },

      /**
       * @param {date|number|string} input
       */
      parseDate: function(input) {
        var day, month, year, _ref, _ref1, _ref2, _ref3, _ref4, _ref5, _ref6, _ref7;
        if (typeof input === 'string') {
          switch (input.length) {
            case 4:
              if (/\d{4}/.test(input)) {
                return new Date(input, 0, 1);
              }
              break;
            case 6:
              _ref1 = ((_ref = input.match(/(\d{4})(\d{2})/)) != null ? _ref.slice(1, 3) : void 0) || [], year = _ref1[0], month = _ref1[1];
              if ((year != null) && (month != null)) {
                return new Date(year, month - 1, 1);
              }
              break;
            case 7:
              _ref3 = ((_ref2 = input.match(/(\d{4})[\-\.\/](\d{2})/)) != null ? _ref2.slice(1, 3) : void 0) || [], year = _ref3[0], month = _ref3[1];
              if ((year != null) && (month != null)) {
                return new Date(year, month - 1, 1);
              }
              break;
            case 8:
              _ref5 = ((_ref4 = input.match(/(\d{4})(\d{2})(\d{2})/)) != null ? _ref4.slice(1, 4) : void 0) || [], year = _ref5[0], month = _ref5[1], day = _ref5[2];
              if ((year != null) && (month != null) && (day != null)) {
                return new Date(year, month - 1, day);
              }
              break;
            case 10:
              _ref7 = ((_ref6 = input.match(/(\d{4})[\-\.\/](\d{2})[-\.](\d{2})/)) != null ? _ref6.slice(1, 4) : void 0) || [], year = _ref7[0], month = _ref7[1], day = _ref7[2];
              if ((year != null) && (month != null) && (day != null)) {
                return new Date(year, month - 1, day);
              }
          }
        }
        return new Date(input);
      },

      /**
       * @param {array|object} items
       * @param {function} callback
       */
      some: function(items, callback) {
        var i, item, key, _i, _len;
        if (!$.isFunction(callback)) {
          $.error(callback + " is not a function");
        }
        if ($.isArray(items)) {
          for (i = _i = 0, _len = items.length; _i < _len; i = ++_i) {
            item = items[i];
            if (callback.call(window, item, i)) {
              return true;
            }
          }
        } else if ($.isPlainObject(items)) {
          for (key in items) {
            item = items[key];
            if (callback.call(window, item, key)) {
              return true;
            }
          }
        } else {
          $.error(items + " is not array or plain object");
        }
        return false;
      },

      /**
       * @param {boolean|number} [checkbyte] check byte length if true. (default is false)
       * @param {string} string
       */
      getLength: function(checkbyte, string) {
        var args, c, i, length, _i, _ref, _ref1;
        args = $.makeArray(arguments);
        checkbyte = (_ref = typeof args[0]) === 'boolean' || _ref === 'number' ? args.shift() : false;
        if (typeof args[0] !== 'string') {
          $.error(args[0] + " is not a string");
        }
        string = args.shift();
        if (checkbyte === false) {
          return string.length;
        }
        length = 0;
        for (i = _i = 0, _ref1 = string.length; 0 <= _ref1 ? _i < _ref1 : _i > _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
          c = string.charCodeAt(i);
          length += (function() {
            switch (false) {
              case !(c <= 0x00007F):
                return 1;
              case !(typeof checkbyte === 'number' && checkbyte > 0):
                return checkbyte;
              case !(c <= 0x0007FF):
                return 2;
              case !(c <= 0x00FFFF):
                return 3;
              default:
                return 4;
            }
          })();
        }
        return length;
      },

      /**
       * @param {boolean|number} [checkbyte] check byte length if true. (default is false)
       * @param {string} string
       * @param {number} maxLength the max length.
       * @param {string} [suffix] the suffix.
       */
      cutstring: function(checkbyte, string, maxLength, suffix) {
        var args, c, checkedLength, i, l, length, newString, suffixLength, _i, _ref, _ref1;
        args = $.makeArray(arguments);
        checkbyte = (_ref = typeof args[0]) === 'boolean' || _ref === 'number' ? args.shift() : false;
        if (typeof args[0] !== 'string') {
          $.error(args[0] + " is not a string");
        }
        string = args.shift();
        if (typeof args[0] !== 'number') {
          $.error(args[0] + " is not a number");
        }
        maxLength = args.shift();
        suffix = typeof args[0] === 'string' ? args.shift() : '';
        length = $.getLength(checkbyte, string);
        if (!(length > maxLength)) {
          return string;
        }
        suffixLength = $.getLength(checkbyte, suffix);
        if (suffixLength > maxLength) {
          $.error("Max length must be more than suffix length");
        }
        newString = '';
        checkedLength = 0;
        for (i = _i = 0, _ref1 = string.length; 0 <= _ref1 ? _i < _ref1 : _i > _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
          c = string.charAt(i);
          l = $.getLength(checkbyte, c);
          if (checkedLength + l > maxLength - suffixLength) {
            break;
          }
          checkedLength += l;
          newString += c;
        }
        return newString + suffix;
      },

      /**
       * @param {number} size the size.
       * @param {string} [fillChar] the fill character.
       */
      fill: function(size, fillChar) {
        if (typeof size !== 'number') {
          $.error(size + " is not a number");
        }
        if (typeof fillChar === 'undefined') {
          fillChar = " ";
        }
        if (typeof fillChar !== 'string') {
          $.error(fillChar + " is not a string");
        }
        return Array(1 + size).join(fillChar);
      },

      /**
       * @param {string} string the string.
       * @param {number} size the size.
       * @param {string} [fillChar] the fill character.
       */
      leftPad: function(string, size, fillChar) {
        if (typeof string === 'undefined') {
          string = '';
        }
        if (typeof string !== 'string') {
          string = string.toString();
        }
        if (typeof size !== 'number') {
          $.error(size + " is not a number");
        }
        if (typeof fillChar === 'undefined') {
          fillChar = " ";
        }
        if (typeof fillChar !== 'string') {
          $.error(fillChar + " is not a string");
        }
        if (string.length >= size) {
          return string;
        } else {
          return $.fill(size - string.length, fillChar) + string;
        }
      },

      /**
       * @param {string} string the string.
       * @param {number} size the size.
       * @param {string} [fillChar] the fill character.
       */
      rightPad: function(string, size, fillChar) {
        if (typeof string === 'undefined') {
          string = '';
        }
        if (typeof string !== 'string') {
          string = string.toString();
        }
        if (typeof size !== 'number') {
          $.error(size + " is not a number");
        }
        if (typeof fillChar === 'undefined') {
          fillChar = " ";
        }
        if (typeof fillChar !== 'string') {
          $.error(fillChar + " is not a string");
        }
        if (string.length >= size) {
          return string;
        } else {
          return string + $.fill(size - string.length, fillChar);
        }
      },

      /**
       * Max zIndex from document body.
       */
      maxZIndex: function(excludes) {
        return $(document.body).maxZIndex(excludes);
      },

      /**
       * @param {object} [attrs] the attributes.
       * @param {object|array} values the values.
       * @returns {*|HTMLElement}
       */
      makeInput: function(attrs, values) {
        var $input, args, value;
        args = $.makeArray(arguments);
        attrs = $.extend({
          type: 'hidden'
        }, $.isPlainObject(args[0]) ? args.shift() : {});
        values = $.isArray(args[0]) ? args.shift() : args.length > 0 ? args : [''];
        return $((function() {
          var _i, _len, _results;
          _results = [];
          for (_i = 0, _len = values.length; _i < _len; _i++) {
            value = values[_i];
            $input = $('<input/>', attrs);
            if ($.isPlainObject(value)) {
              if ('type' in value) {
                $input.attr('type', value.type);
              }
              if ('name' in value) {
                $input.attr('name', value.name);
              }
              if ('value' in value) {
                $input.val(value.value);
              }
            } else {
              $input.val(value);
            }
            _results.push($input.get(0));
          }
          return _results;
        })());
      },
      xmlToString: function(xmlNode) {
        try {
          return (new XMLSerializer()).serializeToString(xmlNode);
        } catch (_error) {
          if (xmlNode.xml == null) {
            $.error("XMLSerializer not supported");
          }
          return xmlNode.xml;
        }
      },
      deserialize: function(querystring, options) {
        var name, o, pair, pairs, value, _i, _len, _ref;
        if (!(typeof querystring === 'string' && querystring !== '')) {
          return {};
        }
        pairs = querystring.split(/&amp;|&/i);
        if (!$.isPlainObject(options)) {
          options = {};
        }
        o = {};
        for (_i = 0, _len = pairs.length; _i < _len; _i++) {
          pair = pairs[_i];
          _ref = pair.split('='), name = _ref[0], value = _ref[1];
          name = decodeURIComponent(name);
          value = decodeURIComponent(value);
          if (!((options.except != null) && __indexOf.call(options.except, name) >= 0)) {
            $.obj.set(true, o, name, value);
          }
        }
        return o;
      },
      split: function(str, separator, escapeChar, limit) {
        var escaped, i, limited, p, part, parts, s, _ref, _ref1;
        if (typeof separator === 'number') {
          _ref = [separator, null, null], limit = _ref[0], separator = _ref[1], escapeChar = _ref[2];
        } else if (typeof escapeChar === 'number') {
          _ref1 = [escapeChar, null], limit = _ref1[0], escapeChar = _ref1[1];
        }
        str = str.toString();
        limited = function(i) {
          return (0 < limit && limit <= i + 1);
        };
        parts = [];
        i = 0;
        s = 0;
        while ((p = str.indexOf(separator, s)) !== -1 && !limited(i)) {
          part = str.slice(s, p);
          escaped = false;
          if (escapeChar && part.slice(-1) === escapeChar) {
            part = part.slice(0, -1);
            escaped = part.slice(-1) !== escapeChar;
            if (escaped) {
              part += separator;
            }
          }
          parts[i] = (parts[i] || '') + part;
          s = p + 1;
          if (!escaped) {
            i++;
          }
        }
        if (s <= str.length) {
          parts[i] = (parts[i] || '') + str.slice(s);
        }
        return parts;
      },
      supportsInputType: function(type) {
        var input;
        input = document.createElement('input');
        input.setAttribute('type', type);
        return input.type === type;
      },
      antStylePathToRegex: function(path) {
        var pattern;
        if (typeof path !== 'string') {
          $.error("Path must be string type : " + path);
        }
        if (!(path.length > 0)) {
          $.error("Path must not be empty.");
        }
        path = path.replace(/\/{2,}/g, '/');
        path = path.replace(/[-[\]{}()+.,\\^$|#\s]/g, '\\$&');
        pattern = path.replace(/((\/?\*\*)|(\/?\*)|(\?)|(\/))/g, function($0) {
          switch ($0) {
            case '/**':
              return '(?:/{1,}.*)?';
            case '**':
              return '.*';
            case '/*':
              return '(?:/{1,}[^/]*)?';
            case '*':
              return '[^/]*';
            case '?':
              return '[^/]';
            case '/':
              return '/{1,}';
          }
        });
        return new RegExp('^(' + pattern + ')$');
      },
      reindexParams: function(prefix, params) {
        var currIndex, index, param, prevIndex, regex, results, _i, _len;
        regex = new RegExp('^(' + prefix.replace('.', '\\.') + ')\\[(\\d+)\\]');
        prevIndex = null;
        index = -1;
        for (_i = 0, _len = params.length; _i < _len; _i++) {
          param = params[_i];
          results = regex.exec(param.name);
          if (results) {
            currIndex = results[2];
            if (prevIndex !== currIndex) {
              prevIndex = currIndex;
              index++;
            }
            param.name = param.name.replace(regex, '$1[' + index + ']');
          }
        }
        return index;
      }
    });
    $.lpad = $.leftPad;
    $.rpad = $.rightPad;
    $.fn.extend({
      reverse: function() {
        return Array.prototype.reverse.call(this);
      },
      findByName: function(name) {
        return this.find('[name="' + name + '"]');
      },
      findByNames: function() {
        var arg;
        if (arguments.length === 0) {
          return $([]);
        } else {
          return this.find(((function() {
            var _i, _len, _results;
            _results = [];
            for (_i = 0, _len = arguments.length; _i < _len; _i++) {
              arg = arguments[_i];
              _results.push('[name="' + arg + '"]');
            }
            return _results;
          }).apply(this, arguments)).join(','));
        }
      },
      maxZIndex: function(excludes) {
        var zIndex;
        zIndex = 0;
        this.find(':visible').andSelf().add(this.parentsUntil('html')).not(excludes).each(function() {
          var $this, value, _ref;
          if (this.nodeName !== '#document') {
            $this = $(this);
            if ((_ref = $this.css('position')) === 'absolute' || _ref === 'relative' || _ref === 'fixed') {
              value = parseInt($this.css('zIndex'));
              if (!isNaN(value) && value > zIndex) {
                return zIndex = value;
              }
            }
          }
        });
        return zIndex;
      },
      serializeObject: function(options) {
        var result;
        result = {};
        options = options || {};
        $.each(this.serializeArray(), function() {
          var _ref;
          if (!((options.except != null) && (_ref = this.name, __indexOf.call(options.except, _ref) >= 0))) {
            if (this.name in result) {
              if (!$.isArray(result[this.name])) {
                result[this.name] = [result[this.name]];
              }
              return result[this.name].push(this.value);
            } else {
              return result[this.name] = this.value;
            }
          }
        });
        return result;
      },
      appendField: function(name, value, callback) {
        var key, values, _ref, _ref1;
        if (!(this.length > 0)) {
          return this;
        }
        if (typeof name === 'string') {
          _ref = [{}, value], values = _ref[0], values[name] = _ref[1];
        } else if ($.isPlainObject(name)) {
          _ref1 = [name, value], values = _ref1[0], callback = _ref1[1];
        } else {
          return this;
        }
        values = (function() {
          var _results;
          _results = [];
          for (key in values) {
            value = values[key];
            _results.push({
              name: name,
              value: value
            });
          }
          return _results;
        })();
        this.filter('form').each(function() {
          var elements;
          elements = $.makeInput({
            type: 'hidden'
          }, values).appendTo(this);
          if (callback != null) {
            if (typeof callback.call === "function") {
              callback.call(elements, elements);
            }
          }
        });
        return this;
      },
      reclone: function() {
        return this.map((function(args) {
          return function() {
            var newEl, oldEl;
            oldEl = $(this);
            newEl = oldEl.clone.apply(oldEl, args);
            newEl.insertAfter(this);
            oldEl.remove();
            return newEl[0];
          };
        })(arguments));
      },
      groupBy: function(callback) {
        var elem, i, key, result, _i, _len;
        if (!$.isFunction(callback)) {
          $.error(callback + " is not a function");
        }
        result = {};
        for (i = _i = 0, _len = this.length; _i < _len; i = ++_i) {
          elem = this[i];
          key = callback.call(elem, elem, i, this);
          if (key !== void 0) {
            if (!(key in result)) {
              result[key] = $([]);
            }
            result[key].push(this[i]);
          }
        }
        return result;
      }
    });
    $.obj = {
      get: function(obj, key, defaultValue) {
        var keyFragment, _i, _len, _ref;
        if (obj == null) {
          return defaultValue;
        }
        if (!key) {
          return obj;
        }
        _ref = $.split(key, '.', '/');
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          keyFragment = _ref[_i];
          if ((obj = obj[keyFragment]) == null) {
            return defaultValue;
          }
        }
        if ($.isArray(defaultValue) && !$.isArray(obj)) {
          obj = $.makeArray(obj);
        }
        return obj;
      },
      set: function(appendArray, obj, fullkey, value) {
        var args, currObj, i, isNull, key, keys, _i, _len;
        args = $.makeArray(arguments);
        appendArray = typeof args[0] === 'boolean' ? args.shift() : false;
        obj = typeof args[0] === 'object' || $.isFunction(args[0]) ? args.shift() : {};
        if (typeof args[0] !== 'string') {
          $.error("Object key must be string type : " + args[0]);
        }
        fullkey = args.shift();
        value = args.shift();
        keys = $.map($.split(fullkey, '.', '/'), function(key) {
          var inBracket, inKeys, nextMatches;
          if (/^([^\[]+)?\[([^\]]+)?\]/.test(key)) {
            inKeys = [key.match(/^([^\[]+)?/)[1]];
            inBracket = /\[([^\]]+)?\]/g;
            while (nextMatches = inBracket.exec(key)) {
              inKeys.push(nextMatches[1]);
            }
            return inKeys;
          } else {
            return key;
          }
        });
        isNull = function(o, key) {
          try {
            return !(key in o && (o[key] != null));
          } catch (_error) {
            return false;
          }
        };
        currObj = obj;
        for (i = _i = 0, _len = keys.length; _i < _len; i = ++_i) {
          key = keys[i];
          if (i === keys.length - 1) {
            if (!appendArray || isNull(currObj, key)) {
              currObj[key] = value;
            } else if ($.isArray(currObj[key])) {
              currObj[key].push(value);
            } else {
              currObj[key] = [currObj[key], value];
            }
          } else if (isNull(currObj, key)) {
            if (!keys[i + 1]) {
              keys[i + 1] = '0';
            }
            currObj[key] = /^\d+$/.test(keys[i + 1]) ? [] : {};
          } else if (typeof keys[i + 1] === 'undefined') {
            keys[i + 1] = $.isArray(currObj[key]) ? currObj[key].length + '' : '';
          }
          currObj = currObj[key];
        }
        return obj;
      },
      generalize: function(obj) {
        var key, newObj, value;
        if (!$.isPlainObject(obj)) {
          return obj;
        }
        newObj = {};
        for (key in obj) {
          value = obj[key];
          if (key.contains('.') || /\[(\w+)?\]/.test(key)) {
            $.obj.set(true, newObj, key, value);
          } else {
            newObj[key] = value;
          }
        }
        return newObj;
      },
      extend: function(deep, appendArray, target, extendIfUndefined) {
        var args, copy, copyIsArray, flags, name, options, src, srcIsPlainObject, _i, _len;
        args = $.makeArray(arguments);
        deep = typeof args[0] === 'boolean' ? args.shift() : false;
        appendArray = typeof args[0] === 'boolean' ? args.shift() : false;
        extendIfUndefined = typeof args.last() === 'boolean' ? args.pop() : false;
        target = args.length === 1 ? {} : args.shift() || {};
        if (!(typeof target === 'object' || $.isFunction(target))) {
          target = {};
        }
        for (_i = 0, _len = args.length; _i < _len; _i++) {
          options = args[_i];
          if (options != null) {
            for (name in options) {
              src = target[name];
              copy = options[name];
              if (target === copy) {
                continue;
              }
              copyIsArray = false;
              if (deep && copy && ($.isPlainObject(copy) || (copyIsArray = $.isArray(copy)))) {
                if (!copyIsArray) {
                  srcIsPlainObject = false;
                  if (src === void 0 || (srcIsPlainObject = $.isPlainObject(src)) || !extendIfUndefined) {
                    target[name] = $.obj.extend(deep, appendArray, (srcIsPlainObject ? src : {}), copy, extendIfUndefined);
                  }
                } else if (src === void 0 || !extendIfUndefined) {
                  target[name] = $.merge((appendArray && $.isArray(src) ? src : []), $.obj.extend(deep, [], copy));
                }
              } else if (copy !== void 0 && (src === void 0 || !extendIfUndefined)) {
                if (copy instanceof Date) {
                  target[name] = new Date(copy.getTime());
                } else if (copy instanceof RegExp) {
                  flags = '';
                  if (copy.global != null) {
                    flags += 'g';
                  }
                  if (copy.ignoreCase != null) {
                    flags += 'i';
                  }
                  if (copy.multiline != null) {
                    flags += 'm';
                  }
                  if (copy.sticky != null) {
                    flags += 'y';
                  }
                  target[name] = RegExp(copy.source, flags);
                } else {
                  target[name] = copy;
                }
              }
            }
          }
        }
        return target;
      },
      make: function() {
        var i, obj, _i, _ref;
        obj = {};
        for (i = _i = 0, _ref = arguments.length; _i < _ref; i = _i += 2) {
          obj[arguments[i]] = arguments[i + 1];
        }
        return obj;
      },
      empty: function(obj) {
        var key;
        if ($.isPlainObject(obj)) {
          for (key in obj) {
            delete obj[key];
          }
        }
        return obj;
      }
    };
    for (key in $.obj) {
      shortKey = key + 'Object';
      if (!(shortKey in $)) {
        $[shortKey] = $.obj[key];
      }
    }
    String.prototype.contains = function(str) {
      return this.indexOf(str) > -1;
    };
    String.prototype.startsWith = function(str) {
      return this.indexOf(str) === 0;
    };
    String.prototype.endsWith = function(str) {
      var i;
      i = this.lastIndexOf(str);
      return i > -1 && i === this.length - str.toString().length;
    };
    String.prototype.lpad = String.prototype.leftPad = function(size, fillChar) {
      return $.leftPad(this.toString(), size, fillChar);
    };
    String.prototype.rpad = String.prototype.rightPad = function(size, fillChar) {
      return $.rightPad(this.toString(), size, fillChar);
    };
    String.prototype.format = function() {
      return this.replace(/(''|'\{|\}'|\{(\w+)\})/g, (function(args) {
        return function($0, $1, $2) {
          switch ($1) {
            case "''":
              return "'";
            case "'{":
              return '{';
            case "}'":
              return '}';
            default:
              return (!/^\d+$/g.test($2) ? args[0] || {} : $.isArray(args[0]) ? args[0] : args)[$2];
          }
        };
      })(arguments));
    };
    String.prototype.formatVariables = function() {
      var matches, regex, variables, _ref;
      regex = /(''|'\{|\}'|\{(\w+)\})/g;
      variables = [];
      while (matches = regex.exec(this)) {
        if ((_ref = matches[0]) !== "''" && _ref !== "'{" && _ref !== "}'") {
          variables.push(matches[2]);
        }
      }
      return variables;
    };
    String.prototype.parseDate = function() {
      return $.parseDate(this.toString());
    };
    String.prototype.deserialize = function() {
      return $.deserialize(this.toString());
    };
    String.prototype.xmlEscape = function() {
      return this.replace(/(<|>|"|'|&)/g, function($1) {
        switch ($1) {
          case '<':
            return '&lt;';
          case '>':
            return '&gt;';
          case '"':
            return '&#34;';
          case "'":
            return '&#39;';
          case '&':
            return '&amp;';
          default:
            return $1;
        }
      });
    };
    String.prototype.xmlUnescape = function() {
      return this.replace(/(&lt;|&gt;|&#34;|&#39;|&amp;)/g, function($1) {
        switch ($1) {
          case '&lt;':
            return '<';
          case '&gt;':
            return '>';
          case '&#34;':
            return '"';
          case '&#39;':
            return "'";
          case '&amp;':
            return '&';
          default:
            return $1;
        }
      });
    };
    String.prototype.nl2br = function(xmlEscape) {
      return (xmlEscape ? this.xmlEscape() : this).replace(/(\r\n|\n\r|\r|\n)/g, '<br/>');
    };
    String.prototype.br2nl = function(xmlUnescape) {
      var result;
      result = this.replace(/(<br>|<br\/>)/g, '\n');
      if (xmlUnescape) {
        return result.xmlUnescape();
      } else {
        return result;
      }
    };
    String.prototype.quote = function(overlapable) {
      if (arguments.length === 0) {
        overlapable = true;
      }
      if (!overlapable && this.length >= 2) {
        if (this.charAt(0) === '"' && this.charAt(this.length - 1) === '"') {
          return this.toString();
        }
        if (this.charAt(0) === "'" && this.charAt(this.length - 1) === "'") {
          return this.toString();
        }
      }
      return '"' + this + '"';
    };
    String.prototype.unquote = function() {
      if (this.length >= 2 && ((this.charAt(0) === '"' && this.charAt(this.length - 1) === '"') || (this.charAt(0) === "'" && this.charAt(this.length - 1) === "'"))) {
        return this.slice(1, -1);
      }
      return this.toString();
    };
    String.prototype.compareTo = function(str) {
      switch (false) {
        case !(str == null):
          return 1;
        case !(this > str):
          return 1;
        case !(this < str):
          return -1;
        default:
          return 0;
      }
    };
    String.prototype.grouped = function(size) {
      var i, _i, _ref, _results;
      _results = [];
      for (i = _i = 0, _ref = this.length; size > 0 ? _i < _ref : _i > _ref; i = _i += size) {
        _results.push(this.slice(i, i + size));
      }
      return _results;
    };
    String.prototype.groupedRight = function(size) {
      var i;
      return ((function() {
        var _i, _ref, _results;
        _results = [];
        for (i = _i = _ref = this.length; -size > 0 ? _i < 0 : _i > 0; i = _i += -size) {
          _results.push(this.slice(Math.max(0, i - size), i));
        }
        return _results;
      }).call(this)).reverse();
    };
    String.prototype.a = String.prototype.antStylePathToRegex = function() {
      return $.antStylePathToRegex(this.toString());
    };
    String.prototype.r = String.prototype.regex = function(flags) {
      return new RegExp(this, flags);
    };
    if (!String.prototype.trim) {
      String.prototype.trim = function() {
        return $.trim(this.toString());
      };
    }
    Number.prototype.lpad = Number.prototype.leftPad = function(size, fillChar) {
      return this.toString().leftPad(size, fillChar);
    };
    Number.prototype.rpad = Number.prototype.rightPad = function(size, fillChar) {
      return this.toString().rightPad(size, fillChar);
    };
    Array.range = function(from, to, step) {
      var begin, end, i, isNumber, range, _i, _ref;
      range = [];
      isNumber = typeof from === 'number' && typeof to === 'number';
      begin = isNumber ? from : from.toString().charCodeAt(0);
      end = isNumber ? to : to.toString().charCodeAt(0);
      for (i = _i = begin, _ref = step || 1; _ref > 0 ? _i <= end : _i >= end; i = _i += _ref) {
        range.push(isNumber ? i : String.fromCharCode(i));
      }
      return range;
    };
    Array.prototype.first = function() {
      return this[0];
    };
    Array.prototype.last = function() {
      return this[this.length - 1];
    };
    Array.prototype.contains = function(a) {
      return __indexOf.call(this, a) >= 0;
    };
    Array.prototype.include = function(a) {
      var i;
      i = this.indexOf(a);
      if (i > -1) {
        this[i] = a;
      } else {
        this.push(a);
      }
      return this;
    };
    Array.prototype.remove = function(a) {
      var i, _i, _ref;
      for (i = _i = _ref = this.length - 1; _ref <= 0 ? _i <= 0 : _i >= 0; i = _ref <= 0 ? ++_i : --_i) {
        if (this[i] === a) {
          this.splice(i, 1);
          break;
        }
      }
      return this;
    };
    Array.prototype.trimAll = function() {
      var a, _i, _len, _ref, _results;
      _results = [];
      for (_i = 0, _len = this.length; _i < _len; _i++) {
        a = this[_i];
        _results.push((a != null ? typeof a.toString === "function" ? (_ref = a.toString()) != null ? typeof _ref.trim === "function" ? _ref.trim() : void 0 : void 0 : void 0 : void 0) || '');
      }
      return _results;
    };
    Array.prototype.groupBy = function(callback) {
      var a, i, result, _i, _len;
      if (!$.isFunction(callback)) {
        $.error(callback + " is not a function");
      }
      result = {};
      for (i = _i = 0, _len = this.length; _i < _len; i = ++_i) {
        a = this[i];
        key = callback.call(window, a, i, this);
        if (key !== void 0) {
          if (!(key in result)) {
            result[key] = [];
          }
          result[key].push(a);
        }
      }
      return result;
    };
    Array.prototype.grouped = function(size) {
      var i, _i, _ref, _results;
      _results = [];
      for (i = _i = 0, _ref = this.length; size > 0 ? _i < _ref : _i > _ref; i = _i += size) {
        _results.push(this.slice(i, i + size));
      }
      return _results;
    };
    Array.prototype.groupedRight = function(size) {
      var i;
      return ((function() {
        var _i, _ref, _results;
        _results = [];
        for (i = _i = _ref = this.length; -size > 0 ? _i < 0 : _i > 0; i = _i += -size) {
          _results.push(this.slice(Math.max(0, i - size), i));
        }
        return _results;
      }).call(this)).reverse();
    };
    Array.prototype.min = function() {
      return this.reduce(function(a, b) {
        if (a < b) {
          return a;
        } else {
          return b;
        }
      });
    };
    Array.prototype.max = function() {
      return this.reduce(function(a, b) {
        if (a > b) {
          return a;
        } else {
          return b;
        }
      });
    };
    Array.prototype.joinPaths = function() {
      var a, path, _i, _len;
      path = '';
      for (_i = 0, _len = this.length; _i < _len; _i++) {
        a = this[_i];
        if (a) {
          if (path.length > 0 && path.charAt(path.length - 1) !== '/') {
            path += '/';
          }
          path += a.toString();
        }
      }
      return path;
    };
    if (!Array.prototype.some) {
      Array.prototype.some = function(callback) {
        return $.some(this, callback);
      };
    }
    if (!Array.prototype.every) {
      Array.prototype.every = function(callback) {
        var a, _i, _len;
        for (_i = 0, _len = this.length; _i < _len; _i++) {
          a = this[_i];
          if (!callback.call(window, a)) {
            return false;
          }
        }
        return true;
      };
    }
    if (!Array.prototype.indexOf) {
      Array.prototype.indexOf = function(o) {
        var a, i, _i, _len;
        for (i = _i = 0, _len = this.length; _i < _len; i = ++_i) {
          a = this[i];
          if (a === o) {
            return i;
          }
        }
        return -1;
      };
    }
    if (!Array.prototype.reduce) {
      Array.prototype.reduce = function(callback) {
        var i, result, _i, _ref;
        if (!(this.length > 0)) {
          throw new TypeError("Reduce of empty array with no initial value");
        }
        result = this[0];
        for (i = _i = 1, _ref = this.length; 1 <= _ref ? _i < _ref : _i > _ref; i = 1 <= _ref ? ++_i : --_i) {
          result = callback.call(window, result, this[i], i, this);
        }
        return result;
      };
    }
    if (!Array.prototype.filter) {
      Array.prototype.filter = function(callback) {
        var a, i, result, _i, _len;
        result = [];
        for (i = _i = 0, _len = this.length; _i < _len; i = ++_i) {
          a = this[i];
          if (callback.call(window, a, i, this)) {
            result.push(a);
          }
        }
        return result;
      };
    }
    Date.MILLISECONDS_IN_DAY = 86400000;
    Date.MILLISECONDS_IN_HOUR = 3600000;
    Date.MILLISECONDS_IN_MINUTE = 60000;
    Date.MILLISECONDS_IN_SECOND = 1000;
    Date.diff = function(a, b) {
      var times;
      times = this.diffTimes(a, b);
      return {
        days: parseInt(times / this.MILLISECONDS_IN_DAY),
        hours: parseInt(times % this.MILLISECONDS_IN_DAY / this.MILLISECONDS_IN_HOUR),
        minutes: parseInt(times % this.MILLISECONDS_IN_HOUR / this.MILLISECONDS_IN_MINUTE),
        seconds: parseInt(times % this.MILLISECONDS_IN_MINUTE / this.MILLISECONDS_IN_SECOND)
      };
    };
    Date.diffTimes = function(a, b) {
      return a.getTime() - b.getTime();
    };
    Date.diffYears = function(a, b) {
      return a.getFullYear() - b.getFullYear();
    };
    Date.diffMonths = function(a, b) {
      return this.diffYears(a, b) * 12 + a.getMonth() - b.getMonth();
    };
    Date.diffDays = function(a, b) {
      return parseInt(this.diffTimes(a, b) / this.MILLISECONDS_IN_DAY);
    };
    Date.diffHours = function(a, b) {
      return parseInt(this.diffTimes(a, b) / this.MILLISECONDS_IN_HOUR);
    };
    Date.diffMinutes = function(a, b) {
      return parseInt(this.diffTimes(a, b) / this.MILLISECONDS_IN_MINUTE);
    };
    Date.diffSeconds = function(a, b) {
      return parseInt(this.diffTimes(a, b) / this.MILLISECONDS_IN_SECOND);
    };
    Date.prototype.addTime = function(a) {
      this.setTime(this.getTime() + a);
      return this;
    };
    Date.prototype.addYear = function(a) {
      this.setFullYear(this.getFullYear() + a);
      return this;
    };
    Date.prototype.addMonth = function(a) {
      this.setMonth(this.getMonth() + a);
      return this;
    };
    Date.prototype.addDate = function(a) {
      this.setDate(this.getDate() + a);
      return this;
    };
    Date.prototype.addHours = function(a) {
      this.setHours(this.getHours() + a);
      return this;
    };
    Date.prototype.addMinutes = function(a) {
      this.setMinutes(this.getMinutes() + a);
      return this;
    };
    Date.prototype.addSeconds = function(a) {
      this.setSeconds(this.getSeconds() + a);
      return this;
    };
    Date.prototype.addMilliseconds = function(a) {
      this.setMilliseconds(this.getMilliseconds() + a);
      return this;
    };
    Date.prototype.addUTCYear = function(a) {
      this.setUTCFullYear(this.getUTCFullYear() + a);
      return this;
    };
    Date.prototype.addUTCMonth = function(a) {
      this.setUTCMonth(this.getUTCMonth() + a);
      return this;
    };
    Date.prototype.addUTCDate = function(a) {
      this.setUTCDate(this.getUTCDate() + a);
      return this;
    };
    Date.prototype.addUTCHours = function(a) {
      this.setUTCHours(this.getUTCHours() + a);
      return this;
    };
    Date.prototype.addUTCMinutes = function(a) {
      this.setUTCMinutes(this.getUTCMinutes() + a);
      return this;
    };
    Date.prototype.addUTCSeconds = function(a) {
      this.setUTCSeconds(this.getUTCSeconds() + a);
      return this;
    };
    Date.prototype.addUTCMilliseconds = function(a) {
      this.setUTCMilliseconds(this.getUTCMilliseconds() + a);
      return this;
    };
    Date.prototype.diff = function(a) {
      return Date.diff(this, a);
    };
    Date.prototype.diffTimes = function(a) {
      return Date.diffTimes(this, a);
    };
    Date.prototype.diffYears = function(a) {
      return Date.diffYears(this, a);
    };
    Date.prototype.diffMonths = function(a) {
      return Date.diffMonths(this, a);
    };
    Date.prototype.diffDays = function(a) {
      return Date.diffDays(this, a);
    };
    Date.prototype.diffHours = function(a) {
      return Date.diffHours(this, a);
    };
    Date.prototype.diffMinutes = function(a) {
      return Date.diffMinutes(this, a);
    };
    Date.prototype.diffSeconds = function(a) {
      return Date.diffSeconds(this, a);
    };
    Date.prototype.truncateDate = function() {
      return new Date(this.getFullYear(), this.getMonth(), this.getDate());
    };
    Date.prototype.format = function(format) {
      var date;
      if (!format) {
        return format;
      }
      if (isNaN(this.getTime())) {
        return 'NaN';
      }
      date = new Date(this);
      return format.replace(/(''|'[^']+'|y+|m+|M+|d+|D+|h+|H+|s+|S+|E+|a+)/g, function($0) {
        switch ($0.charAt(0)) {
          case "'":
            if ($0.charAt(1) === "'") {
              return "'";
            } else if ($0.charAt($0.length - 1) === "'") {
              return $0.slice(1, -1);
            } else {
              return $0;
            }
          case 'y':
            return ($0.length < 4 ? date.getFullYear().toString().slice(-2) : date.getFullYear()).leftPad($0.length, '0');
          case 'M':
            if ($0.length < 3) {
              return (date.getMonth() + 1).leftPad($0.length, '0');
            } else if ($0.length === 3) {
              return $.messages['monthShortNames'][date.getMonth()];
            } else {
              return $.messages['monthLongNames'][date.getMonth()];
            }
            break;
          case 'd':
            return date.getDate().leftPad($0.length, '0');
          case 'D':
            return parseInt((date.getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / Date.MILLISECONDS_IN_DAY).leftPad($0.length, '0');
          case 'E':
            if ($0.length < 4) {
              return $.messages['dayShortNames'][date.getDay()];
            } else {
              return $.messages['dayLongNames'][date.getDay()];
            }
          case 'a':
            if (date.getHours() < 12) {
              return $.messages['am'];
            } else {
              return $.messages['pm'];
            }
          case 'H':
            return date.getHours().leftPad($0.length, '0');
          case 'h':
            return ((date.getHours() % 12) || 12).leftPad($0.length, '0');
          case 'm':
            return date.getMinutes().leftPad($0.length, '0');
          case 's':
            return date.getSeconds().leftPad($0.length, '0');
          case 'S':
            return date.getMilliseconds().leftPad($0.length, '0');
          default:
            return $0;
        }
      });
    };
    RegExp.escape = function(text) {
      return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
    };
    return $;
  });

}).call(this);

//# sourceMappingURL=jquery-extends.js.map
