
/*!
 * @name jQuery options
 * @version 1.0.0
 * @requires:
 *   jquery >= 1.7
 *   jquery-extends >= 1.0.0
 */

(function() {
  (function(factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery-extends'], function($) {
        return factory($);
      });
    } else if (typeof exports === 'object') {
      return factory(require('jquery-extends'));
    } else {
      return factory(jQuery);
    }
  })(function($) {
    'use strict';
    var Options;
    Options = (function() {
      function Options(defaults) {
        this.$defaults = defaults;
        this.$options = $.obj.extend(true, defaults);
      }

      Options.prototype.get = function(key, defaultValue) {
        if (key) {
          return $.obj.get(this.$options, key, defaultValue);
        } else {
          return this.$options;
        }
      };

      Options.prototype.set = function(options) {
        $.obj.extend(true, this.$options, options);
        return this;
      };

      Options.prototype.reset = function(keepOptions) {
        this.$options = $.obj.extend(true, (keepOptions ? this.$options : {}), this.$defaults);
        return this;
      };

      return Options;

    })();
    $.Options = function(options) {
      return new Options(options);
    };
    return Options;
  });

}).call(this);

//# sourceMappingURL=jquery-options.js.map
