###!
# @name jQuery Parameter Control plugin
# @version 1.0.0
# @requires:
#   jquery >= 1.7
#   jquery-extends >= 1.0.0
###

((factory) ->
  if typeof define is 'function' and define.amd
    # AMD. Register as an anonymous module.
    define ['jquery-extends'], ($) -> factory $
  else if typeof exports is 'object'
    # CommonJS
    factory require('jquery-extends')
  else
    # Browser globals
    factory jQuery
) ($) ->
  'use strict'

  # Default parameters
  defaultParams = {}

  ###*
  # @param {boolean} [clear] clear previous default parameters.
  # @param {object|string} params the parameters or parameter name.
  # @param {object} [value] the parameter value.
  ###
  $.param.setDefaultParams = (clear, params, value) ->
    args = $.makeArray(arguments)
    clear = if typeof args[0] is 'boolean' then args.shift() else false
    params = if typeof args[0] is 'string' then $.obj.make(args.shift(), args.shift()) else args.shift()
    defaultParams = {}  if clear
    $.extend defaultParams, params

  ###*
  # @param {object|string} [params] the parameters or parameter name.
  # @param {boolean} [ignoredEmpty] default is true.
  ###
  $.param.queryData = (params, ignoredEmpty) ->
    params = $.extend({}, defaultParams, params)
    for key, value of params
      params[key] = value()  if $.isFunction value
      delete params[key]  unless ignoredEmpty is false or value? and value isnt ''
    params

  ###*
  # @param {object|string} [params] the parameters or parameter name.
  # @param {boolean} [traditional] the traditional flag.
  # @param {boolean} [ignoredEmpty] default is true.
  ###
  $.param.queryString = (params, traditional, ignoredEmpty) ->
    @(@queryData(params, ignoredEmpty), if not traditional? then true else traditional)

  ###*
  # @param {string} [url] the url.
  # @param {object|string} [params] the parameters or parameter name.
  # @param {boolean} [traditional] the traditional flag.
  # @param {boolean} [ignoredEmpty] default is true.
  ###
  $.param.makeUrl = (url, params, traditional, ignoredEmpty) ->
    url = ''  unless url?
    $.error "URL is not a string [" + url + "]"  unless typeof url is 'string'

    hash = ''
    hashPosition = url.indexOf('#')
    if hashPosition > -1
      hash = url.substring(hashPosition)
      url = url.substring(0, hashPosition)

    queryString = @queryString(params, traditional, ignoredEmpty)
    url += (if url.contains('?') then '&' else '?') + queryString  if queryString
    url + hash

  ###*
  # @param {string} [url] the url.
  # @param {object|string} [params] the parameters or parameter name.
  # @param {boolean} [ignoredEmpty] default is true.
  ###
  $.param.postUrl = (url, params, ignoredEmpty) ->
    url = ''  unless url?
    $.error "URL is not a string [" + url + "]"  unless typeof url is 'string'

    hashPosition = url.indexOf('#')
    url = url.substring(0, hashPosition)  if hashPosition > -1

    i = url.indexOf('?')
    if i > -1
      querystring = url.substring(i + 1)
      params = $.extend(true, {}, $.deserialize(querystring), params)  if querystring
      url = url.substring(0, i)

    form = $('<form/>', action: url, method: 'post')
    form.appendField(@queryData(params, ignoredEmpty))
    form.appendTo(document.body).hide()
    form.submit()
    form.remove()
    return undefined

  String::makeUrl = () -> $.param.makeUrl.apply($.param, $.merge([@toString()], arguments))
  String::postUrl = () -> $.param.postUrl.apply($.param, $.merge([@toString()], arguments))

  # Exports
  $.param
