/*! x509-1.1.12.js (c) 2012-2017 Kenji Urushima | kjur.github.com/jsrsasign/license
 */
function X509(){this.subjectPublicKeyRSA=null;this.subjectPublicKeyRSA_hN=null;this.subjectPublicKeyRSA_hE=null;this.hex=null;this.getSerialNumberHex=function(){return ASN1HEX.getDecendantHexVByNthList(this.hex,0,[0,1])};this.getSignatureAlgorithmField=function(){var b=ASN1HEX.getDecendantHexVByNthList(this.hex,0,[0,2,0]);var a=KJUR.asn1.ASN1Util.oidHexToInt(b);var c=KJUR.asn1.x509.OID.oid2name(a);return c};this.getIssuerHex=function(){return ASN1HEX.getDecendantHexTLVByNthList(this.hex,0,[0,3])};this.getIssuerString=function(){return X509.hex2dn(ASN1HEX.getDecendantHexTLVByNthList(this.hex,0,[0,3]))};this.getSubjectHex=function(){return ASN1HEX.getDecendantHexTLVByNthList(this.hex,0,[0,5])};this.getSubjectString=function(){return X509.hex2dn(ASN1HEX.getDecendantHexTLVByNthList(this.hex,0,[0,5]))};this.getNotBefore=function(){var a=ASN1HEX.getDecendantHexVByNthList(this.hex,0,[0,4,0]);a=a.replace(/(..)/g,"%$1");a=decodeURIComponent(a);return a};this.getNotAfter=function(){var a=ASN1HEX.getDecendantHexVByNthList(this.hex,0,[0,4,1]);a=a.replace(/(..)/g,"%$1");a=decodeURIComponent(a);return a};this.readCertPEM=function(c){var e=ASN1HEX.pemToHex(c);var b=X509.getPublicKeyHexArrayFromCertHex(e);var d=new RSAKey();d.setPublic(b[0],b[1]);this.subjectPublicKeyRSA=d;this.subjectPublicKeyRSA_hN=b[0];this.subjectPublicKeyRSA_hE=b[1];this.hex=e};this.readCertPEMWithoutRSAInit=function(c){var d=ASN1HEX.pemToHex(c);var b=X509.getPublicKeyHexArrayFromCertHex(d);if(typeof this.subjectPublicKeyRSA.setPublic==="function"){this.subjectPublicKeyRSA.setPublic(b[0],b[1])}this.subjectPublicKeyRSA_hN=b[0];this.subjectPublicKeyRSA_hE=b[1];this.hex=d};this.getInfo=function(){var p="Basic Fields\n";p+="  serial number: "+this.getSerialNumberHex()+"\n";p+="  signature algorithm: "+this.getSignatureAlgorithmField()+"\n";p+="  issuer: "+this.getIssuerString()+"\n";p+="  notBefore: "+this.getNotBefore()+"\n";p+="  notAfter: "+this.getNotAfter()+"\n";p+="  subject: "+this.getSubjectString()+"\n";p+="  subject public key info: \n";var j=X509.getSubjectPublicKeyInfoPosFromCertHex(this.hex);var d=ASN1HEX.getHexOfTLV_AtObj(this.hex,j);var n=KEYUTIL.getKey(d,null,"pkcs8pub");if(n instanceof RSAKey){p+="    key algorithm: RSA\n";p+="    n="+n.n.toString(16).substr(0,16)+"...\n";p+="    e="+n.e.toString(16)+"\n"}p+="X509v3 Extensions:\n";var m=X509.getV3ExtInfoListOfCertHex(this.hex);for(var e=0;e<m.length;e++){var b=m[e];var o=KJUR.asn1.x509.OID.oid2name(b.oid);if(o===""){o=b.oid}var k="";if(b.critical===true){k="CRITICAL"}p+="  "+o+" "+k+":\n";if(o==="basicConstraints"){var g=X509.getExtBasicConstraints(this.hex);if(g.cA===undefined){p+="    {}\n"}else{p+="    cA=true";if(g.pathLen!==undefined){p+=", pathLen="+g.pathLen}p+="\n"}}else{if(o==="keyUsage"){p+="    "+X509.getExtKeyUsageString(this.hex)+"\n"}else{if(o==="subjectKeyIdentifier"){p+="    "+X509.getExtSubjectKeyIdentifier(this.hex)+"\n"}else{if(o==="authorityKeyIdentifier"){var a=X509.getExtAuthorityKeyIdentifier(this.hex);if(a.kid!==undefined){p+="    kid="+a.kid+"\n"}}else{if(o==="extKeyUsage"){var h=X509.getExtExtKeyUsageName(this.hex);p+="    "+h.join(", ")+"\n"}else{if(o==="subjectAltName"){var f=X509.getExtSubjectAltName(this.hex);p+="    "+f.join(", ")+"\n"}else{if(o==="cRLDistributionPoints"){var l=X509.getExtCRLDistributionPointsURI(this.hex);p+="    "+l+"\n"}else{if(o==="authorityInfoAccess"){var c=X509.getExtAIAInfo(this.hex);if(c.ocsp!==undefined){p+="    ocsp: "+c.ocsp.join(",")+"\n"}if(c.caissuer!==undefined){p+="    caissuer: "+c.caissuer.join(",")+"\n"}}}}}}}}}}p+="signature algorithm: "+X509.getSignatureAlgorithmName(this.hex)+"\n";p+="signature: "+X509.getSignatureValueHex(this.hex).substr(0,16)+"...\n";return p}}X509.pemToBase64=function(a){var b=a;b=b.replace("-----BEGIN CERTIFICATE-----","");b=b.replace("-----END CERTIFICATE-----","");b=b.replace(/[ \n]+/g,"");return b};X509.pemToHex=function(a){return ASN1HEX.pemToHex(a)};X509.getSubjectPublicKeyPosFromCertHex=function(f){var e=X509.getSubjectPublicKeyInfoPosFromCertHex(f);if(e==-1){return -1}var b=ASN1HEX.getPosArrayOfChildren_AtObj(f,e);if(b.length!=2){return -1}var d=b[1];if(f.substring(d,d+2)!="03"){return -1}var c=ASN1HEX.getStartPosOfV_AtObj(f,d);if(f.substring(c,c+2)!="00"){return -1}return c+2};X509.getSubjectPublicKeyInfoPosFromCertHex=function(d){var c=ASN1HEX.getStartPosOfV_AtObj(d,0);var b=ASN1HEX.getPosArrayOfChildren_AtObj(d,c);if(b.length<1){return -1}if(d.substring(b[0],b[0]+10)=="a003020102"){if(b.length<6){return -1}return b[6]}else{if(b.length<5){return -1}return b[5]}};X509.getPublicKeyHexArrayFromCertHex=function(f){var e=X509.getSubjectPublicKeyPosFromCertHex(f);var b=ASN1HEX.getPosArrayOfChildren_AtObj(f,e);if(b.length!=2){return[]}var d=ASN1HEX.getHexOfV_AtObj(f,b[0]);var c=ASN1HEX.getHexOfV_AtObj(f,b[1]);if(d!=null&&c!=null){return[d,c]}else{return[]}};X509.getHexTbsCertificateFromCert=function(b){var a=ASN1HEX.getStartPosOfV_AtObj(b,0);return a};X509.getPublicKeyHexArrayFromCertPEM=function(c){var d=ASN1HEX.pemToHex(c);var b=X509.getPublicKeyHexArrayFromCertHex(d);return b};X509.hex2dn=function(f,b){if(b===undefined){b=0}if(f.substr(b,2)!=="30"){throw"malformed DN"}var c=new Array();var d=ASN1HEX.getPosArrayOfChildren_AtObj(f,b);for(var e=0;e<d.length;e++){c.push(X509.hex2rdn(f,d[e]))}c=c.map(function(a){return a.replace("/","\\/")});return"/"+c.join("/")};X509.hex2rdn=function(f,b){if(b===undefined){b=0}if(f.substr(b,2)!=="31"){throw"malformed RDN"}var c=new Array();var d=ASN1HEX.getPosArrayOfChildren_AtObj(f,b);for(var e=0;e<d.length;e++){c.push(X509.hex2attrTypeValue(f,d[e]))}c=c.map(function(a){return a.replace("+","\\+")});return c.join("+")};X509.hex2attrTypeValue=function(g,b){if(b===undefined){b=0}if(g.substr(b,2)!=="30"){throw"malformed attribute type and value"}var c=ASN1HEX.getPosArrayOfChildren_AtObj(g,b);if(c.length!==2||g.substr(c[0],2)!=="06"){"malformed attribute type and value"}var d=ASN1HEX.getHexOfV_AtObj(g,c[0]);var h=KJUR.asn1.ASN1Util.oidHexToInt(d);var f=KJUR.asn1.x509.OID.oid2atype(h);var a=ASN1HEX.getHexOfV_AtObj(g,c[1]);var e=hextorstr(a);return f+"="+e};X509.getPublicKeyFromCertHex=function(c){var a,e,b;var g=6;var d=ASN1HEX;var f=d.getVbyList;b=d.getDecendantHexTLVByNthList(c,0,[0,0]);if(b!=="a003020102"){g=5}e=f(c,0,[0,g,0,0],"06");if(e==="2a864886f70d010101"){a=new RSAKey()}else{if(e==="2a8648ce380401"){a=new KJUR.crypto.DSA()}else{if(e==="2a8648ce3d0201"){a=new KJUR.crypto.ECDSA()}else{throw"unsupported public key in X.509 cert"}}}a.readCertPubKeyHex(c,g);return a};X509.getPublicKeyFromCertPEM=function(a){var c=ASN1HEX;var b=c.pemToHex(a);return X509.getPublicKeyFromCertHex(b)};X509.getPublicKeyInfoPropOfCertPEM=function(e){var i={};i.algparam=null;var f=ASN1HEX.pemToHex(e);var d=ASN1HEX.getPosArrayOfChildren_AtObj(f,0);if(d.length!=3){throw"malformed X.509 certificate PEM (code:001)"}if(f.substr(d[0],2)!="30"){throw"malformed X.509 certificate PEM (code:002)"}var c=ASN1HEX.getPosArrayOfChildren_AtObj(f,d[0]);var g=6;if(f.substr(c[0],2)!=="a0"){g=5}if(c.length<g+1){throw"malformed X.509 certificate PEM (code:003)"}var a=ASN1HEX.getPosArrayOfChildren_AtObj(f,c[g]);if(a.length!=2){throw"malformed X.509 certificate PEM (code:004)"}var h=ASN1HEX.getPosArrayOfChildren_AtObj(f,a[0]);if(h.length!=2){throw"malformed X.509 certificate PEM (code:005)"}i.algoid=ASN1HEX.getHexOfV_AtObj(f,h[0]);if(f.substr(h[1],2)=="06"){i.algparam=ASN1HEX.getHexOfV_AtObj(f,h[1])}else{if(f.substr(h[1],2)=="30"){i.algparam=ASN1HEX.getHexOfTLV_AtObj(f,h[1])}}if(f.substr(a[1],2)!="03"){throw"malformed X.509 certificate PEM (code:006)"}var b=ASN1HEX.getHexOfV_AtObj(f,a[1]);i.keyhex=b.substr(2);return i};X509.getPublicKeyInfoPosOfCertHEX=function(c){var b=ASN1HEX.getPosArrayOfChildren_AtObj(c,0);if(b.length!=3){throw"malformed X.509 certificate PEM (code:001)"}if(c.substr(b[0],2)!="30"){throw"malformed X.509 certificate PEM (code:002)"}var a=ASN1HEX.getPosArrayOfChildren_AtObj(c,b[0]);if(a.length<7){throw"malformed X.509 certificate PEM (code:003)"}return a[6]};X509.getV3ExtInfoListOfCertHex=function(g){var b=ASN1HEX.getPosArrayOfChildren_AtObj(g,0);if(b.length!=3){throw"malformed X.509 certificate PEM (code:001)"}if(g.substr(b[0],2)!="30"){throw"malformed X.509 certificate PEM (code:002)"}var a=ASN1HEX.getPosArrayOfChildren_AtObj(g,b[0]);if(a.length<8){throw"malformed X.509 certificate PEM (code:003)"}if(g.substr(a[7],2)!="a3"){throw"malformed X.509 certificate PEM (code:004)"}var h=ASN1HEX.getPosArrayOfChildren_AtObj(g,a[7]);if(h.length!=1){throw"malformed X.509 certificate PEM (code:005)"}if(g.substr(h[0],2)!="30"){throw"malformed X.509 certificate PEM (code:006)"}var f=ASN1HEX.getPosArrayOfChildren_AtObj(g,h[0]);var e=f.length;var d=new Array(e);for(var c=0;c<e;c++){d[c]=X509.getV3ExtItemInfo_AtObj(g,f[c])}return d};X509.getV3ExtItemInfo_AtObj=function(f,g){var e={};e.posTLV=g;var b=ASN1HEX.getPosArrayOfChildren_AtObj(f,g);if(b.length!=2&&b.length!=3){throw"malformed X.509v3 Ext (code:001)"}if(f.substr(b[0],2)!="06"){throw"malformed X.509v3 Ext (code:002)"}var d=ASN1HEX.getHexOfV_AtObj(f,b[0]);e.oid=ASN1HEX.hextooidstr(d);e.critical=false;if(b.length==3){e.critical=true}var c=b[b.length-1];if(f.substr(c,2)!="04"){throw"malformed X.509v3 Ext (code:003)"}e.posV=ASN1HEX.getStartPosOfV_AtObj(f,c);return e};X509.getHexOfTLV_V3ExtValue=function(b,a){var c=X509.getPosOfTLV_V3ExtValue(b,a);if(c==-1){return null}return ASN1HEX.getHexOfTLV_AtObj(b,c)};X509.getHexOfV_V3ExtValue=function(b,a){var c=X509.getPosOfTLV_V3ExtValue(b,a);if(c==-1){return null}return ASN1HEX.getHexOfV_AtObj(b,c)};X509.getPosOfTLV_V3ExtValue=function(f,b){var d=b;if(!b.match(/^[0-9.]+$/)){d=KJUR.asn1.x509.OID.name2oid(b)}if(d==""){return -1}var c=X509.getV3ExtInfoListOfCertHex(f);for(var a=0;a<c.length;a++){var e=c[a];if(e.oid==d){return e.posV}}return -1};X509.getExtBasicConstraints=function(d){var a=X509.getHexOfV_V3ExtValue(d,"basicConstraints");if(a===null){return null}if(a===""){return{}}if(a==="0101ff"){return{cA:true}}if(a.substr(0,8)==="0101ff02"){var c=ASN1HEX.getHexOfV_AtObj(a,6);var b=parseInt(c,16);return{cA:true,pathLen:b}}throw"unknown error"};X509.KEYUSAGE_NAME=["digitalSignature","nonRepudiation","keyEncipherment","dataEncipherment","keyAgreement","keyCertSign","cRLSign","encipherOnly","decipherOnly"];X509.getExtKeyUsageBin=function(d){var b=X509.getHexOfV_V3ExtValue(d,"keyUsage");if(b==""){return""}if(b.length%2!=0||b.length<=2){throw"malformed key usage value"}var a=parseInt(b.substr(0,2));var c=parseInt(b.substr(2),16).toString(2);return c.substr(0,c.length-a)};X509.getExtKeyUsageString=function(e){var d=X509.getExtKeyUsageBin(e);var b=new Array();for(var c=0;c<d.length;c++){if(d.substr(c,1)=="1"){b.push(X509.KEYUSAGE_NAME[c])}}return b.join(",")};X509.getExtSubjectKeyIdentifier=function(b){var a=X509.getHexOfV_V3ExtValue(b,"subjectKeyIdentifier");return a};X509.getExtAuthorityKeyIdentifier=function(f){var b={};var e=X509.getHexOfTLV_V3ExtValue(f,"authorityKeyIdentifier");if(e===null){return null}var c=ASN1HEX.getPosArrayOfChildren_AtObj(e,0);for(var d=0;d<c.length;d++){if(e.substr(c[d],2)==="80"){b.kid=ASN1HEX.getHexOfV_AtObj(e,c[d])}}return b};X509.getExtExtKeyUsageName=function(k){var b=new Array();var f=X509.getHexOfTLV_V3ExtValue(k,"extKeyUsage");if(f===null){return null}var c=ASN1HEX.getPosArrayOfChildren_AtObj(f,0);for(var e=0;e<c.length;e++){var j=ASN1HEX.getHexOfV_AtObj(f,c[e]);var g=KJUR.asn1.ASN1Util.oidHexToInt(j);var d=KJUR.asn1.x509.OID.oid2name(g);b.push(d)}return b};X509.getExtSubjectAltName=function(g){var b=new Array();var f=X509.getHexOfTLV_V3ExtValue(g,"subjectAltName");var c=ASN1HEX.getPosArrayOfChildren_AtObj(f,0);for(var e=0;e<c.length;e++){if(f.substr(c[e],2)==="82"){var d=hextoutf8(ASN1HEX.getHexOfV_AtObj(f,c[e]));b.push(d)}}return b};X509.getExtCRLDistributionPointsURI=function(n){var p=new Array();var k=X509.getHexOfTLV_V3ExtValue(n,"cRLDistributionPoints");var o=ASN1HEX.getPosArrayOfChildren_AtObj(k,0);for(var g=0;g<o.length;g++){var l=ASN1HEX.getHexOfTLV_AtObj(k,o[g]);var b=ASN1HEX.getPosArrayOfChildren_AtObj(l,0);for(var e=0;e<b.length;e++){if(l.substr(b[e],2)==="a0"){var f=ASN1HEX.getHexOfV_AtObj(l,b[e]);if(f.substr(0,2)==="a0"){var c=ASN1HEX.getHexOfV_AtObj(f,0);if(c.substr(0,2)==="86"){var m=ASN1HEX.getHexOfV_AtObj(c,0);var d=hextoutf8(m);p.push(d)}}}}}return p};X509.getExtAIAInfo=function(g){var j={};j.ocsp=[];j.caissuer=[];var h=X509.getPosOfTLV_V3ExtValue(g,"authorityInfoAccess");if(h==-1){return null}if(g.substr(h,2)!="30"){throw"malformed AIA Extn Value"}var d=ASN1HEX.getPosArrayOfChildren_AtObj(g,h);for(var c=0;c<d.length;c++){var a=d[c];var b=ASN1HEX.getPosArrayOfChildren_AtObj(g,a);if(b.length!=2){throw"malformed AccessDescription of AIA Extn"}var e=b[0];var f=b[1];if(ASN1HEX.getHexOfV_AtObj(g,e)=="2b06010505073001"){if(g.substr(f,2)=="86"){j.ocsp.push(hextoutf8(ASN1HEX.getHexOfV_AtObj(g,f)))}}if(ASN1HEX.getHexOfV_AtObj(g,e)=="2b06010505073002"){if(g.substr(f,2)=="86"){j.caissuer.push(hextoutf8(ASN1HEX.getHexOfV_AtObj(g,f)))}}}return j};X509.getSignatureAlgorithmName=function(d){var b=ASN1HEX.getDecendantHexVByNthList(d,0,[1,0]);var a=KJUR.asn1.ASN1Util.oidHexToInt(b);var c=KJUR.asn1.x509.OID.oid2name(a);return c};X509.getSignatureValueHex=function(b){var a=ASN1HEX.getDecendantHexVByNthList(b,0,[2]);if(a.substr(0,2)!=="00"){throw"can't get signature value"}return a.substr(2)};X509.getSerialNumberHex=function(a){return ASN1HEX.getDecendantHexVByNthList(a,0,[0,1])};X509.verifySignature=function(f,c){var d=X509.getSignatureAlgorithmName(f);var a=X509.getSignatureValueHex(f);var b=ASN1HEX.getDecendantHexTLVByNthList(f,0,[0]);var e=new KJUR.crypto.Signature({alg:d});e.init(c);e.updateHex(b);return e.verify(a)};