define(['../internal/baseFunctions', './keysIn'], function(baseFunctions, keysIn) {

  /**
   * Creates an array of function property names from all enumerable properties,
   * own and inherited, of `object`.
   *
   * @static
   * @memberOf _
   * @alias methods
   * @category Object
   * @param {Object} object The object to inspect.
   * @returns {Array} Returns the new array of property names.
   * @example
   *
   * _.functions(_);
   * // => ['after', 'ary', 'assign', ...]
   */
  function functions(object) {
    return baseFunctions(object, keysIn(object));
  }

  return functions;
});
