define([], function() {

  /** Native method references. */
  var floor = Math.floor;

  /* Native method references for those with the same name as other `lodash` methods. */
  var nativeRandom = Math.random;

  /**
   * The base implementation of `_.random` without support for argument juggling
   * and returning floating-point numbers.
   *
   * @private
   * @param {number} min The minimum possible value.
   * @param {number} max The maximum possible value.
   * @returns {number} Returns the random number.
   */
  function baseRandom(min, max) {
    return min + floor(nativeRandom() * (max - min + 1));
  }

  return baseRandom;
});
