define(['./internal/baseSet'], function(baseSet) {

  /**
   * The inverse of `_.toPairs`; this method returns an object composed
   * from key-value `pairs`.
   *
   * @static
   * @memberOf _
   * @category Array
   * @param {Array} pairs The key-value pairs.
   * @returns {Object} Returns the new object.
   * @example
   *
   * _.fromPairs([['fred', 30], ['barney', 40]]);
   * // => { 'fred': 30, 'barney': 40 }
   */
  function fromPairs(pairs) {
    var index = -1,
        length = pairs ? pairs.length : 0,
        result = {};

    while (++index < length) {
      var pair = pairs[index];
      baseSet(result, pair[0], pair[1]);
    }
    return result;
  }

  return fromPairs;
});
