define(['./stackClear', './stackDelete', './stackGet', './stackHas', './stackSet'], function(stackClear, stackDelete, stackGet, stackHas, stackSet) {

  /**
   * Creates a stack cache object to store key-value pairs.
   *
   * @private
   * @param {Array} [values] The values to cache.
   */
  function Stack(values) {
    var index = -1,
        length = values ? values.length : 0;

    this.clear();
    while (++index < length) {
      var entry = values[index];
      this.set(entry[0], entry[1]);
    }
  }

  // Add functions to the `Stack` cache.
  Stack.prototype.clear = stackClear;
  Stack.prototype['delete'] = stackDelete;
  Stack.prototype.get = stackGet;
  Stack.prototype.has = stackHas;
  Stack.prototype.set = stackSet;

  return Stack;
});
