define([], function() {

  /** Used for built-in method references. */
  var arrayProto = Array.prototype;

  /* Built-in method references for those with the same name as other `lodash` methods. */
  var nativeJoin = arrayProto.join;

  /**
   * Converts all elements in `array` into a string separated by `separator`.
   *
   * @static
   * @memberOf _
   * @category Array
   * @param {Array} array The array to convert.
   * @param {string} [separator=','] The element separator.
   * @returns {string} Returns the joined string.
   * @example
   *
   * _.join(['a', 'b', 'c'], '~');
   * // => 'a~b~c'
   */
  function join(array, separator) {
    return array ? nativeJoin.call(array, separator) : '';
  }

  return join;
});
