(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(factory.toString()).default;
	else if(typeof exports === 'object')
		exports["Quagga"] = factory(factory.toString()).default;
	else
		root["Quagga"] = factory(factory.toString()).default;
})(this, function(__factorySource__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 213);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */


var logDisabled_ = true;

// Utility methods.
var utils = {
  disableLog: function(bool) {
    if (typeof bool !== 'boolean') {
      return new Error('Argument type: ' + typeof bool +
          '. Please use a boolean.');
    }
    logDisabled_ = bool;
    return (bool) ? 'adapter.js logging disabled' :
        'adapter.js logging enabled';
  },

  log: function() {
    if (typeof window === 'object') {
      if (logDisabled_) {
        return;
      }
      if (typeof console !== 'undefined' && typeof console.log === 'function') {
        console.log.apply(console, arguments);
      }
    }
  },

  /**
   * Extract browser version out of the provided user agent string.
   *
   * @param {!string} uastring userAgent string.
   * @param {!string} expr Regular expression used as match criteria.
   * @param {!number} pos position in the version string to be returned.
   * @return {!number} browser version.
   */
  extractVersion: function(uastring, expr, pos) {
    var match = uastring.match(expr);
    return match && match.length >= pos && parseInt(match[pos], 10);
  },

  /**
   * Browser detector.
   *
   * @return {object} result containing browser and version
   *     properties.
   */
  detectBrowser: function() {
    // Returned result object.
    var result = {};
    result.browser = null;
    result.version = null;

    // Fail early if it's not a browser
    if (typeof window === 'undefined' || !window.navigator) {
      result.browser = 'Not a browser.';
      return result;
    }

    // Firefox.
    if (navigator.mozGetUserMedia) {
      result.browser = 'firefox';
      result.version = this.extractVersion(navigator.userAgent,
          /Firefox\/([0-9]+)\./, 1);

    // all webkit-based browsers
    } else if (navigator.webkitGetUserMedia) {
      // Chrome, Chromium, Webview, Opera, all use the chrome shim for now
      if (window.webkitRTCPeerConnection) {
        result.browser = 'chrome';
        result.version = this.extractVersion(navigator.userAgent,
          /Chrom(e|ium)\/([0-9]+)\./, 2);

      // Safari or unknown webkit-based
      // for the time being Safari has support for MediaStreams but not webRTC
      } else {
        // Safari UA substrings of interest for reference:
        // - webkit version:           AppleWebKit/602.1.25 (also used in Op,Cr)
        // - safari UI version:        Version/9.0.3 (unique to Safari)
        // - safari UI webkit version: Safari/601.4.4 (also used in Op,Cr)
        //
        // if the webkit version and safari UI webkit versions are equals,
        // ... this is a stable version.
        //
        // only the internal webkit version is important today to know if
        // media streams are supported
        //
        if (navigator.userAgent.match(/Version\/(\d+).(\d+)/)) {
          result.browser = 'safari';
          result.version = this.extractVersion(navigator.userAgent,
            /AppleWebKit\/([0-9]+)\./, 1);

        // unknown webkit-based browser
        } else {
          result.browser = 'Unsupported webkit-based browser ' +
              'with GUM support but no WebRTC support.';
          return result;
        }
      }

    // Edge.
    } else if (navigator.mediaDevices &&
        navigator.userAgent.match(/Edge\/(\d+).(\d+)$/)) {
      result.browser = 'edge';
      result.version = this.extractVersion(navigator.userAgent,
          /Edge\/(\d+).(\d+)$/, 2);

    // Default fallthrough: not supported.
    } else {
      result.browser = 'Not a supported browser.';
      return result;
    }

    return result;
  }
};

// Export.
module.exports = {
  log: utils.log,
  disableLog: utils.disableLog,
  browserDetails: utils.detectBrowser(),
  extractVersion: utils.extractVersion
};


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

var freeGlobal = __webpack_require__(58);

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

module.exports = root;


/***/ },
/* 2 */
/***/ function(module, exports) {

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

module.exports = isArray;


/***/ },
/* 3 */
/***/ function(module, exports) {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

var baseIsNative = __webpack_require__(124),
    getValue = __webpack_require__(154);

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

module.exports = getNative;


/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_merge__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__barcode_reader__ = __webpack_require__(10);


var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };




function EANReader(opts, supplements) {
    opts = __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default()(getDefaulConfig(), opts);
    __WEBPACK_IMPORTED_MODULE_1__barcode_reader__["a" /* default */].call(this, opts, supplements);
}

function getDefaulConfig() {
    var config = {};

    Object.keys(EANReader.CONFIG_KEYS).forEach(function (key) {
        config[key] = EANReader.CONFIG_KEYS[key].default;
    });
    return config;
}

var properties = {
    CODE_L_START: { value: 0 },
    CODE_G_START: { value: 10 },
    START_PATTERN: { value: [1, 1, 1] },
    STOP_PATTERN: { value: [1, 1, 1] },
    MIDDLE_PATTERN: { value: [1, 1, 1, 1, 1] },
    EXTENSION_START_PATTERN: { value: [1, 1, 2] },
    CODE_PATTERN: { value: [[3, 2, 1, 1], [2, 2, 2, 1], [2, 1, 2, 2], [1, 4, 1, 1], [1, 1, 3, 2], [1, 2, 3, 1], [1, 1, 1, 4], [1, 3, 1, 2], [1, 2, 1, 3], [3, 1, 1, 2], [1, 1, 2, 3], [1, 2, 2, 2], [2, 2, 1, 2], [1, 1, 4, 1], [2, 3, 1, 1], [1, 3, 2, 1], [4, 1, 1, 1], [2, 1, 3, 1], [3, 1, 2, 1], [2, 1, 1, 3]] },
    CODE_FREQUENCY: { value: [0, 11, 13, 14, 19, 25, 28, 21, 22, 26] },
    SINGLE_CODE_ERROR: { value: 0.70 },
    AVG_CODE_ERROR: { value: 0.48 },
    FORMAT: { value: "ean_13", writeable: false }
};

EANReader.prototype = Object.create(__WEBPACK_IMPORTED_MODULE_1__barcode_reader__["a" /* default */].prototype, properties);
EANReader.prototype.constructor = EANReader;

EANReader.prototype._decodeCode = function (start, coderange) {
    var counter = [0, 0, 0, 0],
        i,
        self = this,
        offset = start,
        isWhite = !self._row[offset],
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: start,
        end: start
    },
        code,
        error;

    if (!coderange) {
        coderange = self.CODE_PATTERN.length;
    }

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                for (code = 0; code < coderange; code++) {
                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
                    if (error < bestMatch.error) {
                        bestMatch.code = code;
                        bestMatch.error = error;
                    }
                }
                bestMatch.end = i;
                if (bestMatch.error > self.AVG_CODE_ERROR) {
                    return null;
                }
                return bestMatch;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

EANReader.prototype._findPattern = function (pattern, offset, isWhite, tryHarder, epsilon) {
    var counter = [],
        self = this,
        i,
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0
    },
        error,
        j,
        sum;

    if (!offset) {
        offset = self._nextSet(self._row);
    }

    if (isWhite === undefined) {
        isWhite = false;
    }

    if (tryHarder === undefined) {
        tryHarder = true;
    }

    if (epsilon === undefined) {
        epsilon = self.AVG_CODE_ERROR;
    }

    for (i = 0; i < pattern.length; i++) {
        counter[i] = 0;
    }

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                sum = 0;
                for (j = 0; j < counter.length; j++) {
                    sum += counter[j];
                }
                error = self._matchPattern(counter, pattern);

                if (error < epsilon) {
                    bestMatch.error = error;
                    bestMatch.start = i - sum;
                    bestMatch.end = i;
                    return bestMatch;
                }
                if (tryHarder) {
                    for (j = 0; j < counter.length - 2; j++) {
                        counter[j] = counter[j + 2];
                    }
                    counter[counter.length - 2] = 0;
                    counter[counter.length - 1] = 0;
                    counterPos--;
                } else {
                    return null;
                }
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

EANReader.prototype._findStart = function () {
    var self = this,
        leadingWhitespaceStart,
        offset = self._nextSet(self._row),
        startInfo;

    while (!startInfo) {
        startInfo = self._findPattern(self.START_PATTERN, offset);
        if (!startInfo) {
            return null;
        }
        leadingWhitespaceStart = startInfo.start - (startInfo.end - startInfo.start);
        if (leadingWhitespaceStart >= 0) {
            if (self._matchRange(leadingWhitespaceStart, startInfo.start, 0)) {
                return startInfo;
            }
        }
        offset = startInfo.end;
        startInfo = null;
    }
};

EANReader.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start);
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
    return null;
};

EANReader.prototype._findEnd = function (offset, isWhite) {
    var self = this,
        endInfo = self._findPattern(self.STOP_PATTERN, offset, isWhite, false);

    return endInfo !== null ? self._verifyTrailingWhitespace(endInfo) : null;
};

EANReader.prototype._calculateFirstDigit = function (codeFrequency) {
    var i,
        self = this;

    for (i = 0; i < self.CODE_FREQUENCY.length; i++) {
        if (codeFrequency === self.CODE_FREQUENCY[i]) {
            return i;
        }
    }
    return null;
};

EANReader.prototype._decodePayload = function (code, result, decodedCodes) {
    var i,
        self = this,
        codeFrequency = 0x0,
        firstDigit;

    for (i = 0; i < 6; i++) {
        code = self._decodeCode(code.end);
        if (!code) {
            return null;
        }
        if (code.code >= self.CODE_G_START) {
            code.code = code.code - self.CODE_G_START;
            codeFrequency |= 1 << 5 - i;
        } else {
            codeFrequency |= 0 << 5 - i;
        }
        result.push(code.code);
        decodedCodes.push(code);
    }

    firstDigit = self._calculateFirstDigit(codeFrequency);
    if (firstDigit === null) {
        return null;
    }
    result.unshift(firstDigit);

    code = self._findPattern(self.MIDDLE_PATTERN, code.end, true, false);
    if (code === null) {
        return null;
    }
    decodedCodes.push(code);

    for (i = 0; i < 6; i++) {
        code = self._decodeCode(code.end, self.CODE_G_START);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code);
    }

    return code;
};

EANReader.prototype._decode = function () {
    var startInfo,
        self = this,
        code,
        result = [],
        decodedCodes = [],
        resultInfo = {};

    startInfo = self._findStart();
    if (!startInfo) {
        return null;
    }
    code = {
        code: startInfo.code,
        start: startInfo.start,
        end: startInfo.end
    };
    decodedCodes.push(code);
    code = self._decodePayload(code, result, decodedCodes);
    if (!code) {
        return null;
    }
    code = self._findEnd(code.end, false);
    if (!code) {
        return null;
    }

    decodedCodes.push(code);

    // Checksum
    if (!self._checksum(result)) {
        return null;
    }

    if (this.supplements.length > 0) {
        var ext = this._decodeExtensions(code.end);
        if (!ext) {
            return null;
        }
        var lastCode = ext.decodedCodes[ext.decodedCodes.length - 1],
            endInfo = {
            start: lastCode.start + ((lastCode.end - lastCode.start) / 2 | 0),
            end: lastCode.end
        };
        if (!self._verifyTrailingWhitespace(endInfo)) {
            return null;
        }
        resultInfo = {
            supplement: ext,
            code: result.join("") + ext.code
        };
    }

    return _extends({
        code: result.join(""),
        start: startInfo.start,
        end: code.end,
        codeset: "",
        startInfo: startInfo,
        decodedCodes: decodedCodes
    }, resultInfo);
};

EANReader.prototype._decodeExtensions = function (offset) {
    var i,
        start = this._nextSet(this._row, offset),
        startInfo = this._findPattern(this.EXTENSION_START_PATTERN, start, false, false),
        result;

    if (startInfo === null) {
        return null;
    }

    for (i = 0; i < this.supplements.length; i++) {
        result = this.supplements[i].decode(this._row, startInfo.end);
        if (result !== null) {
            return {
                code: result.code,
                start: start,
                startInfo: startInfo,
                end: result.end,
                codeset: "",
                decodedCodes: result.decodedCodes
            };
        }
    }
    return null;
};

EANReader.prototype._checksum = function (result) {
    var sum = 0,
        i;

    for (i = result.length - 2; i >= 0; i -= 2) {
        sum += result[i];
    }
    sum *= 3;
    for (i = result.length - 1; i >= 0; i -= 2) {
        sum += result[i];
    }
    return sum % 10 === 0;
};

EANReader.CONFIG_KEYS = {
    supplements: {
        'type': 'arrayOf(string)',
        'default': [],
        'description': 'Allowed extensions to be decoded (2 and/or 5)'
    }
};

/* harmony default export */ exports["a"] = EANReader;

/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(12),
    getRawTag = __webpack_require__(152),
    objectToString = __webpack_require__(183);

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

var isArray = __webpack_require__(2),
    isKey = __webpack_require__(165),
    stringToPath = __webpack_require__(192),
    toString = __webpack_require__(203);

/**
 * Casts `value` to a path array if it's not one.
 *
 * @private
 * @param {*} value The value to inspect.
 * @param {Object} [object] The object to query keys on.
 * @returns {Array} Returns the cast property path array.
 */
function castPath(value, object) {
  if (isArray(value)) {
    return value;
  }
  return isKey(value, object) ? [value] : stringToPath(toString(value));
}

module.exports = castPath;


/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

var assignValue = __webpack_require__(29),
    baseAssignValue = __webpack_require__(30);

/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  var isNew = !object;
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];

    var newValue = customizer
      ? customizer(object[key], source[key], key, object, source)
      : undefined;

    if (newValue === undefined) {
      newValue = source[key];
    }
    if (isNew) {
      baseAssignValue(object, key, newValue);
    } else {
      assignValue(object, key, newValue);
    }
  }
  return object;
}

module.exports = copyObject;


/***/ },
/* 9 */
/***/ function(module, exports) {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
function BarcodeReader(config, supplements) {
    this._row = [];
    this.config = config || {};
    this.supplements = supplements;
    return this;
}

BarcodeReader.prototype._nextUnset = function (line, start) {
    var i;

    if (start === undefined) {
        start = 0;
    }
    for (i = start; i < line.length; i++) {
        if (!line[i]) {
            return i;
        }
    }
    return line.length;
};

BarcodeReader.prototype._matchPattern = function (counter, code, maxSingleError) {
    var i,
        error = 0,
        singleError = 0,
        sum = 0,
        modulo = 0,
        barWidth,
        count,
        scaled;

    maxSingleError = maxSingleError || this.SINGLE_CODE_ERROR || 1;

    for (i = 0; i < counter.length; i++) {
        sum += counter[i];
        modulo += code[i];
    }
    if (sum < modulo) {
        return Number.MAX_VALUE;
    }
    barWidth = sum / modulo;
    maxSingleError *= barWidth;

    for (i = 0; i < counter.length; i++) {
        count = counter[i];
        scaled = code[i] * barWidth;
        singleError = Math.abs(count - scaled) / scaled;
        if (singleError > maxSingleError) {
            return Number.MAX_VALUE;
        }
        error += singleError;
    }
    return error / modulo;
};

BarcodeReader.prototype._nextSet = function (line, offset) {
    var i;

    offset = offset || 0;
    for (i = offset; i < line.length; i++) {
        if (line[i]) {
            return i;
        }
    }
    return line.length;
};

BarcodeReader.prototype._correctBars = function (counter, correction, indices) {
    var length = indices.length,
        tmp = 0;
    while (length--) {
        tmp = counter[indices[length]] * (1 - (1 - correction) / 2);
        if (tmp > 1) {
            counter[indices[length]] = tmp;
        }
    }
};

BarcodeReader.prototype._matchTrace = function (cmpCounter, epsilon) {
    var counter = [],
        i,
        self = this,
        offset = self._nextSet(self._row),
        isWhite = !self._row[offset],
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0
    },
        error;

    if (cmpCounter) {
        for (i = 0; i < cmpCounter.length; i++) {
            counter.push(0);
        }
        for (i = offset; i < self._row.length; i++) {
            if (self._row[i] ^ isWhite) {
                counter[counterPos]++;
            } else {
                if (counterPos === counter.length - 1) {
                    error = self._matchPattern(counter, cmpCounter);

                    if (error < epsilon) {
                        bestMatch.start = i - offset;
                        bestMatch.end = i;
                        bestMatch.counter = counter;
                        return bestMatch;
                    } else {
                        return null;
                    }
                } else {
                    counterPos++;
                }
                counter[counterPos] = 1;
                isWhite = !isWhite;
            }
        }
    } else {
        counter.push(0);
        for (i = offset; i < self._row.length; i++) {
            if (self._row[i] ^ isWhite) {
                counter[counterPos]++;
            } else {
                counterPos++;
                counter.push(0);
                counter[counterPos] = 1;
                isWhite = !isWhite;
            }
        }
    }

    // if cmpCounter was not given
    bestMatch.start = offset;
    bestMatch.end = self._row.length - 1;
    bestMatch.counter = counter;
    return bestMatch;
};

BarcodeReader.prototype.decodePattern = function (pattern) {
    var self = this,
        result;

    self._row = pattern;
    result = self._decode();
    if (result === null) {
        self._row.reverse();
        result = self._decode();
        if (result) {
            result.direction = BarcodeReader.DIRECTION.REVERSE;
            result.start = self._row.length - result.start;
            result.end = self._row.length - result.end;
        }
    } else {
        result.direction = BarcodeReader.DIRECTION.FORWARD;
    }
    if (result) {
        result.format = self.FORMAT;
    }
    return result;
};

BarcodeReader.prototype._matchRange = function (start, end, value) {
    var i;

    start = start < 0 ? 0 : start;
    for (i = start; i < end; i++) {
        if (this._row[i] !== value) {
            return false;
        }
    }
    return true;
};

BarcodeReader.prototype._fillCounters = function (offset, end, isWhite) {
    var self = this,
        counterPos = 0,
        i,
        counters = [];

    isWhite = typeof isWhite !== 'undefined' ? isWhite : true;
    offset = typeof offset !== 'undefined' ? offset : self._nextUnset(self._row);
    end = end || self._row.length;

    counters[counterPos] = 0;
    for (i = offset; i < end; i++) {
        if (self._row[i] ^ isWhite) {
            counters[counterPos]++;
        } else {
            counterPos++;
            counters[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return counters;
};

Object.defineProperty(BarcodeReader.prototype, "FORMAT", {
    value: 'unknown',
    writeable: false
});

BarcodeReader.DIRECTION = {
    FORWARD: 1,
    REVERSE: -1
};

BarcodeReader.Exception = {
    StartNotFoundException: "Start-Info was not found!",
    CodeNotFoundException: "Code could not be found!",
    PatternNotFoundException: "Pattern could not be found!"
};

BarcodeReader.CONFIG_KEYS = {};

/* harmony default export */ exports["a"] = BarcodeReader;

/***/ },
/* 11 */
/***/ function(module, exports) {

module.exports = clone

/**
 * Creates a new vec2 initialized with values from an existing vector
 *
 * @param {vec2} a vector to clone
 * @returns {vec2} a new 2D vector
 */
function clone(a) {
    var out = new Float32Array(2)
    out[0] = a[0]
    out[1] = a[1]
    return out
}

/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

var root = __webpack_require__(1);

/** Built-in value references. */
var Symbol = root.Symbol;

module.exports = Symbol;


/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony default export */ exports["a"] = {
    init: function init(arr, val) {
        var l = arr.length;
        while (l--) {
            arr[l] = val;
        }
    },

    /**
     * Shuffles the content of an array
     * @return {Array} the array itself shuffled
     */
    shuffle: function shuffle(arr) {
        var i = arr.length - 1,
            j,
            x;
        for (i; i >= 0; i--) {
            j = Math.floor(Math.random() * i);
            x = arr[i];
            arr[i] = arr[j];
            arr[j] = x;
        }
        return arr;
    },

    toPointList: function toPointList(arr) {
        var i,
            j,
            row = [],
            rows = [];
        for (i = 0; i < arr.length; i++) {
            row = [];
            for (j = 0; j < arr[i].length; j++) {
                row[j] = arr[i][j];
            }
            rows[i] = "[" + row.join(",") + "]";
        }
        return "[" + rows.join(",\r\n") + "]";
    },

    /**
     * returns the elements which's score is bigger than the threshold
     * @return {Array} the reduced array
     */
    threshold: function threshold(arr, _threshold, scoreFunc) {
        var i,
            queue = [];
        for (i = 0; i < arr.length; i++) {
            if (scoreFunc.apply(arr, [arr[i]]) >= _threshold) {
                queue.push(arr[i]);
            }
        }
        return queue;
    },

    maxIndex: function maxIndex(arr) {
        var i,
            max = 0;
        for (i = 0; i < arr.length; i++) {
            if (arr[i] > arr[max]) {
                max = i;
            }
        }
        return max;
    },

    max: function max(arr) {
        var i,
            max = 0;
        for (i = 0; i < arr.length; i++) {
            if (arr[i] > max) {
                max = arr[i];
            }
        }
        return max;
    },

    sum: function sum(arr) {
        var length = arr.length,
            sum = 0;

        while (length--) {
            sum += arr[length];
        }
        return sum;
    }
};

/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony default export */ exports["a"] = {
    drawRect: function drawRect(pos, size, ctx, style) {
        ctx.strokeStyle = style.color;
        ctx.fillStyle = style.color;
        ctx.lineWidth = 1;
        ctx.beginPath();
        ctx.strokeRect(pos.x, pos.y, size.x, size.y);
    },
    drawPath: function drawPath(path, def, ctx, style) {
        ctx.strokeStyle = style.color;
        ctx.fillStyle = style.color;
        ctx.lineWidth = style.lineWidth;
        ctx.beginPath();
        ctx.moveTo(path[0][def.x], path[0][def.y]);
        for (var j = 1; j < path.length; j++) {
            ctx.lineTo(path[j][def.x], path[j][def.y]);
        }
        ctx.closePath();
        ctx.stroke();
    },
    drawImage: function drawImage(imageData, size, ctx) {
        var canvasData = ctx.getImageData(0, 0, size.x, size.y),
            data = canvasData.data,
            imageDataPos = imageData.length,
            canvasDataPos = data.length,
            value;

        if (canvasDataPos / imageDataPos !== 4) {
            return false;
        }
        while (imageDataPos--) {
            value = imageData[imageDataPos];
            data[--canvasDataPos] = 255;
            data[--canvasDataPos] = value;
            data[--canvasDataPos] = value;
            data[--canvasDataPos] = value;
        }
        ctx.putImageData(canvasData, 0, 0);
        return true;
    }
};

/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

var listCacheClear = __webpack_require__(168),
    listCacheDelete = __webpack_require__(169),
    listCacheGet = __webpack_require__(170),
    listCacheHas = __webpack_require__(171),
    listCacheSet = __webpack_require__(172);

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

module.exports = ListCache;


/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

var eq = __webpack_require__(21);

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

module.exports = assocIndexOf;


/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

var isKeyable = __webpack_require__(166);

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

module.exports = getMapData;


/***/ },
/* 18 */
/***/ function(module, exports) {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  length = length == null ? MAX_SAFE_INTEGER : length;
  return !!length &&
    (typeof value == 'number' || reIsUint.test(value)) &&
    (value > -1 && value % 1 == 0 && value < length);
}

module.exports = isIndex;


/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4);

/* Built-in method references that are verified to be native. */
var nativeCreate = getNative(Object, 'create');

module.exports = nativeCreate;


/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

var isSymbol = __webpack_require__(38);

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/**
 * Converts `value` to a string key if it's not a string or symbol.
 *
 * @private
 * @param {*} value The value to inspect.
 * @returns {string|symbol} Returns the key.
 */
function toKey(value) {
  if (typeof value == 'string' || isSymbol(value)) {
    return value;
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

module.exports = toKey;


/***/ },
/* 21 */
/***/ function(module, exports) {

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

module.exports = eq;


/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

var baseIsArguments = __webpack_require__(123),
    isObjectLike = __webpack_require__(9);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

module.exports = isArguments;


/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

var isFunction = __webpack_require__(36),
    isLength = __webpack_require__(37);

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

module.exports = isArrayLike;


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

var arrayLikeKeys = __webpack_require__(47),
    baseKeysIn = __webpack_require__(127),
    isArrayLike = __webpack_require__(23);

/**
 * Creates an array of the own and inherited enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keysIn(new Foo);
 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
 */
function keysIn(object) {
  return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
}

module.exports = keysIn;


/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__cluster__ = __webpack_require__(73);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__array_helper__ = __webpack_require__(13);
/* harmony export (immutable) */ exports["b"] = imageRef;
/* unused harmony export computeIntegralImage2 */
/* unused harmony export computeIntegralImage */
/* unused harmony export thresholdImage */
/* unused harmony export computeHistogram */
/* unused harmony export sharpenLine */
/* unused harmony export determineOtsuThreshold */
/* harmony export (immutable) */ exports["f"] = otsuThreshold;
/* unused harmony export computeBinaryImage */
/* harmony export (immutable) */ exports["g"] = cluster;
/* unused harmony export Tracer */
/* unused harmony export DILATE */
/* unused harmony export ERODE */
/* unused harmony export dilate */
/* unused harmony export erode */
/* unused harmony export subtract */
/* unused harmony export bitwiseOr */
/* unused harmony export countNonZero */
/* harmony export (immutable) */ exports["h"] = topGeneric;
/* unused harmony export grayArrayFromImage */
/* unused harmony export grayArrayFromContext */
/* harmony export (immutable) */ exports["c"] = grayAndHalfSampleFromCanvasData;
/* harmony export (immutable) */ exports["d"] = computeGray;
/* unused harmony export loadImageArray */
/* harmony export (immutable) */ exports["i"] = halfSample;
/* harmony export (immutable) */ exports["a"] = hsv2rgb;
/* unused harmony export _computeDivisors */
/* harmony export (immutable) */ exports["e"] = calculatePatchSize;
/* unused harmony export _parseCSSDimensionValues */
/* unused harmony export _dimensionsConverters */
/* harmony export (immutable) */ exports["j"] = computeImageArea;


var vec2 = {
    clone: __webpack_require__(11)
};
var vec3 = {
    clone: __webpack_require__(104)
};

/**
 * @param x x-coordinate
 * @param y y-coordinate
 * @return ImageReference {x,y} Coordinate
 */
function imageRef(x, y) {
    var that = {
        x: x,
        y: y,
        toVec2: function toVec2() {
            return vec2.clone([this.x, this.y]);
        },
        toVec3: function toVec3() {
            return vec3.clone([this.x, this.y, 1]);
        },
        round: function round() {
            this.x = this.x > 0.0 ? Math.floor(this.x + 0.5) : Math.floor(this.x - 0.5);
            this.y = this.y > 0.0 ? Math.floor(this.y + 0.5) : Math.floor(this.y - 0.5);
            return this;
        }
    };
    return that;
};

/**
 * Computes an integral image of a given grayscale image.
 * @param imageDataContainer {ImageDataContainer} the image to be integrated
 */
function computeIntegralImage2(imageWrapper, integralWrapper) {
    var imageData = imageWrapper.data;
    var width = imageWrapper.size.x;
    var height = imageWrapper.size.y;
    var integralImageData = integralWrapper.data;
    var sum = 0,
        posA = 0,
        posB = 0,
        posC = 0,
        posD = 0,
        x,
        y;

    // sum up first column
    posB = width;
    sum = 0;
    for (y = 1; y < height; y++) {
        sum += imageData[posA];
        integralImageData[posB] += sum;
        posA += width;
        posB += width;
    }

    posA = 0;
    posB = 1;
    sum = 0;
    for (x = 1; x < width; x++) {
        sum += imageData[posA];
        integralImageData[posB] += sum;
        posA++;
        posB++;
    }

    for (y = 1; y < height; y++) {
        posA = y * width + 1;
        posB = (y - 1) * width + 1;
        posC = y * width;
        posD = (y - 1) * width;
        for (x = 1; x < width; x++) {
            integralImageData[posA] += imageData[posA] + integralImageData[posB] + integralImageData[posC] - integralImageData[posD];
            posA++;
            posB++;
            posC++;
            posD++;
        }
    }
};

function computeIntegralImage(imageWrapper, integralWrapper) {
    var imageData = imageWrapper.data;
    var width = imageWrapper.size.x;
    var height = imageWrapper.size.y;
    var integralImageData = integralWrapper.data;
    var sum = 0;

    // sum up first row
    for (var i = 0; i < width; i++) {
        sum += imageData[i];
        integralImageData[i] = sum;
    }

    for (var v = 1; v < height; v++) {
        sum = 0;
        for (var u = 0; u < width; u++) {
            sum += imageData[v * width + u];
            integralImageData[v * width + u] = sum + integralImageData[(v - 1) * width + u];
        }
    }
};

function thresholdImage(imageWrapper, threshold, targetWrapper) {
    if (!targetWrapper) {
        targetWrapper = imageWrapper;
    }
    var imageData = imageWrapper.data,
        length = imageData.length,
        targetData = targetWrapper.data;

    while (length--) {
        targetData[length] = imageData[length] < threshold ? 1 : 0;
    }
};

function computeHistogram(imageWrapper, bitsPerPixel) {
    if (!bitsPerPixel) {
        bitsPerPixel = 8;
    }
    var imageData = imageWrapper.data,
        length = imageData.length,
        bitShift = 8 - bitsPerPixel,
        bucketCnt = 1 << bitsPerPixel,
        hist = new Int32Array(bucketCnt);

    while (length--) {
        hist[imageData[length] >> bitShift]++;
    }
    return hist;
};

function sharpenLine(line) {
    var i,
        length = line.length,
        left = line[0],
        center = line[1],
        right;

    for (i = 1; i < length - 1; i++) {
        right = line[i + 1];
        //  -1 4 -1 kernel
        line[i - 1] = center * 2 - left - right & 255;
        left = center;
        center = right;
    }
    return line;
};

function determineOtsuThreshold(imageWrapper, bitsPerPixel) {
    if (!bitsPerPixel) {
        bitsPerPixel = 8;
    }
    var hist,
        threshold,
        bitShift = 8 - bitsPerPixel;

    function px(init, end) {
        var sum = 0,
            i;
        for (i = init; i <= end; i++) {
            sum += hist[i];
        }
        return sum;
    }

    function mx(init, end) {
        var i,
            sum = 0;

        for (i = init; i <= end; i++) {
            sum += i * hist[i];
        }

        return sum;
    }

    function determineThreshold() {
        var vet = [0],
            p1,
            p2,
            p12,
            k,
            m1,
            m2,
            m12,
            max = (1 << bitsPerPixel) - 1;

        hist = computeHistogram(imageWrapper, bitsPerPixel);
        for (k = 1; k < max; k++) {
            p1 = px(0, k);
            p2 = px(k + 1, max);
            p12 = p1 * p2;
            if (p12 === 0) {
                p12 = 1;
            }
            m1 = mx(0, k) * p2;
            m2 = mx(k + 1, max) * p1;
            m12 = m1 - m2;
            vet[k] = m12 * m12 / p12;
        }
        return __WEBPACK_IMPORTED_MODULE_1__array_helper__["a" /* default */].maxIndex(vet);
    }

    threshold = determineThreshold();
    return threshold << bitShift;
};

function otsuThreshold(imageWrapper, targetWrapper) {
    var threshold = determineOtsuThreshold(imageWrapper);

    thresholdImage(imageWrapper, threshold, targetWrapper);
    return threshold;
};

// local thresholding
function computeBinaryImage(imageWrapper, integralWrapper, targetWrapper) {
    computeIntegralImage(imageWrapper, integralWrapper);

    if (!targetWrapper) {
        targetWrapper = imageWrapper;
    }
    var imageData = imageWrapper.data;
    var targetData = targetWrapper.data;
    var width = imageWrapper.size.x;
    var height = imageWrapper.size.y;
    var integralImageData = integralWrapper.data;
    var sum = 0,
        v,
        u,
        kernel = 3,
        A,
        B,
        C,
        D,
        avg,
        size = (kernel * 2 + 1) * (kernel * 2 + 1);

    // clear out top & bottom-border
    for (v = 0; v <= kernel; v++) {
        for (u = 0; u < width; u++) {
            targetData[v * width + u] = 0;
            targetData[(height - 1 - v) * width + u] = 0;
        }
    }

    // clear out left & right border
    for (v = kernel; v < height - kernel; v++) {
        for (u = 0; u <= kernel; u++) {
            targetData[v * width + u] = 0;
            targetData[v * width + (width - 1 - u)] = 0;
        }
    }

    for (v = kernel + 1; v < height - kernel - 1; v++) {
        for (u = kernel + 1; u < width - kernel; u++) {
            A = integralImageData[(v - kernel - 1) * width + (u - kernel - 1)];
            B = integralImageData[(v - kernel - 1) * width + (u + kernel)];
            C = integralImageData[(v + kernel) * width + (u - kernel - 1)];
            D = integralImageData[(v + kernel) * width + (u + kernel)];
            sum = D - C - B + A;
            avg = sum / size;
            targetData[v * width + u] = imageData[v * width + u] > avg + 5 ? 0 : 1;
        }
    }
};

function cluster(points, threshold, property) {
    var i,
        k,
        cluster,
        point,
        clusters = [];

    if (!property) {
        property = "rad";
    }

    function addToCluster(newPoint) {
        var found = false;
        for (k = 0; k < clusters.length; k++) {
            cluster = clusters[k];
            if (cluster.fits(newPoint)) {
                cluster.add(newPoint);
                found = true;
            }
        }
        return found;
    }

    // iterate over each cloud
    for (i = 0; i < points.length; i++) {
        point = __WEBPACK_IMPORTED_MODULE_0__cluster__["a" /* default */].createPoint(points[i], i, property);
        if (!addToCluster(point)) {
            clusters.push(__WEBPACK_IMPORTED_MODULE_0__cluster__["a" /* default */].create(point, threshold));
        }
    }
    return clusters;
};

var Tracer = {
    trace: function trace(points, vec) {
        var iteration,
            maxIterations = 10,
            top = [],
            result = [],
            centerPos = 0,
            currentPos = 0;

        function trace(idx, forward) {
            var from,
                to,
                toIdx,
                predictedPos,
                thresholdX = 1,
                thresholdY = Math.abs(vec[1] / 10),
                found = false;

            function match(pos, predicted) {
                if (pos.x > predicted.x - thresholdX && pos.x < predicted.x + thresholdX && pos.y > predicted.y - thresholdY && pos.y < predicted.y + thresholdY) {
                    return true;
                } else {
                    return false;
                }
            }

            // check if the next index is within the vec specifications
            // if not, check as long as the threshold is met

            from = points[idx];
            if (forward) {
                predictedPos = {
                    x: from.x + vec[0],
                    y: from.y + vec[1]
                };
            } else {
                predictedPos = {
                    x: from.x - vec[0],
                    y: from.y - vec[1]
                };
            }

            toIdx = forward ? idx + 1 : idx - 1;
            to = points[toIdx];
            while (to && (found = match(to, predictedPos)) !== true && Math.abs(to.y - from.y) < vec[1]) {
                toIdx = forward ? toIdx + 1 : toIdx - 1;
                to = points[toIdx];
            }

            return found ? toIdx : null;
        }

        for (iteration = 0; iteration < maxIterations; iteration++) {
            // randomly select point to start with
            centerPos = Math.floor(Math.random() * points.length);

            // trace forward
            top = [];
            currentPos = centerPos;
            top.push(points[currentPos]);
            while ((currentPos = trace(currentPos, true)) !== null) {
                top.push(points[currentPos]);
            }
            if (centerPos > 0) {
                currentPos = centerPos;
                while ((currentPos = trace(currentPos, false)) !== null) {
                    top.push(points[currentPos]);
                }
            }

            if (top.length > result.length) {
                result = top;
            }
        }
        return result;
    }
};

var DILATE = 1;
var ERODE = 2;

function dilate(inImageWrapper, outImageWrapper) {
    var v,
        u,
        inImageData = inImageWrapper.data,
        outImageData = outImageWrapper.data,
        height = inImageWrapper.size.y,
        width = inImageWrapper.size.x,
        sum,
        yStart1,
        yStart2,
        xStart1,
        xStart2;

    for (v = 1; v < height - 1; v++) {
        for (u = 1; u < width - 1; u++) {
            yStart1 = v - 1;
            yStart2 = v + 1;
            xStart1 = u - 1;
            xStart2 = u + 1;
            sum = inImageData[yStart1 * width + xStart1] + inImageData[yStart1 * width + xStart2] + inImageData[v * width + u] + inImageData[yStart2 * width + xStart1] + inImageData[yStart2 * width + xStart2];
            outImageData[v * width + u] = sum > 0 ? 1 : 0;
        }
    }
};

function erode(inImageWrapper, outImageWrapper) {
    var v,
        u,
        inImageData = inImageWrapper.data,
        outImageData = outImageWrapper.data,
        height = inImageWrapper.size.y,
        width = inImageWrapper.size.x,
        sum,
        yStart1,
        yStart2,
        xStart1,
        xStart2;

    for (v = 1; v < height - 1; v++) {
        for (u = 1; u < width - 1; u++) {
            yStart1 = v - 1;
            yStart2 = v + 1;
            xStart1 = u - 1;
            xStart2 = u + 1;
            sum = inImageData[yStart1 * width + xStart1] + inImageData[yStart1 * width + xStart2] + inImageData[v * width + u] + inImageData[yStart2 * width + xStart1] + inImageData[yStart2 * width + xStart2];
            outImageData[v * width + u] = sum === 5 ? 1 : 0;
        }
    }
};

function subtract(aImageWrapper, bImageWrapper, resultImageWrapper) {
    if (!resultImageWrapper) {
        resultImageWrapper = aImageWrapper;
    }
    var length = aImageWrapper.data.length,
        aImageData = aImageWrapper.data,
        bImageData = bImageWrapper.data,
        cImageData = resultImageWrapper.data;

    while (length--) {
        cImageData[length] = aImageData[length] - bImageData[length];
    }
};

function bitwiseOr(aImageWrapper, bImageWrapper, resultImageWrapper) {
    if (!resultImageWrapper) {
        resultImageWrapper = aImageWrapper;
    }
    var length = aImageWrapper.data.length,
        aImageData = aImageWrapper.data,
        bImageData = bImageWrapper.data,
        cImageData = resultImageWrapper.data;

    while (length--) {
        cImageData[length] = aImageData[length] || bImageData[length];
    }
};

function countNonZero(imageWrapper) {
    var length = imageWrapper.data.length,
        data = imageWrapper.data,
        sum = 0;

    while (length--) {
        sum += data[length];
    }
    return sum;
};

function topGeneric(list, top, scoreFunc) {
    var i,
        minIdx = 0,
        min = 0,
        queue = [],
        score,
        hit,
        pos;

    for (i = 0; i < top; i++) {
        queue[i] = {
            score: 0,
            item: null
        };
    }

    for (i = 0; i < list.length; i++) {
        score = scoreFunc.apply(this, [list[i]]);
        if (score > min) {
            hit = queue[minIdx];
            hit.score = score;
            hit.item = list[i];
            min = Number.MAX_VALUE;
            for (pos = 0; pos < top; pos++) {
                if (queue[pos].score < min) {
                    min = queue[pos].score;
                    minIdx = pos;
                }
            }
        }
    }

    return queue;
};

function grayArrayFromImage(htmlImage, offsetX, ctx, array) {
    ctx.drawImage(htmlImage, offsetX, 0, htmlImage.width, htmlImage.height);
    var ctxData = ctx.getImageData(offsetX, 0, htmlImage.width, htmlImage.height).data;
    computeGray(ctxData, array);
};

function grayArrayFromContext(ctx, size, offset, array) {
    var ctxData = ctx.getImageData(offset.x, offset.y, size.x, size.y).data;
    computeGray(ctxData, array);
};

function grayAndHalfSampleFromCanvasData(canvasData, size, outArray) {
    var topRowIdx = 0;
    var bottomRowIdx = size.x;
    var endIdx = Math.floor(canvasData.length / 4);
    var outWidth = size.x / 2;
    var outImgIdx = 0;
    var inWidth = size.x;
    var i;

    while (bottomRowIdx < endIdx) {
        for (i = 0; i < outWidth; i++) {
            outArray[outImgIdx] = Math.floor((0.299 * canvasData[topRowIdx * 4 + 0] + 0.587 * canvasData[topRowIdx * 4 + 1] + 0.114 * canvasData[topRowIdx * 4 + 2] + (0.299 * canvasData[(topRowIdx + 1) * 4 + 0] + 0.587 * canvasData[(topRowIdx + 1) * 4 + 1] + 0.114 * canvasData[(topRowIdx + 1) * 4 + 2]) + (0.299 * canvasData[bottomRowIdx * 4 + 0] + 0.587 * canvasData[bottomRowIdx * 4 + 1] + 0.114 * canvasData[bottomRowIdx * 4 + 2]) + (0.299 * canvasData[(bottomRowIdx + 1) * 4 + 0] + 0.587 * canvasData[(bottomRowIdx + 1) * 4 + 1] + 0.114 * canvasData[(bottomRowIdx + 1) * 4 + 2])) / 4);
            outImgIdx++;
            topRowIdx = topRowIdx + 2;
            bottomRowIdx = bottomRowIdx + 2;
        }
        topRowIdx = topRowIdx + inWidth;
        bottomRowIdx = bottomRowIdx + inWidth;
    }
};

function computeGray(imageData, outArray, config) {
    var l = imageData.length / 4 | 0,
        i,
        singleChannel = config && config.singleChannel === true;

    if (singleChannel) {
        for (i = 0; i < l; i++) {
            outArray[i] = imageData[i * 4 + 0];
        }
    } else {
        for (i = 0; i < l; i++) {
            outArray[i] = Math.floor(0.299 * imageData[i * 4 + 0] + 0.587 * imageData[i * 4 + 1] + 0.114 * imageData[i * 4 + 2]);
        }
    }
};

function loadImageArray(src, callback, canvas) {
    if (!canvas) {
        canvas = document.createElement('canvas');
    }
    var img = new Image();
    img.callback = callback;
    img.onload = function () {
        canvas.width = this.width;
        canvas.height = this.height;
        var ctx = canvas.getContext('2d');
        ctx.drawImage(this, 0, 0);
        var array = new Uint8Array(this.width * this.height);
        ctx.drawImage(this, 0, 0);
        var data = ctx.getImageData(0, 0, this.width, this.height).data;
        computeGray(data, array);
        this.callback(array, {
            x: this.width,
            y: this.height
        }, this);
    };
    img.src = src;
};

/**
 * @param inImg {ImageWrapper} input image to be sampled
 * @param outImg {ImageWrapper} to be stored in
 */
function halfSample(inImgWrapper, outImgWrapper) {
    var inImg = inImgWrapper.data;
    var inWidth = inImgWrapper.size.x;
    var outImg = outImgWrapper.data;
    var topRowIdx = 0;
    var bottomRowIdx = inWidth;
    var endIdx = inImg.length;
    var outWidth = inWidth / 2;
    var outImgIdx = 0;
    while (bottomRowIdx < endIdx) {
        for (var i = 0; i < outWidth; i++) {
            outImg[outImgIdx] = Math.floor((inImg[topRowIdx] + inImg[topRowIdx + 1] + inImg[bottomRowIdx] + inImg[bottomRowIdx + 1]) / 4);
            outImgIdx++;
            topRowIdx = topRowIdx + 2;
            bottomRowIdx = bottomRowIdx + 2;
        }
        topRowIdx = topRowIdx + inWidth;
        bottomRowIdx = bottomRowIdx + inWidth;
    }
};

function hsv2rgb(hsv, rgb) {
    var h = hsv[0],
        s = hsv[1],
        v = hsv[2],
        c = v * s,
        x = c * (1 - Math.abs(h / 60 % 2 - 1)),
        m = v - c,
        r = 0,
        g = 0,
        b = 0;

    rgb = rgb || [0, 0, 0];

    if (h < 60) {
        r = c;
        g = x;
    } else if (h < 120) {
        r = x;
        g = c;
    } else if (h < 180) {
        g = c;
        b = x;
    } else if (h < 240) {
        g = x;
        b = c;
    } else if (h < 300) {
        r = x;
        b = c;
    } else if (h < 360) {
        r = c;
        b = x;
    }
    rgb[0] = (r + m) * 255 | 0;
    rgb[1] = (g + m) * 255 | 0;
    rgb[2] = (b + m) * 255 | 0;
    return rgb;
};

function _computeDivisors(n) {
    var largeDivisors = [],
        divisors = [],
        i;

    for (i = 1; i < Math.sqrt(n) + 1; i++) {
        if (n % i === 0) {
            divisors.push(i);
            if (i !== n / i) {
                largeDivisors.unshift(Math.floor(n / i));
            }
        }
    }
    return divisors.concat(largeDivisors);
};

function _computeIntersection(arr1, arr2) {
    var i = 0,
        j = 0,
        result = [];

    while (i < arr1.length && j < arr2.length) {
        if (arr1[i] === arr2[j]) {
            result.push(arr1[i]);
            i++;
            j++;
        } else if (arr1[i] > arr2[j]) {
            j++;
        } else {
            i++;
        }
    }
    return result;
};

function calculatePatchSize(patchSize, imgSize) {
    var divisorsX = _computeDivisors(imgSize.x),
        divisorsY = _computeDivisors(imgSize.y),
        wideSide = Math.max(imgSize.x, imgSize.y),
        common = _computeIntersection(divisorsX, divisorsY),
        nrOfPatchesList = [8, 10, 15, 20, 32, 60, 80],
        nrOfPatchesMap = {
        "x-small": 5,
        "small": 4,
        "medium": 3,
        "large": 2,
        "x-large": 1
    },
        nrOfPatchesIdx = nrOfPatchesMap[patchSize] || nrOfPatchesMap.medium,
        nrOfPatches = nrOfPatchesList[nrOfPatchesIdx],
        desiredPatchSize = Math.floor(wideSide / nrOfPatches),
        optimalPatchSize;

    function findPatchSizeForDivisors(divisors) {
        var i = 0,
            found = divisors[Math.floor(divisors.length / 2)];

        while (i < divisors.length - 1 && divisors[i] < desiredPatchSize) {
            i++;
        }
        if (i > 0) {
            if (Math.abs(divisors[i] - desiredPatchSize) > Math.abs(divisors[i - 1] - desiredPatchSize)) {
                found = divisors[i - 1];
            } else {
                found = divisors[i];
            }
        }
        if (desiredPatchSize / found < nrOfPatchesList[nrOfPatchesIdx + 1] / nrOfPatchesList[nrOfPatchesIdx] && desiredPatchSize / found > nrOfPatchesList[nrOfPatchesIdx - 1] / nrOfPatchesList[nrOfPatchesIdx]) {
            return { x: found, y: found };
        }
        return null;
    }

    optimalPatchSize = findPatchSizeForDivisors(common);
    if (!optimalPatchSize) {
        optimalPatchSize = findPatchSizeForDivisors(_computeDivisors(wideSide));
        if (!optimalPatchSize) {
            optimalPatchSize = findPatchSizeForDivisors(_computeDivisors(desiredPatchSize * nrOfPatches));
        }
    }
    return optimalPatchSize;
};

function _parseCSSDimensionValues(value) {
    var dimension = {
        value: parseFloat(value),
        unit: value.indexOf("%") === value.length - 1 ? "%" : "%"
    };

    return dimension;
};

var _dimensionsConverters = {
    top: function top(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.height * (dimension.value / 100));
        }
    },
    right: function right(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.width - context.width * (dimension.value / 100));
        }
    },
    bottom: function bottom(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.height - context.height * (dimension.value / 100));
        }
    },
    left: function left(dimension, context) {
        if (dimension.unit === "%") {
            return Math.floor(context.width * (dimension.value / 100));
        }
    }
};

function computeImageArea(inputWidth, inputHeight, area) {
    var context = { width: inputWidth, height: inputHeight };

    var parsedArea = Object.keys(area).reduce(function (result, key) {
        var value = area[key],
            parsed = _parseCSSDimensionValues(value),
            calculated = _dimensionsConverters[key](parsed, context);

        result[key] = calculated;
        return result;
    }, {});

    return {
        sx: parsedArea.left,
        sy: parsedArea.top,
        sw: parsedArea.right - parsedArea.left,
        sh: parsedArea.bottom - parsedArea.top
    };
};

/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__subImage__ = __webpack_require__(76);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_cv_utils__ = __webpack_require__(25);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__common_array_helper__ = __webpack_require__(13);



var vec2 = {
    clone: __webpack_require__(11)
};

/**
 * Represents a basic image combining the data and size.
 * In addition, some methods for manipulation are contained.
 * @param size {x,y} The size of the image in pixel
 * @param data {Array} If given, a flat array containing the pixel data
 * @param ArrayType {Type} If given, the desired DataType of the Array (may be typed/non-typed)
 * @param initialize {Boolean} Indicating if the array should be initialized on creation.
 * @returns {ImageWrapper}
 */
function ImageWrapper(size, data, ArrayType, initialize) {
    if (!data) {
        if (ArrayType) {
            this.data = new ArrayType(size.x * size.y);
            if (ArrayType === Array && initialize) {
                __WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a" /* default */].init(this.data, 0);
            }
        } else {
            this.data = new Uint8Array(size.x * size.y);
            if (Uint8Array === Array && initialize) {
                __WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a" /* default */].init(this.data, 0);
            }
        }
    } else {
        this.data = data;
    }
    this.size = size;
}

/**
 * tests if a position is within the image with a given offset
 * @param imgRef {x, y} The location to test
 * @param border Number the padding value in pixel
 * @returns {Boolean} true if location inside the image's border, false otherwise
 * @see cvd/image.h
 */
ImageWrapper.prototype.inImageWithBorder = function (imgRef, border) {
    return imgRef.x >= border && imgRef.y >= border && imgRef.x < this.size.x - border && imgRef.y < this.size.y - border;
};

/**
 * Performs bilinear sampling
 * @param inImg Image to extract sample from
 * @param x the x-coordinate
 * @param y the y-coordinate
 * @returns the sampled value
 * @see cvd/vision.h
 */
ImageWrapper.sample = function (inImg, x, y) {
    var lx = Math.floor(x);
    var ly = Math.floor(y);
    var w = inImg.size.x;
    var base = ly * inImg.size.x + lx;
    var a = inImg.data[base + 0];
    var b = inImg.data[base + 1];
    var c = inImg.data[base + w];
    var d = inImg.data[base + w + 1];
    var e = a - b;
    x -= lx;
    y -= ly;

    var result = Math.floor(x * (y * (e - c + d) - e) + y * (c - a) + a);
    return result;
};

/**
 * Initializes a given array. Sets each element to zero.
 * @param array {Array} The array to initialize
 */
ImageWrapper.clearArray = function (array) {
    var l = array.length;
    while (l--) {
        array[l] = 0;
    }
};

/**
 * Creates a {SubImage} from the current image ({this}).
 * @param from {ImageRef} The position where to start the {SubImage} from. (top-left corner)
 * @param size {ImageRef} The size of the resulting image
 * @returns {SubImage} A shared part of the original image
 */
ImageWrapper.prototype.subImage = function (from, size) {
    return new __WEBPACK_IMPORTED_MODULE_0__subImage__["a" /* default */](from, size, this);
};

/**
 * Creates an {ImageWrapper) and copies the needed underlying image-data area
 * @param imageWrapper {ImageWrapper} The target {ImageWrapper} where the data should be copied
 * @param from {ImageRef} The location where to copy from (top-left location)
 */
ImageWrapper.prototype.subImageAsCopy = function (imageWrapper, from) {
    var sizeY = imageWrapper.size.y,
        sizeX = imageWrapper.size.x;
    var x, y;
    for (x = 0; x < sizeX; x++) {
        for (y = 0; y < sizeY; y++) {
            imageWrapper.data[y * sizeX + x] = this.data[(from.y + y) * this.size.x + from.x + x];
        }
    }
};

ImageWrapper.prototype.copyTo = function (imageWrapper) {
    var length = this.data.length,
        srcData = this.data,
        dstData = imageWrapper.data;

    while (length--) {
        dstData[length] = srcData[length];
    }
};

/**
 * Retrieves a given pixel position from the image
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @returns {Number} The grayscale value at the pixel-position
 */
ImageWrapper.prototype.get = function (x, y) {
    return this.data[y * this.size.x + x];
};

/**
 * Retrieves a given pixel position from the image
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @returns {Number} The grayscale value at the pixel-position
 */
ImageWrapper.prototype.getSafe = function (x, y) {
    var i;

    if (!this.indexMapping) {
        this.indexMapping = {
            x: [],
            y: []
        };
        for (i = 0; i < this.size.x; i++) {
            this.indexMapping.x[i] = i;
            this.indexMapping.x[i + this.size.x] = i;
        }
        for (i = 0; i < this.size.y; i++) {
            this.indexMapping.y[i] = i;
            this.indexMapping.y[i + this.size.y] = i;
        }
    }
    return this.data[this.indexMapping.y[y + this.size.y] * this.size.x + this.indexMapping.x[x + this.size.x]];
};

/**
 * Sets a given pixel position in the image
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @param value {Number} The grayscale value to set
 * @returns {ImageWrapper} The Image itself (for possible chaining)
 */
ImageWrapper.prototype.set = function (x, y, value) {
    this.data[y * this.size.x + x] = value;
    return this;
};

/**
 * Sets the border of the image (1 pixel) to zero
 */
ImageWrapper.prototype.zeroBorder = function () {
    var i,
        width = this.size.x,
        height = this.size.y,
        data = this.data;
    for (i = 0; i < width; i++) {
        data[i] = data[(height - 1) * width + i] = 0;
    }
    for (i = 1; i < height - 1; i++) {
        data[i * width] = data[i * width + (width - 1)] = 0;
    }
};

/**
 * Inverts a binary image in place
 */
ImageWrapper.prototype.invert = function () {
    var data = this.data,
        length = data.length;

    while (length--) {
        data[length] = data[length] ? 0 : 1;
    }
};

ImageWrapper.prototype.convolve = function (kernel) {
    var x,
        y,
        kx,
        ky,
        kSize = kernel.length / 2 | 0,
        accu = 0;
    for (y = 0; y < this.size.y; y++) {
        for (x = 0; x < this.size.x; x++) {
            accu = 0;
            for (ky = -kSize; ky <= kSize; ky++) {
                for (kx = -kSize; kx <= kSize; kx++) {
                    accu += kernel[ky + kSize][kx + kSize] * this.getSafe(x + kx, y + ky);
                }
            }
            this.data[y * this.size.x + x] = accu;
        }
    }
};

ImageWrapper.prototype.moments = function (labelcount) {
    var data = this.data,
        x,
        y,
        height = this.size.y,
        width = this.size.x,
        val,
        ysq,
        labelsum = [],
        i,
        label,
        mu11,
        mu02,
        mu20,
        x_,
        y_,
        tmp,
        result = [],
        PI = Math.PI,
        PI_4 = PI / 4;

    if (labelcount <= 0) {
        return result;
    }

    for (i = 0; i < labelcount; i++) {
        labelsum[i] = {
            m00: 0,
            m01: 0,
            m10: 0,
            m11: 0,
            m02: 0,
            m20: 0,
            theta: 0,
            rad: 0
        };
    }

    for (y = 0; y < height; y++) {
        ysq = y * y;
        for (x = 0; x < width; x++) {
            val = data[y * width + x];
            if (val > 0) {
                label = labelsum[val - 1];
                label.m00 += 1;
                label.m01 += y;
                label.m10 += x;
                label.m11 += x * y;
                label.m02 += ysq;
                label.m20 += x * x;
            }
        }
    }

    for (i = 0; i < labelcount; i++) {
        label = labelsum[i];
        if (!isNaN(label.m00) && label.m00 !== 0) {
            x_ = label.m10 / label.m00;
            y_ = label.m01 / label.m00;
            mu11 = label.m11 / label.m00 - x_ * y_;
            mu02 = label.m02 / label.m00 - y_ * y_;
            mu20 = label.m20 / label.m00 - x_ * x_;
            tmp = (mu02 - mu20) / (2 * mu11);
            tmp = 0.5 * Math.atan(tmp) + (mu11 >= 0 ? PI_4 : -PI_4) + PI;
            label.theta = (tmp * 180 / PI + 90) % 180 - 90;
            if (label.theta < 0) {
                label.theta += 180;
            }
            label.rad = tmp > PI ? tmp - PI : tmp;
            label.vec = vec2.clone([Math.cos(tmp), Math.sin(tmp)]);
            result.push(label);
        }
    }

    return result;
};

/**
 * Displays the {ImageWrapper} in a given canvas
 * @param canvas {Canvas} The canvas element to write to
 * @param scale {Number} Scale which is applied to each pixel-value
 */
ImageWrapper.prototype.show = function (canvas, scale) {
    var ctx, frame, data, current, pixel, x, y;

    if (!scale) {
        scale = 1.0;
    }
    ctx = canvas.getContext('2d');
    canvas.width = this.size.x;
    canvas.height = this.size.y;
    frame = ctx.getImageData(0, 0, canvas.width, canvas.height);
    data = frame.data;
    current = 0;
    for (y = 0; y < this.size.y; y++) {
        for (x = 0; x < this.size.x; x++) {
            pixel = y * this.size.x + x;
            current = this.get(x, y) * scale;
            data[pixel * 4 + 0] = current;
            data[pixel * 4 + 1] = current;
            data[pixel * 4 + 2] = current;
            data[pixel * 4 + 3] = 255;
        }
    }
    //frame.data = data;
    ctx.putImageData(frame, 0, 0);
};

/**
 * Displays the {SubImage} in a given canvas
 * @param canvas {Canvas} The canvas element to write to
 * @param scale {Number} Scale which is applied to each pixel-value
 */
ImageWrapper.prototype.overlay = function (canvas, scale, from) {
    if (!scale || scale < 0 || scale > 360) {
        scale = 360;
    }
    var hsv = [0, 1, 1];
    var rgb = [0, 0, 0];
    var whiteRgb = [255, 255, 255];
    var blackRgb = [0, 0, 0];
    var result = [];
    var ctx = canvas.getContext('2d');
    var frame = ctx.getImageData(from.x, from.y, this.size.x, this.size.y);
    var data = frame.data;
    var length = this.data.length;
    while (length--) {
        hsv[0] = this.data[length] * scale;
        result = hsv[0] <= 0 ? whiteRgb : hsv[0] >= 360 ? blackRgb : __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["a" /* hsv2rgb */])(hsv, rgb);
        data[length * 4 + 0] = result[0];
        data[length * 4 + 1] = result[1];
        data[length * 4 + 2] = result[2];
        data[length * 4 + 3] = 255;
    }
    ctx.putImageData(frame, from.x, from.y);
};

/* harmony default export */ exports["a"] = ImageWrapper;

/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4),
    root = __webpack_require__(1);

/* Built-in method references that are verified to be native. */
var Map = getNative(root, 'Map');

module.exports = Map;


/***/ },
/* 28 */
/***/ function(module, exports) {

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

module.exports = arrayPush;


/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

var baseAssignValue = __webpack_require__(30),
    eq = __webpack_require__(21);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

module.exports = assignValue;


/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

var defineProperty = __webpack_require__(56);

/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && defineProperty) {
    defineProperty(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}

module.exports = baseAssignValue;


/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

var Uint8Array = __webpack_require__(109);

/**
 * Creates a clone of `arrayBuffer`.
 *
 * @private
 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
 * @returns {ArrayBuffer} Returns the cloned array buffer.
 */
function cloneArrayBuffer(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new Uint8Array(result).set(new Uint8Array(arrayBuffer));
  return result;
}

module.exports = cloneArrayBuffer;


/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

var overArg = __webpack_require__(62);

/** Built-in value references. */
var getPrototype = overArg(Object.getPrototypeOf, Object);

module.exports = getPrototype;


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

var arrayFilter = __webpack_require__(115),
    stubArray = __webpack_require__(69);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};

module.exports = getSymbols;


/***/ },
/* 34 */
/***/ function(module, exports) {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  return value === proto;
}

module.exports = isPrototype;


/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var root = __webpack_require__(1),
    stubFalse = __webpack_require__(201);

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

module.exports = isBuffer;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(41)(module)))

/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(6),
    isObject = __webpack_require__(3);

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

module.exports = isFunction;


/***/ },
/* 37 */
/***/ function(module, exports) {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

module.exports = isLength;


/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(6),
    isObjectLike = __webpack_require__(9);

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && baseGetTag(value) == symbolTag);
}

module.exports = isSymbol;


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

var arrayLikeKeys = __webpack_require__(47),
    baseKeys = __webpack_require__(126),
    isArrayLike = __webpack_require__(23);

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}

module.exports = keys;


/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

var baseMerge = __webpack_require__(128),
    createAssigner = __webpack_require__(148);

/**
 * This method is like `_.assign` except that it recursively merges own and
 * inherited enumerable string keyed properties of source objects into the
 * destination object. Source properties that resolve to `undefined` are
 * skipped if a destination value exists. Array and plain object properties
 * are merged recursively. Other objects and value types are overridden by
 * assignment. Source objects are applied from left to right. Subsequent
 * sources overwrite property assignments of previous sources.
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @memberOf _
 * @since 0.5.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @returns {Object} Returns `object`.
 * @example
 *
 * var object = {
 *   'a': [{ 'b': 2 }, { 'd': 4 }]
 * };
 *
 * var other = {
 *   'a': [{ 'c': 3 }, { 'e': 5 }]
 * };
 *
 * _.merge(object, other);
 * // => { 'a': [{ 'b': 2, 'c': 3 }, { 'd': 4, 'e': 5 }] }
 */
var merge = createAssigner(function(object, source, srcIndex) {
  baseMerge(object, source, srcIndex);
});

module.exports = merge;


/***/ },
/* 41 */
/***/ function(module, exports) {

module.exports = function(module) {
	if(!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if(!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			configurable: false,
			get: function() { return module.l; }
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			configurable: false,
			get: function() { return module.i; }
		});
		module.webpackPolyfill = 1;
	}
	return module;
}


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/**
 * http://www.codeproject.com/Tips/407172/Connected-Component-Labeling-and-Vectorization
 */
var Tracer = {
    searchDirections: [[0, 1], [1, 1], [1, 0], [1, -1], [0, -1], [-1, -1], [-1, 0], [-1, 1]],
    create: function create(imageWrapper, labelWrapper) {
        var imageData = imageWrapper.data,
            labelData = labelWrapper.data,
            searchDirections = this.searchDirections,
            width = imageWrapper.size.x,
            pos;

        function _trace(current, color, label, edgelabel) {
            var i, y, x;

            for (i = 0; i < 7; i++) {
                y = current.cy + searchDirections[current.dir][0];
                x = current.cx + searchDirections[current.dir][1];
                pos = y * width + x;
                if (imageData[pos] === color && (labelData[pos] === 0 || labelData[pos] === label)) {
                    labelData[pos] = label;
                    current.cy = y;
                    current.cx = x;
                    return true;
                } else {
                    if (labelData[pos] === 0) {
                        labelData[pos] = edgelabel;
                    }
                    current.dir = (current.dir + 1) % 8;
                }
            }
            return false;
        }

        function vertex2D(x, y, dir) {
            return {
                dir: dir,
                x: x,
                y: y,
                next: null,
                prev: null
            };
        }

        function _contourTracing(sy, sx, label, color, edgelabel) {
            var Fv = null,
                Cv,
                P,
                ldir,
                current = {
                cx: sx,
                cy: sy,
                dir: 0
            };

            if (_trace(current, color, label, edgelabel)) {
                Fv = vertex2D(sx, sy, current.dir);
                Cv = Fv;
                ldir = current.dir;
                P = vertex2D(current.cx, current.cy, 0);
                P.prev = Cv;
                Cv.next = P;
                P.next = null;
                Cv = P;
                do {
                    current.dir = (current.dir + 6) % 8;
                    _trace(current, color, label, edgelabel);
                    if (ldir !== current.dir) {
                        Cv.dir = current.dir;
                        P = vertex2D(current.cx, current.cy, 0);
                        P.prev = Cv;
                        Cv.next = P;
                        P.next = null;
                        Cv = P;
                    } else {
                        Cv.dir = ldir;
                        Cv.x = current.cx;
                        Cv.y = current.cy;
                    }
                    ldir = current.dir;
                } while (current.cx !== sx || current.cy !== sy);
                Fv.prev = Cv.prev;
                Cv.prev.next = Fv;
            }
            return Fv;
        }

        return {
            trace: function trace(current, color, label, edgelabel) {
                return _trace(current, color, label, edgelabel);
            },
            contourTracing: function contourTracing(sy, sx, label, color, edgelabel) {
                return _contourTracing(sy, sx, label, color, edgelabel);
            }
        };
    }
};

/* harmony default export */ exports["a"] = Tracer;

/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__barcode_reader__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_array_helper__ = __webpack_require__(13);



function Code39Reader() {
    __WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a" /* default */].call(this);
}

var properties = {
    ALPHABETH_STRING: { value: "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%" },
    ALPHABET: { value: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 45, 46, 32, 42, 36, 47, 43, 37] },
    CHARACTER_ENCODINGS: { value: [0x034, 0x121, 0x061, 0x160, 0x031, 0x130, 0x070, 0x025, 0x124, 0x064, 0x109, 0x049, 0x148, 0x019, 0x118, 0x058, 0x00D, 0x10C, 0x04C, 0x01C, 0x103, 0x043, 0x142, 0x013, 0x112, 0x052, 0x007, 0x106, 0x046, 0x016, 0x181, 0x0C1, 0x1C0, 0x091, 0x190, 0x0D0, 0x085, 0x184, 0x0C4, 0x094, 0x0A8, 0x0A2, 0x08A, 0x02A] },
    ASTERISK: { value: 0x094 },
    FORMAT: { value: "code_39", writeable: false }
};

Code39Reader.prototype = Object.create(__WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a" /* default */].prototype, properties);
Code39Reader.prototype.constructor = Code39Reader;

Code39Reader.prototype._toCounters = function (start, counter) {
    var self = this,
        numCounters = counter.length,
        end = self._row.length,
        isWhite = !self._row[start],
        i,
        counterPos = 0;

    __WEBPACK_IMPORTED_MODULE_1__common_array_helper__["a" /* default */].init(counter, 0);

    for (i = start; i < end; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            counterPos++;
            if (counterPos === numCounters) {
                break;
            } else {
                counter[counterPos] = 1;
                isWhite = !isWhite;
            }
        }
    }

    return counter;
};

Code39Reader.prototype._decode = function () {
    var self = this,
        counters = [0, 0, 0, 0, 0, 0, 0, 0, 0],
        result = [],
        start = self._findStart(),
        decodedChar,
        lastStart,
        pattern,
        nextStart;

    if (!start) {
        return null;
    }
    nextStart = self._nextSet(self._row, start.end);

    do {
        counters = self._toCounters(nextStart, counters);
        pattern = self._toPattern(counters);
        if (pattern < 0) {
            return null;
        }
        decodedChar = self._patternToChar(pattern);
        if (decodedChar < 0) {
            return null;
        }
        result.push(decodedChar);
        lastStart = nextStart;
        nextStart += __WEBPACK_IMPORTED_MODULE_1__common_array_helper__["a" /* default */].sum(counters);
        nextStart = self._nextSet(self._row, nextStart);
    } while (decodedChar !== '*');
    result.pop();

    if (!result.length) {
        return null;
    }

    if (!self._verifyTrailingWhitespace(lastStart, nextStart, counters)) {
        return null;
    }

    return {
        code: result.join(""),
        start: start.start,
        end: nextStart,
        startInfo: start,
        decodedCodes: result
    };
};

Code39Reader.prototype._verifyTrailingWhitespace = function (lastStart, nextStart, counters) {
    var trailingWhitespaceEnd,
        patternSize = __WEBPACK_IMPORTED_MODULE_1__common_array_helper__["a" /* default */].sum(counters);

    trailingWhitespaceEnd = nextStart - lastStart - patternSize;
    if (trailingWhitespaceEnd * 3 >= patternSize) {
        return true;
    }
    return false;
};

Code39Reader.prototype._patternToChar = function (pattern) {
    var i,
        self = this;

    for (i = 0; i < self.CHARACTER_ENCODINGS.length; i++) {
        if (self.CHARACTER_ENCODINGS[i] === pattern) {
            return String.fromCharCode(self.ALPHABET[i]);
        }
    }
    return -1;
};

Code39Reader.prototype._findNextWidth = function (counters, current) {
    var i,
        minWidth = Number.MAX_VALUE;

    for (i = 0; i < counters.length; i++) {
        if (counters[i] < minWidth && counters[i] > current) {
            minWidth = counters[i];
        }
    }

    return minWidth;
};

Code39Reader.prototype._toPattern = function (counters) {
    var numCounters = counters.length,
        maxNarrowWidth = 0,
        numWideBars = numCounters,
        wideBarWidth = 0,
        self = this,
        pattern,
        i;

    while (numWideBars > 3) {
        maxNarrowWidth = self._findNextWidth(counters, maxNarrowWidth);
        numWideBars = 0;
        pattern = 0;
        for (i = 0; i < numCounters; i++) {
            if (counters[i] > maxNarrowWidth) {
                pattern |= 1 << numCounters - 1 - i;
                numWideBars++;
                wideBarWidth += counters[i];
            }
        }

        if (numWideBars === 3) {
            for (i = 0; i < numCounters && numWideBars > 0; i++) {
                if (counters[i] > maxNarrowWidth) {
                    numWideBars--;
                    if (counters[i] * 2 >= wideBarWidth) {
                        return -1;
                    }
                }
            }
            return pattern;
        }
    }
    return -1;
};

Code39Reader.prototype._findStart = function () {
    var self = this,
        offset = self._nextSet(self._row),
        patternStart = offset,
        counter = [0, 0, 0, 0, 0, 0, 0, 0, 0],
        counterPos = 0,
        isWhite = false,
        i,
        j,
        whiteSpaceMustStart;

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                // find start pattern
                if (self._toPattern(counter) === self.ASTERISK) {
                    whiteSpaceMustStart = Math.floor(Math.max(0, patternStart - (i - patternStart) / 4));
                    if (self._matchRange(whiteSpaceMustStart, patternStart, 0)) {
                        return {
                            start: patternStart,
                            end: i
                        };
                    }
                }

                patternStart += counter[0] + counter[1];
                for (j = 0; j < 7; j++) {
                    counter[j] = counter[j + 2];
                }
                counter[7] = 0;
                counter[8] = 0;
                counterPos--;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

/* harmony default export */ exports["a"] = Code39Reader;

/***/ },
/* 44 */
/***/ function(module, exports) {

module.exports = dot

/**
 * Calculates the dot product of two vec2's
 *
 * @param {vec2} a the first operand
 * @param {vec2} b the second operand
 * @returns {Number} dot product of a and b
 */
function dot(a, b) {
    return a[0] * b[0] + a[1] * b[1]
}

/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

var mapCacheClear = __webpack_require__(173),
    mapCacheDelete = __webpack_require__(174),
    mapCacheGet = __webpack_require__(175),
    mapCacheHas = __webpack_require__(176),
    mapCacheSet = __webpack_require__(177);

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

module.exports = MapCache;


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

var ListCache = __webpack_require__(15),
    stackClear = __webpack_require__(187),
    stackDelete = __webpack_require__(188),
    stackGet = __webpack_require__(189),
    stackHas = __webpack_require__(190),
    stackSet = __webpack_require__(191);

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

module.exports = Stack;


/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

var baseTimes = __webpack_require__(136),
    isArguments = __webpack_require__(22),
    isArray = __webpack_require__(2),
    isBuffer = __webpack_require__(35),
    isIndex = __webpack_require__(18),
    isTypedArray = __webpack_require__(68);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = arrayLikeKeys;


/***/ },
/* 48 */
/***/ function(module, exports) {

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

module.exports = arrayMap;


/***/ },
/* 49 */
/***/ function(module, exports) {

/**
 * A specialized version of `_.reduce` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {*} [accumulator] The initial value.
 * @param {boolean} [initAccum] Specify using the first element of `array` as
 *  the initial value.
 * @returns {*} Returns the accumulated value.
 */
function arrayReduce(array, iteratee, accumulator, initAccum) {
  var index = -1,
      length = array == null ? 0 : array.length;

  if (initAccum && length) {
    accumulator = array[++index];
  }
  while (++index < length) {
    accumulator = iteratee(accumulator, array[index], index, array);
  }
  return accumulator;
}

module.exports = arrayReduce;


/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

var baseAssignValue = __webpack_require__(30),
    eq = __webpack_require__(21);

/**
 * This function is like `assignValue` except that it doesn't assign
 * `undefined` values.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignMergeValue(object, key, value) {
  if ((value !== undefined && !eq(object[key], value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

module.exports = assignMergeValue;


/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

var castPath = __webpack_require__(7),
    toKey = __webpack_require__(20);

/**
 * The base implementation of `_.get` without support for default values.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @returns {*} Returns the resolved value.
 */
function baseGet(object, path) {
  path = castPath(path, object);

  var index = 0,
      length = path.length;

  while (object != null && index < length) {
    object = object[toKey(path[index++])];
  }
  return (index && index == length) ? object : undefined;
}

module.exports = baseGet;


/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

var arrayPush = __webpack_require__(28),
    isArray = __webpack_require__(2);

/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
}

module.exports = baseGetAllKeys;


/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var root = __webpack_require__(1);

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined,
    allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined;

/**
 * Creates a clone of  `buffer`.
 *
 * @private
 * @param {Buffer} buffer The buffer to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Buffer} Returns the cloned buffer.
 */
function cloneBuffer(buffer, isDeep) {
  if (isDeep) {
    return buffer.slice();
  }
  var length = buffer.length,
      result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

  buffer.copy(result);
  return result;
}

module.exports = cloneBuffer;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(41)(module)))

/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

var cloneArrayBuffer = __webpack_require__(31);

/**
 * Creates a clone of `typedArray`.
 *
 * @private
 * @param {Object} typedArray The typed array to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned typed array.
 */
function cloneTypedArray(typedArray, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}

module.exports = cloneTypedArray;


/***/ },
/* 55 */
/***/ function(module, exports) {

/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

module.exports = copyArray;


/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4);

var defineProperty = (function() {
  try {
    var func = getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

module.exports = defineProperty;


/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

var flatten = __webpack_require__(194),
    overRest = __webpack_require__(63),
    setToString = __webpack_require__(64);

/**
 * A specialized version of `baseRest` which flattens the rest array.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @returns {Function} Returns the new function.
 */
function flatRest(func) {
  return setToString(overRest(func, undefined, flatten), func + '');
}

module.exports = flatRest;


/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

module.exports = freeGlobal;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(70)))

/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

var baseGetAllKeys = __webpack_require__(52),
    getSymbolsIn = __webpack_require__(60),
    keysIn = __webpack_require__(24);

/**
 * Creates an array of own and inherited enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeysIn(object) {
  return baseGetAllKeys(object, keysIn, getSymbolsIn);
}

module.exports = getAllKeysIn;


/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

var arrayPush = __webpack_require__(28),
    getPrototype = __webpack_require__(32),
    getSymbols = __webpack_require__(33),
    stubArray = __webpack_require__(69);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own and inherited enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
  var result = [];
  while (object) {
    arrayPush(result, getSymbols(object));
    object = getPrototype(object);
  }
  return result;
};

module.exports = getSymbolsIn;


/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

var baseCreate = __webpack_require__(119),
    getPrototype = __webpack_require__(32),
    isPrototype = __webpack_require__(34);

/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  return (typeof object.constructor == 'function' && !isPrototype(object))
    ? baseCreate(getPrototype(object))
    : {};
}

module.exports = initCloneObject;


/***/ },
/* 62 */
/***/ function(module, exports) {

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

module.exports = overArg;


/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

var apply = __webpack_require__(113);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * A specialized version of `baseRest` which transforms the rest array.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @param {Function} transform The rest array transform.
 * @returns {Function} Returns the new function.
 */
function overRest(func, start, transform) {
  start = nativeMax(start === undefined ? (func.length - 1) : start, 0);
  return function() {
    var args = arguments,
        index = -1,
        length = nativeMax(args.length - start, 0),
        array = Array(length);

    while (++index < length) {
      array[index] = args[start + index];
    }
    index = -1;
    var otherArgs = Array(start + 1);
    while (++index < start) {
      otherArgs[index] = args[index];
    }
    otherArgs[start] = transform(array);
    return apply(func, this, otherArgs);
  };
}

module.exports = overRest;


/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

var baseSetToString = __webpack_require__(134),
    shortOut = __webpack_require__(186);

/**
 * Sets the `toString` method of `func` to return `string`.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var setToString = shortOut(baseSetToString);

module.exports = setToString;


/***/ },
/* 65 */
/***/ function(module, exports) {

/** Used for built-in method references. */
var funcProto = Function.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

module.exports = toSource;


/***/ },
/* 66 */
/***/ function(module, exports) {

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

module.exports = identity;


/***/ },
/* 67 */
/***/ function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(6),
    getPrototype = __webpack_require__(32),
    isObjectLike = __webpack_require__(9);

/** `Object#toString` result references. */
var objectTag = '[object Object]';

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to infer the `Object` constructor. */
var objectCtorString = funcToString.call(Object);

/**
 * Checks if `value` is a plain object, that is, an object created by the
 * `Object` constructor or one with a `[[Prototype]]` of `null`.
 *
 * @static
 * @memberOf _
 * @since 0.8.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * _.isPlainObject(new Foo);
 * // => false
 *
 * _.isPlainObject([1, 2, 3]);
 * // => false
 *
 * _.isPlainObject({ 'x': 0, 'y': 0 });
 * // => true
 *
 * _.isPlainObject(Object.create(null));
 * // => true
 */
function isPlainObject(value) {
  if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
    return false;
  }
  var proto = getPrototype(value);
  if (proto === null) {
    return true;
  }
  var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
  return typeof Ctor == 'function' && Ctor instanceof Ctor &&
    funcToString.call(Ctor) == objectCtorString;
}

module.exports = isPlainObject;


/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

var baseIsTypedArray = __webpack_require__(125),
    baseUnary = __webpack_require__(138),
    nodeUtil = __webpack_require__(182);

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

module.exports = isTypedArray;


/***/ },
/* 69 */
/***/ function(module, exports) {

/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

module.exports = stubArray;


/***/ },
/* 70 */
/***/ function(module, exports) {

var g;

// This works in non-strict mode
g = (function() { return this; })();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ },
/* 71 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_merge__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_typedefs__ = __webpack_require__(77);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_typedefs___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1__common_typedefs__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_webrtc_adapter__ = __webpack_require__(205);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_webrtc_adapter___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_webrtc_adapter__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__common_image_wrapper__ = __webpack_require__(26);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__locator_barcode_locator__ = __webpack_require__(87);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__decoder_barcode_decoder__ = __webpack_require__(80);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__common_events__ = __webpack_require__(74);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__input_camera_access__ = __webpack_require__(82);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__common_image_debug__ = __webpack_require__(14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__analytics_result_collector__ = __webpack_require__(72);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__config_config__ = __webpack_require__(79);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_input_stream__ = __webpack_require__(86);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_frame_grabber__ = __webpack_require__(84);


var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

 // eslint-disable-line no-unused-vars
 // eslint-disable-line no-unused-vars











var vec2 = {
    clone: __webpack_require__(11)
};

var _inputStream,
    _framegrabber,
    _stopped,
    _canvasContainer = {
    ctx: {
        image: null,
        overlay: null
    },
    dom: {
        image: null,
        overlay: null
    }
},
    _inputImageWrapper,
    _boxSize,
    _decoder,
    _workerPool = [],
    _onUIThread = true,
    _resultCollector,
    _config = {};

function initializeData(imageWrapper) {
    initBuffers(imageWrapper);
    _decoder = __WEBPACK_IMPORTED_MODULE_5__decoder_barcode_decoder__["a" /* default */].create(_config.decoder, _inputImageWrapper);
}

function initInputStream(cb) {
    var video;
    if (_config.inputStream.type === "VideoStream") {
        video = document.createElement("video");
        _inputStream = __WEBPACK_IMPORTED_MODULE_11_input_stream__["a" /* default */].createVideoStream(video);
    } else if (_config.inputStream.type === "ImageStream") {
        _inputStream = __WEBPACK_IMPORTED_MODULE_11_input_stream__["a" /* default */].createImageStream();
    } else if (_config.inputStream.type === "LiveStream") {
        var $viewport = getViewPort();
        if ($viewport) {
            video = $viewport.querySelector("video");
            if (!video) {
                video = document.createElement("video");
                $viewport.appendChild(video);
            }
        }
        _inputStream = __WEBPACK_IMPORTED_MODULE_11_input_stream__["a" /* default */].createLiveStream(video);
        __WEBPACK_IMPORTED_MODULE_7__input_camera_access__["a" /* default */].request(video, _config.inputStream.constraints).then(function () {
            _inputStream.trigger("canrecord");
        }).catch(function (err) {
            return cb(err);
        });
    }

    _inputStream.setAttribute("preload", "auto");
    _inputStream.setInputStream(_config.inputStream);
    _inputStream.addEventListener("canrecord", canRecord.bind(undefined, cb));
}

function getViewPort() {
    var target = _config.inputStream.target;
    // Check if target is already a DOM element
    if (target && target.nodeName && target.nodeType === 1) {
        return target;
    } else {
        // Use '#interactive.viewport' as a fallback selector (backwards compatibility)
        var selector = typeof target === 'string' ? target : '#interactive.viewport';
        return document.querySelector(selector);
    }
}

function canRecord(cb) {
    __WEBPACK_IMPORTED_MODULE_4__locator_barcode_locator__["a" /* default */].checkImageConstraints(_inputStream, _config.locator);
    initCanvas(_config);
    _framegrabber = __WEBPACK_IMPORTED_MODULE_12_frame_grabber__["a" /* default */].create(_inputStream, _canvasContainer.dom.image);

    adjustWorkerPool(_config.numOfWorkers, function () {
        if (_config.numOfWorkers === 0) {
            initializeData();
        }
        ready(cb);
    });
}

function ready(cb) {
    _inputStream.play();
    cb();
}

function initCanvas() {
    if (typeof document !== "undefined") {
        var $viewport = getViewPort();
        _canvasContainer.dom.image = document.querySelector("canvas.imgBuffer");
        if (!_canvasContainer.dom.image) {
            _canvasContainer.dom.image = document.createElement("canvas");
            _canvasContainer.dom.image.className = "imgBuffer";
            if ($viewport && _config.inputStream.type === "ImageStream") {
                $viewport.appendChild(_canvasContainer.dom.image);
            }
        }
        _canvasContainer.ctx.image = _canvasContainer.dom.image.getContext("2d");
        _canvasContainer.dom.image.width = _inputStream.getCanvasSize().x;
        _canvasContainer.dom.image.height = _inputStream.getCanvasSize().y;

        _canvasContainer.dom.overlay = document.querySelector("canvas.drawingBuffer");
        if (!_canvasContainer.dom.overlay) {
            _canvasContainer.dom.overlay = document.createElement("canvas");
            _canvasContainer.dom.overlay.className = "drawingBuffer";
            if ($viewport) {
                $viewport.appendChild(_canvasContainer.dom.overlay);
            }
            var clearFix = document.createElement("br");
            clearFix.setAttribute("clear", "all");
            if ($viewport) {
                $viewport.appendChild(clearFix);
            }
        }
        _canvasContainer.ctx.overlay = _canvasContainer.dom.overlay.getContext("2d");
        _canvasContainer.dom.overlay.width = _inputStream.getCanvasSize().x;
        _canvasContainer.dom.overlay.height = _inputStream.getCanvasSize().y;
    }
}

function initBuffers(imageWrapper) {
    if (imageWrapper) {
        _inputImageWrapper = imageWrapper;
    } else {
        _inputImageWrapper = new __WEBPACK_IMPORTED_MODULE_3__common_image_wrapper__["a" /* default */]({
            x: _inputStream.getWidth(),
            y: _inputStream.getHeight()
        });
    }

    if (true) {
        console.log(_inputImageWrapper.size);
    }
    _boxSize = [vec2.clone([0, 0]), vec2.clone([0, _inputImageWrapper.size.y]), vec2.clone([_inputImageWrapper.size.x, _inputImageWrapper.size.y]), vec2.clone([_inputImageWrapper.size.x, 0])];
    __WEBPACK_IMPORTED_MODULE_4__locator_barcode_locator__["a" /* default */].init(_inputImageWrapper, _config.locator);
}

function getBoundingBoxes() {
    if (_config.locate) {
        return __WEBPACK_IMPORTED_MODULE_4__locator_barcode_locator__["a" /* default */].locate();
    } else {
        return [[vec2.clone(_boxSize[0]), vec2.clone(_boxSize[1]), vec2.clone(_boxSize[2]), vec2.clone(_boxSize[3])]];
    }
}

function transformResult(result) {
    var topRight = _inputStream.getTopRight(),
        xOffset = topRight.x,
        yOffset = topRight.y,
        i;

    if (xOffset === 0 && yOffset === 0) {
        return;
    }

    if (result.barcodes) {
        for (i = 0; i < result.barcodes.length; i++) {
            transformResult(result.barcodes[i]);
        }
    }

    if (result.line && result.line.length === 2) {
        moveLine(result.line);
    }

    if (result.box) {
        moveBox(result.box);
    }

    if (result.boxes && result.boxes.length > 0) {
        for (i = 0; i < result.boxes.length; i++) {
            moveBox(result.boxes[i]);
        }
    }

    function moveBox(box) {
        var corner = box.length;

        while (corner--) {
            box[corner][0] += xOffset;
            box[corner][1] += yOffset;
        }
    }

    function moveLine(line) {
        line[0].x += xOffset;
        line[0].y += yOffset;
        line[1].x += xOffset;
        line[1].y += yOffset;
    }
}

function addResult(result, imageData) {
    if (!imageData || !_resultCollector) {
        return;
    }

    if (result.barcodes) {
        result.barcodes.filter(function (barcode) {
            return barcode.codeResult;
        }).forEach(function (barcode) {
            return addResult(barcode, imageData);
        });
    } else if (result.codeResult) {
        _resultCollector.addResult(imageData, _inputStream.getCanvasSize(), result.codeResult);
    }
}

function hasCodeResult(result) {
    return result && (result.barcodes ? result.barcodes.some(function (barcode) {
        return barcode.codeResult;
    }) : result.codeResult);
}

function publishResult(result, imageData) {
    var resultToPublish = result;

    if (result && _onUIThread) {
        transformResult(result);
        addResult(result, imageData);
        resultToPublish = result.barcodes || result;
    }

    __WEBPACK_IMPORTED_MODULE_6__common_events__["a" /* default */].publish("processed", resultToPublish);
    if (hasCodeResult(result)) {
        __WEBPACK_IMPORTED_MODULE_6__common_events__["a" /* default */].publish("detected", resultToPublish);
    }
}

function locateAndDecode() {
    var result, boxes;

    boxes = getBoundingBoxes();
    if (boxes) {
        result = _decoder.decodeFromBoundingBoxes(boxes);
        result = result || {};
        result.boxes = boxes;
        publishResult(result, _inputImageWrapper.data);
    } else {
        publishResult();
    }
}

function update() {
    var availableWorker;

    if (_onUIThread) {
        if (_workerPool.length > 0) {
            availableWorker = _workerPool.filter(function (workerThread) {
                return !workerThread.busy;
            })[0];
            if (availableWorker) {
                _framegrabber.attachData(availableWorker.imageData);
            } else {
                return; // all workers are busy
            }
        } else {
            _framegrabber.attachData(_inputImageWrapper.data);
        }
        if (_framegrabber.grab()) {
            if (availableWorker) {
                availableWorker.busy = true;
                availableWorker.worker.postMessage({
                    cmd: 'process',
                    imageData: availableWorker.imageData
                }, [availableWorker.imageData.buffer]);
            } else {
                locateAndDecode();
            }
        }
    } else {
        locateAndDecode();
    }
}

function startContinuousUpdate() {
    var next = null,
        delay = 1000 / (_config.frequency || 60);

    _stopped = false;
    (function frame(timestamp) {
        next = next || timestamp;
        if (!_stopped) {
            if (timestamp >= next) {
                next += delay;
                update();
            }
            window.requestAnimFrame(frame);
        }
    })(performance.now());
}

function _start() {
    if (_onUIThread && _config.inputStream.type === "LiveStream") {
        startContinuousUpdate();
    } else {
        update();
    }
}

function initWorker(cb) {
    var blobURL,
        workerThread = {
        worker: undefined,
        imageData: new Uint8Array(_inputStream.getWidth() * _inputStream.getHeight()),
        busy: true
    };

    blobURL = generateWorkerBlob();
    workerThread.worker = new Worker(blobURL);

    workerThread.worker.onmessage = function (e) {
        if (e.data.event === 'initialized') {
            URL.revokeObjectURL(blobURL);
            workerThread.busy = false;
            workerThread.imageData = new Uint8Array(e.data.imageData);
            if (true) {
                console.log("Worker initialized");
            }
            return cb(workerThread);
        } else if (e.data.event === 'processed') {
            workerThread.imageData = new Uint8Array(e.data.imageData);
            workerThread.busy = false;
            publishResult(e.data.result, workerThread.imageData);
        } else if (e.data.event === 'error') {
            if (true) {
                console.log("Worker error: " + e.data.message);
            }
        }
    };

    workerThread.worker.postMessage({
        cmd: 'init',
        size: { x: _inputStream.getWidth(), y: _inputStream.getHeight() },
        imageData: workerThread.imageData,
        config: configForWorker(_config)
    }, [workerThread.imageData.buffer]);
}

function configForWorker(config) {
    return _extends({}, config, {
        inputStream: _extends({}, config.inputStream, {
            target: null
        })
    });
}

function workerInterface(factory) {
    /* eslint-disable no-undef*/
    if (factory) {
        var Quagga = factory().default;
        if (!Quagga) {
            self.postMessage({ 'event': 'error', message: 'Quagga could not be created' });
            return;
        }
    }
    var imageWrapper;

    self.onmessage = function (e) {
        if (e.data.cmd === 'init') {
            var config = e.data.config;
            config.numOfWorkers = 0;
            imageWrapper = new Quagga.ImageWrapper({
                x: e.data.size.x,
                y: e.data.size.y
            }, new Uint8Array(e.data.imageData));
            Quagga.init(config, ready, imageWrapper);
            Quagga.onProcessed(onProcessed);
        } else if (e.data.cmd === 'process') {
            imageWrapper.data = new Uint8Array(e.data.imageData);
            Quagga.start();
        } else if (e.data.cmd === 'setReaders') {
            Quagga.setReaders(e.data.readers);
        }
    };

    function onProcessed(result) {
        self.postMessage({
            'event': 'processed',
            imageData: imageWrapper.data,
            result: result
        }, [imageWrapper.data.buffer]);
    }

    function ready() {
        // eslint-disable-line
        self.postMessage({ 'event': 'initialized', imageData: imageWrapper.data }, [imageWrapper.data.buffer]);
    }

    /* eslint-enable */
}

function generateWorkerBlob() {
    var blob, factorySource;

    /* jshint ignore:start */
    if (typeof __factorySource__ !== 'undefined') {
        factorySource = __factorySource__; // eslint-disable-line no-undef
    }
    /* jshint ignore:end */

    blob = new Blob(['(' + workerInterface.toString() + ')(' + factorySource + ');'], { type: 'text/javascript' });

    return window.URL.createObjectURL(blob);
}

function _setReaders(readers) {
    if (_decoder) {
        _decoder.setReaders(readers);
    } else if (_onUIThread && _workerPool.length > 0) {
        _workerPool.forEach(function (workerThread) {
            workerThread.worker.postMessage({ cmd: 'setReaders', readers: readers });
        });
    }
}

function adjustWorkerPool(capacity, cb) {
    var increaseBy = capacity - _workerPool.length;
    if (increaseBy === 0) {
        return cb && cb();
    }
    if (increaseBy < 0) {
        var workersToTerminate = _workerPool.slice(increaseBy);
        workersToTerminate.forEach(function (workerThread) {
            workerThread.worker.terminate();
            if (true) {
                console.log("Worker terminated!");
            }
        });
        _workerPool = _workerPool.slice(0, increaseBy);
        return cb && cb();
    } else {
        var workerInitialized = function workerInitialized(workerThread) {
            _workerPool.push(workerThread);
            if (_workerPool.length >= capacity) {
                cb && cb();
            }
        };

        for (var i = 0; i < increaseBy; i++) {
            initWorker(workerInitialized);
        }
    }
}

/* harmony default export */ exports["default"] = {
    init: function init(config, cb, imageWrapper) {
        _config = __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default()({}, __WEBPACK_IMPORTED_MODULE_10__config_config__["a" /* default */], config);
        if (imageWrapper) {
            _onUIThread = false;
            initializeData(imageWrapper);
            return cb();
        } else {
            initInputStream(cb);
        }
    },
    start: function start() {
        _start();
    },
    stop: function stop() {
        _stopped = true;
        adjustWorkerPool(0);
        if (_config.inputStream.type === "LiveStream") {
            __WEBPACK_IMPORTED_MODULE_7__input_camera_access__["a" /* default */].release();
            _inputStream.clearEventHandlers();
        }
    },
    pause: function pause() {
        _stopped = true;
    },
    onDetected: function onDetected(callback) {
        __WEBPACK_IMPORTED_MODULE_6__common_events__["a" /* default */].subscribe("detected", callback);
    },
    offDetected: function offDetected(callback) {
        __WEBPACK_IMPORTED_MODULE_6__common_events__["a" /* default */].unsubscribe("detected", callback);
    },
    onProcessed: function onProcessed(callback) {
        __WEBPACK_IMPORTED_MODULE_6__common_events__["a" /* default */].subscribe("processed", callback);
    },
    offProcessed: function offProcessed(callback) {
        __WEBPACK_IMPORTED_MODULE_6__common_events__["a" /* default */].unsubscribe("processed", callback);
    },
    setReaders: function setReaders(readers) {
        _setReaders(readers);
    },
    registerResultCollector: function registerResultCollector(resultCollector) {
        if (resultCollector && typeof resultCollector.addResult === 'function') {
            _resultCollector = resultCollector;
        }
    },
    canvas: _canvasContainer,
    decodeSingle: function decodeSingle(config, resultCallback) {
        var _this = this;

        config = __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default()({
            inputStream: {
                type: "ImageStream",
                sequence: false,
                size: 800,
                src: config.src
            },
            numOfWorkers: true && config.debug ? 0 : 1,
            locator: {
                halfSample: false
            }
        }, config);
        this.init(config, function () {
            __WEBPACK_IMPORTED_MODULE_6__common_events__["a" /* default */].once("processed", function (result) {
                _this.stop();
                resultCallback.call(null, result);
            }, true);
            _start();
        });
    },
    ImageWrapper: __WEBPACK_IMPORTED_MODULE_3__common_image_wrapper__["a" /* default */],
    ImageDebug: __WEBPACK_IMPORTED_MODULE_8__common_image_debug__["a" /* default */],
    ResultCollector: __WEBPACK_IMPORTED_MODULE_9__analytics_result_collector__["a" /* default */],
    CameraAccess: __WEBPACK_IMPORTED_MODULE_7__input_camera_access__["a" /* default */]
};

/***/ },
/* 72 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__common_image_debug__ = __webpack_require__(14);


function contains(codeResult, list) {
    if (list) {
        return list.some(function (item) {
            return Object.keys(item).every(function (key) {
                return item[key] === codeResult[key];
            });
        });
    }
    return false;
}

function passesFilter(codeResult, filter) {
    if (typeof filter === 'function') {
        return filter(codeResult);
    }
    return true;
}

/* harmony default export */ exports["a"] = {
    create: function create(config) {
        var canvas = document.createElement("canvas"),
            ctx = canvas.getContext("2d"),
            results = [],
            capacity = config.capacity || 20,
            capture = config.capture === true;

        function matchesConstraints(codeResult) {
            return capacity && codeResult && !contains(codeResult, config.blacklist) && passesFilter(codeResult, config.filter);
        }

        return {
            addResult: function addResult(data, imageSize, codeResult) {
                var result = {};

                if (matchesConstraints(codeResult)) {
                    capacity--;
                    result.codeResult = codeResult;
                    if (capture) {
                        canvas.width = imageSize.x;
                        canvas.height = imageSize.y;
                        __WEBPACK_IMPORTED_MODULE_0__common_image_debug__["a" /* default */].drawImage(data, imageSize, ctx);
                        result.frame = canvas.toDataURL();
                    }
                    results.push(result);
                }
            },
            getResults: function getResults() {
                return results;
            }
        };
    }
};

/***/ },
/* 73 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
var vec2 = {
    clone: __webpack_require__(11),
    dot: __webpack_require__(44)
};
/**
 * Creates a cluster for grouping similar orientations of datapoints
 */
/* harmony default export */ exports["a"] = {
    create: function create(point, threshold) {
        var points = [],
            center = {
            rad: 0,
            vec: vec2.clone([0, 0])
        },
            pointMap = {};

        function init() {
            _add(point);
            updateCenter();
        }

        function _add(pointToAdd) {
            pointMap[pointToAdd.id] = pointToAdd;
            points.push(pointToAdd);
        }

        function updateCenter() {
            var i,
                sum = 0;
            for (i = 0; i < points.length; i++) {
                sum += points[i].rad;
            }
            center.rad = sum / points.length;
            center.vec = vec2.clone([Math.cos(center.rad), Math.sin(center.rad)]);
        }

        init();

        return {
            add: function add(pointToAdd) {
                if (!pointMap[pointToAdd.id]) {
                    _add(pointToAdd);
                    updateCenter();
                }
            },
            fits: function fits(otherPoint) {
                // check cosine similarity to center-angle
                var similarity = Math.abs(vec2.dot(otherPoint.point.vec, center.vec));
                if (similarity > threshold) {
                    return true;
                }
                return false;
            },
            getPoints: function getPoints() {
                return points;
            },
            getCenter: function getCenter() {
                return center;
            }
        };
    },
    createPoint: function createPoint(newPoint, id, property) {
        return {
            rad: newPoint[property],
            point: newPoint,
            id: id
        };
    }
};

/***/ },
/* 74 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony default export */ exports["a"] = (function () {
    var events = {};

    function getEvent(eventName) {
        if (!events[eventName]) {
            events[eventName] = {
                subscribers: []
            };
        }
        return events[eventName];
    }

    function clearEvents() {
        events = {};
    }

    function publishSubscription(subscription, data) {
        if (subscription.async) {
            setTimeout(function () {
                subscription.callback(data);
            }, 4);
        } else {
            subscription.callback(data);
        }
    }

    function _subscribe(event, callback, async) {
        var subscription;

        if (typeof callback === "function") {
            subscription = {
                callback: callback,
                async: async
            };
        } else {
            subscription = callback;
            if (!subscription.callback) {
                throw "Callback was not specified on options";
            }
        }

        getEvent(event).subscribers.push(subscription);
    }

    return {
        subscribe: function subscribe(event, callback, async) {
            return _subscribe(event, callback, async);
        },
        publish: function publish(eventName, data) {
            var event = getEvent(eventName),
                subscribers = event.subscribers;

            // Publish one-time subscriptions
            subscribers.filter(function (subscriber) {
                return !!subscriber.once;
            }).forEach(function (subscriber) {
                publishSubscription(subscriber, data);
            });

            // remove them from the subscriber
            event.subscribers = subscribers.filter(function (subscriber) {
                return !subscriber.once;
            });

            // publish the rest
            event.subscribers.forEach(function (subscriber) {
                publishSubscription(subscriber, data);
            });
        },
        once: function once(event, callback, async) {
            _subscribe(event, {
                callback: callback,
                async: async,
                once: true
            });
        },
        unsubscribe: function unsubscribe(eventName, callback) {
            var event;

            if (eventName) {
                event = getEvent(eventName);
                if (event && callback) {
                    event.subscribers = event.subscribers.filter(function (subscriber) {
                        return subscriber.callback !== callback;
                    });
                } else {
                    event.subscribers = [];
                }
            } else {
                clearEvents();
            }
        }
    };
})();

/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ exports["b"] = enumerateDevices;
/* harmony export (immutable) */ exports["a"] = getUserMedia;

function enumerateDevices() {
    if (navigator.mediaDevices && typeof navigator.mediaDevices.enumerateDevices === 'function') {
        return navigator.mediaDevices.enumerateDevices();
    }
    return Promise.reject(new Error('enumerateDevices is not defined'));
};

function getUserMedia(constraints) {
    if (navigator.mediaDevices && typeof navigator.mediaDevices.getUserMedia === 'function') {
        return navigator.mediaDevices.getUserMedia(constraints);
    }
    return Promise.reject(new Error('getUserMedia is not defined'));
}

/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/**
 * Construct representing a part of another {ImageWrapper}. Shares data
 * between the parent and the child.
 * @param from {ImageRef} The position where to start the {SubImage} from. (top-left corner)
 * @param size {ImageRef} The size of the resulting image
 * @param I {ImageWrapper} The {ImageWrapper} to share from
 * @returns {SubImage} A shared part of the original image
 */
function SubImage(from, size, I) {
    if (!I) {
        I = {
            data: null,
            size: size
        };
    }
    this.data = I.data;
    this.originalSize = I.size;
    this.I = I;

    this.from = from;
    this.size = size;
}

/**
 * Displays the {SubImage} in a given canvas
 * @param canvas {Canvas} The canvas element to write to
 * @param scale {Number} Scale which is applied to each pixel-value
 */
SubImage.prototype.show = function (canvas, scale) {
    var ctx, frame, data, current, y, x, pixel;

    if (!scale) {
        scale = 1.0;
    }
    ctx = canvas.getContext('2d');
    canvas.width = this.size.x;
    canvas.height = this.size.y;
    frame = ctx.getImageData(0, 0, canvas.width, canvas.height);
    data = frame.data;
    current = 0;
    for (y = 0; y < this.size.y; y++) {
        for (x = 0; x < this.size.x; x++) {
            pixel = y * this.size.x + x;
            current = this.get(x, y) * scale;
            data[pixel * 4 + 0] = current;
            data[pixel * 4 + 1] = current;
            data[pixel * 4 + 2] = current;
            data[pixel * 4 + 3] = 255;
        }
    }
    frame.data = data;
    ctx.putImageData(frame, 0, 0);
};

/**
 * Retrieves a given pixel position from the {SubImage}
 * @param x {Number} The x-position
 * @param y {Number} The y-position
 * @returns {Number} The grayscale value at the pixel-position
 */
SubImage.prototype.get = function (x, y) {
    return this.data[(this.from.y + y) * this.originalSize.x + this.from.x + x];
};

/**
 * Updates the underlying data from a given {ImageWrapper}
 * @param image {ImageWrapper} The updated image
 */
SubImage.prototype.updateData = function (image) {
    this.originalSize = image.size;
    this.data = image.data;
};

/**
 * Updates the position of the shared area
 * @param from {x,y} The new location
 * @returns {SubImage} returns {this} for possible chaining
 */
SubImage.prototype.updateFrom = function (from) {
    this.from = from;
    return this;
};

/* harmony default export */ exports["a"] = SubImage;

/***/ },
/* 77 */
/***/ function(module, exports) {

/*
 * typedefs.js
 * Normalizes browser-specific prefixes
 */

if (typeof window !== 'undefined') {
    window.requestAnimFrame = function () {
        return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function ( /* function FrameRequestCallback */callback) {
            window.setTimeout(callback, 1000 / 60);
        };
    }();
}
Math.imul = Math.imul || function (a, b) {
    var ah = a >>> 16 & 0xffff,
        al = a & 0xffff,
        bh = b >>> 16 & 0xffff,
        bl = b & 0xffff;
    // the shift by 0 fixes the sign on the high part
    // the final |0 converts the unsigned value into a signed value
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
};

if (typeof Object.assign !== 'function') {
    Object.assign = function (target) {
        // .length of function is 2
        'use strict';

        if (target === null) {
            // TypeError if undefined or null
            throw new TypeError('Cannot convert undefined or null to object');
        }

        var to = Object(target);

        for (var index = 1; index < arguments.length; index++) {
            var nextSource = arguments[index];

            if (nextSource !== null) {
                // Skip over if undefined or null
                for (var nextKey in nextSource) {
                    // Avoid bugs when hasOwnProperty is shadowed
                    if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
                        to[nextKey] = nextSource[nextKey];
                    }
                }
            }
        }
        return to;
    };
}

/***/ },
/* 78 */
/***/ function(module, exports) {

module.exports = {
    inputStream: {
        name: "Live",
        type: "LiveStream",
        constraints: {
            width: 640,
            height: 480,
            // aspectRatio: 640/480, // optional
            facingMode: "environment" },
        area: {
            top: "0%",
            right: "0%",
            left: "0%",
            bottom: "0%"
        },
        singleChannel: false // true: only the red color-channel is read
    },
    locate: true,
    numOfWorkers: 0,
    decoder: {
        readers: ['code_128_reader'],
        debug: {
            drawBoundingBox: false,
            showFrequency: false,
            drawScanline: false,
            showPattern: false
        }
    },
    locator: {
        halfSample: true,
        patchSize: "medium", // x-small, small, medium, large, x-large
        debug: {
            showCanvas: false,
            showPatches: false,
            showFoundPatches: false,
            showSkeleton: false,
            showLabels: false,
            showPatchLabels: false,
            showRemainingPatchLabels: false,
            boxFromPatches: {
                showTransformed: false,
                showTransformedBox: false,
                showBB: false
            }
        }
    }
};

/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
var config = void 0;

if (true) {
    config = __webpack_require__(78);
} else if (ENV.node) {
    config = require('./config.node.js');
} else {
    config = require('./config.prod.js');
}

/* harmony default export */ exports["a"] = config;

/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__bresenham__ = __webpack_require__(81);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_image_debug__ = __webpack_require__(14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__reader_code_128_reader__ = __webpack_require__(91);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__reader_ean_reader__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__reader_code_39_reader__ = __webpack_require__(43);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__reader_code_39_vin_reader__ = __webpack_require__(92);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__reader_codabar_reader__ = __webpack_require__(90);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__reader_upc_reader__ = __webpack_require__(98);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__reader_ean_8_reader__ = __webpack_require__(95);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__reader_ean_2_reader__ = __webpack_require__(93);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__reader_ean_5_reader__ = __webpack_require__(94);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__reader_upc_e_reader__ = __webpack_require__(97);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__reader_i2of5_reader__ = __webpack_require__(96);
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };















var READERS = {
    code_128_reader: __WEBPACK_IMPORTED_MODULE_2__reader_code_128_reader__["a" /* default */],
    ean_reader: __WEBPACK_IMPORTED_MODULE_3__reader_ean_reader__["a" /* default */],
    ean_5_reader: __WEBPACK_IMPORTED_MODULE_10__reader_ean_5_reader__["a" /* default */],
    ean_2_reader: __WEBPACK_IMPORTED_MODULE_9__reader_ean_2_reader__["a" /* default */],
    ean_8_reader: __WEBPACK_IMPORTED_MODULE_8__reader_ean_8_reader__["a" /* default */],
    code_39_reader: __WEBPACK_IMPORTED_MODULE_4__reader_code_39_reader__["a" /* default */],
    code_39_vin_reader: __WEBPACK_IMPORTED_MODULE_5__reader_code_39_vin_reader__["a" /* default */],
    codabar_reader: __WEBPACK_IMPORTED_MODULE_6__reader_codabar_reader__["a" /* default */],
    upc_reader: __WEBPACK_IMPORTED_MODULE_7__reader_upc_reader__["a" /* default */],
    upc_e_reader: __WEBPACK_IMPORTED_MODULE_11__reader_upc_e_reader__["a" /* default */],
    i2of5_reader: __WEBPACK_IMPORTED_MODULE_12__reader_i2of5_reader__["a" /* default */]
};
/* harmony default export */ exports["a"] = {
    create: function create(config, inputImageWrapper) {
        var _canvas = {
            ctx: {
                frequency: null,
                pattern: null,
                overlay: null
            },
            dom: {
                frequency: null,
                pattern: null,
                overlay: null
            }
        },
            _barcodeReaders = [];

        initCanvas();
        initReaders();
        initConfig();

        function initCanvas() {
            if (true && typeof document !== 'undefined') {
                var $debug = document.querySelector("#debug.detection");
                _canvas.dom.frequency = document.querySelector("canvas.frequency");
                if (!_canvas.dom.frequency) {
                    _canvas.dom.frequency = document.createElement("canvas");
                    _canvas.dom.frequency.className = "frequency";
                    if ($debug) {
                        $debug.appendChild(_canvas.dom.frequency);
                    }
                }
                _canvas.ctx.frequency = _canvas.dom.frequency.getContext("2d");

                _canvas.dom.pattern = document.querySelector("canvas.patternBuffer");
                if (!_canvas.dom.pattern) {
                    _canvas.dom.pattern = document.createElement("canvas");
                    _canvas.dom.pattern.className = "patternBuffer";
                    if ($debug) {
                        $debug.appendChild(_canvas.dom.pattern);
                    }
                }
                _canvas.ctx.pattern = _canvas.dom.pattern.getContext("2d");

                _canvas.dom.overlay = document.querySelector("canvas.drawingBuffer");
                if (_canvas.dom.overlay) {
                    _canvas.ctx.overlay = _canvas.dom.overlay.getContext("2d");
                }
            }
        }

        function initReaders() {
            config.readers.forEach(function (readerConfig) {
                var reader,
                    configuration = {},
                    supplements = [];

                if ((typeof readerConfig === 'undefined' ? 'undefined' : _typeof(readerConfig)) === 'object') {
                    reader = readerConfig.format;
                    configuration = readerConfig.config;
                } else if (typeof readerConfig === 'string') {
                    reader = readerConfig;
                }
                if (true) {
                    console.log("Before registering reader: ", reader);
                }
                if (configuration.supplements) {
                    supplements = configuration.supplements.map(function (supplement) {
                        return new READERS[supplement]();
                    });
                }
                _barcodeReaders.push(new READERS[reader](configuration, supplements));
            });
            if (true) {
                console.log("Registered Readers: " + _barcodeReaders.map(function (reader) {
                    return JSON.stringify({ format: reader.FORMAT, config: reader.config });
                }).join(', '));
            }
        }

        function initConfig() {
            if (true && typeof document !== 'undefined') {
                var i,
                    vis = [{
                    node: _canvas.dom.frequency,
                    prop: config.debug.showFrequency
                }, {
                    node: _canvas.dom.pattern,
                    prop: config.debug.showPattern
                }];

                for (i = 0; i < vis.length; i++) {
                    if (vis[i].prop === true) {
                        vis[i].node.style.display = "block";
                    } else {
                        vis[i].node.style.display = "none";
                    }
                }
            }
        }

        /**
         * extend the line on both ends
         * @param {Array} line
         * @param {Number} angle
         */
        function getExtendedLine(line, angle, ext) {
            function extendLine(amount) {
                var extension = {
                    y: amount * Math.sin(angle),
                    x: amount * Math.cos(angle)
                };

                line[0].y -= extension.y;
                line[0].x -= extension.x;
                line[1].y += extension.y;
                line[1].x += extension.x;
            }

            // check if inside image
            extendLine(ext);
            while (ext > 1 && (!inputImageWrapper.inImageWithBorder(line[0], 0) || !inputImageWrapper.inImageWithBorder(line[1], 0))) {
                ext -= Math.ceil(ext / 2);
                extendLine(-ext);
            }
            return line;
        }

        function getLine(box) {
            return [{
                x: (box[1][0] - box[0][0]) / 2 + box[0][0],
                y: (box[1][1] - box[0][1]) / 2 + box[0][1]
            }, {
                x: (box[3][0] - box[2][0]) / 2 + box[2][0],
                y: (box[3][1] - box[2][1]) / 2 + box[2][1]
            }];
        }

        function tryDecode(line) {
            var result = null,
                i,
                barcodeLine = __WEBPACK_IMPORTED_MODULE_0__bresenham__["a" /* default */].getBarcodeLine(inputImageWrapper, line[0], line[1]);

            if (true && config.debug.showFrequency) {
                __WEBPACK_IMPORTED_MODULE_1__common_image_debug__["a" /* default */].drawPath(line, { x: 'x', y: 'y' }, _canvas.ctx.overlay, { color: 'red', lineWidth: 3 });
                __WEBPACK_IMPORTED_MODULE_0__bresenham__["a" /* default */].debug.printFrequency(barcodeLine.line, _canvas.dom.frequency);
            }

            __WEBPACK_IMPORTED_MODULE_0__bresenham__["a" /* default */].toBinaryLine(barcodeLine);

            if (true && config.debug.showPattern) {
                __WEBPACK_IMPORTED_MODULE_0__bresenham__["a" /* default */].debug.printPattern(barcodeLine.line, _canvas.dom.pattern);
            }

            for (i = 0; i < _barcodeReaders.length && result === null; i++) {
                result = _barcodeReaders[i].decodePattern(barcodeLine.line);
            }
            if (result === null) {
                return null;
            }
            return {
                codeResult: result,
                barcodeLine: barcodeLine
            };
        }

        /**
         * This method slices the given area apart and tries to detect a barcode-pattern
         * for each slice. It returns the decoded barcode, or null if nothing was found
         * @param {Array} box
         * @param {Array} line
         * @param {Number} lineAngle
         */
        function tryDecodeBruteForce(box, line, lineAngle) {
            var sideLength = Math.sqrt(Math.pow(box[1][0] - box[0][0], 2) + Math.pow(box[1][1] - box[0][1], 2)),
                i,
                slices = 16,
                result = null,
                dir,
                extension,
                xdir = Math.sin(lineAngle),
                ydir = Math.cos(lineAngle);

            for (i = 1; i < slices && result === null; i++) {
                // move line perpendicular to angle
                dir = sideLength / slices * i * (i % 2 === 0 ? -1 : 1);
                extension = {
                    y: dir * xdir,
                    x: dir * ydir
                };
                line[0].y += extension.x;
                line[0].x -= extension.y;
                line[1].y += extension.x;
                line[1].x -= extension.y;

                result = tryDecode(line);
            }
            return result;
        }

        function getLineLength(line) {
            return Math.sqrt(Math.pow(Math.abs(line[1].y - line[0].y), 2) + Math.pow(Math.abs(line[1].x - line[0].x), 2));
        }

        /**
         * With the help of the configured readers (Code128 or EAN) this function tries to detect a
         * valid barcode pattern within the given area.
         * @param {Object} box The area to search in
         * @returns {Object} the result {codeResult, line, angle, pattern, threshold}
         */
        function _decodeFromBoundingBox(box) {
            var line,
                lineAngle,
                ctx = _canvas.ctx.overlay,
                result,
                lineLength;

            if (true) {
                if (config.debug.drawBoundingBox && ctx) {
                    __WEBPACK_IMPORTED_MODULE_1__common_image_debug__["a" /* default */].drawPath(box, { x: 0, y: 1 }, ctx, { color: "blue", lineWidth: 2 });
                }
            }

            line = getLine(box);
            lineLength = getLineLength(line);
            lineAngle = Math.atan2(line[1].y - line[0].y, line[1].x - line[0].x);
            line = getExtendedLine(line, lineAngle, Math.floor(lineLength * 0.1));
            if (line === null) {
                return null;
            }

            result = tryDecode(line);
            if (result === null) {
                result = tryDecodeBruteForce(box, line, lineAngle);
            }

            if (result === null) {
                return null;
            }

            if (true && result && config.debug.drawScanline && ctx) {
                __WEBPACK_IMPORTED_MODULE_1__common_image_debug__["a" /* default */].drawPath(line, { x: 'x', y: 'y' }, ctx, { color: 'red', lineWidth: 3 });
            }

            return {
                codeResult: result.codeResult,
                line: line,
                angle: lineAngle,
                pattern: result.barcodeLine.line,
                threshold: result.barcodeLine.threshold
            };
        }

        return {
            decodeFromBoundingBox: function decodeFromBoundingBox(box) {
                return _decodeFromBoundingBox(box);
            },
            decodeFromBoundingBoxes: function decodeFromBoundingBoxes(boxes) {
                var i,
                    result,
                    barcodes = [],
                    multiple = config.multiple;

                for (i = 0; i < boxes.length; i++) {
                    var box = boxes[i];
                    result = _decodeFromBoundingBox(box) || {};
                    result.box = box;

                    if (multiple) {
                        barcodes.push(result);
                    } else if (result.codeResult) {
                        return result;
                    }
                }

                if (multiple) {
                    return {
                        barcodes: barcodes
                    };
                }
            },
            setReaders: function setReaders(readers) {
                config.readers = readers;
                _barcodeReaders.length = 0;
                initReaders();
            }
        };
    }
};

/***/ },
/* 81 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__ = __webpack_require__(26);


var Bresenham = {};

var Slope = {
    DIR: {
        UP: 1,
        DOWN: -1
    }
};
/**
 * Scans a line of the given image from point p1 to p2 and returns a result object containing
 * gray-scale values (0-255) of the underlying pixels in addition to the min
 * and max values.
 * @param {Object} imageWrapper
 * @param {Object} p1 The start point {x,y}
 * @param {Object} p2 The end point {x,y}
 * @returns {line, min, max}
 */
Bresenham.getBarcodeLine = function (imageWrapper, p1, p2) {
    var x0 = p1.x | 0,
        y0 = p1.y | 0,
        x1 = p2.x | 0,
        y1 = p2.y | 0,
        steep = Math.abs(y1 - y0) > Math.abs(x1 - x0),
        deltax,
        deltay,
        error,
        ystep,
        y,
        tmp,
        x,
        line = [],
        imageData = imageWrapper.data,
        width = imageWrapper.size.x,
        sum = 0,
        val,
        min = 255,
        max = 0;

    function read(a, b) {
        val = imageData[b * width + a];
        sum += val;
        min = val < min ? val : min;
        max = val > max ? val : max;
        line.push(val);
    }

    if (steep) {
        tmp = x0;
        x0 = y0;
        y0 = tmp;

        tmp = x1;
        x1 = y1;
        y1 = tmp;
    }
    if (x0 > x1) {
        tmp = x0;
        x0 = x1;
        x1 = tmp;

        tmp = y0;
        y0 = y1;
        y1 = tmp;
    }
    deltax = x1 - x0;
    deltay = Math.abs(y1 - y0);
    error = deltax / 2 | 0;
    y = y0;
    ystep = y0 < y1 ? 1 : -1;
    for (x = x0; x < x1; x++) {
        if (steep) {
            read(y, x);
        } else {
            read(x, y);
        }
        error = error - deltay;
        if (error < 0) {
            y = y + ystep;
            error = error + deltax;
        }
    }

    return {
        line: line,
        min: min,
        max: max
    };
};

/**
 * Converts the result from getBarcodeLine into a binary representation
 * also considering the frequency and slope of the signal for more robust results
 * @param {Object} result {line, min, max}
 */
Bresenham.toBinaryLine = function (result) {
    var min = result.min,
        max = result.max,
        line = result.line,
        slope,
        slope2,
        center = min + (max - min) / 2,
        extrema = [],
        currentDir,
        dir,
        threshold = (max - min) / 12,
        rThreshold = -threshold,
        i,
        j;

    // 1. find extrema
    currentDir = line[0] > center ? Slope.DIR.UP : Slope.DIR.DOWN;
    extrema.push({
        pos: 0,
        val: line[0]
    });
    for (i = 0; i < line.length - 2; i++) {
        slope = line[i + 1] - line[i];
        slope2 = line[i + 2] - line[i + 1];
        if (slope + slope2 < rThreshold && line[i + 1] < center * 1.5) {
            dir = Slope.DIR.DOWN;
        } else if (slope + slope2 > threshold && line[i + 1] > center * 0.5) {
            dir = Slope.DIR.UP;
        } else {
            dir = currentDir;
        }

        if (currentDir !== dir) {
            extrema.push({
                pos: i,
                val: line[i]
            });
            currentDir = dir;
        }
    }
    extrema.push({
        pos: line.length,
        val: line[line.length - 1]
    });

    for (j = extrema[0].pos; j < extrema[1].pos; j++) {
        line[j] = line[j] > center ? 0 : 1;
    }

    // iterate over extrema and convert to binary based on avg between minmax
    for (i = 1; i < extrema.length - 1; i++) {
        if (extrema[i + 1].val > extrema[i].val) {
            threshold = extrema[i].val + (extrema[i + 1].val - extrema[i].val) / 3 * 2 | 0;
        } else {
            threshold = extrema[i + 1].val + (extrema[i].val - extrema[i + 1].val) / 3 | 0;
        }

        for (j = extrema[i].pos; j < extrema[i + 1].pos; j++) {
            line[j] = line[j] > threshold ? 0 : 1;
        }
    }

    return {
        line: line,
        threshold: threshold
    };
};

/**
 * Used for development only
 */
Bresenham.debug = {
    printFrequency: function printFrequency(line, canvas) {
        var i,
            ctx = canvas.getContext("2d");
        canvas.width = line.length;
        canvas.height = 256;

        ctx.beginPath();
        ctx.strokeStyle = "blue";
        for (i = 0; i < line.length; i++) {
            ctx.moveTo(i, 255);
            ctx.lineTo(i, 255 - line[i]);
        }
        ctx.stroke();
        ctx.closePath();
    },

    printPattern: function printPattern(line, canvas) {
        var ctx = canvas.getContext("2d"),
            i;

        canvas.width = line.length;
        ctx.fillColor = "black";
        for (i = 0; i < line.length; i++) {
            if (line[i] === 1) {
                ctx.fillRect(i, 0, 1, 100);
            }
        }
    }
};

/* harmony default export */ exports["a"] = Bresenham;

/***/ },
/* 82 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_pick__ = __webpack_require__(200);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_pick___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_pick__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash_omit__ = __webpack_require__(199);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_lodash_omit___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_lodash_omit__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_mediaDevices__ = __webpack_require__(75);
/* unused harmony export pickConstraints */



var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };



var facingMatching = {
    "user": /front/i,
    "environment": /back/i
};

var streamRef;

function waitForVideo(video) {
    return new Promise(function (resolve, reject) {
        var attempts = 10;

        function checkVideo() {
            if (attempts > 0) {
                if (video.videoWidth > 0 && video.videoHeight > 0) {
                    if (true) {
                        console.log(video.videoWidth + "px x " + video.videoHeight + "px");
                    }
                    resolve();
                } else {
                    window.setTimeout(checkVideo, 500);
                }
            } else {
                reject('Unable to play video stream. Is webcam working?');
            }
            attempts--;
        }
        checkVideo();
    });
}

/**
 * Tries to attach the camera-stream to a given video-element
 * and calls the callback function when the content is ready
 * @param {Object} constraints
 * @param {Object} video
 */
function initCamera(video, constraints) {
    return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_mediaDevices__["a" /* getUserMedia */])(constraints).then(function (stream) {
        return new Promise(function (resolve) {
            streamRef = stream;
            video.setAttribute("autoplay", 'true');
            video.srcObject = stream;
            video.addEventListener('loadedmetadata', function () {
                video.play();
                resolve();
            });
        });
    }).then(waitForVideo.bind(null, video));
}

function deprecatedConstraints(videoConstraints) {
    var normalized = __WEBPACK_IMPORTED_MODULE_0_lodash_pick___default()(videoConstraints, ["width", "height", "facingMode", "aspectRatio", "deviceId"]);

    if (typeof videoConstraints.minAspectRatio !== 'undefined' && videoConstraints.minAspectRatio > 0) {
        normalized.aspectRatio = videoConstraints.minAspectRatio;
        console.log("WARNING: Constraint 'minAspectRatio' is deprecated; Use 'aspectRatio' instead");
    }
    if (typeof videoConstraints.facing !== 'undefined') {
        normalized.facingMode = videoConstraints.facing;
        console.log("WARNING: Constraint 'facing' is deprecated. Use 'facingMode' instead'");
    }
    return normalized;
}

function pickDevice(constraints) {
    var desiredFacing = constraints.video.facingMode,
        facingMatch = facingMatching[desiredFacing];

    if (!facingMatch) {
        return Promise.resolve(constraints);
    }
    return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_mediaDevices__["b" /* enumerateDevices */])().then(function (devices) {
        var selectedDeviceId = devices.filter(function (device) {
            return device.kind === 'videoinput' && facingMatch.test(device.label);
        }).map(function (facingDevice) {
            return facingDevice.deviceId;
        })[0];
        if (selectedDeviceId) {
            constraints = _extends({}, constraints, {
                video: _extends({}, __WEBPACK_IMPORTED_MODULE_1_lodash_omit___default()(constraints.video, ["facingMode"]), {
                    deviceId: selectedDeviceId
                })
            });
        }
        return Promise.resolve(constraints);
    });
}

function pickConstraints(videoConstraints) {
    var normalizedConstraints = {
        audio: false,
        video: deprecatedConstraints(videoConstraints)
    };

    if (!normalizedConstraints.video.deviceId) {
        if (typeof normalizedConstraints.video.facingMode === 'string' && normalizedConstraints.video.facingMode.length > 0) {
            return pickDevice(normalizedConstraints);
        }
    }
    return Promise.resolve(normalizedConstraints);
}

function enumerateVideoDevices() {
    return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_2_mediaDevices__["b" /* enumerateDevices */])().then(function (devices) {
        return devices.filter(function (device) {
            return device.kind === 'videoinput';
        });
    });
}

/* harmony default export */ exports["a"] = {
    request: function request(video, videoConstraints) {
        return pickConstraints(videoConstraints).then(initCamera.bind(null, video));
    },
    release: function release() {
        var tracks = streamRef && streamRef.getVideoTracks();
        if (tracks && tracks.length) {
            tracks[0].stop();
        }
        streamRef = null;
    },
    enumerateVideoDevices: enumerateVideoDevices,
    getActiveStreamLabel: function getActiveStreamLabel() {
        if (streamRef) {
            var tracks = streamRef.getVideoTracks();
            if (tracks && tracks.length) {
                return tracks[0].label;
            }
        }
    }
};

/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* unused harmony export AvailableTags */
/* harmony export (immutable) */ exports["a"] = findTagsInObjectURL;
/* unused harmony export base64ToArrayBuffer */
/* unused harmony export findTagsInBuffer */
// Scraped from https://github.com/exif-js/exif-js

var ExifTags = { 0x0112: "orientation" };
var AvailableTags = Object.keys(ExifTags).map(function (key) {
    return ExifTags[key];
});

function findTagsInObjectURL(src) {
    var tags = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : AvailableTags;

    if (/^blob\:/i.test(src)) {
        return objectURLToBlob(src).then(readToBuffer).then(function (buffer) {
            return findTagsInBuffer(buffer, tags);
        });
    }
    return Promise.resolve(null);
}

function base64ToArrayBuffer(dataUrl) {
    var base64 = dataUrl.replace(/^data\:([^\;]+)\;base64,/gmi, ''),
        binary = atob(base64),
        len = binary.length,
        buffer = new ArrayBuffer(len),
        view = new Uint8Array(buffer);

    for (var i = 0; i < len; i++) {
        view[i] = binary.charCodeAt(i);
    }
    return buffer;
}

function readToBuffer(blob) {
    return new Promise(function (resolve) {
        var fileReader = new FileReader();
        fileReader.onload = function (e) {
            return resolve(e.target.result);
        };
        fileReader.readAsArrayBuffer(blob);
    });
}

function objectURLToBlob(url) {
    return new Promise(function (resolve, reject) {
        var http = new XMLHttpRequest();
        http.open("GET", url, true);
        http.responseType = "blob";
        http.onreadystatechange = function () {
            if (http.readyState === XMLHttpRequest.DONE && (http.status === 200 || http.status === 0)) {
                resolve(this.response);
            }
        };
        http.onerror = reject;
        http.send();
    });
}

function findTagsInBuffer(file) {
    var selectedTags = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : AvailableTags;

    var dataView = new DataView(file),
        length = file.byteLength,
        exifTags = selectedTags.reduce(function (result, selectedTag) {
        var exifTag = Object.keys(ExifTags).filter(function (tag) {
            return ExifTags[tag] === selectedTag;
        })[0];
        if (exifTag) {
            result[exifTag] = selectedTag;
        }
        return result;
    }, {});
    var offset = 2,
        marker = void 0;

    if (dataView.getUint8(0) !== 0xFF || dataView.getUint8(1) !== 0xD8) {
        return false;
    }

    while (offset < length) {
        if (dataView.getUint8(offset) !== 0xFF) {
            return false;
        }

        marker = dataView.getUint8(offset + 1);
        if (marker === 0xE1) {
            return readEXIFData(dataView, offset + 4, exifTags);
        } else {
            offset += 2 + dataView.getUint16(offset + 2);
        }
    }
}

function readEXIFData(file, start, exifTags) {
    if (getStringFromBuffer(file, start, 4) !== "Exif") {
        return false;
    }

    var tiffOffset = start + 6;
    var bigEnd = void 0,
        tags = void 0;

    if (file.getUint16(tiffOffset) === 0x4949) {
        bigEnd = false;
    } else if (file.getUint16(tiffOffset) === 0x4D4D) {
        bigEnd = true;
    } else {
        return false;
    }

    if (file.getUint16(tiffOffset + 2, !bigEnd) !== 0x002A) {
        return false;
    }

    var firstIFDOffset = file.getUint32(tiffOffset + 4, !bigEnd);
    if (firstIFDOffset < 0x00000008) {
        return false;
    }

    tags = readTags(file, tiffOffset, tiffOffset + firstIFDOffset, exifTags, bigEnd);
    return tags;
}

function readTags(file, tiffStart, dirStart, strings, bigEnd) {
    var entries = file.getUint16(dirStart, !bigEnd),
        tags = {};

    for (var i = 0; i < entries; i++) {
        var entryOffset = dirStart + i * 12 + 2,
            tag = strings[file.getUint16(entryOffset, !bigEnd)];
        if (tag) {
            tags[tag] = readTagValue(file, entryOffset, tiffStart, dirStart, bigEnd);
        }
    }
    return tags;
}

function readTagValue(file, entryOffset, tiffStart, dirStart, bigEnd) {
    var type = file.getUint16(entryOffset + 2, !bigEnd),
        numValues = file.getUint32(entryOffset + 4, !bigEnd);

    switch (type) {
        case 3:
            if (numValues === 1) {
                return file.getUint16(entryOffset + 8, !bigEnd);
            }
    }
}

function getStringFromBuffer(buffer, start, length) {
    var outstr = "";
    for (var n = start; n < start + length; n++) {
        outstr += String.fromCharCode(buffer.getUint8(n));
    }
    return outstr;
}

/***/ },
/* 84 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__common_cv_utils__ = __webpack_require__(25);


var TO_RADIANS = Math.PI / 180;

function adjustCanvasSize(canvas, targetSize) {
    if (canvas.width !== targetSize.x) {
        if (true) {
            console.log("WARNING: canvas-size needs to be adjusted");
        }
        canvas.width = targetSize.x;
    }
    if (canvas.height !== targetSize.y) {
        if (true) {
            console.log("WARNING: canvas-size needs to be adjusted");
        }
        canvas.height = targetSize.y;
    }
}

var FrameGrabber = {};

FrameGrabber.create = function (inputStream, canvas) {
    var _that = {},
        _streamConfig = inputStream.getConfig(),
        _video_size = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__common_cv_utils__["b" /* imageRef */])(inputStream.getRealWidth(), inputStream.getRealHeight()),
        _canvasSize = inputStream.getCanvasSize(),
        _size = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__common_cv_utils__["b" /* imageRef */])(inputStream.getWidth(), inputStream.getHeight()),
        topRight = inputStream.getTopRight(),
        _sx = topRight.x,
        _sy = topRight.y,
        _canvas,
        _ctx = null,
        _data = null;

    _canvas = canvas ? canvas : document.createElement("canvas");
    _canvas.width = _canvasSize.x;
    _canvas.height = _canvasSize.y;
    _ctx = _canvas.getContext("2d");
    _data = new Uint8Array(_size.x * _size.y);
    if (true) {
        console.log("FrameGrabber", JSON.stringify({
            size: _size,
            topRight: topRight,
            videoSize: _video_size,
            canvasSize: _canvasSize
        }));
    }

    /**
     * Uses the given array as frame-buffer
     */
    _that.attachData = function (data) {
        _data = data;
    };

    /**
     * Returns the used frame-buffer
     */
    _that.getData = function () {
        return _data;
    };

    /**
     * Fetches a frame from the input-stream and puts into the frame-buffer.
     * The image-data is converted to gray-scale and then half-sampled if configured.
     */
    _that.grab = function () {
        var doHalfSample = _streamConfig.halfSample,
            frame = inputStream.getFrame(),
            drawable = frame,
            drawAngle = 0,
            ctxData;
        if (drawable) {
            adjustCanvasSize(_canvas, _canvasSize);
            if (_streamConfig.type === 'ImageStream') {
                drawable = frame.img;
                if (frame.tags && frame.tags.orientation) {
                    switch (frame.tags.orientation) {
                        case 6:
                            drawAngle = 90 * TO_RADIANS;
                            break;
                        case 8:
                            drawAngle = -90 * TO_RADIANS;
                            break;
                    }
                }
            }

            if (drawAngle !== 0) {
                _ctx.translate(_canvasSize.x / 2, _canvasSize.y / 2);
                _ctx.rotate(drawAngle);
                _ctx.drawImage(drawable, -_canvasSize.y / 2, -_canvasSize.x / 2, _canvasSize.y, _canvasSize.x);
                _ctx.rotate(-drawAngle);
                _ctx.translate(-_canvasSize.x / 2, -_canvasSize.y / 2);
            } else {
                _ctx.drawImage(drawable, 0, 0, _canvasSize.x, _canvasSize.y);
            }

            ctxData = _ctx.getImageData(_sx, _sy, _size.x, _size.y).data;
            if (doHalfSample) {
                __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__common_cv_utils__["c" /* grayAndHalfSampleFromCanvasData */])(ctxData, _size, _data);
            } else {
                __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__common_cv_utils__["d" /* computeGray */])(ctxData, _data, _streamConfig);
            }
            return true;
        } else {
            return false;
        }
    };

    _that.getSize = function () {
        return _size;
    };

    return _that;
};

/* harmony default export */ exports["a"] = FrameGrabber;

/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__exif_helper__ = __webpack_require__(83);


var ImageLoader = {};
ImageLoader.load = function (directory, callback, offset, size, sequence) {
    var htmlImagesSrcArray = new Array(size),
        htmlImagesArray = new Array(htmlImagesSrcArray.length),
        i,
        img,
        num;

    if (sequence === false) {
        htmlImagesSrcArray[0] = directory;
    } else {
        for (i = 0; i < htmlImagesSrcArray.length; i++) {
            num = offset + i;
            htmlImagesSrcArray[i] = directory + "image-" + ("00" + num).slice(-3) + ".jpg";
        }
    }
    htmlImagesArray.notLoaded = [];
    htmlImagesArray.addImage = function (image) {
        htmlImagesArray.notLoaded.push(image);
    };
    htmlImagesArray.loaded = function (loadedImg) {
        var notloadedImgs = htmlImagesArray.notLoaded;
        for (var x = 0; x < notloadedImgs.length; x++) {
            if (notloadedImgs[x] === loadedImg) {
                notloadedImgs.splice(x, 1);
                for (var y = 0; y < htmlImagesSrcArray.length; y++) {
                    var imgName = htmlImagesSrcArray[y].substr(htmlImagesSrcArray[y].lastIndexOf("/"));
                    if (loadedImg.src.lastIndexOf(imgName) !== -1) {
                        htmlImagesArray[y] = { img: loadedImg };
                        break;
                    }
                }
                break;
            }
        }
        if (notloadedImgs.length === 0) {
            if (true) {
                console.log("Images loaded");
            }
            if (sequence === false) {
                __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__exif_helper__["a" /* findTagsInObjectURL */])(directory, ['orientation']).then(function (tags) {
                    htmlImagesArray[0].tags = tags;
                    callback(htmlImagesArray);
                }).catch(function (e) {
                    console.log(e);
                    callback(htmlImagesArray);
                });
            } else {
                callback(htmlImagesArray);
            }
        }
    };

    for (i = 0; i < htmlImagesSrcArray.length; i++) {
        img = new Image();
        htmlImagesArray.addImage(img);
        addOnloadHandler(img, htmlImagesArray);
        img.src = htmlImagesSrcArray[i];
    }
};

function addOnloadHandler(img, htmlImagesArray) {
    img.onload = function () {
        htmlImagesArray.loaded(this);
    };
}

/* harmony default export */ exports["a"] = ImageLoader;

/***/ },
/* 86 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__image_loader__ = __webpack_require__(85);


var InputStream = {};
InputStream.createVideoStream = function (video) {
    var that = {},
        _config = null,
        _eventNames = ['canrecord', 'ended'],
        _eventHandlers = {},
        _calculatedWidth,
        _calculatedHeight,
        _topRight = { x: 0, y: 0 },
        _canvasSize = { x: 0, y: 0 };

    function initSize() {
        var width = video.videoWidth,
            height = video.videoHeight;

        _calculatedWidth = _config.size ? width / height > 1 ? _config.size : Math.floor(width / height * _config.size) : width;
        _calculatedHeight = _config.size ? width / height > 1 ? Math.floor(height / width * _config.size) : _config.size : height;

        _canvasSize.x = _calculatedWidth;
        _canvasSize.y = _calculatedHeight;
    }

    that.getRealWidth = function () {
        return video.videoWidth;
    };

    that.getRealHeight = function () {
        return video.videoHeight;
    };

    that.getWidth = function () {
        return _calculatedWidth;
    };

    that.getHeight = function () {
        return _calculatedHeight;
    };

    that.setWidth = function (width) {
        _calculatedWidth = width;
    };

    that.setHeight = function (height) {
        _calculatedHeight = height;
    };

    that.setInputStream = function (config) {
        _config = config;
        video.src = typeof config.src !== 'undefined' ? config.src : '';
    };

    that.ended = function () {
        return video.ended;
    };

    that.getConfig = function () {
        return _config;
    };

    that.setAttribute = function (name, value) {
        video.setAttribute(name, value);
    };

    that.pause = function () {
        video.pause();
    };

    that.play = function () {
        video.play();
    };

    that.setCurrentTime = function (time) {
        if (_config.type !== "LiveStream") {
            video.currentTime = time;
        }
    };

    that.addEventListener = function (event, f, bool) {
        if (_eventNames.indexOf(event) !== -1) {
            if (!_eventHandlers[event]) {
                _eventHandlers[event] = [];
            }
            _eventHandlers[event].push(f);
        } else {
            video.addEventListener(event, f, bool);
        }
    };

    that.clearEventHandlers = function () {
        _eventNames.forEach(function (eventName) {
            var handlers = _eventHandlers[eventName];
            if (handlers && handlers.length > 0) {
                handlers.forEach(function (handler) {
                    video.removeEventListener(eventName, handler);
                });
            }
        });
    };

    that.trigger = function (eventName, args) {
        var j,
            handlers = _eventHandlers[eventName];

        if (eventName === 'canrecord') {
            initSize();
        }
        if (handlers && handlers.length > 0) {
            for (j = 0; j < handlers.length; j++) {
                handlers[j].apply(that, args);
            }
        }
    };

    that.setTopRight = function (topRight) {
        _topRight.x = topRight.x;
        _topRight.y = topRight.y;
    };

    that.getTopRight = function () {
        return _topRight;
    };

    that.setCanvasSize = function (size) {
        _canvasSize.x = size.x;
        _canvasSize.y = size.y;
    };

    that.getCanvasSize = function () {
        return _canvasSize;
    };

    that.getFrame = function () {
        return video;
    };

    return that;
};

InputStream.createLiveStream = function (video) {
    video.setAttribute("autoplay", true);
    var that = InputStream.createVideoStream(video);

    that.ended = function () {
        return false;
    };

    return that;
};

InputStream.createImageStream = function () {
    var that = {};
    var _config = null;

    var width = 0,
        height = 0,
        frameIdx = 0,
        paused = true,
        loaded = false,
        imgArray = null,
        size = 0,
        offset = 1,
        baseUrl = null,
        ended = false,
        calculatedWidth,
        calculatedHeight,
        _eventNames = ['canrecord', 'ended'],
        _eventHandlers = {},
        _topRight = { x: 0, y: 0 },
        _canvasSize = { x: 0, y: 0 };

    function loadImages() {
        loaded = false;
        __WEBPACK_IMPORTED_MODULE_0__image_loader__["a" /* default */].load(baseUrl, function (imgs) {
            imgArray = imgs;
            if (imgs[0].tags && imgs[0].tags.orientation) {
                switch (imgs[0].tags.orientation) {
                    case 6:
                    case 8:
                        width = imgs[0].img.height;
                        height = imgs[0].img.width;
                        break;
                    default:
                        width = imgs[0].img.width;
                        height = imgs[0].img.height;
                }
            } else {
                width = imgs[0].img.width;
                height = imgs[0].img.height;
            }
            calculatedWidth = _config.size ? width / height > 1 ? _config.size : Math.floor(width / height * _config.size) : width;
            calculatedHeight = _config.size ? width / height > 1 ? Math.floor(height / width * _config.size) : _config.size : height;
            _canvasSize.x = calculatedWidth;
            _canvasSize.y = calculatedHeight;
            loaded = true;
            frameIdx = 0;
            setTimeout(function () {
                publishEvent("canrecord", []);
            }, 0);
        }, offset, size, _config.sequence);
    }

    function publishEvent(eventName, args) {
        var j,
            handlers = _eventHandlers[eventName];

        if (handlers && handlers.length > 0) {
            for (j = 0; j < handlers.length; j++) {
                handlers[j].apply(that, args);
            }
        }
    }

    that.trigger = publishEvent;

    that.getWidth = function () {
        return calculatedWidth;
    };

    that.getHeight = function () {
        return calculatedHeight;
    };

    that.setWidth = function (newWidth) {
        calculatedWidth = newWidth;
    };

    that.setHeight = function (newHeight) {
        calculatedHeight = newHeight;
    };

    that.getRealWidth = function () {
        return width;
    };

    that.getRealHeight = function () {
        return height;
    };

    that.setInputStream = function (stream) {
        _config = stream;
        if (stream.sequence === false) {
            baseUrl = stream.src;
            size = 1;
        } else {
            baseUrl = stream.src;
            size = stream.length;
        }
        loadImages();
    };

    that.ended = function () {
        return ended;
    };

    that.setAttribute = function () {};

    that.getConfig = function () {
        return _config;
    };

    that.pause = function () {
        paused = true;
    };

    that.play = function () {
        paused = false;
    };

    that.setCurrentTime = function (time) {
        frameIdx = time;
    };

    that.addEventListener = function (event, f) {
        if (_eventNames.indexOf(event) !== -1) {
            if (!_eventHandlers[event]) {
                _eventHandlers[event] = [];
            }
            _eventHandlers[event].push(f);
        }
    };

    that.setTopRight = function (topRight) {
        _topRight.x = topRight.x;
        _topRight.y = topRight.y;
    };

    that.getTopRight = function () {
        return _topRight;
    };

    that.setCanvasSize = function (canvasSize) {
        _canvasSize.x = canvasSize.x;
        _canvasSize.y = canvasSize.y;
    };

    that.getCanvasSize = function () {
        return _canvasSize;
    };

    that.getFrame = function () {
        var frame;

        if (!loaded) {
            return null;
        }
        if (!paused) {
            frame = imgArray[frameIdx];
            if (frameIdx < size - 1) {
                frameIdx++;
            } else {
                setTimeout(function () {
                    ended = true;
                    publishEvent("ended", []);
                }, 0);
            }
        }
        return frame;
    };

    return that;
};

/* harmony default export */ exports["a"] = InputStream;

/***/ },
/* 87 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__ = __webpack_require__(26);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_cv_utils__ = __webpack_require__(25);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__common_array_helper__ = __webpack_require__(13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__common_image_debug__ = __webpack_require__(14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__rasterizer__ = __webpack_require__(88);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__tracer__ = __webpack_require__(42);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__skeletonizer__ = __webpack_require__(89);







var vec2 = {
    clone: __webpack_require__(11),
    dot: __webpack_require__(44),
    scale: __webpack_require__(102),
    transformMat2: __webpack_require__(103)
};
var mat2 = {
    copy: __webpack_require__(99),
    create: __webpack_require__(100),
    invert: __webpack_require__(101)
};

var _config,
    _currentImageWrapper,
    _skelImageWrapper,
    _subImageWrapper,
    _labelImageWrapper,
    _patchGrid,
    _patchLabelGrid,
    _imageToPatchGrid,
    _binaryImageWrapper,
    _patchSize,
    _canvasContainer = {
    ctx: {
        binary: null
    },
    dom: {
        binary: null
    }
},
    _numPatches = { x: 0, y: 0 },
    _inputImageWrapper,
    _skeletonizer;

function initBuffers() {
    var skeletonImageData;

    if (_config.halfSample) {
        _currentImageWrapper = new __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a" /* default */]({
            x: _inputImageWrapper.size.x / 2 | 0,
            y: _inputImageWrapper.size.y / 2 | 0
        });
    } else {
        _currentImageWrapper = _inputImageWrapper;
    }

    _patchSize = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["e" /* calculatePatchSize */])(_config.patchSize, _currentImageWrapper.size);

    _numPatches.x = _currentImageWrapper.size.x / _patchSize.x | 0;
    _numPatches.y = _currentImageWrapper.size.y / _patchSize.y | 0;

    _binaryImageWrapper = new __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a" /* default */](_currentImageWrapper.size, undefined, Uint8Array, false);

    _labelImageWrapper = new __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a" /* default */](_patchSize, undefined, Array, true);

    skeletonImageData = new ArrayBuffer(64 * 1024);
    _subImageWrapper = new __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a" /* default */](_patchSize, new Uint8Array(skeletonImageData, 0, _patchSize.x * _patchSize.y));
    _skelImageWrapper = new __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a" /* default */](_patchSize, new Uint8Array(skeletonImageData, _patchSize.x * _patchSize.y * 3, _patchSize.x * _patchSize.y), undefined, true);
    _skeletonizer = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_6__skeletonizer__["a" /* default */])(typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : global, {
        size: _patchSize.x
    }, skeletonImageData);

    _imageToPatchGrid = new __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a" /* default */]({
        x: _currentImageWrapper.size.x / _subImageWrapper.size.x | 0,
        y: _currentImageWrapper.size.y / _subImageWrapper.size.y | 0
    }, undefined, Array, true);
    _patchGrid = new __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a" /* default */](_imageToPatchGrid.size, undefined, undefined, true);
    _patchLabelGrid = new __WEBPACK_IMPORTED_MODULE_0__common_image_wrapper__["a" /* default */](_imageToPatchGrid.size, undefined, Int32Array, true);
}

function initCanvas() {
    if (_config.useWorker || typeof document === 'undefined') {
        return;
    }
    _canvasContainer.dom.binary = document.createElement("canvas");
    _canvasContainer.dom.binary.className = "binaryBuffer";
    if (true && _config.debug.showCanvas === true) {
        document.querySelector("#debug").appendChild(_canvasContainer.dom.binary);
    }
    _canvasContainer.ctx.binary = _canvasContainer.dom.binary.getContext("2d");
    _canvasContainer.dom.binary.width = _binaryImageWrapper.size.x;
    _canvasContainer.dom.binary.height = _binaryImageWrapper.size.y;
}

/**
 * Creates a bounding box which encloses all the given patches
 * @returns {Array} The minimal bounding box
 */
function boxFromPatches(patches) {
    var overAvg,
        i,
        j,
        patch,
        transMat,
        minx = _binaryImageWrapper.size.x,
        miny = _binaryImageWrapper.size.y,
        maxx = -_binaryImageWrapper.size.x,
        maxy = -_binaryImageWrapper.size.y,
        box,
        scale;

    // draw all patches which are to be taken into consideration
    overAvg = 0;
    for (i = 0; i < patches.length; i++) {
        patch = patches[i];
        overAvg += patch.rad;
        if (true && _config.debug.showPatches) {
            __WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a" /* default */].drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "red" });
        }
    }

    overAvg /= patches.length;
    overAvg = (overAvg * 180 / Math.PI + 90) % 180 - 90;
    if (overAvg < 0) {
        overAvg += 180;
    }

    overAvg = (180 - overAvg) * Math.PI / 180;
    transMat = mat2.copy(mat2.create(), [Math.cos(overAvg), Math.sin(overAvg), -Math.sin(overAvg), Math.cos(overAvg)]);

    // iterate over patches and rotate by angle
    for (i = 0; i < patches.length; i++) {
        patch = patches[i];
        for (j = 0; j < 4; j++) {
            vec2.transformMat2(patch.box[j], patch.box[j], transMat);
        }

        if (true && _config.debug.boxFromPatches.showTransformed) {
            __WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a" /* default */].drawPath(patch.box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#99ff00', lineWidth: 2 });
        }
    }

    // find bounding box
    for (i = 0; i < patches.length; i++) {
        patch = patches[i];
        for (j = 0; j < 4; j++) {
            if (patch.box[j][0] < minx) {
                minx = patch.box[j][0];
            }
            if (patch.box[j][0] > maxx) {
                maxx = patch.box[j][0];
            }
            if (patch.box[j][1] < miny) {
                miny = patch.box[j][1];
            }
            if (patch.box[j][1] > maxy) {
                maxy = patch.box[j][1];
            }
        }
    }

    box = [[minx, miny], [maxx, miny], [maxx, maxy], [minx, maxy]];

    if (true && _config.debug.boxFromPatches.showTransformedBox) {
        __WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a" /* default */].drawPath(box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#ff0000', lineWidth: 2 });
    }

    scale = _config.halfSample ? 2 : 1;
    // reverse rotation;
    transMat = mat2.invert(transMat, transMat);
    for (j = 0; j < 4; j++) {
        vec2.transformMat2(box[j], box[j], transMat);
    }

    if (true && _config.debug.boxFromPatches.showBB) {
        __WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a" /* default */].drawPath(box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#ff0000', lineWidth: 2 });
    }

    for (j = 0; j < 4; j++) {
        vec2.scale(box[j], box[j], scale);
    }

    return box;
}

/**
 * Creates a binary image of the current image
 */
function binarizeImage() {
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["f" /* otsuThreshold */])(_currentImageWrapper, _binaryImageWrapper);
    _binaryImageWrapper.zeroBorder();
    if (true && _config.debug.showCanvas) {
        _binaryImageWrapper.show(_canvasContainer.dom.binary, 255);
    }
}

/**
 * Iterate over the entire image
 * extract patches
 */
function findPatches() {
    var i,
        j,
        x,
        y,
        moments,
        patchesFound = [],
        rasterizer,
        rasterResult,
        patch;
    for (i = 0; i < _numPatches.x; i++) {
        for (j = 0; j < _numPatches.y; j++) {
            x = _subImageWrapper.size.x * i;
            y = _subImageWrapper.size.y * j;

            // seperate parts
            skeletonize(x, y);

            // Rasterize, find individual bars
            _skelImageWrapper.zeroBorder();
            __WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a" /* default */].init(_labelImageWrapper.data, 0);
            rasterizer = __WEBPACK_IMPORTED_MODULE_4__rasterizer__["a" /* default */].create(_skelImageWrapper, _labelImageWrapper);
            rasterResult = rasterizer.rasterize(0);

            if (true && _config.debug.showLabels) {
                _labelImageWrapper.overlay(_canvasContainer.dom.binary, Math.floor(360 / rasterResult.count), { x: x, y: y });
            }

            // calculate moments from the skeletonized patch
            moments = _labelImageWrapper.moments(rasterResult.count);

            // extract eligible patches
            patchesFound = patchesFound.concat(describePatch(moments, [i, j], x, y));
        }
    }

    if (true && _config.debug.showFoundPatches) {
        for (i = 0; i < patchesFound.length; i++) {
            patch = patchesFound[i];
            __WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a" /* default */].drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "#99ff00", lineWidth: 2 });
        }
    }

    return patchesFound;
}

/**
 * Finds those connected areas which contain at least 6 patches
 * and returns them ordered DESC by the number of contained patches
 * @param {Number} maxLabel
 */
function findBiggestConnectedAreas(maxLabel) {
    var i,
        sum,
        labelHist = [],
        topLabels = [];

    for (i = 0; i < maxLabel; i++) {
        labelHist.push(0);
    }
    sum = _patchLabelGrid.data.length;
    while (sum--) {
        if (_patchLabelGrid.data[sum] > 0) {
            labelHist[_patchLabelGrid.data[sum] - 1]++;
        }
    }

    labelHist = labelHist.map(function (val, idx) {
        return {
            val: val,
            label: idx + 1
        };
    });

    labelHist.sort(function (a, b) {
        return b.val - a.val;
    });

    // extract top areas with at least 6 patches present
    topLabels = labelHist.filter(function (el) {
        return el.val >= 5;
    });

    return topLabels;
}

/**
 *
 */
function findBoxes(topLabels, maxLabel) {
    var i,
        j,
        sum,
        patches = [],
        patch,
        box,
        boxes = [],
        hsv = [0, 1, 1],
        rgb = [0, 0, 0];

    for (i = 0; i < topLabels.length; i++) {
        sum = _patchLabelGrid.data.length;
        patches.length = 0;
        while (sum--) {
            if (_patchLabelGrid.data[sum] === topLabels[i].label) {
                patch = _imageToPatchGrid.data[sum];
                patches.push(patch);
            }
        }
        box = boxFromPatches(patches);
        if (box) {
            boxes.push(box);

            // draw patch-labels if requested
            if (true && _config.debug.showRemainingPatchLabels) {
                for (j = 0; j < patches.length; j++) {
                    patch = patches[j];
                    hsv[0] = topLabels[i].label / (maxLabel + 1) * 360;
                    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["a" /* hsv2rgb */])(hsv, rgb);
                    __WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a" /* default */].drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "rgb(" + rgb.join(",") + ")", lineWidth: 2 });
                }
            }
        }
    }
    return boxes;
}

/**
 * Find similar moments (via cluster)
 * @param {Object} moments
 */
function similarMoments(moments) {
    var clusters = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["g" /* cluster */])(moments, 0.90);
    var topCluster = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["h" /* topGeneric */])(clusters, 1, function (e) {
        return e.getPoints().length;
    });
    var points = [],
        result = [];
    if (topCluster.length === 1) {
        points = topCluster[0].item.getPoints();
        for (var i = 0; i < points.length; i++) {
            result.push(points[i].point);
        }
    }
    return result;
}

function skeletonize(x, y) {
    _binaryImageWrapper.subImageAsCopy(_subImageWrapper, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["b" /* imageRef */])(x, y));
    _skeletonizer.skeletonize();

    // Show skeleton if requested
    if (true && _config.debug.showSkeleton) {
        _skelImageWrapper.overlay(_canvasContainer.dom.binary, 360, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["b" /* imageRef */])(x, y));
    }
}

/**
 * Extracts and describes those patches which seem to contain a barcode pattern
 * @param {Array} moments
 * @param {Object} patchPos,
 * @param {Number} x
 * @param {Number} y
 * @returns {Array} list of patches
 */
function describePatch(moments, patchPos, x, y) {
    var k,
        avg,
        eligibleMoments = [],
        matchingMoments,
        patch,
        patchesFound = [],
        minComponentWeight = Math.ceil(_patchSize.x / 3);

    if (moments.length >= 2) {
        // only collect moments which's area covers at least minComponentWeight pixels.
        for (k = 0; k < moments.length; k++) {
            if (moments[k].m00 > minComponentWeight) {
                eligibleMoments.push(moments[k]);
            }
        }

        // if at least 2 moments are found which have at least minComponentWeights covered
        if (eligibleMoments.length >= 2) {
            matchingMoments = similarMoments(eligibleMoments);
            avg = 0;
            // determine the similarity of the moments
            for (k = 0; k < matchingMoments.length; k++) {
                avg += matchingMoments[k].rad;
            }

            // Only two of the moments are allowed not to fit into the equation
            // add the patch to the set
            if (matchingMoments.length > 1 && matchingMoments.length >= eligibleMoments.length / 4 * 3 && matchingMoments.length > moments.length / 4) {
                avg /= matchingMoments.length;
                patch = {
                    index: patchPos[1] * _numPatches.x + patchPos[0],
                    pos: {
                        x: x,
                        y: y
                    },
                    box: [vec2.clone([x, y]), vec2.clone([x + _subImageWrapper.size.x, y]), vec2.clone([x + _subImageWrapper.size.x, y + _subImageWrapper.size.y]), vec2.clone([x, y + _subImageWrapper.size.y])],
                    moments: matchingMoments,
                    rad: avg,
                    vec: vec2.clone([Math.cos(avg), Math.sin(avg)])
                };
                patchesFound.push(patch);
            }
        }
    }
    return patchesFound;
}

/**
 * finds patches which are connected and share the same orientation
 * @param {Object} patchesFound
 */
function rasterizeAngularSimilarity(patchesFound) {
    var label = 0,
        threshold = 0.95,
        currIdx = 0,
        j,
        patch,
        hsv = [0, 1, 1],
        rgb = [0, 0, 0];

    function notYetProcessed() {
        var i;
        for (i = 0; i < _patchLabelGrid.data.length; i++) {
            if (_patchLabelGrid.data[i] === 0 && _patchGrid.data[i] === 1) {
                return i;
            }
        }
        return _patchLabelGrid.length;
    }

    function trace(currentIdx) {
        var x,
            y,
            currentPatch,
            idx,
            dir,
            current = {
            x: currentIdx % _patchLabelGrid.size.x,
            y: currentIdx / _patchLabelGrid.size.x | 0
        },
            similarity;

        if (currentIdx < _patchLabelGrid.data.length) {
            currentPatch = _imageToPatchGrid.data[currentIdx];
            // assign label
            _patchLabelGrid.data[currentIdx] = label;
            for (dir = 0; dir < __WEBPACK_IMPORTED_MODULE_5__tracer__["a" /* default */].searchDirections.length; dir++) {
                y = current.y + __WEBPACK_IMPORTED_MODULE_5__tracer__["a" /* default */].searchDirections[dir][0];
                x = current.x + __WEBPACK_IMPORTED_MODULE_5__tracer__["a" /* default */].searchDirections[dir][1];
                idx = y * _patchLabelGrid.size.x + x;

                // continue if patch empty
                if (_patchGrid.data[idx] === 0) {
                    _patchLabelGrid.data[idx] = Number.MAX_VALUE;
                    continue;
                }

                if (_patchLabelGrid.data[idx] === 0) {
                    similarity = Math.abs(vec2.dot(_imageToPatchGrid.data[idx].vec, currentPatch.vec));
                    if (similarity > threshold) {
                        trace(idx);
                    }
                }
            }
        }
    }

    // prepare for finding the right patches
    __WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a" /* default */].init(_patchGrid.data, 0);
    __WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a" /* default */].init(_patchLabelGrid.data, 0);
    __WEBPACK_IMPORTED_MODULE_2__common_array_helper__["a" /* default */].init(_imageToPatchGrid.data, null);

    for (j = 0; j < patchesFound.length; j++) {
        patch = patchesFound[j];
        _imageToPatchGrid.data[patch.index] = patch;
        _patchGrid.data[patch.index] = 1;
    }

    // rasterize the patches found to determine area
    _patchGrid.zeroBorder();

    while ((currIdx = notYetProcessed()) < _patchLabelGrid.data.length) {
        label++;
        trace(currIdx);
    }

    // draw patch-labels if requested
    if (true && _config.debug.showPatchLabels) {
        for (j = 0; j < _patchLabelGrid.data.length; j++) {
            if (_patchLabelGrid.data[j] > 0 && _patchLabelGrid.data[j] <= label) {
                patch = _imageToPatchGrid.data[j];
                hsv[0] = _patchLabelGrid.data[j] / (label + 1) * 360;
                __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["a" /* hsv2rgb */])(hsv, rgb);
                __WEBPACK_IMPORTED_MODULE_3__common_image_debug__["a" /* default */].drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "rgb(" + rgb.join(",") + ")", lineWidth: 2 });
            }
        }
    }

    return label;
}

/* harmony default export */ exports["a"] = {
    init: function init(inputImageWrapper, config) {
        _config = config;
        _inputImageWrapper = inputImageWrapper;

        initBuffers();
        initCanvas();
    },

    locate: function locate() {
        var patchesFound, topLabels, boxes;

        if (_config.halfSample) {
            __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["i" /* halfSample */])(_inputImageWrapper, _currentImageWrapper);
        }

        binarizeImage();
        patchesFound = findPatches();
        // return unless 5% or more patches are found
        if (patchesFound.length < _numPatches.x * _numPatches.y * 0.05) {
            return null;
        }

        // rasterrize area by comparing angular similarity;
        var maxLabel = rasterizeAngularSimilarity(patchesFound);
        if (maxLabel < 1) {
            return null;
        }

        // search for area with the most patches (biggest connected area)
        topLabels = findBiggestConnectedAreas(maxLabel);
        if (topLabels.length === 0) {
            return null;
        }

        boxes = findBoxes(topLabels, maxLabel);
        return boxes;
    },

    checkImageConstraints: function checkImageConstraints(inputStream, config) {
        var patchSize,
            width = inputStream.getWidth(),
            height = inputStream.getHeight(),
            halfSample = config.halfSample ? 0.5 : 1,
            size,
            area;

        // calculate width and height based on area
        if (inputStream.getConfig().area) {
            area = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["j" /* computeImageArea */])(width, height, inputStream.getConfig().area);
            inputStream.setTopRight({ x: area.sx, y: area.sy });
            inputStream.setCanvasSize({ x: width, y: height });
            width = area.sw;
            height = area.sh;
        }

        size = {
            x: Math.floor(width * halfSample),
            y: Math.floor(height * halfSample)
        };

        patchSize = __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__common_cv_utils__["e" /* calculatePatchSize */])(config.patchSize, size);
        if (true) {
            console.log("Patch-Size: " + JSON.stringify(patchSize));
        }

        inputStream.setWidth(Math.floor(Math.floor(size.x / patchSize.x) * (1 / halfSample) * patchSize.x));
        inputStream.setHeight(Math.floor(Math.floor(size.y / patchSize.y) * (1 / halfSample) * patchSize.y));

        if (inputStream.getWidth() % patchSize.x === 0 && inputStream.getHeight() % patchSize.y === 0) {
            return true;
        }

        throw new Error("Image dimensions do not comply with the current settings: Width (" + width + " )and height (" + height + ") must a multiple of " + patchSize.x);
    }
};
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(70)))

/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__tracer__ = __webpack_require__(42);


/**
 * http://www.codeproject.com/Tips/407172/Connected-Component-Labeling-and-Vectorization
 */
var Rasterizer = {
    createContour2D: function createContour2D() {
        return {
            dir: null,
            index: null,
            firstVertex: null,
            insideContours: null,
            nextpeer: null,
            prevpeer: null
        };
    },
    CONTOUR_DIR: {
        CW_DIR: 0,
        CCW_DIR: 1,
        UNKNOWN_DIR: 2
    },
    DIR: {
        OUTSIDE_EDGE: -32767,
        INSIDE_EDGE: -32766
    },
    create: function create(imageWrapper, labelWrapper) {
        var imageData = imageWrapper.data,
            labelData = labelWrapper.data,
            width = imageWrapper.size.x,
            height = imageWrapper.size.y,
            tracer = __WEBPACK_IMPORTED_MODULE_0__tracer__["a" /* default */].create(imageWrapper, labelWrapper);

        return {
            rasterize: function rasterize(depthlabel) {
                var color,
                    bc,
                    lc,
                    labelindex,
                    cx,
                    cy,
                    colorMap = [],
                    vertex,
                    p,
                    cc,
                    sc,
                    pos,
                    connectedCount = 0,
                    i;

                for (i = 0; i < 400; i++) {
                    colorMap[i] = 0;
                }

                colorMap[0] = imageData[0];
                cc = null;
                for (cy = 1; cy < height - 1; cy++) {
                    labelindex = 0;
                    bc = colorMap[0];
                    for (cx = 1; cx < width - 1; cx++) {
                        pos = cy * width + cx;
                        if (labelData[pos] === 0) {
                            color = imageData[pos];
                            if (color !== bc) {
                                if (labelindex === 0) {
                                    lc = connectedCount + 1;
                                    colorMap[lc] = color;
                                    bc = color;
                                    vertex = tracer.contourTracing(cy, cx, lc, color, Rasterizer.DIR.OUTSIDE_EDGE);
                                    if (vertex !== null) {
                                        connectedCount++;
                                        labelindex = lc;
                                        p = Rasterizer.createContour2D();
                                        p.dir = Rasterizer.CONTOUR_DIR.CW_DIR;
                                        p.index = labelindex;
                                        p.firstVertex = vertex;
                                        p.nextpeer = cc;
                                        p.insideContours = null;
                                        if (cc !== null) {
                                            cc.prevpeer = p;
                                        }
                                        cc = p;
                                    }
                                } else {
                                    vertex = tracer.contourTracing(cy, cx, Rasterizer.DIR.INSIDE_EDGE, color, labelindex);
                                    if (vertex !== null) {
                                        p = Rasterizer.createContour2D();
                                        p.firstVertex = vertex;
                                        p.insideContours = null;
                                        if (depthlabel === 0) {
                                            p.dir = Rasterizer.CONTOUR_DIR.CCW_DIR;
                                        } else {
                                            p.dir = Rasterizer.CONTOUR_DIR.CW_DIR;
                                        }
                                        p.index = depthlabel;
                                        sc = cc;
                                        while (sc !== null && sc.index !== labelindex) {
                                            sc = sc.nextpeer;
                                        }
                                        if (sc !== null) {
                                            p.nextpeer = sc.insideContours;
                                            if (sc.insideContours !== null) {
                                                sc.insideContours.prevpeer = p;
                                            }
                                            sc.insideContours = p;
                                        }
                                    }
                                }
                            } else {
                                labelData[pos] = labelindex;
                            }
                        } else if (labelData[pos] === Rasterizer.DIR.OUTSIDE_EDGE || labelData[pos] === Rasterizer.DIR.INSIDE_EDGE) {
                            labelindex = 0;
                            if (labelData[pos] === Rasterizer.DIR.INSIDE_EDGE) {
                                bc = imageData[pos];
                            } else {
                                bc = colorMap[0];
                            }
                        } else {
                            labelindex = labelData[pos];
                            bc = colorMap[labelindex];
                        }
                    }
                }
                sc = cc;
                while (sc !== null) {
                    sc.index = depthlabel;
                    sc = sc.nextpeer;
                }
                return {
                    cc: cc,
                    count: connectedCount
                };
            },
            debug: {
                drawContour: function drawContour(canvas, firstContour) {
                    var ctx = canvas.getContext("2d"),
                        pq = firstContour,
                        iq,
                        q,
                        p;

                    ctx.strokeStyle = "red";
                    ctx.fillStyle = "red";
                    ctx.lineWidth = 1;

                    if (pq !== null) {
                        iq = pq.insideContours;
                    } else {
                        iq = null;
                    }

                    while (pq !== null) {
                        if (iq !== null) {
                            q = iq;
                            iq = iq.nextpeer;
                        } else {
                            q = pq;
                            pq = pq.nextpeer;
                            if (pq !== null) {
                                iq = pq.insideContours;
                            } else {
                                iq = null;
                            }
                        }

                        switch (q.dir) {
                            case Rasterizer.CONTOUR_DIR.CW_DIR:
                                ctx.strokeStyle = "red";
                                break;
                            case Rasterizer.CONTOUR_DIR.CCW_DIR:
                                ctx.strokeStyle = "blue";
                                break;
                            case Rasterizer.CONTOUR_DIR.UNKNOWN_DIR:
                                ctx.strokeStyle = "green";
                                break;
                        }

                        p = q.firstVertex;
                        ctx.beginPath();
                        ctx.moveTo(p.x, p.y);
                        do {
                            p = p.next;
                            ctx.lineTo(p.x, p.y);
                        } while (p !== q.firstVertex);
                        ctx.stroke();
                    }
                }
            }
        };
    }
};

/* harmony default export */ exports["a"] = Rasterizer;

/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* @preserve ASM BEGIN */
/* eslint-disable eqeqeq*/
function Skeletonizer(stdlib, foreign, buffer) {
    "use asm";

    var images = new stdlib.Uint8Array(buffer),
        size = foreign.size | 0,
        imul = stdlib.Math.imul;

    function erode(inImagePtr, outImagePtr) {
        inImagePtr = inImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var v = 0,
            u = 0,
            sum = 0,
            yStart1 = 0,
            yStart2 = 0,
            xStart1 = 0,
            xStart2 = 0,
            offset = 0;

        for (v = 1; (v | 0) < (size - 1 | 0); v = v + 1 | 0) {
            offset = offset + size | 0;
            for (u = 1; (u | 0) < (size - 1 | 0); u = u + 1 | 0) {
                yStart1 = offset - size | 0;
                yStart2 = offset + size | 0;
                xStart1 = u - 1 | 0;
                xStart2 = u + 1 | 0;
                sum = (images[inImagePtr + yStart1 + xStart1 | 0] | 0) + (images[inImagePtr + yStart1 + xStart2 | 0] | 0) + (images[inImagePtr + offset + u | 0] | 0) + (images[inImagePtr + yStart2 + xStart1 | 0] | 0) + (images[inImagePtr + yStart2 + xStart2 | 0] | 0) | 0;
                if ((sum | 0) == (5 | 0)) {
                    images[outImagePtr + offset + u | 0] = 1;
                } else {
                    images[outImagePtr + offset + u | 0] = 0;
                }
            }
        }
        return;
    }

    function subtract(aImagePtr, bImagePtr, outImagePtr) {
        aImagePtr = aImagePtr | 0;
        bImagePtr = bImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[outImagePtr + length | 0] = (images[aImagePtr + length | 0] | 0) - (images[bImagePtr + length | 0] | 0) | 0;
        }
    }

    function bitwiseOr(aImagePtr, bImagePtr, outImagePtr) {
        aImagePtr = aImagePtr | 0;
        bImagePtr = bImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[outImagePtr + length | 0] = images[aImagePtr + length | 0] | 0 | (images[bImagePtr + length | 0] | 0) | 0;
        }
    }

    function countNonZero(imagePtr) {
        imagePtr = imagePtr | 0;

        var sum = 0,
            length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            sum = (sum | 0) + (images[imagePtr + length | 0] | 0) | 0;
        }

        return sum | 0;
    }

    function init(imagePtr, value) {
        imagePtr = imagePtr | 0;
        value = value | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[imagePtr + length | 0] = value;
        }
    }

    function dilate(inImagePtr, outImagePtr) {
        inImagePtr = inImagePtr | 0;
        outImagePtr = outImagePtr | 0;

        var v = 0,
            u = 0,
            sum = 0,
            yStart1 = 0,
            yStart2 = 0,
            xStart1 = 0,
            xStart2 = 0,
            offset = 0;

        for (v = 1; (v | 0) < (size - 1 | 0); v = v + 1 | 0) {
            offset = offset + size | 0;
            for (u = 1; (u | 0) < (size - 1 | 0); u = u + 1 | 0) {
                yStart1 = offset - size | 0;
                yStart2 = offset + size | 0;
                xStart1 = u - 1 | 0;
                xStart2 = u + 1 | 0;
                sum = (images[inImagePtr + yStart1 + xStart1 | 0] | 0) + (images[inImagePtr + yStart1 + xStart2 | 0] | 0) + (images[inImagePtr + offset + u | 0] | 0) + (images[inImagePtr + yStart2 + xStart1 | 0] | 0) + (images[inImagePtr + yStart2 + xStart2 | 0] | 0) | 0;
                if ((sum | 0) > (0 | 0)) {
                    images[outImagePtr + offset + u | 0] = 1;
                } else {
                    images[outImagePtr + offset + u | 0] = 0;
                }
            }
        }
        return;
    }

    function memcpy(srcImagePtr, dstImagePtr) {
        srcImagePtr = srcImagePtr | 0;
        dstImagePtr = dstImagePtr | 0;

        var length = 0;

        length = imul(size, size) | 0;

        while ((length | 0) > 0) {
            length = length - 1 | 0;
            images[dstImagePtr + length | 0] = images[srcImagePtr + length | 0] | 0;
        }
    }

    function zeroBorder(imagePtr) {
        imagePtr = imagePtr | 0;

        var x = 0,
            y = 0;

        for (x = 0; (x | 0) < (size - 1 | 0); x = x + 1 | 0) {
            images[imagePtr + x | 0] = 0;
            images[imagePtr + y | 0] = 0;
            y = y + size - 1 | 0;
            images[imagePtr + y | 0] = 0;
            y = y + 1 | 0;
        }
        for (x = 0; (x | 0) < (size | 0); x = x + 1 | 0) {
            images[imagePtr + y | 0] = 0;
            y = y + 1 | 0;
        }
    }

    function skeletonize() {
        var subImagePtr = 0,
            erodedImagePtr = 0,
            tempImagePtr = 0,
            skelImagePtr = 0,
            sum = 0,
            done = 0;

        erodedImagePtr = imul(size, size) | 0;
        tempImagePtr = erodedImagePtr + erodedImagePtr | 0;
        skelImagePtr = tempImagePtr + erodedImagePtr | 0;

        // init skel-image
        init(skelImagePtr, 0);
        zeroBorder(subImagePtr);

        do {
            erode(subImagePtr, erodedImagePtr);
            dilate(erodedImagePtr, tempImagePtr);
            subtract(subImagePtr, tempImagePtr, tempImagePtr);
            bitwiseOr(skelImagePtr, tempImagePtr, skelImagePtr);
            memcpy(erodedImagePtr, subImagePtr);
            sum = countNonZero(subImagePtr) | 0;
            done = (sum | 0) == 0 | 0;
        } while (!done);
    }
    return {
        skeletonize: skeletonize
    };
}
/* @preserve ASM END */
/* harmony default export */ exports["a"] = Skeletonizer;
/* eslint-enable eqeqeq*/

/***/ },
/* 90 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__barcode_reader__ = __webpack_require__(10);


function CodabarReader() {
    __WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a" /* default */].call(this);
    this._counters = [];
}

var properties = {
    ALPHABETH_STRING: { value: "0123456789-$:/.+ABCD" },
    ALPHABET: { value: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 36, 58, 47, 46, 43, 65, 66, 67, 68] },
    CHARACTER_ENCODINGS: { value: [0x003, 0x006, 0x009, 0x060, 0x012, 0x042, 0x021, 0x024, 0x030, 0x048, 0x00c, 0x018, 0x045, 0x051, 0x054, 0x015, 0x01A, 0x029, 0x00B, 0x00E] },
    START_END: { value: [0x01A, 0x029, 0x00B, 0x00E] },
    MIN_ENCODED_CHARS: { value: 4 },
    MAX_ACCEPTABLE: { value: 2.0 },
    PADDING: { value: 1.5 },
    FORMAT: { value: "codabar", writeable: false }
};

CodabarReader.prototype = Object.create(__WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a" /* default */].prototype, properties);
CodabarReader.prototype.constructor = CodabarReader;

CodabarReader.prototype._decode = function () {
    var self = this,
        result = [],
        start,
        decodedChar,
        pattern,
        nextStart,
        end;

    this._counters = self._fillCounters();
    start = self._findStart();
    if (!start) {
        return null;
    }
    nextStart = start.startCounter;

    do {
        pattern = self._toPattern(nextStart);
        if (pattern < 0) {
            return null;
        }
        decodedChar = self._patternToChar(pattern);
        if (decodedChar < 0) {
            return null;
        }
        result.push(decodedChar);
        nextStart += 8;
        if (result.length > 1 && self._isStartEnd(pattern)) {
            break;
        }
    } while (nextStart < self._counters.length);

    // verify end
    if (result.length - 2 < self.MIN_ENCODED_CHARS || !self._isStartEnd(pattern)) {
        return null;
    }

    // verify end white space
    if (!self._verifyWhitespace(start.startCounter, nextStart - 8)) {
        return null;
    }

    if (!self._validateResult(result, start.startCounter)) {
        return null;
    }

    nextStart = nextStart > self._counters.length ? self._counters.length : nextStart;
    end = start.start + self._sumCounters(start.startCounter, nextStart - 8);

    return {
        code: result.join(""),
        start: start.start,
        end: end,
        startInfo: start,
        decodedCodes: result
    };
};

CodabarReader.prototype._verifyWhitespace = function (startCounter, endCounter) {
    if (startCounter - 1 <= 0 || this._counters[startCounter - 1] >= this._calculatePatternLength(startCounter) / 2.0) {
        if (endCounter + 8 >= this._counters.length || this._counters[endCounter + 7] >= this._calculatePatternLength(endCounter) / 2.0) {
            return true;
        }
    }
    return false;
};

CodabarReader.prototype._calculatePatternLength = function (offset) {
    var i,
        sum = 0;

    for (i = offset; i < offset + 7; i++) {
        sum += this._counters[i];
    }

    return sum;
};

CodabarReader.prototype._thresholdResultPattern = function (result, startCounter) {
    var self = this,
        categorization = {
        space: {
            narrow: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE },
            wide: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE }
        },
        bar: {
            narrow: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE },
            wide: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE }
        }
    },
        kind,
        cat,
        i,
        j,
        pos = startCounter,
        pattern;

    for (i = 0; i < result.length; i++) {
        pattern = self._charToPattern(result[i]);
        for (j = 6; j >= 0; j--) {
            kind = (j & 1) === 2 ? categorization.bar : categorization.space;
            cat = (pattern & 1) === 1 ? kind.wide : kind.narrow;
            cat.size += self._counters[pos + j];
            cat.counts++;
            pattern >>= 1;
        }
        pos += 8;
    }

    ["space", "bar"].forEach(function (key) {
        var newkind = categorization[key];
        newkind.wide.min = Math.floor((newkind.narrow.size / newkind.narrow.counts + newkind.wide.size / newkind.wide.counts) / 2);
        newkind.narrow.max = Math.ceil(newkind.wide.min);
        newkind.wide.max = Math.ceil((newkind.wide.size * self.MAX_ACCEPTABLE + self.PADDING) / newkind.wide.counts);
    });

    return categorization;
};

CodabarReader.prototype._charToPattern = function (char) {
    var self = this,
        charCode = char.charCodeAt(0),
        i;

    for (i = 0; i < self.ALPHABET.length; i++) {
        if (self.ALPHABET[i] === charCode) {
            return self.CHARACTER_ENCODINGS[i];
        }
    }
    return 0x0;
};

CodabarReader.prototype._validateResult = function (result, startCounter) {
    var self = this,
        thresholds = self._thresholdResultPattern(result, startCounter),
        i,
        j,
        kind,
        cat,
        size,
        pos = startCounter,
        pattern;

    for (i = 0; i < result.length; i++) {
        pattern = self._charToPattern(result[i]);
        for (j = 6; j >= 0; j--) {
            kind = (j & 1) === 0 ? thresholds.bar : thresholds.space;
            cat = (pattern & 1) === 1 ? kind.wide : kind.narrow;
            size = self._counters[pos + j];
            if (size < cat.min || size > cat.max) {
                return false;
            }
            pattern >>= 1;
        }
        pos += 8;
    }
    return true;
};

CodabarReader.prototype._patternToChar = function (pattern) {
    var i,
        self = this;

    for (i = 0; i < self.CHARACTER_ENCODINGS.length; i++) {
        if (self.CHARACTER_ENCODINGS[i] === pattern) {
            return String.fromCharCode(self.ALPHABET[i]);
        }
    }
    return -1;
};

CodabarReader.prototype._computeAlternatingThreshold = function (offset, end) {
    var i,
        min = Number.MAX_VALUE,
        max = 0,
        counter;

    for (i = offset; i < end; i += 2) {
        counter = this._counters[i];
        if (counter > max) {
            max = counter;
        }
        if (counter < min) {
            min = counter;
        }
    }

    return (min + max) / 2.0 | 0;
};

CodabarReader.prototype._toPattern = function (offset) {
    var numCounters = 7,
        end = offset + numCounters,
        barThreshold,
        spaceThreshold,
        bitmask = 1 << numCounters - 1,
        pattern = 0,
        i,
        threshold;

    if (end > this._counters.length) {
        return -1;
    }

    barThreshold = this._computeAlternatingThreshold(offset, end);
    spaceThreshold = this._computeAlternatingThreshold(offset + 1, end);

    for (i = 0; i < numCounters; i++) {
        threshold = (i & 1) === 0 ? barThreshold : spaceThreshold;
        if (this._counters[offset + i] > threshold) {
            pattern |= bitmask;
        }
        bitmask >>= 1;
    }

    return pattern;
};

CodabarReader.prototype._isStartEnd = function (pattern) {
    var i;

    for (i = 0; i < this.START_END.length; i++) {
        if (this.START_END[i] === pattern) {
            return true;
        }
    }
    return false;
};

CodabarReader.prototype._sumCounters = function (start, end) {
    var i,
        sum = 0;

    for (i = start; i < end; i++) {
        sum += this._counters[i];
    }
    return sum;
};

CodabarReader.prototype._findStart = function () {
    var self = this,
        i,
        pattern,
        start = self._nextUnset(self._row),
        end;

    for (i = 1; i < this._counters.length; i++) {
        pattern = self._toPattern(i);
        if (pattern !== -1 && self._isStartEnd(pattern)) {
            // TODO: Look for whitespace ahead
            start += self._sumCounters(0, i);
            end = start + self._sumCounters(i, i + 8);
            return {
                start: start,
                end: end,
                startCounter: i,
                endCounter: i + 8
            };
        }
    }
};

/* harmony default export */ exports["a"] = CodabarReader;

/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__barcode_reader__ = __webpack_require__(10);


function Code128Reader() {
    __WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a" /* default */].call(this);
}

var properties = {
    CODE_SHIFT: { value: 98 },
    CODE_C: { value: 99 },
    CODE_B: { value: 100 },
    CODE_A: { value: 101 },
    START_CODE_A: { value: 103 },
    START_CODE_B: { value: 104 },
    START_CODE_C: { value: 105 },
    STOP_CODE: { value: 106 },
    CODE_PATTERN: { value: [[2, 1, 2, 2, 2, 2], [2, 2, 2, 1, 2, 2], [2, 2, 2, 2, 2, 1], [1, 2, 1, 2, 2, 3], [1, 2, 1, 3, 2, 2], [1, 3, 1, 2, 2, 2], [1, 2, 2, 2, 1, 3], [1, 2, 2, 3, 1, 2], [1, 3, 2, 2, 1, 2], [2, 2, 1, 2, 1, 3], [2, 2, 1, 3, 1, 2], [2, 3, 1, 2, 1, 2], [1, 1, 2, 2, 3, 2], [1, 2, 2, 1, 3, 2], [1, 2, 2, 2, 3, 1], [1, 1, 3, 2, 2, 2], [1, 2, 3, 1, 2, 2], [1, 2, 3, 2, 2, 1], [2, 2, 3, 2, 1, 1], [2, 2, 1, 1, 3, 2], [2, 2, 1, 2, 3, 1], [2, 1, 3, 2, 1, 2], [2, 2, 3, 1, 1, 2], [3, 1, 2, 1, 3, 1], [3, 1, 1, 2, 2, 2], [3, 2, 1, 1, 2, 2], [3, 2, 1, 2, 2, 1], [3, 1, 2, 2, 1, 2], [3, 2, 2, 1, 1, 2], [3, 2, 2, 2, 1, 1], [2, 1, 2, 1, 2, 3], [2, 1, 2, 3, 2, 1], [2, 3, 2, 1, 2, 1], [1, 1, 1, 3, 2, 3], [1, 3, 1, 1, 2, 3], [1, 3, 1, 3, 2, 1], [1, 1, 2, 3, 1, 3], [1, 3, 2, 1, 1, 3], [1, 3, 2, 3, 1, 1], [2, 1, 1, 3, 1, 3], [2, 3, 1, 1, 1, 3], [2, 3, 1, 3, 1, 1], [1, 1, 2, 1, 3, 3], [1, 1, 2, 3, 3, 1], [1, 3, 2, 1, 3, 1], [1, 1, 3, 1, 2, 3], [1, 1, 3, 3, 2, 1], [1, 3, 3, 1, 2, 1], [3, 1, 3, 1, 2, 1], [2, 1, 1, 3, 3, 1], [2, 3, 1, 1, 3, 1], [2, 1, 3, 1, 1, 3], [2, 1, 3, 3, 1, 1], [2, 1, 3, 1, 3, 1], [3, 1, 1, 1, 2, 3], [3, 1, 1, 3, 2, 1], [3, 3, 1, 1, 2, 1], [3, 1, 2, 1, 1, 3], [3, 1, 2, 3, 1, 1], [3, 3, 2, 1, 1, 1], [3, 1, 4, 1, 1, 1], [2, 2, 1, 4, 1, 1], [4, 3, 1, 1, 1, 1], [1, 1, 1, 2, 2, 4], [1, 1, 1, 4, 2, 2], [1, 2, 1, 1, 2, 4], [1, 2, 1, 4, 2, 1], [1, 4, 1, 1, 2, 2], [1, 4, 1, 2, 2, 1], [1, 1, 2, 2, 1, 4], [1, 1, 2, 4, 1, 2], [1, 2, 2, 1, 1, 4], [1, 2, 2, 4, 1, 1], [1, 4, 2, 1, 1, 2], [1, 4, 2, 2, 1, 1], [2, 4, 1, 2, 1, 1], [2, 2, 1, 1, 1, 4], [4, 1, 3, 1, 1, 1], [2, 4, 1, 1, 1, 2], [1, 3, 4, 1, 1, 1], [1, 1, 1, 2, 4, 2], [1, 2, 1, 1, 4, 2], [1, 2, 1, 2, 4, 1], [1, 1, 4, 2, 1, 2], [1, 2, 4, 1, 1, 2], [1, 2, 4, 2, 1, 1], [4, 1, 1, 2, 1, 2], [4, 2, 1, 1, 1, 2], [4, 2, 1, 2, 1, 1], [2, 1, 2, 1, 4, 1], [2, 1, 4, 1, 2, 1], [4, 1, 2, 1, 2, 1], [1, 1, 1, 1, 4, 3], [1, 1, 1, 3, 4, 1], [1, 3, 1, 1, 4, 1], [1, 1, 4, 1, 1, 3], [1, 1, 4, 3, 1, 1], [4, 1, 1, 1, 1, 3], [4, 1, 1, 3, 1, 1], [1, 1, 3, 1, 4, 1], [1, 1, 4, 1, 3, 1], [3, 1, 1, 1, 4, 1], [4, 1, 1, 1, 3, 1], [2, 1, 1, 4, 1, 2], [2, 1, 1, 2, 1, 4], [2, 1, 1, 2, 3, 2], [2, 3, 3, 1, 1, 1, 2]] },
    SINGLE_CODE_ERROR: { value: 0.64 },
    AVG_CODE_ERROR: { value: 0.30 },
    FORMAT: { value: "code_128", writeable: false },
    MODULE_INDICES: { value: { bar: [0, 2, 4], space: [1, 3, 5] } }
};

Code128Reader.prototype = Object.create(__WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a" /* default */].prototype, properties);
Code128Reader.prototype.constructor = Code128Reader;

Code128Reader.prototype._decodeCode = function (start, correction) {
    var counter = [0, 0, 0, 0, 0, 0],
        i,
        self = this,
        offset = start,
        isWhite = !self._row[offset],
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: start,
        end: start,
        correction: {
            bar: 1,
            space: 1
        }
    },
        code,
        error;

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                if (correction) {
                    self._correct(counter, correction);
                }
                for (code = 0; code < self.CODE_PATTERN.length; code++) {
                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
                    if (error < bestMatch.error) {
                        bestMatch.code = code;
                        bestMatch.error = error;
                    }
                }
                bestMatch.end = i;
                if (bestMatch.code === -1 || bestMatch.error > self.AVG_CODE_ERROR) {
                    return null;
                }
                if (self.CODE_PATTERN[bestMatch.code]) {
                    bestMatch.correction.bar = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.bar);
                    bestMatch.correction.space = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.space);
                }
                return bestMatch;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

Code128Reader.prototype._correct = function (counter, correction) {
    this._correctBars(counter, correction.bar, this.MODULE_INDICES.bar);
    this._correctBars(counter, correction.space, this.MODULE_INDICES.space);
};

Code128Reader.prototype._findStart = function () {
    var counter = [0, 0, 0, 0, 0, 0],
        i,
        self = this,
        offset = self._nextSet(self._row),
        isWhite = false,
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0,
        correction: {
            bar: 1,
            space: 1
        }
    },
        code,
        error,
        j,
        sum;

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                sum = 0;
                for (j = 0; j < counter.length; j++) {
                    sum += counter[j];
                }
                for (code = self.START_CODE_A; code <= self.START_CODE_C; code++) {
                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
                    if (error < bestMatch.error) {
                        bestMatch.code = code;
                        bestMatch.error = error;
                    }
                }
                if (bestMatch.error < self.AVG_CODE_ERROR) {
                    bestMatch.start = i - sum;
                    bestMatch.end = i;
                    bestMatch.correction.bar = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.bar);
                    bestMatch.correction.space = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.space);
                    return bestMatch;
                }

                for (j = 0; j < 4; j++) {
                    counter[j] = counter[j + 2];
                }
                counter[4] = 0;
                counter[5] = 0;
                counterPos--;
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

Code128Reader.prototype._decode = function () {
    var self = this,
        startInfo = self._findStart(),
        code = null,
        done = false,
        result = [],
        multiplier = 0,
        checksum = 0,
        codeset,
        rawResult = [],
        decodedCodes = [],
        shiftNext = false,
        unshift,
        removeLastCharacter = true;

    if (startInfo === null) {
        return null;
    }
    code = {
        code: startInfo.code,
        start: startInfo.start,
        end: startInfo.end,
        correction: {
            bar: startInfo.correction.bar,
            space: startInfo.correction.space
        }
    };
    decodedCodes.push(code);
    checksum = code.code;
    switch (code.code) {
        case self.START_CODE_A:
            codeset = self.CODE_A;
            break;
        case self.START_CODE_B:
            codeset = self.CODE_B;
            break;
        case self.START_CODE_C:
            codeset = self.CODE_C;
            break;
        default:
            return null;
    }

    while (!done) {
        unshift = shiftNext;
        shiftNext = false;
        code = self._decodeCode(code.end, code.correction);
        if (code !== null) {
            if (code.code !== self.STOP_CODE) {
                removeLastCharacter = true;
            }

            if (code.code !== self.STOP_CODE) {
                rawResult.push(code.code);
                multiplier++;
                checksum += multiplier * code.code;
            }
            decodedCodes.push(code);

            switch (codeset) {
                case self.CODE_A:
                    if (code.code < 64) {
                        result.push(String.fromCharCode(32 + code.code));
                    } else if (code.code < 96) {
                        result.push(String.fromCharCode(code.code - 64));
                    } else {
                        if (code.code !== self.STOP_CODE) {
                            removeLastCharacter = false;
                        }
                        switch (code.code) {
                            case self.CODE_SHIFT:
                                shiftNext = true;
                                codeset = self.CODE_B;
                                break;
                            case self.CODE_B:
                                codeset = self.CODE_B;
                                break;
                            case self.CODE_C:
                                codeset = self.CODE_C;
                                break;
                            case self.STOP_CODE:
                                done = true;
                                break;
                        }
                    }
                    break;
                case self.CODE_B:
                    if (code.code < 96) {
                        result.push(String.fromCharCode(32 + code.code));
                    } else {
                        if (code.code !== self.STOP_CODE) {
                            removeLastCharacter = false;
                        }
                        switch (code.code) {
                            case self.CODE_SHIFT:
                                shiftNext = true;
                                codeset = self.CODE_A;
                                break;
                            case self.CODE_A:
                                codeset = self.CODE_A;
                                break;
                            case self.CODE_C:
                                codeset = self.CODE_C;
                                break;
                            case self.STOP_CODE:
                                done = true;
                                break;
                        }
                    }
                    break;
                case self.CODE_C:
                    if (code.code < 100) {
                        result.push(code.code < 10 ? "0" + code.code : code.code);
                    } else {
                        if (code.code !== self.STOP_CODE) {
                            removeLastCharacter = false;
                        }
                        switch (code.code) {
                            case self.CODE_A:
                                codeset = self.CODE_A;
                                break;
                            case self.CODE_B:
                                codeset = self.CODE_B;
                                break;
                            case self.STOP_CODE:
                                done = true;
                                break;
                        }
                    }
                    break;
            }
        } else {
            done = true;
        }
        if (unshift) {
            codeset = codeset === self.CODE_A ? self.CODE_B : self.CODE_A;
        }
    }

    if (code === null) {
        return null;
    }

    code.end = self._nextUnset(self._row, code.end);
    if (!self._verifyTrailingWhitespace(code)) {
        return null;
    }

    checksum -= multiplier * rawResult[rawResult.length - 1];
    if (checksum % 103 !== rawResult[rawResult.length - 1]) {
        return null;
    }

    if (!result.length) {
        return null;
    }

    // remove last code from result (checksum)
    if (removeLastCharacter) {
        result.splice(result.length - 1, 1);
    }

    return {
        code: result.join(""),
        start: startInfo.start,
        end: code.end,
        codeset: codeset,
        startInfo: startInfo,
        decodedCodes: decodedCodes,
        endInfo: code
    };
};

__WEBPACK_IMPORTED_MODULE_0__barcode_reader__["a" /* default */].prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
    return null;
};

function calculateCorrection(expected, normalized, indices) {
    var length = indices.length,
        sumNormalized = 0,
        sumExpected = 0;

    while (length--) {
        sumExpected += expected[indices[length]];
        sumNormalized += normalized[indices[length]];
    }
    return sumExpected / sumNormalized;
}

/* harmony default export */ exports["a"] = Code128Reader;

/***/ },
/* 92 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__code_39_reader__ = __webpack_require__(43);


function Code39VINReader() {
    __WEBPACK_IMPORTED_MODULE_0__code_39_reader__["a" /* default */].call(this);
}

var patterns = {
    IOQ: /[IOQ]/g,
    AZ09: /[A-Z0-9]{17}/
};

Code39VINReader.prototype = Object.create(__WEBPACK_IMPORTED_MODULE_0__code_39_reader__["a" /* default */].prototype);
Code39VINReader.prototype.constructor = Code39VINReader;

// Cribbed from:
// https://github.com/zxing/zxing/blob/master/core/src/main/java/com/google/zxing/client/result/VINResultParser.java
Code39VINReader.prototype._decode = function () {
    var result = __WEBPACK_IMPORTED_MODULE_0__code_39_reader__["a" /* default */].prototype._decode.apply(this);
    if (!result) {
        return null;
    }

    var code = result.code;

    if (!code) {
        return null;
    }

    code = code.replace(patterns.IOQ, '');

    if (!code.match(patterns.AZ09)) {
        if (true) {
            console.log('Failed AZ09 pattern code:', code);
        }
        return null;
    }

    if (!this._checkChecksum(code)) {
        return null;
    }

    result.code = code;
    return result;
};

Code39VINReader.prototype._checkChecksum = function (code) {
    // TODO
    return !!code;
};

/* harmony default export */ exports["a"] = Code39VINReader;

/***/ },
/* 93 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ean_reader__ = __webpack_require__(5);


function EAN2Reader() {
    __WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].call(this);
}

var properties = {
    FORMAT: { value: "ean_2", writeable: false }
};

EAN2Reader.prototype = Object.create(__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].prototype, properties);
EAN2Reader.prototype.constructor = EAN2Reader;

EAN2Reader.prototype.decode = function (row, start) {
    this._row = row;
    var counters = [0, 0, 0, 0],
        codeFrequency = 0,
        i = 0,
        offset = start,
        end = this._row.length,
        code,
        result = [],
        decodedCodes = [];

    for (i = 0; i < 2 && offset < end; i++) {
        code = this._decodeCode(offset);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code % 10);
        if (code.code >= this.CODE_G_START) {
            codeFrequency |= 1 << 1 - i;
        }
        if (i != 1) {
            offset = this._nextSet(this._row, code.end);
            offset = this._nextUnset(this._row, offset);
        }
    }

    if (result.length != 2 || parseInt(result.join("")) % 4 !== codeFrequency) {
        return null;
    }
    return {
        code: result.join(""),
        decodedCodes: decodedCodes,
        end: code.end
    };
};

/* harmony default export */ exports["a"] = EAN2Reader;

/***/ },
/* 94 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ean_reader__ = __webpack_require__(5);


function EAN5Reader() {
    __WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].call(this);
}

var properties = {
    FORMAT: { value: "ean_5", writeable: false }
};

var CHECK_DIGIT_ENCODINGS = [24, 20, 18, 17, 12, 6, 3, 10, 9, 5];

EAN5Reader.prototype = Object.create(__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].prototype, properties);
EAN5Reader.prototype.constructor = EAN5Reader;

EAN5Reader.prototype.decode = function (row, start) {
    this._row = row;
    var counters = [0, 0, 0, 0],
        codeFrequency = 0,
        i = 0,
        offset = start,
        end = this._row.length,
        code,
        result = [],
        decodedCodes = [];

    for (i = 0; i < 5 && offset < end; i++) {
        code = this._decodeCode(offset);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code % 10);
        if (code.code >= this.CODE_G_START) {
            codeFrequency |= 1 << 4 - i;
        }
        if (i != 4) {
            offset = this._nextSet(this._row, code.end);
            offset = this._nextUnset(this._row, offset);
        }
    }

    if (result.length != 5) {
        return null;
    }

    if (extensionChecksum(result) !== determineCheckDigit(codeFrequency)) {
        return null;
    }
    return {
        code: result.join(""),
        decodedCodes: decodedCodes,
        end: code.end
    };
};

function determineCheckDigit(codeFrequency) {
    var i;
    for (i = 0; i < 10; i++) {
        if (codeFrequency === CHECK_DIGIT_ENCODINGS[i]) {
            return i;
        }
    }
    return null;
}

function extensionChecksum(result) {
    var length = result.length,
        sum = 0,
        i;

    for (i = length - 2; i >= 0; i -= 2) {
        sum += result[i];
    }
    sum *= 3;
    for (i = length - 1; i >= 0; i -= 2) {
        sum += result[i];
    }
    sum *= 3;
    return sum % 10;
}

/* harmony default export */ exports["a"] = EAN5Reader;

/***/ },
/* 95 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ean_reader__ = __webpack_require__(5);


function EAN8Reader(opts, supplements) {
    __WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].call(this, opts, supplements);
}

var properties = {
    FORMAT: { value: "ean_8", writeable: false }
};

EAN8Reader.prototype = Object.create(__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].prototype, properties);
EAN8Reader.prototype.constructor = EAN8Reader;

EAN8Reader.prototype._decodePayload = function (code, result, decodedCodes) {
    var i,
        self = this;

    for (i = 0; i < 4; i++) {
        code = self._decodeCode(code.end, self.CODE_G_START);
        if (!code) {
            return null;
        }
        result.push(code.code);
        decodedCodes.push(code);
    }

    code = self._findPattern(self.MIDDLE_PATTERN, code.end, true, false);
    if (code === null) {
        return null;
    }
    decodedCodes.push(code);

    for (i = 0; i < 4; i++) {
        code = self._decodeCode(code.end, self.CODE_G_START);
        if (!code) {
            return null;
        }
        decodedCodes.push(code);
        result.push(code.code);
    }

    return code;
};

/* harmony default export */ exports["a"] = EAN8Reader;

/***/ },
/* 96 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_lodash_merge__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__barcode_reader__ = __webpack_require__(10);




function I2of5Reader(opts) {
    opts = __WEBPACK_IMPORTED_MODULE_0_lodash_merge___default()(getDefaulConfig(), opts);
    __WEBPACK_IMPORTED_MODULE_1__barcode_reader__["a" /* default */].call(this, opts);
    this.barSpaceRatio = [1, 1];
    if (opts.normalizeBarSpaceWidth) {
        this.SINGLE_CODE_ERROR = 0.38;
        this.AVG_CODE_ERROR = 0.09;
    }
}

function getDefaulConfig() {
    var config = {};

    Object.keys(I2of5Reader.CONFIG_KEYS).forEach(function (key) {
        config[key] = I2of5Reader.CONFIG_KEYS[key].default;
    });
    return config;
}

var N = 1,
    W = 3,
    properties = {
    START_PATTERN: { value: [N, N, N, N] },
    STOP_PATTERN: { value: [N, N, W] },
    CODE_PATTERN: { value: [[N, N, W, W, N], [W, N, N, N, W], [N, W, N, N, W], [W, W, N, N, N], [N, N, W, N, W], [W, N, W, N, N], [N, W, W, N, N], [N, N, N, W, W], [W, N, N, W, N], [N, W, N, W, N]] },
    SINGLE_CODE_ERROR: { value: 0.78, writable: true },
    AVG_CODE_ERROR: { value: 0.38, writable: true },
    MAX_CORRECTION_FACTOR: { value: 5 },
    FORMAT: { value: "i2of5" }
};

I2of5Reader.prototype = Object.create(__WEBPACK_IMPORTED_MODULE_1__barcode_reader__["a" /* default */].prototype, properties);
I2of5Reader.prototype.constructor = I2of5Reader;

I2of5Reader.prototype._matchPattern = function (counter, code) {
    if (this.config.normalizeBarSpaceWidth) {
        var i,
            counterSum = [0, 0],
            codeSum = [0, 0],
            correction = [0, 0],
            correctionRatio = this.MAX_CORRECTION_FACTOR,
            correctionRatioInverse = 1 / correctionRatio;

        for (i = 0; i < counter.length; i++) {
            counterSum[i % 2] += counter[i];
            codeSum[i % 2] += code[i];
        }
        correction[0] = codeSum[0] / counterSum[0];
        correction[1] = codeSum[1] / counterSum[1];

        correction[0] = Math.max(Math.min(correction[0], correctionRatio), correctionRatioInverse);
        correction[1] = Math.max(Math.min(correction[1], correctionRatio), correctionRatioInverse);
        this.barSpaceRatio = correction;
        for (i = 0; i < counter.length; i++) {
            counter[i] *= this.barSpaceRatio[i % 2];
        }
    }
    return __WEBPACK_IMPORTED_MODULE_1__barcode_reader__["a" /* default */].prototype._matchPattern.call(this, counter, code);
};

I2of5Reader.prototype._findPattern = function (pattern, offset, isWhite, tryHarder) {
    var counter = [],
        self = this,
        i,
        counterPos = 0,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0
    },
        error,
        j,
        sum,
        normalized,
        epsilon = self.AVG_CODE_ERROR;

    isWhite = isWhite || false;
    tryHarder = tryHarder || false;

    if (!offset) {
        offset = self._nextSet(self._row);
    }

    for (i = 0; i < pattern.length; i++) {
        counter[i] = 0;
    }

    for (i = offset; i < self._row.length; i++) {
        if (self._row[i] ^ isWhite) {
            counter[counterPos]++;
        } else {
            if (counterPos === counter.length - 1) {
                sum = 0;
                for (j = 0; j < counter.length; j++) {
                    sum += counter[j];
                }
                error = self._matchPattern(counter, pattern);
                if (error < epsilon) {
                    bestMatch.error = error;
                    bestMatch.start = i - sum;
                    bestMatch.end = i;
                    return bestMatch;
                }
                if (tryHarder) {
                    for (j = 0; j < counter.length - 2; j++) {
                        counter[j] = counter[j + 2];
                    }
                    counter[counter.length - 2] = 0;
                    counter[counter.length - 1] = 0;
                    counterPos--;
                } else {
                    return null;
                }
            } else {
                counterPos++;
            }
            counter[counterPos] = 1;
            isWhite = !isWhite;
        }
    }
    return null;
};

I2of5Reader.prototype._findStart = function () {
    var self = this,
        leadingWhitespaceStart,
        offset = self._nextSet(self._row),
        startInfo,
        narrowBarWidth = 1;

    while (!startInfo) {
        startInfo = self._findPattern(self.START_PATTERN, offset, false, true);
        if (!startInfo) {
            return null;
        }
        narrowBarWidth = Math.floor((startInfo.end - startInfo.start) / 4);
        leadingWhitespaceStart = startInfo.start - narrowBarWidth * 10;
        if (leadingWhitespaceStart >= 0) {
            if (self._matchRange(leadingWhitespaceStart, startInfo.start, 0)) {
                return startInfo;
            }
        }
        offset = startInfo.end;
        startInfo = null;
    }
};

I2of5Reader.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
    return null;
};

I2of5Reader.prototype._findEnd = function () {
    var self = this,
        endInfo,
        tmp;

    self._row.reverse();
    endInfo = self._findPattern(self.STOP_PATTERN);
    self._row.reverse();

    if (endInfo === null) {
        return null;
    }

    // reverse numbers
    tmp = endInfo.start;
    endInfo.start = self._row.length - endInfo.end;
    endInfo.end = self._row.length - tmp;

    return endInfo !== null ? self._verifyTrailingWhitespace(endInfo) : null;
};

I2of5Reader.prototype._decodePair = function (counterPair) {
    var i,
        code,
        codes = [],
        self = this;

    for (i = 0; i < counterPair.length; i++) {
        code = self._decodeCode(counterPair[i]);
        if (!code) {
            return null;
        }
        codes.push(code);
    }
    return codes;
};

I2of5Reader.prototype._decodeCode = function (counter) {
    var j,
        self = this,
        sum = 0,
        normalized,
        error,
        epsilon = self.AVG_CODE_ERROR,
        code,
        bestMatch = {
        error: Number.MAX_VALUE,
        code: -1,
        start: 0,
        end: 0
    };

    for (j = 0; j < counter.length; j++) {
        sum += counter[j];
    }
    for (code = 0; code < self.CODE_PATTERN.length; code++) {
        error = self._matchPattern(counter, self.CODE_PATTERN[code]);
        if (error < bestMatch.error) {
            bestMatch.code = code;
            bestMatch.error = error;
        }
    }
    if (bestMatch.error < epsilon) {
        return bestMatch;
    }
};

I2of5Reader.prototype._decodePayload = function (counters, result, decodedCodes) {
    var i,
        self = this,
        pos = 0,
        counterLength = counters.length,
        counterPair = [[0, 0, 0, 0, 0], [0, 0, 0, 0, 0]],
        codes;

    while (pos < counterLength) {
        for (i = 0; i < 5; i++) {
            counterPair[0][i] = counters[pos] * this.barSpaceRatio[0];
            counterPair[1][i] = counters[pos + 1] * this.barSpaceRatio[1];
            pos += 2;
        }
        codes = self._decodePair(counterPair);
        if (!codes) {
            return null;
        }
        for (i = 0; i < codes.length; i++) {
            result.push(codes[i].code + "");
            decodedCodes.push(codes[i]);
        }
    }
    return codes;
};

I2of5Reader.prototype._verifyCounterLength = function (counters) {
    return counters.length % 10 === 0;
};

I2of5Reader.prototype._decode = function () {
    var startInfo,
        endInfo,
        self = this,
        code,
        result = [],
        decodedCodes = [],
        counters;

    startInfo = self._findStart();
    if (!startInfo) {
        return null;
    }
    decodedCodes.push(startInfo);

    endInfo = self._findEnd();
    if (!endInfo) {
        return null;
    }

    counters = self._fillCounters(startInfo.end, endInfo.start, false);
    if (!self._verifyCounterLength(counters)) {
        return null;
    }
    code = self._decodePayload(counters, result, decodedCodes);
    if (!code) {
        return null;
    }
    if (result.length % 2 !== 0 || result.length < 6) {
        return null;
    }

    decodedCodes.push(endInfo);
    return {
        code: result.join(""),
        start: startInfo.start,
        end: endInfo.end,
        startInfo: startInfo,
        decodedCodes: decodedCodes
    };
};

I2of5Reader.CONFIG_KEYS = {
    normalizeBarSpaceWidth: {
        'type': 'boolean',
        'default': false,
        'description': 'If true, the reader tries to normalize the' + 'width-difference between bars and spaces'
    }
};

/* harmony default export */ exports["a"] = I2of5Reader;

/***/ },
/* 97 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ean_reader__ = __webpack_require__(5);


function UPCEReader(opts, supplements) {
    __WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].call(this, opts, supplements);
}

var properties = {
    CODE_FREQUENCY: { value: [[56, 52, 50, 49, 44, 38, 35, 42, 41, 37], [7, 11, 13, 14, 19, 25, 28, 21, 22, 26]] },
    STOP_PATTERN: { value: [1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7] },
    FORMAT: { value: "upc_e", writeable: false }
};

UPCEReader.prototype = Object.create(__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].prototype, properties);
UPCEReader.prototype.constructor = UPCEReader;

UPCEReader.prototype._decodePayload = function (code, result, decodedCodes) {
    var i,
        self = this,
        codeFrequency = 0x0;

    for (i = 0; i < 6; i++) {
        code = self._decodeCode(code.end);
        if (!code) {
            return null;
        }
        if (code.code >= self.CODE_G_START) {
            code.code = code.code - self.CODE_G_START;
            codeFrequency |= 1 << 5 - i;
        }
        result.push(code.code);
        decodedCodes.push(code);
    }
    if (!self._determineParity(codeFrequency, result)) {
        return null;
    }

    return code;
};

UPCEReader.prototype._determineParity = function (codeFrequency, result) {
    var i, nrSystem;

    for (nrSystem = 0; nrSystem < this.CODE_FREQUENCY.length; nrSystem++) {
        for (i = 0; i < this.CODE_FREQUENCY[nrSystem].length; i++) {
            if (codeFrequency === this.CODE_FREQUENCY[nrSystem][i]) {
                result.unshift(nrSystem);
                result.push(i);
                return true;
            }
        }
    }
    return false;
};

UPCEReader.prototype._convertToUPCA = function (result) {
    var upca = [result[0]],
        lastDigit = result[result.length - 2];

    if (lastDigit <= 2) {
        upca = upca.concat(result.slice(1, 3)).concat([lastDigit, 0, 0, 0, 0]).concat(result.slice(3, 6));
    } else if (lastDigit === 3) {
        upca = upca.concat(result.slice(1, 4)).concat([0, 0, 0, 0, 0]).concat(result.slice(4, 6));
    } else if (lastDigit === 4) {
        upca = upca.concat(result.slice(1, 5)).concat([0, 0, 0, 0, 0, result[5]]);
    } else {
        upca = upca.concat(result.slice(1, 6)).concat([0, 0, 0, 0, lastDigit]);
    }

    upca.push(result[result.length - 1]);
    return upca;
};

UPCEReader.prototype._checksum = function (result) {
    return __WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].prototype._checksum.call(this, this._convertToUPCA(result));
};

UPCEReader.prototype._findEnd = function (offset, isWhite) {
    isWhite = true;
    return __WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].prototype._findEnd.call(this, offset, isWhite);
};

UPCEReader.prototype._verifyTrailingWhitespace = function (endInfo) {
    var self = this,
        trailingWhitespaceEnd;

    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
    if (trailingWhitespaceEnd < self._row.length) {
        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
            return endInfo;
        }
    }
};

/* harmony default export */ exports["a"] = UPCEReader;

/***/ },
/* 98 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ean_reader__ = __webpack_require__(5);


function UPCReader(opts, supplements) {
    __WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].call(this, opts, supplements);
}

var properties = {
    FORMAT: { value: "upc_a", writeable: false }
};

UPCReader.prototype = Object.create(__WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].prototype, properties);
UPCReader.prototype.constructor = UPCReader;

UPCReader.prototype._decode = function () {
    var result = __WEBPACK_IMPORTED_MODULE_0__ean_reader__["a" /* default */].prototype._decode.call(this);

    if (result && result.code && result.code.length === 13 && result.code.charAt(0) === "0") {
        result.code = result.code.substring(1);
        return result;
    }
    return null;
};

/* harmony default export */ exports["a"] = UPCReader;

/***/ },
/* 99 */
/***/ function(module, exports) {

module.exports = copy

/**
 * Copy the values from one mat2 to another
 *
 * @alias mat2.copy
 * @param {mat2} out the receiving matrix
 * @param {mat2} a the source matrix
 * @returns {mat2} out
 */
function copy(out, a) {
  out[0] = a[0]
  out[1] = a[1]
  out[2] = a[2]
  out[3] = a[3]
  return out
}


/***/ },
/* 100 */
/***/ function(module, exports) {

module.exports = create

/**
 * Creates a new identity mat2
 *
 * @alias mat2.create
 * @returns {mat2} a new 2x2 matrix
 */
function create() {
  var out = new Float32Array(4)
  out[0] = 1
  out[1] = 0
  out[2] = 0
  out[3] = 1
  return out
}


/***/ },
/* 101 */
/***/ function(module, exports) {

module.exports = invert

/**
 * Inverts a mat2
 *
 * @alias mat2.invert
 * @param {mat2} out the receiving matrix
 * @param {mat2} a the source matrix
 * @returns {mat2} out
 */
function invert(out, a) {
  var a0 = a[0]
  var a1 = a[1]
  var a2 = a[2]
  var a3 = a[3]
  var det = a0 * a3 - a2 * a1

  if (!det) return null
  det = 1.0 / det

  out[0] =  a3 * det
  out[1] = -a1 * det
  out[2] = -a2 * det
  out[3] =  a0 * det

  return out
}


/***/ },
/* 102 */
/***/ function(module, exports) {

module.exports = scale

/**
 * Scales a vec2 by a scalar number
 *
 * @param {vec2} out the receiving vector
 * @param {vec2} a the vector to scale
 * @param {Number} b amount to scale the vector by
 * @returns {vec2} out
 */
function scale(out, a, b) {
    out[0] = a[0] * b
    out[1] = a[1] * b
    return out
}

/***/ },
/* 103 */
/***/ function(module, exports) {

module.exports = transformMat2

/**
 * Transforms the vec2 with a mat2
 *
 * @param {vec2} out the receiving vector
 * @param {vec2} a the vector to transform
 * @param {mat2} m matrix to transform with
 * @returns {vec2} out
 */
function transformMat2(out, a, m) {
    var x = a[0],
        y = a[1]
    out[0] = m[0] * x + m[2] * y
    out[1] = m[1] * x + m[3] * y
    return out
}

/***/ },
/* 104 */
/***/ function(module, exports) {

module.exports = clone;

/**
 * Creates a new vec3 initialized with values from an existing vector
 *
 * @param {vec3} a vector to clone
 * @returns {vec3} a new 3D vector
 */
function clone(a) {
    var out = new Float32Array(3)
    out[0] = a[0]
    out[1] = a[1]
    out[2] = a[2]
    return out
}

/***/ },
/* 105 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4),
    root = __webpack_require__(1);

/* Built-in method references that are verified to be native. */
var DataView = getNative(root, 'DataView');

module.exports = DataView;


/***/ },
/* 106 */
/***/ function(module, exports, __webpack_require__) {

var hashClear = __webpack_require__(156),
    hashDelete = __webpack_require__(157),
    hashGet = __webpack_require__(158),
    hashHas = __webpack_require__(159),
    hashSet = __webpack_require__(160);

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

module.exports = Hash;


/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4),
    root = __webpack_require__(1);

/* Built-in method references that are verified to be native. */
var Promise = getNative(root, 'Promise');

module.exports = Promise;


/***/ },
/* 108 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4),
    root = __webpack_require__(1);

/* Built-in method references that are verified to be native. */
var Set = getNative(root, 'Set');

module.exports = Set;


/***/ },
/* 109 */
/***/ function(module, exports, __webpack_require__) {

var root = __webpack_require__(1);

/** Built-in value references. */
var Uint8Array = root.Uint8Array;

module.exports = Uint8Array;


/***/ },
/* 110 */
/***/ function(module, exports, __webpack_require__) {

var getNative = __webpack_require__(4),
    root = __webpack_require__(1);

/* Built-in method references that are verified to be native. */
var WeakMap = getNative(root, 'WeakMap');

module.exports = WeakMap;


/***/ },
/* 111 */
/***/ function(module, exports) {

/**
 * Adds the key-value `pair` to `map`.
 *
 * @private
 * @param {Object} map The map to modify.
 * @param {Array} pair The key-value pair to add.
 * @returns {Object} Returns `map`.
 */
function addMapEntry(map, pair) {
  // Don't return `map.set` because it's not chainable in IE 11.
  map.set(pair[0], pair[1]);
  return map;
}

module.exports = addMapEntry;


/***/ },
/* 112 */
/***/ function(module, exports) {

/**
 * Adds `value` to `set`.
 *
 * @private
 * @param {Object} set The set to modify.
 * @param {*} value The value to add.
 * @returns {Object} Returns `set`.
 */
function addSetEntry(set, value) {
  // Don't return `set.add` because it's not chainable in IE 11.
  set.add(value);
  return set;
}

module.exports = addSetEntry;


/***/ },
/* 113 */
/***/ function(module, exports) {

/**
 * A faster alternative to `Function#apply`, this function invokes `func`
 * with the `this` binding of `thisArg` and the arguments of `args`.
 *
 * @private
 * @param {Function} func The function to invoke.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {Array} args The arguments to invoke `func` with.
 * @returns {*} Returns the result of `func`.
 */
function apply(func, thisArg, args) {
  switch (args.length) {
    case 0: return func.call(thisArg);
    case 1: return func.call(thisArg, args[0]);
    case 2: return func.call(thisArg, args[0], args[1]);
    case 3: return func.call(thisArg, args[0], args[1], args[2]);
  }
  return func.apply(thisArg, args);
}

module.exports = apply;


/***/ },
/* 114 */
/***/ function(module, exports) {

/**
 * A specialized version of `_.forEach` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns `array`.
 */
function arrayEach(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (iteratee(array[index], index, array) === false) {
      break;
    }
  }
  return array;
}

module.exports = arrayEach;


/***/ },
/* 115 */
/***/ function(module, exports) {

/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length,
      resIndex = 0,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}

module.exports = arrayFilter;


/***/ },
/* 116 */
/***/ function(module, exports, __webpack_require__) {

var copyObject = __webpack_require__(8),
    keys = __webpack_require__(39);

/**
 * The base implementation of `_.assign` without support for multiple sources
 * or `customizer` functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @returns {Object} Returns `object`.
 */
function baseAssign(object, source) {
  return object && copyObject(source, keys(source), object);
}

module.exports = baseAssign;


/***/ },
/* 117 */
/***/ function(module, exports, __webpack_require__) {

var copyObject = __webpack_require__(8),
    keysIn = __webpack_require__(24);

/**
 * The base implementation of `_.assignIn` without support for multiple sources
 * or `customizer` functions.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @returns {Object} Returns `object`.
 */
function baseAssignIn(object, source) {
  return object && copyObject(source, keysIn(source), object);
}

module.exports = baseAssignIn;


/***/ },
/* 118 */
/***/ function(module, exports, __webpack_require__) {

var Stack = __webpack_require__(46),
    arrayEach = __webpack_require__(114),
    assignValue = __webpack_require__(29),
    baseAssign = __webpack_require__(116),
    baseAssignIn = __webpack_require__(117),
    cloneBuffer = __webpack_require__(53),
    copyArray = __webpack_require__(55),
    copySymbols = __webpack_require__(145),
    copySymbolsIn = __webpack_require__(146),
    getAllKeys = __webpack_require__(151),
    getAllKeysIn = __webpack_require__(59),
    getTag = __webpack_require__(153),
    initCloneArray = __webpack_require__(161),
    initCloneByTag = __webpack_require__(162),
    initCloneObject = __webpack_require__(61),
    isArray = __webpack_require__(2),
    isBuffer = __webpack_require__(35),
    isObject = __webpack_require__(3),
    keys = __webpack_require__(39);

/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1,
    CLONE_FLAT_FLAG = 2,
    CLONE_SYMBOLS_FLAG = 4;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values supported by `_.clone`. */
var cloneableTags = {};
cloneableTags[argsTag] = cloneableTags[arrayTag] =
cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =
cloneableTags[boolTag] = cloneableTags[dateTag] =
cloneableTags[float32Tag] = cloneableTags[float64Tag] =
cloneableTags[int8Tag] = cloneableTags[int16Tag] =
cloneableTags[int32Tag] = cloneableTags[mapTag] =
cloneableTags[numberTag] = cloneableTags[objectTag] =
cloneableTags[regexpTag] = cloneableTags[setTag] =
cloneableTags[stringTag] = cloneableTags[symbolTag] =
cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
cloneableTags[errorTag] = cloneableTags[funcTag] =
cloneableTags[weakMapTag] = false;

/**
 * The base implementation of `_.clone` and `_.cloneDeep` which tracks
 * traversed objects.
 *
 * @private
 * @param {*} value The value to clone.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Deep clone
 *  2 - Flatten inherited properties
 *  4 - Clone symbols
 * @param {Function} [customizer] The function to customize cloning.
 * @param {string} [key] The key of `value`.
 * @param {Object} [object] The parent object of `value`.
 * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
 * @returns {*} Returns the cloned value.
 */
function baseClone(value, bitmask, customizer, key, object, stack) {
  var result,
      isDeep = bitmask & CLONE_DEEP_FLAG,
      isFlat = bitmask & CLONE_FLAT_FLAG,
      isFull = bitmask & CLONE_SYMBOLS_FLAG;

  if (customizer) {
    result = object ? customizer(value, key, object, stack) : customizer(value);
  }
  if (result !== undefined) {
    return result;
  }
  if (!isObject(value)) {
    return value;
  }
  var isArr = isArray(value);
  if (isArr) {
    result = initCloneArray(value);
    if (!isDeep) {
      return copyArray(value, result);
    }
  } else {
    var tag = getTag(value),
        isFunc = tag == funcTag || tag == genTag;

    if (isBuffer(value)) {
      return cloneBuffer(value, isDeep);
    }
    if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
      result = (isFlat || isFunc) ? {} : initCloneObject(value);
      if (!isDeep) {
        return isFlat
          ? copySymbolsIn(value, baseAssignIn(result, value))
          : copySymbols(value, baseAssign(result, value));
      }
    } else {
      if (!cloneableTags[tag]) {
        return object ? value : {};
      }
      result = initCloneByTag(value, tag, baseClone, isDeep);
    }
  }
  // Check for circular references and return its corresponding clone.
  stack || (stack = new Stack);
  var stacked = stack.get(value);
  if (stacked) {
    return stacked;
  }
  stack.set(value, result);

  var keysFunc = isFull
    ? (isFlat ? getAllKeysIn : getAllKeys)
    : (isFlat ? keysIn : keys);

  var props = isArr ? undefined : keysFunc(value);
  arrayEach(props || value, function(subValue, key) {
    if (props) {
      key = subValue;
      subValue = value[key];
    }
    // Recursively populate clone (susceptible to call stack limits).
    assignValue(result, key, baseClone(subValue, bitmask, customizer, key, value, stack));
  });
  return result;
}

module.exports = baseClone;


/***/ },
/* 119 */
/***/ function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(3);

/** Built-in value references. */
var objectCreate = Object.create;

/**
 * The base implementation of `_.create` without support for assigning
 * properties to the created object.
 *
 * @private
 * @param {Object} proto The object to inherit from.
 * @returns {Object} Returns the new object.
 */
var baseCreate = (function() {
  function object() {}
  return function(proto) {
    if (!isObject(proto)) {
      return {};
    }
    if (objectCreate) {
      return objectCreate(proto);
    }
    object.prototype = proto;
    var result = new object;
    object.prototype = undefined;
    return result;
  };
}());

module.exports = baseCreate;


/***/ },
/* 120 */
/***/ function(module, exports, __webpack_require__) {

var arrayPush = __webpack_require__(28),
    isFlattenable = __webpack_require__(163);

/**
 * The base implementation of `_.flatten` with support for restricting flattening.
 *
 * @private
 * @param {Array} array The array to flatten.
 * @param {number} depth The maximum recursion depth.
 * @param {boolean} [predicate=isFlattenable] The function invoked per iteration.
 * @param {boolean} [isStrict] Restrict to values that pass `predicate` checks.
 * @param {Array} [result=[]] The initial result value.
 * @returns {Array} Returns the new flattened array.
 */
function baseFlatten(array, depth, predicate, isStrict, result) {
  var index = -1,
      length = array.length;

  predicate || (predicate = isFlattenable);
  result || (result = []);

  while (++index < length) {
    var value = array[index];
    if (depth > 0 && predicate(value)) {
      if (depth > 1) {
        // Recursively flatten arrays (susceptible to call stack limits).
        baseFlatten(value, depth - 1, predicate, isStrict, result);
      } else {
        arrayPush(result, value);
      }
    } else if (!isStrict) {
      result[result.length] = value;
    }
  }
  return result;
}

module.exports = baseFlatten;


/***/ },
/* 121 */
/***/ function(module, exports, __webpack_require__) {

var createBaseFor = __webpack_require__(149);

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

module.exports = baseFor;


/***/ },
/* 122 */
/***/ function(module, exports) {

/**
 * The base implementation of `_.hasIn` without support for deep paths.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {Array|string} key The key to check.
 * @returns {boolean} Returns `true` if `key` exists, else `false`.
 */
function baseHasIn(object, key) {
  return object != null && key in Object(object);
}

module.exports = baseHasIn;


/***/ },
/* 123 */
/***/ function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(6),
    isObjectLike = __webpack_require__(9);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

module.exports = baseIsArguments;


/***/ },
/* 124 */
/***/ function(module, exports, __webpack_require__) {

var isFunction = __webpack_require__(36),
    isMasked = __webpack_require__(167),
    isObject = __webpack_require__(3),
    toSource = __webpack_require__(65);

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

module.exports = baseIsNative;


/***/ },
/* 125 */
/***/ function(module, exports, __webpack_require__) {

var baseGetTag = __webpack_require__(6),
    isLength = __webpack_require__(37),
    isObjectLike = __webpack_require__(9);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

module.exports = baseIsTypedArray;


/***/ },
/* 126 */
/***/ function(module, exports, __webpack_require__) {

var isPrototype = __webpack_require__(34),
    nativeKeys = __webpack_require__(180);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

module.exports = baseKeys;


/***/ },
/* 127 */
/***/ function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(3),
    isPrototype = __webpack_require__(34),
    nativeKeysIn = __webpack_require__(181);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeysIn(object) {
  if (!isObject(object)) {
    return nativeKeysIn(object);
  }
  var isProto = isPrototype(object),
      result = [];

  for (var key in object) {
    if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = baseKeysIn;


/***/ },
/* 128 */
/***/ function(module, exports, __webpack_require__) {

var Stack = __webpack_require__(46),
    assignMergeValue = __webpack_require__(50),
    baseFor = __webpack_require__(121),
    baseMergeDeep = __webpack_require__(129),
    isObject = __webpack_require__(3),
    keysIn = __webpack_require__(24);

/**
 * The base implementation of `_.merge` without support for multiple sources.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} [customizer] The function to customize merged values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMerge(object, source, srcIndex, customizer, stack) {
  if (object === source) {
    return;
  }
  baseFor(source, function(srcValue, key) {
    if (isObject(srcValue)) {
      stack || (stack = new Stack);
      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
    }
    else {
      var newValue = customizer
        ? customizer(object[key], srcValue, (key + ''), object, source, stack)
        : undefined;

      if (newValue === undefined) {
        newValue = srcValue;
      }
      assignMergeValue(object, key, newValue);
    }
  }, keysIn);
}

module.exports = baseMerge;


/***/ },
/* 129 */
/***/ function(module, exports, __webpack_require__) {

var assignMergeValue = __webpack_require__(50),
    cloneBuffer = __webpack_require__(53),
    cloneTypedArray = __webpack_require__(54),
    copyArray = __webpack_require__(55),
    initCloneObject = __webpack_require__(61),
    isArguments = __webpack_require__(22),
    isArray = __webpack_require__(2),
    isArrayLikeObject = __webpack_require__(196),
    isBuffer = __webpack_require__(35),
    isFunction = __webpack_require__(36),
    isObject = __webpack_require__(3),
    isPlainObject = __webpack_require__(67),
    isTypedArray = __webpack_require__(68),
    toPlainObject = __webpack_require__(202);

/**
 * A specialized version of `baseMerge` for arrays and objects which performs
 * deep merges and tracks traversed objects enabling objects with circular
 * references to be merged.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {string} key The key of the value to merge.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} mergeFunc The function to merge values.
 * @param {Function} [customizer] The function to customize assigned values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
  var objValue = object[key],
      srcValue = source[key],
      stacked = stack.get(srcValue);

  if (stacked) {
    assignMergeValue(object, key, stacked);
    return;
  }
  var newValue = customizer
    ? customizer(objValue, srcValue, (key + ''), object, source, stack)
    : undefined;

  var isCommon = newValue === undefined;

  if (isCommon) {
    var isArr = isArray(srcValue),
        isBuff = !isArr && isBuffer(srcValue),
        isTyped = !isArr && !isBuff && isTypedArray(srcValue);

    newValue = srcValue;
    if (isArr || isBuff || isTyped) {
      if (isArray(objValue)) {
        newValue = objValue;
      }
      else if (isArrayLikeObject(objValue)) {
        newValue = copyArray(objValue);
      }
      else if (isBuff) {
        isCommon = false;
        newValue = cloneBuffer(srcValue, true);
      }
      else if (isTyped) {
        isCommon = false;
        newValue = cloneTypedArray(srcValue, true);
      }
      else {
        newValue = [];
      }
    }
    else if (isPlainObject(srcValue) || isArguments(srcValue)) {
      newValue = objValue;
      if (isArguments(objValue)) {
        newValue = toPlainObject(objValue);
      }
      else if (!isObject(objValue) || (srcIndex && isFunction(objValue))) {
        newValue = initCloneObject(srcValue);
      }
    }
    else {
      isCommon = false;
    }
  }
  if (isCommon) {
    // Recursively merge objects and arrays (susceptible to call stack limits).
    stack.set(srcValue, newValue);
    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
    stack['delete'](srcValue);
  }
  assignMergeValue(object, key, newValue);
}

module.exports = baseMergeDeep;


/***/ },
/* 130 */
/***/ function(module, exports, __webpack_require__) {

var basePickBy = __webpack_require__(131),
    hasIn = __webpack_require__(195);

/**
 * The base implementation of `_.pick` without support for individual
 * property identifiers.
 *
 * @private
 * @param {Object} object The source object.
 * @param {string[]} paths The property paths to pick.
 * @returns {Object} Returns the new object.
 */
function basePick(object, paths) {
  return basePickBy(object, paths, function(value, path) {
    return hasIn(object, path);
  });
}

module.exports = basePick;


/***/ },
/* 131 */
/***/ function(module, exports, __webpack_require__) {

var baseGet = __webpack_require__(51),
    baseSet = __webpack_require__(133),
    castPath = __webpack_require__(7);

/**
 * The base implementation of  `_.pickBy` without support for iteratee shorthands.
 *
 * @private
 * @param {Object} object The source object.
 * @param {string[]} paths The property paths to pick.
 * @param {Function} predicate The function invoked per property.
 * @returns {Object} Returns the new object.
 */
function basePickBy(object, paths, predicate) {
  var index = -1,
      length = paths.length,
      result = {};

  while (++index < length) {
    var path = paths[index],
        value = baseGet(object, path);

    if (predicate(value, path)) {
      baseSet(result, castPath(path, object), value);
    }
  }
  return result;
}

module.exports = basePickBy;


/***/ },
/* 132 */
/***/ function(module, exports, __webpack_require__) {

var identity = __webpack_require__(66),
    overRest = __webpack_require__(63),
    setToString = __webpack_require__(64);

/**
 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 */
function baseRest(func, start) {
  return setToString(overRest(func, start, identity), func + '');
}

module.exports = baseRest;


/***/ },
/* 133 */
/***/ function(module, exports, __webpack_require__) {

var assignValue = __webpack_require__(29),
    castPath = __webpack_require__(7),
    isIndex = __webpack_require__(18),
    isObject = __webpack_require__(3),
    toKey = __webpack_require__(20);

/**
 * The base implementation of `_.set`.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {Array|string} path The path of the property to set.
 * @param {*} value The value to set.
 * @param {Function} [customizer] The function to customize path creation.
 * @returns {Object} Returns `object`.
 */
function baseSet(object, path, value, customizer) {
  if (!isObject(object)) {
    return object;
  }
  path = castPath(path, object);

  var index = -1,
      length = path.length,
      lastIndex = length - 1,
      nested = object;

  while (nested != null && ++index < length) {
    var key = toKey(path[index]),
        newValue = value;

    if (index != lastIndex) {
      var objValue = nested[key];
      newValue = customizer ? customizer(objValue, key, nested) : undefined;
      if (newValue === undefined) {
        newValue = isObject(objValue)
          ? objValue
          : (isIndex(path[index + 1]) ? [] : {});
      }
    }
    assignValue(nested, key, newValue);
    nested = nested[key];
  }
  return object;
}

module.exports = baseSet;


/***/ },
/* 134 */
/***/ function(module, exports, __webpack_require__) {

var constant = __webpack_require__(193),
    defineProperty = __webpack_require__(56),
    identity = __webpack_require__(66);

/**
 * The base implementation of `setToString` without support for hot loop shorting.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var baseSetToString = !defineProperty ? identity : function(func, string) {
  return defineProperty(func, 'toString', {
    'configurable': true,
    'enumerable': false,
    'value': constant(string),
    'writable': true
  });
};

module.exports = baseSetToString;


/***/ },
/* 135 */
/***/ function(module, exports) {

/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */
function baseSlice(array, start, end) {
  var index = -1,
      length = array.length;

  if (start < 0) {
    start = -start > length ? 0 : (length + start);
  }
  end = end > length ? length : end;
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : ((end - start) >>> 0);
  start >>>= 0;

  var result = Array(length);
  while (++index < length) {
    result[index] = array[index + start];
  }
  return result;
}

module.exports = baseSlice;


/***/ },
/* 136 */
/***/ function(module, exports) {

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

module.exports = baseTimes;


/***/ },
/* 137 */
/***/ function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(12),
    arrayMap = __webpack_require__(48),
    isArray = __webpack_require__(2),
    isSymbol = __webpack_require__(38);

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isArray(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return arrayMap(value, baseToString) + '';
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

module.exports = baseToString;


/***/ },
/* 138 */
/***/ function(module, exports) {

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

module.exports = baseUnary;


/***/ },
/* 139 */
/***/ function(module, exports, __webpack_require__) {

var castPath = __webpack_require__(7),
    last = __webpack_require__(197),
    parent = __webpack_require__(184),
    toKey = __webpack_require__(20);

/**
 * The base implementation of `_.unset`.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {Array|string} path The property path to unset.
 * @returns {boolean} Returns `true` if the property is deleted, else `false`.
 */
function baseUnset(object, path) {
  path = castPath(path, object);
  object = parent(object, path);
  return object == null || delete object[toKey(last(path))];
}

module.exports = baseUnset;


/***/ },
/* 140 */
/***/ function(module, exports, __webpack_require__) {

var cloneArrayBuffer = __webpack_require__(31);

/**
 * Creates a clone of `dataView`.
 *
 * @private
 * @param {Object} dataView The data view to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned data view.
 */
function cloneDataView(dataView, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
  return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}

module.exports = cloneDataView;


/***/ },
/* 141 */
/***/ function(module, exports, __webpack_require__) {

var addMapEntry = __webpack_require__(111),
    arrayReduce = __webpack_require__(49),
    mapToArray = __webpack_require__(178);

/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1;

/**
 * Creates a clone of `map`.
 *
 * @private
 * @param {Object} map The map to clone.
 * @param {Function} cloneFunc The function to clone values.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned map.
 */
function cloneMap(map, isDeep, cloneFunc) {
  var array = isDeep ? cloneFunc(mapToArray(map), CLONE_DEEP_FLAG) : mapToArray(map);
  return arrayReduce(array, addMapEntry, new map.constructor);
}

module.exports = cloneMap;


/***/ },
/* 142 */
/***/ function(module, exports) {

/** Used to match `RegExp` flags from their coerced string values. */
var reFlags = /\w*$/;

/**
 * Creates a clone of `regexp`.
 *
 * @private
 * @param {Object} regexp The regexp to clone.
 * @returns {Object} Returns the cloned regexp.
 */
function cloneRegExp(regexp) {
  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
  result.lastIndex = regexp.lastIndex;
  return result;
}

module.exports = cloneRegExp;


/***/ },
/* 143 */
/***/ function(module, exports, __webpack_require__) {

var addSetEntry = __webpack_require__(112),
    arrayReduce = __webpack_require__(49),
    setToArray = __webpack_require__(185);

/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1;

/**
 * Creates a clone of `set`.
 *
 * @private
 * @param {Object} set The set to clone.
 * @param {Function} cloneFunc The function to clone values.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned set.
 */
function cloneSet(set, isDeep, cloneFunc) {
  var array = isDeep ? cloneFunc(setToArray(set), CLONE_DEEP_FLAG) : setToArray(set);
  return arrayReduce(array, addSetEntry, new set.constructor);
}

module.exports = cloneSet;


/***/ },
/* 144 */
/***/ function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(12);

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * Creates a clone of the `symbol` object.
 *
 * @private
 * @param {Object} symbol The symbol object to clone.
 * @returns {Object} Returns the cloned symbol object.
 */
function cloneSymbol(symbol) {
  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
}

module.exports = cloneSymbol;


/***/ },
/* 145 */
/***/ function(module, exports, __webpack_require__) {

var copyObject = __webpack_require__(8),
    getSymbols = __webpack_require__(33);

/**
 * Copies own symbols of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy symbols from.
 * @param {Object} [object={}] The object to copy symbols to.
 * @returns {Object} Returns `object`.
 */
function copySymbols(source, object) {
  return copyObject(source, getSymbols(source), object);
}

module.exports = copySymbols;


/***/ },
/* 146 */
/***/ function(module, exports, __webpack_require__) {

var copyObject = __webpack_require__(8),
    getSymbolsIn = __webpack_require__(60);

/**
 * Copies own and inherited symbols of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy symbols from.
 * @param {Object} [object={}] The object to copy symbols to.
 * @returns {Object} Returns `object`.
 */
function copySymbolsIn(source, object) {
  return copyObject(source, getSymbolsIn(source), object);
}

module.exports = copySymbolsIn;


/***/ },
/* 147 */
/***/ function(module, exports, __webpack_require__) {

var root = __webpack_require__(1);

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

module.exports = coreJsData;


/***/ },
/* 148 */
/***/ function(module, exports, __webpack_require__) {

var baseRest = __webpack_require__(132),
    isIterateeCall = __webpack_require__(164);

/**
 * Creates a function like `_.assign`.
 *
 * @private
 * @param {Function} assigner The function to assign values.
 * @returns {Function} Returns the new assigner function.
 */
function createAssigner(assigner) {
  return baseRest(function(object, sources) {
    var index = -1,
        length = sources.length,
        customizer = length > 1 ? sources[length - 1] : undefined,
        guard = length > 2 ? sources[2] : undefined;

    customizer = (assigner.length > 3 && typeof customizer == 'function')
      ? (length--, customizer)
      : undefined;

    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? undefined : customizer;
      length = 1;
    }
    object = Object(object);
    while (++index < length) {
      var source = sources[index];
      if (source) {
        assigner(object, source, index, customizer);
      }
    }
    return object;
  });
}

module.exports = createAssigner;


/***/ },
/* 149 */
/***/ function(module, exports) {

/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index = -1,
        iterable = Object(object),
        props = keysFunc(object),
        length = props.length;

    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

module.exports = createBaseFor;


/***/ },
/* 150 */
/***/ function(module, exports, __webpack_require__) {

var isPlainObject = __webpack_require__(67);

/**
 * Used by `_.omit` to customize its `_.cloneDeep` use to only clone plain
 * objects.
 *
 * @private
 * @param {*} value The value to inspect.
 * @param {string} key The key of the property to inspect.
 * @returns {*} Returns the uncloned value or `undefined` to defer cloning to `_.cloneDeep`.
 */
function customOmitClone(value) {
  return isPlainObject(value) ? undefined : value;
}

module.exports = customOmitClone;


/***/ },
/* 151 */
/***/ function(module, exports, __webpack_require__) {

var baseGetAllKeys = __webpack_require__(52),
    getSymbols = __webpack_require__(33),
    keys = __webpack_require__(39);

/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return baseGetAllKeys(object, keys, getSymbols);
}

module.exports = getAllKeys;


/***/ },
/* 152 */
/***/ function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(12);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

module.exports = getRawTag;


/***/ },
/* 153 */
/***/ function(module, exports, __webpack_require__) {

var DataView = __webpack_require__(105),
    Map = __webpack_require__(27),
    Promise = __webpack_require__(107),
    Set = __webpack_require__(108),
    WeakMap = __webpack_require__(110),
    baseGetTag = __webpack_require__(6),
    toSource = __webpack_require__(65);

/** `Object#toString` result references. */
var mapTag = '[object Map]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    setTag = '[object Set]',
    weakMapTag = '[object WeakMap]';

var dataViewTag = '[object DataView]';

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map && getTag(new Map) != mapTag) ||
    (Promise && getTag(Promise.resolve()) != promiseTag) ||
    (Set && getTag(new Set) != setTag) ||
    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = baseGetTag(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

module.exports = getTag;


/***/ },
/* 154 */
/***/ function(module, exports) {

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

module.exports = getValue;


/***/ },
/* 155 */
/***/ function(module, exports, __webpack_require__) {

var castPath = __webpack_require__(7),
    isArguments = __webpack_require__(22),
    isArray = __webpack_require__(2),
    isIndex = __webpack_require__(18),
    isLength = __webpack_require__(37),
    toKey = __webpack_require__(20);

/**
 * Checks if `path` exists on `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @param {Function} hasFunc The function to check properties.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 */
function hasPath(object, path, hasFunc) {
  path = castPath(path, object);

  var index = -1,
      length = path.length,
      result = false;

  while (++index < length) {
    var key = toKey(path[index]);
    if (!(result = object != null && hasFunc(object, key))) {
      break;
    }
    object = object[key];
  }
  if (result || ++index != length) {
    return result;
  }
  length = object == null ? 0 : object.length;
  return !!length && isLength(length) && isIndex(key, length) &&
    (isArray(object) || isArguments(object));
}

module.exports = hasPath;


/***/ },
/* 156 */
/***/ function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(19);

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  this.size = 0;
}

module.exports = hashClear;


/***/ },
/* 157 */
/***/ function(module, exports) {

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = hashDelete;


/***/ },
/* 158 */
/***/ function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(19);

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

module.exports = hashGet;


/***/ },
/* 159 */
/***/ function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(19);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
}

module.exports = hashHas;


/***/ },
/* 160 */
/***/ function(module, exports, __webpack_require__) {

var nativeCreate = __webpack_require__(19);

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

module.exports = hashSet;


/***/ },
/* 161 */
/***/ function(module, exports) {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Initializes an array clone.
 *
 * @private
 * @param {Array} array The array to clone.
 * @returns {Array} Returns the initialized clone.
 */
function initCloneArray(array) {
  var length = array.length,
      result = array.constructor(length);

  // Add properties assigned by `RegExp#exec`.
  if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
    result.index = array.index;
    result.input = array.input;
  }
  return result;
}

module.exports = initCloneArray;


/***/ },
/* 162 */
/***/ function(module, exports, __webpack_require__) {

var cloneArrayBuffer = __webpack_require__(31),
    cloneDataView = __webpack_require__(140),
    cloneMap = __webpack_require__(141),
    cloneRegExp = __webpack_require__(142),
    cloneSet = __webpack_require__(143),
    cloneSymbol = __webpack_require__(144),
    cloneTypedArray = __webpack_require__(54);

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/**
 * Initializes an object clone based on its `toStringTag`.
 *
 * **Note:** This function only supports cloning values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to clone.
 * @param {string} tag The `toStringTag` of the object to clone.
 * @param {Function} cloneFunc The function to clone values.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneByTag(object, tag, cloneFunc, isDeep) {
  var Ctor = object.constructor;
  switch (tag) {
    case arrayBufferTag:
      return cloneArrayBuffer(object);

    case boolTag:
    case dateTag:
      return new Ctor(+object);

    case dataViewTag:
      return cloneDataView(object, isDeep);

    case float32Tag: case float64Tag:
    case int8Tag: case int16Tag: case int32Tag:
    case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
      return cloneTypedArray(object, isDeep);

    case mapTag:
      return cloneMap(object, isDeep, cloneFunc);

    case numberTag:
    case stringTag:
      return new Ctor(object);

    case regexpTag:
      return cloneRegExp(object);

    case setTag:
      return cloneSet(object, isDeep, cloneFunc);

    case symbolTag:
      return cloneSymbol(object);
  }
}

module.exports = initCloneByTag;


/***/ },
/* 163 */
/***/ function(module, exports, __webpack_require__) {

var Symbol = __webpack_require__(12),
    isArguments = __webpack_require__(22),
    isArray = __webpack_require__(2);

/** Built-in value references. */
var spreadableSymbol = Symbol ? Symbol.isConcatSpreadable : undefined;

/**
 * Checks if `value` is a flattenable `arguments` object or array.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is flattenable, else `false`.
 */
function isFlattenable(value) {
  return isArray(value) || isArguments(value) ||
    !!(spreadableSymbol && value && value[spreadableSymbol]);
}

module.exports = isFlattenable;


/***/ },
/* 164 */
/***/ function(module, exports, __webpack_require__) {

var eq = __webpack_require__(21),
    isArrayLike = __webpack_require__(23),
    isIndex = __webpack_require__(18),
    isObject = __webpack_require__(3);

/**
 * Checks if the given arguments are from an iteratee call.
 *
 * @private
 * @param {*} value The potential iteratee value argument.
 * @param {*} index The potential iteratee index or key argument.
 * @param {*} object The potential iteratee object argument.
 * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
 *  else `false`.
 */
function isIterateeCall(value, index, object) {
  if (!isObject(object)) {
    return false;
  }
  var type = typeof index;
  if (type == 'number'
        ? (isArrayLike(object) && isIndex(index, object.length))
        : (type == 'string' && index in object)
      ) {
    return eq(object[index], value);
  }
  return false;
}

module.exports = isIterateeCall;


/***/ },
/* 165 */
/***/ function(module, exports, __webpack_require__) {

var isArray = __webpack_require__(2),
    isSymbol = __webpack_require__(38);

/** Used to match property names within property paths. */
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    reIsPlainProp = /^\w*$/;

/**
 * Checks if `value` is a property name and not a property path.
 *
 * @private
 * @param {*} value The value to check.
 * @param {Object} [object] The object to query keys on.
 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
 */
function isKey(value, object) {
  if (isArray(value)) {
    return false;
  }
  var type = typeof value;
  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
      value == null || isSymbol(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
    (object != null && value in Object(object));
}

module.exports = isKey;


/***/ },
/* 166 */
/***/ function(module, exports) {

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

module.exports = isKeyable;


/***/ },
/* 167 */
/***/ function(module, exports, __webpack_require__) {

var coreJsData = __webpack_require__(147);

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

module.exports = isMasked;


/***/ },
/* 168 */
/***/ function(module, exports) {

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

module.exports = listCacheClear;


/***/ },
/* 169 */
/***/ function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(16);

/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

module.exports = listCacheDelete;


/***/ },
/* 170 */
/***/ function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(16);

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

module.exports = listCacheGet;


/***/ },
/* 171 */
/***/ function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(16);

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

module.exports = listCacheHas;


/***/ },
/* 172 */
/***/ function(module, exports, __webpack_require__) {

var assocIndexOf = __webpack_require__(16);

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

module.exports = listCacheSet;


/***/ },
/* 173 */
/***/ function(module, exports, __webpack_require__) {

var Hash = __webpack_require__(106),
    ListCache = __webpack_require__(15),
    Map = __webpack_require__(27);

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map || ListCache),
    'string': new Hash
  };
}

module.exports = mapCacheClear;


/***/ },
/* 174 */
/***/ function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(17);

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = mapCacheDelete;


/***/ },
/* 175 */
/***/ function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(17);

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

module.exports = mapCacheGet;


/***/ },
/* 176 */
/***/ function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(17);

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

module.exports = mapCacheHas;


/***/ },
/* 177 */
/***/ function(module, exports, __webpack_require__) {

var getMapData = __webpack_require__(17);

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

module.exports = mapCacheSet;


/***/ },
/* 178 */
/***/ function(module, exports) {

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

module.exports = mapToArray;


/***/ },
/* 179 */
/***/ function(module, exports, __webpack_require__) {

var memoize = __webpack_require__(198);

/** Used as the maximum memoize cache size. */
var MAX_MEMOIZE_SIZE = 500;

/**
 * A specialized version of `_.memoize` which clears the memoized function's
 * cache when it exceeds `MAX_MEMOIZE_SIZE`.
 *
 * @private
 * @param {Function} func The function to have its output memoized.
 * @returns {Function} Returns the new memoized function.
 */
function memoizeCapped(func) {
  var result = memoize(func, function(key) {
    if (cache.size === MAX_MEMOIZE_SIZE) {
      cache.clear();
    }
    return key;
  });

  var cache = result.cache;
  return result;
}

module.exports = memoizeCapped;


/***/ },
/* 180 */
/***/ function(module, exports, __webpack_require__) {

var overArg = __webpack_require__(62);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = overArg(Object.keys, Object);

module.exports = nativeKeys;


/***/ },
/* 181 */
/***/ function(module, exports) {

/**
 * This function is like
 * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * except that it includes inherited enumerable properties.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function nativeKeysIn(object) {
  var result = [];
  if (object != null) {
    for (var key in Object(object)) {
      result.push(key);
    }
  }
  return result;
}

module.exports = nativeKeysIn;


/***/ },
/* 182 */
/***/ function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(module) {var freeGlobal = __webpack_require__(58);

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports && freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

module.exports = nodeUtil;

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(41)(module)))

/***/ },
/* 183 */
/***/ function(module, exports) {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

module.exports = objectToString;


/***/ },
/* 184 */
/***/ function(module, exports, __webpack_require__) {

var baseGet = __webpack_require__(51),
    baseSlice = __webpack_require__(135);

/**
 * Gets the parent value at `path` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Array} path The path to get the parent value of.
 * @returns {*} Returns the parent value.
 */
function parent(object, path) {
  return path.length < 2 ? object : baseGet(object, baseSlice(path, 0, -1));
}

module.exports = parent;


/***/ },
/* 185 */
/***/ function(module, exports) {

/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

module.exports = setToArray;


/***/ },
/* 186 */
/***/ function(module, exports) {

/** Used to detect hot functions by number of calls within a span of milliseconds. */
var HOT_COUNT = 800,
    HOT_SPAN = 16;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeNow = Date.now;

/**
 * Creates a function that'll short out and invoke `identity` instead
 * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
 * milliseconds.
 *
 * @private
 * @param {Function} func The function to restrict.
 * @returns {Function} Returns the new shortable function.
 */
function shortOut(func) {
  var count = 0,
      lastCalled = 0;

  return function() {
    var stamp = nativeNow(),
        remaining = HOT_SPAN - (stamp - lastCalled);

    lastCalled = stamp;
    if (remaining > 0) {
      if (++count >= HOT_COUNT) {
        return arguments[0];
      }
    } else {
      count = 0;
    }
    return func.apply(undefined, arguments);
  };
}

module.exports = shortOut;


/***/ },
/* 187 */
/***/ function(module, exports, __webpack_require__) {

var ListCache = __webpack_require__(15);

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
  this.size = 0;
}

module.exports = stackClear;


/***/ },
/* 188 */
/***/ function(module, exports) {

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

module.exports = stackDelete;


/***/ },
/* 189 */
/***/ function(module, exports) {

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

module.exports = stackGet;


/***/ },
/* 190 */
/***/ function(module, exports) {

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

module.exports = stackHas;


/***/ },
/* 191 */
/***/ function(module, exports, __webpack_require__) {

var ListCache = __webpack_require__(15),
    Map = __webpack_require__(27),
    MapCache = __webpack_require__(45);

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof ListCache) {
    var pairs = data.__data__;
    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

module.exports = stackSet;


/***/ },
/* 192 */
/***/ function(module, exports, __webpack_require__) {

var memoizeCapped = __webpack_require__(179);

/** Used to match property names within property paths. */
var reLeadingDot = /^\./,
    rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

/** Used to match backslashes in property paths. */
var reEscapeChar = /\\(\\)?/g;

/**
 * Converts `string` to a property path array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the property path array.
 */
var stringToPath = memoizeCapped(function(string) {
  var result = [];
  if (reLeadingDot.test(string)) {
    result.push('');
  }
  string.replace(rePropName, function(match, number, quote, string) {
    result.push(quote ? string.replace(reEscapeChar, '$1') : (number || match));
  });
  return result;
});

module.exports = stringToPath;


/***/ },
/* 193 */
/***/ function(module, exports) {

/**
 * Creates a function that returns `value`.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {*} value The value to return from the new function.
 * @returns {Function} Returns the new constant function.
 * @example
 *
 * var objects = _.times(2, _.constant({ 'a': 1 }));
 *
 * console.log(objects);
 * // => [{ 'a': 1 }, { 'a': 1 }]
 *
 * console.log(objects[0] === objects[1]);
 * // => true
 */
function constant(value) {
  return function() {
    return value;
  };
}

module.exports = constant;


/***/ },
/* 194 */
/***/ function(module, exports, __webpack_require__) {

var baseFlatten = __webpack_require__(120);

/**
 * Flattens `array` a single level deep.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Array
 * @param {Array} array The array to flatten.
 * @returns {Array} Returns the new flattened array.
 * @example
 *
 * _.flatten([1, [2, [3, [4]], 5]]);
 * // => [1, 2, [3, [4]], 5]
 */
function flatten(array) {
  var length = array == null ? 0 : array.length;
  return length ? baseFlatten(array, 1) : [];
}

module.exports = flatten;


/***/ },
/* 195 */
/***/ function(module, exports, __webpack_require__) {

var baseHasIn = __webpack_require__(122),
    hasPath = __webpack_require__(155);

/**
 * Checks if `path` is a direct or inherited property of `object`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path to check.
 * @returns {boolean} Returns `true` if `path` exists, else `false`.
 * @example
 *
 * var object = _.create({ 'a': _.create({ 'b': 2 }) });
 *
 * _.hasIn(object, 'a');
 * // => true
 *
 * _.hasIn(object, 'a.b');
 * // => true
 *
 * _.hasIn(object, ['a', 'b']);
 * // => true
 *
 * _.hasIn(object, 'b');
 * // => false
 */
function hasIn(object, path) {
  return object != null && hasPath(object, path, baseHasIn);
}

module.exports = hasIn;


/***/ },
/* 196 */
/***/ function(module, exports, __webpack_require__) {

var isArrayLike = __webpack_require__(23),
    isObjectLike = __webpack_require__(9);

/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */
function isArrayLikeObject(value) {
  return isObjectLike(value) && isArrayLike(value);
}

module.exports = isArrayLikeObject;


/***/ },
/* 197 */
/***/ function(module, exports) {

/**
 * Gets the last element of `array`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Array
 * @param {Array} array The array to query.
 * @returns {*} Returns the last element of `array`.
 * @example
 *
 * _.last([1, 2, 3]);
 * // => 3
 */
function last(array) {
  var length = array == null ? 0 : array.length;
  return length ? array[length - 1] : undefined;
}

module.exports = last;


/***/ },
/* 198 */
/***/ function(module, exports, __webpack_require__) {

var MapCache = __webpack_require__(45);

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that memoizes the result of `func`. If `resolver` is
 * provided, it determines the cache key for storing the result based on the
 * arguments provided to the memoized function. By default, the first argument
 * provided to the memoized function is used as the map cache key. The `func`
 * is invoked with the `this` binding of the memoized function.
 *
 * **Note:** The cache is exposed as the `cache` property on the memoized
 * function. Its creation may be customized by replacing the `_.memoize.Cache`
 * constructor with one whose instances implement the
 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
 * method interface of `clear`, `delete`, `get`, `has`, and `set`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to have its output memoized.
 * @param {Function} [resolver] The function to resolve the cache key.
 * @returns {Function} Returns the new memoized function.
 * @example
 *
 * var object = { 'a': 1, 'b': 2 };
 * var other = { 'c': 3, 'd': 4 };
 *
 * var values = _.memoize(_.values);
 * values(object);
 * // => [1, 2]
 *
 * values(other);
 * // => [3, 4]
 *
 * object.a = 2;
 * values(object);
 * // => [1, 2]
 *
 * // Modify the result cache.
 * values.cache.set(object, ['a', 'b']);
 * values(object);
 * // => ['a', 'b']
 *
 * // Replace `_.memoize.Cache`.
 * _.memoize.Cache = WeakMap;
 */
function memoize(func, resolver) {
  if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments,
        key = resolver ? resolver.apply(this, args) : args[0],
        cache = memoized.cache;

    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result) || cache;
    return result;
  };
  memoized.cache = new (memoize.Cache || MapCache);
  return memoized;
}

// Expose `MapCache`.
memoize.Cache = MapCache;

module.exports = memoize;


/***/ },
/* 199 */
/***/ function(module, exports, __webpack_require__) {

var arrayMap = __webpack_require__(48),
    baseClone = __webpack_require__(118),
    baseUnset = __webpack_require__(139),
    castPath = __webpack_require__(7),
    copyObject = __webpack_require__(8),
    customOmitClone = __webpack_require__(150),
    flatRest = __webpack_require__(57),
    getAllKeysIn = __webpack_require__(59);

/** Used to compose bitmasks for cloning. */
var CLONE_DEEP_FLAG = 1,
    CLONE_FLAT_FLAG = 2,
    CLONE_SYMBOLS_FLAG = 4;

/**
 * The opposite of `_.pick`; this method creates an object composed of the
 * own and inherited enumerable property paths of `object` that are not omitted.
 *
 * **Note:** This method is considerably slower than `_.pick`.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The source object.
 * @param {...(string|string[])} [paths] The property paths to omit.
 * @returns {Object} Returns the new object.
 * @example
 *
 * var object = { 'a': 1, 'b': '2', 'c': 3 };
 *
 * _.omit(object, ['a', 'c']);
 * // => { 'b': '2' }
 */
var omit = flatRest(function(object, paths) {
  var result = {};
  if (object == null) {
    return result;
  }
  var isDeep = false;
  paths = arrayMap(paths, function(path) {
    path = castPath(path, object);
    isDeep || (isDeep = path.length > 1);
    return path;
  });
  copyObject(object, getAllKeysIn(object), result);
  if (isDeep) {
    result = baseClone(result, CLONE_DEEP_FLAG | CLONE_FLAT_FLAG | CLONE_SYMBOLS_FLAG, customOmitClone);
  }
  var length = paths.length;
  while (length--) {
    baseUnset(result, paths[length]);
  }
  return result;
});

module.exports = omit;


/***/ },
/* 200 */
/***/ function(module, exports, __webpack_require__) {

var basePick = __webpack_require__(130),
    flatRest = __webpack_require__(57);

/**
 * Creates an object composed of the picked `object` properties.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The source object.
 * @param {...(string|string[])} [paths] The property paths to pick.
 * @returns {Object} Returns the new object.
 * @example
 *
 * var object = { 'a': 1, 'b': '2', 'c': 3 };
 *
 * _.pick(object, ['a', 'c']);
 * // => { 'a': 1, 'c': 3 }
 */
var pick = flatRest(function(object, paths) {
  return object == null ? {} : basePick(object, paths);
});

module.exports = pick;


/***/ },
/* 201 */
/***/ function(module, exports) {

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = stubFalse;


/***/ },
/* 202 */
/***/ function(module, exports, __webpack_require__) {

var copyObject = __webpack_require__(8),
    keysIn = __webpack_require__(24);

/**
 * Converts `value` to a plain object flattening inherited enumerable string
 * keyed properties of `value` to own properties of the plain object.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {Object} Returns the converted plain object.
 * @example
 *
 * function Foo() {
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.assign({ 'a': 1 }, new Foo);
 * // => { 'a': 1, 'b': 2 }
 *
 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
 * // => { 'a': 1, 'b': 2, 'c': 3 }
 */
function toPlainObject(value) {
  return copyObject(value, keysIn(value));
}

module.exports = toPlainObject;


/***/ },
/* 203 */
/***/ function(module, exports, __webpack_require__) {

var baseToString = __webpack_require__(137);

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

module.exports = toString;


/***/ },
/* 204 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
 /* eslint-env node */


// SDP helpers.
var SDPUtils = {};

// Generate an alphanumeric identifier for cname or mids.
// TODO: use UUIDs instead? https://gist.github.com/jed/982883
SDPUtils.generateIdentifier = function() {
  return Math.random().toString(36).substr(2, 10);
};

// The RTCP CNAME used by all peerconnections from the same JS.
SDPUtils.localCName = SDPUtils.generateIdentifier();

// Splits SDP into lines, dealing with both CRLF and LF.
SDPUtils.splitLines = function(blob) {
  return blob.trim().split('\n').map(function(line) {
    return line.trim();
  });
};
// Splits SDP into sessionpart and mediasections. Ensures CRLF.
SDPUtils.splitSections = function(blob) {
  var parts = blob.split('\nm=');
  return parts.map(function(part, index) {
    return (index > 0 ? 'm=' + part : part).trim() + '\r\n';
  });
};

// Returns lines that start with a certain prefix.
SDPUtils.matchPrefix = function(blob, prefix) {
  return SDPUtils.splitLines(blob).filter(function(line) {
    return line.indexOf(prefix) === 0;
  });
};

// Parses an ICE candidate line. Sample input:
// candidate:702786350 2 udp 41819902 8.8.8.8 60769 typ relay raddr 8.8.8.8
// rport 55996"
SDPUtils.parseCandidate = function(line) {
  var parts;
  // Parse both variants.
  if (line.indexOf('a=candidate:') === 0) {
    parts = line.substring(12).split(' ');
  } else {
    parts = line.substring(10).split(' ');
  }

  var candidate = {
    foundation: parts[0],
    component: parts[1],
    protocol: parts[2].toLowerCase(),
    priority: parseInt(parts[3], 10),
    ip: parts[4],
    port: parseInt(parts[5], 10),
    // skip parts[6] == 'typ'
    type: parts[7]
  };

  for (var i = 8; i < parts.length; i += 2) {
    switch (parts[i]) {
      case 'raddr':
        candidate.relatedAddress = parts[i + 1];
        break;
      case 'rport':
        candidate.relatedPort = parseInt(parts[i + 1], 10);
        break;
      case 'tcptype':
        candidate.tcpType = parts[i + 1];
        break;
      default: // Unknown extensions are silently ignored.
        break;
    }
  }
  return candidate;
};

// Translates a candidate object into SDP candidate attribute.
SDPUtils.writeCandidate = function(candidate) {
  var sdp = [];
  sdp.push(candidate.foundation);
  sdp.push(candidate.component);
  sdp.push(candidate.protocol.toUpperCase());
  sdp.push(candidate.priority);
  sdp.push(candidate.ip);
  sdp.push(candidate.port);

  var type = candidate.type;
  sdp.push('typ');
  sdp.push(type);
  if (type !== 'host' && candidate.relatedAddress &&
      candidate.relatedPort) {
    sdp.push('raddr');
    sdp.push(candidate.relatedAddress); // was: relAddr
    sdp.push('rport');
    sdp.push(candidate.relatedPort); // was: relPort
  }
  if (candidate.tcpType && candidate.protocol.toLowerCase() === 'tcp') {
    sdp.push('tcptype');
    sdp.push(candidate.tcpType);
  }
  return 'candidate:' + sdp.join(' ');
};

// Parses an rtpmap line, returns RTCRtpCoddecParameters. Sample input:
// a=rtpmap:111 opus/48000/2
SDPUtils.parseRtpMap = function(line) {
  var parts = line.substr(9).split(' ');
  var parsed = {
    payloadType: parseInt(parts.shift(), 10) // was: id
  };

  parts = parts[0].split('/');

  parsed.name = parts[0];
  parsed.clockRate = parseInt(parts[1], 10); // was: clockrate
  // was: channels
  parsed.numChannels = parts.length === 3 ? parseInt(parts[2], 10) : 1;
  return parsed;
};

// Generate an a=rtpmap line from RTCRtpCodecCapability or
// RTCRtpCodecParameters.
SDPUtils.writeRtpMap = function(codec) {
  var pt = codec.payloadType;
  if (codec.preferredPayloadType !== undefined) {
    pt = codec.preferredPayloadType;
  }
  return 'a=rtpmap:' + pt + ' ' + codec.name + '/' + codec.clockRate +
      (codec.numChannels !== 1 ? '/' + codec.numChannels : '') + '\r\n';
};

// Parses an a=extmap line (headerextension from RFC 5285). Sample input:
// a=extmap:2 urn:ietf:params:rtp-hdrext:toffset
SDPUtils.parseExtmap = function(line) {
  var parts = line.substr(9).split(' ');
  return {
    id: parseInt(parts[0], 10),
    uri: parts[1]
  };
};

// Generates a=extmap line from RTCRtpHeaderExtensionParameters or
// RTCRtpHeaderExtension.
SDPUtils.writeExtmap = function(headerExtension) {
  return 'a=extmap:' + (headerExtension.id || headerExtension.preferredId) +
       ' ' + headerExtension.uri + '\r\n';
};

// Parses an ftmp line, returns dictionary. Sample input:
// a=fmtp:96 vbr=on;cng=on
// Also deals with vbr=on; cng=on
SDPUtils.parseFmtp = function(line) {
  var parsed = {};
  var kv;
  var parts = line.substr(line.indexOf(' ') + 1).split(';');
  for (var j = 0; j < parts.length; j++) {
    kv = parts[j].trim().split('=');
    parsed[kv[0].trim()] = kv[1];
  }
  return parsed;
};

// Generates an a=ftmp line from RTCRtpCodecCapability or RTCRtpCodecParameters.
SDPUtils.writeFmtp = function(codec) {
  var line = '';
  var pt = codec.payloadType;
  if (codec.preferredPayloadType !== undefined) {
    pt = codec.preferredPayloadType;
  }
  if (codec.parameters && Object.keys(codec.parameters).length) {
    var params = [];
    Object.keys(codec.parameters).forEach(function(param) {
      params.push(param + '=' + codec.parameters[param]);
    });
    line += 'a=fmtp:' + pt + ' ' + params.join(';') + '\r\n';
  }
  return line;
};

// Parses an rtcp-fb line, returns RTCPRtcpFeedback object. Sample input:
// a=rtcp-fb:98 nack rpsi
SDPUtils.parseRtcpFb = function(line) {
  var parts = line.substr(line.indexOf(' ') + 1).split(' ');
  return {
    type: parts.shift(),
    parameter: parts.join(' ')
  };
};
// Generate a=rtcp-fb lines from RTCRtpCodecCapability or RTCRtpCodecParameters.
SDPUtils.writeRtcpFb = function(codec) {
  var lines = '';
  var pt = codec.payloadType;
  if (codec.preferredPayloadType !== undefined) {
    pt = codec.preferredPayloadType;
  }
  if (codec.rtcpFeedback && codec.rtcpFeedback.length) {
    // FIXME: special handling for trr-int?
    codec.rtcpFeedback.forEach(function(fb) {
      lines += 'a=rtcp-fb:' + pt + ' ' + fb.type +
      (fb.parameter && fb.parameter.length ? ' ' + fb.parameter : '') +
          '\r\n';
    });
  }
  return lines;
};

// Parses an RFC 5576 ssrc media attribute. Sample input:
// a=ssrc:3735928559 cname:something
SDPUtils.parseSsrcMedia = function(line) {
  var sp = line.indexOf(' ');
  var parts = {
    ssrc: parseInt(line.substr(7, sp - 7), 10)
  };
  var colon = line.indexOf(':', sp);
  if (colon > -1) {
    parts.attribute = line.substr(sp + 1, colon - sp - 1);
    parts.value = line.substr(colon + 1);
  } else {
    parts.attribute = line.substr(sp + 1);
  }
  return parts;
};

// Extracts DTLS parameters from SDP media section or sessionpart.
// FIXME: for consistency with other functions this should only
//   get the fingerprint line as input. See also getIceParameters.
SDPUtils.getDtlsParameters = function(mediaSection, sessionpart) {
  var lines = SDPUtils.splitLines(mediaSection);
  // Search in session part, too.
  lines = lines.concat(SDPUtils.splitLines(sessionpart));
  var fpLine = lines.filter(function(line) {
    return line.indexOf('a=fingerprint:') === 0;
  })[0].substr(14);
  // Note: a=setup line is ignored since we use the 'auto' role.
  var dtlsParameters = {
    role: 'auto',
    fingerprints: [{
      algorithm: fpLine.split(' ')[0],
      value: fpLine.split(' ')[1]
    }]
  };
  return dtlsParameters;
};

// Serializes DTLS parameters to SDP.
SDPUtils.writeDtlsParameters = function(params, setupType) {
  var sdp = 'a=setup:' + setupType + '\r\n';
  params.fingerprints.forEach(function(fp) {
    sdp += 'a=fingerprint:' + fp.algorithm + ' ' + fp.value + '\r\n';
  });
  return sdp;
};
// Parses ICE information from SDP media section or sessionpart.
// FIXME: for consistency with other functions this should only
//   get the ice-ufrag and ice-pwd lines as input.
SDPUtils.getIceParameters = function(mediaSection, sessionpart) {
  var lines = SDPUtils.splitLines(mediaSection);
  // Search in session part, too.
  lines = lines.concat(SDPUtils.splitLines(sessionpart));
  var iceParameters = {
    usernameFragment: lines.filter(function(line) {
      return line.indexOf('a=ice-ufrag:') === 0;
    })[0].substr(12),
    password: lines.filter(function(line) {
      return line.indexOf('a=ice-pwd:') === 0;
    })[0].substr(10)
  };
  return iceParameters;
};

// Serializes ICE parameters to SDP.
SDPUtils.writeIceParameters = function(params) {
  return 'a=ice-ufrag:' + params.usernameFragment + '\r\n' +
      'a=ice-pwd:' + params.password + '\r\n';
};

// Parses the SDP media section and returns RTCRtpParameters.
SDPUtils.parseRtpParameters = function(mediaSection) {
  var description = {
    codecs: [],
    headerExtensions: [],
    fecMechanisms: [],
    rtcp: []
  };
  var lines = SDPUtils.splitLines(mediaSection);
  var mline = lines[0].split(' ');
  for (var i = 3; i < mline.length; i++) { // find all codecs from mline[3..]
    var pt = mline[i];
    var rtpmapline = SDPUtils.matchPrefix(
        mediaSection, 'a=rtpmap:' + pt + ' ')[0];
    if (rtpmapline) {
      var codec = SDPUtils.parseRtpMap(rtpmapline);
      var fmtps = SDPUtils.matchPrefix(
          mediaSection, 'a=fmtp:' + pt + ' ');
      // Only the first a=fmtp:<pt> is considered.
      codec.parameters = fmtps.length ? SDPUtils.parseFmtp(fmtps[0]) : {};
      codec.rtcpFeedback = SDPUtils.matchPrefix(
          mediaSection, 'a=rtcp-fb:' + pt + ' ')
        .map(SDPUtils.parseRtcpFb);
      description.codecs.push(codec);
      // parse FEC mechanisms from rtpmap lines.
      switch (codec.name.toUpperCase()) {
        case 'RED':
        case 'ULPFEC':
          description.fecMechanisms.push(codec.name.toUpperCase());
          break;
        default: // only RED and ULPFEC are recognized as FEC mechanisms.
          break;
      }
    }
  }
  SDPUtils.matchPrefix(mediaSection, 'a=extmap:').forEach(function(line) {
    description.headerExtensions.push(SDPUtils.parseExtmap(line));
  });
  // FIXME: parse rtcp.
  return description;
};

// Generates parts of the SDP media section describing the capabilities /
// parameters.
SDPUtils.writeRtpDescription = function(kind, caps) {
  var sdp = '';

  // Build the mline.
  sdp += 'm=' + kind + ' ';
  sdp += caps.codecs.length > 0 ? '9' : '0'; // reject if no codecs.
  sdp += ' UDP/TLS/RTP/SAVPF ';
  sdp += caps.codecs.map(function(codec) {
    if (codec.preferredPayloadType !== undefined) {
      return codec.preferredPayloadType;
    }
    return codec.payloadType;
  }).join(' ') + '\r\n';

  sdp += 'c=IN IP4 0.0.0.0\r\n';
  sdp += 'a=rtcp:9 IN IP4 0.0.0.0\r\n';

  // Add a=rtpmap lines for each codec. Also fmtp and rtcp-fb.
  caps.codecs.forEach(function(codec) {
    sdp += SDPUtils.writeRtpMap(codec);
    sdp += SDPUtils.writeFmtp(codec);
    sdp += SDPUtils.writeRtcpFb(codec);
  });
  sdp += 'a=rtcp-mux\r\n';

  caps.headerExtensions.forEach(function(extension) {
    sdp += SDPUtils.writeExtmap(extension);
  });
  // FIXME: write fecMechanisms.
  return sdp;
};

// Parses the SDP media section and returns an array of
// RTCRtpEncodingParameters.
SDPUtils.parseRtpEncodingParameters = function(mediaSection) {
  var encodingParameters = [];
  var description = SDPUtils.parseRtpParameters(mediaSection);
  var hasRed = description.fecMechanisms.indexOf('RED') !== -1;
  var hasUlpfec = description.fecMechanisms.indexOf('ULPFEC') !== -1;

  // filter a=ssrc:... cname:, ignore PlanB-msid
  var ssrcs = SDPUtils.matchPrefix(mediaSection, 'a=ssrc:')
  .map(function(line) {
    return SDPUtils.parseSsrcMedia(line);
  })
  .filter(function(parts) {
    return parts.attribute === 'cname';
  });
  var primarySsrc = ssrcs.length > 0 && ssrcs[0].ssrc;
  var secondarySsrc;

  var flows = SDPUtils.matchPrefix(mediaSection, 'a=ssrc-group:FID')
  .map(function(line) {
    var parts = line.split(' ');
    parts.shift();
    return parts.map(function(part) {
      return parseInt(part, 10);
    });
  });
  if (flows.length > 0 && flows[0].length > 1 && flows[0][0] === primarySsrc) {
    secondarySsrc = flows[0][1];
  }

  description.codecs.forEach(function(codec) {
    if (codec.name.toUpperCase() === 'RTX' && codec.parameters.apt) {
      var encParam = {
        ssrc: primarySsrc,
        codecPayloadType: parseInt(codec.parameters.apt, 10),
        rtx: {
          payloadType: codec.payloadType,
          ssrc: secondarySsrc
        }
      };
      encodingParameters.push(encParam);
      if (hasRed) {
        encParam = JSON.parse(JSON.stringify(encParam));
        encParam.fec = {
          ssrc: secondarySsrc,
          mechanism: hasUlpfec ? 'red+ulpfec' : 'red'
        };
        encodingParameters.push(encParam);
      }
    }
  });
  if (encodingParameters.length === 0 && primarySsrc) {
    encodingParameters.push({
      ssrc: primarySsrc
    });
  }

  // we support both b=AS and b=TIAS but interpret AS as TIAS.
  var bandwidth = SDPUtils.matchPrefix(mediaSection, 'b=');
  if (bandwidth.length) {
    if (bandwidth[0].indexOf('b=TIAS:') === 0) {
      bandwidth = parseInt(bandwidth[0].substr(7), 10);
    } else if (bandwidth[0].indexOf('b=AS:') === 0) {
      bandwidth = parseInt(bandwidth[0].substr(5), 10);
    }
    encodingParameters.forEach(function(params) {
      params.maxBitrate = bandwidth;
    });
  }
  return encodingParameters;
};

SDPUtils.writeSessionBoilerplate = function() {
  // FIXME: sess-id should be an NTP timestamp.
  return 'v=0\r\n' +
      'o=thisisadapterortc 8169639915646943137 2 IN IP4 127.0.0.1\r\n' +
      's=-\r\n' +
      't=0 0\r\n';
};

SDPUtils.writeMediaSection = function(transceiver, caps, type, stream) {
  var sdp = SDPUtils.writeRtpDescription(transceiver.kind, caps);

  // Map ICE parameters (ufrag, pwd) to SDP.
  sdp += SDPUtils.writeIceParameters(
      transceiver.iceGatherer.getLocalParameters());

  // Map DTLS parameters to SDP.
  sdp += SDPUtils.writeDtlsParameters(
      transceiver.dtlsTransport.getLocalParameters(),
      type === 'offer' ? 'actpass' : 'active');

  sdp += 'a=mid:' + transceiver.mid + '\r\n';

  if (transceiver.rtpSender && transceiver.rtpReceiver) {
    sdp += 'a=sendrecv\r\n';
  } else if (transceiver.rtpSender) {
    sdp += 'a=sendonly\r\n';
  } else if (transceiver.rtpReceiver) {
    sdp += 'a=recvonly\r\n';
  } else {
    sdp += 'a=inactive\r\n';
  }

  // FIXME: for RTX there might be multiple SSRCs. Not implemented in Edge yet.
  if (transceiver.rtpSender) {
    var msid = 'msid:' + stream.id + ' ' +
        transceiver.rtpSender.track.id + '\r\n';
    sdp += 'a=' + msid;
    sdp += 'a=ssrc:' + transceiver.sendEncodingParameters[0].ssrc +
        ' ' + msid;
  }
  // FIXME: this should be written by writeRtpDescription.
  sdp += 'a=ssrc:' + transceiver.sendEncodingParameters[0].ssrc +
      ' cname:' + SDPUtils.localCName + '\r\n';
  return sdp;
};

// Gets the direction from the mediaSection or the sessionpart.
SDPUtils.getDirection = function(mediaSection, sessionpart) {
  // Look for sendrecv, sendonly, recvonly, inactive, default to sendrecv.
  var lines = SDPUtils.splitLines(mediaSection);
  for (var i = 0; i < lines.length; i++) {
    switch (lines[i]) {
      case 'a=sendrecv':
      case 'a=sendonly':
      case 'a=recvonly':
      case 'a=inactive':
        return lines[i].substr(2);
      default:
        // FIXME: What should happen here?
    }
  }
  if (sessionpart) {
    return SDPUtils.getDirection(sessionpart);
  }
  return 'sendrecv';
};

// Expose public methods.
module.exports = SDPUtils;


/***/ },
/* 205 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */



// Shimming starts here.
(function() {
  // Utils.
  var logging = __webpack_require__(0).log;
  var browserDetails = __webpack_require__(0).browserDetails;
  // Export to the adapter global object visible in the browser.
  module.exports.browserDetails = browserDetails;
  module.exports.extractVersion = __webpack_require__(0).extractVersion;
  module.exports.disableLog = __webpack_require__(0).disableLog;

  // Uncomment the line below if you want logging to occur, including logging
  // for the switch statement below. Can also be turned on in the browser via
  // adapter.disableLog(false), but then logging from the switch statement below
  // will not appear.
  // require('./utils').disableLog(false);

  // Browser shims.
  var chromeShim = __webpack_require__(206) || null;
  var edgeShim = __webpack_require__(208) || null;
  var firefoxShim = __webpack_require__(210) || null;
  var safariShim = __webpack_require__(212) || null;

  // Shim browser if found.
  switch (browserDetails.browser) {
    case 'opera': // fallthrough as it uses chrome shims
    case 'chrome':
      if (!chromeShim || !chromeShim.shimPeerConnection) {
        logging('Chrome shim is not included in this adapter release.');
        return;
      }
      logging('adapter.js shimming chrome.');
      // Export to the adapter global object visible in the browser.
      module.exports.browserShim = chromeShim;

      chromeShim.shimGetUserMedia();
      chromeShim.shimMediaStream();
      chromeShim.shimSourceObject();
      chromeShim.shimPeerConnection();
      chromeShim.shimOnTrack();
      break;
    case 'firefox':
      if (!firefoxShim || !firefoxShim.shimPeerConnection) {
        logging('Firefox shim is not included in this adapter release.');
        return;
      }
      logging('adapter.js shimming firefox.');
      // Export to the adapter global object visible in the browser.
      module.exports.browserShim = firefoxShim;

      firefoxShim.shimGetUserMedia();
      firefoxShim.shimSourceObject();
      firefoxShim.shimPeerConnection();
      firefoxShim.shimOnTrack();
      break;
    case 'edge':
      if (!edgeShim || !edgeShim.shimPeerConnection) {
        logging('MS edge shim is not included in this adapter release.');
        return;
      }
      logging('adapter.js shimming edge.');
      // Export to the adapter global object visible in the browser.
      module.exports.browserShim = edgeShim;

      edgeShim.shimGetUserMedia();
      edgeShim.shimPeerConnection();
      break;
    case 'safari':
      if (!safariShim) {
        logging('Safari shim is not included in this adapter release.');
        return;
      }
      logging('adapter.js shimming safari.');
      // Export to the adapter global object visible in the browser.
      module.exports.browserShim = safariShim;

      safariShim.shimGetUserMedia();
      break;
    default:
      logging('Unsupported browser!');
  }
})();


/***/ },
/* 206 */
/***/ function(module, exports, __webpack_require__) {

"use strict";

/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */

var logging = __webpack_require__(0).log;
var browserDetails = __webpack_require__(0).browserDetails;

var chromeShim = {
  shimMediaStream: function() {
    window.MediaStream = window.MediaStream || window.webkitMediaStream;
  },

  shimOnTrack: function() {
    if (typeof window === 'object' && window.RTCPeerConnection && !('ontrack' in
        window.RTCPeerConnection.prototype)) {
      Object.defineProperty(window.RTCPeerConnection.prototype, 'ontrack', {
        get: function() {
          return this._ontrack;
        },
        set: function(f) {
          var self = this;
          if (this._ontrack) {
            this.removeEventListener('track', this._ontrack);
            this.removeEventListener('addstream', this._ontrackpoly);
          }
          this.addEventListener('track', this._ontrack = f);
          this.addEventListener('addstream', this._ontrackpoly = function(e) {
            // onaddstream does not fire when a track is added to an existing
            // stream. But stream.onaddtrack is implemented so we use that.
            e.stream.addEventListener('addtrack', function(te) {
              var event = new Event('track');
              event.track = te.track;
              event.receiver = {track: te.track};
              event.streams = [e.stream];
              self.dispatchEvent(event);
            });
            e.stream.getTracks().forEach(function(track) {
              var event = new Event('track');
              event.track = track;
              event.receiver = {track: track};
              event.streams = [e.stream];
              this.dispatchEvent(event);
            }.bind(this));
          }.bind(this));
        }
      });
    }
  },

  shimSourceObject: function() {
    if (typeof window === 'object') {
      if (window.HTMLMediaElement &&
        !('srcObject' in window.HTMLMediaElement.prototype)) {
        // Shim the srcObject property, once, when HTMLMediaElement is found.
        Object.defineProperty(window.HTMLMediaElement.prototype, 'srcObject', {
          get: function() {
            return this._srcObject;
          },
          set: function(stream) {
            var self = this;
            // Use _srcObject as a private property for this shim
            this._srcObject = stream;
            if (this.src) {
              URL.revokeObjectURL(this.src);
            }

            if (!stream) {
              this.src = '';
              return;
            }
            this.src = URL.createObjectURL(stream);
            // We need to recreate the blob url when a track is added or
            // removed. Doing it manually since we want to avoid a recursion.
            stream.addEventListener('addtrack', function() {
              if (self.src) {
                URL.revokeObjectURL(self.src);
              }
              self.src = URL.createObjectURL(stream);
            });
            stream.addEventListener('removetrack', function() {
              if (self.src) {
                URL.revokeObjectURL(self.src);
              }
              self.src = URL.createObjectURL(stream);
            });
          }
        });
      }
    }
  },

  shimPeerConnection: function() {
    // The RTCPeerConnection object.
    window.RTCPeerConnection = function(pcConfig, pcConstraints) {
      // Translate iceTransportPolicy to iceTransports,
      // see https://code.google.com/p/webrtc/issues/detail?id=4869
      logging('PeerConnection');
      if (pcConfig && pcConfig.iceTransportPolicy) {
        pcConfig.iceTransports = pcConfig.iceTransportPolicy;
      }

      var pc = new webkitRTCPeerConnection(pcConfig, pcConstraints);
      var origGetStats = pc.getStats.bind(pc);
      pc.getStats = function(selector, successCallback, errorCallback) {
        var self = this;
        var args = arguments;

        // If selector is a function then we are in the old style stats so just
        // pass back the original getStats format to avoid breaking old users.
        if (arguments.length > 0 && typeof selector === 'function') {
          return origGetStats(selector, successCallback);
        }

        var fixChromeStats_ = function(response) {
          var standardReport = {};
          var reports = response.result();
          reports.forEach(function(report) {
            var standardStats = {
              id: report.id,
              timestamp: report.timestamp,
              type: report.type
            };
            report.names().forEach(function(name) {
              standardStats[name] = report.stat(name);
            });
            standardReport[standardStats.id] = standardStats;
          });

          return standardReport;
        };

        // shim getStats with maplike support
        var makeMapStats = function(stats, legacyStats) {
          var map = new Map(Object.keys(stats).map(function(key) {
            return[key, stats[key]];
          }));
          legacyStats = legacyStats || stats;
          Object.keys(legacyStats).forEach(function(key) {
            map[key] = legacyStats[key];
          });
          return map;
        };

        if (arguments.length >= 2) {
          var successCallbackWrapper_ = function(response) {
            args[1](makeMapStats(fixChromeStats_(response)));
          };

          return origGetStats.apply(this, [successCallbackWrapper_,
              arguments[0]]);
        }

        // promise-support
        return new Promise(function(resolve, reject) {
          if (args.length === 1 && typeof selector === 'object') {
            origGetStats.apply(self, [
              function(response) {
                resolve(makeMapStats(fixChromeStats_(response)));
              }, reject]);
          } else {
            // Preserve legacy chrome stats only on legacy access of stats obj
            origGetStats.apply(self, [
              function(response) {
                resolve(makeMapStats(fixChromeStats_(response),
                    response.result()));
              }, reject]);
          }
        }).then(successCallback, errorCallback);
      };

      return pc;
    };
    window.RTCPeerConnection.prototype = webkitRTCPeerConnection.prototype;

    // wrap static methods. Currently just generateCertificate.
    if (webkitRTCPeerConnection.generateCertificate) {
      Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
        get: function() {
          return webkitRTCPeerConnection.generateCertificate;
        }
      });
    }

    ['createOffer', 'createAnswer'].forEach(function(method) {
      var nativeMethod = webkitRTCPeerConnection.prototype[method];
      webkitRTCPeerConnection.prototype[method] = function() {
        var self = this;
        if (arguments.length < 1 || (arguments.length === 1 &&
            typeof arguments[0] === 'object')) {
          var opts = arguments.length === 1 ? arguments[0] : undefined;
          return new Promise(function(resolve, reject) {
            nativeMethod.apply(self, [resolve, reject, opts]);
          });
        }
        return nativeMethod.apply(this, arguments);
      };
    });

    // add promise support -- natively available in Chrome 51
    if (browserDetails.version < 51) {
      ['setLocalDescription', 'setRemoteDescription', 'addIceCandidate']
          .forEach(function(method) {
            var nativeMethod = webkitRTCPeerConnection.prototype[method];
            webkitRTCPeerConnection.prototype[method] = function() {
              var args = arguments;
              var self = this;
              var promise = new Promise(function(resolve, reject) {
                nativeMethod.apply(self, [args[0], resolve, reject]);
              });
              if (args.length < 2) {
                return promise;
              }
              return promise.then(function() {
                args[1].apply(null, []);
              },
              function(err) {
                if (args.length >= 3) {
                  args[2].apply(null, [err]);
                }
              });
            };
          });
    }

    // shim implicit creation of RTCSessionDescription/RTCIceCandidate
    ['setLocalDescription', 'setRemoteDescription', 'addIceCandidate']
        .forEach(function(method) {
          var nativeMethod = webkitRTCPeerConnection.prototype[method];
          webkitRTCPeerConnection.prototype[method] = function() {
            arguments[0] = new ((method === 'addIceCandidate') ?
                RTCIceCandidate : RTCSessionDescription)(arguments[0]);
            return nativeMethod.apply(this, arguments);
          };
        });

    // support for addIceCandidate(null or undefined)
    var nativeAddIceCandidate =
        RTCPeerConnection.prototype.addIceCandidate;
    RTCPeerConnection.prototype.addIceCandidate = function() {
      if (!arguments[0]) {
        if (arguments[1]) {
          arguments[1].apply(null);
        }
        return Promise.resolve();
      }
      return nativeAddIceCandidate.apply(this, arguments);
    };
  }
};


// Expose public methods.
module.exports = {
  shimMediaStream: chromeShim.shimMediaStream,
  shimOnTrack: chromeShim.shimOnTrack,
  shimSourceObject: chromeShim.shimSourceObject,
  shimPeerConnection: chromeShim.shimPeerConnection,
  shimGetUserMedia: __webpack_require__(207)
};


/***/ },
/* 207 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */

var logging = __webpack_require__(0).log;

// Expose public methods.
module.exports = function() {
  var constraintsToChrome_ = function(c) {
    if (typeof c !== 'object' || c.mandatory || c.optional) {
      return c;
    }
    var cc = {};
    Object.keys(c).forEach(function(key) {
      if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
        return;
      }
      var r = (typeof c[key] === 'object') ? c[key] : {ideal: c[key]};
      if (r.exact !== undefined && typeof r.exact === 'number') {
        r.min = r.max = r.exact;
      }
      var oldname_ = function(prefix, name) {
        if (prefix) {
          return prefix + name.charAt(0).toUpperCase() + name.slice(1);
        }
        return (name === 'deviceId') ? 'sourceId' : name;
      };
      if (r.ideal !== undefined) {
        cc.optional = cc.optional || [];
        var oc = {};
        if (typeof r.ideal === 'number') {
          oc[oldname_('min', key)] = r.ideal;
          cc.optional.push(oc);
          oc = {};
          oc[oldname_('max', key)] = r.ideal;
          cc.optional.push(oc);
        } else {
          oc[oldname_('', key)] = r.ideal;
          cc.optional.push(oc);
        }
      }
      if (r.exact !== undefined && typeof r.exact !== 'number') {
        cc.mandatory = cc.mandatory || {};
        cc.mandatory[oldname_('', key)] = r.exact;
      } else {
        ['min', 'max'].forEach(function(mix) {
          if (r[mix] !== undefined) {
            cc.mandatory = cc.mandatory || {};
            cc.mandatory[oldname_(mix, key)] = r[mix];
          }
        });
      }
    });
    if (c.advanced) {
      cc.optional = (cc.optional || []).concat(c.advanced);
    }
    return cc;
  };

  var shimConstraints_ = function(constraints, func) {
    constraints = JSON.parse(JSON.stringify(constraints));
    if (constraints && constraints.audio) {
      constraints.audio = constraintsToChrome_(constraints.audio);
    }
    if (constraints && typeof constraints.video === 'object') {
      // Shim facingMode for mobile, where it defaults to "user".
      var face = constraints.video.facingMode;
      face = face && ((typeof face === 'object') ? face : {ideal: face});

      if ((face && (face.exact === 'user' || face.exact === 'environment' ||
                    face.ideal === 'user' || face.ideal === 'environment')) &&
          !(navigator.mediaDevices.getSupportedConstraints &&
            navigator.mediaDevices.getSupportedConstraints().facingMode)) {
        delete constraints.video.facingMode;
        if (face.exact === 'environment' || face.ideal === 'environment') {
          // Look for "back" in label, or use last cam (typically back cam).
          return navigator.mediaDevices.enumerateDevices()
          .then(function(devices) {
            devices = devices.filter(function(d) {
              return d.kind === 'videoinput';
            });
            var back = devices.find(function(d) {
              return d.label.toLowerCase().indexOf('back') !== -1;
            }) || (devices.length && devices[devices.length - 1]);
            if (back) {
              constraints.video.deviceId = face.exact ? {exact: back.deviceId} :
                                                        {ideal: back.deviceId};
            }
            constraints.video = constraintsToChrome_(constraints.video);
            logging('chrome: ' + JSON.stringify(constraints));
            return func(constraints);
          });
        }
      }
      constraints.video = constraintsToChrome_(constraints.video);
    }
    logging('chrome: ' + JSON.stringify(constraints));
    return func(constraints);
  };

  var shimError_ = function(e) {
    return {
      name: {
        PermissionDeniedError: 'NotAllowedError',
        ConstraintNotSatisfiedError: 'OverconstrainedError'
      }[e.name] || e.name,
      message: e.message,
      constraint: e.constraintName,
      toString: function() {
        return this.name + (this.message && ': ') + this.message;
      }
    };
  };

  var getUserMedia_ = function(constraints, onSuccess, onError) {
    shimConstraints_(constraints, function(c) {
      navigator.webkitGetUserMedia(c, onSuccess, function(e) {
        onError(shimError_(e));
      });
    });
  };

  navigator.getUserMedia = getUserMedia_;

  // Returns the result of getUserMedia as a Promise.
  var getUserMediaPromise_ = function(constraints) {
    return new Promise(function(resolve, reject) {
      navigator.getUserMedia(constraints, resolve, reject);
    });
  };

  if (!navigator.mediaDevices) {
    navigator.mediaDevices = {
      getUserMedia: getUserMediaPromise_,
      enumerateDevices: function() {
        return new Promise(function(resolve) {
          var kinds = {audio: 'audioinput', video: 'videoinput'};
          return MediaStreamTrack.getSources(function(devices) {
            resolve(devices.map(function(device) {
              return {label: device.label,
                      kind: kinds[device.kind],
                      deviceId: device.id,
                      groupId: ''};
            }));
          });
        });
      }
    };
  }

  // A shim for getUserMedia method on the mediaDevices object.
  // TODO(KaptenJansson) remove once implemented in Chrome stable.
  if (!navigator.mediaDevices.getUserMedia) {
    navigator.mediaDevices.getUserMedia = function(constraints) {
      return getUserMediaPromise_(constraints);
    };
  } else {
    // Even though Chrome 45 has navigator.mediaDevices and a getUserMedia
    // function which returns a Promise, it does not accept spec-style
    // constraints.
    var origGetUserMedia = navigator.mediaDevices.getUserMedia.
        bind(navigator.mediaDevices);
    navigator.mediaDevices.getUserMedia = function(cs) {
      return shimConstraints_(cs, function(c) {
        return origGetUserMedia(c).then(function(stream) {
          if (c.audio && !stream.getAudioTracks().length ||
              c.video && !stream.getVideoTracks().length) {
            stream.getTracks().forEach(function(track) {
              track.stop();
            });
            throw new DOMException('', 'NotFoundError');
          }
          return stream;
        }, function(e) {
          return Promise.reject(shimError_(e));
        });
      });
    };
  }

  // Dummy devicechange event methods.
  // TODO(KaptenJansson) remove once implemented in Chrome stable.
  if (typeof navigator.mediaDevices.addEventListener === 'undefined') {
    navigator.mediaDevices.addEventListener = function() {
      logging('Dummy mediaDevices.addEventListener called.');
    };
  }
  if (typeof navigator.mediaDevices.removeEventListener === 'undefined') {
    navigator.mediaDevices.removeEventListener = function() {
      logging('Dummy mediaDevices.removeEventListener called.');
    };
  }
};


/***/ },
/* 208 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */


var SDPUtils = __webpack_require__(204);
var browserDetails = __webpack_require__(0).browserDetails;

var edgeShim = {
  shimPeerConnection: function() {
    if (window.RTCIceGatherer) {
      // ORTC defines an RTCIceCandidate object but no constructor.
      // Not implemented in Edge.
      if (!window.RTCIceCandidate) {
        window.RTCIceCandidate = function(args) {
          return args;
        };
      }
      // ORTC does not have a session description object but
      // other browsers (i.e. Chrome) that will support both PC and ORTC
      // in the future might have this defined already.
      if (!window.RTCSessionDescription) {
        window.RTCSessionDescription = function(args) {
          return args;
        };
      }
      // this adds an additional event listener to MediaStrackTrack that signals
      // when a tracks enabled property was changed.
      var origMSTEnabled = Object.getOwnPropertyDescriptor(
          MediaStreamTrack.prototype, 'enabled');
      Object.defineProperty(MediaStreamTrack.prototype, 'enabled', {
        set: function(value) {
          origMSTEnabled.set.call(this, value);
          var ev = new Event('enabled');
          ev.enabled = value;
          this.dispatchEvent(ev);
        }
      });
    }

    window.RTCPeerConnection = function(config) {
      var self = this;

      var _eventTarget = document.createDocumentFragment();
      ['addEventListener', 'removeEventListener', 'dispatchEvent']
          .forEach(function(method) {
            self[method] = _eventTarget[method].bind(_eventTarget);
          });

      this.onicecandidate = null;
      this.onaddstream = null;
      this.ontrack = null;
      this.onremovestream = null;
      this.onsignalingstatechange = null;
      this.oniceconnectionstatechange = null;
      this.onnegotiationneeded = null;
      this.ondatachannel = null;

      this.localStreams = [];
      this.remoteStreams = [];
      this.getLocalStreams = function() {
        return self.localStreams;
      };
      this.getRemoteStreams = function() {
        return self.remoteStreams;
      };

      this.localDescription = new RTCSessionDescription({
        type: '',
        sdp: ''
      });
      this.remoteDescription = new RTCSessionDescription({
        type: '',
        sdp: ''
      });
      this.signalingState = 'stable';
      this.iceConnectionState = 'new';
      this.iceGatheringState = 'new';

      this.iceOptions = {
        gatherPolicy: 'all',
        iceServers: []
      };
      if (config && config.iceTransportPolicy) {
        switch (config.iceTransportPolicy) {
          case 'all':
          case 'relay':
            this.iceOptions.gatherPolicy = config.iceTransportPolicy;
            break;
          case 'none':
            // FIXME: remove once implementation and spec have added this.
            throw new TypeError('iceTransportPolicy "none" not supported');
          default:
            // don't set iceTransportPolicy.
            break;
        }
      }
      this.usingBundle = config && config.bundlePolicy === 'max-bundle';

      if (config && config.iceServers) {
        // Edge does not like
        // 1) stun:
        // 2) turn: that does not have all of turn:host:port?transport=udp
        // 3) turn: with ipv6 addresses
        var iceServers = JSON.parse(JSON.stringify(config.iceServers));
        this.iceOptions.iceServers = iceServers.filter(function(server) {
          if (server && server.urls) {
            var urls = server.urls;
            if (typeof urls === 'string') {
              urls = [urls];
            }
            urls = urls.filter(function(url) {
              return (url.indexOf('turn:') === 0 &&
                  url.indexOf('transport=udp') !== -1 &&
                  url.indexOf('turn:[') === -1) ||
                  (url.indexOf('stun:') === 0 &&
                    browserDetails.version >= 14393);
            })[0];
            return !!urls;
          }
          return false;
        });
      }
      this._config = config;

      // per-track iceGathers, iceTransports, dtlsTransports, rtpSenders, ...
      // everything that is needed to describe a SDP m-line.
      this.transceivers = [];

      // since the iceGatherer is currently created in createOffer but we
      // must not emit candidates until after setLocalDescription we buffer
      // them in this array.
      this._localIceCandidatesBuffer = [];
    };

    window.RTCPeerConnection.prototype._emitBufferedCandidates = function() {
      var self = this;
      var sections = SDPUtils.splitSections(self.localDescription.sdp);
      // FIXME: need to apply ice candidates in a way which is async but
      // in-order
      this._localIceCandidatesBuffer.forEach(function(event) {
        var end = !event.candidate || Object.keys(event.candidate).length === 0;
        if (end) {
          for (var j = 1; j < sections.length; j++) {
            if (sections[j].indexOf('\r\na=end-of-candidates\r\n') === -1) {
              sections[j] += 'a=end-of-candidates\r\n';
            }
          }
        } else if (event.candidate.candidate.indexOf('typ endOfCandidates')
            === -1) {
          sections[event.candidate.sdpMLineIndex + 1] +=
              'a=' + event.candidate.candidate + '\r\n';
        }
        self.localDescription.sdp = sections.join('');
        self.dispatchEvent(event);
        if (self.onicecandidate !== null) {
          self.onicecandidate(event);
        }
        if (!event.candidate && self.iceGatheringState !== 'complete') {
          var complete = self.transceivers.every(function(transceiver) {
            return transceiver.iceGatherer &&
                transceiver.iceGatherer.state === 'completed';
          });
          if (complete) {
            self.iceGatheringState = 'complete';
          }
        }
      });
      this._localIceCandidatesBuffer = [];
    };

    window.RTCPeerConnection.prototype.getConfiguration = function() {
      return this._config;
    };

    window.RTCPeerConnection.prototype.addStream = function(stream) {
      // Clone is necessary for local demos mostly, attaching directly
      // to two different senders does not work (build 10547).
      var clonedStream = stream.clone();
      stream.getTracks().forEach(function(track, idx) {
        var clonedTrack = clonedStream.getTracks()[idx];
        track.addEventListener('enabled', function(event) {
          clonedTrack.enabled = event.enabled;
        });
      });
      this.localStreams.push(clonedStream);
      this._maybeFireNegotiationNeeded();
    };

    window.RTCPeerConnection.prototype.removeStream = function(stream) {
      var idx = this.localStreams.indexOf(stream);
      if (idx > -1) {
        this.localStreams.splice(idx, 1);
        this._maybeFireNegotiationNeeded();
      }
    };

    window.RTCPeerConnection.prototype.getSenders = function() {
      return this.transceivers.filter(function(transceiver) {
        return !!transceiver.rtpSender;
      })
      .map(function(transceiver) {
        return transceiver.rtpSender;
      });
    };

    window.RTCPeerConnection.prototype.getReceivers = function() {
      return this.transceivers.filter(function(transceiver) {
        return !!transceiver.rtpReceiver;
      })
      .map(function(transceiver) {
        return transceiver.rtpReceiver;
      });
    };

    // Determines the intersection of local and remote capabilities.
    window.RTCPeerConnection.prototype._getCommonCapabilities =
        function(localCapabilities, remoteCapabilities) {
          var commonCapabilities = {
            codecs: [],
            headerExtensions: [],
            fecMechanisms: []
          };
          localCapabilities.codecs.forEach(function(lCodec) {
            for (var i = 0; i < remoteCapabilities.codecs.length; i++) {
              var rCodec = remoteCapabilities.codecs[i];
              if (lCodec.name.toLowerCase() === rCodec.name.toLowerCase() &&
                  lCodec.clockRate === rCodec.clockRate) {
                // number of channels is the highest common number of channels
                rCodec.numChannels = Math.min(lCodec.numChannels,
                    rCodec.numChannels);
                // push rCodec so we reply with offerer payload type
                commonCapabilities.codecs.push(rCodec);

                // determine common feedback mechanisms
                rCodec.rtcpFeedback = rCodec.rtcpFeedback.filter(function(fb) {
                  for (var j = 0; j < lCodec.rtcpFeedback.length; j++) {
                    if (lCodec.rtcpFeedback[j].type === fb.type &&
                        lCodec.rtcpFeedback[j].parameter === fb.parameter) {
                      return true;
                    }
                  }
                  return false;
                });
                // FIXME: also need to determine .parameters
                //  see https://github.com/openpeer/ortc/issues/569
                break;
              }
            }
          });

          localCapabilities.headerExtensions
              .forEach(function(lHeaderExtension) {
                for (var i = 0; i < remoteCapabilities.headerExtensions.length;
                     i++) {
                  var rHeaderExtension = remoteCapabilities.headerExtensions[i];
                  if (lHeaderExtension.uri === rHeaderExtension.uri) {
                    commonCapabilities.headerExtensions.push(rHeaderExtension);
                    break;
                  }
                }
              });

          // FIXME: fecMechanisms
          return commonCapabilities;
        };

    // Create ICE gatherer, ICE transport and DTLS transport.
    window.RTCPeerConnection.prototype._createIceAndDtlsTransports =
        function(mid, sdpMLineIndex) {
          var self = this;
          var iceGatherer = new RTCIceGatherer(self.iceOptions);
          var iceTransport = new RTCIceTransport(iceGatherer);
          iceGatherer.onlocalcandidate = function(evt) {
            var event = new Event('icecandidate');
            event.candidate = {sdpMid: mid, sdpMLineIndex: sdpMLineIndex};

            var cand = evt.candidate;
            var end = !cand || Object.keys(cand).length === 0;
            // Edge emits an empty object for RTCIceCandidateComplete‥
            if (end) {
              // polyfill since RTCIceGatherer.state is not implemented in
              // Edge 10547 yet.
              if (iceGatherer.state === undefined) {
                iceGatherer.state = 'completed';
              }

              // Emit a candidate with type endOfCandidates to make the samples
              // work. Edge requires addIceCandidate with this empty candidate
              // to start checking. The real solution is to signal
              // end-of-candidates to the other side when getting the null
              // candidate but some apps (like the samples) don't do that.
              event.candidate.candidate =
                  'candidate:1 1 udp 1 0.0.0.0 9 typ endOfCandidates';
            } else {
              // RTCIceCandidate doesn't have a component, needs to be added
              cand.component = iceTransport.component === 'RTCP' ? 2 : 1;
              event.candidate.candidate = SDPUtils.writeCandidate(cand);
            }

            // update local description.
            var sections = SDPUtils.splitSections(self.localDescription.sdp);
            if (event.candidate.candidate.indexOf('typ endOfCandidates')
                === -1) {
              sections[event.candidate.sdpMLineIndex + 1] +=
                  'a=' + event.candidate.candidate + '\r\n';
            } else {
              sections[event.candidate.sdpMLineIndex + 1] +=
                  'a=end-of-candidates\r\n';
            }
            self.localDescription.sdp = sections.join('');

            var complete = self.transceivers.every(function(transceiver) {
              return transceiver.iceGatherer &&
                  transceiver.iceGatherer.state === 'completed';
            });

            // Emit candidate if localDescription is set.
            // Also emits null candidate when all gatherers are complete.
            switch (self.iceGatheringState) {
              case 'new':
                self._localIceCandidatesBuffer.push(event);
                if (end && complete) {
                  self._localIceCandidatesBuffer.push(
                      new Event('icecandidate'));
                }
                break;
              case 'gathering':
                self._emitBufferedCandidates();
                self.dispatchEvent(event);
                if (self.onicecandidate !== null) {
                  self.onicecandidate(event);
                }
                if (complete) {
                  self.dispatchEvent(new Event('icecandidate'));
                  if (self.onicecandidate !== null) {
                    self.onicecandidate(new Event('icecandidate'));
                  }
                  self.iceGatheringState = 'complete';
                }
                break;
              case 'complete':
                // should not happen... currently!
                break;
              default: // no-op.
                break;
            }
          };
          iceTransport.onicestatechange = function() {
            self._updateConnectionState();
          };

          var dtlsTransport = new RTCDtlsTransport(iceTransport);
          dtlsTransport.ondtlsstatechange = function() {
            self._updateConnectionState();
          };
          dtlsTransport.onerror = function() {
            // onerror does not set state to failed by itself.
            dtlsTransport.state = 'failed';
            self._updateConnectionState();
          };

          return {
            iceGatherer: iceGatherer,
            iceTransport: iceTransport,
            dtlsTransport: dtlsTransport
          };
        };

    // Start the RTP Sender and Receiver for a transceiver.
    window.RTCPeerConnection.prototype._transceive = function(transceiver,
        send, recv) {
      var params = this._getCommonCapabilities(transceiver.localCapabilities,
          transceiver.remoteCapabilities);
      if (send && transceiver.rtpSender) {
        params.encodings = transceiver.sendEncodingParameters;
        params.rtcp = {
          cname: SDPUtils.localCName
        };
        if (transceiver.recvEncodingParameters.length) {
          params.rtcp.ssrc = transceiver.recvEncodingParameters[0].ssrc;
        }
        transceiver.rtpSender.send(params);
      }
      if (recv && transceiver.rtpReceiver) {
        // remove RTX field in Edge 14942
        if (transceiver.kind === 'video'
            && transceiver.recvEncodingParameters) {
          transceiver.recvEncodingParameters.forEach(function(p) {
            delete p.rtx;
          });
        }
        params.encodings = transceiver.recvEncodingParameters;
        params.rtcp = {
          cname: transceiver.cname
        };
        if (transceiver.sendEncodingParameters.length) {
          params.rtcp.ssrc = transceiver.sendEncodingParameters[0].ssrc;
        }
        transceiver.rtpReceiver.receive(params);
      }
    };

    window.RTCPeerConnection.prototype.setLocalDescription =
        function(description) {
          var self = this;
          var sections;
          var sessionpart;
          if (description.type === 'offer') {
            // FIXME: What was the purpose of this empty if statement?
            // if (!this._pendingOffer) {
            // } else {
            if (this._pendingOffer) {
              // VERY limited support for SDP munging. Limited to:
              // * changing the order of codecs
              sections = SDPUtils.splitSections(description.sdp);
              sessionpart = sections.shift();
              sections.forEach(function(mediaSection, sdpMLineIndex) {
                var caps = SDPUtils.parseRtpParameters(mediaSection);
                self._pendingOffer[sdpMLineIndex].localCapabilities = caps;
              });
              this.transceivers = this._pendingOffer;
              delete this._pendingOffer;
            }
          } else if (description.type === 'answer') {
            sections = SDPUtils.splitSections(self.remoteDescription.sdp);
            sessionpart = sections.shift();
            var isIceLite = SDPUtils.matchPrefix(sessionpart,
                'a=ice-lite').length > 0;
            sections.forEach(function(mediaSection, sdpMLineIndex) {
              var transceiver = self.transceivers[sdpMLineIndex];
              var iceGatherer = transceiver.iceGatherer;
              var iceTransport = transceiver.iceTransport;
              var dtlsTransport = transceiver.dtlsTransport;
              var localCapabilities = transceiver.localCapabilities;
              var remoteCapabilities = transceiver.remoteCapabilities;

              var rejected = mediaSection.split('\n', 1)[0]
                  .split(' ', 2)[1] === '0';

              if (!rejected && !transceiver.isDatachannel) {
                var remoteIceParameters = SDPUtils.getIceParameters(
                    mediaSection, sessionpart);
                if (isIceLite) {
                  var cands = SDPUtils.matchPrefix(mediaSection, 'a=candidate:')
                  .map(function(cand) {
                    return SDPUtils.parseCandidate(cand);
                  })
                  .filter(function(cand) {
                    return cand.component === '1';
                  });
                  // ice-lite only includes host candidates in the SDP so we can
                  // use setRemoteCandidates (which implies an
                  // RTCIceCandidateComplete)
                  if (cands.length) {
                    iceTransport.setRemoteCandidates(cands);
                  }
                }
                var remoteDtlsParameters = SDPUtils.getDtlsParameters(
                    mediaSection, sessionpart);
                if (isIceLite) {
                  remoteDtlsParameters.role = 'server';
                }

                if (!self.usingBundle || sdpMLineIndex === 0) {
                  iceTransport.start(iceGatherer, remoteIceParameters,
                      isIceLite ? 'controlling' : 'controlled');
                  dtlsTransport.start(remoteDtlsParameters);
                }

                // Calculate intersection of capabilities.
                var params = self._getCommonCapabilities(localCapabilities,
                    remoteCapabilities);

                // Start the RTCRtpSender. The RTCRtpReceiver for this
                // transceiver has already been started in setRemoteDescription.
                self._transceive(transceiver,
                    params.codecs.length > 0,
                    false);
              }
            });
          }

          this.localDescription = {
            type: description.type,
            sdp: description.sdp
          };
          switch (description.type) {
            case 'offer':
              this._updateSignalingState('have-local-offer');
              break;
            case 'answer':
              this._updateSignalingState('stable');
              break;
            default:
              throw new TypeError('unsupported type "' + description.type +
                  '"');
          }

          // If a success callback was provided, emit ICE candidates after it
          // has been executed. Otherwise, emit callback after the Promise is
          // resolved.
          var hasCallback = arguments.length > 1 &&
            typeof arguments[1] === 'function';
          if (hasCallback) {
            var cb = arguments[1];
            window.setTimeout(function() {
              cb();
              if (self.iceGatheringState === 'new') {
                self.iceGatheringState = 'gathering';
              }
              self._emitBufferedCandidates();
            }, 0);
          }
          var p = Promise.resolve();
          p.then(function() {
            if (!hasCallback) {
              if (self.iceGatheringState === 'new') {
                self.iceGatheringState = 'gathering';
              }
              // Usually candidates will be emitted earlier.
              window.setTimeout(self._emitBufferedCandidates.bind(self), 500);
            }
          });
          return p;
        };

    window.RTCPeerConnection.prototype.setRemoteDescription =
        function(description) {
          var self = this;
          var stream = new MediaStream();
          var receiverList = [];
          var sections = SDPUtils.splitSections(description.sdp);
          var sessionpart = sections.shift();
          var isIceLite = SDPUtils.matchPrefix(sessionpart,
              'a=ice-lite').length > 0;
          this.usingBundle = SDPUtils.matchPrefix(sessionpart,
              'a=group:BUNDLE ').length > 0;
          sections.forEach(function(mediaSection, sdpMLineIndex) {
            var lines = SDPUtils.splitLines(mediaSection);
            var mline = lines[0].substr(2).split(' ');
            var kind = mline[0];
            var rejected = mline[1] === '0';
            var direction = SDPUtils.getDirection(mediaSection, sessionpart);

            var mid = SDPUtils.matchPrefix(mediaSection, 'a=mid:');
            if (mid.length) {
              mid = mid[0].substr(6);
            } else {
              mid = SDPUtils.generateIdentifier();
            }

            // Reject datachannels which are not implemented yet.
            if (kind === 'application' && mline[2] === 'DTLS/SCTP') {
              self.transceivers[sdpMLineIndex] = {
                mid: mid,
                isDatachannel: true
              };
              return;
            }

            var transceiver;
            var iceGatherer;
            var iceTransport;
            var dtlsTransport;
            var rtpSender;
            var rtpReceiver;
            var sendEncodingParameters;
            var recvEncodingParameters;
            var localCapabilities;

            var track;
            // FIXME: ensure the mediaSection has rtcp-mux set.
            var remoteCapabilities = SDPUtils.parseRtpParameters(mediaSection);
            var remoteIceParameters;
            var remoteDtlsParameters;
            if (!rejected) {
              remoteIceParameters = SDPUtils.getIceParameters(mediaSection,
                  sessionpart);
              remoteDtlsParameters = SDPUtils.getDtlsParameters(mediaSection,
                  sessionpart);
              remoteDtlsParameters.role = 'client';
            }
            recvEncodingParameters =
                SDPUtils.parseRtpEncodingParameters(mediaSection);

            var cname;
            // Gets the first SSRC. Note that with RTX there might be multiple
            // SSRCs.
            var remoteSsrc = SDPUtils.matchPrefix(mediaSection, 'a=ssrc:')
                .map(function(line) {
                  return SDPUtils.parseSsrcMedia(line);
                })
                .filter(function(obj) {
                  return obj.attribute === 'cname';
                })[0];
            if (remoteSsrc) {
              cname = remoteSsrc.value;
            }

            var isComplete = SDPUtils.matchPrefix(mediaSection,
                'a=end-of-candidates', sessionpart).length > 0;
            var cands = SDPUtils.matchPrefix(mediaSection, 'a=candidate:')
                .map(function(cand) {
                  return SDPUtils.parseCandidate(cand);
                })
                .filter(function(cand) {
                  return cand.component === '1';
                });
            if (description.type === 'offer' && !rejected) {
              var transports = self.usingBundle && sdpMLineIndex > 0 ? {
                iceGatherer: self.transceivers[0].iceGatherer,
                iceTransport: self.transceivers[0].iceTransport,
                dtlsTransport: self.transceivers[0].dtlsTransport
              } : self._createIceAndDtlsTransports(mid, sdpMLineIndex);

              if (isComplete) {
                transports.iceTransport.setRemoteCandidates(cands);
              }

              localCapabilities = RTCRtpReceiver.getCapabilities(kind);

              // filter RTX until additional stuff needed for RTX is implemented
              // in adapter.js
              localCapabilities.codecs = localCapabilities.codecs.filter(
                  function(codec) {
                    return codec.name !== 'rtx';
                  });

              sendEncodingParameters = [{
                ssrc: (2 * sdpMLineIndex + 2) * 1001
              }];

              rtpReceiver = new RTCRtpReceiver(transports.dtlsTransport, kind);

              track = rtpReceiver.track;
              receiverList.push([track, rtpReceiver]);
              // FIXME: not correct when there are multiple streams but that is
              // not currently supported in this shim.
              stream.addTrack(track);

              // FIXME: look at direction.
              if (self.localStreams.length > 0 &&
                  self.localStreams[0].getTracks().length >= sdpMLineIndex) {
                var localTrack;
                if (kind === 'audio') {
                  localTrack = self.localStreams[0].getAudioTracks()[0];
                } else if (kind === 'video') {
                  localTrack = self.localStreams[0].getVideoTracks()[0];
                }
                if (localTrack) {
                  rtpSender = new RTCRtpSender(localTrack,
                      transports.dtlsTransport);
                }
              }

              self.transceivers[sdpMLineIndex] = {
                iceGatherer: transports.iceGatherer,
                iceTransport: transports.iceTransport,
                dtlsTransport: transports.dtlsTransport,
                localCapabilities: localCapabilities,
                remoteCapabilities: remoteCapabilities,
                rtpSender: rtpSender,
                rtpReceiver: rtpReceiver,
                kind: kind,
                mid: mid,
                cname: cname,
                sendEncodingParameters: sendEncodingParameters,
                recvEncodingParameters: recvEncodingParameters
              };
              // Start the RTCRtpReceiver now. The RTPSender is started in
              // setLocalDescription.
              self._transceive(self.transceivers[sdpMLineIndex],
                  false,
                  direction === 'sendrecv' || direction === 'sendonly');
            } else if (description.type === 'answer' && !rejected) {
              transceiver = self.transceivers[sdpMLineIndex];
              iceGatherer = transceiver.iceGatherer;
              iceTransport = transceiver.iceTransport;
              dtlsTransport = transceiver.dtlsTransport;
              rtpSender = transceiver.rtpSender;
              rtpReceiver = transceiver.rtpReceiver;
              sendEncodingParameters = transceiver.sendEncodingParameters;
              localCapabilities = transceiver.localCapabilities;

              self.transceivers[sdpMLineIndex].recvEncodingParameters =
                  recvEncodingParameters;
              self.transceivers[sdpMLineIndex].remoteCapabilities =
                  remoteCapabilities;
              self.transceivers[sdpMLineIndex].cname = cname;

              if ((isIceLite || isComplete) && cands.length) {
                iceTransport.setRemoteCandidates(cands);
              }
              if (!self.usingBundle || sdpMLineIndex === 0) {
                iceTransport.start(iceGatherer, remoteIceParameters,
                    'controlling');
                dtlsTransport.start(remoteDtlsParameters);
              }

              self._transceive(transceiver,
                  direction === 'sendrecv' || direction === 'recvonly',
                  direction === 'sendrecv' || direction === 'sendonly');

              if (rtpReceiver &&
                  (direction === 'sendrecv' || direction === 'sendonly')) {
                track = rtpReceiver.track;
                receiverList.push([track, rtpReceiver]);
                stream.addTrack(track);
              } else {
                // FIXME: actually the receiver should be created later.
                delete transceiver.rtpReceiver;
              }
            }
          });

          this.remoteDescription = {
            type: description.type,
            sdp: description.sdp
          };
          switch (description.type) {
            case 'offer':
              this._updateSignalingState('have-remote-offer');
              break;
            case 'answer':
              this._updateSignalingState('stable');
              break;
            default:
              throw new TypeError('unsupported type "' + description.type +
                  '"');
          }
          if (stream.getTracks().length) {
            self.remoteStreams.push(stream);
            window.setTimeout(function() {
              var event = new Event('addstream');
              event.stream = stream;
              self.dispatchEvent(event);
              if (self.onaddstream !== null) {
                window.setTimeout(function() {
                  self.onaddstream(event);
                }, 0);
              }

              receiverList.forEach(function(item) {
                var track = item[0];
                var receiver = item[1];
                var trackEvent = new Event('track');
                trackEvent.track = track;
                trackEvent.receiver = receiver;
                trackEvent.streams = [stream];
                self.dispatchEvent(event);
                if (self.ontrack !== null) {
                  window.setTimeout(function() {
                    self.ontrack(trackEvent);
                  }, 0);
                }
              });
            }, 0);
          }
          if (arguments.length > 1 && typeof arguments[1] === 'function') {
            window.setTimeout(arguments[1], 0);
          }
          return Promise.resolve();
        };

    window.RTCPeerConnection.prototype.close = function() {
      this.transceivers.forEach(function(transceiver) {
        /* not yet
        if (transceiver.iceGatherer) {
          transceiver.iceGatherer.close();
        }
        */
        if (transceiver.iceTransport) {
          transceiver.iceTransport.stop();
        }
        if (transceiver.dtlsTransport) {
          transceiver.dtlsTransport.stop();
        }
        if (transceiver.rtpSender) {
          transceiver.rtpSender.stop();
        }
        if (transceiver.rtpReceiver) {
          transceiver.rtpReceiver.stop();
        }
      });
      // FIXME: clean up tracks, local streams, remote streams, etc
      this._updateSignalingState('closed');
    };

    // Update the signaling state.
    window.RTCPeerConnection.prototype._updateSignalingState =
        function(newState) {
          this.signalingState = newState;
          var event = new Event('signalingstatechange');
          this.dispatchEvent(event);
          if (this.onsignalingstatechange !== null) {
            this.onsignalingstatechange(event);
          }
        };

    // Determine whether to fire the negotiationneeded event.
    window.RTCPeerConnection.prototype._maybeFireNegotiationNeeded =
        function() {
          // Fire away (for now).
          var event = new Event('negotiationneeded');
          this.dispatchEvent(event);
          if (this.onnegotiationneeded !== null) {
            this.onnegotiationneeded(event);
          }
        };

    // Update the connection state.
    window.RTCPeerConnection.prototype._updateConnectionState = function() {
      var self = this;
      var newState;
      var states = {
        'new': 0,
        closed: 0,
        connecting: 0,
        checking: 0,
        connected: 0,
        completed: 0,
        failed: 0
      };
      this.transceivers.forEach(function(transceiver) {
        states[transceiver.iceTransport.state]++;
        states[transceiver.dtlsTransport.state]++;
      });
      // ICETransport.completed and connected are the same for this purpose.
      states.connected += states.completed;

      newState = 'new';
      if (states.failed > 0) {
        newState = 'failed';
      } else if (states.connecting > 0 || states.checking > 0) {
        newState = 'connecting';
      } else if (states.disconnected > 0) {
        newState = 'disconnected';
      } else if (states.new > 0) {
        newState = 'new';
      } else if (states.connected > 0 || states.completed > 0) {
        newState = 'connected';
      }

      if (newState !== self.iceConnectionState) {
        self.iceConnectionState = newState;
        var event = new Event('iceconnectionstatechange');
        this.dispatchEvent(event);
        if (this.oniceconnectionstatechange !== null) {
          this.oniceconnectionstatechange(event);
        }
      }
    };

    window.RTCPeerConnection.prototype.createOffer = function() {
      var self = this;
      if (this._pendingOffer) {
        throw new Error('createOffer called while there is a pending offer.');
      }
      var offerOptions;
      if (arguments.length === 1 && typeof arguments[0] !== 'function') {
        offerOptions = arguments[0];
      } else if (arguments.length === 3) {
        offerOptions = arguments[2];
      }

      var tracks = [];
      var numAudioTracks = 0;
      var numVideoTracks = 0;
      // Default to sendrecv.
      if (this.localStreams.length) {
        numAudioTracks = this.localStreams[0].getAudioTracks().length;
        numVideoTracks = this.localStreams[0].getVideoTracks().length;
      }
      // Determine number of audio and video tracks we need to send/recv.
      if (offerOptions) {
        // Reject Chrome legacy constraints.
        if (offerOptions.mandatory || offerOptions.optional) {
          throw new TypeError(
              'Legacy mandatory/optional constraints not supported.');
        }
        if (offerOptions.offerToReceiveAudio !== undefined) {
          numAudioTracks = offerOptions.offerToReceiveAudio;
        }
        if (offerOptions.offerToReceiveVideo !== undefined) {
          numVideoTracks = offerOptions.offerToReceiveVideo;
        }
      }
      if (this.localStreams.length) {
        // Push local streams.
        this.localStreams[0].getTracks().forEach(function(track) {
          tracks.push({
            kind: track.kind,
            track: track,
            wantReceive: track.kind === 'audio' ?
                numAudioTracks > 0 : numVideoTracks > 0
          });
          if (track.kind === 'audio') {
            numAudioTracks--;
          } else if (track.kind === 'video') {
            numVideoTracks--;
          }
        });
      }
      // Create M-lines for recvonly streams.
      while (numAudioTracks > 0 || numVideoTracks > 0) {
        if (numAudioTracks > 0) {
          tracks.push({
            kind: 'audio',
            wantReceive: true
          });
          numAudioTracks--;
        }
        if (numVideoTracks > 0) {
          tracks.push({
            kind: 'video',
            wantReceive: true
          });
          numVideoTracks--;
        }
      }

      var sdp = SDPUtils.writeSessionBoilerplate();
      var transceivers = [];
      tracks.forEach(function(mline, sdpMLineIndex) {
        // For each track, create an ice gatherer, ice transport,
        // dtls transport, potentially rtpsender and rtpreceiver.
        var track = mline.track;
        var kind = mline.kind;
        var mid = SDPUtils.generateIdentifier();

        var transports = self.usingBundle && sdpMLineIndex > 0 ? {
          iceGatherer: transceivers[0].iceGatherer,
          iceTransport: transceivers[0].iceTransport,
          dtlsTransport: transceivers[0].dtlsTransport
        } : self._createIceAndDtlsTransports(mid, sdpMLineIndex);

        var localCapabilities = RTCRtpSender.getCapabilities(kind);
        // filter RTX until additional stuff needed for RTX is implemented
        // in adapter.js
        localCapabilities.codecs = localCapabilities.codecs.filter(
            function(codec) {
              return codec.name !== 'rtx';
            });
        localCapabilities.codecs.forEach(function(codec) {
          // work around https://bugs.chromium.org/p/webrtc/issues/detail?id=6552
          // by adding level-asymmetry-allowed=1
          if (codec.name === 'H264' &&
              codec.parameters['level-asymmetry-allowed'] === undefined) {
            codec.parameters['level-asymmetry-allowed'] = '1';
          }
        });

        var rtpSender;
        var rtpReceiver;

        // generate an ssrc now, to be used later in rtpSender.send
        var sendEncodingParameters = [{
          ssrc: (2 * sdpMLineIndex + 1) * 1001
        }];
        if (track) {
          rtpSender = new RTCRtpSender(track, transports.dtlsTransport);
        }

        if (mline.wantReceive) {
          rtpReceiver = new RTCRtpReceiver(transports.dtlsTransport, kind);
        }

        transceivers[sdpMLineIndex] = {
          iceGatherer: transports.iceGatherer,
          iceTransport: transports.iceTransport,
          dtlsTransport: transports.dtlsTransport,
          localCapabilities: localCapabilities,
          remoteCapabilities: null,
          rtpSender: rtpSender,
          rtpReceiver: rtpReceiver,
          kind: kind,
          mid: mid,
          sendEncodingParameters: sendEncodingParameters,
          recvEncodingParameters: null
        };
      });
      if (this.usingBundle) {
        sdp += 'a=group:BUNDLE ' + transceivers.map(function(t) {
          return t.mid;
        }).join(' ') + '\r\n';
      }
      tracks.forEach(function(mline, sdpMLineIndex) {
        var transceiver = transceivers[sdpMLineIndex];
        sdp += SDPUtils.writeMediaSection(transceiver,
            transceiver.localCapabilities, 'offer', self.localStreams[0]);
      });

      this._pendingOffer = transceivers;
      var desc = new RTCSessionDescription({
        type: 'offer',
        sdp: sdp
      });
      if (arguments.length && typeof arguments[0] === 'function') {
        window.setTimeout(arguments[0], 0, desc);
      }
      return Promise.resolve(desc);
    };

    window.RTCPeerConnection.prototype.createAnswer = function() {
      var self = this;

      var sdp = SDPUtils.writeSessionBoilerplate();
      if (this.usingBundle) {
        sdp += 'a=group:BUNDLE ' + this.transceivers.map(function(t) {
          return t.mid;
        }).join(' ') + '\r\n';
      }
      this.transceivers.forEach(function(transceiver) {
        if (transceiver.isDatachannel) {
          sdp += 'm=application 0 DTLS/SCTP 5000\r\n' +
              'c=IN IP4 0.0.0.0\r\n' +
              'a=mid:' + transceiver.mid + '\r\n';
          return;
        }
        // Calculate intersection of capabilities.
        var commonCapabilities = self._getCommonCapabilities(
            transceiver.localCapabilities,
            transceiver.remoteCapabilities);

        sdp += SDPUtils.writeMediaSection(transceiver, commonCapabilities,
            'answer', self.localStreams[0]);
      });

      var desc = new RTCSessionDescription({
        type: 'answer',
        sdp: sdp
      });
      if (arguments.length && typeof arguments[0] === 'function') {
        window.setTimeout(arguments[0], 0, desc);
      }
      return Promise.resolve(desc);
    };

    window.RTCPeerConnection.prototype.addIceCandidate = function(candidate) {
      if (!candidate) {
        this.transceivers.forEach(function(transceiver) {
          transceiver.iceTransport.addRemoteCandidate({});
        });
      } else {
        var mLineIndex = candidate.sdpMLineIndex;
        if (candidate.sdpMid) {
          for (var i = 0; i < this.transceivers.length; i++) {
            if (this.transceivers[i].mid === candidate.sdpMid) {
              mLineIndex = i;
              break;
            }
          }
        }
        var transceiver = this.transceivers[mLineIndex];
        if (transceiver) {
          var cand = Object.keys(candidate.candidate).length > 0 ?
              SDPUtils.parseCandidate(candidate.candidate) : {};
          // Ignore Chrome's invalid candidates since Edge does not like them.
          if (cand.protocol === 'tcp' && (cand.port === 0 || cand.port === 9)) {
            return;
          }
          // Ignore RTCP candidates, we assume RTCP-MUX.
          if (cand.component !== '1') {
            return;
          }
          // A dirty hack to make samples work.
          if (cand.type === 'endOfCandidates') {
            cand = {};
          }
          transceiver.iceTransport.addRemoteCandidate(cand);

          // update the remoteDescription.
          var sections = SDPUtils.splitSections(this.remoteDescription.sdp);
          sections[mLineIndex + 1] += (cand.type ? candidate.candidate.trim()
              : 'a=end-of-candidates') + '\r\n';
          this.remoteDescription.sdp = sections.join('');
        }
      }
      if (arguments.length > 1 && typeof arguments[1] === 'function') {
        window.setTimeout(arguments[1], 0);
      }
      return Promise.resolve();
    };

    window.RTCPeerConnection.prototype.getStats = function() {
      var promises = [];
      this.transceivers.forEach(function(transceiver) {
        ['rtpSender', 'rtpReceiver', 'iceGatherer', 'iceTransport',
            'dtlsTransport'].forEach(function(method) {
              if (transceiver[method]) {
                promises.push(transceiver[method].getStats());
              }
            });
      });
      var cb = arguments.length > 1 && typeof arguments[1] === 'function' &&
          arguments[1];
      return new Promise(function(resolve) {
        // shim getStats with maplike support
        var results = new Map();
        Promise.all(promises).then(function(res) {
          res.forEach(function(result) {
            Object.keys(result).forEach(function(id) {
              results.set(id, result[id]);
              results[id] = result[id];
            });
          });
          if (cb) {
            window.setTimeout(cb, 0, results);
          }
          resolve(results);
        });
      });
    };
  }
};

// Expose public methods.
module.exports = {
  shimPeerConnection: edgeShim.shimPeerConnection,
  shimGetUserMedia: __webpack_require__(209)
};


/***/ },
/* 209 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */


// Expose public methods.
module.exports = function() {
  var shimError_ = function(e) {
    return {
      name: {PermissionDeniedError: 'NotAllowedError'}[e.name] || e.name,
      message: e.message,
      constraint: e.constraint,
      toString: function() {
        return this.name;
      }
    };
  };

  // getUserMedia error shim.
  var origGetUserMedia = navigator.mediaDevices.getUserMedia.
      bind(navigator.mediaDevices);
  navigator.mediaDevices.getUserMedia = function(c) {
    return origGetUserMedia(c).catch(function(e) {
      return Promise.reject(shimError_(e));
    });
  };
};


/***/ },
/* 210 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */


var browserDetails = __webpack_require__(0).browserDetails;

var firefoxShim = {
  shimOnTrack: function() {
    if (typeof window === 'object' && window.RTCPeerConnection && !('ontrack' in
        window.RTCPeerConnection.prototype)) {
      Object.defineProperty(window.RTCPeerConnection.prototype, 'ontrack', {
        get: function() {
          return this._ontrack;
        },
        set: function(f) {
          if (this._ontrack) {
            this.removeEventListener('track', this._ontrack);
            this.removeEventListener('addstream', this._ontrackpoly);
          }
          this.addEventListener('track', this._ontrack = f);
          this.addEventListener('addstream', this._ontrackpoly = function(e) {
            e.stream.getTracks().forEach(function(track) {
              var event = new Event('track');
              event.track = track;
              event.receiver = {track: track};
              event.streams = [e.stream];
              this.dispatchEvent(event);
            }.bind(this));
          }.bind(this));
        }
      });
    }
  },

  shimSourceObject: function() {
    // Firefox has supported mozSrcObject since FF22, unprefixed in 42.
    if (typeof window === 'object') {
      if (window.HTMLMediaElement &&
        !('srcObject' in window.HTMLMediaElement.prototype)) {
        // Shim the srcObject property, once, when HTMLMediaElement is found.
        Object.defineProperty(window.HTMLMediaElement.prototype, 'srcObject', {
          get: function() {
            return this.mozSrcObject;
          },
          set: function(stream) {
            this.mozSrcObject = stream;
          }
        });
      }
    }
  },

  shimPeerConnection: function() {
    if (typeof window !== 'object' || !(window.RTCPeerConnection ||
        window.mozRTCPeerConnection)) {
      return; // probably media.peerconnection.enabled=false in about:config
    }
    // The RTCPeerConnection object.
    if (!window.RTCPeerConnection) {
      window.RTCPeerConnection = function(pcConfig, pcConstraints) {
        if (browserDetails.version < 38) {
          // .urls is not supported in FF < 38.
          // create RTCIceServers with a single url.
          if (pcConfig && pcConfig.iceServers) {
            var newIceServers = [];
            for (var i = 0; i < pcConfig.iceServers.length; i++) {
              var server = pcConfig.iceServers[i];
              if (server.hasOwnProperty('urls')) {
                for (var j = 0; j < server.urls.length; j++) {
                  var newServer = {
                    url: server.urls[j]
                  };
                  if (server.urls[j].indexOf('turn') === 0) {
                    newServer.username = server.username;
                    newServer.credential = server.credential;
                  }
                  newIceServers.push(newServer);
                }
              } else {
                newIceServers.push(pcConfig.iceServers[i]);
              }
            }
            pcConfig.iceServers = newIceServers;
          }
        }
        return new mozRTCPeerConnection(pcConfig, pcConstraints);
      };
      window.RTCPeerConnection.prototype = mozRTCPeerConnection.prototype;

      // wrap static methods. Currently just generateCertificate.
      if (mozRTCPeerConnection.generateCertificate) {
        Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
          get: function() {
            return mozRTCPeerConnection.generateCertificate;
          }
        });
      }

      window.RTCSessionDescription = mozRTCSessionDescription;
      window.RTCIceCandidate = mozRTCIceCandidate;
    }

    // shim away need for obsolete RTCIceCandidate/RTCSessionDescription.
    ['setLocalDescription', 'setRemoteDescription', 'addIceCandidate']
        .forEach(function(method) {
          var nativeMethod = RTCPeerConnection.prototype[method];
          RTCPeerConnection.prototype[method] = function() {
            arguments[0] = new ((method === 'addIceCandidate') ?
                RTCIceCandidate : RTCSessionDescription)(arguments[0]);
            return nativeMethod.apply(this, arguments);
          };
        });

    // support for addIceCandidate(null or undefined)
    var nativeAddIceCandidate =
        RTCPeerConnection.prototype.addIceCandidate;
    RTCPeerConnection.prototype.addIceCandidate = function() {
      if (!arguments[0]) {
        if (arguments[1]) {
          arguments[1].apply(null);
        }
        return Promise.resolve();
      }
      return nativeAddIceCandidate.apply(this, arguments);
    };

    if (browserDetails.version < 48) {
      // shim getStats with maplike support
      var makeMapStats = function(stats) {
        var map = new Map();
        Object.keys(stats).forEach(function(key) {
          map.set(key, stats[key]);
          map[key] = stats[key];
        });
        return map;
      };

      var nativeGetStats = RTCPeerConnection.prototype.getStats;
      RTCPeerConnection.prototype.getStats = function(selector, onSucc, onErr) {
        return nativeGetStats.apply(this, [selector || null])
          .then(function(stats) {
            return makeMapStats(stats);
          })
          .then(onSucc, onErr);
      };
    }
  }
};

// Expose public methods.
module.exports = {
  shimOnTrack: firefoxShim.shimOnTrack,
  shimSourceObject: firefoxShim.shimSourceObject,
  shimPeerConnection: firefoxShim.shimPeerConnection,
  shimGetUserMedia: __webpack_require__(211)
};


/***/ },
/* 211 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */
 /* eslint-env node */


var logging = __webpack_require__(0).log;
var browserDetails = __webpack_require__(0).browserDetails;

// Expose public methods.
module.exports = function() {
  var shimError_ = function(e) {
    return {
      name: {
        SecurityError: 'NotAllowedError',
        PermissionDeniedError: 'NotAllowedError'
      }[e.name] || e.name,
      message: {
        'The operation is insecure.': 'The request is not allowed by the ' +
        'user agent or the platform in the current context.'
      }[e.message] || e.message,
      constraint: e.constraint,
      toString: function() {
        return this.name + (this.message && ': ') + this.message;
      }
    };
  };

  // getUserMedia constraints shim.
  var getUserMedia_ = function(constraints, onSuccess, onError) {
    var constraintsToFF37_ = function(c) {
      if (typeof c !== 'object' || c.require) {
        return c;
      }
      var require = [];
      Object.keys(c).forEach(function(key) {
        if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
          return;
        }
        var r = c[key] = (typeof c[key] === 'object') ?
            c[key] : {ideal: c[key]};
        if (r.min !== undefined ||
            r.max !== undefined || r.exact !== undefined) {
          require.push(key);
        }
        if (r.exact !== undefined) {
          if (typeof r.exact === 'number') {
            r. min = r.max = r.exact;
          } else {
            c[key] = r.exact;
          }
          delete r.exact;
        }
        if (r.ideal !== undefined) {
          c.advanced = c.advanced || [];
          var oc = {};
          if (typeof r.ideal === 'number') {
            oc[key] = {min: r.ideal, max: r.ideal};
          } else {
            oc[key] = r.ideal;
          }
          c.advanced.push(oc);
          delete r.ideal;
          if (!Object.keys(r).length) {
            delete c[key];
          }
        }
      });
      if (require.length) {
        c.require = require;
      }
      return c;
    };
    constraints = JSON.parse(JSON.stringify(constraints));
    if (browserDetails.version < 38) {
      logging('spec: ' + JSON.stringify(constraints));
      if (constraints.audio) {
        constraints.audio = constraintsToFF37_(constraints.audio);
      }
      if (constraints.video) {
        constraints.video = constraintsToFF37_(constraints.video);
      }
      logging('ff37: ' + JSON.stringify(constraints));
    }
    return navigator.mozGetUserMedia(constraints, onSuccess, function(e) {
      onError(shimError_(e));
    });
  };

  // Returns the result of getUserMedia as a Promise.
  var getUserMediaPromise_ = function(constraints) {
    return new Promise(function(resolve, reject) {
      getUserMedia_(constraints, resolve, reject);
    });
  };

  // Shim for mediaDevices on older versions.
  if (!navigator.mediaDevices) {
    navigator.mediaDevices = {getUserMedia: getUserMediaPromise_,
      addEventListener: function() { },
      removeEventListener: function() { }
    };
  }
  navigator.mediaDevices.enumerateDevices =
      navigator.mediaDevices.enumerateDevices || function() {
        return new Promise(function(resolve) {
          var infos = [
            {kind: 'audioinput', deviceId: 'default', label: '', groupId: ''},
            {kind: 'videoinput', deviceId: 'default', label: '', groupId: ''}
          ];
          resolve(infos);
        });
      };

  if (browserDetails.version < 41) {
    // Work around http://bugzil.la/1169665
    var orgEnumerateDevices =
        navigator.mediaDevices.enumerateDevices.bind(navigator.mediaDevices);
    navigator.mediaDevices.enumerateDevices = function() {
      return orgEnumerateDevices().then(undefined, function(e) {
        if (e.name === 'NotFoundError') {
          return [];
        }
        throw e;
      });
    };
  }
  if (browserDetails.version < 49) {
    var origGetUserMedia = navigator.mediaDevices.getUserMedia.
        bind(navigator.mediaDevices);
    navigator.mediaDevices.getUserMedia = function(c) {
      return origGetUserMedia(c).then(function(stream) {
        // Work around https://bugzil.la/802326
        if (c.audio && !stream.getAudioTracks().length ||
            c.video && !stream.getVideoTracks().length) {
          stream.getTracks().forEach(function(track) {
            track.stop();
          });
          throw new DOMException('The object can not be found here.',
                                 'NotFoundError');
        }
        return stream;
      }, function(e) {
        return Promise.reject(shimError_(e));
      });
    };
  }
  navigator.getUserMedia = function(constraints, onSuccess, onError) {
    if (browserDetails.version < 44) {
      return getUserMedia_(constraints, onSuccess, onError);
    }
    // Replace Firefox 44+'s deprecation warning with unprefixed version.
    console.warn('navigator.getUserMedia has been replaced by ' +
                 'navigator.mediaDevices.getUserMedia');
    navigator.mediaDevices.getUserMedia(constraints).then(onSuccess, onError);
  };
};


/***/ },
/* 212 */
/***/ function(module, exports, __webpack_require__) {

"use strict";
/*
 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */

var safariShim = {
  // TODO: DrAlex, should be here, double check against LayoutTests
  // shimOnTrack: function() { },

  // TODO: once the back-end for the mac port is done, add.
  // TODO: check for webkitGTK+
  // shimPeerConnection: function() { },

  shimGetUserMedia: function() {
    navigator.getUserMedia = navigator.webkitGetUserMedia;
  }
};

// Expose public methods.
module.exports = {
  shimGetUserMedia: safariShim.shimGetUserMedia
  // TODO
  // shimOnTrack: safariShim.shimOnTrack,
  // shimPeerConnection: safariShim.shimPeerConnection
};


/***/ },
/* 213 */
/***/ function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(71);


/***/ }
/******/ ])
});
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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