/*!
 * tui-chart
 * @fileoverview tui-chart
 * @author NHN Ent. FE Development Lab <dl_javascript@nhnent.com>
 * @version 2.17.1
 * @license MIT
 * @link https://github.com/nhnent/tui.chart
 * bundle created at "Tue Apr 17 2018 10:21:01 GMT+0900 (KST)"
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("raphael"), require("tui-code-snippet"));
	else if(typeof define === 'function' && define.amd)
		define(["raphael", "tui-code-snippet"], factory);
	else if(typeof exports === 'object')
		exports["chart"] = factory(require("raphael"), require("tui-code-snippet"));
	else
		root["tui"] = root["tui"] || {}, root["tui"]["chart"] = factory(root["Raphael"], (root["tui"] && root["tui"]["util"]));
})(this, function(__WEBPACK_EXTERNAL_MODULE_3__, __WEBPACK_EXTERNAL_MODULE_6__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/dist/";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';

	var pluginRaphael = __webpack_require__(2);
	var chart = __webpack_require__(29);
	__webpack_require__(147);

	chart.registerPlugin(pluginRaphael.name, pluginRaphael.plugins, pluginRaphael.callback);
	chart.renderUtil = __webpack_require__(7);
	chart.arrayUtil = __webpack_require__(10);
	chart.colorutil = __webpack_require__(138);

	/**
	 * NHN Entertainment Toast UI Chart.
	 * @namespace tui.chart
	 */
	module.exports = chart;


/***/ }),
/* 1 */,
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raphael render plugin.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphael = __webpack_require__(3);

	var BarChart = __webpack_require__(4);
	var Boxplot = __webpack_require__(12);
	var Bullet = __webpack_require__(13);
	var LineChart = __webpack_require__(14);
	var AreaChart = __webpack_require__(16);
	var PieChart = __webpack_require__(18);
	var RadialLineSeries = __webpack_require__(19);
	var CoordinateTypeChart = __webpack_require__(20);
	var BoxTypeChart = __webpack_require__(21);
	var MapChart = __webpack_require__(22);

	var legend = __webpack_require__(23);
	var MapLegend = __webpack_require__(24);
	var CircleLegend = __webpack_require__(25);
	var title = __webpack_require__(26);
	var axis = __webpack_require__(27);

	var RadialPlot = __webpack_require__(28);

	var pluginRaphael = {
	    bar: BarChart,
	    boxplot: Boxplot,
	    bullet: Bullet,
	    column: BarChart,
	    line: LineChart,
	    area: AreaChart,
	    pie: PieChart,
	    bubble: CoordinateTypeChart,
	    scatter: CoordinateTypeChart,
	    heatmap: BoxTypeChart,
	    treemap: BoxTypeChart,
	    map: MapChart,
	    radial: RadialLineSeries,
	    legend: legend,
	    mapLegend: MapLegend,
	    circleLegend: CircleLegend,
	    radialPlot: RadialPlot,
	    title: title,
	    axis: axis
	};
	var callback = function(container, dimension) {
	    var paper = raphael(container, dimension.width, dimension.height);
	    var rect = paper.rect(0, 0, dimension.width, dimension.height);

	    if (paper.raphael.svg) {
	        appendGlowFilterToDefs(paper);
	    }

	    paper.pushDownBackgroundToBottom = function() {
	        rect.toBack();
	    };

	    paper.changeChartBackgroundColor = function(color) {
	        rect.attr({
	            fill: color
	        });
	    };

	    paper.changeChartBackgroundOpacity = function(opacity) {
	        rect.attr({
	            'fill-opacity': opacity
	        });
	    };

	    paper.resizeBackground = function(width, height) {
	        rect.attr({
	            width: width,
	            height: height
	        });
	    };

	    rect.attr({
	        fill: '#fff',
	        'stroke-width': 0
	    });

	    return paper;
	};

	/**
	 * Append glow filter for series label
	 * @param {object} paper Raphael paper object
	 * @ignore
	 */
	function appendGlowFilterToDefs(paper) {
	    var filter = document.createElementNS('http://www.w3.org/2000/svg', 'filter');
	    var feGaussianBlur = document.createElementNS('http://www.w3.org/2000/svg', 'feGaussianBlur');
	    var feFlood = document.createElementNS('http://www.w3.org/2000/svg', 'feFlood');
	    var feComposite = document.createElementNS('http://www.w3.org/2000/svg', 'feComposite');
	    var feMorphology = document.createElementNS('http://www.w3.org/2000/svg', 'feMorphology');
	    var feMerge = document.createElementNS('http://www.w3.org/2000/svg', 'feMerge');
	    var feMergeNodeColoredBlur = document.createElementNS('http://www.w3.org/2000/svg', 'feMergeNode');
	    var feMergeNodeSourceGraphic = document.createElementNS('http://www.w3.org/2000/svg', 'feMergeNode');

	    filter.id = 'glow';

	    feFlood.setAttribute('result', 'flood');
	    feFlood.setAttribute('flood-color', '#ffffff');
	    feFlood.setAttribute('flood-opacity', '0.5');

	    feComposite.setAttribute('in', 'flood');
	    feComposite.setAttribute('result', 'mask');
	    feComposite.setAttribute('in2', 'SourceGraphic');
	    feComposite.setAttribute('operator', 'in');

	    feMorphology.setAttribute('in', 'mask');
	    feMorphology.setAttribute('result', 'dilated');
	    feMorphology.setAttribute('operator', 'dilate');
	    feMorphology.setAttribute('radius', '2');

	    feGaussianBlur.setAttribute('in', 'dilated');
	    feGaussianBlur.setAttribute('result', 'blurred');
	    feGaussianBlur.setAttribute('stdDeviation', '1');

	    feMergeNodeColoredBlur.setAttribute('in', 'blurred');
	    feMergeNodeSourceGraphic.setAttribute('in', 'SourceGraphic');

	    filter.appendChild(feFlood);
	    filter.appendChild(feComposite);
	    filter.appendChild(feMorphology);
	    filter.appendChild(feGaussianBlur);

	    filter.appendChild(feMerge);

	    feMerge.appendChild(feMergeNodeColoredBlur);
	    feMerge.appendChild(feMergeNodeSourceGraphic);

	    paper.defs.appendChild(filter);
	}

	module.exports = {
	    name: 'Raphael',
	    plugins: pluginRaphael,
	    callback: callback
	};



/***/ }),
/* 3 */
/***/ (function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_3__;

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raphael bar chart renderer.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var snippet = __webpack_require__(6);
	var raphael = __webpack_require__(3);

	var ANIMATION_DURATION = 700;
	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;
	var DEFAULT_LUMINANC = 0.2;
	var SERIES_EXTRA_VISUAL_AREA_FOR_ZERO = 2;

	/**
	 * @classdesc RaphaelBarChart is graph renderer for bar, column chart.
	 * @class RaphaelBarChart
	 * @private
	 */
	var RaphaelBarChart = snippet.defineClass(/** @lends RaphaelBarChart.prototype */ {
	    /**
	     * Render function of bar chart
	     * @param {object} paper paper object
	     * @param {{size: object, model: object, options: object, tooltipPosition: string}} data chart data
	     * @returns {Array.<object>} seriesSet
	     */
	    render: function(paper, data) {
	        var groupBounds = data.groupBounds;

	        if (!groupBounds) {
	            return null;
	        }

	        this.paper = paper;

	        this.theme = data.theme;
	        this.seriesDataModel = data.seriesDataModel;
	        this.chartType = data.chartType;

	        this.paper.setStart();

	        this.options = data.options;
	        this.theme = data.theme;
	        this.groupBars = this._renderBars(groupBounds);
	        this.groupBorders = this._renderBarBorders(groupBounds);

	        this.overlay = this._renderOverlay();
	        this.groupBounds = groupBounds;

	        return this.paper.setFinish();
	    },

	    /**
	     * Render overlay.
	     * @returns {object} raphael object
	     * @private
	     */
	    _renderOverlay: function() {
	        var bound = {
	            width: 1,
	            height: 1,
	            left: 0,
	            top: 0
	        };
	        var attributes = {
	            'fill-opacity': 0
	        };

	        return this._renderBar(bound, '#fff', attributes);
	    },

	    /**
	     * Render rect
	     * @param {{left: number, top: number, width: number, height: number}} bound bound
	     * @param {string} color series color
	     * @param {object} [attributes] - attributes
	     * @returns {object} bar rect
	     * @private
	     */
	    _renderBar: function(bound, color, attributes) {
	        var rect;

	        if (bound.width < 0 || bound.height < 0) {
	            return null;
	        }

	        rect = raphaelRenderUtil.renderRect(this.paper, bound, snippet.extend({
	            fill: color,
	            stroke: 'none'
	        }, attributes));

	        return rect;
	    },

	    /**
	     * Render bars.
	     * @param {Array.<Array.<{left: number, top:number, width: number, height: number}>>} groupBounds bounds
	     * @returns {Array.<Array.<object>>} bars
	     * @private
	     */
	    _renderBars: function(groupBounds) {
	        var self = this;
	        var colors = this.theme.colors;
	        var colorByPoint = this.options.colorByPoint;
	        var groupBars = snippet.map(groupBounds, function(bounds, groupIndex) {
	            return snippet.map(bounds, function(bound, index) {
	                var color, rect, item;

	                if (!bound) {
	                    return null;
	                }

	                item = self.seriesDataModel.getSeriesItem(groupIndex, index);

	                color = colorByPoint ? colors[groupIndex] : colors[index];
	                rect = self._renderBar(bound.start, color);

	                return {
	                    rect: rect,
	                    color: color,
	                    bound: bound.end,
	                    item: item,
	                    groupIndex: groupIndex,
	                    index: index,
	                    isRange: item.isRange
	                };
	            });
	        });

	        return groupBars;
	    },

	    /**
	     * Make rect points.
	     * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	     * @returns {{
	     *      leftTop: {left: number, top: number},
	     *      rightTop: {left: number, top: number},
	     *      rightBottom: {left: number, top: number},
	     *      leftBottom: {left: number, top: number}
	     * }} rect points
	     * @private
	     */
	    _makeRectPoints: function(bound) {
	        return {
	            leftTop: {
	                left: Math.ceil(bound.left),
	                top: Math.ceil(bound.top)
	            },
	            rightTop: {
	                left: Math.ceil(bound.left + bound.width),
	                top: Math.ceil(bound.top)
	            },
	            rightBottom: {
	                left: Math.ceil(bound.left + bound.width),
	                top: Math.ceil(bound.top + bound.height)
	            },
	            leftBottom: {
	                left: Math.ceil(bound.left),
	                top: Math.ceil(bound.top + bound.height)
	            }
	        };
	    },

	    /**
	     * Make top line path.
	     * @param {object} points points
	     *      @param {{left: number, top: number}} points.leftTop left top
	     *      @param {{left: number, top: number}} points.rightTop right top
	     * @param {string} chartType chart type
	     * @param {Item} item item
	     * @returns {string} top line path
	     * @private
	     */
	    _makeTopLinePath: function(points, chartType, item) {
	        var linePath = null,
	            value = item.value,
	            cloneLeftTop;

	        if (chartType === 'bar' || value >= 0 || item.isRange) {
	            cloneLeftTop = snippet.extend({}, points.leftTop);
	            cloneLeftTop.left -= chartType === 'column' || value < 0 ? 1 : 0;
	            linePath = raphaelRenderUtil.makeLinePath(cloneLeftTop, points.rightTop).join(' ');
	        }

	        return linePath;
	    },

	    /**
	     * Make right line path.
	     * @param {object} points points
	     *      @param {{left: number, top: number}} points.rightTop right top
	     *      @param {{left: number, top: number}} points.rightBottom right bottom
	     * @param {string} chartType chart type
	     * @param {Item} item item
	     * @returns {string} top line path
	     * @private
	     */
	    _makeRightLinePath: function(points, chartType, item) {
	        var linePath = null;

	        if (chartType === 'column' || item.value >= 0 || item.isRange) {
	            linePath = raphaelRenderUtil.makeLinePath(points.rightTop, points.rightBottom).join(' ');
	        }

	        return linePath;
	    },

	    /**
	     * Make bottom line path.
	     * @param {object} points points
	     *      @param {{left: number, top: number}} points.lefBottom left bottom
	     *      @param {{left: number, top: number}} points.rightBottom right bottom
	     * @param {string} chartType chart type
	     * @param {Item} item item
	     * @returns {string} top line path
	     * @private
	     */
	    _makeBottomLinePath: function(points, chartType, item) {
	        var linePath = null;

	        if (chartType === 'bar' || item.value < 0 || item.isRange) {
	            linePath = raphaelRenderUtil.makeLinePath(points.leftBottom, points.rightBottom).join(' ');
	        }

	        return linePath;
	    },

	    /**
	     * Make left line path.
	     * @param {object} points points
	     *      @param {{left: number, top: number}} points.lefTop left top
	     *      @param {{left: number, top: number}} points.leftBottom left bottom
	     * @param {string} chartType chart type
	     * @param {Item} item item
	     * @returns {string} top line path
	     * @private
	     */
	    _makeLeftLinePath: function(points, chartType, item) {
	        var linePath = null;

	        if (chartType === 'column' || item.value < 0 || item.isRange) {
	            linePath = raphaelRenderUtil.makeLinePath(points.leftTop, points.leftBottom).join(' ');
	        }

	        return linePath;
	    },

	    /**
	     * Make border lines paths.
	     * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	     * @param {string} chartType chart type
	     * @param {Item} item item
	     * @returns {{top: string, right: string, bottom: string, left: string}} paths
	     * @private
	     */
	    _makeBorderLinesPaths: function(bound, chartType, item) {
	        var points = this._makeRectPoints(bound),
	            paths = {
	                top: this._makeTopLinePath(points, chartType, item),
	                right: this._makeRightLinePath(points, chartType, item),
	                bottom: this._makeBottomLinePath(points, chartType, item),
	                left: this._makeLeftLinePath(points, chartType, item)
	            };

	        return snippet.filter(paths, function(path) {
	            return path;
	        });
	    },

	    /**
	     * Render border lines;
	     * @param {{left: number, top:number, width: number, height: number}} bound bar bound
	     * @param {string} borderColor border color
	     * @param {string} chartType chart type
	     * @param {Item} item item
	     * @returns {object} raphael object
	     * @private
	     */
	    _renderBorderLines: function(bound, borderColor, chartType, item) {
	        var self = this,
	            borderLinePaths = this._makeBorderLinesPaths(bound, chartType, item),
	            lines = {};

	        snippet.forEach(borderLinePaths, function(path, name) {
	            lines[name] = raphaelRenderUtil.renderLine(self.paper, path, borderColor, 1);
	        });

	        return lines;
	    },

	    /**
	     * Render bar borders.
	     * @param {Array.<Array.<{left: number, top:number, width: number, height: number}>>} groupBounds bounds
	     * @returns {Array.<Array.<object>>} borders
	     * @private
	     */
	    _renderBarBorders: function(groupBounds) {
	        var self = this,
	            borderColor = this.theme.borderColor,
	            groupBorders;

	        if (!borderColor) {
	            return null;
	        }

	        groupBorders = snippet.map(groupBounds, function(bounds, groupIndex) {
	            return snippet.map(bounds, function(bound, index) {
	                var seriesItem;

	                if (!bound) {
	                    return null;
	                }

	                seriesItem = self.seriesDataModel.getSeriesItem(groupIndex, index);

	                return self._renderBorderLines(bound.start, borderColor, self.chartType, seriesItem);
	            });
	        });

	        return groupBorders;
	    },

	    /**
	     * Animate rect.
	     * @param {object} rect raphael object
	     * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	     * @private
	     */
	    _animateRect: function(rect, bound) {
	        rect.animate({
	            x: bound.width ? bound.left : bound.left - (SERIES_EXTRA_VISUAL_AREA_FOR_ZERO / 2),
	            y: bound.height ? bound.top : bound.top - (SERIES_EXTRA_VISUAL_AREA_FOR_ZERO / 2),
	            width: bound.width ? bound.width : SERIES_EXTRA_VISUAL_AREA_FOR_ZERO,
	            height: bound.height ? bound.height : SERIES_EXTRA_VISUAL_AREA_FOR_ZERO
	        }, ANIMATION_DURATION, '>');
	    },

	    /**
	     * Animate borders.
	     * @param {Array.<object>} lines raphael objects
	     * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	     * @param {string} chartType chart type
	     * @param {Item} item item
	     * @private
	     */
	    _animateBorders: function(lines, bound, chartType, item) {
	        var paths = this._makeBorderLinesPaths(bound, chartType, item);

	        snippet.forEach(lines, function(line, name) {
	            line.animate({
	                path: paths[name]
	            }, ANIMATION_DURATION, '>');
	        });
	    },

	    /**
	     * Animate.
	     * @param {function} onFinish finish callback function
	     */
	    animate: function(onFinish) {
	        var self = this,
	            groupBorders = this.groupBorders || [];

	        raphaelRenderUtil.forEach2dArray(this.groupBars, function(bar, groupIndex, index) {
	            var lines = groupBorders[groupIndex] && groupBorders[groupIndex][index];
	            if (!bar) {
	                return;
	            }
	            self._animateRect(bar.rect, bar.bound);
	            if (lines) {
	                self._animateBorders(lines, bar.bound, self.chartType, bar.item);
	            }
	        });

	        if (onFinish) {
	            this.callbackTimeout = setTimeout(function() {
	                onFinish();
	                delete self.callbackTimeout;
	            }, ANIMATION_DURATION);
	        }
	    },

	    /**
	     * Show animation.
	     * @param {{groupIndex: number, index:number}} data show info
	     */
	    showAnimation: function(data) {
	        var bar = this.groupBars[data.groupIndex][data.index],
	            bound = bar.bound;
	        this.overlay.attr({
	            width: bound.width,
	            height: bound.height,
	            x: bound.left,
	            y: bound.top,
	            'fill-opacity': 0.3
	        });
	    },

	    /**
	     * Hide animation.
	     */
	    hideAnimation: function() {
	        this.overlay.attr({
	            width: 1,
	            height: 1,
	            x: 0,
	            y: 0,
	            'fill-opacity': 0
	        });
	    },

	    /**
	     * Update rect bound
	     * @param {object} rect raphael object
	     * @param {{left: number, top: number, width: number, height: number}} bound bound
	     * @private
	     */
	    _updateRectBound: function(rect, bound) {
	        rect.attr({
	            x: bound.left,
	            y: bound.top,
	            width: bound.width,
	            height: bound.height
	        });
	    },

	    /**
	     * Resize graph of bar type chart.
	     * @param {object} params parameters
	     *      @param {{width: number, height:number}} params.dimension dimension
	     *      @param {Array.<Array.<{
	     *                  left:number, top:number, width: number, height: number
	     *              }>>} params.groupBounds group bounds
	     */
	    resize: function(params) {
	        var self = this,
	            groupBorders = this.groupBorders || [],
	            dimension = params.dimension,
	            groupBounds = params.groupBounds;

	        this.groupBounds = groupBounds;
	        this.paper.setSize(dimension.width, dimension.height);

	        raphaelRenderUtil.forEach2dArray(this.groupBars, function(bar, groupIndex, index) {
	            var lines, bound;

	            if (!bar) {
	                return;
	            }

	            lines = groupBorders[groupIndex] && groupBorders[groupIndex][index];
	            bound = groupBounds[groupIndex][index].end;
	            bar.bound = bound;
	            raphaelRenderUtil.updateRectBound(bar.rect, bound);

	            if (lines) {
	                self._updateBordersPath(lines, bound, self.chartType, bar.item);
	            }
	        });
	    },

	    /**
	     * Change borders color.
	     * @param {Array.<object>} lines raphael objects
	     * @param {borderColor} borderColor border color
	     * @private
	     */
	    _changeBordersColor: function(lines, borderColor) {
	        snippet.forEach(lines, function(line) {
	            line.attr({stroke: borderColor});
	        });
	    },

	    /**
	     * Change bar color.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     * @param {string} color fill color
	     * @param {?string} borderColor stroke color
	     * @private
	     */
	    _changeBarColor: function(indexes, color, borderColor) {
	        var bar = this.groupBars[indexes.groupIndex][indexes.index],
	            lines;

	        bar.rect.attr({
	            fill: color
	        });

	        if (borderColor) {
	            lines = this.groupBorders[indexes.groupIndex][indexes.index];
	            this._changeBordersColor(lines, borderColor);
	        }
	    },

	    /**
	     * Select series.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     */
	    selectSeries: function(indexes) {
	        var bar = this.groupBars[indexes.groupIndex][indexes.index],
	            objColor = raphael.color(bar.color),
	            selectionColorTheme = this.theme.selectionColor,
	            color = selectionColorTheme || raphaelRenderUtil.makeChangedLuminanceColor(objColor.hex, DEFAULT_LUMINANC),
	            borderColor = this.theme.borderColor,
	            objBorderColor;

	        if (borderColor) {
	            objBorderColor = raphael.color(borderColor);
	            borderColor = raphaelRenderUtil.makeChangedLuminanceColor(objBorderColor.hex, DEFAULT_LUMINANC);
	        }

	        this._changeBarColor(indexes, color, borderColor);
	    },

	    /**
	     * Unselect series.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     */
	    unselectSeries: function(indexes) {
	        var bar = this.groupBars[indexes.groupIndex][indexes.index],
	            borderColor = this.theme.borderColor;
	        this._changeBarColor(indexes, bar.color, borderColor);
	    },

	    /**
	     * Select legend.
	     * @param {?number} legendIndex legend index
	     */
	    selectLegend: function(legendIndex) {
	        var groupBorders = this.groupBorders || [],
	            noneSelected = snippet.isNull(legendIndex);

	        raphaelRenderUtil.forEach2dArray(this.groupBars, function(bar, groupIndex, index) {
	            var lines, opacity;

	            if (!bar) {
	                return;
	            }

	            lines = groupBorders[groupIndex] && groupBorders[groupIndex][index];
	            opacity = (noneSelected || legendIndex === index) ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;

	            bar.rect.attr({'fill-opacity': opacity});
	            if (lines) {
	                snippet.forEach(lines, function(line) {
	                    line.attr({'stroke-opacity': opacity});
	                });
	            }
	        });
	    },

	    renderSeriesLabel: function(paper, groupPositions, groupLabels, labelTheme, isStacked) {
	        var textAnchor = (isStacked || this.chartType === 'column') ? 'middle' : 'start';
	        var attributes = {
	            'font-size': labelTheme.fontSize,
	            'font-family': labelTheme.fontFamily,
	            'font-weight': labelTheme.fontWeight,
	            fill: labelTheme.color,
	            opacity: 0,
	            'text-anchor': textAnchor
	        };
	        var labelSet = paper.set();

	        snippet.forEach(groupLabels, function(categoryLabel, categoryIndex) {
	            snippet.forEach(categoryLabel, function(label, seriesIndex) {
	                var position = groupPositions[categoryIndex][seriesIndex];
	                var endLabel = raphaelRenderUtil.renderText(paper, position.end, label.end, attributes);
	                var startLabel;

	                endLabel.node.style.userSelect = 'none';
	                endLabel.node.style.cursor = 'default';
	                endLabel.node.setAttribute('filter', 'url(#glow)');

	                labelSet.push(endLabel);

	                if (position.start) {
	                    startLabel = raphaelRenderUtil.renderText(paper, position.start, label.start, attributes);
	                    startLabel.node.style.userSelect = 'none';
	                    startLabel.node.style.cursor = 'default';
	                    startLabel.node.setAttribute('filter', 'url(#glow)');

	                    labelSet.push(startLabel);
	                }
	            });
	        });

	        return labelSet;
	    }
	});

	module.exports = RaphaelBarChart;


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Util for raphael rendering.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);
	var renderUtil = __webpack_require__(7);
	var raphael = __webpack_require__(3);

	/**
	 * Util for raphael rendering.
	 * @module raphaelRenderUtil
	 * @private
	 */
	var raphaelRenderUtil = {

	    /**
	     * Make line path.
	     * @memberOf module:raphaelRenderUtil
	     * @param {{top: number, left: number}} fromPos from position
	     * @param {{top: number, left: number}} toPos to position
	     * @param {number} width width
	     * @returns {string} path
	     */
	    makeLinePath: function(fromPos, toPos, width) {
	        var fromPoint = [fromPos.left, fromPos.top];
	        var toPoint = [toPos.left, toPos.top];
	        var additionalPoint;

	        width = width || 1;
	        additionalPoint = (width % 2 / 2);

	        snippet.forEachArray(fromPoint, function(from, index) {
	            if (from === toPoint[index]) {
	                fromPoint[index] = toPoint[index] = Math.round(from) - additionalPoint;
	            }
	        });

	        return ['M'].concat(fromPoint).concat('L').concat(toPoint);
	    },

	    /**
	     * Render line.
	     * @memberOf module:raphaelRenderUtil
	     * @param {object} paper raphael paper
	     * @param {string} path line path
	     * @param {string} color line color
	     * @param {number} strokeWidth stroke width
	     * @returns {object} raphael line
	     */
	    renderLine: function(paper, path, color, strokeWidth) {
	        var line = paper.path([path]),
	            strokeStyle = {
	                stroke: color,
	                'stroke-width': strokeWidth || 2
	            };

	        if (color === 'transparent') {
	            strokeStyle.stroke = '#fff';
	            strokeStyle['stroke-opacity'] = 0;
	        }
	        line.attr(strokeStyle);

	        return line;
	    },

	    /**
	     * text ellipsis for fixed width
	     * @param {string} text - target text
	     * @param {number} fixedWidth - width for elipsis
	     * @param {object} theme - lable theme
	     * @returns {string}
	     */
	    getEllipsisText: function(text, fixedWidth, theme) {
	        var textArray = text.split('');
	        var textLength = textArray.length;
	        var dotWidth = this.getRenderedTextSize('.', theme.fontSize, theme.fontFamily).width;
	        var textWidth = dotWidth * 2;
	        var newString = '';
	        var i = 0;

	        for (; i < textLength; i += 1) {
	            textWidth += this.getRenderedTextSize(textArray[i], theme.fontSize, theme.fontFamily).width;
	            if (textWidth >= fixedWidth) {
	                newString += '..';
	                break;
	            }
	            newString += textArray[i];
	        }

	        return newString;
	    },

	    /**
	     * Render text
	     * @param {object} paper - Raphael paper object
	     * @param {{left: number, top: number}} pos - text object position
	     * @param {string} text - text content
	     * @param {object} [attributes] - text object's attributes
	     * @returns {object}
	     */
	    renderText: function(paper, pos, text, attributes) {
	        var textObj = paper.text(pos.left, pos.top, snippet.decodeHTMLEntity(String(text)));

	        if (attributes) {
	            if (attributes['dominant-baseline']) {
	                textObj.node.setAttribute('dominant-baseline', attributes['dominant-baseline']);
	            } else {
	                textObj.node.setAttribute('dominant-baseline', 'central');
	            }

	            textObj.attr(attributes);
	        }

	        return textObj;
	    },

	    /**
	     * Render area graph.
	     * @param {object} paper raphael paper
	     * @param {string} path path
	     * @param {object} fillStyle fill style
	     *      @param {string} fillStyle.fill fill color
	     *      @param {?number} fillStyle.opacity fill opacity
	     *      @param {string} fillStyle.stroke stroke color
	     *      @param {?number} fillStyle.stroke-opacity stroke opacity
	     * @returns {Array.<object>} raphael object
	     */
	    renderArea: function(paper, path, fillStyle) {
	        var area = paper.path(path);

	        fillStyle = snippet.extend({
	            'stroke-opacity': 0
	        }, fillStyle);
	        area.attr(fillStyle);

	        return area;
	    },

	    /**
	     * Render circle.
	     * @param {object} paper - raphael object
	     * @param {{left: number, top: number}} position - position
	     * @param {number} radius - radius
	     * @param {object} attributes - attributes
	     * @returns {object}
	     */
	    renderCircle: function(paper, position, radius, attributes) {
	        var circle = paper.circle(position.left, position.top, radius);

	        if (attributes) {
	            circle.attr(attributes);
	        }

	        return circle;
	    },

	    /**
	     * Render rect.
	     * @param {object} paper - raphael object
	     * @param {{left: number, top: number, width: number, height, number}} bound - bound
	     * @param {object} attributes - attributes
	     * @returns {*}
	     */
	    renderRect: function(paper, bound, attributes) {
	        var rect = paper.rect(bound.left, bound.top, bound.width, bound.height);

	        if (attributes) {
	            rect.attr(attributes);
	        }

	        return rect;
	    },

	    /**
	     * Update rect bound
	     * @param {object} rect raphael object
	     * @param {{left: number, top: number, width: number, height: number}} bound bound
	     */
	    updateRectBound: function(rect, bound) {
	        rect.attr({
	            x: bound.left,
	            y: bound.top,
	            width: bound.width,
	            height: bound.height
	        });
	    },

	    /**
	     * Render items of line type chart.
	     * @param {Array.<Array.<object>>} groupItems group items
	     * @param {function} funcRenderItem function
	     */
	    forEach2dArray: function(groupItems, funcRenderItem) {
	        if (groupItems) {
	            snippet.forEachArray(groupItems, function(items, groupIndex) {
	                snippet.forEachArray(items, function(item, index) {
	                    funcRenderItem(item, groupIndex, index);
	                });
	            });
	        }
	    },

	    /**
	     * Make changed luminance color.
	     * @param {string} hex hax color
	     * @param {number} lum luminance
	     * @returns {string} changed color
	     */
	    makeChangedLuminanceColor: function(hex, lum) {
	        var changedHex;

	        hex = hex.replace('#', '');
	        lum = lum || 0;

	        changedHex = snippet.map(snippet.range(3), function(index) {
	            var hd = parseInt(hex.substr(index * 2, 2), 16);
	            var newHd = hd + (hd * lum);

	            newHd = Math.round(Math.min(Math.max(0, newHd), 255)).toString(16);

	            return renderUtil.formatToZeroFill(newHd, 2);
	        }).join('');

	        return '#' + changedHex;
	    },

	    /**
	     * Get rendered text element size
	     * @param {string} text text content
	     * @param {number} fontSize font-size attribute
	     * @param {string} fontFamily font-family attribute
	     * @returns {{
	     *     width: number,
	     *     height: number
	     * }}
	     */
	    getRenderedTextSize: function(text, fontSize, fontFamily) {
	        var paper = raphael(document.body, 100, 100);
	        var textElement = paper.text(0, 0, text).attr({
	            'font-size': fontSize,
	            'font-family': fontFamily
	        });
	        var bBox = textElement.getBBox();

	        textElement.remove();
	        paper.remove();

	        return {
	            width: bBox.width,
	            height: bBox.height
	        };
	    },

	    /**
	     * Animate given element's opacity
	     * @param {object} element element
	     * @param {number} startOpacity endOpacity default is '0'
	     * @param {number} endOpacity endOpacity default is '1'
	     * @param {number} duration endOpacity default is '600'
	     */
	    animateOpacity: function(element, startOpacity, endOpacity, duration) {
	        var animationDuration = isNumber(duration) ? duration : 600;
	        var animationStartOpacity = isNumber(startOpacity) ? startOpacity : 0;
	        var animationEndOpacity = isNumber(endOpacity) ? endOpacity : 1;
	        var animation = raphael.animation({
	            opacity: animationEndOpacity
	        }, animationDuration);

	        element.attr({
	            opacity: animationStartOpacity
	        });

	        element.animate(animation);
	    }
	};

	/**
	 * Return boolean value for given parameter is number or not
	 * @param {*} numberSuspect number suspect
	 * @returns {boolean}
	 */
	function isNumber(numberSuspect) {
	    return snippet.isExisty(numberSuspect) && typeof numberSuspect === 'number';
	}

	module.exports = raphaelRenderUtil;


/***/ }),
/* 6 */
/***/ (function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_6__;

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Util for rendering.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var dom = __webpack_require__(9);
	var arrayUtil = __webpack_require__(10);

	var snippet = __webpack_require__(6);
	var predicate = __webpack_require__(11);

	var concat = Array.prototype.concat;

	var browser = snippet.browser,
	    isIE7 = browser.msie && browser.version === 7,
	    isOldBrowser = browser.msie && browser.version <= 8;
	var hasComputedStyle = window.getComputedStyle || false;

	var lineBaseChartCount = 0;
	var CLIP_RECT_ID = 'clipRectForAnimation';

	/**
	 * Util for rendering.
	 * @module renderUtil
	 * @private */
	var renderUtil = {
	    /**
	     * Concat string.
	     * @params {...string} target strings
	     * @returns {string} concat string
	     * @memberof module:renderUtil
	     */
	    concatStr: function() {
	        return String.prototype.concat.apply('', arguments);
	    },

	    /**
	     * Make cssText for font.
	     * @param {{fontSize: number, fontFamily: string, color: string}} theme font theme
	     * @returns {string} cssText
	     * @memberof module:renderUtil
	     */
	    makeFontCssText: function(theme) {
	        var cssTexts = [];

	        if (!theme) {
	            return '';
	        }

	        if (theme.fontSize) {
	            cssTexts.push(this.concatStr('font-size:', theme.fontSize, 'px'));
	        }

	        if (theme.fontFamily) {
	            cssTexts.push(this.concatStr('font-family:', theme.fontFamily));
	        }

	        if (theme.color) {
	            cssTexts.push(this.concatStr('color:', theme.color));
	        }

	        if (theme.fontWeight) {
	            cssTexts.push(this.concatStr('font-weight:', theme.fontWeight));
	        }

	        return cssTexts.join(';');
	    },

	    checkEl: null,
	    /**
	     * Create element for size check.
	     * @memberof module:renderUtil
	     * @returns {HTMLElement} element
	     * @private
	     */
	    _createSizeCheckEl: function() {
	        var div, span;
	        if (!this.checkEl) {
	            div = dom.create('DIV', 'tui-chart-size-check-element');
	            span = dom.create('SPAN');
	            div.appendChild(span);
	            this.checkEl = div;
	        } else {
	            this.checkEl.style.cssText = '';
	        }

	        return this.checkEl;
	    },

	    /**
	     * Make caching key.
	     * @param {string} label labek
	     * @param {{fontSize: number, fontFamily: string}} theme theme
	     * @param {string} offsetType offset type (offsetWidth or offsetHeight)
	     * @returns {string} key
	     * @private
	     */
	    _makeCachingKey: function(label, theme, offsetType) {
	        var keys = [label, offsetType];

	        snippet.forEach(theme, function(key, value) {
	            keys.push(key + value);
	        });

	        return keys.join('-');
	    },

	    /**
	     * Add css style.
	     * @param {HTMLElement} div div element
	     * @param {{fontSize: number, fontFamily: string, cssText: string}} theme theme
	     * @private
	     */
	    _addCssStyle: function(div, theme) {
	        div.style.fontSize = (theme.fontSize || chartConst.DEFAULT_LABEL_FONT_SIZE) + 'px';

	        if (theme.fontFamily) {
	            div.style.fontFamily = theme.fontFamily;
	        }

	        if (theme.fontWeight) {
	            div.style.fontWeight = theme.fontWeight;
	        }

	        if (theme.cssText) {
	            div.style.cssText += theme.cssText;
	        }
	    },

	    /**
	     * Size cache.
	     * @type {object}
	     * @private
	     */
	    sizeCache: {},

	    /**
	     * Get rendered label size (width or height).
	     * @memberOf module:renderUtil
	     * @param {string | number} label label
	     * @param {object} theme theme
	     * @param {string} offsetType offset type (offsetWidth or offsetHeight)
	     * @returns {number} size
	     * @private
	     */
	    _getRenderedLabelSize: function(label, theme, offsetType) {
	        var key, div, span, labelSize;

	        theme = theme || {};

	        label = snippet.isExisty(label) ? String(label) : '';

	        if (!label) {
	            return 0;
	        }

	        key = this._makeCachingKey(label, theme, offsetType);
	        labelSize = this.sizeCache[key];

	        if (!labelSize) {
	            div = this._createSizeCheckEl();
	            span = div.firstChild;

	            span.innerHTML = label;

	            this._addCssStyle(div, theme);

	            document.body.appendChild(div);
	            labelSize = span[offsetType];
	            document.body.removeChild(div);

	            this.sizeCache[key] = labelSize;
	        }

	        return labelSize;
	    },

	    /**
	     * Get rendered label width.
	     * @memberof module:renderUtil
	     * @param {string} label label
	     * @param {{fontSize: number, fontFamily: string, color: string}} theme label theme
	     * @returns {number} width
	     */
	    getRenderedLabelWidth: function(label, theme) {
	        var labelWidth = this._getRenderedLabelSize(label, theme, 'offsetWidth');

	        return labelWidth;
	    },

	    /**
	     * Get rendered label height.
	     * @memberof module:renderUtil
	     * @param {string} label label
	     * @param {{fontSize: number, fontFamily: string, color: string}} theme label theme
	     * @returns {number} height
	     */
	    getRenderedLabelHeight: function(label, theme) {
	        var labelHeight = this._getRenderedLabelSize(label, theme, 'offsetHeight');

	        return labelHeight;
	    },

	    /**
	     * Get Rendered Labels Max Size(width or height).
	     * @memberof module:renderUtil
	     * @param {string[]} labels labels
	     * @param {{fontSize: number, fontFamily: string, color: string}} theme label theme
	     * @param {function} iteratee iteratee
	     * @returns {number} max size (width or height)
	     * @private
	     */
	    _getRenderedLabelsMaxSize: function(labels, theme, iteratee) {
	        var maxSize = 0,
	            sizes;

	        if (labels && labels.length) {
	            sizes = snippet.map(labels, function(label) {
	                return iteratee(label, theme);
	            });
	            maxSize = arrayUtil.max(sizes);
	        }

	        return maxSize;
	    },

	    /**
	     * Get rendered labels max width.
	     * @memberof module:renderUtil
	     * @param {string[]} labels labels
	     * @param {{fontSize: number, fontFamily: string, color: string}} theme label theme
	     * @returns {number} max width
	     * @private
	     */
	    getRenderedLabelsMaxWidth: function(labels, theme) {
	        var iteratee = snippet.bind(this.getRenderedLabelWidth, this);
	        var maxWidth = this._getRenderedLabelsMaxSize(labels, theme, iteratee);

	        return maxWidth;
	    },

	    /**
	     * Get rendered labels max height.
	     * @memberof module:renderUtil
	     * @param {string[]} labels labels
	     * @param {{fontSize: number, fontFamily: string, color: string}} theme label theme
	     * @returns {number} max height
	     */
	    getRenderedLabelsMaxHeight: function(labels, theme) {
	        var iteratee = snippet.bind(this.getRenderedLabelHeight, this);
	        var maxHeight = this._getRenderedLabelsMaxSize(labels, theme, iteratee);

	        return maxHeight;
	    },

	    /**
	     * Render dimension.
	     * @memberof module:renderUtil
	     * @param {HTMLElement} el target element
	     * @param {{width: number, height: number}} dimension dimension
	     */
	    renderDimension: function(el, dimension) {
	        el.style.cssText = [
	            this.concatStr('width:', dimension.width, 'px'),
	            this.concatStr('height:', dimension.height, 'px')
	        ].join(';');
	    },

	    /**
	     * Render position(top, right).
	     * @memberof module:renderUtil
	     * @param {HTMLElement} el target element
	     * @param {{top: number, left: number, right: number}} position position
	     */
	    renderPosition: function(el, position) {
	        if (snippet.isUndefined(position)) {
	            return;
	        }

	        snippet.forEachArray(['top', 'bottom', 'left', 'right'], function(key) {
	            var value = position[key];

	            if (snippet.isNumber(value)) {
	                el.style[key] = position[key] + 'px';
	            }
	        });
	    },

	    /**
	     * Render background.
	     * @memberof module:renderUtil
	     * @param {HTMLElement} el target element
	     * @param {string} background background option
	     */
	    renderBackground: function(el, background) {
	        if (!background) {
	            return;
	        }

	        el.style.background = background;
	    },

	    /**
	     * Render font family.
	     * @memberof module:renderUtil
	     * @param {HTMLElement} el target element
	     * @param {string} fontFamily font family option
	     */
	    renderFontFamily: function(el, fontFamily) {
	        if (!fontFamily) {
	            return;
	        }

	        el.style.fontFamily = fontFamily;
	    },

	    /**
	     * Render title.
	     * @memberof module:renderUtil
	     * @param {string} title title
	     * @param {{fontSize: number, color: string, background: string}} theme title theme
	     * @param {string} className css class name
	     * @returns {HTMLElement} title element
	     */
	    renderTitle: function(title, theme, className) {
	        var elTitle, cssText;

	        if (!title) {
	            return null;
	        }

	        elTitle = dom.create('DIV', className);
	        elTitle.innerHTML = title;

	        cssText = renderUtil.makeFontCssText(theme);

	        if (theme.background) {
	            cssText += ';' + this.concatStr('background:', theme.background);
	        }

	        elTitle.style.cssText = cssText;

	        return elTitle;
	    },

	    /**
	     * Expand dimension.
	     * @param {{
	     *      dimension: {width: number, height: number},
	     *      position: {left: number, top: number}
	     * }} bound series bound
	     * @returns {{
	     *      dimension: {width: number, height: number},
	     *      position: {left: number, top: number}
	     * }} expended bound
	     * @memberof module:renderUtil
	     */
	    expandBound: function(bound) {
	        var dimension = bound.dimension;
	        var position = bound.position;

	        return {
	            dimension: {
	                width: dimension.width + (chartConst.SERIES_EXPAND_SIZE * 2),
	                height: dimension.height + (chartConst.SERIES_EXPAND_SIZE * 2)
	            },
	            position: {
	                left: position.left - chartConst.SERIES_EXPAND_SIZE,
	                top: position.top - chartConst.SERIES_EXPAND_SIZE
	            }
	        };
	    },

	    /**
	     * Proper case.
	     * @param {string} value - string value
	     * @returns {string}
	     */
	    _properCase: function(value) {
	        return value.substring(0, 1).toUpperCase() + value.substring(1);
	    },

	    /**
	     * Make mouse event detector name.
	     * @param {string} prefix prefix
	     * @param {string} value value
	     * @param {string} suffix suffix
	     * @returns {string} mouse event detector name
	     * @memberof module:renderUtil
	     */
	    makeMouseEventDetectorName: function(prefix, value, suffix) {
	        return prefix + this._properCase(value) + this._properCase(suffix);
	    },

	    /**
	     * Format value.
	     * @param {object} params - raw data
	     *     @param {number} params.value value
	     *     @param {Array.<function>} params.formatFunctions - functions for format
	     *     @param {string} params.chartType - type of chart
	     *     @param {string} params.areaType - type of area like yAxis, xAxis, series, circleLegend
	     *     @param {string} [params.valueType] - type of value
	     *     @param {string} [params.legendName] - legendName
	     * @returns {string} formatted value
	     * @memberof module:renderUtil
	     */
	    formatValue: function(params) {
	        var value = params.value;
	        var formatFunctions = params.formatFunctions;
	        var valueType = params.valueType || 'value';
	        var areaType = params.areaType;
	        var chartType = params.chartType;
	        var legendName = params.legendName;

	        var fns = [String(value)].concat(formatFunctions || []);

	        return snippet.reduce(fns, function(stored, fn) {
	            return fn(stored, chartType, areaType, valueType, legendName);
	        });
	    },
	    /**
	     * Format values.
	     * @param {Array.<number>} values values
	     * @param {Array.<function>} formatFunctions functions for format
	     * @param {string} chartType - type of chart
	     * @param {string} areaType - type of area like yAxis, xAxis, series, circleLegend
	     * @param {string} valueType - type of value
	     * @returns {Array.<string>}
	     * @memberof module:renderUtil
	     */
	    formatValues: function(values, formatFunctions, chartType, areaType, valueType) {
	        var formatedValues;

	        if (!formatFunctions || !formatFunctions.length) {
	            return values;
	        }

	        formatedValues = snippet.map(values, function(label) {
	            return renderUtil.formatValue({
	                value: label,
	                formatFunctions: formatFunctions,
	                chartType: chartType,
	                areaType: areaType,
	                valueType: valueType
	            });
	        });

	        return formatedValues;
	    },

	    /**
	     * Format date.
	     * @param {string | number | date} value - value
	     * @param {string} format - date format
	     * @returns {string}
	     * @memberof module:renderUtil
	     */
	    formatDate: function(value, format) {
	        var date = snippet.isDate(value) ? value : (new Date(value));
	        format = format || chartConst.DEFAULT_DATE_FORMAT;

	        return snippet.formatDate(format, date) || value;
	    },

	    /**
	     * Format dates.
	     * @param {Array.<string | number | date>} values - values
	     * @param {string} format - date format
	     * @returns {Array}
	     * @memberof module:renderUtil
	     */
	    formatDates: function(values, format) {
	        var formatDate = this.formatDate;

	        format = format || chartConst.DEFAULT_DATE_FORMAT;

	        return snippet.map(values, function(value) {
	            return formatDate(value, format);
	        });
	    },

	    /**
	     * Cancel animation
	     * @param {{id: number}} animation animaion object
	     * @memberof module:renderUtil
	     */
	    cancelAnimation: function(animation) {
	        if (animation && animation.id) {
	            cancelAnimationFrame(animation.id);
	            delete animation.id;
	        }
	    },

	    /**
	     * Start animation.
	     * @param {number} animationTime - animation time
	     * @param {function} onAnimation - animation callback function
	     * @param {function} onCompleted - completed callback function
	     * @returns {{id: number}} requestAnimationFrame id
	     * @memberof module:renderUtil
	     */
	    startAnimation: function(animationTime, onAnimation, onCompleted) {
	        var animation = {},
	            startTime;

	        /**
	         * Animate.
	         */
	        function animate() {
	            var diffTime = (new Date()).getTime() - startTime,
	                ratio = Math.min((diffTime / animationTime), 1);

	            onAnimation(ratio);

	            if (ratio === 1) {
	                delete animation.id;
	                if (onCompleted) {
	                    onCompleted();
	                }
	            } else {
	                animation.id = requestAnimationFrame(animate);
	            }
	        }

	        startTime = (new Date()).getTime();
	        animation.id = requestAnimationFrame(animate);

	        return animation;
	    },

	    /**
	     * Whether IE7 or not.
	     * @returns {boolean} result boolean
	     */
	    isIE7: function() {
	        return isIE7;
	    },

	    /**
	     * Whether oldBrowser or not.
	     * @memberof module:renderUtil
	     * @returns {boolean} result boolean
	     */
	    isOldBrowser: function() {
	        return isOldBrowser;
	    },

	    /**
	     * Format to zero fill.
	     * @param {string} value target value
	     * @param {number} len length of result
	     * @returns {string} formatted value
	     * @private
	     */
	    formatToZeroFill: function(value, len) {
	        var zero = '0';

	        value = String(value);

	        if (value.length >= len) {
	            return value;
	        }

	        while (value.length < len) {
	            value = zero + value;
	        }

	        return value;
	    },

	    /**
	     * Format to Decimal.
	     * @param {string} value target value
	     * @param {number} len length of under decimal point
	     * @returns {string} formatted value
	     * @memberof module:renderUtil
	     */
	    formatToDecimal: function(value, len) {
	        var DECIMAL = 10;
	        var pow;

	        if (len === 0) {
	            return Math.round(value);
	        }

	        pow = Math.pow(DECIMAL, len);
	        value = Math.round(value * pow) / pow;
	        value = parseFloat(value).toFixed(len);

	        return value;
	    },

	    /**
	     * Format to Comma.
	     * @param {string} value target value
	     * @returns {string} formatted value
	     * @private
	     */
	    formatToComma: function(value) {
	        var comma = ',',
	            underPointValue = '',
	            betweenLen = 3,
	            orgValue = value,
	            sign, values, lastIndex, formattedValue;

	        value = String(value);
	        sign = value.indexOf('-') > -1 ? '-' : '';

	        if (value.indexOf('.') > -1) {
	            values = value.split('.');
	            value = String(Math.abs(values[0]));
	            underPointValue = '.' + values[1];
	        } else {
	            value = String(Math.abs(value));
	        }

	        if (value.length <= betweenLen) {
	            formattedValue = orgValue;
	        } else {
	            values = (value).split('').reverse();
	            lastIndex = values.length - 1;
	            values = snippet.map(values, function(char, index) {
	                var result = [char];
	                if (index < lastIndex && (index + 1) % betweenLen === 0) {
	                    result.push(comma);
	                }

	                return result;
	            });
	            formattedValue = sign + concat.apply([], values).reverse().join('') + underPointValue;
	        }

	        return formattedValue;
	    },

	    /**
	     * Make cssText from map.
	     * @param {object} cssMap - css map
	     * @returns {string}
	     * @memberof module:renderUtil
	     */
	    makeCssTextFromMap: function(cssMap) {
	        return snippet.map(cssMap, function(value, name) {
	            return renderUtil.concatStr(name, ':', value);
	        }).join(';');
	    },

	    /**
	     * Perse String.
	     * @param {string} value - string
	     * @returns {string}
	     */
	    _perseString: function(value) {
	        return typeof value === 'string' || typeof value === 'number' ? String(value) : '';
	    },

	    /**
	     * Add prefix or suffix to label.
	     * @param {array} labels - labels
	     * @param {string} prefix - string
	     * @param {string} suffix - string
	     * @returns {array}
	     * @memberof module:renderUtil
	     */
	    addPrefixSuffix: function(labels, prefix, suffix) {
	        prefix = this._perseString(prefix);
	        suffix = this._perseString(suffix);

	        if (!(prefix === '' && suffix === '')) {
	            return snippet.map(labels, function(label) {
	                return prefix + label + suffix;
	            });
	        }

	        return labels;
	    },

	    /**
	     * Returns element's style value defined at css file
	     * @param {HTMLElement} target - Current element
	     * @returns {Object} Style object of element
	     * @memberof module:renderUtil
	     */
	    getStyle: function(target) {
	        var computedObj;

	        if (hasComputedStyle) {
	            computedObj = window.getComputedStyle(target, '');
	        } else {
	            computedObj = target.currentStyle;
	        }

	        return computedObj;
	    },

	    /**
	     * Get clip rect id
	     * @returns {string} create unique id by line base chart count
	     */
	    generateClipRectId: function() {
	        var id = CLIP_RECT_ID + lineBaseChartCount;
	        lineBaseChartCount += 1;

	        return id;
	    },

	    /**
	     * get default height of series top area
	     * @param {string} chartType - chart type
	     * @param {object} theme - series theme
	     * @returns {number} - default series top height
	     */
	    getDefaultSeriesTopAreaHeight: function(chartType, theme) {
	        if (predicate.isBarTypeChart(chartType) ||
	            predicate.isLineTypeChart(chartType) ||
	            predicate.isComboChart(chartType) ||
	            predicate.isBulletChart(chartType)
	        ) {
	            return this.getRenderedLabelHeight(chartConst.MAX_HEIGHT_WORD, theme) +
	                chartConst.SERIES_LABEL_PADDING;
	        }

	        return 0;
	    }
	};

	/**
	 * Set css opacity.
	 * @param {HTMLElement | Array.<HTMLElement>} elements - elements
	 * @param {function} iteratee - iteratee
	 * @ignore
	 */
	function setOpacity(elements, iteratee) {
	    elements = snippet.isArray(elements) ? elements : [elements];
	    snippet.forEachArray(elements, iteratee);
	}

	/**
	 * Make filter opacity css string.
	 * @param {number} opacity - opacity
	 * @returns {string}
	 * @ignore
	 */
	function makeCssFilterOpacityString(opacity) {
	    return 'alpha(opacity=' + (opacity * chartConst.OLD_BROWSER_OPACITY_100) + ')';
	}

	if (isOldBrowser) {
	    /**
	     * Make opacity css text for old browser(IE7, IE8).
	     * @param {number} opacity - opacity
	     * @returns {string}
	     */
	    renderUtil.makeOpacityCssText = function(opacity) {
	        var cssText = '';

	        if (snippet.isExisty(opacity)) {
	            cssText = ';filter:' + makeCssFilterOpacityString(opacity);
	        }

	        return cssText;
	    };

	    /**
	     * Set css opacity for old browser(IE7, IE8).
	     * @param {HTMLElement | Array.<HTMLElement>} elements - elements
	     * @param {number} opacity - opacity
	     */
	    renderUtil.setOpacity = function(elements, opacity) {
	        var filter = makeCssFilterOpacityString(opacity);
	        setOpacity(elements, function(element) {
	            element.style.filter = filter;
	        });
	    };
	} else {
	    /**
	     * Make opacity css text for browser supporting opacity property of CSS3.
	     * @param {number} opacity - opacity
	     * @returns {string}
	     */
	    renderUtil.makeOpacityCssText = function(opacity) {
	        var cssText = '';

	        if (snippet.isExisty(opacity)) {
	            cssText = ';opacity:' + opacity;
	        }

	        return cssText;
	    };

	    /**
	     * Set css opacity for browser supporting opacity property of CSS3.
	     * @param {HTMLElement | Array.<HTMLElement>} elements - elements
	     * @param {number} opacity - opacity
	     */
	    renderUtil.setOpacity = function(elements, opacity) {
	        setOpacity(elements, function(element) {
	            element.style.opacity = opacity;
	        });
	    };
	}

	module.exports = renderUtil;


/***/ }),
/* 8 */
/***/ (function(module, exports) {

	/**
	 * @fileoverview Chart const
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	/**
	 * Chart const
	 * @readonly
	 * @enum {number|string}
	 * @private
	 */
	var chartConst = {
	    /** tui class names
	     * @type {string}
	     */
	    CLASS_NAME_LEGEND_LABEL: 'tui-chart-legend-label',
	    /** @type {string} */
	    CLASS_NAME_LEGEND_CHECKBOX: 'tui-chart-legend-checkbox',
	    /** @type {string} */
	    CLASS_NAME_SERIES_LABEL: 'tui-chart-series-label',
	    /** @type {string} */
	    CLASS_NAME_SERIES_LEGEND: 'tui-chart-series-legend',
	    /** @type {string} */
	    CLASS_NAME_RESET_ZOOM_BTN: 'tui-chart-reset-zoom-btn',
	    /** @type {string} */
	    CLASS_NAME_CHART_EXPORT_MENU_AREA: 'tui-chart-chartExportMenu-area',
	    /** @type {string} */
	    CLASS_NAME_CHART_EXPORT_MENU_ITEM: 'tui-chart-chartExportMenu-item',
	    /** @type {string} */
	    CLASS_NAME_CHART_EXPORT_MENU_BUTTON: 'tui-chart-chartExportMenu-button',
	    /** chart type
	     * @type {string}
	     */
	    CHART_TYPE_BAR: 'bar',
	    /** @type {string} */
	    CHART_TYPE_COLUMN: 'column',
	    /** @type {string} */
	    CHART_TYPE_LINE: 'line',
	    /** @type {string} */
	    CHART_TYPE_AREA: 'area',
	    /** @type {string} */
	    CHART_TYPE_COMBO: 'combo',
	    /** @type {string} */
	    CHART_TYPE_COLUMN_LINE_COMBO: 'columnLineCombo',
	    /** @type {string} */
	    CHART_TYPE_LINE_SCATTER_COMBO: 'lineScatterCombo',
	    /** @type {string} */
	    CHART_TYPE_LINE_AREA_COMBO: 'lineAreaCombo',
	    /** @type {string} */
	    CHART_TYPE_PIE_DONUT_COMBO: 'pieDonutCombo',
	    /** @type {string} */
	    CHART_TYPE_PIE: 'pie',
	    /** @type {string} */
	    CHART_TYPE_BUBBLE: 'bubble',
	    /** @type {string} */
	    CHART_TYPE_SCATTER: 'scatter',
	    /** @type {string} */
	    CHART_TYPE_HEATMAP: 'heatmap',
	    /** @type {string} */
	    CHART_TYPE_TREEMAP: 'treemap',
	    /** @type {string} */
	    CHART_TYPE_MAP: 'map',
	    /** @type {string} */
	    CHART_TYPE_RADIAL: 'radial',
	    /** @type {string} */
	    CHART_TYPE_BOXPLOT: 'boxplot',
	    /** @type {string} */
	    CHART_TYPE_BULLET: 'bullet',
	    /** chart padding */
	    CHART_PADDING: 10,
	    /** chart default width */
	    CHART_DEFAULT_WIDTH: 500,
	    /** chart default height */
	    CHART_DEFAULT_HEIGHT: 400,
	    /** overlapping width of xAxis and yAxis */
	    OVERLAPPING_WIDTH: 1,
	    /** rendered text padding */
	    TEXT_PADDING: 2,
	    /** series expand size */
	    SERIES_EXPAND_SIZE: 10,
	    /** series label padding */
	    SERIES_LABEL_PADDING: 5,
	    /** series event margins for the value zero */
	    SERIES_EXTRA_EVENT_AREA_FOR_ZERO: 2,
	    /** default font size of title */
	    DEFAULT_TITLE_FONT_SIZE: 14,
	    /** default font size of axis title */
	    DEFAULT_AXIS_TITLE_FONT_SIZE: 10,
	    /** default font size of label */
	    DEFAULT_LABEL_FONT_SIZE: 12,
	    /** default font size of series label */
	    DEFAULT_SERIES_LABEL_FONT_SIZE: 11,
	    /** default graph plugin
	     * @type {string}
	     */
	    DEFAULT_PLUGIN: 'Raphael',
	    /** default tick color
	     * @type {string}
	     */
	    DEFAULT_TICK_COLOR: 'black',
	    /** default theme name
	     * @type {string}
	     */
	    DEFAULT_THEME_NAME: 'default',
	    MAX_HEIGHT_WORD: 'A',
	    /** stack type
	     * @type {string}
	     */
	    NORMAL_STACK_TYPE: 'normal',
	    /** @type {string} */
	    PERCENT_STACK_TYPE: 'percent',
	    /** default stack
	     * @type {string}
	     */
	    DEFAULT_STACK: '___DEFAULT___STACK___',
	    /** dummy key
	     * @type {string}
	     */
	    DUMMY_KEY: '___DUMMY___KEY___',
	    /** root id of treemap
	     * @type {string}
	     */
	    TREEMAP_ROOT_ID: '___TUI_TREEMAP_ROOT___',
	    /** id prefix of treemap
	     * @type {string}
	     */
	    TREEMAP_ID_PREFIX: '___TUI_TREEMAP_ID___',
	    /** prefix for caching seriesItems
	     * @type {string}
	     */
	    TREEMAP_DEPTH_KEY_PREFIX: '___TUI_TREEMAP_DEPTH___',
	    /** @type {string} */
	    TREEMAP_PARENT_KEY_PREFIX: '___TUI_TREEMAP_PARENT___',
	    /** @type {string} */
	    TREEMAP_LEAF_KEY_PREFIX: '___TUI_TREEMAP_LEAF___',
	    /** @type {string} */
	    TREEMAP_LIMIT_DEPTH_KEY_PREFIX: '___TUI_TREEMAP_LIMIT_DEPTH___',
	    /** default border color for treemap chart
	     * @type {string}
	     */
	    TREEMAP_DEFAULT_BORDER: '#ccc',
	    /** empty axis label */
	    EMPTY_AXIS_LABEL: '',
	    /** angel */
	    ANGLE_85: 85,
	    ANGLE_90: 90,
	    ANGLE_360: 360,
	    /** radian */
	    RAD: Math.PI / 180,
	    RERENDER_TIME: 700,
	    ADDING_DATA_ANIMATION_DURATION: 300,
	    /** series label align outer
	     * @type {string}
	     */
	    LABEL_ALIGN_OUTER: 'outer',
	    /** @type {string} */
	    LEGEND_ALIGN_TOP: 'top',
	    /** @type {string} */
	    LEGEND_ALIGN_BOTTOM: 'bottom',
	    /** @type {string} */
	    LEGEND_ALIGN_LEFT: 'left',
	    /** @type {number} */
	    LEGEND_PAGINATION_BUTTON_WIDTH: 10,
	    /** @type {number} */
	    LEGEND_PAGINATION_BUTTON_PADDING_LEFT: 5,
	    /** series outer label padding */
	    SERIES_OUTER_LABEL_PADDING: 20,
	    /** default ratio for pie graph */
	    PIE_GRAPH_DEFAULT_RATIO: 0.9,
	    /** small ratio for pie graph */
	    PIE_GRAPH_SMALL_RATIO: 0.75,
	    /** tick count for spectrum legend */
	    SPECTRUM_LEGEND_TICK_COUNT: 4,
	    /** legend & lable concat separator */
	    LABEL_SEPARATOR: '\n',
	    /** default position ratio of map chart label
	     * @type {object}
	     */
	    MAP_CHART_LABEL_DEFAULT_POSITION_RATIO: {
	        x: 0.5,
	        y: 0.5
	    },
	    /** dot radius */
	    DOT_RADIUS: 4,
	    /** radius for circle of scatter chart*/
	    SCATTER_RADIUS: 5,
	    /**
	     * theme properties
	     * @type {{yAxis: Array.<string>, series: Array.<string>}}
	     */
	    THEME_PROPS_MAP: {
	        yAxis: ['tickColor', 'title', 'label'],
	        series: ['label', 'colors', 'borderColor', 'borderWidth', 'selectionColor', 'startColor', 'endColor',
	            'overColor', 'dot', 'ranges']
	    },
	    /** title area width padding */
	    TITLE_AREA_WIDTH_PADDING: 20,
	    /** top margin of x axis label */
	    XAXIS_LABEL_TOP_MARGIN: 10,
	    /** right padding of vertical label */
	    V_LABEL_RIGHT_PADDING: 10,
	    /** tooltip prefix
	     * @type {string}
	     */
	    TOOLTIP_PREFIX: 'tui-chart-tooltip',
	    /** tooltip z-index **/
	    TOOLTIP_ZINDEX: 500,
	    /** tooltip animation time */
	    TOOLTIP_ANIMATION_TIME: 100,
	    /** tooltip animation time for pie chart */
	    TOOLTIP_PIE_ANIMATION_TIME: 50,
	    /** minimum pixel type step size */
	    MIN_PIXEL_TYPE_STEP_SIZE: 45,
	    /** maximum pixel type step size */
	    MAX_PIXEL_TYPE_STEP_SIZE: 65,
	    /** axis scale for percent stack option
	     * @type {object}
	     */
	    PERCENT_STACKED_AXIS_SCALE: {
	        limit: {
	            min: 0,
	            max: 100
	        },
	        step: 25,
	        labels: [0, 25, 50, 75, 100]
	    },
	    /** axis scale for minus percent stack option
	     * @type {object}
	     */
	    MINUS_PERCENT_STACKED_AXIS_SCALE: {
	        limit: {
	            min: -100,
	            max: 0
	        },
	        step: 25,
	        labels: [0, -25, -50, -75, -100]
	    },
	    /** axis scale of dual percent stack option
	     * @type {object}
	     */
	    DUAL_PERCENT_STACKED_AXIS_SCALE: {
	        limit: {
	            min: -100,
	            max: 100
	        },
	        step: 25,
	        labels: [-100, -75, -50, -25, 0, 25, 50, 75, 100]
	    },
	    /** axis scale of diverging percent stack option
	     * @type {object}
	     */
	    DIVERGING_PERCENT_STACKED_AXIS_SCALE: {
	        limit: {
	            min: -100,
	            max: 100
	        },
	        step: 25,
	        labels: [100, 75, 50, 25, 0, 25, 50, 75, 100]
	    },
	    /**
	     * datetime axis type
	     * @type {string}
	     */
	    AXIS_TYPE_DATETIME: 'datetime',
	    /**
	     * default dateFormat
	     * @type {string}
	     */
	    DEFAULT_DATE_FORMAT: 'YYYY.MM.DD hh:mm:dd',
	    /**
	     * date type
	     * @type {string}
	     */
	    DATE_TYPE_YEAR: 'year',
	    DATE_TYPE_MONTH: 'month',
	    DATE_TYPE_WEEK: 'week',
	    DATE_TYPE_DATE: 'date',
	    DATE_TYPE_HOUR: 'hour',
	    DATE_TYPE_MINUTE: 'minute',
	    DATE_TYPE_SECOND: 'second',
	    /** title add padding */
	    TITLE_PADDING: 10,
	    /** legend area padding */
	    LEGEND_AREA_PADDING: 10,
	    /** legend checkbox width */
	    LEGEND_CHECKBOX_WIDTH: 10,
	    LEGEND_ICON_WIDTH: 40,
	    LEGEND_ICON_HEIGHT: 15,
	    /** lgend label left padding */
	    LEGEND_LABEL_LEFT_PADDING: 5,
	    MIN_LEGEND_WIDTH: 100,
	    /** map legend height */
	    MAP_LEGEND_SIZE: 200,
	    /** map legend graph size */
	    MAP_LEGEND_GRAPH_SIZE: 25,
	    /** map legend label padding */
	    MAP_LEGEND_LABEL_PADDING: 10,
	    CIRCLE_LEGEND_LABEL_FONT_SIZE: 9,
	    CIRCLE_LEGEND_PADDING: 10,
	    HALF_RATIO: 0.5,
	    /** AXIS LABEL PADDING */
	    AXIS_LABEL_PADDING: 7,
	    /** rotations degree candidates */
	    DEGREE_CANDIDATES: [25, 45, 65, 85],
	    /**
	     * auto tick interval
	     * @type {string}
	     */
	    TICK_INTERVAL_AUTO: 'auto',
	    /** yAxis align option
	     * @type {string}
	     */
	    YAXIS_ALIGN_CENTER: 'center',
	    /** xAxis label compare margin */
	    XAXIS_LABEL_COMPARE_MARGIN: 20,
	    /** xAxis label gutter */
	    XAXIS_LABEL_GUTTER: 2,
	    /**
	     * Standard multiple nums of axis
	     * @type {Array}
	     */
	    AXIS_STANDARD_MULTIPLE_NUMS: [1, 2, 5, 10, 20, 50, 100],
	    /**
	     * Last standard multiple num of axis
	     */
	    AXIS_LAST_STANDARD_MULTIPLE_NUM: 100,
	    /** label padding top */
	    LABEL_PADDING_TOP: 3,
	    /** line margin top */
	    LINE_MARGIN_TOP: 5,
	    /** tooltip gap */
	    TOOLTIP_GAP: 5,
	    /** tooltip direction
	     * @type {string}
	     */
	    TOOLTIP_DIRECTION_FORWARD: 'forword',
	    /** @type {string} */
	    TOOLTIP_DIRECTION_CENTER: 'center',
	    /** @type {string} */
	    TOOLTIP_DIRECTION_BACKWARD: 'backword',
	    /** tooltip align options
	     * @type {string}
	     */
	    TOOLTIP_DEFAULT_ALIGN_OPTION: 'center top',
	    /** @type {string} */
	    TOOLTIP_DEFAULT_HORIZONTAL_ALIGN_OPTION: 'right middle',
	    /** @type {string} */
	    TOOLTIP_DEFAULT_GROUP_ALIGN_OPTION: 'right middle',
	    /** @type {string} */
	    TOOLTIP_DEFAULT_GROUP_HORIZONTAL_ALIGN_OPTION: 'center bottom',
	    /** hide delay */
	    HIDE_DELAY: 200,
	    OLD_BROWSER_OPACITY_100: 100,
	    SERIES_LABEL_OPACITY: 0.3,
	    WHEEL_TICK: 120,
	    MAX_ZOOM_MAGN: 5,
	    FF_WHEELDELTA_ADJUSTING_VALUE: -40,
	    IE7_ROTATION_FILTER_STYLE_MAP: {
	        25: ' style="filter: progid:DXImageTransform.Microsoft.Matrix(SizingMethod=\'auto expand\',' +
	                ' M11=0.9063077870366499, M12=0.42261826174069944, M21=-0.42261826174069944, M22=0.9063077870366499)"',
	        45: ' style="filter: progid:DXImageTransform.Microsoft.Matrix(SizingMethod=\'auto expand\',' +
	                ' M11=0.7071067811865476, M12=0.7071067811865475, M21=-0.7071067811865475, M22=0.7071067811865476)"',
	        65: ' style="filter: progid:DXImageTransform.Microsoft.Matrix(SizingMethod=\'auto expand\',' +
	                ' M11=0.42261826174069944, M12=0.9063077870366499, M21=-0.9063077870366499, M22=0.42261826174069944)"',
	        85: ' style="filter: progid:DXImageTransform.Microsoft.Matrix(SizingMethod=\'auto expand\',' +
	                ' M11=0.08715574274765814, M12=0.9961946980917455, M21=-0.9961946980917455, M22=0.08715574274765814)"'
	    },
	    /** prefix for public event
	     * @type {string}
	     */
	    PUBLIC_EVENT_PREFIX: 'public_',
	    /** public event map
	     * @type {object}
	     */
	    PUBLIC_EVENT_MAP: {
	        load: true,
	        selectLegend: true,
	        selectSeries: true,
	        unselectSeries: true,
	        beforeShowTooltip: true,
	        afterShowTooltip: true,
	        beforeHideTooltip: true,
	        zoom: true
	    },
	    /** for radial */
	    RADIAL_PLOT_PADDING: 15, // Prevent cross paper boundaries by line width
	    RADIAL_MARGIN_FOR_CATEGORY: 60,
	    RADIAL_CATEGORY_PADDING: 20,

	    COMPONENT_TYPE_DOM: 'DOM',
	    COMPONENT_TYPE_RAPHAEL: 'Raphael',

	    IMAGE_EXTENSIONS: ['png', 'jpeg'],
	    DATA_EXTENSIONS: ['xls', 'csv'],

	    GUIDE_AREACHART_AREAOPACITY_TYPE: 'areaOpacity should be a number between 0 and 1',

	    /** for bullet */
	    BULLET_TYPE_ACTUAL: 'Actual',
	    BULLET_TYPE_RANGE: 'Ranges',
	    BULLET_TYPE_MARKER: 'Markers',
	    BULLET_MARKER_STROKE_TICK: 3,
	    BULLET_MARKER_BUFFER_POSITION: 5,
	    BULLET_RANGES_HEIGHT_RATIO: 0.7,
	    BULLET_ACTUAL_HEIGHT_RATIO: 0.28,
	    BULLET_MARKERS_HEIGHT_RATIO: 0.55,
	    BULLET_MARKER_DETECT_PADDING: 3
	};
	module.exports = chartConst;


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview DOM Handler.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);
	var aps = Array.prototype.slice;

	/**
	 * DOM Handler.
	 * @module domHandler
	 * @private */
	var domHandler = {
	    /**
	     * Create element.
	     * @memberOf module:domHandler
	     * @param {string} tag html tag
	     * @param {string} newClass class name
	     * @returns {HTMLElement} created element
	     */
	    create: function(tag, newClass) {
	        var el = document.createElement(tag);

	        if (newClass) {
	            this.addClass(el, newClass);
	        }

	        return el;
	    },

	    /**
	     * Get class names.
	     * @memberOf module:domHandler
	     * @param {HTMLElement} el target element
	     * @returns {Array} names
	     * @private
	     */
	    _getClassNames: function(el) {
	        var className, classNames;

	        if (el.classList) {
	            classNames = aps.call(el.classList);
	        } else {
	            className = el.className || '';
	            classNames = className && snippet.isString(className) ? className.split(' ') : [];
	        }

	        return classNames;
	    },

	    /**
	     * Add css class to target element.
	     * @memberOf module:domHandler
	     * @param {HTMLElement} el target element
	     * @param {string} newClass add class name
	     */
	    addClass: function(el, newClass) {
	        var classNames, index;

	        if (!el || !newClass) {
	            return;
	        }

	        classNames = this._getClassNames(el);
	        index = snippet.inArray(newClass, classNames);

	        if (index > -1) {
	            return;
	        }

	        classNames.push(newClass);
	        el.className = classNames.join(' ');
	    },

	    /**
	     * Remove css class from target element.
	     * @memberOf module:domHandler
	     * @param {HTMLElement} el target element
	     * @param {string} rmClass remove class name
	     */
	    removeClass: function(el, rmClass) {
	        var classNames = this._getClassNames(el),
	            index = snippet.inArray(rmClass, classNames);

	        if (index === -1) {
	            return;
	        }

	        classNames.splice(index, 1);
	        el.className = classNames.join(' ');
	    },

	    /**
	     * Whether class exist or not.
	     * @memberOf module:domHandler
	     * @param {HTMLElement} el target element
	     * @param {string} findClass target css class
	     * @returns {boolean} has class
	     */
	    hasClass: function(el, findClass) {
	        var classNames = this._getClassNames(el);
	        var index = snippet.inArray(findClass, classNames);

	        return index > -1;
	    },

	    /**
	     * Find parent by class name.
	     * @memberOf module:domHandler
	     * @param {HTMLElement} el target element
	     * @param {string} className target css class
	     * @param {string} lastClass last css class
	     * @returns {HTMLElement} result element
	     */
	    findParentByClass: function(el, className, lastClass) {
	        var parent = el.parentNode,
	            result;

	        if (!parent) {
	            result = null;
	        } else if (this.hasClass(parent, className)) {
	            result = parent;
	        } else if (parent.nodeName === 'BODY' || this.hasClass(parent, lastClass)) {
	            result = null;
	        } else {
	            result = this.findParentByClass(parent, className, lastClass);
	        }

	        return result;
	    },

	    /**
	     * Append child element.
	     * @memberOf module:domHandler
	     * @param {HTMLElement} container container element
	     * @param {HTMLElement} children child element
	     */
	    append: function(container, children) {
	        if (!container || !children) {
	            return;
	        }
	        children = snippet.isArray(children) ? children : [children];

	        snippet.forEachArray(children, function(child) {
	            if (!child) {
	                return;
	            }
	            container.appendChild(child);
	        });
	    }
	};

	module.exports = domHandler;


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Util for array.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);

	/**
	 * Pick minimum value from value array.
	 * @memberOf module:arrayUtil
	 * @param {Array} arr value array
	 * @param {?function} condition condition function
	 * @param {?object} context target context
	 * @returns {*} minimum value
	 */
	var min = function(arr, condition, context) {
	    var result, minValue, rest;

	    if (!condition) {
	        result = Math.min.apply(null, arr);
	    } else {
	        result = arr[0];
	        minValue = condition.call(context, result, 0);
	        rest = arr.slice(1);
	        snippet.forEachArray(rest, function(item, index) {
	            var compareValue = condition.call(context, item, index + 1);
	            if (compareValue < minValue) {
	                minValue = compareValue;
	                result = item;
	            }
	        });
	    }

	    return result;
	};

	/**
	 * Pick maximum value from value array.
	 * @memberOf module:arrayUtil
	 * @param {Array} arr value array
	 * @param {?function} [condition] condition function
	 * @param {?object} [context] target context
	 * @returns {*} maximum value
	 */
	var max = function(arr, condition, context) {
	    var result, maxValue, rest;

	    if (!condition) {
	        result = Math.max.apply(null, arr);
	    } else {
	        result = arr[0];
	        maxValue = condition.call(context, result, 0);
	        rest = arr.slice(1);
	        snippet.forEachArray(rest, function(item, index) {
	            var compareValue = condition.call(context, item, index + 1);
	            if (compareValue > maxValue) {
	                maxValue = compareValue;
	                result = item;
	            }
	        });
	    }

	    return result;
	};

	/**
	 * Whether one of them is true or not.
	 * @memberOf module:arrayUtil
	 * @param {Array} collection target collection
	 * @param {function} condition condition function
	 * @param {?object} context target context
	 * @returns {boolean} result boolean
	 */
	var any = function(collection, condition, context) {
	    var result = false;
	    snippet.forEach(collection, function(item, key) {
	        if (condition.call(context, item, key, collection)) {
	            result = true;
	        }

	        return !result;
	    });

	    return result;
	};

	/**
	 * All of them is true or not.
	 * @memberOf module:arrayUtil
	 * @param {Array} collection target collection
	 * @param {function} condition condition function
	 * @param {?object} context target context
	 * @returns {boolean} result boolean
	 */
	var all = function(collection, condition, context) {
	    var result = !!(collection || []).length;
	    snippet.forEach(collection, function(item, key) {
	        if (!condition.call(context, item, key, collection)) {
	            result = false;
	        }

	        return result !== false;
	    });

	    return result;
	};

	/**
	 * Make unique values.
	 * @memberOf module:arrayUtil
	 * @param {Array} arr target array
	 * @param {?boolean} sorted whether sorted or not.
	 * @param {?function} iteratee iteratee function
	 * @param {?object} context target context
	 * @returns {Array} unique values
	 */
	var unique = function(arr, sorted, iteratee, context) {
	    var result = [],
	        prevValue;

	    if (!snippet.isBoolean(sorted)) {
	        context = iteratee;
	        iteratee = sorted;
	        sorted = false;
	    }

	    iteratee = iteratee || function(value) {
	        return value;
	    };

	    if (sorted) {
	        snippet.forEachArray(arr, function(value, index) {
	            value = iteratee.call(context, value, index, arr);
	            if (!index || prevValue !== value) {
	                result.push(value);
	            }
	            prevValue = value;
	        });
	    } else {
	        snippet.forEachArray(arr, function(value, index) {
	            value = iteratee.call(context, value, index, arr);
	            if (snippet.inArray(value, result) === -1) {
	                result.push(value);
	            }
	        });
	    }

	    return result;
	};

	/**
	 * Array pivot.
	 * @memberOf module:arrayUtil
	 * @param {Array.<Array>} arr2d target 2d array
	 * @returns {Array.<Array>} pivoted 2d array
	 */
	var pivot = function(arr2d) {
	    var result = [];
	    var len = max(snippet.map(arr2d, function(arr) {
	        return arr.length;
	    }));
	    var index;

	    snippet.forEachArray(arr2d, function(arr) {
	        for (index = 0; index < len; index += 1) {
	            if (!result[index]) {
	                result[index] = [];
	            }
	            result[index].push(arr[index]);
	        }
	    });

	    return result;
	};

	var arrayUtil = {
	    min: min,
	    max: max,
	    any: any,
	    all: all,
	    unique: unique,
	    pivot: pivot
	};

	module.exports = arrayUtil;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Predicate.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var arrayUtil = __webpack_require__(10);

	/**
	 * predicate.
	 * @module predicate
	 * @private */
	var predicate = {
	    /**
	     * Whether bar chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isBarChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_BAR;
	    },

	    /**
	     * Whether column chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isColumnChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_COLUMN;
	    },

	    /**
	     * Whether bar type chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isBarTypeChart: function(chartType) {
	        return predicate.isBarChart(chartType) || predicate.isColumnChart(chartType);
	    },

	    /**
	     * Whether boxplot chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isBoxplotChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_BOXPLOT;
	    },

	    /**
	     * Whether bullet chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isBulletChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_BULLET;
	    },

	    /**
	     * Whether radial type chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isRadialChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_RADIAL;
	    },

	    /**
	     * Whether diverging chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @param {boolean} diverging - whether has diverging or not
	     * @returns {*|boolean}
	     */
	    isDivergingChart: function(chartType, diverging) {
	        return this.isBarTypeChart(chartType) && diverging;
	    },

	    /**
	     * Whether normal stack chart or not.
	     * @param {string} chartType - type of chart
	     * @param {string} stackType - type of stack
	     * @returns {boolean}
	     * @private
	     */
	    isNormalStackChart: function(chartType, stackType) {
	        var isAllowedStackOption = predicate.isAllowedStackOption(chartType);
	        var isNormalStack = predicate.isNormalStack(stackType);

	        return isAllowedStackOption && isNormalStack;
	    },

	    /**
	     * Whether percent stack chart or not.
	     * @param {string} chartType - type of chart
	     * @param {string} stackType - type of stack
	     * @returns {boolean}
	     * @private
	     */
	    isPercentStackChart: function(chartType, stackType) {
	        var isAllowedStackOption = predicate.isAllowedStackOption(chartType);
	        var isPercentStack = predicate.isPercentStack(stackType);

	        return isAllowedStackOption && isPercentStack;
	    },

	    /**
	     * Whether combo chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isComboChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_COMBO;
	    },

	    /**
	     * Whether pie and donut combo chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @param {Array.<string>} subChartTypes - types of chart
	     * @returns {boolean}
	     */
	    isPieDonutComboChart: function(chartType, subChartTypes) {
	        var isAllPieType = arrayUtil.all(subChartTypes, function(subChartType) {
	            return predicate.isPieChart(subChartType);
	        });

	        return predicate.isComboChart(chartType) && isAllPieType;
	    },

	    /**
	     * Whether line chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isLineChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_LINE;
	    },

	    /**
	     * Whether area chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isAreaChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_AREA;
	    },

	    /**
	     * Whether line and area combo chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @param {Array.<string>} subChartTypes - types of chart
	     * @returns {boolean}
	     */
	    isLineAreaComboChart: function(chartType, subChartTypes) {
	        var isAllLineType = arrayUtil.all(subChartTypes || [], function(subChartType) {
	            return predicate.isLineChart(subChartType) || predicate.isAreaChart(subChartType);
	        });

	        return predicate.isComboChart(chartType) && isAllLineType;
	    },

	    /**
	     * Whether line and area combo chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @param {Array.<string>} subChartTypes - types of chart
	     * @returns {boolean}
	     */
	    hasLineChart: function(chartType, subChartTypes) {
	        var hasLineType = arrayUtil.any(subChartTypes || [], function(subChartType) {
	            return predicate.isLineChart(subChartType);
	        });

	        return predicate.isComboChart(chartType) && hasLineType;
	    },

	    /**
	     * Whether line and scatter combo chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @param {Array.<string>} subChartTypes - types of chart
	     * @returns {boolean}
	     */
	    isLineScatterComboChart: function(chartType, subChartTypes) {
	        var isAllLineType = arrayUtil.all(subChartTypes || [], function(subChartType) {
	            return predicate.isLineChart(subChartType) || predicate.isScatterChart(subChartType);
	        });

	        return predicate.isComboChart(chartType) && isAllLineType;
	    },

	    /**
	     * Whether line type chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @param {Array.<string>} [subChartTypes] - types of chart
	     * @returns {boolean}
	     */
	    isLineTypeChart: function(chartType, subChartTypes) {
	        return predicate.isLineChart(chartType) || predicate.isAreaChart(chartType)
	            || predicate.isLineAreaComboChart(chartType, subChartTypes);
	    },

	    /**
	     * Whether bubble chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isBubbleChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_BUBBLE;
	    },

	    /**
	     * Whether scatter chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    isScatterChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_SCATTER;
	    },

	    /**
	     * Whether heatmap chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    isHeatmapChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_HEATMAP;
	    },

	    /**
	     * Whether treemap chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    isTreemapChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_TREEMAP;
	    },

	    /**
	     * Whether box type chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    isBoxTypeChart: function(chartType) {
	        return predicate.isHeatmapChart(chartType) || predicate.isTreemapChart(chartType);
	    },

	    /**
	     * Whether pie chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    isPieChart: function(chartType) {
	        // change to indexOf for handling alias
	        return chartType && chartType.indexOf(chartConst.CHART_TYPE_PIE) !== -1;
	    },

	    /**
	     * Whether map chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isMapChart: function(chartType) {
	        return chartType === chartConst.CHART_TYPE_MAP;
	    },

	    /**
	     * Whether map type chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    isMapTypeChart: function(chartType) {
	        return (this.isMapChart(chartType) || this.isHeatmapChart(chartType) || this.isTreemapChart(chartType));
	    },

	    /**
	     * Whether coordinate type chart or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    isCoordinateTypeChart: function(chartType) {
	        return predicate.isBubbleChart(chartType) || predicate.isScatterChart(chartType);
	    },

	    /**
	     * Whether allow rendering for minus point in area of series.
	     * @memberOf module:predicate
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    allowMinusPointRender: function(chartType) {
	        return predicate.isLineTypeChart(chartType) || predicate.isCoordinateTypeChart(chartType) ||
	            predicate.isBoxTypeChart(chartType) || predicate.isBulletChart(chartType);
	    },

	    /**
	     * Whether chart to detect mouse events on series or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isChartToDetectMouseEventOnSeries: function(chartType) {
	        return predicate.isPieChart(chartType) || predicate.isMapChart(chartType)
	            || predicate.isCoordinateTypeChart(chartType);
	    },

	    /**
	     * Whether align of label is outer or not.
	     * @memberOf module:predicate
	     * @param {string} align - align of legend
	     * @returns {boolean}
	     */
	    isLabelAlignOuter: function(align) {
	        return align === chartConst.LABEL_ALIGN_OUTER;
	    },

	    /**
	     * Whether show label or not.
	     * @param {{showLabel: ?boolean, showLegend: ?boolean}} options - options
	     * @returns {boolean}
	     */
	    isShowLabel: function(options) {
	        return options.showLabel || options.showLegend;
	    },

	    /**
	     * Whether show outer label or not.
	     * @param {{showLabel: ?boolean, showLegend: ?boolean, labelAlign: string}} options - options
	     * @returns {*|boolean}
	     */
	    isShowOuterLabel: function(options) {
	        return predicate.isShowLabel(options) && predicate.isLabelAlignOuter(options.labelAlign);
	    },

	    /**
	     * Whether align of legend is left or not.
	     * @memberOf module:predicate
	     * @param {string} align - align of legend
	     * @returns {boolean}
	     */
	    isLegendAlignLeft: function(align) {
	        return align === chartConst.LEGEND_ALIGN_LEFT;
	    },

	    /**
	     * Whether align of legend is top or not.
	     * @memberOf module:predicate
	     * @param {string} align - align of legend
	     * @returns {boolean}
	     */
	    isLegendAlignTop: function(align) {
	        return align === chartConst.LEGEND_ALIGN_TOP;
	    },

	    /**
	     * Whether align of legend is bottom or not.
	     * @memberOf module:predicate
	     * @param {string} align - align of legend
	     * @returns {boolean}
	     */
	    isLegendAlignBottom: function(align) {
	        return align === chartConst.LEGEND_ALIGN_BOTTOM;
	    },

	    /**
	     * Whether horizontal legend or not.
	     * @memberOf module:predicate
	     * @param {string} align - align option for legend
	     * @returns {boolean}
	     */
	    isHorizontalLegend: function(align) {
	        return predicate.isLegendAlignTop(align) || predicate.isLegendAlignBottom(align);
	    },

	    /**
	     * Whether vertical legend or not.
	     * @memberOf module:predicate
	     * @param {string} align - align option for legend
	     * @returns {boolean}
	     */
	    isVerticalLegend: function(align) {
	        return !predicate.isHorizontalLegend(align);
	    },

	    /**
	     * Whether allowed stackType option or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - type of chart
	     * @returns {boolean}
	     */
	    isAllowedStackOption: function(chartType) {
	        return predicate.isBarChart(chartType) || predicate.isColumnChart(chartType)
	            || predicate.isAreaChart(chartType);
	    },

	    /**
	     * Whether normal stack type or not.
	     * @memberOf module:predicate
	     * @param {boolean} stackType - stackType option
	     * @returns {boolean}
	     */
	    isNormalStack: function(stackType) {
	        return stackType === chartConst.NORMAL_STACK_TYPE;
	    },

	    /**
	     * Whether percent stack type or not.
	     * @memberOf module:predicate
	     * @param {boolean} stackType - stackType option
	     * @returns {boolean}
	     */
	    isPercentStack: function(stackType) {
	        return stackType === chartConst.PERCENT_STACK_TYPE;
	    },

	    /**
	     * Whether valid stackType option or not.
	     * @memberOf module:predicate
	     * @param {boolean} stackType - stackType option
	     * @returns {boolean}
	     */
	    isValidStackOption: function(stackType) {
	        return stackType && (predicate.isNormalStack(stackType) || predicate.isPercentStack(stackType));
	    },

	    /**
	     * Whether allow range data or not.
	     * @memberOf module:predicate
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    isAllowRangeData: function(chartType) {
	        return predicate.isBarTypeChart(chartType) || predicate.isAreaChart(chartType);
	    },

	    /**
	     * Whether align of yAxis is center or not.
	     * @memberOf module:predicate
	     * @param {boolean} hasRightYAxis - whether has right yAxis.
	     * @param {string} alignOption - align option of yAxis.
	     * @returns {boolean} whether - align center or not.
	     */
	    isYAxisAlignCenter: function(hasRightYAxis, alignOption) {
	        return !hasRightYAxis && (alignOption === chartConst.YAXIS_ALIGN_CENTER);
	    },

	    /**
	     * Whether minus limit or not.
	     * @memberOf module:predicate
	     * @param {{min: number, max: number}} limit - limit
	     * @returns {boolean}
	     */
	    isMinusLimit: function(limit) {
	        return limit.min <= 0 && limit.max <= 0;
	    },

	    /**
	     * Whether auto tick interval or not.
	     * @param {string} [tickInterval] - tick interval option
	     * @returns {boolean}
	     */
	    isAutoTickInterval: function(tickInterval) {
	        return tickInterval === chartConst.TICK_INTERVAL_AUTO;
	    },

	    /**
	     * Whether valid label interval or not.
	     * @param {number} [labelInterval] - label interval option
	     * @param {string} [tickInterval] - tick interval option
	     * @returns {*|boolean}
	     */
	    isValidLabelInterval: function(labelInterval, tickInterval) {
	        return labelInterval && labelInterval > 1 && !tickInterval;
	    },

	    /**
	     * Whether datetime type or not.
	     * @param {string} type - type
	     * @returns {boolean}
	     */
	    isDatetimeType: function(type) {
	        return type === chartConst.AXIS_TYPE_DATETIME;
	    },

	    /**
	     * @param {string} chartType - type of chart
	     * @returns {boolean} - whether it support ChartBase#showTooltip API
	     */
	    isSupportPublicShowTooptipAPI: function(chartType) {
	        return this.isBarChart(chartType) ||
	            this.isColumnChart(chartType) ||
	            this.isLineChart(chartType) ||
	            this.isAreaChart(chartType) ||
	            this.isBoxplotChart(chartType);
	    },

	    /**
	     * @param {string} chartType - type of chart
	     * @returns {boolean} - whether it support ChartBase#hideTooltip API
	     */
	    isSupportPublicHideTooptipAPI: function(chartType) {
	        return this.isBarChart(chartType) ||
	            this.isColumnChart(chartType) ||
	            this.isLineChart(chartType) ||
	            this.isAreaChart(chartType) ||
	            this.isBoxplotChart(chartType);
	    }
	};

	module.exports = predicate;


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raphael boxplot chart renderer.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var snippet = __webpack_require__(6);
	var raphael = __webpack_require__(3);

	var ANIMATION_DURATION = 700;
	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;
	var DEFAULT_LUMINANC = 0.2;
	var BOX_STROKE_WIDTH = 1;
	var EDGE_LINE_WIDTH = 2;
	var MEDIAN_LINE_WIDTH = 2;
	var WHISKER_LINE_WIDTH = 1;

	/**
	 * @classdesc RaphaelBoxplotChart is graph renderer for bar, column chart.
	 * @class RaphaelBoxplotChart
	 * @private
	 */
	var RaphaelBoxplotChart = snippet.defineClass(/** @lends RaphaelBoxplotChart.prototype */ {
	    /**
	     * Render function of bar chart
	     * @param {object} paper paper object
	     * @param {{size: object, model: object, options: object, tooltipPosition: string}} data chart data
	     * @returns {Array.<object>} seriesSet
	     */
	    render: function(paper, data) {
	        var groupBounds = data.groupBounds;

	        if (!groupBounds) {
	            return null;
	        }

	        this.paper = paper;

	        this.theme = data.theme;
	        this.options = data.options;
	        this.seriesDataModel = data.seriesDataModel;
	        this.chartType = data.chartType;

	        this.paper.setStart();
	        this.groupWhiskers = [];
	        this.groupMedians = [];
	        this.groupBoxes = this._renderBoxplots(groupBounds);
	        this.groupBorders = this._renderBoxBorders(groupBounds);

	        this.rectOverlay = this._renderRectOverlay();
	        this.circleOverlay = this._renderCircleOverlay();
	        this.groupBounds = groupBounds;

	        return this.paper.setFinish();
	    },

	    /**
	     * Render overlay.
	     * @returns {object} raphael object
	     * @private
	     */
	    _renderRectOverlay: function() {
	        var bound = {
	            width: 1,
	            height: 1,
	            left: 0,
	            top: 0
	        };
	        var attributes = {
	            'fill-opacity': 0
	        };

	        return raphaelRenderUtil.renderRect(this.paper, bound, snippet.extend({
	            'stroke-width': 0
	        }, attributes));
	    },

	    /**
	     * Render overlay.
	     * @returns {object} raphael object
	     * @private
	     */
	    _renderCircleOverlay: function() {
	        var position = {
	            left: 0,
	            top: 0
	        };
	        var attributes = {
	            'fill-opacity': 0
	        };

	        return raphaelRenderUtil.renderCircle(this.paper, position, 0, snippet.extend({
	            'stroke-width': 0
	        }, attributes));
	    },

	    /**
	     * Render rect
	     * @param {{left: number, top: number, width: number, height: number}} bound bound
	     * @param {string} color series color
	     * @param {object} [attributes] - attributes
	     * @returns {object} bar rect
	     * @private
	     */
	    _renderBox: function(bound, color, attributes) {
	        var rect;

	        if (bound.width < 0 || bound.height < 0) {
	            return null;
	        }

	        rect = raphaelRenderUtil.renderRect(this.paper, bound, snippet.extend({
	            fill: '#fff',
	            stroke: color,
	            'stroke-width': BOX_STROKE_WIDTH
	        }, attributes));

	        return rect;
	    },

	    /**
	     * Render boxes.
	     * @param {Array.<Array.<{left: number, top:number, width: number, height: number}>>} groupBounds bounds
	     * @returns {Array.<Array.<object>>} bars
	     * @private
	     */
	    _renderBoxes: function(groupBounds) {
	        var self = this;
	        var colors = this.theme.colors;
	        var colorByPoint = this.options.colorByPoint;

	        return snippet.map(groupBounds, function(bounds, groupIndex) {
	            return snippet.map(bounds, function(bound, index) {
	                var color, rect, item;

	                if (!bound) {
	                    return null;
	                }

	                item = self.seriesDataModel.getSeriesItem(groupIndex, index);

	                color = colorByPoint ? colors[groupIndex] : colors[index];

	                if (bound.start) {
	                    rect = self._renderBox(bound.start, color);
	                }

	                return {
	                    rect: rect,
	                    color: color,
	                    bound: bound.end,
	                    item: item,
	                    groupIndex: groupIndex,
	                    index: index
	                };
	            });
	        });
	    },

	    /**
	     * Render boxplots.
	     * @param {Array.<Array.<{left: number, top:number, width: number, height: number}>>} groupBounds bounds
	     * @returns {Array.<Array.<object>>} bars
	     * @private
	     */
	    _renderBoxplots: function(groupBounds) {
	        var groupBoxes = this._renderBoxes(groupBounds);

	        this.groupWhiskers = this._renderWhiskers(groupBounds);
	        this.groupMedians = this._renderMedianLines(groupBounds);
	        this.groupOutliers = this._renderOutliers(groupBounds);

	        return groupBoxes;
	    },

	    _renderWhisker: function(end, start, color) {
	        var paper = this.paper;
	        var topDistance = start.top - end.top;
	        var whiskerDirection = topDistance > 0 ? 1 : -1;
	        var width = end.width;
	        var left = end.left;
	        var quartileWidth = width / 4;
	        var edgePath = 'M' + (left + quartileWidth) + ',' + end.top + 'H' + (left + (quartileWidth * 3));
	        var whiskerPath = 'M' + (left + (quartileWidth * 2)) + ',' + end.top + 'V' + (end.top + (Math.abs(topDistance) * whiskerDirection));
	        var edge = raphaelRenderUtil.renderLine(paper, edgePath, color, EDGE_LINE_WIDTH);
	        var whisker = raphaelRenderUtil.renderLine(paper, whiskerPath, color, WHISKER_LINE_WIDTH);
	        var whiskers = [];

	        edge.attr({
	            opacity: 0
	        });
	        whisker.attr({
	            opacity: 0
	        });

	        whiskers.push(edge);
	        whiskers.push(whisker);

	        return whiskers;
	    },

	    _renderWhiskers: function(groupBounds) {
	        var self = this;
	        var colors = this.theme.colors;
	        var colorByPoint = this.options.colorByPoint;
	        var groupWhiskers = [];

	        snippet.forEach(groupBounds, function(bounds, groupIndex) {
	            var whiskers = [];

	            snippet.forEach(bounds, function(bound, index) {
	                var color = colorByPoint ? colors[groupIndex] : colors[index];

	                if (!bound) {
	                    return;
	                }

	                whiskers = whiskers.concat(self._renderWhisker(bound.min, bound.start, color));
	                whiskers = whiskers.concat(self._renderWhisker(bound.max, bound.end, color));
	            });

	            groupWhiskers.push(whiskers);
	        });

	        return groupWhiskers;
	    },

	    _renderMedianLine: function(bound, color) {
	        var width = bound.width;
	        var medianLinePath = 'M' + bound.left + ',' + bound.top + 'H' + (bound.left + width);
	        var median = raphaelRenderUtil.renderLine(this.paper, medianLinePath, color, MEDIAN_LINE_WIDTH);

	        median.attr({
	            opacity: 0
	        });

	        return median;
	    },

	    _renderMedianLines: function(groupBounds) {
	        var self = this;
	        var colors = this.theme.colors;
	        var colorByPoint = this.options.colorByPoint;
	        var groupMedians = [];

	        snippet.forEach(groupBounds, function(bounds, groupIndex) {
	            var medians = [];

	            snippet.forEach(bounds, function(bound, index) {
	                var color = colorByPoint ? colors[groupIndex] : colors[index];

	                if (!bound) {
	                    return;
	                }

	                medians.push(self._renderMedianLine(bound.median, color));
	            });
	            groupMedians.push(medians);
	        });

	        return groupMedians;
	    },

	    _renderOutlier: function(bound, color) {
	        var outlier = raphaelRenderUtil.renderCircle(this.paper, {
	            left: bound.left,
	            top: bound.top
	        }, 3, {
	            stroke: color
	        });

	        outlier.attr({
	            opacity: 0
	        });

	        return outlier;
	    },

	    _renderOutliers: function(groupBounds) {
	        var self = this;
	        var colors = this.theme.colors;
	        var colorByPoint = this.options.colorByPoint;
	        var groupOutliers = [];

	        snippet.forEach(groupBounds, function(bounds, groupIndex) {
	            var outliers = [];
	            snippet.forEach(bounds, function(bound, index) {
	                var color = colorByPoint ? colors[groupIndex] : colors[index];
	                var seriesOutliers = [];

	                if (!bound) {
	                    return;
	                }

	                if (bound.outliers.length) {
	                    snippet.forEach(bound.outliers, function(outlier) {
	                        seriesOutliers.push(self._renderOutlier(outlier, color));
	                    });
	                }
	                outliers.push(seriesOutliers);
	            });
	            groupOutliers.push(outliers);
	        });

	        return groupOutliers;
	    },

	    /**
	     * Make rect points.
	     * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	     * @returns {{
	     *      leftTop: {left: number, top: number},
	     *      rightTop: {left: number, top: number},
	     *      rightBottom: {left: number, top: number},
	     *      leftBottom: {left: number, top: number}
	     * }} rect points
	     * @private
	     */
	    _makeRectPoints: function(bound) {
	        return {
	            leftTop: {
	                left: Math.ceil(bound.left),
	                top: Math.ceil(bound.top)
	            },
	            rightTop: {
	                left: Math.ceil(bound.left + bound.width),
	                top: Math.ceil(bound.top)
	            },
	            rightBottom: {
	                left: Math.ceil(bound.left + bound.width),
	                top: Math.ceil(bound.top + bound.height)
	            },
	            leftBottom: {
	                left: Math.ceil(bound.left),
	                top: Math.ceil(bound.top + bound.height)
	            }
	        };
	    },

	    /**
	     * Render border lines;
	     * @param {{left: number, top:number, width: number, height: number}} bound bar bound
	     * @param {string} borderColor border color
	     * @param {string} chartType chart type
	     * @param {Item} item item
	     * @returns {object} raphael object
	     * @private
	     */
	    _renderBorderLines: function(bound, borderColor, chartType, item) {
	        var self = this;
	        var borderLinePaths = this._makeBorderLinesPaths(bound, chartType, item);
	        var lines = {};

	        snippet.forEach(borderLinePaths, function(path, name) {
	            lines[name] = raphaelRenderUtil.renderLine(self.paper, path, borderColor, 1);
	        });

	        return lines;
	    },

	    /**
	     * Render bar borders.
	     * @param {Array.<Array.<{left: number, top:number, width: number, height: number}>>} groupBounds bounds
	     * @returns {Array.<Array.<object>>} borders
	     * @private
	     */
	    _renderBoxBorders: function(groupBounds) {
	        var self = this,
	            borderColor = this.theme.borderColor,
	            groupBorders;

	        if (!borderColor) {
	            return null;
	        }

	        groupBorders = snippet.map(groupBounds, function(bounds, groupIndex) {
	            return snippet.map(bounds, function(bound, index) {
	                var seriesItem;

	                if (!bound) {
	                    return null;
	                }

	                seriesItem = self.seriesDataModel.getSeriesItem(groupIndex, index);

	                return self._renderBorderLines(bound.start, borderColor, self.chartType, seriesItem);
	            });
	        });

	        return groupBorders;
	    },

	    /**
	     * Animate rect.
	     * @param {object} rect raphael object
	     * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	     * @private
	     */
	    _animateRect: function(rect, bound) {
	        rect.animate({
	            x: bound.left,
	            y: bound.top,
	            width: bound.width,
	            height: bound.height
	        }, ANIMATION_DURATION, '>');
	    },

	    /**
	     * Animate.
	     * @param {function} onFinish finish callback function
	     */
	    animate: function(onFinish) {
	        var self = this;
	        var animation = raphael.animation({
	            opacity: 1
	        }, ANIMATION_DURATION);

	        raphaelRenderUtil.forEach2dArray(this.groupBoxes, function(box) {
	            if (!box) {
	                return;
	            }
	            self._animateRect(box.rect, box.bound);
	        });

	        raphaelRenderUtil.forEach2dArray(self.groupWhiskers, function(whisker) {
	            whisker.animate(animation.delay(ANIMATION_DURATION));
	        });

	        raphaelRenderUtil.forEach2dArray(self.groupMedians, function(median) {
	            median.animate(animation.delay(ANIMATION_DURATION));
	        });

	        raphaelRenderUtil.forEach2dArray(self.groupOutliers, function(outliers) {
	            snippet.forEach(outliers, function(outlier) {
	                outlier.animate(animation.delay(ANIMATION_DURATION));
	            });
	        });

	        if (onFinish) {
	            this.callbackTimeout = setTimeout(function() {
	                onFinish();
	                delete self.callbackTimeout;
	            }, ANIMATION_DURATION);
	        }
	    },

	    /**
	     * Show animation.
	     * @param {{groupIndex: number, index:number}} data show info
	     */
	    showAnimation: function(data) {
	        if (snippet.isNumber(data.outlierIndex)) {
	            this.showOutlierAnimation(data);
	        } else {
	            this.showRectAnimation(data);
	        }
	    },

	    /**
	     * Show animation.
	     * @param {{groupIndex: number, index:number}} data show info
	     */
	    showRectAnimation: function(data) {
	        var bar = this.groupBoxes[data.groupIndex][data.index],
	            bound = bar.bound;

	        this.rectOverlay.attr({
	            width: bound.width,
	            height: bound.height,
	            x: bound.left,
	            y: bound.top,
	            fill: bar.color,
	            'fill-opacity': 0.3
	        });
	    },

	    /**
	     * Show animation.
	     * @param {{groupIndex: number, index:number}} data show info
	     */
	    showOutlierAnimation: function(data) {
	        var targetAttr = this.groupOutliers[data.groupIndex][data.index][data.outlierIndex].attr();

	        this.circleOverlay.attr({
	            r: targetAttr.r,
	            cx: targetAttr.cx,
	            cy: targetAttr.cy,
	            fill: targetAttr.stroke,
	            'fill-opacity': 0.3,
	            stroke: targetAttr.stroke,
	            'stroke-width': 2
	        });
	    },

	    /**
	     * Hide animation.
	     */
	    hideAnimation: function() {
	        this.circleOverlay.attr({
	            width: 1,
	            height: 1,
	            x: 0,
	            y: 0,
	            'fill-opacity': 0,
	            'stroke-width': 0
	        });
	        this.rectOverlay.attr({
	            width: 1,
	            height: 1,
	            x: 0,
	            y: 0,
	            'fill-opacity': 0
	        });
	    },

	    /**
	     * Update rect bound
	     * @param {object} rect raphael object
	     * @param {{left: number, top: number, width: number, height: number}} bound bound
	     * @private
	     */
	    _updateRectBound: function(rect, bound) {
	        rect.attr({
	            x: bound.left,
	            y: bound.top,
	            width: bound.width,
	            height: bound.height
	        });
	    },

	    /**
	     * Resize graph of bar type chart.
	     * @param {object} params parameters
	     *      @param {{width: number, height:number}} params.dimension dimension
	     *      @param {Array.<Array.<{
	     *                  left:number, top:number, width: number, height: number
	     *              }>>} params.groupBounds group bounds
	     */
	    resize: function(params) {
	        var dimension = params.dimension;
	        var groupBounds = params.groupBounds;

	        this.groupBounds = groupBounds;
	        this.paper.setSize(dimension.width, dimension.height);

	        raphaelRenderUtil.forEach2dArray(this.groupBoxes, function(bar, groupIndex, index) {
	            var bound;

	            if (!bar) {
	                return;
	            }

	            bound = groupBounds[groupIndex][index].end;
	            bar.bound = bound;
	            raphaelRenderUtil.updateRectBound(bar.rect, bound);
	        });
	    },

	    /**
	     * Change borders color.
	     * @param {Array.<object>} lines raphael objects
	     * @param {borderColor} borderColor border color
	     * @private
	     */
	    _changeBordersColor: function(lines, borderColor) {
	        snippet.forEach(lines, function(line) {
	            line.attr({stroke: borderColor});
	        });
	    },

	    /**
	     * Change bar color.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     * @param {string} color fill color
	     * @param {?string} borderColor stroke color
	     * @private
	     */
	    _changeBoxColor: function(indexes, color, borderColor) {
	        var bar = this.groupBoxes[indexes.groupIndex][indexes.index];
	        var lines;

	        bar.rect.attr({
	            stroke: color
	        });

	        if (borderColor) {
	            lines = this.groupBorders[indexes.groupIndex][indexes.index];
	            this._changeBordersColor(lines, borderColor);
	        }
	    },

	    /**
	     * Select series.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     */
	    selectSeries: function(indexes) {
	        var bar = this.groupBoxes[indexes.groupIndex][indexes.index],
	            objColor = raphael.color(bar.color),
	            selectionColorTheme = this.theme.selectionColor,
	            color = selectionColorTheme || raphaelRenderUtil.makeChangedLuminanceColor(objColor.hex, DEFAULT_LUMINANC),
	            borderColor = this.theme.borderColor,
	            objBorderColor;

	        if (borderColor) {
	            objBorderColor = raphael.color(borderColor);
	            borderColor = raphaelRenderUtil.makeChangedLuminanceColor(objBorderColor.hex, DEFAULT_LUMINANC);
	        }

	        this._changeBoxColor(indexes, color, borderColor);
	    },

	    /**
	     * Unselect series.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     */
	    unselectSeries: function(indexes) {
	        var bar = this.groupBoxes[indexes.groupIndex][indexes.index],
	            borderColor = this.theme.borderColor;
	        this._changeBoxColor(indexes, bar.color, borderColor);
	    },

	    /**
	     * Select legend.
	     * @param {?number} legendIndex legend index
	     */
	    selectLegend: function(legendIndex) {
	        var noneSelected = snippet.isNull(legendIndex);

	        raphaelRenderUtil.forEach2dArray(this.groupBoxes, function(box, groupIndex, index) {
	            var opacity;

	            if (!box) {
	                return;
	            }

	            opacity = (noneSelected || legendIndex === index) ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;

	            box.rect.attr({'stroke-opacity': opacity});
	        });
	        raphaelRenderUtil.forEach2dArray(this.groupWhiskers, function(whisker, groupIndex, index) {
	            var opacity = (noneSelected || legendIndex === index) ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;

	            whisker.attr({'stroke-opacity': opacity});
	        });
	        raphaelRenderUtil.forEach2dArray(this.groupMedians, function(median, groupIndex, index) {
	            var opacity = (noneSelected || legendIndex === index) ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;

	            median.attr({'stroke-opacity': opacity});
	        });
	    },

	    renderSeriesLabel: function(paper, groupPositions, groupLabels, labelTheme, isStacked) {
	        var attributes = {
	            'font-size': labelTheme.fontSize,
	            'font-family': labelTheme.fontFamily,
	            'font-weight': labelTheme.fontWeight,
	            fill: labelTheme.color,
	            opacity: 0,
	            'text-anchor': isStacked ? 'middle' : 'start'
	        };
	        var labelSet = paper.set();

	        snippet.forEach(groupLabels, function(categoryLabel, categoryIndex) {
	            snippet.forEach(categoryLabel, function(label, seriesIndex) {
	                var position = groupPositions[categoryIndex][seriesIndex];
	                var endLabel = raphaelRenderUtil.renderText(paper, position.end, label.end, attributes);
	                var startLabel;

	                endLabel.node.style.userSelect = 'none';
	                endLabel.node.style.cursor = 'default';
	                endLabel.node.setAttribute('filter', 'url(#glow)');

	                labelSet.push(endLabel);

	                if (position.start) {
	                    startLabel = raphaelRenderUtil.renderText(paper, position.start, label.start, attributes);
	                    startLabel.node.style.userSelect = 'none';
	                    startLabel.node.style.cursor = 'default';
	                    startLabel.node.setAttribute('filter', 'url(#glow)');

	                    labelSet.push(startLabel);
	                }
	            });
	        });

	        return labelSet;
	    }
	});

	module.exports = RaphaelBoxplotChart;


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raphael bullet chart renderer.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var chartConst = __webpack_require__(8);
	var snippet = __webpack_require__(6);
	var renderUtil = __webpack_require__(7);

	var browser = snippet.browser;
	var IS_LTE_IE8 = browser.msie && browser.version <= 8;
	var ANIMATION_DURATION = 700;
	var ANIMATION_DELAY = 700;
	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;
	var EVENT_DETECTOR_PADDING = 20;

	/**
	 * @classdesc RaphaelBulletChart is graph renderer for bullet chart.
	 * @class RaphaelBulletChart
	 * @private
	 */
	var RaphaelBulletChart = snippet.defineClass(/** @lends RaphaelBulletChart.prototype */ {
	    /**
	     * Render function of bar chart
	     * @param {object} paper paper object
	     * @param {{size: object, model: object, options: object, tooltipPosition: string}} data chart data
	     * @returns {Array.<object>} seriesSet
	     */
	    render: function(paper, data) {
	        var groupBounds = data.groupBounds;
	        var seriesDataModel = data.seriesDataModel;

	        if (!groupBounds || !groupBounds.length) {
	            return null;
	        }

	        this.paper = paper;

	        this.theme = data.theme;
	        this.dimension = data.dimension;
	        this.position = data.position;
	        this.options = data.options;
	        this.chartType = data.chartType;
	        this.isVertical = data.isVertical;

	        this.seriesDataModel = seriesDataModel;
	        this.maxRangeCount = seriesDataModel.maxRangeCount;
	        this.maxMarkerCount = seriesDataModel.maxMarkerCount;

	        this.rangeOpacities = {};

	        this.paper.setStart();

	        this._renderBounds(groupBounds);

	        return this.paper.setFinish();
	    },

	    /**
	     * Get range opacity by index
	     * If rangeOpacities[index] not exists, create and store. then use it next time
	     * @param {number} index - ranges index
	     * @returns {number} - opacity of ranges bar at index
	     * @private
	     */
	    _getRangeOpacity: function(index) {
	        var maxRangeCount = this.maxRangeCount;
	        if (this.prevMaxRangeCount !== maxRangeCount) {
	            this._updateOpacityStep(maxRangeCount);
	        }

	        if (index < maxRangeCount && !this.rangeOpacities[index]) {
	            this.rangeOpacities[index] = 1 - (this.opacityStep * (index + 1));
	        }

	        return this.rangeOpacities[index];
	    },

	    /**
	     * Update opacity step using maxRangeCount
	     * @param {number} maxRangeCount - maximum count of ranges bar among series graphes
	     * @private
	     */
	    _updateOpacityStep: function(maxRangeCount) {
	        this.rangeOpacities = {};
	        this.opacityStep = Number(1 / (maxRangeCount + 1)).toFixed(2);
	        this.prevMaxRangeCount = maxRangeCount;
	    },

	    /**
	     * Render bullet graph using groupBounds model
	     * @param {Array.<object>} groupBounds - bounds data for rendering bullet graph
	     * @private
	     */
	    _renderBounds: function(groupBounds) {
	        var rangeThemes = this.theme.ranges;
	        var paper = this.paper;

	        this.groupBars = [];
	        this.groupLines = [];

	        snippet.forEach(groupBounds, function(bounds, groupIndex) {
	            var seriesColor = this.theme.colors[groupIndex];
	            var rangeIndex = 0;
	            var barSet = paper.set();
	            var lineSet = paper.set();

	            snippet.forEach(bounds, function(bound) {
	                var type = bound.type;

	                if (type === chartConst.BULLET_TYPE_ACTUAL) {
	                    barSet.push(this._renderActual(bound, seriesColor));
	                } else if (type === chartConst.BULLET_TYPE_RANGE) {
	                    barSet.push(this._renderRange(bound, seriesColor, rangeIndex, rangeThemes[rangeIndex]));
	                    rangeIndex += 1;
	                } else if (type === chartConst.BULLET_TYPE_MARKER) {
	                    lineSet.push(this._renderMarker(bound, seriesColor));
	                }
	            }, this);

	            this.groupBars.push(barSet);
	            this.groupLines.push(lineSet);
	        }, this);
	    },

	    /**
	     * Render actual bar
	     * @param {object} bound - bound model on start point
	     * @param {string} seriesColor - series color for painting actual bar
	     * @returns {Element} - rendered actual bar
	     * @private
	     */
	    _renderActual: function(bound, seriesColor) {
	        if (!bound) {
	            return null;
	        }

	        return this._renderBar(bound, seriesColor);
	    },

	    /**
	     * Render range bar
	     * @param {object} bound - bound model on start point
	     * @param {string} seriesColor - series color for painting range bar
	     * @param {number} rangeIndex - ranges index
	     * @param {object} rangeTheme - range theme
	     * @returns {Element} - rendered range bar
	     * @private
	     */
	    _renderRange: function(bound, seriesColor, rangeIndex, rangeTheme) {
	        var color = seriesColor;
	        var opacity = this._getRangeOpacity(rangeIndex);
	        var attr = {opacity: opacity};

	        if (!bound) {
	            return null;
	        }

	        if (rangeTheme) {
	            color = rangeTheme.color || color;
	            attr.opacity = rangeTheme.opacity || opacity;
	        }

	        return this._renderBar(bound, color, attr);
	    },

	    /**
	     * Create bar type element using passing arguments
	     * @param {object} bound - bound data for render rect element
	     * @param {string} color - hex type color string
	     * @param {object} attributes - styling attributes
	     * @returns {Element} - svg rect element
	     * @private
	     */
	    _renderBar: function(bound, color, attributes) {
	        if (bound.width < 0 || bound.height < 0) {
	            return null;
	        }

	        return raphaelRenderUtil.renderRect(this.paper, bound, snippet.extend({
	            fill: color,
	            stroke: 'none'
	        }, attributes));
	    },

	    /**
	     * Render marker
	     * @param {object} bound - bound model of marker
	     * @param {string} seriesColor - series color for painting marker
	     * @returns {Element} - rendered marker
	     * @private
	     */
	    _renderMarker: function(bound, seriesColor) {
	        if (!bound) {
	            return null;
	        }

	        return this._renderLine(bound, seriesColor);
	    },

	    /**
	     * Create line element using passing arguments
	     * @param {object} bound - bound data for render path element
	     * @param {string} color - hex type color string
	     * @returns {Element} - svg rect element
	     * @private
	     */
	    _renderLine: function(bound, color) {
	        var top = bound.top;
	        var left = bound.left;
	        var length = bound.length;
	        var endPosition = this.isVertical ? 'L' + (left + length) + ',' + top : 'L' + left + ',' + (top + length);
	        var path = 'M' + left + ',' + top + endPosition;

	        return raphaelRenderUtil.renderLine(this.paper, path, color, chartConst.BULLET_MARKER_STROKE_TICK);
	    },

	    /**
	     * Animate.
	     * @param {function} onFinish finish callback function
	     * @param {Array.<object>} seriesSet series set
	     */
	    animate: function(onFinish, seriesSet) {
	        var paper = this.paper;
	        var dimension = this.dimension;
	        var position = this.position;
	        var clipRect = this.clipRect;
	        var clipRectId = this._getClipRectId();
	        var clipRectWidth = dimension.width - EVENT_DETECTOR_PADDING;
	        var clipRectHeight = dimension.height - EVENT_DETECTOR_PADDING;
	        var startDimension = {};
	        var animateAttr = {};

	        if (this.isVertical) {
	            startDimension.width = clipRectWidth;
	            startDimension.height = 0;
	            animateAttr.height = clipRectHeight;
	        } else {
	            startDimension.width = 0;
	            startDimension.height = clipRectHeight;
	            animateAttr.width = clipRectWidth;
	        }

	        // Animation was implemented using <clipPath> SVG element
	        // As Browser compatibility of <clipPath> is IE9+,
	        // No Animation on IE8
	        if (!IS_LTE_IE8 && dimension) {
	            if (!clipRect) {
	                clipRect = createClipPathRectWithLayout(paper, position, startDimension, clipRectId);
	                this.clipRect = clipRect;
	            } else {
	                clipRect.attr({
	                    x: position.left,
	                    y: position.top
	                });
	                clipRect.attr(startDimension);
	            }

	            seriesSet.forEach(function(element) {
	                if (element.type === 'set') {
	                    element.forEach(function(item) {
	                        item.node.setAttribute('clip-path', 'url(#' + clipRectId + ')');
	                    });
	                } else {
	                    element.node.setAttribute('clip-path', 'url(#' + clipRectId + ')');
	                }
	            });

	            clipRect.animate(animateAttr, ANIMATION_DURATION, '>', onFinish);
	        }

	        if (onFinish) {
	            this.callbackTimeout = setTimeout(function() {
	                onFinish();
	                delete self.callbackTimeout;
	            }, ANIMATION_DELAY);
	        }
	    },

	    /**
	     * Resize bullet chart
	     * @param {object} params parameters
	     *      @param {{width: number, height:number}} params.dimension dimension
	     *      @param {Array.<Array.<{
	     *                  left:number, top:number, width: number, height: number
	     *              }>>} params.groupBounds group bounds
	     */
	    resize: function(params) {
	        var dimension = params.dimension;
	        var groupBounds = params.groupBounds;
	        var width = dimension.width;
	        var height = dimension.height;

	        this.dimension = params.dimension;
	        this.groupBounds = groupBounds;
	        this.resizeClipRect(width, height);
	        this.paper.setSize(width, height);

	        this._renderBounds(groupBounds);
	    },

	    /**
	     * Resize clip rect size
	     * @param {number} width series width
	     * @param {number} height series height
	     */
	    resizeClipRect: function(width, height) {
	        var clipRect = this.paper.getById(this._getClipRectId() + '_rect');

	        clipRect.attr({
	            width: width,
	            height: height
	        });
	    },

	    /**
	     * set clip rect position
	     * @param {object} position series position
	     */
	    setClipRectPosition: function(position) {
	        var clipRect = this.paper.getById(this._getClipRectId() + '_rect');

	        clipRect.attr({
	            x: position.left,
	            y: position.top
	        });
	    },

	    /**
	     * Set clip rect id
	     * @returns {string} id - clip rect id
	     * @private
	     */
	    _getClipRectId: function() {
	        if (!this.clipRectId) {
	            this.clipRectId = renderUtil.generateClipRectId();
	        }

	        return this.clipRectId;
	    },

	    /**
	     * Change borders color.
	     * @param {Array.<object>} lines raphael objects
	     * @param {borderColor} borderColor border color
	     * @private
	     */
	    _changeBordersColor: function(lines, borderColor) {
	        snippet.forEach(lines, function(line) {
	            line.attr({stroke: borderColor});
	        });
	    },

	    /**
	     * Select legend.
	     * @param {?number} legendIndex legend index
	     */
	    selectLegend: function(legendIndex) {
	        var allEmphasized = snippet.isNull(legendIndex);

	        snippet.forEachArray(this.groupBars, function(bars, groupIndex) {
	            var opacity = (allEmphasized || legendIndex === groupIndex) ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;

	            this.groupBars[groupIndex].attr({'fill-opacity': opacity});
	            this.groupLabels[groupIndex].attr({opacity: opacity});
	            snippet.forEachArray(this.groupLabels[groupIndex], function(label) {
	                label.attr({opacity: opacity});
	            });
	        }, this);
	    },

	    /**
	     * @param {object} paper - raphael paper
	     * @param {Array.<object>} positionData - series label positions
	     * @param {Array.<string>} labelData - series labels
	     * @param {object} labelTheme - series text theme
	     * @returns {object} - rendered label set
	     */
	    renderSeriesLabel: function(paper, positionData, labelData, labelTheme) {
	        var attributes = {
	            'font-size': labelTheme.fontSize,
	            'font-family': labelTheme.fontFamily,
	            'font-weight': labelTheme.fontWeight,
	            fill: labelTheme.color,
	            opacity: 0,
	            'text-anchor': this.isVertical ? 'middle' : 'start'
	        };
	        var set = paper.set();

	        this.groupLabels = snippet.map(labelData, function(labels, groupIndex) {
	            var labelSet = paper.set();
	            snippet.forEach(labels, function(label, index) {
	                var labelElement = this._renderLabel(paper, positionData[groupIndex][index], attributes, label);
	                labelSet.push(labelElement);
	                set.push(labelElement);
	            }, this);

	            return labelSet;
	        }, this);

	        return set;
	    },

	    /**
	     * @param {object} paper - raphael paper
	     * @param {Array.<object>} position - series label positions
	     * @param {Array.<string>} attributes - label text attributes
	     * @param {string} labelText - label text
	     * @returns {object} - rendered label object
	     * @private
	     */
	    _renderLabel: function(paper, position, attributes, labelText) {
	        var label = raphaelRenderUtil.renderText(paper, position, labelText, attributes);
	        var node = label.node;
	        var style = node.style;
	        style.userSelect = 'none';
	        style.cursor = 'default';
	        node.setAttribute('filter', 'url(#glow)');

	        return label;
	    },

	    /**
	     * @param {number} index - series index
	     * @returns {Array.<object>} - color and opacity of series
	     */
	    getGraphColors: function() {
	        return snippet.map(this.groupBars, function(barSet, groupIndex) {
	            var barColors = [];
	            var markerCount = this.groupLines[groupIndex].length;
	            var i = 0;
	            var legendColor;

	            barSet.forEach(function(item) {
	                barColors.push(item.attrs.fill);
	            });

	            legendColor = barColors[barColors.length - 1];

	            for (; i <= markerCount; i += 1) {
	                barColors.push(legendColor);
	            }

	            return barColors;
	        }, this);
	    }
	});

	/**
	 * Create clip rect with layout
	 * @param {object} paper Raphael paper
	 * @param {object} position position
	 * @param {object} dimension dimension
	 * @param {string} id ID string
	 * @returns {object}
	 * @ignore
	 */
	function createClipPathRectWithLayout(paper, position, dimension, id) {
	    var clipPath = document.createElementNS('http://www.w3.org/2000/svg', 'clipPath');
	    var rect = paper.rect(position.left, position.top, dimension.width, dimension.height);

	    rect.id = id + '_rect';
	    clipPath.id = id;

	    clipPath.appendChild(rect.node);
	    paper.defs.appendChild(clipPath);

	    return rect;
	}

	module.exports = RaphaelBulletChart;


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raphael line chart renderer.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var RaphaelLineBase = __webpack_require__(15);
	var raphaelRenderUtil = __webpack_require__(5);
	var snippet = __webpack_require__(6);

	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;

	var RaphaelLineChart = snippet.defineClass(RaphaelLineBase, /** @lends RaphaelLineChart.prototype */ {
	    /**
	     * RaphaelLineCharts is graph renderer for line chart.
	     * @constructs RaphaelLineChart
	     * @private
	     * @private
	     * @extends RaphaelLineTypeBase
	     */
	    init: function() {
	        /**
	         * selected legend index
	         * @type {?number}
	         */
	        this.selectedLegendIndex = null;

	        /**
	         * type of chart
	         * @type {string}
	         */
	        this.chartType = 'line';

	        /**
	         * Line width
	         * @type {number}
	         */
	        this.lineWidth = 2;
	    },

	    /**
	     * Render function of line chart.
	     * @param {object} [paper] - raphael paper
	     * @param {{groupPositions: Array.<Array>, dimension: object, theme: object, options: object}} data render data
	     * @returns {object} paper raphael paper
	     */
	    render: function(paper, data) {
	        var dimension = data.dimension;
	        var groupPositions = data.groupPositions;
	        var theme = data.theme;
	        var colors = theme.colors;
	        var options = data.options;
	        var opacity = options.showDot ? 1 : 0;
	        var isSpline = options.spline;
	        var lineWidth = this.lineWidth = (snippet.isNumber(options.pointWidth) ? options.pointWidth : this.lineWidth);
	        var borderStyle = this.makeBorderStyle(theme.borderColor, opacity);
	        var outDotStyle = this.makeOutDotStyle(opacity, borderStyle);
	        var groupPaths;

	        if (isSpline) {
	            groupPaths = this._getSplineLinesPath(groupPositions, options.connectNulls);
	        } else {
	            groupPaths = this._getLinesPath(groupPositions, options.connectNulls);
	        }

	        this.paper = paper;
	        this.theme = data.theme;
	        this.isSpline = isSpline;
	        this.dimension = dimension;
	        this.position = data.position;

	        paper.setStart();

	        this.groupLines = this._renderLines(paper, groupPaths, colors, lineWidth);
	        this.tooltipLine = this._renderTooltipLine(paper, dimension.height);
	        this.groupDots = this._renderDots(paper, groupPositions, colors, opacity);

	        if (options.allowSelect) {
	            this.selectionDot = this._makeSelectionDot(paper);
	            this.selectionColor = theme.selectionColor;
	        }
	        this.colors = colors;
	        this.borderStyle = borderStyle;
	        this.outDotStyle = outDotStyle;
	        this.groupPositions = groupPositions;
	        this.groupPaths = groupPaths;
	        this.dotOpacity = opacity;
	        delete this.pivotGroupDots;

	        return paper.setFinish();
	    },

	    /**
	     * Get lines path.
	     * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	     * @param {boolean} [connectNulls] - boolean value connect nulls or not
	     * @returns {Array.<Array.<string>>} path
	     * @private
	     */
	    _getLinesPath: function(groupPositions, connectNulls) {
	        var self = this;

	        return snippet.map(groupPositions, function(positions) {
	            return self._makeLinesPath(positions, null, connectNulls);
	        });
	    },

	    /**
	     * Get spline lines path.
	     * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	     * @param {boolean} [connectNulls] - boolean value connect nulls or not
	     * @returns {Array} path
	     * @private
	     */
	    _getSplineLinesPath: function(groupPositions, connectNulls) {
	        var self = this;

	        return snippet.map(groupPositions, function(positions) {
	            return self._makeSplineLinesPath(positions, connectNulls);
	        });
	    },

	    /**
	     * Render lines.
	     * @param {object} paper raphael paper
	     * @param {Array.<Array.<string>>} groupPaths paths
	     * @param {string[]} colors line colors
	     * @param {?number} strokeWidth stroke width
	     * @returns {Array.<Array.<object>>} lines
	     * @private
	     */
	    _renderLines: function(paper, groupPaths, colors, strokeWidth) {
	        return snippet.map(groupPaths, function(path, groupIndex) {
	            var color = colors[groupIndex] || 'transparent';

	            return raphaelRenderUtil.renderLine(paper, path.join(' '), color, strokeWidth);
	        });
	    },

	    /**
	     * Resize graph of line chart.
	     * @param {object} params parameters
	     *      @param {{width: number, height:number}} params.dimension dimension
	     *      @param {Array.<Array.<{left:number, top:number}>>} params.groupPositions group positions
	     */
	    resize: function(params) {
	        var self = this,
	            dimension = params.dimension,
	            groupPositions = params.groupPositions;

	        this.resizeClipRect(dimension.width, dimension.height);

	        this.groupPositions = groupPositions;
	        this.groupPaths = this.isSpline ? this._getSplineLinesPath(groupPositions) : this._getLinesPath(groupPositions);
	        this.paper.setSize(dimension.width, dimension.height);
	        this.tooltipLine.attr({top: dimension.height});

	        snippet.forEachArray(this.groupPaths, function(path, groupIndex) {
	            self.groupLines[groupIndex].attr({path: path.join(' ')});

	            snippet.forEachArray(self.groupDots[groupIndex], function(item, index) {
	                if (item.endDot) {
	                    self.moveDot(item.endDot.dot, groupPositions[groupIndex][index]);
	                }
	            });
	        });
	    },

	    /**
	     * Select legend.
	     * @param {?number} legendIndex legend index
	     */
	    selectLegend: function(legendIndex) {
	        var noneSelected = snippet.isNull(legendIndex);

	        if (this.selectedLegendIndex && this.selectedLegendIndex !== -1) {
	            this.resetSeriesOrder(this.selectedLegendIndex);
	        }

	        this.selectedLegendIndex = legendIndex;

	        snippet.forEachArray(this.groupLines, function(line, groupIndex) {
	            var isSelectedLegend = legendIndex === groupIndex;
	            var opacity = (noneSelected || isSelectedLegend) ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	            var groupDots = this.groupDots[groupIndex];

	            line.attr({'stroke-opacity': opacity});

	            snippet.forEachArray(groupDots, function(item) {
	                item.opacity = opacity;

	                if (this.dotOpacity) {
	                    item.endDot.dot.attr({'fill-opacity': opacity});
	                }
	            }, this);

	            if (isSelectedLegend) {
	                this.moveSeriesToFront(line, groupDots);
	            }
	        }, this);

	        if (noneSelected) {
	            snippet.forEachArray(this.groupLines, function(line, groupIndex) {
	                this.moveSeriesToFront(line, this.groupDots[groupIndex]);
	            }, this);
	        }
	    },

	    /**
	     * Reset series order after selected to be same to when it is first rendered
	     * @param {number} legendIndex - legend index to reset series order
	     * @ignore
	     */
	    resetSeriesOrder: function(legendIndex) {
	        var frontLine = legendIndex + 1 < this.groupLines.length ? this.groupLines[legendIndex + 1] : null;

	        if (frontLine) {
	            this.groupLines[legendIndex].insertBefore(frontLine);
	            snippet.forEachArray(this.groupDots[legendIndex], function(item) {
	                item.endDot.dot.insertBefore(frontLine);
	            });
	        }
	    },

	    /**
	     * @param {SVGElement} lineType - line or area graph
	     * @param {Array.<SVGElement>} dots - dot type element
	     * @ignore
	     * @override
	     */
	    moveSeriesToFront: function(lineType, dots) {
	        lineType.toFront();

	        snippet.forEachArray(dots, function(item) {
	            item.endDot.dot.toFront();
	        });
	    },

	    /**
	     * Animate for adding data.
	     * @param {object} data - data for graph rendering
	     * @param {number} tickSize - tick size
	     * @param {Array.<Array.<object>>} groupPositions - group positions
	     * @param {boolean} [shiftingOption] - shifting option
	     */
	    animateForAddingData: function(data, tickSize, groupPositions, shiftingOption) {
	        var self = this;
	        var isSpline = data.options.spline;
	        var groupPaths = isSpline ? this._getSplineLinesPath(groupPositions) : this._getLinesPath(groupPositions);
	        var additionalIndex = 0;

	        if (!groupPositions.length) {
	            return;
	        }

	        if (shiftingOption) {
	            additionalIndex = 1;
	        }

	        snippet.forEachArray(this.groupLines, function(line, groupIndex) {
	            var dots = self.groupDots[groupIndex];
	            var groupPosition = groupPositions[groupIndex];

	            if (shiftingOption) {
	                self._removeFirstDot(dots);
	            }

	            snippet.forEachArray(dots, function(item, index) {
	                var position = groupPosition[index + additionalIndex];
	                self._animateByPosition(item.endDot.dot, position, tickSize);
	            });

	            self._animateByPath(line, groupPaths[groupIndex], tickSize);
	        });
	    },

	    renderSeriesLabel: function(paper, groupPositions, groupLabels, labelTheme) {
	        var attributes = {
	            'font-size': labelTheme.fontSize,
	            'font-family': labelTheme.fontFamily,
	            'font-weight': labelTheme.fontWeight,
	            fill: labelTheme.color,
	            'text-anchor': 'middle',
	            opacity: 0
	        };
	        var set = paper.set();

	        snippet.forEach(groupLabels, function(categoryLabel, categoryIndex) {
	            snippet.forEach(categoryLabel, function(label, seriesIndex) {
	                var position = groupPositions[categoryIndex][seriesIndex];
	                var endLabel = raphaelRenderUtil.renderText(paper, position.end, label.end, attributes);
	                var startLabel;

	                set.push(endLabel);

	                endLabel.node.style.userSelect = 'none';
	                endLabel.node.style.cursor = 'default';
	                endLabel.node.setAttribute('filter', 'url(#glow)');

	                if (position.start) {
	                    startLabel = raphaelRenderUtil.renderText(paper, position.start, label.start, attributes);

	                    startLabel.node.style.userSelect = 'none';
	                    startLabel.node.style.cursor = 'default';
	                    startLabel.node.setAttribute('filter', 'url(#glow)');

	                    set.push(startLabel);
	                }
	            });
	        });

	        return set;
	    }
	});

	module.exports = RaphaelLineChart;


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview RaphaelLineTypeBase is base class for line type renderer.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var renderUtil = __webpack_require__(7);
	var snippet = __webpack_require__(6);
	var arrayUtil = __webpack_require__(10);

	var browser = snippet.browser;
	var IS_LTE_IE8 = browser.msie && browser.version <= 8;
	var ANIMATION_DURATION = 700;
	var DEFAULT_DOT_RADIUS = 3;
	var SELECTION_DOT_RADIUS = 7;
	var DE_EMPHASIS_OPACITY = 0.3;
	var MOVING_ANIMATION_DURATION = 300;

	var concat = Array.prototype.concat;

	/**
	 * @classdesc RaphaelLineTypeBase is base for line type renderer.
	 * @class RaphaelLineTypeBase
	 * @private
	 */
	var RaphaelLineTypeBase = snippet.defineClass(/** @lends RaphaelLineTypeBase.prototype */ {
	    /**
	     * Make lines path.
	     * @param {Array.<{left: number, top: number, startTop: number}>} positions positions
	     * @param {?string} [posTopType='top'] position top type
	     * @param {boolean} [connectNulls] - boolean value connect nulls or not
	     * @returns {Array.<string | number>} paths
	     * @private
	     */
	    _makeLinesPath: function(positions, posTopType, connectNulls) {
	        var path = [];
	        var prevMissing = false;

	        posTopType = posTopType || 'top';
	        snippet.map(positions, function(position) {
	            var pathCommand = (prevMissing && !connectNulls) ? 'M' : 'L';

	            if (position) {
	                path.push([pathCommand, position.left, position[posTopType]]);
	                if (prevMissing) {
	                    prevMissing = false;
	                }
	            } else {
	                prevMissing = true;
	            }
	        });

	        path = concat.apply([], path);

	        if (path.length > 0) {
	            path[0] = 'M';
	        }

	        return path;
	    },

	    /**
	     * Get anchor. (http://raphaeljs.com/analytics.js)
	     * @param {{left: number, top: number}} fromPos from position
	     * @param {{left: number, top: number}} pos position
	     * @param {{left: number, top: number}} nextPos next position
	     * @returns {{x1: number, y1: number, x2: number, y2: number}} anchor
	     * @private
	     */
	    _getAnchor: function(fromPos, pos, nextPos) {
	        var l1 = (pos.left - fromPos.left) / 2,
	            l2 = (nextPos.left - pos.left) / 2,
	            a = Math.atan((pos.left - fromPos.left) / Math.abs(pos.top - fromPos.top)),
	            b = Math.atan((nextPos.left - pos.left) / Math.abs(pos.top - nextPos.top)),
	            alpha, dx1, dy1, dx2, dy2;

	        a = fromPos.top < pos.top ? Math.PI - a : a;
	        b = nextPos.top < pos.top ? Math.PI - b : b;
	        alpha = (Math.PI / 2) - (((a + b) % (Math.PI * 2)) / 2);
	        dx1 = l1 * Math.sin(alpha + a);
	        dy1 = l1 * Math.cos(alpha + a);
	        dx2 = l2 * Math.sin(alpha + b);
	        dy2 = l2 * Math.cos(alpha + b);

	        return {
	            x1: pos.left - dx1,
	            y1: pos.top + dy1,
	            x2: pos.left + dx2,
	            y2: pos.top + dy2
	        };
	    },

	    /**
	     * Get spline positions groups which is divided with null data value.
	     * If series has not divided positions, it returns only one positions group.
	     * @param {Array.<object>} positions positions array
	     * @param {boolean} connectNulls option of connect line of both null data's side
	     * @returns {Array.<Array.<object>>}
	     * @private
	     */
	    _getSplinePositionsGroups: function(positions, connectNulls) {
	        var positionsGroups = [];
	        var positionsGroup = [];
	        snippet.forEach(positions, function(position, index) {
	            var isLastIndex = index === positions.length - 1;

	            if (position) {
	                positionsGroup.push(position);
	            }

	            if ((!position && positionsGroup.length > 0 && !connectNulls) || isLastIndex) {
	                positionsGroups.push(positionsGroup);
	                positionsGroup = [];
	            }
	        });

	        return positionsGroups;
	    },

	    /**
	     * Get spline partial paths
	     * @param {Array.<Array.<object>>} positionsGroups positions groups
	     * @returns {Array.<Array.<Array>>}
	     * @private
	     */
	    _getSplinePartialPaths: function(positionsGroups) {
	        var self = this;
	        var paths = [];
	        var firstPos, lastPos, positionsLen, fromPos, middlePositions, path, prevPos;

	        snippet.forEach(positionsGroups, function(dataPositions) {
	            prevPos = firstPos = dataPositions[0];
	            positionsLen = dataPositions.length;
	            fromPos = firstPos;
	            lastPos = dataPositions[positionsLen - 1];
	            middlePositions = dataPositions.slice(1).slice(0, positionsLen - 2);

	            path = snippet.map(middlePositions, function(position, index) {
	                var nextPos = dataPositions[index + 2];
	                var anchor = self._getAnchor(fromPos, position, nextPos);

	                fromPos = position;

	                if (Math.abs(anchor.y1 - prevPos.top) > Math.abs(prevPos.top - position.top)) {
	                    anchor.y1 = position.top;
	                }

	                if (Math.abs(anchor.y2 - nextPos.top) > Math.abs(nextPos.top - position.top)) {
	                    anchor.y2 = position.top;
	                }

	                prevPos = position;

	                return [anchor.x1, anchor.y1, position.left, position.top, anchor.x2, anchor.y2];
	            });

	            path.push([lastPos.left, lastPos.top, lastPos.left, lastPos.top]);
	            path.unshift(['M', firstPos.left, firstPos.top, 'C', firstPos.left, firstPos.top]);
	            paths.push(path);
	        });

	        return paths;
	    },

	    /**
	     * Make spline lines path.
	     * @param {Array.<{left: number, top: number, startTop: number}>} positions positions
	     * @param {boolean} [connectNulls] - boolean value connect nulls or not
	     * @returns {Array.<string | number>} paths
	     * @private
	     */
	    _makeSplineLinesPath: function(positions, connectNulls) {
	        var path = [];
	        var positionsGroups = this._getSplinePositionsGroups(positions, connectNulls);
	        var partialPaths = this._getSplinePartialPaths(positionsGroups);

	        snippet.forEach(partialPaths, function(partialPath) {
	            path = path.concat(partialPath);
	        });

	        return path;
	    },

	    /**
	     * Render tooltip line.
	     * @param {object} paper raphael paper
	     * @param {number} height height
	     * @returns {object} raphael object
	     * @private
	     */
	    _renderTooltipLine: function(paper, height) {
	        var linePath = raphaelRenderUtil.makeLinePath({
	            left: 10,
	            top: height
	        }, {
	            left: 10,
	            top: 0
	        });

	        return raphaelRenderUtil.renderLine(paper, linePath, 'transparent', 1);
	    },

	    /**
	     * Make border style.
	     * @param {string} borderColor border color
	     * @param {number} opacity opacity
	     * @returns {{stroke: string, stroke-width: number, strike-opacity: number}} border style
	     */
	    makeBorderStyle: function(borderColor, opacity) {
	        var borderStyle;

	        if (borderColor) {
	            borderStyle = {
	                stroke: borderColor,
	                'stroke-width': 1,
	                'stroke-opacity': opacity
	            };
	        }

	        return borderStyle;
	    },

	    /**
	     * Make dot style for mouseout event.
	     * @param {number} opacity opacity
	     * @param {object} borderStyle border style
	     * @returns {{fill-opacity: number, stroke-opacity: number, r: number}} style
	     */
	    makeOutDotStyle: function(opacity, borderStyle) {
	        var outDotStyle = {
	            'fill-opacity': opacity,
	            'stroke-opacity': 0,
	            r: DEFAULT_DOT_RADIUS
	        };

	        if (borderStyle) {
	            snippet.extend(outDotStyle, borderStyle);
	        }

	        return outDotStyle;
	    },

	    /**
	     * Render dot.
	     * @param {object} paper raphael papaer
	     * @param {{left: number, top: number}} position dot position
	     * @param {string} color dot color
	     * @param {number} opacity opacity
	     * @returns {object} raphael dot
	     */
	    renderDot: function(paper, position, color, opacity) {
	        var dotTheme = (this.theme && this.theme.dot) || {dot: {}};
	        var dot, dotStyle, raphaelDot;

	        if (position) {
	            dot = paper.circle(position.left, position.top, dotTheme.radius || DEFAULT_DOT_RADIUS);
	            dotStyle = {
	                fill: dotTheme.fillColor || color,
	                'fill-opacity': snippet.isNumber(opacity) ? opacity : dotTheme.fillOpacity,
	                stroke: dotTheme.strokeColor || color,
	                'stroke-opacity': snippet.isNumber(opacity) ? opacity : dotTheme.strokeOpacity,
	                'stroke-width': dotTheme.strokeWidth
	            };

	            dot.attr(dotStyle);

	            raphaelDot = {
	                dot: dot,
	                color: color
	            };
	        }

	        return raphaelDot;
	    },

	    /**
	     * Move dots to front.
	     * @param {Array.<{startDot: {dot: object}, endDot: {dot: object}}>} dots - dots
	     * @private
	     */
	    _moveDotsToFront: function(dots) {
	        raphaelRenderUtil.forEach2dArray(dots, function(dotInfo) {
	            dotInfo.endDot.dot.toFront();
	            if (dotInfo.startDot) {
	                dotInfo.startDot.dot.toFront();
	            }
	        });
	    },

	    /**
	     * Render dots.
	     * @param {object} paper raphael paper
	     * @param {Array.<Array.<object>>} groupPositions positions
	     * @param {string[]} colors colors
	     * @param {number} opacity opacity
	     * @param {Array.<object>} [seriesSet] series set
	     * @returns {Array.<object>} dots
	     * @private
	     */
	    _renderDots: function(paper, groupPositions, colors, opacity, seriesSet) {
	        var self = this;
	        var dots;

	        dots = snippet.map(groupPositions, function(positions, groupIndex) {
	            var color = colors[groupIndex];

	            return snippet.map(positions, function(position) {
	                var dotMap = {
	                    endDot: self.renderDot(paper, position, color, opacity)
	                };
	                var startPosition;

	                if (self.hasRangeData) {
	                    startPosition = snippet.extend({}, position);
	                    startPosition.top = startPosition.startTop;
	                    dotMap.startDot = self.renderDot(paper, startPosition, color, opacity);
	                }

	                if (seriesSet) {
	                    seriesSet.push(dotMap.endDot.dot);
	                    if (dotMap.startDot) {
	                        seriesSet.push(dotMap.startDot.dot);
	                    }
	                }

	                return dotMap;
	            });
	        });

	        return dots;
	    },

	    /**
	     * Get center position
	     * @param {{left: number, top: number}} fromPos from position
	     * @param {{left: number, top: number}} toPos to position
	     * @returns {{left: number, top: number}} position
	     * @private
	     */
	    _getCenter: function(fromPos, toPos) {
	        return {
	            left: (fromPos.left + toPos.left) / 2,
	            top: (fromPos.top + toPos.top) / 2
	        };
	    },

	    /**
	     * Show dot.
	     * @param {object} dotInformation raphael object
	     * @param {number} groupIndex seriesIndex
	     * @private
	     */
	    _showDot: function(dotInformation, groupIndex) {
	        var hoverTheme = this.theme.dot.hover;
	        var attributes = {
	            'fill-opacity': hoverTheme.fillOpacity,
	            stroke: hoverTheme.strokeColor || dotInformation.color,
	            'stroke-opacity': hoverTheme.strokeOpacity,
	            'stroke-width': hoverTheme.strokeWidth,
	            r: hoverTheme.radius
	        };

	        this._setPrevDotAttributes(groupIndex, dotInformation.dot);

	        if (hoverTheme.fillColor) {
	            attributes.fill = hoverTheme.fillColor;
	        }

	        dotInformation.dot.attr(attributes);
	    },

	    /**
	     * temp save dot style attribute
	     * @param {number} groupIndex seriesIndex
	     * @param {object} dot raphael circle object
	     * @private
	     */
	    _setPrevDotAttributes: function(groupIndex, dot) {
	        if (!this._prevDotAttributes) {
	            this._prevDotAttributes = {};
	        }
	        this._prevDotAttributes[groupIndex] = dot.attr();
	    },

	    /**
	     * Update line stroke width.
	     * @param {object} line raphael object
	     * @param {number} strokeWidth stroke width
	     * @private
	     */
	    _updateLineStrokeWidth: function(line, strokeWidth) {
	        line.attr({
	            'stroke-width': strokeWidth
	        });
	    },

	    /**
	     * Show animation.
	     * @param {{groupIndex: number, index:number}} data show info
	     */
	    showAnimation: function(data) {
	        var index = data.groupIndex; // Line chart has pivot values.
	        var groupIndex = data.index;
	        var line = this.groupLines ? this.groupLines[groupIndex] : this.groupAreas[groupIndex];
	        var item = this.groupDots[groupIndex][index];
	        var strokeWidth, startLine;

	        if (!item) {
	            return;
	        }

	        if (this.chartType === 'area') {
	            strokeWidth = this.lineWidth * 2;
	            startLine = line.startLine;
	            line = line.line;
	        } else {
	            strokeWidth = this.lineWidth * 2;
	        }

	        this._updateLineStrokeWidth(line, strokeWidth);

	        if (startLine) {
	            this._updateLineStrokeWidth(startLine, strokeWidth);
	        }
	        this._showDot(item.endDot, groupIndex);

	        if (item.startDot) {
	            this._showDot(item.startDot, groupIndex);
	        }
	    },

	    /**
	     * Get pivot group dots.
	     * @returns {Array.<Array>} dots
	     * @private
	     */
	    _getPivotGroupDots: function() {
	        if (!this.pivotGroupDots && this.groupDots) {
	            this.pivotGroupDots = arrayUtil.pivot(this.groupDots);
	        }

	        return this.pivotGroupDots;
	    },

	    /**
	     * Show group dots.
	     * @param {number} index index
	     * @private
	     */
	    _showGroupDots: function(index) {
	        var self = this;
	        var groupDots = this._getPivotGroupDots();

	        if (!groupDots || !groupDots[index]) {
	            return;
	        }

	        snippet.forEachArray(groupDots[index], function(item, groupIndex) {
	            if (item.endDot) {
	                self._showDot(item.endDot, groupIndex);
	            }

	            if (item.startDot) {
	                self._showDot(item.startDot, groupIndex);
	            }
	        });
	    },

	    /**
	     * Show line for group tooltip.
	     * @param {{
	     *      dimension: {width: number, height: number},
	     *      position: {left: number, top: number}
	     * }} bound bound
	     * @param {object} layout layout
	     */
	    showGroupTooltipLine: function(bound, layout) {
	        var left = Math.max(bound.position.left, 11);
	        var linePath = raphaelRenderUtil.makeLinePath({
	            left: left,
	            top: layout.position.top + bound.dimension.height
	        }, {
	            left: left,
	            top: layout.position.top
	        });

	        if (this.tooltipLine) {
	            this.tooltipLine.attr({
	                path: linePath,
	                stroke: '#999',
	                'stroke-opacity': 1
	            });
	        }
	    },

	    /**
	     * Show group animation.
	     * @param {number} index index
	     */
	    showGroupAnimation: function(index) {
	        this._showGroupDots(index);
	    },

	    /**
	     * Hide dot.
	     * @param {object} dot raphael object
	     * @param {number} groupIndex seriesIndex
	     * @param {?number} opacity opacity
	     * @private
	     */
	    _hideDot: function(dot, groupIndex, opacity) {
	        var prev = this._prevDotAttributes[groupIndex];
	        var outDotStyle = this.outDotStyle;

	        // if prev data exists, use prev.r
	        // there is dot disappearing issue, when hideDot
	        if (prev && !snippet.isUndefined(opacity)) {
	            outDotStyle = snippet.extend({
	                'r': prev.r,
	                'stroke': prev.stroke,
	                'fill': prev.fill,
	                'stroke-opacity': prev['stroke-opacity'],
	                'stroke-width': prev['stroke-width']
	            }, {
	                'fill-opacity': opacity
	            });
	        }

	        dot.attr(outDotStyle);
	    },

	    /**
	     * Hide animation.
	     * @param {{groupIndex: number, index:number}} data hide info
	     */
	    hideAnimation: function(data) {
	        var index = data.groupIndex; // Line chart has pivot values.
	        var groupIndex = data.index;
	        var opacity = this.dotOpacity;
	        var groupDot = this.groupDots[groupIndex];
	        var line, item, strokeWidth, startLine;

	        if (!groupDot || !groupDot[index]) {
	            return;
	        }

	        line = this.groupLines ? this.groupLines[groupIndex] : this.groupAreas[groupIndex];
	        item = groupDot[index];

	        if (this.chartType === 'area') {
	            strokeWidth = this.lineWidth;
	            startLine = line.startLine;
	            line = line.line;
	        } else {
	            strokeWidth = this.lineWidth;
	        }

	        if (opacity && !snippet.isNull(this.selectedLegendIndex) && this.selectedLegendIndex !== groupIndex) {
	            opacity = DE_EMPHASIS_OPACITY;
	        }

	        if (line) {
	            this._updateLineStrokeWidth(line, strokeWidth);
	        }

	        if (startLine) {
	            this._updateLineStrokeWidth(startLine, strokeWidth);
	        }

	        if (item) {
	            this._hideDot(item.endDot.dot, groupIndex, opacity);

	            if (item.startDot) {
	                this._hideDot(item.startDot.dot, groupIndex, opacity);
	            }
	        }
	    },

	    /**
	     * Hide group dots.
	     * @param {number} index index
	     * @private
	     */
	    _hideGroupDots: function(index) {
	        var self = this;
	        var hasSelectedIndex = !snippet.isNull(this.selectedLegendIndex);
	        var baseOpacity = this.dotOpacity;
	        var groupDots = this._getPivotGroupDots();

	        if (!groupDots || !groupDots[index]) {
	            return;
	        }

	        snippet.forEachArray(groupDots[index], function(item, groupIndex) {
	            var opacity = baseOpacity;

	            if (opacity && hasSelectedIndex && self.selectedLegendIndex !== groupIndex) {
	                opacity = DE_EMPHASIS_OPACITY;
	            }

	            if (item.endDot) {
	                self._hideDot(item.endDot.dot, groupIndex, opacity);
	            }

	            if (item.startDot) {
	                self._hideDot(item.startDot.dot, groupIndex, opacity);
	            }
	        });
	    },

	    /**
	     * Hide line for group tooltip.
	     */
	    hideGroupTooltipLine: function() {
	        this.tooltipLine.attr({
	            'stroke-opacity': 0
	        });
	    },

	    /**
	     * Hide group animation.
	     * @param {number} index index
	     */
	    hideGroupAnimation: function(index) {
	        this._hideGroupDots(index);
	    },

	    /**
	     * Move dot.
	     * @param {object} dot - raphael object
	     * @param {{left: number, top: number}} position - position
	     * @private
	     */
	    _moveDot: function(dot, position) {
	        var dotAttrs = {
	            cx: position.left,
	            cy: position.top
	        };

	        if (this.dotOpacity) {
	            dotAttrs = snippet.extend({'fill-opacity': this.dotOpacity}, dotAttrs, this.borderStyle);
	        }

	        dot.attr(dotAttrs);
	    },

	    /**
	     * Animate.
	     * @param {function} onFinish callback
	     * @param {Array.<object>} seriesSet series set
	     */
	    animate: function(onFinish, seriesSet) {
	        var paper = this.paper;
	        var dimension = this.dimension;
	        var position = this.position;
	        var clipRect = this.clipRect;
	        var clipRectId = this._getClipRectId();

	        if (!IS_LTE_IE8 && dimension) {
	            if (!clipRect) {
	                clipRect = createClipPathRectWithLayout(paper, position, dimension, clipRectId);
	                this.clipRect = clipRect;
	            } else {
	                clipRect.attr({
	                    width: 0,
	                    height: dimension.height
	                });
	            }

	            seriesSet.forEach(function(seriesElement) {
	                seriesElement.node.setAttribute('clip-path', 'url(#' + clipRectId + ')');
	            });

	            clipRect.animate({
	                width: dimension.width
	            }, ANIMATION_DURATION, '>', onFinish);
	        }
	    },

	    /**
	     * Make selection dot.
	     * @param {object} paper raphael paper
	     * @returns {object} selection dot
	     * @private
	     */
	    _makeSelectionDot: function(paper) {
	        var selectionDot = paper.circle(0, 0, SELECTION_DOT_RADIUS);

	        selectionDot.attr({
	            'fill': '#ffffff',
	            'fill-opacity': 0,
	            'stroke-opacity': 0,
	            'stroke-width': 2
	        });

	        return selectionDot;
	    },

	    /**
	     * Select series.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     */
	    selectSeries: function(indexes) {
	        var item = this.groupDots[indexes.index][indexes.groupIndex],
	            position = this.groupPositions[indexes.index][indexes.groupIndex];

	        this.selectedItem = item;
	        this.selectionDot.attr({
	            cx: position.left,
	            cy: position.top,
	            'fill-opacity': 0.5,
	            'stroke-opacity': 1,
	            stroke: this.selectionColor || item.endDot.color
	        });

	        if (this.selectionStartDot) {
	            this.selectionStartDot.attr({
	                cx: position.left,
	                cy: position.startTop,
	                'fill-opacity': 0.5,
	                'stroke-opacity': 1,
	                stroke: this.selectionColor || item.startDot.color
	            });
	        }
	    },

	    /**
	     * Unselect series.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     */
	    unselectSeries: function(indexes) {
	        var item = this.groupDots[indexes.index][indexes.groupIndex];

	        if (this.selectedItem === item) {
	            this.selectionDot.attr({
	                'fill-opacity': 0,
	                'stroke-opacity': 0
	            });
	        }

	        if (this.selectionStartDot) {
	            this.selectionStartDot.attr({
	                'fill-opacity': 0,
	                'stroke-opacity': 0
	            });
	        }
	    },

	    /**
	     * Set width or height of paper.
	     * @param {number} width - width
	     * @param {number} height - height
	     */
	    setSize: function(width, height) {
	        width = width || this.dimension.width;
	        height = height || this.dimension.height;
	        this.paper.setSize(width, height);
	    },

	    /**
	     * Animate by position.
	     * @param {object} raphaelObj - raphael object
	     * @param {{left: number, top: number}} position - position
	     * @param {number} tickSize tick size
	     * @private
	     */
	    _animateByPosition: function(raphaelObj, position, tickSize) {
	        var attr = {
	            cx: position.left,
	            cy: position.top
	        };

	        if (snippet.isExisty(tickSize)) {
	            attr.transform = 't-' + tickSize + ',0';
	        }

	        raphaelObj.animate(attr, MOVING_ANIMATION_DURATION);
	    },

	    /**
	     * Animate by path.
	     * @param {object} raphaelObj - raphael object
	     * @param {Array.<string | number>} paths - paths
	     * @param {number} tickSize tick size
	     * @private
	     */
	    _animateByPath: function(raphaelObj, paths, tickSize) {
	        var attr = {
	            path: paths.join(' ')
	        };

	        if (snippet.isExisty(tickSize)) {
	            attr.transform = 't-' + tickSize + ',0';
	        }

	        raphaelObj.animate(attr, MOVING_ANIMATION_DURATION);
	    },

	    /**
	     * Remove first dot.
	     * @param {Array.<object>} dots - dots
	     * @private
	     */
	    _removeFirstDot: function(dots) {
	        var firstDot = dots.shift();

	        firstDot.endDot.dot.remove();

	        if (firstDot.startDot) {
	            firstDot.startDot.dot.remove();
	        }
	    },

	    /**
	     * Clear paper.
	     */
	    clear: function() {
	        delete this.paper.dots;
	        this.paper.clear();
	    },

	    /**
	     * Resize clip rect size
	     * @param {number} width series width
	     * @param {number} height series height
	     */
	    resizeClipRect: function(width, height) {
	        var clipRect = this.paper.getById(this._getClipRectId() + '_rect');

	        clipRect.attr({
	            width: width,
	            height: height
	        });
	    },

	    /**
	     * Set clip rect id
	     * @returns {string} id - clip rect id
	     * @private
	     */
	    _getClipRectId: function() {
	        if (!this.clipRectId) {
	            this.clipRectId = renderUtil.generateClipRectId();
	        }

	        return this.clipRectId;
	    },

	    /**
	     * Reset series order after selected to be same to when it is first rendered
	     * @param {number} legendIndex - legend index to reset series order
	     * @ignore
	     * @abstract
	     */
	    resetSeriesOrder: function() {},

	    /**
	     * @param {SVGElement | {area: {SVGElement}, line: {SVGElement}, startLine: {SVGElement}}} lineType - line or area graph
	     * @param {Array.<SVGElement>} dots - dot type element
	     * @abstract
	     */
	    moveSeriesToFront: function() {}
	});

	/**
	 * Create clip rect with layout
	 * @param {object} paper Raphael paper
	 * @param {object} position position
	 * @param {object} dimension dimension
	 * @param {string} id ID string
	 * @returns {object}
	 * @ignore
	 */
	function createClipPathRectWithLayout(paper, position, dimension, id) {
	    var clipPath = document.createElementNS('http://www.w3.org/2000/svg', 'clipPath');
	    var rect = paper.rect((position.left - 10), (position.top - 10), 0, dimension.height);

	    rect.id = id + '_rect';
	    clipPath.id = id;

	    clipPath.appendChild(rect.node);
	    paper.defs.appendChild(clipPath);

	    return rect;
	}

	module.exports = RaphaelLineTypeBase;


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raphael area chart renderer.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var RaphaelLineBase = __webpack_require__(15);
	var raphaelRenderUtil = __webpack_require__(5);
	var snippet = __webpack_require__(6);

	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;

	var concat = Array.prototype.concat;
	var GUIDE_AREACHART_AREAOPACITY_TYPE = __webpack_require__(8).GUIDE_AREACHART_AREAOPACITY_TYPE;
	var consoleUtil = __webpack_require__(17);

	var RaphaelAreaChart = snippet.defineClass(RaphaelLineBase, /** @lends RaphaelAreaChart.prototype */ {
	    /**
	     * RaphaelAreaChart is graph renderer for area chart.
	     * @constructs RaphaelAreaChart
	     * @private
	     * @private
	     * @extends RaphaelLineTypeBase
	     */
	    init: function() {
	        /**
	         * selected legend index
	         * @type {?number}
	         */
	        this.selectedLegendIndex = null;

	        /**
	         * type of chart
	         * @type {string}
	         */
	        this.chartType = 'area';

	        /**
	         * Line width
	         * @type {number}
	         */
	        this.lineWidth = 1;
	    },

	    /**
	     * Render function of area chart.
	     * @param {object} paper - raphael paper
	     * @param {{groupPositions: Array.<Array>, dimension: object, theme: object, options: object}} data render data
	     * @returns {object}
	     */
	    render: function(paper, data) {
	        var dimension = data.dimension;
	        var groupPositions = data.groupPositions;
	        var theme = data.theme;
	        var colors = theme.colors;
	        var options = data.options;
	        var areaOpacity = this._isAreaOpacityNumber(options.areaOpacity) ? options.areaOpacity : 0.5;
	        var dotOpacity = options.showDot ? 1 : 0;
	        var borderStyle = this.makeBorderStyle(theme.borderColor, dotOpacity);
	        var outDotStyle = this.makeOutDotStyle(dotOpacity, borderStyle);
	        var lineWidth = this.lineWidth = (snippet.isNumber(options.pointWidth) ? options.pointWidth : this.lineWidth);

	        this.paper = paper;
	        this.theme = data.theme;
	        this.isSpline = options.spline;
	        this.dimension = dimension;
	        this.position = data.position;

	        this.zeroTop = data.zeroTop;
	        this.hasRangeData = data.hasRangeData;

	        paper.setStart();

	        this.groupPaths = this._getAreaChartPath(groupPositions, null, options.connectNulls);
	        this.groupAreas = this._renderAreas(paper, this.groupPaths, colors, lineWidth, areaOpacity);
	        this.tooltipLine = this._renderTooltipLine(paper, dimension.height);
	        this.groupDots = this._renderDots(paper, groupPositions, colors, dotOpacity);

	        if (options.allowSelect) {
	            this.selectionDot = this._makeSelectionDot(paper);
	            this.selectionColor = theme.selectionColor;

	            if (this.hasRangeData) {
	                this.selectionStartDot = this._makeSelectionDot(paper);
	            }
	        }

	        this.outDotStyle = outDotStyle;
	        this.groupPositions = groupPositions;
	        this.dotOpacity = dotOpacity;

	        this.pivotGroupDots = null;

	        return paper.setFinish();
	    },

	    /**
	     * Get path for area chart.
	     * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions - positions
	     * @param {boolean} [hasExtraPath] - whether has extra path or not
	     * @param {boolean} [connectNulls] - boolean value connect nulls or not
	     * @returns {*}
	     * @private
	     */
	    _getAreaChartPath: function(groupPositions, hasExtraPath, connectNulls) {
	        var path;

	        if (this.isSpline) {
	            path = this._makeSplineAreaChartPath(groupPositions, hasExtraPath);
	        } else {
	            path = this._makeAreaChartPath(groupPositions, hasExtraPath, connectNulls);
	        }

	        return path;
	    },

	    /**
	     * Render area graphs.
	     * @param {object} paper paper
	     * @param {Array.<object>} groupPaths group paths
	     * @param {Array.<string>} colors colors
	     * @param {number} lineWidth line width
	     * @param {number} opacity opacity
	     * @returns {Array} raphael objects
	     * @private
	     */
	    _renderAreas: function(paper, groupPaths, colors, lineWidth, opacity) {
	        var groupAreas;

	        colors = colors.slice(0, groupPaths.length);
	        colors.reverse();
	        groupPaths.reverse();

	        groupAreas = snippet.map(groupPaths, function(path, groupIndex) {
	            var areaColor = colors[groupIndex] || 'transparent',
	                lineColor = areaColor,
	                polygons = {
	                    area: raphaelRenderUtil.renderArea(paper, path.area.join(' '), {
	                        fill: areaColor,
	                        opacity: opacity,
	                        stroke: areaColor
	                    }),
	                    line: raphaelRenderUtil.renderLine(paper, path.line.join(' '), lineColor, lineWidth)
	                };

	            if (path.startLine) {
	                polygons.startLine = raphaelRenderUtil.renderLine(paper, path.startLine.join(' '), lineColor, 1);
	            }

	            return polygons;
	        });

	        return groupAreas.reverse();
	    },

	    /**
	     * Make height.
	     * @param {number} top top
	     * @param {number} startTop start top
	     * @returns {number} height
	     * @private
	     */
	    _makeHeight: function(top, startTop) {
	        return Math.abs(top - startTop);
	    },

	    /**
	     * Make areas path.
	     * @param {Array.<{left: number, top: number, startTop: number}>} positions positions
	     * @param {boolean} [hasExtraPath] - whether has extra path or not
	     * @returns {Array.<string | number>} path
	     * @private
	     */
	    _makeAreasPath: function(positions, hasExtraPath) {
	        var path = [];
	        var paths = [];
	        var prevNull = false;
	        var positionLength = positions.length;
	        var targetIndex;
	        var formerPath = [];
	        var latterPath = [];

	        snippet.forEachArray(positions, function(position, index) {
	            var moveOrLine;
	            if (position) {
	                if (prevNull) {
	                    moveOrLine = 'M';
	                    prevNull = false;
	                } else {
	                    moveOrLine = 'L';
	                }

	                formerPath.push([moveOrLine, position.left, position.top]);
	                latterPath.unshift(['L', position.left, position.startTop]);
	            } else {
	                prevNull = true;
	                latterPath.push(['z']);
	            }

	            if (!position || index === positionLength - 1) {
	                paths.push(formerPath.concat(latterPath));
	                formerPath = [];
	                latterPath = [];
	            }
	        });

	        snippet.forEachArray(paths, function(partialPath) {
	            path = path.concat(partialPath);
	        });

	        if (hasExtraPath !== false) {
	            targetIndex = positions.length - 1;
	            path.splice(targetIndex + 1, 0, path[targetIndex], path[targetIndex + 1]);
	        }

	        path = concat.apply([], path);
	        path[0] = 'M';

	        return path;
	    },

	    /**
	     * Make path for area chart.
	     * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	     * @param {boolean} [hasExtraPath] - whether has extra path or not
	     * @param {boolean} [connectNulls] - boolean value connect nulls or not
	     * @returns {Array.<{area: Array.<string | number>, line: Array.<string | number>}>} path
	     * @private
	     */
	    _makeAreaChartPath: function(groupPositions, hasExtraPath, connectNulls) {
	        var self = this;

	        return snippet.map(groupPositions, function(positions) {
	            var paths;

	            paths = {
	                area: self._makeAreasPath(positions, hasExtraPath),
	                line: self._makeLinesPath(positions, null, connectNulls)
	            };

	            if (self.hasRangeData) {
	                paths.startLine = self._makeLinesPath(positions, 'startTop');
	            }

	            return paths;
	        });
	    },

	    /**
	     * Make spline area bottom path.
	     * @param {Array.<{left: number, top: number}>} positions positions
	     * @returns {Array.<string | number>} spline area path
	     * @private
	     */
	    _makeSplineAreaBottomPath: function(positions) {
	        var self = this;

	        return snippet.map(positions, function(position) {
	            return ['L', position.left, self.zeroTop];
	        }).reverse();
	    },

	    /**
	     * Make spline path for area chart.
	     * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	     * @param {boolean} [hasExtraPath] - whether has extra path or not
	     * @returns {Array.<{area: Array.<string | number>, line: Array.<string | number>}>} path
	     * @private
	     */
	    _makeSplineAreaChartPath: function(groupPositions, hasExtraPath) {
	        var self = this;

	        return snippet.map(groupPositions, function(positions) {
	            var linesPath = self._makeSplineLinesPath(positions);
	            var areaPath = JSON.parse(JSON.stringify(linesPath));
	            var areasBottomPath = self._makeSplineAreaBottomPath(positions);
	            var lastPosition;

	            if (hasExtraPath !== false) {
	                lastPosition = positions[positions.length - 1];
	                areaPath.push(['L', lastPosition.left, lastPosition.top]);
	                areasBottomPath.unshift(['L', lastPosition.left, self.zeroTop]);
	            }

	            return {
	                area: areaPath.concat(areasBottomPath),
	                line: linesPath
	            };
	        });
	    },

	    /**
	     * Resize graph of area chart.
	     * @param {object} params parameters
	     *      @param {{width: number, height:number}} params.dimension dimension
	     *      @param {Array.<Array.<{left:number, top:number}>>} params.groupPositions group positions
	     */
	    resize: function(params) {
	        var self = this,
	            dimension = params.dimension,
	            groupPositions = params.groupPositions;

	        this.resizeClipRect(dimension.width, dimension.height);

	        this.zeroTop = params.zeroTop;
	        this.groupPositions = groupPositions;
	        this.groupPaths = this._getAreaChartPath(groupPositions);
	        this.paper.setSize(dimension.width, dimension.height);
	        this.tooltipLine.attr({top: dimension.height});

	        snippet.forEachArray(this.groupPaths, function(path, groupIndex) {
	            var area = self.groupAreas[groupIndex];
	            area.area.attr({path: path.area.join(' ')});
	            area.line.attr({path: path.line.join(' ')});

	            if (area.startLine) {
	                area.startLine.attr({path: path.startLine.join(' ')});
	            }

	            snippet.forEachArray(self.groupDots[groupIndex], function(item, index) {
	                var position = groupPositions[groupIndex][index];
	                var startPositon;

	                if (item.endDot) {
	                    self._moveDot(item.endDot.dot, position);
	                }
	                if (item.startDot) {
	                    startPositon = snippet.extend({}, position);
	                    startPositon.top = startPositon.startTop;
	                    self._moveDot(item.startDot.dot, startPositon);
	                }
	            });
	        });
	    },

	    /**
	     * Select legend.
	     * @param {?number} legendIndex legend index
	     */
	    selectLegend: function(legendIndex) {
	        var noneSelected = snippet.isNull(legendIndex);

	        if (this.selectedLegendIndex && this.selectedLegendIndex !== -1) {
	            this.resetSeriesOrder(this.selectedLegendIndex);
	        }

	        this.selectedLegendIndex = legendIndex;

	        snippet.forEachArray(this.groupAreas, function(area, groupIndex) {
	            var isSelectedLegend = legendIndex === groupIndex;
	            var opacity = (noneSelected || isSelectedLegend) ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	            var groupDots = this.groupDots[groupIndex];

	            area.area.attr({'fill-opacity': opacity});
	            area.line.attr({'stroke-opacity': opacity});

	            if (area.startLine) {
	                area.startLine.attr({'stroke-opacity': opacity});
	            }

	            snippet.forEachArray(groupDots, function(item) {
	                if (this.dotOpacity) {
	                    item.endDot.dot.attr({'fill-opacity': opacity});
	                    if (item.startDot) {
	                        item.startDot.dot.attr({'fill-opacity': opacity});
	                    }
	                }
	            }, this);

	            if (isSelectedLegend) {
	                this.moveSeriesToFront(area, groupDots);
	            }
	        }, this);
	    },

	    /**
	     * Reset series order after selected to be same to when it is first rendered
	     * @param {number} legendIndex - legend index to reset series order
	     * @ignore
	     */
	    resetSeriesOrder: function(legendIndex) {
	        var frontLine = legendIndex + 1 < this.groupLines.length ? this.groupLines[legendIndex + 1] : null;

	        if (frontLine) {
	            this.groupLines[legendIndex].insertBefore(frontLine);
	            snippet.forEachArray(this.groupDots[legendIndex], function(item) {
	                item.endDot.dot.insertBefore(frontLine);
	            });
	        }
	    },

	    /**
	     * @param {{area: {SVGElement}, line: {SVGElement}, startLine: {SVGElement}}} areaSurface - line or plane to represent area chart
	     * @param {Array.<SVGElement>} dots - dot type element
	     * @ignore
	     * @override
	     */
	    moveSeriesToFront: function(areaSurface, dots) {
	        areaSurface.line.toFront();
	        areaSurface.area.toFront();
	        if (areaSurface.startLine) {
	            areaSurface.startLine.toFront();
	        }

	        snippet.forEachArray(dots, function(item) {
	            item.endDot.dot.toFront();
	            if (item.startDot) {
	                item.startDot.dot.toFront();
	            }
	        });
	    },

	    /**
	     * Animate for adding data.
	     * @param {object} data - data for graph rendering
	     * @param {number} tickSize - tick size
	     * @param {Array.<Array.<object>>} groupPositions - group positions
	     * @param {boolean} [shiftingOption] - shifting option
	     * @param {number} zeroTop - position top value for zero point
	     */
	    animateForAddingData: function(data, tickSize, groupPositions, shiftingOption, zeroTop) {
	        var self = this;
	        var groupPaths = this._getAreaChartPath(groupPositions, false);
	        var additionalIndex = 0;

	        if (!groupPositions.length) {
	            return;
	        }

	        if (shiftingOption) {
	            additionalIndex = 1;
	        }

	        this.zeroTop = zeroTop;

	        snippet.forEachArray(this.groupAreas, function(area, groupIndex) {
	            var dots = self.groupDots[groupIndex];
	            var groupPosition = groupPositions[groupIndex];
	            var pathMap = groupPaths[groupIndex];

	            if (shiftingOption) {
	                self._removeFirstDot(dots);
	            }

	            snippet.forEachArray(dots, function(item, index) {
	                var position = groupPosition[index + additionalIndex];
	                self._animateByPosition(item.endDot.dot, position, tickSize);

	                if (item.startDot) {
	                    self._animateByPosition(item.startDot.dot, {
	                        left: position.left,
	                        top: position.startTop
	                    }, tickSize);
	                }
	            });

	            self._animateByPath(area.area, pathMap.area, tickSize);
	            self._animateByPath(area.line, pathMap.line, tickSize);

	            if (area.startLine) {
	                self._animateByPath(area.startLine, pathMap.startLine, tickSize);
	            }
	        });
	    },

	    renderSeriesLabel: function(paper, groupPositions, groupLabels, labelTheme) {
	        var attributes = {
	            'font-size': labelTheme.fontSize,
	            'font-family': labelTheme.fontFamily,
	            'font-weight': labelTheme.fontWeight,
	            fill: labelTheme.color,
	            'text-anchor': 'middle',
	            opacity: 0
	        };
	        var set = paper.set();

	        snippet.forEach(groupLabels, function(categoryLabel, categoryIndex) {
	            snippet.forEach(categoryLabel, function(label, seriesIndex) {
	                var position = groupPositions[categoryIndex][seriesIndex];
	                var endLabel = raphaelRenderUtil.renderText(paper, position.end, label.end, attributes);
	                var startLabel;

	                set.push(endLabel);

	                endLabel.node.style.userSelect = 'none';
	                endLabel.node.style.cursor = 'default';
	                endLabel.node.setAttribute('filter', 'url(#glow)');

	                if (position.start) {
	                    startLabel = raphaelRenderUtil.renderText(paper, position.start, label.start, attributes);

	                    startLabel.node.style.userSelect = 'none';
	                    startLabel.node.style.cursor = 'default';
	                    startLabel.node.setAttribute('filter', 'url(#glow)');

	                    set.push(startLabel);
	                }
	            });
	        });

	        return set;
	    },

	    /**
	     * Test areaOpacity is a number, and return the result.
	     * It is used to determine whether to set a default value, 0.5.
	     * If it is not a number, areaOpacity will be changed to the default value, 0.5.
	     * @param {*} areaOpacity - value of property `options.areaOpacity`
	     * @returns {boolean} - whether areaOpacity is a number.
	     * @private
	     */
	    _isAreaOpacityNumber: function(areaOpacity) {
	        var isNumber = snippet.isNumber(areaOpacity);

	        if (isNumber) {
	            if (areaOpacity < 0 || areaOpacity > 1) {
	                consoleUtil.print(GUIDE_AREACHART_AREAOPACITY_TYPE, 'warn');
	            }
	        } else if (!snippet.isUndefined(areaOpacity)) {
	            consoleUtil.print(GUIDE_AREACHART_AREAOPACITY_TYPE, 'error');
	        }

	        return isNumber;
	    }
	});

	module.exports = RaphaelAreaChart;


/***/ }),
/* 17 */
/***/ (function(module, exports) {

	/**
	 * @fileoverview util for console
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	module.exports = {
	    /**
	     * check if window.console exists
	     * @param {string} message - message
	     * @param {string} status - print function of window.console
	     */
	    print: function(message, status) {
	        status = status || 'log';

	        if (window.console) {
	            window.console[status](message);
	        }
	    }
	};


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview RaphaelPieCharts is graph renderer for pie chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var snippet = __webpack_require__(6);
	var raphael = __webpack_require__(3);

	var DEGREE_180 = 180;
	var DEGREE_360 = 360;
	var MIN_DEGREE = 0.01;
	var RAD = Math.PI / DEGREE_180;
	var LOADING_ANIMATION_DURATION = 700;
	var EMPHASIS_OPACITY = 1;
	var OVERLAY_OPACITY = 0.3;
	var DE_EMPHASIS_OPACITY = 0.3;
	var DEFAULT_LUMINANT_VALUE = 0.2;
	var OVERLAY_ID = 'overlay';
	var TOOLTIP_OFFSET_VALUE = 20;

	/**
	 * @classdesc RaphaelPieCharts is graph renderer for pie chart.
	 * @class RaphaelPieChart
	 * @private
	 */
	var RaphaelPieChart = snippet.defineClass(/** @lends RaphaelPieChart.prototype */ {
	    /**
	     * Render function of pie chart.
	     * @param {object} paper Raphael paper
	     * @param {{
	     *      sectorData: Array.<object>,
	     *      circleBound: {cx: number, cy: number, r: number},
	     *      dimension: object, theme: object, options: object
	     * }} data render data
	     * @param {object} callbacks callbacks
	     *      @param {function} callbacks.showTooltip show tooltip function
	     *      @param {function} callbacks.hideTooltip hide tooltip function
	     * @returns {object} paper raphael paper
	     */
	    render: function(paper, data, callbacks) {
	        var pieSeriesSet = paper.set();

	        /**
	         * raphael object
	         * @type {object}
	         */
	        this.paper = paper;

	        /**
	         * ratio for hole
	         * @type {number}
	         */
	        this.holeRatio = data.options.radiusRange[0];

	        /**
	         * base background
	         * @type {string}
	         */
	        this.chartBackground = data.chartBackground;

	        /**
	         * type of chart
	         * @type {string}
	         */
	        this.chartType = data.chartType;

	        /**
	         * functions for tooltip control
	         * @type {{showTooltip: Function, hideTooltip: Function}}
	         */
	        this.callbacks = callbacks;

	        /**
	         * color for selection
	         * @type {string}
	         */
	        this.selectionColor = data.theme.selectionColor;

	        /**
	         * bound for circle
	         * @type {{cx: number, cy: number, r: number}}
	         */
	        this.circleBound = data.circleBound;

	        /**
	         * sector attr's name for draw graph
	         * @type {string}
	         */
	        this.sectorName = 'sector_' + this.chartType;

	        this._setSectorAttr();

	        this.sectorInfos = this._renderPie(data.sectorData, data.theme.colors, data.additionalIndex, pieSeriesSet);
	        this.overlay = this._renderOverlay();

	        /**
	         * previous mouse position
	         * @type {{left: number, top: number}}
	         */
	        this.prevPosition = null;

	        /**
	         * previous hover sector
	         * @type {object}
	         */
	        this.prevHoverSector = null;

	        return pieSeriesSet;
	    },

	    /**
	     * Clear paper.
	     */
	    clear: function() {
	        this.legendLines = null;
	        this.paper.clear();
	    },

	    /**
	     * Make sector path.
	     * @param {number} cx center x
	     * @param {number} cy center y
	     * @param {number} r radius
	     * @param {number} startAngle start angle
	     * @param {number} endAngle end angel
	     * @returns {{path: Array}} sector path
	     * @private
	     */
	    _makeSectorPath: function(cx, cy, r, startAngle, endAngle) {
	        var startRadian = startAngle * RAD;
	        var endRadian = endAngle * RAD;
	        var x1 = cx + (r * Math.sin(startRadian)); // x point of start radian
	        var y1 = cy - (r * Math.cos(startRadian)); // y posint of start radian
	        var x2 = cx + (r * Math.sin(endRadian)); // x point of end radian
	        var y2 = cy - (r * Math.cos(endRadian)); // y point of end radian
	        var largeArcFlag = endAngle - startAngle > DEGREE_180 ? 1 : 0;
	        var path = ['M', cx, cy,
	            'L', x1, y1,
	            'A', r, r, 0, largeArcFlag, 1, x2, y2,
	            'Z'];

	        // see details about path
	        // http://www.w3schools.com/svg/svg_path.asp
	        // https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/d
	        return {path: path};
	    },

	    /**
	     * Make sector path for donut chart.
	     * @param {number} cx - center x
	     * @param {number} cy - center y
	     * @param {number} r - radius
	     * @param {number} startAngle - start angle
	     * @param {number} endAngle - end angel
	     * @param {number} [holeRadius] - hole radius
	     * @returns {{path: Array}} sector path
	     * @private
	     */
	    _makeDonutSectorPath: function(cx, cy, r, startAngle, endAngle, holeRadius) {
	        /* eslint max-params: [2, 6]*/
	        var startRadian = startAngle * RAD;
	        var endRadian = endAngle * RAD;
	        var r2 = holeRadius || (r * this.holeRatio); // radius of donut hole
	        var x1 = cx + (r * Math.sin(startRadian));
	        var y1 = cy - (r * Math.cos(startRadian));
	        var x2 = cx + (r2 * Math.sin(startRadian));
	        var y2 = cy - (r2 * Math.cos(startRadian));
	        var x3 = cx + (r * Math.sin(endRadian));
	        var y3 = cy - (r * Math.cos(endRadian));
	        var x4 = cx + (r2 * Math.sin(endRadian));
	        var y4 = cy - (r2 * Math.cos(endRadian));
	        var largeArcFlag = endAngle - startAngle > DEGREE_180 ? 1 : 0;
	        var path = [
	            'M', x1, y1,
	            'A', r, r, 0, largeArcFlag, 1, x3, y3,
	            'L', x4, y4,
	            'A', r2, r2, 0, largeArcFlag, 0, x2, y2,
	            'Z'
	        ];

	        return {path: path};
	    },

	    /**
	     * Set sector attribute for raphael paper.
	     * @private
	     */
	    _setSectorAttr: function() {
	        var makeSectorPath;

	        if (this.paper.customAttributes[this.sectorName]) {
	            return;
	        }

	        if (this.holeRatio) {
	            makeSectorPath = this._makeDonutSectorPath;
	        } else {
	            makeSectorPath = this._makeSectorPath;
	        }

	        this.paper.customAttributes[this.sectorName] = snippet.bind(makeSectorPath, this);
	    },

	    /**
	     * Render overlay.
	     * @returns {object} raphael object
	     * @private
	     */
	    _renderOverlay: function() {
	        var params = {
	            paper: this.paper,
	            circleBound: {
	                cx: 0,
	                cy: 0,
	                r: 0
	            },
	            angles: {
	                startAngle: 0,
	                endAngle: 0
	            },
	            attrs: {
	                fill: 'none',
	                opacity: 0,
	                stroke: this.chartBackground.color,
	                'stroke-width': 1
	            }
	        };
	        var inner = this._renderSector(params);

	        inner.data('id', OVERLAY_ID);
	        inner.data('chartType', this.chartType);

	        return {
	            inner: inner,
	            outer: this._renderSector(params)
	        };
	    },

	    /**
	     * Render sector
	     * @param {object} params parameters
	     *      @param {object} params.paper raphael paper
	     *      @param {{cx: number, cy: number, r:number}} params.circleBound circle bounds
	     *      @param {number} params.startAngle start angle
	     *      @param {number} params.endAngle end angle
	     *      @param {{object}} params.attrs attributes
	     * @returns {object} raphael object
	     * @private
	     */
	    _renderSector: function(params) {
	        var circleBound = params.circleBound;
	        var angles = params.angles;
	        var attrs = params.attrs;

	        attrs[this.sectorName] = [circleBound.cx, circleBound.cy, circleBound.r, angles.startAngle, angles.endAngle];

	        return params.paper.path().attr(attrs);
	    },

	    /**
	     * Render pie graph.
	     * @param {Array.<object>} sectorData - sectorData
	     * @param {Array.<string>} colors - sector colors
	     * @param {number} additionalIndex - additional index for accumulate past pie series's data indexes on pieDonutCombo
	     * @param {Array.<object>} pieSeriesSet - pie series set
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderPie: function(sectorData, colors, additionalIndex, pieSeriesSet) {
	        var self = this;
	        var circleBound = this.circleBound;
	        var chartBackground = this.chartBackground;
	        var sectorInfos = [];

	        snippet.forEachArray(sectorData, function(sectorDatum, index) {
	            var ratio = sectorDatum.ratio;
	            var color = colors[index];
	            var sector = self._renderSector({
	                paper: self.paper,
	                circleBound: circleBound,
	                angles: sectorDatum.angles.start,
	                attrs: {
	                    fill: chartBackground.color,
	                    stroke: chartBackground.color,
	                    'stroke-width': 1
	                }
	            });
	            sector.data('index', index);
	            sector.data('legendIndex', index + additionalIndex);
	            sector.data('chartType', self.chartType);

	            sectorInfos.push({
	                sector: sector,
	                color: color,
	                angles: sectorDatum.angles.end,
	                ratio: ratio
	            });

	            pieSeriesSet.push(sector);
	        });

	        return sectorInfos;
	    },

	    /**
	     * Render legend lines.
	     * @param {Array.<object>} outerPositions outer position
	     */
	    renderLegendLines: function(outerPositions) {
	        var paper = this.paper,
	            paths;

	        if (!this.legendLines) {
	            paths = this._makeLinePaths(outerPositions);
	            this.legendLines = snippet.map(paths, function(path) {
	                return raphaelRenderUtil.renderLine(paper, path, 'transparent', 1);
	            });
	        }
	    },

	    /**
	     * Make line paths.
	     * @param {Array.<object>} outerPositions outer positions
	     * @returns {Array} line paths.
	     * @private
	     */
	    _makeLinePaths: function(outerPositions) {
	        return snippet.map(outerPositions, function(positions) {
	            return [
	                raphaelRenderUtil.makeLinePath(positions.start, positions.middle),
	                raphaelRenderUtil.makeLinePath(positions.middle, positions.end),
	                'Z'
	            ].join('');
	        });
	    },

	    /**
	     * Show overlay.
	     * @param {number} index - index
	     * @param {number} legendIndex - legend index
	     * @private
	     */
	    _showOverlay: function(index, legendIndex) {
	        var overlay = this.overlay;
	        var sectorInfo = this.sectorInfos[index];
	        var sa = sectorInfo.angles.startAngle;
	        var ea = sectorInfo.angles.endAngle;
	        var cb = this.circleBound;
	        var innerAttrs;

	        innerAttrs = {
	            fill: '#fff',
	            opacity: OVERLAY_OPACITY
	        };
	        innerAttrs[this.sectorName] = [cb.cx, cb.cy, cb.r, sa, ea, cb.r * this.holeRatio];
	        overlay.inner.attr(innerAttrs);
	        overlay.inner.data('index', index);
	        overlay.inner.data('legendIndex', legendIndex);
	        overlay.outer.attr({
	            path: this._makeDonutSectorPath(cb.cx, cb.cy, cb.r + 10, sa, ea, cb.r).path,
	            fill: sectorInfo.color,
	            opacity: OVERLAY_OPACITY
	        });
	    },

	    /**
	     * Hide overlay.
	     * @private
	     */
	    _hideOverlay: function() {
	        var overlay = this.overlay;
	        var attrs = {
	            fill: 'none',
	            opacity: 0
	        };

	        overlay.inner.attr(attrs);
	        overlay.outer.attr(attrs);
	    },

	    /**
	     * Animate.
	     * @param {function} callback callback
	     */
	    animate: function(callback) {
	        var delayTime = 0;
	        var sectorName = this.sectorName;
	        var circleBound = this.circleBound;
	        var sectorArgs = [circleBound.cx, circleBound.cy, circleBound.r];

	        snippet.forEachArray(this.sectorInfos, function(sectorInfo) {
	            var angles = sectorInfo.angles;
	            var attrMap = {
	                fill: sectorInfo.color
	            };
	            var animationTime = LOADING_ANIMATION_DURATION * sectorInfo.ratio;
	            var anim;

	            if ((angles.startAngle === 0) && (angles.endAngle === DEGREE_360)) {
	                angles.endAngle = DEGREE_360 - MIN_DEGREE;
	            }

	            attrMap[sectorName] = sectorArgs.concat([angles.startAngle, angles.endAngle]);
	            anim = raphael.animation(attrMap, animationTime, '>');
	            sectorInfo.sector.animate(anim.delay(delayTime));
	            delayTime += animationTime;
	        });

	        if (callback) {
	            setTimeout(callback, delayTime);
	        }
	    },

	    /**
	     * Animate legend lines.
	     * @param {?number} legendIndex legend index
	     */
	    animateLegendLines: function(legendIndex) {
	        var isNull;

	        if (!this.legendLines) {
	            return;
	        }

	        isNull = snippet.isNull(legendIndex);

	        snippet.forEachArray(this.legendLines, function(line, index) {
	            var opacity = (isNull || legendIndex === index) ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;

	            line.animate({
	                'stroke': 'black',
	                'stroke-opacity': opacity
	            });
	        });
	    },

	    /**
	     * Resize graph of pie chart.
	     * @param {object} params parameters
	     *      @param {{width: number, height:number}} params.dimension dimension
	     *      @param {{cx:number, cy:number, r: number}} params.circleBound circle bound
	     */
	    resize: function(params) {
	        var dimension = params.dimension;
	        var circleBound = params.circleBound;
	        var sectorName = this.sectorName;
	        var labelSet = this.labelSet;

	        this.circleBound = circleBound;
	        this.paper.setSize(dimension.width, dimension.height);

	        snippet.forEachArray(this.sectorInfos, function(sectorInfo, index) {
	            var angles = sectorInfo.angles;
	            var attrs = {};
	            var bBox;

	            attrs[sectorName] = [circleBound.cx, circleBound.cy, circleBound.r, angles.startAngle, angles.endAngle];
	            sectorInfo.sector.attr(attrs);

	            if (labelSet && labelSet.length) {
	                bBox = sectorInfo.sector.getBBox();

	                labelSet[index].attr({
	                    x: bBox.x + (bBox.width / 2),
	                    y: bBox.y + (bBox.height / 2)
	                });
	            }
	        });
	    },

	    /**
	     * Move legend lines.
	     * @param {Array.<object>} outerPositions outer positions
	     */
	    moveLegendLines: function(outerPositions) {
	        var paths;

	        if (!this.legendLines) {
	            return;
	        }

	        paths = this._makeLinePaths(outerPositions);
	        snippet.forEachArray(this.legendLines, function(line, index) {
	            line.attr({path: paths[index]});

	            return line;
	        });
	    },

	    findSectorInfo: function(position) {
	        var sector = this.paper && this.paper.getElementByPoint(position.left, position.top);
	        var info = null;

	        if (sector) {
	            info = {
	                legendIndex: snippet.isExisty(sector.data('legendIndex')) ? sector.data('legendIndex') : -1,
	                index: snippet.isExisty(sector.data('index')) ? sector.data('index') : -1,
	                chartType: sector.data('chartType')
	            };
	        }

	        return info;
	    },

	    /**
	     * Whether changed or not.
	     * @param {{left: number, top: number}} prevPosition previous position
	     * @param {{left: number, top: number}} position position
	     * @returns {boolean} result boolean
	     * @private
	     */
	    _isChangedPosition: function(prevPosition, position) {
	        return !prevPosition || prevPosition.left !== position.left || prevPosition.top !== position.top;
	    },

	    /**
	     * Show tooltip.
	     * @param {object} sector - raphael object
	     * @param {{left: number, top: number}} position - mouse position
	     * @private
	     */
	    _showTooltip: function(sector, position) {
	        var args = [{}, 0, sector.data('index'), {
	            left: position.left - TOOLTIP_OFFSET_VALUE,
	            top: position.top - TOOLTIP_OFFSET_VALUE
	        }];

	        this.callbacks.showTooltip.apply(null, args);
	    },

	    /**
	     * Whether valid sector or not.
	     * @param {object} sector - raphael object
	     * @returns {boolean}
	     * @private
	     */
	    _isValidSector: function(sector) {
	        return sector && sector.data('chartType') === this.chartType;
	    },

	    /**
	     * Move mouse on series.
	     * @param {{left: number, top: number}} position mouse position
	     */
	    moveMouseOnSeries: function(position) {
	        var sector = this.paper && this.paper.getElementByPoint(position.left, position.top);

	        if (this._isValidSector(sector)) {
	            if (this.prevHoverSector !== sector) {
	                this._showOverlay(sector.data('index'), sector.data('legendIndex'));
	                this.prevHoverSector = sector;
	            }

	            if (this._isChangedPosition(this.prevPosition, position)) {
	                this._showTooltip(sector, position);
	            }
	        } else if (this.prevHoverSector) {
	            this._hideOverlay();
	            this.callbacks.hideTooltip();
	            this.prevHoverSector = null;
	        }

	        this.prevPosition = position;
	    },

	    /**
	     * Select series.
	     * @param {{index: number}} indexes - index map
	     */
	    selectSeries: function(indexes) {
	        var sectorInfo = this.sectorInfos[indexes.index];
	        var luminanceColor, objColor, color;

	        if (!sectorInfo) {
	            return;
	        }

	        objColor = raphael.color(sectorInfo.color);
	        luminanceColor = raphaelRenderUtil.makeChangedLuminanceColor(objColor.hex, DEFAULT_LUMINANT_VALUE);

	        color = this.selectionColor || luminanceColor;

	        sectorInfo.sector.attr({
	            fill: color
	        });
	    },

	    /**
	     * Unelect series.
	     * @param {{index: number}} indexes - index map
	     */
	    unselectSeries: function(indexes) {
	        var sectorInfo = this.sectorInfos[indexes.index];

	        if (!sectorInfo) {
	            return;
	        }

	        sectorInfo.sector.attr({
	            fill: sectorInfo.color
	        });
	    },

	    /**
	     * Select legend.
	     * @param {?number} legendIndex legend index
	     */
	    selectLegend: function(legendIndex) {
	        var isNull = snippet.isNull(legendIndex);
	        var legendLines = this.legendLines;

	        snippet.forEachArray(this.sectorInfos, function(sectorInfo, index) {
	            var opacity = (isNull || legendIndex === index) ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;

	            sectorInfo.sector.attr({
	                'fill-opacity': opacity
	            });

	            if (legendLines) {
	                legendLines[index].attr({
	                    'stroke-opacity': opacity
	                });
	            }
	        });
	    },
	    /**
	     * Get rendered label width
	     * @param {string} text - text content
	     * @param {object} theme - label theme
	     * @returns {number}
	     */
	    getRenderedLabelWidth: function(text, theme) {
	        return raphaelRenderUtil.getRenderedTextSize(text, theme.fontSize, theme.fontFamily).width;
	    },

	    /**
	     * Get rendered label height
	     * @param {string} text - text content
	     * @param {object} theme - label theme
	     * @returns {number}
	     */
	    getRenderedLabelHeight: function(text, theme) {
	        return raphaelRenderUtil.getRenderedTextSize(text, theme.fontSize, theme.fontFamily).height;
	    },

	    /**
	     * Render labels and return label set
	     * @param {object} paper Raphael paper
	     * @param {object} positions position left, top
	     * @param {Array.<string>} labels series labels
	     * @param {object} theme label theme
	     * @returns {Array.<object>}
	     */
	    renderLabels: function(paper, positions, labels, theme) {
	        var labelSet = paper.set();
	        var attributes = {
	            'font-size': theme.fontSize,
	            'font-family': theme.fontFamily,
	            'font-weight': theme.fontWeight,
	            'text-anchor': 'middle',
	            fill: theme.color,
	            opacity: 0
	        };

	        snippet.forEach(positions, function(position, index) {
	            var label;

	            if (position) {
	                label = raphaelRenderUtil.renderText(paper, position, labels[index], attributes);

	                label.node.style.userSelect = 'none';
	                label.node.style.cursor = 'default';
	                label.node.setAttribute('filter', 'url(#glow)');
	            }
	            labelSet.push(label);
	        });

	        this.labelSet = labelSet;

	        return labelSet;
	    }
	});

	module.exports = RaphaelPieChart;


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raphael radial line series renderer.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var RaphaelLineTypeBase = __webpack_require__(15);
	var raphaelRenderUtil = __webpack_require__(5);
	var snippet = __webpack_require__(6);

	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;

	var RaphaelRadialLineSeries = snippet.defineClass(RaphaelLineTypeBase, /** @lends RaphaelRadialLineSeries.prototype */{
	    /**
	     * RaphaelLineCharts is graph renderer for line chart.
	     * @constructs RaphaelRadialLineSeries
	     * @extends RaphaelLineTypeBase
	     */
	    init: function() {
	        /**
	         * selected legend index
	         * @type {?number}
	         */
	        this.selectedLegendIndex = null;

	        /**
	         * type of chart
	         * @type {string}
	         */
	        this.chartType = 'radial';

	        /**
	         * Line width
	         * @type {number}
	         */
	        this.lineWidth = 2;
	    },

	    /**
	     * Render function of line chart.
	     * @param {object} paper - raphael paper
	     * @param {{groupPositions: Array.<Array>, dimension: object, theme: object, options: object}} data render data
	     * @returns {object} paper raphael paper
	     */
	    render: function(paper, data) {
	        var dimension = data.dimension;
	        var groupPositions = data.groupPositions;
	        var theme = data.theme;
	        var colors = theme.colors;
	        var dotOpacity = data.options.showDot ? 1 : 0;
	        var isShowArea = data.options.showArea;

	        var groupPaths = this._getLinesPath(groupPositions);
	        var borderStyle = this.makeBorderStyle(theme.borderColor, dotOpacity);
	        var outDotStyle = this.makeOutDotStyle(dotOpacity, borderStyle);
	        var radialSeriesSet = paper.set();
	        var lineWidth = this.lineWidth = (data.options.pointWidth ? data.options.pointWidth : this.lineWidth);

	        this.paper = paper;
	        this.theme = data.theme;
	        this.dimension = dimension;
	        this.position = data.position;

	        if (isShowArea) {
	            this.groupAreas = this._renderArea(paper, groupPaths, colors, radialSeriesSet);
	        }

	        this.groupLines = this._renderLines(paper, groupPaths, colors, lineWidth, radialSeriesSet);
	        this.groupDots = this._renderDots(paper, groupPositions, colors, dotOpacity, radialSeriesSet);

	        if (data.options.allowSelect) {
	            this.selectionDot = this._makeSelectionDot(paper);
	            this.selectionColor = theme.selectionColor;
	        }

	        this.colors = colors;
	        this.borderStyle = borderStyle;
	        this.outDotStyle = outDotStyle;
	        this.groupPositions = groupPositions;
	        this.groupPaths = groupPaths;
	        this.dotOpacity = dotOpacity;

	        return radialSeriesSet;
	    },

	    /**
	     * Get lines path.
	     * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	     * @returns {Array.<Array.<string>>} path
	     * @private
	     */
	    _getLinesPath: function(groupPositions) {
	        var self = this;

	        return snippet.map(groupPositions, function(positions) {
	            return self._makeLinesPath(positions);
	        });
	    },

	    /**
	     * Render lines.
	     * @param {object} paper raphael paper
	     * @param {Array.<Array.<string>>} groupPaths paths
	     * @param {string[]} colors line colors
	     * @param {?number} strokeWidth stroke width
	     * @param {Array.<object>} radialSeriesSet radial line series set
	     * @returns {Array.<Array.<object>>} lines
	     * @private
	     */
	    _renderLines: function(paper, groupPaths, colors, strokeWidth, radialSeriesSet) {
	        return snippet.map(groupPaths, function(path, groupIndex) {
	            var color = colors[groupIndex] || 'transparent';
	            var line = raphaelRenderUtil.renderLine(paper, path.join(' '), color, strokeWidth);

	            radialSeriesSet.push(line);

	            return line;
	        });
	    },

	    /**
	     * Render area.
	     * @param {object} paper raphael paper
	     * @param {Array.<Array.<string>>} groupPaths paths
	     * @param {string[]} colors line colors
	     * @param {Array.<object>} radialSeriesSet radial line series set
	     * @returns {Array.<Array.<object>>} lines
	     * @private
	     */
	    _renderArea: function(paper, groupPaths, colors, radialSeriesSet) {
	        return snippet.map(groupPaths, function(path, groupIndex) {
	            var color = colors[groupIndex] || 'transparent';
	            var area = raphaelRenderUtil.renderArea(paper, path, {
	                fill: color,
	                opacity: 0.4,
	                'stroke-width': 0,
	                stroke: color
	            });

	            radialSeriesSet.push(area);

	            return area;
	        });
	    },

	    /**
	     * Resize graph of line chart.
	     * /todo copied at raphaelLineCharts#resize, should remove duplication
	     * tooltipLine code was deleted, as group tooltip not works on radial chart/
	     * @param {object} params parameters
	     *      @param {{width: number, height:number}} params.dimension dimension
	     *      @param {Array.<Array.<{left:number, top:number}>>} params.groupPositions group positions
	     */
	    resize: function(params) {
	        var self = this,
	            dimension = params.dimension,
	            groupPositions = params.groupPositions;

	        this.groupPositions = groupPositions;
	        this.groupPaths = this._getLinesPath(groupPositions);
	        this.paper.setSize(dimension.width, dimension.height);

	        snippet.forEachArray(this.groupPaths, function(path, groupIndex) {
	            self.groupLines[groupIndex].attr({path: path.join(' ')});
	            self.groupAreas[groupIndex].attr({path: path.join(' ')});

	            snippet.forEachArray(self.groupDots[groupIndex], function(item, index) {
	                self._moveDot(item.endDot.dot, groupPositions[groupIndex][index]);
	            });
	        });
	    },

	    /**
	     * Select legend.
	     * /todo copied at raphaelLineCharts, should remove duplication
	     * @param {?number} legendIndex legend index
	     */
	    selectLegend: function(legendIndex) {
	        var self = this,
	            noneSelected = snippet.isNull(legendIndex);

	        this.selectedLegendIndex = legendIndex;

	        snippet.forEachArray(this.groupLines, function(line, groupIndex) {
	            var opacity = (noneSelected || legendIndex === groupIndex) ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;

	            line.attr({'stroke-opacity': opacity});

	            snippet.forEachArray(self.groupDots[groupIndex], function(item) {
	                item.opacity = opacity;

	                if (self.dotOpacity) {
	                    item.endDot.dot.attr({'fill-opacity': opacity});
	                }
	            });
	        });
	    }
	});

	module.exports = RaphaelRadialLineSeries;


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raphael bubble chart renderer.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var snippet = __webpack_require__(6);
	var raphael = __webpack_require__(3);

	var ANIMATION_DURATION = 700;
	var CIRCLE_OPACITY = 0.5;
	var STROKE_OPACITY = 0.3;
	var EMPHASIS_OPACITY = 0.5;
	var DE_EMPHASIS_OPACITY = 0.3;
	var DEFAULT_LUMINANC = 0.2;
	var OVERLAY_BORDER_WIDTH = 2;
	var TOOLTIP_OFFSET_VALUE = 20;

	/**
	 * bound for circle
	 * @typedef {{left: number, top: number, radius: number}} bound
	 * @private
	 */

	/**
	 * Information for rendered circle
	 * @typedef {{circle: object, color: string, bound: bound}} circleInfo
	 * @private
	 */

	/**
	 * @classdesc RaphaelBubbleChart is graph renderer for bubble chart.
	 * @class RaphaelBubbleChart
	 * @private
	 */
	var RaphaelBubbleChart = snippet.defineClass(/** @lends RaphaelBubbleChart.prototype */ {
	    /**
	     * Render function of bubble chart
	     * @param {object} paper - Raphael paper
	     * @param {{
	     *      dimension: {width: number, height: number},
	     *      seriesDataModel: SeriesDataModel,
	     *      groupBounds: Array.<Array.<bound>>,
	     *      theme: object
	     * }} data - data for rendering
	     * @param {{showTooltip: function, hideTooltip: function}} callbacks - callbacks for toggle of tooltip.
	     * @returns {object}
	     */
	    render: function(paper, data, callbacks) {
	        var circleSet = paper.set();

	        this.paper = paper;

	        /**
	         * theme
	         * @type {object}
	         */
	        this.theme = data.theme;

	        /**
	         * seriesDataModel
	         * @type {SeriesDataModel}
	         */
	        this.seriesDataModel = data.seriesDataModel;

	        /**
	         * group bounds
	         * @type {Array.<Array.<bound>>}
	         */
	        this.groupBounds = data.groupBounds;

	        /**
	         * callbacks for toggle of tooltip.
	         * @type {{showTooltip: Function, hideTooltip: Function}}
	         */
	        this.callbacks = callbacks;

	        /**
	         * overlay is circle object of raphael, that using for mouseover.
	         * @type {object}
	         */
	        this.overlay = this._renderOverlay();

	        /**
	         * two-dimensional array by circleInfo
	         * @type {Array.<Array.<circleInfo>>}
	         */
	        this.groupCircleInfos = this._renderCircles(circleSet);

	        /**
	         * previous selected circle
	         * @type {?object}
	         */
	        this.prevCircle = null;

	        /**
	         * previous over circle
	         * @type {?object}
	         */
	        this.prevOverCircle = null;

	        /**
	         * animation timeout id
	         * @type {?number}
	         */
	        this.animationTimeoutId = null;

	        return circleSet;
	    },

	    /**
	     * Render overlay.
	     * @returns {object}
	     * @private
	     */
	    _renderOverlay: function() {
	        var position = {
	            left: 0,
	            top: 0
	        };
	        var attribute = {
	            fill: 'none',
	            stroke: '#fff',
	            'stroke-opacity': STROKE_OPACITY,
	            'stroke-width': 2
	        };
	        var circle = raphaelRenderUtil.renderCircle(this.paper, position, 0, attribute);

	        return circle;
	    },

	    /**
	     * Render circles.
	     * @param {object} circleSet - circle set
	     * @returns {Array.<Array.<circleInfo>>}
	     * @private
	     */
	    _renderCircles: function(circleSet) {
	        var self = this;
	        var colors = this.theme.colors;

	        return snippet.map(this.groupBounds, function(bounds, groupIndex) {
	            return snippet.map(bounds, function(bound, index) {
	                var circleInfo = null;
	                var color, circle;

	                if (bound) {
	                    color = colors[index];
	                    circle = raphaelRenderUtil.renderCircle(self.paper, bound, 0, {
	                        fill: color,
	                        opacity: 0,
	                        stroke: 'none'
	                    });

	                    circleSet.push(circle);

	                    circle.data('groupIndex', groupIndex);
	                    circle.data('index', index);

	                    circleInfo = {
	                        circle: circle,
	                        color: color,
	                        bound: bound
	                    };
	                }

	                return circleInfo;
	            });
	        });
	    },

	    /**
	     * Animate circle
	     * @param {object} circle - raphael object
	     * @param {number} radius - radius of circle
	     * @private
	     */
	    _animateCircle: function(circle, radius) {
	        circle.animate({
	            r: radius,
	            opacity: CIRCLE_OPACITY
	        }, ANIMATION_DURATION, '>');
	    },

	    /**
	     * Animate.
	     */
	    animate: function() {
	        var self = this;

	        raphaelRenderUtil.forEach2dArray(this.groupCircleInfos, function(circleInfo) {
	            if (!circleInfo) {
	                return;
	            }
	            self._animateCircle(circleInfo.circle, circleInfo.bound.radius);
	        });
	    },

	    /**
	     * Update circle bound
	     * @param {object} circle - raphael object
	     * @param {{left: number, top: number}} bound - bound
	     * @private
	     */
	    _updatePosition: function(circle, bound) {
	        circle.attr({
	            cx: bound.left,
	            cy: bound.top,
	            r: bound.radius
	        });
	    },

	    /**
	     * Resize graph of bubble type chart.
	     * @param {object} params parameters
	     *      @param {{width: number, height:number}} params.dimension - dimension
	     *      @param {Array.<Array.<bound>>} params.groupBounds - group bounds
	     */
	    resize: function(params) {
	        var self = this;
	        var dimension = params.dimension;
	        var groupBounds = params.groupBounds;

	        this.groupBounds = groupBounds;
	        this.paper.setSize(dimension.width, dimension.height);

	        raphaelRenderUtil.forEach2dArray(this.groupCircleInfos, function(circleInfo, groupIndex, index) {
	            var bound = groupBounds[groupIndex][index];
	            if (circleInfo) {
	                circleInfo.bound = bound;
	                self._updatePosition(circleInfo.circle, bound);
	            }
	        });
	    },

	    /**
	     * Find data indexes of rendered circle by position.
	     * @param {{left: number, top: number}} position - mouse position
	     * @returns {{index: number, groupIndex: number}}
	     */
	    findIndexes: function(position) {
	        var circle = this.paper.getElementByPoint(position.left, position.top);
	        var foundIndexes = null;

	        if (circle) {
	            foundIndexes = {
	                index: circle.data('index'),
	                groupIndex: circle.data('groupIndex')
	            };
	        }

	        return foundIndexes;
	    },

	    /**
	     * Whether changed or not.
	     * @param {{left: number, top: number}} prevPosition - previous position
	     * @param {{left: number, top: number}} position - position
	     * @returns {boolean} result boolean
	     * @private
	     */
	    _isChangedPosition: function(prevPosition, position) {
	        return !prevPosition || prevPosition.left !== position.left || prevPosition.top !== position.top;
	    },

	    /**
	     * Show overlay with animation.
	     * @param {object} indexes - indexes
	     *      @param {number} indexes.groupIndex - index of circles group
	     *      @param {number} indexes.index - index of circles
	     */
	    showAnimation: function(indexes) {
	        var circleInfo = this.groupCircleInfos[indexes.groupIndex][indexes.index];
	        var bound = circleInfo.bound;

	        this.overlay.attr({
	            cx: bound.left,
	            cy: bound.top,
	            r: bound.radius + OVERLAY_BORDER_WIDTH,
	            stroke: circleInfo.color,
	            opacity: 1
	        });
	    },

	    /**
	     * Hide overlay with animation.
	     * @private
	     */
	    hideAnimation: function() {
	        this.overlay.attr({
	            cx: 0,
	            cy: 0,
	            r: 0,
	            opacity: 0
	        });
	    },

	    /**
	     * Find circle.
	     * @param {{left: number, top: number}} position - position
	     * @returns {?object}
	     * @private
	     */
	    _findCircle: function(position) {
	        var circles = [];
	        var paper = this.paper;
	        var foundCircle, circle;

	        while (snippet.isUndefined(foundCircle)) {
	            circle = paper.getElementByPoint(position.left, position.top);

	            if (circle) {
	                if (circle.attrs.opacity > DE_EMPHASIS_OPACITY) {
	                    foundCircle = circle;
	                } else {
	                    circles.push(circle);
	                    circle.hide();
	                }
	            } else {
	                foundCircle = null;
	            }
	        }

	        if (!foundCircle) {
	            foundCircle = circles[0];
	        }

	        snippet.forEachArray(circles, function(_circle) {
	            _circle.show();
	        });

	        return foundCircle;
	    },

	    /**
	     * Move mouse on series.
	     * @param {{left: number, top: number}} position - mouse position
	     */
	    moveMouseOnSeries: function(position) {
	        var circle = this._findCircle(position);
	        var groupIndex, index, args;

	        if (circle && snippet.isExisty(circle.data('groupIndex'))) {
	            groupIndex = circle.data('groupIndex');
	            index = circle.data('index');
	            args = [{}, groupIndex, index, {
	                left: position.left - TOOLTIP_OFFSET_VALUE,
	                top: position.top - TOOLTIP_OFFSET_VALUE
	            }];

	            if (this._isChangedPosition(this.prevPosition, position)) {
	                this.callbacks.showTooltip.apply(null, args);
	                this.prevOverCircle = circle;
	            }
	        } else if (this.prevOverCircle) {
	            this.callbacks.hideTooltip();
	            this.prevOverCircle = null;
	        }
	        this.prevPosition = position;
	    },

	    /**
	     * Select series.
	     * @param {{index: number, groupIndex: number}} indexes - index map
	     */
	    selectSeries: function(indexes) {
	        var groupIndex = indexes.groupIndex;
	        var index = indexes.index;
	        var circleInfo = this.groupCircleInfos[groupIndex][index];
	        var objColor = raphael.color(circleInfo.color);
	        var themeColor = this.theme.selectionColor;
	        var color = themeColor || raphaelRenderUtil.makeChangedLuminanceColor(objColor.hex, DEFAULT_LUMINANC);

	        circleInfo.circle.attr({
	            fill: color
	        });
	    },

	    /**
	     * Unselect series.
	     * @param {{index: number, groupIndex: number}} indexes - index map
	     */
	    unselectSeries: function(indexes) {
	        var groupIndex = indexes.groupIndex;
	        var index = indexes.index;
	        var circleInfo = this.groupCircleInfos[groupIndex][index];

	        circleInfo.circle.attr({
	            fill: circleInfo.color
	        });
	    },

	    /**
	     * Select legend.
	     * @param {?number} legendIndex - index of legend
	     */
	    selectLegend: function(legendIndex) {
	        var noneSelected = snippet.isNull(legendIndex);

	        raphaelRenderUtil.forEach2dArray(this.groupCircleInfos, function(circleInfo, groupIndex, index) {
	            var opacity;

	            if (!circleInfo) {
	                return;
	            }

	            opacity = (noneSelected || legendIndex === index) ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;

	            circleInfo.circle.attr({opacity: opacity});
	        });
	    }
	});

	module.exports = RaphaelBubbleChart;


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview RaphaelBoxTypeChart is graph renderer for box type chart(heatmap chart, treemap chart).
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var snippet = __webpack_require__(6);

	var ANIMATION_DURATION = 100;
	var MIN_BORDER_WIDTH = 1;
	var MAX_BORDER_WIDTH = 3;

	/**
	 * @classdesc RaphaelBoxTypeChart is graph renderer for box type chart(heatmap chart, treemap chart).
	 * @class RaphaelBarChart
	 * @private
	 */
	var RaphaelBoxTypeChart = snippet.defineClass(/** @lends RaphaelBoxTypeChart.prototype */ {
	    /**
	     * Render function of bar chart
	     * @param {object} paper Raphael paper
	     * @param {{
	     *      dimension: {width: number, height: number},
	     *      colorSpectrum: object,
	     *      seriesDataModel: SeriesDataModel,
	     *      groupBounds: (Array.<Array.<object>>|object.<string, object>),
	     *      theme: object
	     * }} seriesData - data for graph rendering
	     * @returns {object}
	     */
	    render: function(paper, seriesData) {
	        var seriesSet = paper.set();

	        this.paper = paper;

	        /**
	         * theme
	         * @type {*|{}}
	         */
	        this.theme = seriesData.theme || {};

	        /**
	         * color spectrum
	         * @type {Object}
	         */
	        this.colorSpectrum = seriesData.colorSpectrum;

	        /**
	         *
	         */
	        this.chartBackground = seriesData.chartBackground;

	        /**
	         * zoomable option
	         */
	        this.zoomable = seriesData.zoomable;

	        /**
	         * border color for rendering box
	         * @type {string}
	         */
	        this.borderColor = this.theme.borderColor || 'none';

	        /**
	         * border width for rendering box
	         */
	        this.borderWidth = this.theme.borderWidth;

	        /**
	         * group bounds
	         * @type {Array.<Array.<object>>|object.<string, object>}
	         */
	        this.groupBounds = seriesData.groupBounds;

	        /**
	         * bound map
	         * @type {object.<string, {left: number, top: number, width: number, height: number}>}
	         */
	        this.boundMap = seriesData.boundMap;

	        this._bindGetBoundFunction();
	        this._bindGetColorFunction();

	        /**
	         * boxes set
	         * @type {Array.<Array.<{rect: Object, color: string}>>}
	         */
	        this.boxesSet = this._renderBoxes(seriesData.seriesDataModel, seriesData.startDepth, !!seriesData.isPivot,
	            seriesSet);

	        return seriesSet;
	    },

	    /**
	     * Bind _getBound private function.
	     * @private
	     */
	    _bindGetBoundFunction: function() {
	        if (this.boundMap) {
	            this._getBound = this._getBoundFromBoundMap;
	        } else {
	            this._getBound = this._getBoundFromGroupBounds;
	        }
	    },

	    /**
	     * Bind _bindGetColorFunction private function.
	     * @private
	     */
	    _bindGetColorFunction: function() {
	        if (this.colorSpectrum) {
	            this._getColor = this._getColorFromSpectrum;
	        } else if (this.zoomable) {
	            this._getColor = this._getColorFromColorsWhenZoomable;
	        } else {
	            this._getColor = this._getColorFromColors;
	        }
	    },

	    /**
	     * Get bound from groupBounds by indexes(groupIndex, index) of seriesItem.
	     * @param {SeriesItem} seriesItem - seriesItem
	     * @returns {{width: number, height: number, left: number, top: number}}
	     * @private
	     */
	    _getBoundFromGroupBounds: function(seriesItem) {
	        return this.groupBounds[seriesItem.groupIndex][seriesItem.index].end;
	    },

	    /**
	     * Get bound from boundMap by id of seriesItem.
	     * @param {SeriesItem} seriesItem - seriesItem
	     * @returns {{width: number, height: number, left: number, top: number}}
	     * @private
	     */
	    _getBoundFromBoundMap: function(seriesItem) {
	        return this.boundMap[seriesItem.id];
	    },

	    /**
	     * Get color from colorSpectrum by ratio of seriesItem.
	     * @param {SeriesItem} seriesItem - seriesItem
	     * @returns {string}
	     * @private
	     */
	    _getColorFromSpectrum: function(seriesItem) {
	        var color;

	        if (!seriesItem.hasChild) {
	            color = this.colorSpectrum.getColor(seriesItem.colorRatio || seriesItem.ratio) || this.chartBackground;
	        } else {
	            color = 'none';
	        }

	        return color;
	    },

	    /**
	     * Get color from colors theme by group property of seriesItem.
	     * @param {SeriesItem} seriesItem - seriesItem
	     * @returns {string}
	     * @private
	     */
	    _getColorFromColors: function(seriesItem) {
	        return seriesItem.hasChild ? 'none' : this.theme.colors[seriesItem.group];
	    },

	    /**
	     * Get color from colors theme, when zoomable option.
	     * @param {SeriesItem} seriesItem - seriesItem
	     * @param {number} startDepth - start depth
	     * @returns {string}
	     * @private
	     */
	    _getColorFromColorsWhenZoomable: function(seriesItem, startDepth) {
	        return (seriesItem.depth === startDepth) ? this.theme.colors[seriesItem.group] : 'none';
	    },

	    /**
	     * Render rect.
	     * @param {{width: number, height: number, left: number, top: number}} bound - bound
	     * @param {string} color - color
	     * @param {number} strokeWidth - stroke width
	     * @returns {object}
	     * @private
	     */
	    _renderRect: function(bound, color, strokeWidth) {
	        return raphaelRenderUtil.renderRect(this.paper, bound, {
	            fill: color,
	            stroke: this.borderColor,
	            'stroke-width': strokeWidth
	        });
	    },

	    /**
	     * Get stroke width.
	     * @param {?number} depth - depth
	     * @param {number} startDepth - start depth
	     * @returns {number}
	     * @private
	     */
	    _getStrokeWidth: function(depth, startDepth) {
	        var strokeWidth;

	        if (this.borderWidth) {
	            strokeWidth = this.borderWidth;
	        } else if (snippet.isExisty(depth)) {
	            strokeWidth = Math.max(MIN_BORDER_WIDTH, MAX_BORDER_WIDTH - (depth - startDepth));
	        } else {
	            strokeWidth = MIN_BORDER_WIDTH;
	        }

	        return strokeWidth;
	    },

	    /**
	     * Render boxes.
	     * @param {SeriesDataModel} seriesDataModel - seriesDataModel
	     * @param {number} startDepth - start depth
	     * @param {boolean} isPivot - whether pivot or not
	     * @param {Array.<object>} seriesSet - seriesSet
	     * @returns {Array.<Array.<{rect: object, color: string}>>}
	     * @private
	     */
	    _renderBoxes: function(seriesDataModel, startDepth, isPivot, seriesSet) {
	        var self = this;
	        var rectToBack;

	        if (this.colorSpectrum || !this.zoomable) {
	            rectToBack = function(rect) {
	                rect.toBack();
	            };
	        } else {
	            rectToBack = function() {};
	        }

	        return seriesDataModel.map(function(seriesGroup, groupIndex) {
	            return seriesGroup.map(function(seriesItem, index) {
	                var result = null;
	                var strokeWidth = self._getStrokeWidth(seriesItem.depth, startDepth);
	                var bound, color;

	                seriesItem.groupIndex = groupIndex;
	                seriesItem.index = index;
	                bound = self._getBound(seriesItem);

	                if (bound) {
	                    color = self._getColor(seriesItem, startDepth);
	                    result = {
	                        rect: self._renderRect(bound, color, strokeWidth),
	                        seriesItem: seriesItem,
	                        color: color
	                    };
	                    rectToBack(result.rect);

	                    if (seriesSet) {
	                        seriesSet.push(result.rect);
	                    }
	                }

	                return result;
	            });
	        }, isPivot);
	    },

	    /**
	     * Animate changing color of box.
	     * @param {object} rect - raphael object
	     * @param {string} [color] - fill color
	     * @param {number} [opacity] - fill opacity
	     * @private
	     */
	    _animateChangingColor: function(rect, color, opacity) {
	        var properties = {
	            'fill-opacity': snippet.isExisty(opacity) ? opacity : 1
	        };

	        if (color) {
	            properties.fill = color;
	        }

	        rect.animate(properties, ANIMATION_DURATION, '>');
	    },

	    /**
	     * Show animation.
	     * @param {{groupIndex: number, index:number}} indexes - index info
	     * @param {boolean} [useSpectrum] - whether use spectrum legend or not
	     * @param {number} [opacity] - fill opacity
	     */
	    showAnimation: function(indexes, useSpectrum, opacity) {
	        var box = this.boxesSet[indexes.groupIndex][indexes.index];
	        var color;

	        if (!box) {
	            return;
	        }

	        useSpectrum = snippet.isUndefined(useSpectrum) ? true : useSpectrum;
	        color = useSpectrum ? this.theme.overColor : box.color;

	        if (box.seriesItem.hasChild) {
	            if (useSpectrum) {
	                box.rect.attr({'fill-opacity': 0});
	            }
	            box.rect.toFront();
	        }

	        this._animateChangingColor(box.rect, color, opacity);
	    },

	    /**
	     * Hide animation.
	     * @param {{groupIndex: number, index:number}} indexes - index info
	     * @param {boolean} [useColorValue] - whether use colorValue or not
	     */
	    hideAnimation: function(indexes, useColorValue) {
	        var colorSpectrum = this.colorSpectrum;
	        var box = this.boxesSet[indexes.groupIndex][indexes.index];
	        var opacity = 1;
	        var color, paper;

	        if (!box) {
	            return;
	        }

	        paper = box.rect.paper;

	        if (box.seriesItem.hasChild) {
	            color = null;
	            if (useColorValue) {
	                opacity = 0;
	            }
	        } else {
	            color = box.color;
	        }

	        this._animateChangingColor(box.rect, color, opacity);

	        setTimeout(function() {
	            if (!colorSpectrum && box.seriesItem.hasChild) {
	                box.rect.toBack();
	                paper.pushDownBackgroundToBottom();
	            }
	        }, ANIMATION_DURATION);
	    },

	    /**
	     * Resize.
	     * @param {{
	     *      dimension: {width: number, height: number},
	     *      groupBounds: (Array.<Array.<object>>|object.<string, object>)
	     * }} seriesData - data for graph rendering
	     */
	    resize: function(seriesData) {
	        var self = this;
	        var dimension = seriesData.dimension;

	        this.boundMap = seriesData.boundMap;
	        this.groupBounds = seriesData.groupBounds;
	        this.paper.setSize(dimension.width, dimension.height);

	        raphaelRenderUtil.forEach2dArray(this.boxesSet, function(box, groupIndex, index) {
	            var bound;

	            if (!box) {
	                return;
	            }

	            bound = self._getBound(box.seriesItem, groupIndex, index);

	            if (bound) {
	                raphaelRenderUtil.updateRectBound(box.rect, bound);
	            }
	        });
	    },

	    renderSeriesLabel: function(paper, positionSet, labels, labelTheme) {
	        var labelSet = paper.set();
	        var attributes = {
	            'font-size': labelTheme.fontSize,
	            'font-family': labelTheme.fontFamily,
	            'font-weight': labelTheme.fontWeight,
	            fill: labelTheme.color,
	            opacity: 0
	        };

	        snippet.forEach(labels, function(categoryLabel, categoryIndex) {
	            snippet.forEach(categoryLabel, function(label, seriesIndex) {
	                var seriesLabel = raphaelRenderUtil.renderText(paper, positionSet[categoryIndex][seriesIndex].end,
	                    label, attributes);

	                seriesLabel.node.style.userSelect = 'none';
	                seriesLabel.node.style.cursor = 'default';
	                seriesLabel.node.setAttribute('filter', 'url(#glow)');

	                labelSet.push(seriesLabel);
	            });
	        });

	        return labelSet;
	    },

	    renderSeriesLabelForTreemap: function(paper, positions, labels, labelTheme) {
	        var labelSet = paper.set();
	        var attributes = {
	            'font-size': labelTheme.fontSize,
	            'font-family': labelTheme.fontFamily,
	            'font-weight': labelTheme.fontWeight,
	            fill: labelTheme.color,
	            opacity: 0
	        };

	        snippet.forEach(labels, function(label, index) {
	            var seriesLabel = raphaelRenderUtil.renderText(paper, positions[index], label, attributes);

	            seriesLabel.node.style.userSelect = 'none';
	            seriesLabel.node.style.cursor = 'default';
	            seriesLabel.node.setAttribute('filter', 'url(#glow)');

	            labelSet.push(seriesLabel);
	        });

	        return labelSet;
	    }
	});

	module.exports = RaphaelBoxTypeChart;


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview RaphaelPieCharts is graph renderer for map chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var dom = __webpack_require__(9);
	var snippet = __webpack_require__(6);
	var browser = snippet.browser;

	var IS_LTE_IE8 = browser.msie && browser.version <= 8;
	var STROKE_COLOR = 'gray';
	var ANIMATION_DURATION = 100;
	var G_ID = 'tui-chart-series-group';

	/**
	 * @classdesc RaphaelMapCharts is graph renderer for map chart.
	 * @class RaphaelMapChart
	 * @private
	 */
	var RaphaelMapChart = snippet.defineClass(/** @lends RaphaelMapChart.prototype */ {
	    /**
	     * Render function of map chart.
	     * @param {object} paper paper object
	     * @param {object} data data
	     *      @param {{width: number, height: number}} data.dimension series dimension
	     *      @param {Array.<{code: string, path: string}>} data.map mapData
	     *      @param {ColorSpectrum} data.colorSpectrum color model
	     */
	    render: function(paper, data) {
	        var mapDimension = data.mapModel.getMapDimension();

	        this.ratio = this._getDimensionRatio(data.layout.dimension, mapDimension);
	        this.dimension = data.layout.dimension;
	        this.position = data.layout.position;
	        this.paper = paper;
	        this.sectorSet = paper.set();
	        this.sectors = this._renderMap(data, this.ratio);

	        if (!IS_LTE_IE8) {
	            this.g = createGElement(paper, this.sectorSet, G_ID);
	        }

	        this.overColor = data.theme.overColor;
	    },

	    /**
	     * Get dimension ratio
	     * @param {object} dimension dimension
	     * @param {object} mapDimension map dimension
	     * @returns {number}
	     * @private
	     */
	    _getDimensionRatio: function(dimension, mapDimension) {
	        return Math.min(dimension.height / mapDimension.height, dimension.width / mapDimension.width);
	    },

	    /**
	     * Render map graph.
	     * @param {object} data data
	     *      @param {{width: number, height: number}} data.dimension series dimension
	     *      @param {Array.<{code: string, path: string}>} data.map mapData
	     *      @param {ColorSpectrum} data.colorSpectrum color model
	     * @param {number} dimensionRatio dimension ratio of rendering by map
	     * @returns {Array.<{sector: object, color: string, data: object}>} rendered map information
	     * @private
	     */
	    _renderMap: function(data, dimensionRatio) {
	        var sectorSet = this.sectorSet;
	        var position = data.layout.position;
	        var paper = this.paper;
	        var colorSpectrum = data.colorSpectrum;

	        return snippet.map(data.mapModel.getMapData(), function(datum, index) {
	            var ratio = datum.ratio || 0;
	            var color = colorSpectrum.getColor(ratio);
	            var sector = raphaelRenderUtil.renderArea(paper, datum.path, {
	                fill: color,
	                opacity: 1,
	                stroke: STROKE_COLOR,
	                'stroke-opacity': 1,
	                transform: 's' + dimensionRatio + ',' + dimensionRatio + ',0,0'
	                    + 't' + (position.left / dimensionRatio) + ',' + (position.top / dimensionRatio)
	            });

	            sector.data('index', index);

	            sectorSet.push(sector);

	            return {
	                sector: sector,
	                color: color,
	                ratio: datum.ratio
	            };
	        });
	    },

	    /**
	     * Find sector index.
	     * @param {{left: number, top: number}} position position
	     * @returns {?number} found index
	     */
	    findSectorIndex: function(position) {
	        var sector = this.paper.getElementByPoint(position.left, position.top),
	            foundIndex = sector && sector.data('index'),
	            data = !snippet.isUndefined(foundIndex) && this.sectors[foundIndex];

	        return data && !snippet.isUndefined(data.ratio) ? foundIndex : null;
	    },

	    /**
	     * Change color.
	     * @param {number} index index
	     */
	    changeColor: function(index) {
	        var sector = this.sectors[index];

	        sector.sector.animate({
	            fill: this.overColor
	        }, ANIMATION_DURATION, '>');
	    },

	    /**
	     * Restore color.
	     * @param {number} index index
	     */
	    restoreColor: function(index) {
	        var sector = this.sectors[index];

	        sector.sector.animate({
	            fill: sector.color
	        }, ANIMATION_DURATION, '>');
	    },

	    /**
	     * Scale map sector paths
	     * @param {number} changedRatio changed ratio of map
	     * @param {object} position position
	     * @param {number} mapRatio mapdimension ratio by dimansion
	     * @param {object} limitPosition limit position
	     * @param {object} mapDimension map dimension
	     */
	    scaleMapPaths: function(changedRatio, position, mapRatio, limitPosition, mapDimension) {
	        var transformList = this.g.transform.baseVal;
	        var zoom = this.paper.canvas.createSVGTransform();
	        var matrix = this.paper.canvas.createSVGMatrix();
	        var raphaelMatrix = this.paper.raphael.matrix();
	        var transformMatrix = transformList.numberOfItems ? transformList.getItem(0).matrix : {
	            a: 1,
	            b: 0,
	            c: 0,
	            d: 1,
	            e: 0,
	            f: 0
	        };
	        var maxRight = mapDimension.width - this.dimension.width;
	        var maxTop = mapDimension.height - this.dimension.height;
	        var previousTranslateX = (transformMatrix.e / transformMatrix.a);
	        var previousTranslateY = (transformMatrix.f / transformMatrix.d);
	        var currentLimitRight = -maxRight / transformMatrix.a;
	        var currentLimitTop = -maxTop / transformMatrix.d;
	        var transformX, transformY;

	        raphaelMatrix.scale(changedRatio, changedRatio,
	            (position.left * mapRatio) - (previousTranslateX * changedRatio),
	            (position.top * mapRatio) - (previousTranslateY * changedRatio));
	        transformX = (raphaelMatrix.e / raphaelMatrix.a) + previousTranslateX;
	        transformY = (raphaelMatrix.f / raphaelMatrix.d) + previousTranslateY;

	        if (transformX >= 0) {
	            raphaelMatrix.e = -previousTranslateX * raphaelMatrix.a;
	        } else if (transformX < currentLimitRight) {
	            raphaelMatrix.e = currentLimitRight - previousTranslateX;
	        }

	        if (transformY >= 0) {
	            raphaelMatrix.f = -previousTranslateY * raphaelMatrix.a;
	        } else if (transformY < currentLimitTop) {
	            raphaelMatrix.f = currentLimitTop - previousTranslateY;
	        }

	        matrix.a = raphaelMatrix.a;
	        matrix.b = raphaelMatrix.b;
	        matrix.c = raphaelMatrix.c;
	        matrix.d = raphaelMatrix.d;
	        matrix.e = raphaelMatrix.e;
	        matrix.f = raphaelMatrix.f;

	        zoom.setMatrix(matrix);
	        transformList.appendItem(zoom);
	        transformList.initialize(transformList.consolidate());
	    },

	    /**
	     * Scale map sector paths
	     * @param {object} distances drag distance for moving
	     * @param {object} mapDimension map dimension
	     */
	    moveMapPaths: function(distances, mapDimension) {
	        var matrix = this.paper.canvas.createSVGMatrix();
	        var raphaelMatrix = this.paper.raphael.matrix();
	        var transformList = this.g.transform.baseVal;
	        var translate = this.paper.canvas.createSVGTransform();
	        var maxRight = mapDimension.width - this.dimension.width;
	        var maxTop = mapDimension.height - this.dimension.height;
	        var transformMatrix = transformList.numberOfItems ? transformList.getItem(0).matrix : {
	            a: 1,
	            b: 0,
	            c: 0,
	            d: 1,
	            e: 0,
	            f: 0
	        };
	        var translateX, translateY, currentTranslateX, currentTranslateY;

	        raphaelMatrix.translate(distances.x, distances.y);

	        currentTranslateX = (raphaelMatrix.e / raphaelMatrix.a);
	        currentTranslateY = (raphaelMatrix.f / raphaelMatrix.d);
	        translateX = currentTranslateX + (transformMatrix.e / transformMatrix.a);
	        translateY = currentTranslateY + (transformMatrix.f / transformMatrix.d);

	        if (translateX >= 0 && currentTranslateX > 0) {
	            raphaelMatrix.e = 0;
	        } else if (translateX < 0 && translateX < -maxRight / transformMatrix.a && currentTranslateX < 0) {
	            raphaelMatrix.e = 0;
	        }
	        if (translateY >= 0 && currentTranslateY > 0) {
	            raphaelMatrix.f = 0;
	        } else if (translateY < 0 && translateY < -maxTop / transformMatrix.d && currentTranslateY < 0) {
	            raphaelMatrix.f = 0;
	        }

	        matrix.a = raphaelMatrix.a;
	        matrix.b = raphaelMatrix.b;
	        matrix.c = raphaelMatrix.c;
	        matrix.d = raphaelMatrix.d;
	        matrix.e = raphaelMatrix.e;
	        matrix.f = raphaelMatrix.f;

	        translate.setMatrix(matrix);
	        transformList.appendItem(translate);
	        transformList.initialize(transformList.consolidate());
	    },
	    /**
	     * Render series labels
	     * @param {object} paper Raphael paper
	     * @param {Array.<object>} labelData label data
	     * @param {object} labelTheme label theme
	     * @returns {Array.<object>}
	     */
	    renderSeriesLabels: function(paper, labelData, labelTheme) {
	        var attributes = {
	            'font-size': labelTheme.fontSize,
	            'font-family': labelTheme.fontFamily,
	            'font-weight': labelTheme.fontWeight,
	            fill: labelTheme.color,
	            'text-anchor': 'middle',
	            opacity: 0,
	            transform: 's' + this.ratio + ',' + this.ratio + ',0,0'
	            + 't' + (this.position.left / this.ratio) + ',' + (this.position.top / this.ratio)
	        };
	        var set = paper.set();
	        var self = this;

	        snippet.forEach(labelData, function(labelDatum) {
	            var position = labelDatum.labelPosition;
	            var label = raphaelRenderUtil.renderText(paper, position, labelDatum.name || labelDatum.code, attributes);

	            set.push(label);

	            label.node.style.userSelect = 'none';
	            label.node.style.cursor = 'default';
	            label.node.setAttribute('filter', 'url(#glow)');

	            if (!IS_LTE_IE8) {
	                self.g.appendChild(label.node);
	            }
	        });

	        return set;
	    }
	});

	/**
	 * Create and append sector set
	 * @param {object} paper Raphael paper
	 * @param {Array.<object>} sectorSet sectorSet
	 * @param {string} id ID string
	 * @returns {object}
	 * @ignore
	 */
	function createGElement(paper, sectorSet, id) {
	    var g = document.createElementNS('http://www.w3.org/2000/svg', 'g');
	    g.id = id;

	    sectorSet.forEach(function(sector) {
	        dom.append(g, sector.node);
	    });

	    paper.canvas.appendChild(g);

	    return g;
	}

	module.exports = RaphaelMapChart;


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raphael title renderer.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var raphaelRenderUtil = __webpack_require__(5);
	var arrayUtil = __webpack_require__(10);
	var snippet = __webpack_require__(6);

	var UNSELECTED_LEGEND_LABEL_OPACITY = 0.5;
	var RaphaelLegendComponent;

	/**
	 * Get sum of icon and left padding width
	 * @returns {number} - icon and left padding width
	 * @ignore
	 */
	function getIconWidth() {
	    return chartConst.LEGEND_ICON_WIDTH + chartConst.LEGEND_LABEL_LEFT_PADDING;
	}

	RaphaelLegendComponent = snippet.defineClass(/** @lends RaphaelLegendComponent.prototype */ {

	    init: function() {
	        /**
	         * @type {number}
	         * @private
	         */
	        this._checkBoxWidth = 0;
	        /**
	         * @type {number}
	         * @private
	         */
	        this._checkBoxHeight = 0;
	        /**
	         * @type {number}
	         * @private
	         */
	        this._iconHeight = 0;
	        /**
	         * @type {number}
	         * @private
	         */
	        this._legendItemHeight = 0;
	        /**
	         * @type {number}
	         * @private
	         */
	        this._currentPageCount = 1;
	        /**
	         * @type {boolean}
	         * @private
	         */
	        this._showCheckbox = true;
	    },

	    /**
	     * @param {Array.<object>} legendData Array of legend item data
	     * @private
	     */
	    _renderLegendItems: function(legendData) {
	        var self = this;
	        var labelPaddingLeft = chartConst.LEGEND_LABEL_LEFT_PADDING;
	        var position = snippet.extend({}, this.basePosition);

	        snippet.forEach(legendData, function(legendDatum, index) {
	            var iconType = legendDatum.iconType;
	            var legendIndex = legendDatum.index;
	            var legendColor = legendDatum.colorByPoint ? '#aaa' : legendDatum.theme.color;
	            var isUnselected = legendDatum.isUnselected;
	            var labelHeight = legendDatum.labelHeight;
	            var checkboxData = legendDatum.checkbox;
	            var predicatedLegendWidth = position.left + self._calculateSingleLegendWidth(legendIndex, iconType);
	            var isNeedBreakLine = (predicatedLegendWidth >= self.paper.width);

	            if (self.isHorizontal && isNeedBreakLine) {
	                position.top += (self._legendItemHeight + chartConst.LABEL_PADDING_TOP);
	                position.left = self.basePosition.left;
	            }

	            if (self._showCheckbox) {
	                self._renderCheckbox(position, {
	                    isChecked: checkboxData.checked,
	                    legendIndex: legendIndex,
	                    legendSet: self.legendSet
	                });

	                position.left += (self._checkBoxWidth + labelPaddingLeft);
	            }

	            self._renderIcon(position, {
	                legendColor: legendColor,
	                iconType: iconType,
	                labelHeight: labelHeight,
	                isUnselected: isUnselected,
	                legendIndex: legendIndex,
	                legendSet: self.legendSet
	            });

	            position.left += chartConst.LEGEND_ICON_WIDTH + labelPaddingLeft;

	            self._renderLabel(position, {
	                labelText: legendDatum.label,
	                labelHeight: labelHeight,
	                isUnselected: isUnselected,
	                legendIndex: legendIndex,
	                legendSet: self.legendSet
	            });

	            if (self.isHorizontal) {
	                position.left += self.labelWidths[index] + labelPaddingLeft;
	            } else {
	                position.left = self.basePosition.left;
	                position.top += self._legendItemHeight + chartConst.LINE_MARGIN_TOP;
	            }
	        });
	    },

	    /**
	     * @param {Array.<object>} legendData Array of legend item data
	     * @param {number} sliceIndex slice index of
	     * @returns {Array.<object>}
	     * @private
	     */
	    _getLegendData: function(legendData, sliceIndex) {
	        var positionTop = this.basePosition.top;
	        var totalHeight = this.dimension.height;
	        var chartHeight = this.paper.height;
	        var resultLegendData = legendData;
	        var pageHeight, singleItemHeight, visibleItemCount;

	        if (!this.isHorizontal && totalHeight + (positionTop * 2) > chartHeight) {
	            pageHeight = chartHeight - (positionTop * 2);
	            this._legendItemHeight = Math.max(legendData[0].labelHeight, chartConst.LEGEND_ICON_HEIGHT);
	            singleItemHeight = (this._legendItemHeight + chartConst.LINE_MARGIN_TOP);

	            visibleItemCount = Math.floor(pageHeight / singleItemHeight);

	            resultLegendData = legendData.slice((sliceIndex - 1) * visibleItemCount, sliceIndex * visibleItemCount);
	        }

	        return resultLegendData;
	    },

	    /**
	     * Render legend
	     * @param {object} data rendering data
	     *     @param {HTMLElement} data.container legend container
	     *     @param {Array.<object>} data.legendData rendering legendData
	     *     @param {boolean} data.isHorizontal boolean value of horizontal or not
	     *     @param {{height:number, width:number}} data.dimension legend dimension
	     *     @param {object} data.labelTheme legend label theme object
	     *     @param {number} data.labelWidths label widths
	     *     @param {object} data.eventBus event bus
	     * @returns {object} paper
	     */
	    render: function(data) {
	        var legendData, legendHeight;

	        this.eventBus = data.eventBus;
	        this.paper = data.paper;
	        this.dimension = data.dimension;
	        this.legendSet = this.paper.set();
	        this.labelWidths = data.labelWidths;
	        this.labelTheme = data.labelTheme;
	        this.basePosition = data.position;
	        this.isHorizontal = data.isHorizontal;
	        this.originalLegendData = data.legendData;

	        if (this.originalLegendData.length) {
	            this._showCheckbox = snippet.isExisty(data.legendData[0].checkbox);
	            this._setComponentDimensionsBaseOnLabelHeight(data.legendData[0].labelHeight);

	            legendData = this._getLegendData(data.legendData, this._currentPageCount);

	            this._renderLegendItems(legendData);

	            if (!this.isHorizontal && legendData && legendData.length < data.legendData.length) {
	                legendHeight = this.paper.height - (this.basePosition.top * 2);

	                this.availablePageCount = Math.ceil(data.dimension.height / legendHeight);

	                this._renderPaginationArea(this.basePosition, {
	                    width: data.dimension.width,
	                    height: legendHeight
	                });
	            }
	        }

	        return this.legendSet;
	    },

	    /**
	     * @param {string} direction direction string of paginate 'next' or 'previous'
	     * @private
	     */
	    _paginateLegendAreaTo: function(direction) {
	        var pageNumber = this._currentPageCount;

	        this._removeLegendItems();

	        if (direction === 'next') {
	            pageNumber += 1;
	        } else {
	            pageNumber -= 1;
	        }

	        this._renderLegendItems(this._getLegendData(this.originalLegendData, pageNumber));
	    },

	    _removeLegendItems: function() {
	        this.legendSet.forEach(function(legendItem) {
	            snippet.forEach(legendItem.events, function(event) {
	                event.unbind();
	            });
	            legendItem.remove();
	        });
	    },

	    /**
	     * @param {{top: number, left: number}} position legend area position
	     * @param {{height: number, width: number}} dimension legend area dimension
	     * @private
	     */
	    _renderPaginationArea: function(position, dimension) {
	        var self = this;
	        var BUTTON_WIDTH = chartConst.LEGEND_PAGINATION_BUTTON_WIDTH;
	        var BUTTON_PADDING_LEFT = chartConst.LEGEND_PAGINATION_BUTTON_PADDING_LEFT;
	        var controllerPositionTop = position.top + dimension.height - chartConst.CHART_PADDING;
	        var controllerPositionLeft = position.left - chartConst.CHART_PADDING;
	        var rightButtonPositionLeft = controllerPositionLeft + dimension.width - BUTTON_WIDTH;
	        var leftButtonPositionLeft = rightButtonPositionLeft - (BUTTON_PADDING_LEFT + BUTTON_WIDTH);
	        var lowerArrowPath = ['M', rightButtonPositionLeft, ',', (controllerPositionTop + 3),
	            'L', (rightButtonPositionLeft + 5), ',', (controllerPositionTop + 8),
	            'L', (rightButtonPositionLeft + 10), ',', (controllerPositionTop + 3)].join('');
	        var upperArrowPath = ['M', leftButtonPositionLeft, ',', (controllerPositionTop + 8),
	            'L', (leftButtonPositionLeft + 5), ',', (controllerPositionTop + 3),
	            'L', (leftButtonPositionLeft + 10), ',', (controllerPositionTop + 8)].join('');

	        this.upperButton = raphaelRenderUtil.renderLine(this.paper, upperArrowPath, '#555', 3);
	        this.lowerButton = raphaelRenderUtil.renderLine(this.paper, lowerArrowPath, '#555', 3);

	        this.upperButton.click(function() {
	            if (self._currentPageCount > 1) {
	                self._paginateLegendAreaTo('previous');
	                self._currentPageCount -= 1;
	            }
	        });

	        this.lowerButton.click(function() {
	            if (self._currentPageCount < self.availablePageCount) {
	                self._paginateLegendAreaTo('next');
	                self._currentPageCount += 1;
	            }
	        });
	    },

	    /**
	     * Make labels width.
	     * @param {Array.<{chartType: ?string, label: string}>} legendData legend data
	     * @param {object} theme theme object
	     * @param {number} maxWidth user option legend max width size
	     * @returns {Array.<number>} label widths
	     */
	    makeLabelWidths: function(legendData, theme, maxWidth) {
	        return snippet.map(legendData, function(item) {
	            var labelWidth = raphaelRenderUtil.getRenderedTextSize(item.label, theme.fontSize, theme.fontFamily).width;
	            if (maxWidth && labelWidth > maxWidth) {
	                labelWidth = maxWidth;
	            }

	            return labelWidth + chartConst.LEGEND_LABEL_LEFT_PADDING;
	        });
	    },

	    /**
	     * Get rendered label height
	     * @param {string} labelText label text
	     * @param {object} theme theme object
	     * @returns {number}
	     */
	    getRenderedLabelHeight: function(labelText, theme) {
	        return raphaelRenderUtil.getRenderedTextSize(labelText, theme.fontSize, theme.fontFamily).height;
	    },

	    /**
	     * Render label text and attach event
	     * @param {object} position left, top
	     * @param {object} data rendering data
	     *     @param {string} data.labelText label text
	     *     @param {number} data.labelHeight label height
	     *     @param {boolean} data.isUnselected boolean value for selected or not
	     *     @param {number} data.legendIndex legend index
	     *     @param {Array.<object>} data.legendSet legend set
	     * @private
	     */
	    _renderLabel: function(position, data) {
	        var eventBus = this.eventBus;
	        var labelTheme = this.labelTheme;
	        var pos = {
	            left: position.left,
	            top: position.top + (this._iconHeight / 2)
	        };

	        var attributes = {
	            fill: labelTheme.color,
	            'font-size': labelTheme.fontSize,
	            'font-family': labelTheme.fontFamily,
	            'font-weight': labelTheme.fontWeight,
	            opacity: data.isUnselected ? UNSELECTED_LEGEND_LABEL_OPACITY : 1,
	            'text-anchor': 'start'
	        };
	        var label = raphaelRenderUtil.renderText(this.paper, pos, data.labelText, attributes);

	        label.data('index', data.legendIndex);

	        label.node.style.userSelect = 'none';
	        label.node.style.cursor = 'pointer';

	        data.legendSet.push(label);

	        label.click(function() {
	            eventBus.fire('labelClicked', data.legendIndex);
	        });
	    },

	    /**
	     * Render checkbox
	     * @param {object} position left, top
	     * @param {object} data rendering data
	     */
	    _renderCheckbox: function(position, data) {
	        var self = this;
	        var checkboxSet;
	        var left = position.left;
	        var top = position.top + ((this._legendItemHeight - this._checkBoxHeight) / 2);
	        var vPathString = 'M' + ((this._checkBoxWidth * 0.3) + left) + ',' + ((this._checkBoxHeight * 0.5) + top)
	            + 'L' + ((this._checkBoxWidth * 0.5) + left) + ',' + ((this._checkBoxHeight * 0.7) + top)
	            + 'L' + ((this._checkBoxWidth * 0.8) + left) + ',' + ((this._checkBoxHeight * 0.2) + top);

	        checkboxSet = this.paper.set();

	        checkboxSet.push(this.paper.rect(left, top, this._checkBoxWidth, this._checkBoxHeight, 2).attr({
	            fill: '#fff'
	        }));

	        if (data.isChecked) {
	            checkboxSet.push(this.paper.path(vPathString));
	        }

	        checkboxSet.data('index', data.legendIndex);
	        checkboxSet.click(function() {
	            self.eventBus.fire('checkboxClicked', data.legendIndex);
	        });

	        checkboxSet.forEach(function(checkbox) {
	            data.legendSet.push(checkbox);
	        });
	    },

	    /**
	     * Render legend icon and attach event
	     * @param {object} position left, top
	     * @param {object} data rendering data
	     *     @param {string} data.labelText label text
	     *     @param {number} data.labelHeight label height
	     *     @param {string} data.legendColor legend color hex
	     *     @param {boolean} data.isUnselected boolean value for selected or not
	     *     @param {number} data.legendIndex legend index
	     *     @param {Array.<object>} data.legendSet legend set
	     * @private
	     */
	    _renderIcon: function(position, data) {
	        var self = this;
	        var icon, pathString;

	        this.paper.setStart();

	        if (data.iconType === 'line') {
	            pathString = 'M' + position.left + ',' + (position.top + (this._legendItemHeight / 2))
	                + 'H' + (position.left + chartConst.LEGEND_ICON_WIDTH);

	            icon = raphaelRenderUtil.renderLine(this.paper, pathString, data.legendColor, 3);
	            icon.attr('stroke-opacity', data.isUnselected ? UNSELECTED_LEGEND_LABEL_OPACITY : 1);
	        } else {
	            icon = raphaelRenderUtil.renderRect(this.paper, {
	                left: position.left,
	                top: position.top,
	                width: chartConst.LEGEND_ICON_WIDTH,
	                height: this._iconHeight
	            }, {
	                'stroke-width': 0,
	                fill: data.legendColor,
	                opacity: data.isUnselected ? UNSELECTED_LEGEND_LABEL_OPACITY : 1
	            });
	        }

	        icon.data('icon', data.iconType);
	        icon.data('index', data.legendIndex);
	        icon.click(function() {
	            self.eventBus.fire('labelClicked', data.legendIndex);
	        });

	        data.legendSet.push(icon);
	    },

	    selectLegend: function(index, legendSet) {
	        legendSet.forEach(function(element) {
	            var indexData = element.data('index');
	            var attributeName = element.data('icon') === 'line' ? 'stroke-opacity' : 'opacity';

	            if (snippet.isNull(indexData) || snippet.isUndefined(indexData)) {
	                element.attr(attributeName, 1);
	            } else if (!snippet.isUndefined(indexData)) {
	                if (snippet.isNumber(index) && indexData !== index) {
	                    element.attr(attributeName, UNSELECTED_LEGEND_LABEL_OPACITY);
	                } else {
	                    element.attr(attributeName, 1);
	                }
	            }
	        });
	    },

	    /**
	     * get checkbox area's width depends on checkbox visibility
	     * @returns {number} - checkbox region's width
	     */
	    _getCheckboxWidth: function() {
	        return this._showCheckbox ? (this._checkBoxWidth + chartConst.LEGEND_LABEL_LEFT_PADDING) : 0;
	    },

	    /**
	     * Get width of a label when parameter is given.
	     * Otherwise, returns maximum width of labels
	     * @param {number} [index] - legend index
	     * @returns {number} - maximum label width  label width
	     */
	    _getLabelWidth: function(index) {
	        var labelWidth;
	        if (index) {
	            labelWidth = this.labelWidths[index] || 0;
	        } else {
	            labelWidth = arrayUtil.max(this.labelWidths);
	        }

	        return labelWidth;
	    },

	    /**
	     * calulate a whole legend width before start rendering
	     * @returns {number} - calculate label
	     */
	    _calculateLegendWidth: function() {
	        return this._calculateSingleLegendWidth();
	    },

	    /**
	     * calculate a single legend width of index `legendIndex`
	     * @param {number} legendIndex - index of legend label
	     * @returns {number} - calculate single legend width
	     */
	    _calculateSingleLegendWidth: function(legendIndex) {
	        return chartConst.LEGEND_AREA_PADDING
	            + this._getCheckboxWidth()
	            + getIconWidth()
	            + this._getLabelWidth(legendIndex)
	            + chartConst.LEGEND_AREA_PADDING;
	    },

	    /**
	     * set component dimension by comparaing label height and icon height
	     * @param {number} labelHeight - label height
	     */
	    _setComponentDimensionsBaseOnLabelHeight: function(labelHeight) {
	        this._legendItemHeight = Math.max(labelHeight, chartConst.LEGEND_ICON_HEIGHT);
	        this._iconHeight = this._legendItemHeight;
	        this._checkBoxWidth = this._checkBoxHeight = labelHeight;
	    }
	});

	module.exports = RaphaelLegendComponent;


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview RaphaelMapLegend is graph renderer for map chart legend.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var chartConst = __webpack_require__(8);
	var snippet = __webpack_require__(6);

	var PADDING = chartConst.LEGEND_AREA_PADDING;
	var DEGREE_HORIZONTAL_BAR = 360;
	var DEGREE_VERTICAL_BAR = 270;
	var GAP_BETWEEN_LABEL_AND_LEGEND_BAR = 35;
	var TICK_BAR_LENGTH = 15;
	var WEDGE_BASE_HALF = 3; // half of wedge triagle base
	/**
	 * @classdesc RaphaelMapLegend is graph renderer for map chart legend.
	 * @class RaphaelMapLegend
	 * @private
	 */
	var RaphaelMapLegend = snippet.defineClass(/** @lends RaphaelMapLegend.prototype */ {
	    /**
	     * Render function of map chart legend.
	     * @param {object} paper raphael paper
	     * @param {object} layout legend layout
	     * @param {ColorSpectrum} colorSpectrum map chart color model
	     * @param {boolean} isHorizontal whether horizontal legend or not
	     * @param {Array.<object>} legendSet legend set
	     */
	    render: function(paper, layout, colorSpectrum, isHorizontal, legendSet) {
	        var gradientBar;

	        layout.position.left += (PADDING * 2);
	        layout.position.top += PADDING;

	        gradientBar = this._renderGradientBar(paper, layout, colorSpectrum, isHorizontal);

	        legendSet.push(gradientBar);

	        this.wedge = this._renderWedge(paper, layout.position);
	        legendSet.push(this.wedge);

	        this.gradientBar = gradientBar;
	    },

	    /**
	     * Render gradient bar inner tick & tick label
	     * @param {object} paper Raphael paper
	     * @param {object} baseData base data for render ticks
	     * @param {Array.<string>} labels labels
	     * @param {boolean} isHorizontal boolean value for is horizontal or not
	     * @param {Array.<object>} legendSet legend set
	     */
	    renderTicksAndLabels: function(paper, baseData, labels, isHorizontal, legendSet) {
	        snippet.forEach(labels, function(label, labelIndex) {
	            var offsetValue = baseData.step * labelIndex;
	            var pos = snippet.extend({}, baseData.position);
	            var path = 'M';

	            if (isHorizontal) {
	                pos.left += offsetValue;
	                path += pos.left + ',' + (pos.top - GAP_BETWEEN_LABEL_AND_LEGEND_BAR)
	                    + 'V' + (pos.top - GAP_BETWEEN_LABEL_AND_LEGEND_BAR + TICK_BAR_LENGTH);
	            } else {
	                pos.top += offsetValue;
	                path += (pos.left - GAP_BETWEEN_LABEL_AND_LEGEND_BAR) + ',' + pos.top
	                    + 'H' + (pos.left - GAP_BETWEEN_LABEL_AND_LEGEND_BAR + TICK_BAR_LENGTH);
	            }

	            legendSet.push(raphaelRenderUtil.renderLine(paper, path, '#ccc', 1));
	            legendSet.push(raphaelRenderUtil.renderText(paper, pos, label));
	        });
	    },

	    /**
	     * Render gradient bar.
	     * @param {object} paper raphael object
	     * @param {object} layout legend layout
	     * @param {ColorSpectrum} colorSpectrum map chart color model
	     * @param {boolean} isHorizontal whether horizontal legend or not
	     * @returns {object}
	     * @private
	     */
	    _renderGradientBar: function(paper, layout, colorSpectrum, isHorizontal) {
	        var rectHeight = layout.dimension.height;
	        var left = layout.position.left;
	        var degree, bound, fill;

	        if (isHorizontal) {
	            rectHeight -= PADDING;
	            degree = DEGREE_HORIZONTAL_BAR;
	            this._makeWedghPath = this._makeHorizontalWedgePath;
	        } else {
	            degree = DEGREE_VERTICAL_BAR;
	            this._makeWedghPath = this._makeVerticalWedgePath;
	        }

	        fill = degree + '-' + colorSpectrum.start + '-' + colorSpectrum.end;

	        bound = {
	            left: left,
	            top: layout.position.top,
	            width: layout.dimension.width - PADDING,
	            height: rectHeight
	        };

	        return raphaelRenderUtil.renderRect(paper, bound, {
	            fill: fill,
	            stroke: 'none'
	        });
	    },

	    /**
	     * Render wedge.
	     * @param {object} paper raphael object
	     * @param {{top: number, left: number}} position base position of legend
	     * @returns {object} raphael object
	     * @private
	     */
	    _renderWedge: function(paper, position) {
	        return paper.path(this.verticalBasePath).attr({
	            'fill': 'gray',
	            stroke: 'none',
	            opacity: 0,
	            transform: 't' + position.left + ',' + position.top
	        });
	    },

	    /**
	     * Vertical base path
	     * @type {Array}
	     */
	    verticalBasePath: ['M', 16, 6, 'L', 24, 3, 'L', 24, 9],

	    /**
	     * Make vertical wedge path.
	     * @param {number} top top
	     * @returns {Array} path
	     * @private
	     */
	    _makeVerticalWedgePath: function(top) {
	        var path = this.verticalBasePath;

	        path[2] = top;
	        path[5] = top - WEDGE_BASE_HALF;
	        path[8] = top + WEDGE_BASE_HALF;

	        return path;
	    },

	    /**
	     * Horizontal base path
	     * @type {Array}
	     */
	    horizontalBasePath: ['M', 5, 16, 'L', 8, 24, 'L', 2, 24],

	    /**
	     * Make horizontal wedge path.
	     * @param {number} left left
	     * @returns {Array} path
	     * @private
	     */
	    _makeHorizontalWedgePath: function(left) {
	        var path = this.horizontalBasePath;

	        path[1] = left;
	        path[4] = left + WEDGE_BASE_HALF;
	        path[7] = left - WEDGE_BASE_HALF;

	        return path;
	    },

	    /**
	     * Show wedge.
	     * @param {number} positionValue top
	     */
	    showWedge: function(positionValue) {
	        var path = this._makeWedghPath(positionValue);

	        this.wedge.attr({
	            path: path,
	            opacity: 1
	        });
	    },

	    /**
	     * Hide wedge
	     */
	    hideWedge: function() {
	        this.wedge.attr({
	            opacity: 0
	        });
	    },

	    /**
	     * Remove location URL from fill attribute
	     * @private
	     */
	    removeLocationURLFromFillAttribute: function() {
	        var gradientBar = this.gradientBar;
	        var fillURL = gradientBar.node.getAttribute('fill');
	        this.locationURL = /url\('?([^#]+)#[^#]+'?\)/.exec(fillURL)[1];

	        gradientBar.node.setAttribute('fill', fillURL.replace(this.locationURL, ''));
	    },

	    /**
	     * Restore location URL to fill attribute
	     * @private
	     */
	    restoreLocationURLToFillAttribute: function() {
	        var gradientBar = this.gradientBar;
	        var fillURL = gradientBar.node.getAttribute('fill');

	        gradientBar.node.setAttribute('fill', fillURL.replace('#', this.locationURL + '#'));
	    }
	});

	module.exports = RaphaelMapLegend;


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview RaphaelCircleLegend is graph renderer for circleLegend.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var snippet = __webpack_require__(6);

	/**
	 * @classdesc RaphaelCircleLegend is graph renderer for circleLegend.
	 * @class RaphaelCircleLegend
	 * @private
	 */
	var RaphaelCircleLegend = snippet.defineClass(/** @lends RaphaelCircleLegend.prototype */ {

	    /**
	     * Render circle and label.
	     * @param {object} paper paper object
	     * @param {{width: number, height: number}} layout - layout of circle legend area
	     * @param {number} maxRadius - pixel type maximum radius
	     * @param {Array.<number>} radiusRatios - radius ratios
	     * @param {Array.<string>} labels - circle legend labels
	     * @returns {Array.<object>}
	     * @private
	     */
	    render: function(paper, layout, maxRadius, radiusRatios, labels) {
	        var left = layout.position.left + (layout.dimension.width / 2);
	        var circleLegendSet = paper.set();

	        snippet.forEachArray(radiusRatios, function(ratio, index) {
	            var radius = maxRadius * ratio;
	            var top = layout.position.top + layout.dimension.height - radius;
	            var circle = raphaelRenderUtil.renderCircle(paper, {
	                left: left,
	                top: top
	            }, radius, {
	                fill: 'none',
	                opacity: 1,
	                stroke: '#888',
	                'stroke-width': 1
	            });

	            circleLegendSet.push(circle);

	            circleLegendSet.push(raphaelRenderUtil.renderText(paper, {
	                left: left,
	                top: top - radius - 5
	            }, labels[index]));
	        });

	        return circleLegendSet;
	    }
	});

	module.exports = RaphaelCircleLegend;


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raphael title renderer.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var chartConst = __webpack_require__(8);
	var snippet = __webpack_require__(6);

	var RaphaelTitleComponent = snippet.defineClass(/** @lends RaphaelTitleComponent.prototype */ {
	    /**
	     * Render title
	     * @param {object} paper - paper
	     * @param {string} titleText - title text
	     * @param {{x: number, y: number}} offset - title offset x, y
	     * @param {object} theme - theme object
	     * @returns {Array.<object>} title set
	     */
	    render: function(paper, titleText, offset, theme) {
	        var fontSize = theme.fontSize;
	        var fontFamily = theme.fontFamily;
	        var titleSize = raphaelRenderUtil.getRenderedTextSize(titleText, fontSize, fontFamily);
	        var pos = {
	            left: paper.width / 2,
	            top: (titleSize.height + chartConst.TITLE_PADDING) / 2 // for renderText's baseline
	        };
	        var titleSet = paper.set();

	        if (offset) {
	            if (offset.x) {
	                pos.left += offset.x;
	            } else if (offset.y) {
	                pos.top += offset.y;
	            }
	        }

	        titleSet.push(raphaelRenderUtil.renderText(paper, pos, titleText, {
	            'font-family': theme.fontFamily,
	            'font-size': theme.fontSize,
	            'font-weight': theme.fontWeight,
	            fill: theme.color,
	            'text-anchor': 'middle'
	        }));

	        return titleSet;
	    },
	    /**
	     * Resize title component
	     * @param {number} chartWidth chart width
	     * @param {Array.<object>} titleSet title set
	     */
	    resize: function(chartWidth, titleSet) {
	        titleSet.attr({
	            x: chartWidth / 2
	        });
	    }
	});

	module.exports = RaphaelTitleComponent;


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raphael title renderer.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var AXIS_BACKGROUND_RIGHT_PADDING = 4;
	var snippet = __webpack_require__(6);

	var RaphaelAxisComponent = snippet.defineClass(/** @lends RaphaelAxisComponent.prototype */ {
	    init: function() {
	        this.ticks = [];
	    },

	    /**
	     * Render background with plot background color
	     * @param {object} paper Raphael paper
	     * @param {object} position axis position
	     * @param {object} dimension axis dimension
	     * @param {object} theme chart theme
	     * @returns {Element} - raphael <rect> element
	     * @private
	     */
	    renderBackground: function(paper, position, dimension, theme) {
	        var background = ((theme && theme.background) || {});
	        var fillColor = (background.color || '#fff');
	        var opacity = (background.opacity || 1);

	        return raphaelRenderUtil.renderRect(paper, {
	            left: 0,
	            top: position.top,
	            width: dimension.width + position.left - AXIS_BACKGROUND_RIGHT_PADDING,
	            height: dimension.height
	        }, {
	            fill: fillColor,
	            opacity: opacity,
	            'stroke-width': 0
	        });
	    },

	    /**
	     * Render title
	     * @param {object} paper raphael paper
	     * @param {object} data rendering data
	     * @param {string} data.text text content
	     * @param {object} data.theme theme object
	     * @param {object} data.rotationInfo object
	     * @param {object} data.layout dimension and position
	     */
	    renderTitle: function(paper, data) {
	        var theme = data.theme;
	        var attributes = {
	            'dominant-baseline': 'auto',
	            'font-family': theme.fontFamily,
	            'font-size': theme.fontSize,
	            'font-weight': theme.fontWeight,
	            fill: theme.color,
	            'text-anchor': 'middle'
	        };
	        var position = this.calculatePosition(paper, data);
	        var title;

	        attributes.transform = getCSSTransform(data.rotationInfo, position);
	        title = raphaelRenderUtil.renderText(paper, position, data.text, attributes);

	        title.node.style.userSelect = 'none';
	        title.node.style.cursor = 'default';

	        data.set.push(title);
	    },

	    /**
	     * Render Axis label
	     * @param {object} data data for render label
	     *       @param {{
	     *           left: number,
	     *           top: number
	     *       }} data.positionTopAndLeft left, top positions
	     *       @param {string} data.labelText label text
	     *       @param {number} data.labelSize label size
	     *       @param {object} data.paper raphael paper
	     *       @param {boolean} data.isVertical boolean value of axis is vertical
	     *       @param {boolean} data.isPositionRight boolean value of axis is right yAxis
	     *       @param {object} data.theme theme of label
	     */
	    renderLabel: function(data) {
	        var positionTopAndLeft = data.positionTopAndLeft;
	        var labelText = data.labelText;
	        var paper = data.paper;
	        var isVertical = data.isVertical;
	        var isPositionRight = data.isPositionRight;
	        var theme = data.theme;
	        var attributes = {
	            'dominant-baseline': 'central',
	            'font-family': theme.fontFamily,
	            'font-size': theme.fontSize,
	            'font-weight': theme.fontWeight,
	            fill: theme.color
	        };
	        var textObj;

	        if (isPositionRight) {
	            attributes['text-anchor'] = 'start';
	        } else if (isVertical) {
	            attributes['text-anchor'] = 'end';
	        } else {
	            attributes['text-anchor'] = 'middle';
	        }

	        textObj = raphaelRenderUtil.renderText(paper, positionTopAndLeft, labelText, attributes);

	        textObj.node.style.userSelect = 'none';
	        textObj.node.style.cursor = 'default';

	        data.set.push(textObj);
	        this.ticks.push(textObj);
	    },

	    /**
	     * Render rotated Axis label
	     * @param {object} data data for render rotated label
	     *       @param {{
	     *           left: number,
	     *           top: number
	     *       }} data.positionTopAndLeft left, top positions
	     *       @param {string} data.labelText label text
	     *       @param {object} data.paper raphael paper
	     *       @param {boolean} data.isVertical boolean value of axis is vertical
	     *       @param {object} data.theme theme of label
	     *       @param {number} data.degree rotation degree
	     */
	    renderRotatedLabel: function(data) {
	        var positionTopAndLeft = data.positionTopAndLeft;
	        var labelText = data.labelText;
	        var paper = data.paper;
	        var theme = data.theme;
	        var textObj = raphaelRenderUtil.renderText(paper, positionTopAndLeft, labelText, {
	            'dominant-baseline': 'central',
	            'font-family': theme.fontFamily,
	            'font-size': theme.fontSize,
	            'font-weight': theme.fontWeight,
	            fill: theme.color,
	            'text-anchor': 'end',
	            transform: 'r' + (-data.degree) + ',' + (positionTopAndLeft.left + 20) + ',' + (positionTopAndLeft.top)
	        });

	        textObj.node.style.userSelect = 'none';
	        textObj.node.style.cursor = 'arrow';

	        data.set.push(textObj);
	        this.ticks.push(textObj);
	    },

	    /**
	     * Render ticks on given paper
	     * @param {object} data data for rendering ticks
	     */
	    renderTicks: function(data) {
	        var self = this;
	        var paper = data.paper;
	        var positions = data.positions;
	        var additionalSize = data.additionalSize;
	        var isVertical = data.isVertical;
	        var isCenter = data.isCenter;
	        var isPositionRight = data.isPositionRight;
	        var tickColor = data.tickColor;
	        var layout = data.layout;
	        var rightEdgeOfAxis = layout.position.left + layout.dimension.width;
	        var baseTop = layout.position.top;
	        var baseLeft = layout.position.left;
	        var tick;
	        var isContainDivensionArea = function(position) {
	            var compareType = isVertical ? 'height' : 'width';

	            return (position > layout.dimension[compareType]);
	        };

	        snippet.forEach(positions, function(position) {
	            var pathString = 'M';

	            position += additionalSize;

	            if (isContainDivensionArea(position)) {
	                return;
	            }

	            if (isVertical) {
	                if (isCenter) {
	                    pathString += baseLeft + ',' + (baseTop + position);
	                    pathString += 'H' + (baseLeft + 5);

	                    pathString += 'M' + rightEdgeOfAxis + ',' + (baseTop + position);
	                    pathString += 'H' + (rightEdgeOfAxis - 5);
	                } else if (isPositionRight) {
	                    pathString += baseLeft + ',' + (baseTop + position);
	                    pathString += 'H' + (baseLeft + 5);
	                } else {
	                    pathString += rightEdgeOfAxis + ',' + (baseTop + position);
	                    pathString += 'H' + (rightEdgeOfAxis - 5);
	                }
	            } else {
	                pathString += (baseLeft + position) + ',' + baseTop;
	                pathString += 'V' + (baseTop + 5);
	            }

	            if (!isNaN(position)) {
	                tick = paper.path(pathString).attr({
	                    stroke: tickColor
	                });
	                data.set.push(tick);
	                self.ticks.push(tick);
	            }
	        });
	    },

	    /**
	     * Render tick line  on given paper
	     * @param {number} data data for render tick line
	     * @param {number} data.areaSize area size width or height
	     * @param {object} data.paper raphael paper
	     * @param {boolean} data.isNotDividedXAxis boolean value for XAxis divided or not
	     * @param {number} data.additionalSize additional size for position and line length
	     * @param {number} data.additionalWidth additional width of tick line paper
	     * @param {number} data.additionalHeight additional height of tick line paper
	     * @param {boolean} data.isPositionRight boolean value of right yAxis or not
	     * @param {boolean} data.isCenter boolean value of center yAxis or not
	     * @param {boolean} data.isVertical boolean value of vertical axis or not
	     */
	    renderTickLine: function(data) {
	        var areaSize = data.areaSize;
	        var lineSize = areaSize;
	        var paper = data.paper;
	        var layout = data.layout;
	        var isNotDividedXAxis = data.isNotDividedXAxis;
	        var additionalSize = data.additionalSize;
	        var isPositionRight = data.isPositionRight;
	        var isCenter = data.isCenter;
	        var isVertical = data.isVertical;
	        var tickColor = data.tickColor;
	        var pathString = 'M';
	        var baseTop = layout.position.top;
	        var baseLeft = layout.position.left;
	        var verticalTickLineEndYCoord = layout.dimension.height + baseTop;
	        var rightEdgeOfAxis = baseLeft + layout.dimension.width;
	        var lineStartYCoord, lineEndXCoord, lineEndYCoord;

	        if (isPositionRight) {
	            pathString += baseLeft + ',' + baseTop;
	            pathString += 'V' + verticalTickLineEndYCoord;
	        } else if (isVertical) {
	            lineStartYCoord = baseTop;
	            pathString += rightEdgeOfAxis + ',' + lineStartYCoord;

	            if (isCenter) {
	                pathString += 'V' + verticalTickLineEndYCoord;
	                pathString += 'M' + baseLeft + ',' + lineStartYCoord;
	                pathString += 'V' + verticalTickLineEndYCoord;
	            } else {
	                lineEndYCoord = baseTop + lineSize;
	                pathString += 'V' + lineEndYCoord;
	            }
	        } else {
	            if (isNotDividedXAxis) {
	                pathString += baseLeft;
	            } else {
	                pathString += (baseLeft + additionalSize);
	            }
	            pathString += ',' + baseTop + 'H';

	            lineEndXCoord = (baseLeft + lineSize);

	            if (!isNotDividedXAxis) {
	                lineEndXCoord += additionalSize;
	            }
	            pathString += lineEndXCoord;
	        }

	        data.set.push(paper.path(pathString).attr({
	            'stroke-width': 1,
	            stroke: tickColor
	        }));
	    },

	    /**
	     * Animate ticks for adding data
	     * @param {number} tickSize tick size of moving
	     */
	    animateForAddingData: function(tickSize) {
	        snippet.forEach(this.ticks, function(tick) {
	            tick.animate({
	                transform: 't-' + tickSize + ',0'
	            }, 300);
	        });
	    },

	    /**
	     * Calculate axis title position, and transforma
	     * @param {Raphael.paper} paper - paper
	     * @param {object} data - options for calcultating title position
	     *  @param {object} data.rotationInfo - isCenter, isVertical, isPositionRight
	     *  @param {object} data.text - text
	     *  @param {object} data.theme - theme
	     *  @param {object} data.layout - layout
	     * @returns {object} position - top, left
	     */
	    calculatePosition: function(paper, data) {
	        var rotationInfo = data.rotationInfo;
	        var textHeight = getTextHeight(data.text, data.theme);
	        var layout = data.layout;
	        var centerPosition = calculateCenterPosition(
	            rotationInfo.isVertical, layout.dimension, layout.position
	        );
	        var position = {};

	        if (rotationInfo.isCenter) {
	            position.top = paper.height - (textHeight / 2);
	            position.left = layout.position.left + (layout.dimension.width / 2);
	        } else if (rotationInfo.isPositionRight) {
	            position.top = centerPosition;
	            position.left = layout.position.left + layout.dimension.width;
	        } else if (rotationInfo.isVertical) {
	            position.top = centerPosition;
	            position.left = layout.position.left + (textHeight / 2);
	        } else {
	            position.top = layout.position.top + layout.dimension.height;
	            position.left = centerPosition;
	        }

	        if (!rotationInfo.isCenter) {
	            addOffset(position, data.offset);
	        }

	        return position;
	    }
	});

	/**
	 * Get a text height by theme
	 * @param {string} text - text
	 * @param {object} theme - axis theme
	 * @returns {number} text height
	 * @ignore
	 */
	function getTextHeight(text, theme) {
	    var titleSize = raphaelRenderUtil.getRenderedTextSize(text, theme.fontSize, theme.fontFamily);

	    return titleSize.height;
	}

	/**
	 * Test axis title need to rotate
	 * @param {object} rotationInfo - rotationInfo
	 * @returns {boolean} - whether it needs to rotate
	 * @ignore
	 */
	function doesTitleRotate(rotationInfo) {
	    if (snippet.isExisty(rotationInfo.rotateTitle)) {
	        return rotationInfo.rotateTitle === true;
	    }

	    return true;
	}

	/**
	 * Calculate center position
	 * @param {boolean} isVertical - is vertical axis
	 * @param {object} dimension - width, height
	 * @param {object} position - top, left
	 * @returns {number} - center position
	 * @ignore
	 */
	function calculateCenterPosition(isVertical, dimension, position) {
	    var size = isVertical ? dimension.height : dimension.width;
	    var margin = isVertical ? position.top : position.left;

	    return (size / 2) + margin;
	}

	/**
	 * Add offset to position
	 * @param {object} position - top, left
	 * @param {object} offset - x, y
	 * @ignore
	 */
	function addOffset(position, offset) {
	    if (!offset) {
	        return;
	    }

	    if (offset.x) {
	        position.left += offset.x;
	    }
	    if (offset.y) {
	        position.top += offset.y;
	    }
	}

	/**
	 * Get transform by rotation info
	 * @param {object} rotationInfo - isCenter, isVertical, isPositionRight
	 * @param {object} position - top, left
	 * @returns {string} css transform
	 * @ignore
	 */
	function getCSSTransform(rotationInfo, position) {
	    var transform = 'none';
	    if (rotationInfo.isPositionRight) {
	        transform = 'r90,' + position.left + ',' + position.top;
	    } else if (rotationInfo.isVertical && doesTitleRotate(rotationInfo)) {
	        transform = 'r-90,' + position.left + ',' + position.top;
	    }

	    return transform;
	}

	module.exports = RaphaelAxisComponent;


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview RaphaelRadialPlot is graph renderer for radial plot.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var raphaelRenderUtil = __webpack_require__(5);
	var arrayUtil = __webpack_require__(10);
	var snippet = __webpack_require__(6);

	var STEP_TOP_ADJUSTMENT = 8;
	var STEP_LEFT_ADJUSTMENT = 3;

	/**
	 * @classdesc RaphaelRadialPlot is graph renderer for radial plot.
	 * @class RaphaelRadialPlot
	 * @private
	 */
	var RaphaelRadialPlot = snippet.defineClass(/** @lends RaphaelRadialPlot.prototype */ {
	    /**
	     * Render function of map chart legend.
	     * @param {object} params parameters
	     * @param {HTMLElement} params.container container
	     * @param {{width: number, height: number}} params.dimension - dimension of circle legend area
	     * @param {Array<Array>} params.plotPositions plot positions
	     * @param {object} params.labelData label data
	     * @returns {object} paper raphael paper
	     */
	    render: function(params) {
	        var plotSet = params.paper.set();

	        this.paper = params.paper;
	        this.layout = params.layout;
	        this.plotPositions = params.plotPositions;
	        this.theme = params.theme;
	        this.options = params.options;
	        this.labelData = params.labelData;

	        this._renderPlot(plotSet);
	        this._renderLabels(plotSet);

	        plotSet.toBack();
	        this.paper.pushDownBackgroundToBottom();

	        return plotSet;
	    },

	    /**
	     * Render plot component
	     * @param {Array.<object>} plotSet plot set
	     * @private
	     */
	    _renderPlot: function(plotSet) {
	        if (this.options.type === 'circle') {
	            this._renderCirclePlot(plotSet);
	        } else {
	            this._renderSpiderwebPlot(plotSet);
	        }

	        this._renderCatergoryLines(plotSet);
	    },

	    /**
	     * Render spider web plot
	     * @param {Array.<object>} plotSet plot set
	     * @private
	     */
	    _renderSpiderwebPlot: function(plotSet) {
	        var groupPaths = this._getLinesPath(this.plotPositions);

	        this._renderLines(groupPaths, this.theme.lineColor, plotSet);
	    },

	    /**
	     * Render circle plot
	     * @param {Array.<object>} plotSet plot set
	     * @private
	     */
	    _renderCirclePlot: function(plotSet) {
	        var i, pos, radius;
	        var plotPositions = this.plotPositions;
	        var centerPoint = plotPositions[0][0];
	        var strokeColor = this.theme.lineColor;

	        for (i = 1; i < plotPositions.length; i += 1) {
	            pos = plotPositions[i][0];
	            radius = centerPoint.top - pos.top;

	            plotSet.push(raphaelRenderUtil.renderCircle(this.paper, centerPoint, radius, {
	                stroke: strokeColor
	            }));
	        }
	    },

	    /**
	     * Render category lines
	     * @param {Array.<object>} plotSet plot set
	     * @private
	     */
	    _renderCatergoryLines: function(plotSet) {
	        var groupPaths = this._getLinesPath(arrayUtil.pivot(this.plotPositions));

	        this._renderLines(groupPaths, this.theme.lineColor, plotSet);
	    },

	    /**
	     * Render labels
	     * @param {Array.<object>} plotSet plot set
	     * @private
	     */
	    _renderLabels: function(plotSet) {
	        var paper = this.paper;
	        var theme = this.theme;
	        var labelData = this.labelData;
	        var attributes = {
	            fill: theme.lineColor,
	            'font-size': theme.label.fontSize,
	            'font-family': theme.label.fontFamily,
	            'text-anchor': 'end',
	            'font-weight': '100',
	            'dominant-baseline': 'middle'
	        };

	        snippet.forEachArray(labelData.category, function(item) {
	            var categoryAttributes = snippet.extend({}, attributes, {
	                'text-anchor': item.position.anchor
	            });
	            var label = raphaelRenderUtil.renderText(paper, item.position, item.text, categoryAttributes);

	            label.node.style.userSelect = 'none';
	            label.node.style.cursor = 'default';

	            plotSet.push(label);
	        });

	        snippet.forEachArray(labelData.step, function(item) {
	            var stepLabel = raphaelRenderUtil.renderText(paper, item.position, item.text, attributes);

	            item.position.top -= STEP_TOP_ADJUSTMENT;
	            item.position.left -= STEP_LEFT_ADJUSTMENT;

	            stepLabel.node.style.userSelect = 'none';
	            stepLabel.node.style.cursor = 'default';

	            plotSet.push(stepLabel);
	        });
	    },

	    /**
	     * Render lines.
	     * @param {Array.<Array.<string>>} groupPaths paths
	     * @param {string} lineColor line color
	     * @param {Array.<object>} plotSet plot set
	     * @returns {Array.<Array.<object>>} lines
	     * @private
	     */
	    _renderLines: function(groupPaths, lineColor, plotSet) {
	        var paper = this.paper;

	        return snippet.map(groupPaths, function(path) {
	            var line = raphaelRenderUtil.renderLine(paper, path.join(' '), lineColor, 1);

	            plotSet.push(line);

	            return line;
	        });
	    },

	    /**
	     * Get lines path.
	     * /todo remove duplication, copied from raphaelLineTypeBase
	     * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	     * @returns {Array.<Array.<string>>} path
	     * @private
	     */
	    _getLinesPath: function(groupPositions) {
	        var self = this;

	        return snippet.map(groupPositions, function(positions) {
	            return self._makeLinesPath(positions);
	        });
	    },

	    /**
	     * Make lines path.
	     * /todo remove duplication, copied from raphaelLineTypeBase
	     * @param {Array.<{left: number, top: number, startTop: number}>} positions positions
	     * @param {?string} [posTopType='top'] position top type
	     * @param {boolean} [connectNulls] - boolean value connect nulls or not
	     * @returns {Array.<string | number>} paths
	     * @private
	     */
	    _makeLinesPath: function(positions, posTopType, connectNulls) {
	        var path = [];
	        var prevMissing = false;

	        posTopType = posTopType || 'top';

	        snippet.map(positions, function(position) {
	            var pathCommand = (prevMissing && !connectNulls) ? 'M' : 'L';

	            if (position) {
	                path.push([pathCommand, position.left, position[posTopType]]);
	                if (prevMissing) {
	                    prevMissing = false;
	                }
	            } else {
	                prevMissing = true;
	            }
	        });

	        path = Array.prototype.concat.apply([], path);
	        path[0] = 'M';

	        return path;
	    }
	});

	module.exports = RaphaelRadialPlot;


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview chart.js is entry point of Toast UI Chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var chartFactory = __webpack_require__(30);
	var pluginFactory = __webpack_require__(32);
	var themeManager = __webpack_require__(33);
	var mapManager = __webpack_require__(35);
	var objectUtil = __webpack_require__(36);
	var seriesDataImporter = __webpack_require__(37);
	var drawingToolPicker = __webpack_require__(38);

	__webpack_require__(39);
	__webpack_require__(40);
	__webpack_require__(146);

	/**
	 * Raw series datum.
	 * @typedef {{name: ?string, data: Array.<number>, stack: ?string}} rawSeriesDatum
	 * @private
	 */

	/**
	 * Raw series data.
	 * @typedef {Array.<rawSeriesDatum>} rawSeriesData
	 * @private
	 */

	/**
	 * Raw data.
	 * @typedef {{
	 *      categories: ?Array.<string>,
	 *      series: (rawSeriesData|{line: ?rawSeriesData, column: ?rawSeriesData})
	 * }} rawData
	 * @private
	 */

	/**
	 * Create chart.
	 * @param {HTMLElement} container container
	 * @param {({
	 *        series: (object|Array),
	 *        categories: Array
	 *   }|{
	 *        table: ({
	 *          elementId: string
	 *        }|{
	 *          element: HTMLElement
	 *        })
	 *   })} rawData - raw data object or data container table element or table's id
	 * @param {{
	 *   chart: {
	 *     width: number,
	 *     height: number,
	 *     title: string,
	 *     format: string
	 *   },
	 *   yAxis: {
	 *     title: string,
	 *     min: number
	 *   },
	 *   xAxis: {
	 *     title: string,
	 *     min: number
	 *   },
	 *   tooltip: {
	 *     suffix: string,
	 *     template: function
	 *   },
	 *   theme: string
	 * }} options - chart options
	 * @param {string} chartType - chart type
	 * @returns {object} chart instance.
	 * @private
	 * @ignore
	 */
	function _createChart(container, rawData, options, chartType) {
	    var theme, chart, temp;

	    if (!rawData) {
	        rawData = {};
	    }

	    if (rawData.table) {
	        rawData = seriesDataImporter.makeDataWithTable(rawData.table);
	    }

	    if (!rawData.series) {
	        rawData.series = [];
	    }

	    rawData = objectUtil.deepCopy(rawData);

	    if (chartType !== 'combo') {
	        temp = rawData.series;
	        rawData.series = {};
	        rawData.series[chartType] = temp;
	    }

	    options = options ? objectUtil.deepCopy(options) : {};
	    options.chartType = chartType;
	    options.theme = options.theme || chartConst.DEFAULT_THEME_NAME;
	    theme = themeManager.get(options.theme, chartType, rawData.series);

	    chart = chartFactory.get(options.chartType, rawData, theme, options);

	    chart.render(container);
	    chart.animateChart();

	    return chart;
	}

	/**
	 * Bar chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {string} options.yAxis.align - align option for center y axis
	 *          @param {boolean} options.yAxis.rotateTitle - whether rotate title or not (default: true)
	 *          @param {string} options.yAxis.type - type of axis
	 *          @param {string} options.yAxis.dateFormat - date format
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.min - minimum value for x axis
	 *          @param {number} options.xAxis.max - maximum value for x axis
	 *      @param {object} options.series - options for series component
	 *          @param {string} options.series.stackType - type of stack
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {number} options.series.barWidth - bar width
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.diverging - whether diverging or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {object} options.tooltip.offsetX - tooltip offset x
	 *          @param {object} options.tooltip.offsetY - tooltip offset y
	 *          @param {object} options.tooltip.position - (deprecated) relative position
	 *              @param {number} options.tooltip.position.left - position left
	 *              @param {number} options.tooltip.position.top - position top
	 *          @param {boolean} options.tooltip.grouped - whether group tooltip or not
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 * @returns {object} bar chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: ['cate1', 'cate2', 'cate3'],
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [20, 30, 50]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [40, 40, 60]
	 *         },
	 *         {
	 *           name: 'Legend3',
	 *           data: [60, 50, 10]
	 *         },
	 *         {
	 *           name: 'Legend4',
	 *           data: [80, 10, 70]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Bar Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.barChart(container, rawData, options);
	 */
	function barChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_BAR);
	}

	/**
	 * Column chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {boolean} options.yAxis.rotateTitle - whether rotate title or not (default: true)
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.labelInterval - label interval for x axis
	 *          @param {boolean} options.xAxis.rotateLabel - whether rotate label or not (default: true)
	 *          @param {string} options.xAxis.type - type of axis
	 *          @param {string} options.xAxis.dateFormat - date format
	 *      @param {object} options.series - options for series component
	 *          @param {string} options.series.stackType - type of stack
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {number} options.series.barWidth - bar width
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.diverging - whether diverging or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {object} options.tooltip.offsetX - tooltip offset x
	 *          @param {object} options.tooltip.offsetY - tooltip offset y
	 *          @param {object} options.tooltip.position - (deprecated) relative position
	 *              @param {number} options.tooltip.position.left - position left
	 *              @param {number} options.tooltip.position.top - position top
	 *          @param {boolean} options.tooltip.grouped - whether group tooltip or not
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 * @returns {object} column chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: ['cate1', 'cate2', 'cate3'],
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [20, 30, 50]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [40, 40, 60]
	 *         },
	 *         {
	 *           name: 'Legend3',
	 *           data: [60, 50, 10]
	 *         },
	 *         {
	 *           name: 'Legend4',
	 *           data: [80, 10, 70]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Column Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.columnChart(container, rawData, options);
	 */
	function columnChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_COLUMN);
	}

	/**
	 * Line chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {?Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {boolean} options.yAxis.rotateTitle - whether rotate title or not (default: true)
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.labelInterval - label interval for x axis
	 *          @param {string} options.xAxis.tickInterval - tick interval for x axis
	 *          @param {boolean} options.xAxis.rotateLabel - whether rotate label or not (default: true)
	 *          @param {string} options.xAxis.type - type of axis
	 *          @param {string} options.xAxis.dateFormat - date format
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showDot - whether show dot or not
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.spline - whether spline or not
	 *          @param {boolean} options.series.zoomable - whether zoomable or not
	 *          @param {boolean} options.series.shifting - whether shifting or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {object} options.tooltip.offsetX - tooltip offset x
	 *          @param {object} options.tooltip.offsetY - tooltip offset y
	 *          @param {object} options.tooltip.position - (deprecated) relative position
	 *              @param {number} options.tooltip.position.left - position left
	 *              @param {number} options.tooltip.position.top - position top
	 *          @param {boolean} options.tooltip.grouped - whether group tooltip or not
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *          @param {Array} options.plot.bands - plot bands
	 *              @param {Array.<string|number|date>} options.plot.bands.range - value range for matching
	 *              @param {string} options.plot.bands.color - band color
	 *              @param {number} options.plot.bands.opacity - band opacity
	 *          @param {Array} options.plot.lines - plot lines
	 *              @param {(string|number|date)} options.plot.lines.value - value for matching
	 *              @param {string} options.plot.lines.color - band color
	 *              @param {number} options.plot.lines.opacity - band opacity
	 *          @param {Array.<{value: (string|number|date), color: ?string, opacity: ?string}>} options.plot.lines
	 *                  - plot lines
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 * @returns {object} bar chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: ['cate1', 'cate2', 'cate3'],
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [20, 30, 50]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [40, 40, 60]
	 *         },
	 *         {
	 *           name: 'Legend3',
	 *           data: [60, 50, 10]
	 *         },
	 *         {
	 *           name: 'Legend4',
	 *           data: [80, 10, 70]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Line Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       },
	 *       series: {
	 *         showDot: true
	 *       }
	 *     };
	 * chart.lineChart(container, rawData, options);
	 */
	function lineChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_LINE);
	}

	/**
	 * Area chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {?Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {boolean} options.yAxis.rotateTitle - whether rotate title or not (default: true)
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.labelInterval - label interval for x axis
	 *          @param {boolean} options.xAxis.rotateLabel - whether rotate label or not (default: true)
	 *          @param {string} options.xAxis.tickInterval - tick interval for x axis
	 *          @param {string} options.xAxis.type - type of axis
	 *          @param {string} options.xAxis.dateFormat - date format
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showDot - whether show dot or not
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.spline - whether spline or not
	 *          @param {boolean} options.series.zoomable - whether zoomable or not
	 *          @param {boolean} options.series.shifting - whether shifting or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {object} options.tooltip.offsetX - tooltip offset x
	 *          @param {object} options.tooltip.offsetY - tooltip offset y
	 *          @param {object} options.tooltip.position - (deprecated) relative position
	 *              @param {number} options.tooltip.position.left - position left
	 *              @param {number} options.tooltip.position.top - position top
	 *          @param {boolean} options.tooltip.grouped - whether group tooltip or not
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *          @param {Array} options.plot.bands - plot bands
	 *              @param {Array.<string|number|date>} options.plot.bands.range - value range for matching
	 *              @param {string} options.plot.bands.color - band color
	 *              @param {number} options.plot.bands.opacity - band opacity
	 *          @param {Array} options.plot.lines - plot lines
	 *              @param {(string|number|date)} options.plot.lines.value - value for matching
	 *              @param {string} options.plot.lines.color - band color
	 *              @param {number} options.plot.lines.opacity - band opacity
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 * @returns {object} bar chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: ['cate1', 'cate2', 'cate3'],
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [20, 30, 50]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [40, 40, 60]
	 *         },
	 *         {
	 *           name: 'Legend3',
	 *           data: [60, 50, 10]
	 *         },
	 *         {
	 *           name: 'Legend4',
	 *           data: [80, 10, 70]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Area Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.areaChart(container, rawData, options);
	 */
	function areaChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_AREA);
	}

	/**
	 * Bubble chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {boolean} options.yAxis.rotateTitle - whether rotate title or not (default: true)
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.labelInterval - label interval for x axis
	 *          @param {boolean} options.xAxis.rotateLabel - whether rotate label or not (default: true)
	 *          @param {number} options.xAxis.min - minimum value for y axis
	 *          @param {number} options.xAxis.max - maximum value for y axis
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {object} options.tooltip.offsetX - tooltip offset x
	 *          @param {object} options.tooltip.offsetY - tooltip offset y
	 *          @param {object} options.tooltip.position - (deprecated) relative position
	 *              @param {number} options.tooltip.position.left - position left
	 *              @param {number} options.tooltip.position.top - position top
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.circleLegend - options for circleLegend
	 *          @param {boolean} options.circleLegend.visible - whether visible or not (default: true)
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 * @returns {object} bubble chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [{
	 *              x: 10,
	 *              y: 20,
	 *              r: 15,
	 *              label: 'Lable1'
	 *           }, {
	 *              x: 20,
	 *              y: 40,
	 *              r: 10,
	 *              label: 'Lable2'
	 *           }]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [{
	 *              x: 40,
	 *              y: 10,
	 *              r: 5,
	 *              label: 'Lable3'
	 *           }, {
	 *              x: 30,
	 *              y: 40,
	 *              r: 8,
	 *              label: 'Lable4'
	 *           }]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Bubble Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.bubbleChart(container, rawData, options);
	 */
	function bubbleChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_BUBBLE);
	}

	/**
	 * Scatter chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {boolean} options.yAxis.rotateTitle - whether rotate title or not (default: true)
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.min - minimum value for y axis
	 *          @param {number} options.xAxis.max - maximum value for y axis
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {object} options.tooltip.offsetX - tooltip offset x
	 *          @param {object} options.tooltip.offsetY - tooltip offset y
	 *          @param {object} options.tooltip.position - (deprecated) relative position
	 *              @param {number} options.tooltip.position.left - position left
	 *              @param {number} options.tooltip.position.top - position top
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 * @returns {object} scatter chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [{
	 *              x: 10,
	 *              y: 20
	 *           }, {
	 *              x: 20,
	 *              y: 40
	 *           }]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [{
	 *              x: 40,
	 *              y: 10
	 *           }, {
	 *              x: 30,
	 *              y: 40
	 *           }]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Scatter Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.scatterChart(container, rawData, options);
	 */
	function scatterChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_SCATTER);
	}

	/**
	 * Heatmap chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {{x: Array.<string | number>, y: Array.<string | number>}} rawData.categories - categories
	 *      @param {Array.<Array.<number>>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {boolean} options.yAxis.rotateTitle - whether rotate title or not (default: true)
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {object} options.tooltip.offsetX - tooltip offset x
	 *          @param {object} options.tooltip.offsetY - tooltip offset y
	 *          @param {object} options.tooltip.position - (deprecated) relative position
	 *              @param {number} options.tooltip.position.left - position left
	 *              @param {number} options.tooltip.position.top - position top
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 * @returns {object} scatter chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: {
	 *           x: [10, 20, 30, 40, 50],
	 *           y: [1, 2, 3, 4, 5, 6]
	 *       },
	 *       series: [
	 *           [10, 20, 30, 40, 50],
	 *           [1, 4, 6, 7, 8],
	 *           [20, 4, 5, 70, 8],
	 *           [100, 40, 30, 80, 30],
	 *           [20, 10, 60, 90, 20],
	 *           [50, 40, 30, 20, 10]
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Heatmap Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.heatmapChart(container, rawData, options);
	 */
	function heatmapChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_HEATMAP);
	}

	/**
	 * Treemap chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<Array.<object>>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.useColorValue - whether use colorValue or not
	 *          @param {boolean} options.series.zoomable - whether zoomable or not
	 *          @param {boolean} options.series.useLeafLabel - whether use leaf label or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {object} options.tooltip.offsetX - tooltip offset x
	 *          @param {object} options.tooltip.offsetY - tooltip offset y
	 *          @param {object} options.tooltip.position - (deprecated) relative position
	 *              @param {number} options.tooltip.position.left - position left
	 *              @param {number} options.tooltip.position.top - position top
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 * @returns {object} scatter chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       series: [
	 *          {
	 *              label: 'label1',
	 *              value: 6
	 *          },
	 *          {
	 *              label: 'label2',
	 *              value: 6
	 *          },
	 *          {
	 *              label: 'label3',
	 *              value: 4
	 *          },
	 *          {
	 *              label: 'label4',
	 *              value: 3
	 *          },
	 *          {
	 *              label: 'label5',
	 *              value: 2
	 *          },
	 *          {
	 *              label: 'label6',
	 *              value: 2
	 *          },
	 *          {
	 *              label: 'label7',
	 *              value: 1
	 *          }
	 *     ],
	 *     options = {
	 *       chart: {
	 *         title: 'Treemap Chart'
	 *       }
	 *     };
	 * chart.treemapChart(container, rawData, options);
	 */
	function treemapChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_TREEMAP);
	}

	/**
	 * Combo chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object|Array} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {boolean} options.yAxis.rotateTitle - whether rotate title or not (default: true)
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.labelInterval - label interval for x axis
	 *          @param {boolean} options.xAxis.rotateLabel - whether rotate label or not (default: true)
	 *      @param {object} options.series - options for series component
	 *          @param {?object} options.series.column - options for column series component
	 *              @param {string} options.series.column.stackType - type of stack
	 *              @param {boolean} options.series.column.showLabel - whether show label or not
	 *              @param {number} options.series.column.barWidth - bar width
	 *          @param {?object} options.series.line - options for line series component
	 *              @param {boolean} options.series.line.showDot - whether show dot or not
	 *              @param {boolean} options.series.line.showLabel - whether show label or not
	 *              @param {boolean} options.series.line.spline - whether spline or not
	 *          @param {?object} options.series.area - options for line series component
	 *              @param {boolean} options.series.area.showDot - whether show dot or not
	 *              @param {boolean} options.series.area.showLabel - whether show label or not
	 *              @param {boolean} options.series.area.spline - whether spline or not
	 *          @param {?object} options.series.pie - options for pie series component
	 *              @param {boolean} options.series.pie.showLabel - whether show label or not
	 *              @param {number} options.series.pie.radiusRatio - ratio of radius for pie graph
	 *              @param {boolean} options.series.pie.startAngle - start angle
	 *              @param {boolean} options.series.pie.endAngle - end angle
	 *          @param {boolean} options.series.showDot - whether show dot or not
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.spline - whether spline or not
	 *          @param {boolean} options.series.zoomable - whether zoomable or not
	 *          @param {boolean} options.series.shifting - whether shifting or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {object} options.tooltip.column - options for column tooltip
	 *              @param {string} options.tooltip.column.suffix - suffix for tooltip
	 *              @param {function} [options.tooltip.column.template] template of tooltip
	 *              @param {string} options.tooltip.column.align - align option for tooltip
	 *              @param {number} options.tooltip.column.offsetX - tooltip offset x
	 *              @param {number} options.tooltip.column.offsetY - tooltip offset y
	 *              @param {object} options.tooltip.column.position - (deprecated) relative position
	 *                  @param {number} options.tooltip.position.left - position left
	 *                  @param {number} options.tooltip.position.top - position top
	 *          @param {boolean} options.tooltip.grouped - whether group tooltip or not
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *          @param {Array} options.plot.bands - plot bands for line & area combo chart
	 *              @param {Array.<string|number|date>} options.plot.bands.range - value range for matching
	 *              @param {string} options.plot.bands.color - band color
	 *              @param {number} options.plot.bands.opacity - band opacity
	 *          @param {Array} options.plot.lines - plot lines
	 *              @param {(string|number|date)} options.plot.lines.value - value for matching
	 *              @param {string} options.plot.lines.color - band color
	 *              @param {number} options.plot.lines.opacity - band opacity
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 * @returns {object} bar chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: ['cate1', 'cate2', 'cate3'],
	 *       series: {
	 *         column: [
	 *           {
	 *             name: 'Legend1',
	 *             data: [20, 30, 50]]
	 *           },
	 *           {
	 *             name: 'Legend2',
	 *             data: [40, 40, 60]
	 *           },
	 *           {
	 *             name: 'Legend3',
	 *             data: [60, 50, 10]
	 *           },
	 *           {
	 *             name: 'Legend4',
	 *             data: [80, 10, 70]
	 *           }
	 *         },
	 *         line: [
	 *           {
	 *             name: 'Legend5',
	 *             data: [1, 2, 3]
	 *           }
	 *         ]
	 *       }
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Combo Chart'
	 *       },
	 *       yAxis:[
	 *         {
	 *           title: 'Y Axis',
	 *           chartType: 'line'
	 *         },
	 *         {
	 *           title: 'Y Right Axis'
	 *         }
	 *       ],
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       },
	 *       series: {
	 *         showDot: true
	 *       }
	 *     };
	 * chart.comboChart(container, rawData, options);
	 */
	function comboChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_COMBO);
	}

	/**
	 * Pie chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {number} options.series.radiusRatio - ratio of radius for pie graph
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.startAngle - start angle
	 *          @param {boolean} options.series.endAngle - end angle
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {object} options.tooltip.offset - tooltip offset
	 *              @param {number} options.tooltip.offset.x - offset x
	 *              @param {number} options.tooltip.offset.y - offset y
	 *          @param {object} options.tooltip.position - (deprecated) relative position
	 *              @param {number} options.tooltip.position.left - position left
	 *              @param {number} options.tooltip.position.top - position top
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left|center|outer)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 * @returns {object} bar chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: 20
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: 40
	 *         },
	 *         {
	 *           name: 'Legend3',
	 *           data: 60
	 *         },
	 *         {
	 *           name: 'Legend4',
	 *           data: 80
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Pie Chart'
	 *       }
	 *     };
	 * chart.pieChart(container, rawData, options);
	 */
	function pieChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_PIE);
	}

	/**
	 * Map chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData chart data
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {object} options.tooltip.offset - tooltip offset
	 *              @param {number} options.tooltip.offset.x - offset x
	 *              @param {number} options.tooltip.offset.y - offset y
	 *          @param {object} options.tooltip.position - (deprecated) relative position
	 *              @param {number} options.tooltip.position.left - position left
	 *              @param {number} options.tooltip.position.top - position top
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left|center|outer)
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.map map type
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 * @returns {object} bar chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       series: [
	 *         {
	 *           code: 'KR',
	 *           data: 100,
	 *           labelCoordinate: {
	 *             x: 0.6,
	 *             y: 0.7
	 *           }
	 *         },
	 *         {
	 *           code: 'JP',
	 *           data: 50
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Map Chart'
	 *       },
	 *       map: 'world'
	 *     };
	 * chart.mapChart(container, rawData, options);
	 */
	function mapChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_MAP);
	}

	/**
	 * radial chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showDot - show dot or not (default: true)
	 *          @param {boolean} options.series.showArea - show area or not (default: true)
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.type - "spiderweb" or "circle" (default: "spiderweb")
	 *      @param {object|Array} options.yAxis - options for y axis component
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {object} options.tooltip.offset - tooltip offset
	 *              @param {number} options.tooltip.offset.x - offset x
	 *              @param {number} options.tooltip.offset.y - offset y
	 *          @param {object} options.tooltip.position - (deprecated) relative position
	 *              @param {number} options.tooltip.position.left - position left
	 *              @param {number} options.tooltip.position.top - position top
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left|center|outer)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 * @returns {object} bar chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('chart-area'),
	 *     rawData = {
	 *         categories: ["June", "July", "Aug", "Sep", "Oct", "Nov"],
	 *         series: [
	 *             {
	 *                 name: 'Budget',
	 *                 data: [5000, 3000, 5000, 7000, 6000, 4000]
	 *             },
	 *             {
	 *                 name: 'Income',
	 *                 data: [8000, 8000, 7000, 2000, 5000, 3000]
	 *             },
	 *             {
	 *                 name: 'Expenses',
	 *                 data: [4000, 4000, 6000, 3000, 4000, 5000]
	 *             },
	 *             {
	 *                 name: 'Debt',
	 *                 data: [6000, 3000, 3000, 1000, 2000, 4000]
	 *             }
	 *         ]
	 *     },
	 *     options = {
	 *         chart: {
	 *             width: 600,
	 *             height: 400
	 *         },
	 *         series: {
	 *             showDot: true,
	 *             showArea: true
	 *         },
	 *         plot: {
	 *             type: 'circle'
	 *         },
	 *         yAxis: {
	 *             min: 0,
	 *             max: 9000
	 *         }
	 *     };
	 * chart.radialChart(container, rawData, options);
	 *
	 */
	function radialChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_RADIAL);
	}

	/**
	 * Boxplot chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData chart data
	 * @param {object} options - chart options
	 * @returns {object} box plot chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 * var rawData = {
	 *  categories: ['Budget', 'Income', 'Expenses', 'Debt'],
	 *  series: [{
	 *      name: '2015',
	 *      data: [
	 *          [1000, 2500, 3714, 5500, 7000],
	 *          [1000, 2250, 3142, 4750, 6000]
	 *      ],
	 *      outliers: [
	 *          [0, 14000]
	 *      ]
	 *  }, {
	 *      name: '2016',
	 *      data: [
	 *          [2000, 4500, 6714, 11500, 13000],
	 *          [7000, 9250, 10142, 11750, 12000]
	 *      ],
	 *      outliers: [
	 *          [1, 14000]
	 *      ]
	 *  }];
	 * };
	 * var options = {
	 *      chart: {
	 *          width: 600,
	 *          height: 400
	 *      },
	 *      series: {
	 *          showDot: true,
	 *          showArea: true
	 *      },
	 *      plot: {
	 *          type: 'circle'
	 *      },
	 *      yAxis: {
	 *          min: 0,
	 *          max: 9000
	 *      }
	 *  };
	 * chart.boxplotChart(container, rawData, options);
	 */
	function boxplotChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_BOXPLOT);
	}

	/**
	 * Bullet chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData chart data
	 * @param {object} options - chart options
	 * @returns {object} box plot chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('chart-area');
	 * var data = {
	 *   categories: ['July', 'August'],
	 *   series: [{
	 *       name: 'Budget',
	 *       data: 25,
	 *      markers: [28, 2, 15],
	 *       ranges: [[-1, 10], [10, 20], [20, 30]]
	 *   },{
	 *       name: 'Hello',
	 *       data: 11,
	 *       markers: [20],
	 *       ranges: [[0, 8], [8, 15]]
	 *   }]
	 * };
	 * var options = {
	 *    chart: {
	 *       width: 700,
	 *       height: 300,
	 *       title: 'Monthly Revenue'
	 *   },
	 *   series: {
	 *       showLabel: true,
	 *       vertical: false
	 *   }
	 * };
	 * chart.bulletChart(container, data, options);
	 */
	function bulletChart(container, rawData, options) {
	    return _createChart(container, rawData, options, chartConst.CHART_TYPE_BULLET);
	}

	/**
	 * Register theme.
	 * @memberof tui.chart
	 * @param {string} themeName - theme name
	 * @param {object} theme - application chart theme
	 *      @param {object} theme.chart - chart theme
	 *          @param {string} theme.chart.fontFamily - font family for chart
	 *          @param {string} theme.chart.background - background for chart
	 *      @param {object} theme.title - chart title theme
	 *          @param {number} theme.title.fontSize - font size
	 *          @param {string} theme.title.fontFamily - font family
	 *          @param {string} theme.title.fontWeight - font weight
	 *          @param {string} theme.title.color - font color
	 *          @param {string} theme.title.background - background
	 *      @param {object} theme.yAxis - y axis theme
	 *          @param {object} theme.yAxis.title - theme for y axis title
	 *              @param {number} theme.yAxis.title.fontSize - font size
	 *              @param {string} theme.yAxis.title.fontFamily - font family
	 *              @param {string} theme.yAxis.title.fontWeight - font weight
	 *              @param {string} theme.yAxis.title.color - font color
	 *          @param {object} theme.yAxis.label - theme for y axis label
	 *              @param {number} theme.yAxis.label.fontSize - font size
	 *              @param {string} theme.yAxis.label.fontFamily - font family
	 *              @param {string} theme.yAxis.label.fontWeight - font weight
	 *              @param {string} theme.yAxis.label.color - font color
	 *          @param {string} theme.yAxis.tickColor - color for y axis tick
	 *      @param {object} theme.xAxis - theme for x axis
	 *          @param {object} theme.xAxis.title - theme for x axis title
	 *              @param {number} theme.xAxis.title.fontSize - font size
	 *              @param {string} theme.xAxis.title.fontFamily - font family
	 *              @param {string} theme.xAxis.title.fontWeight - font weight
	 *              @param {string} theme.xAxis.title.color - font color
	 *          @param {object} theme.xAxis.label - theme for x axis label
	 *              @param {number} theme.xAxis.label.fontSize - font size
	 *              @param {string} theme.xAxis.label.fontFamily - font family
	 *              @param {string} theme.xAxis.label.fontWeight - font weight
	 *              @param {string} theme.xAxis.label.color - font color
	 *          @param {string} theme.xAxis.tickColor - color for x axis tick
	 *      @param {object} theme.plot - theme for plot
	 *          @param {string} theme.plot.lineColor - line color
	 *          @param {string} theme.plot.background - background
	 *      @param {object} theme.series theme for series
	 *          @param {Array.<string>} theme.series.colors - colors
	 *          @param {string} theme.series.borderColor - border color
	 *          @param {string} theme.series.selectionColor - selection color
	 *          @param {string} theme.series.startColor - start color
	 *          @param {string} theme.series.endColor - end color
	 *          @param {string} theme.series.overColor - over color
	 *      @param {object} theme.legend - theme for legend
	 *          @param {object} theme.legend.label - theme for legend label
	 *              @param {number} theme.legend.label.fontSize - font size
	 *              @param {string} theme.legend.label.fontFamily - font family
	 *              @param {string} theme.legend.label.fontWeight - font family
	 *              @param {string} theme.legend.label.color - font color
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var theme = {
	 *   yAxis: {
	 *     tickColor: '#ccbd9a',
	 *       title: {
	 *         color: '#333333'
	 *       },
	 *       label: {
	 *         color: '#6f491d'
	 *       }
	 *     },
	 *     xAxis: {
	 *       tickColor: '#ccbd9a',
	 *       title: {
	 *         color: '#333333'
	 *       },
	 *       label: {
	 *         color: '#6f491d'
	 *       }
	 *     },
	 *     plot: {
	 *       lineColor: '#e5dbc4',
	 *       background: '#f6f1e5'
	 *     },
	 *     series: {
	 *       colors: ['#40abb4', '#e78a31', '#c1c452', '#795224', '#f5f5f5'],
	 *       borderColor: '#8e6535',
	 *       selectionColor: '#cccccc',
	 *       startColor: '#efefef',
	 *       endColor: 'blue',
	 *       overColor: 'yellow'
	 *     },
	 *     legend: {
	 *       label: {
	 *         color: '#6f491d'
	 *       }
	 *     }
	 *   };
	 * chart.registerTheme('newTheme', theme);
	 */
	function registerTheme(themeName, theme) {
	    themeManager.register(themeName, theme);
	}

	/**
	 * Register map.
	 * @memberof tui.chart
	 * @param {string} mapName map name
	 * @param {Array.<{code: string, name: string, path: string}>} data map data
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var data = [
	 *   {
	 *     code: 'KR',
	 *     name: 'South Korea',
	 *     path: 'M835.13,346.53L837.55,350.71...',
	 *     labelCoordinate: {
	 *       x: 0.6,
	 *       y: 0.7
	 *     }
	 *   },
	 *   //...
	 * ];
	 * chart.registerMap('newMap', data);
	 */
	function registerMap(mapName, data) {
	    mapManager.register(mapName, data);
	}

	/**
	 * Register graph plugin.
	 * @memberof tui.chart
	 * @param {string} libType type of graph library
	 * @param {object} plugin plugin to control library
	 * @param {function} getPaperCallback callback function for getting paper
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var pluginRaphael = {
	 *   bar: function() {} // Render class
	 * };
	 * tui.chart.registerPlugin('raphael', pluginRaphael);
	 */
	function registerPlugin(libType, plugin, getPaperCallback) {
	    pluginFactory.register(libType, plugin);
	    drawingToolPicker.addRendererType(libType, getPaperCallback);
	}

	module.exports = {
	    barChart: barChart,
	    columnChart: columnChart,
	    lineChart: lineChart,
	    areaChart: areaChart,
	    bubbleChart: bubbleChart,
	    scatterChart: scatterChart,
	    heatmapChart: heatmapChart,
	    treemapChart: treemapChart,
	    comboChart: comboChart,
	    pieChart: pieChart,
	    mapChart: mapChart,
	    radialChart: radialChart,
	    boxplotChart: boxplotChart,
	    bulletChart: bulletChart,
	    registerTheme: registerTheme,
	    registerMap: registerMap,
	    registerPlugin: registerPlugin
	};


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview  Chart factory play role register chart.
	 *                Also, you can get chart from this factory.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var rawDataHandler = __webpack_require__(31);
	var predicate = __webpack_require__(11);

	var charts = {};
	var factory = {
	    /**
	     * Find key for getting chart.
	     * @param {string} chartType - type of chart
	     * @param {{seriesAlias: ?object, series: object.<string, Array>}} rawData - raw data
	     * @returns {string}
	     * @private
	     */
	    _findKey: function(chartType, rawData) {
	        var key = null;
	        var chartTypeMap;

	        if (predicate.isComboChart(chartType)) {
	            chartTypeMap = rawDataHandler.getChartTypeMap(rawData);

	            if (chartTypeMap[chartConst.CHART_TYPE_COLUMN] && chartTypeMap[chartConst.CHART_TYPE_LINE]) {
	                key = chartConst.CHART_TYPE_COLUMN_LINE_COMBO;
	            } else if (chartTypeMap[chartConst.CHART_TYPE_LINE] && chartTypeMap[chartConst.CHART_TYPE_SCATTER]) {
	                key = chartConst.CHART_TYPE_LINE_SCATTER_COMBO;
	            } else if (chartTypeMap[chartConst.CHART_TYPE_AREA] && chartTypeMap[chartConst.CHART_TYPE_LINE]) {
	                key = chartConst.CHART_TYPE_LINE_AREA_COMBO;
	            } else if (chartTypeMap[chartConst.CHART_TYPE_PIE]) {
	                key = chartConst.CHART_TYPE_PIE_DONUT_COMBO;
	            }
	        } else {
	            key = chartType;
	        }

	        return key;
	    },

	    /**
	     * Get chart instance.
	     * @param {string} chartType chart type
	     * @param {object} rawData chart data
	     * @param {object} theme chart options
	     * @param {object} options chart options
	     * @returns {object} chart instance;
	     */
	    get: function(chartType, rawData, theme, options) {
	        var key = this._findKey(chartType, rawData);
	        var Chart = charts[key];
	        var chart;

	        if (!Chart) {
	            throw new Error('Not exist ' + chartType + ' chart.');
	        }

	        chart = new Chart(rawData, theme, options);

	        return chart;
	    },

	    /**
	     * Register chart.
	     * @param {string} chartType char type
	     * @param {class} ChartClass chart class
	     */
	    register: function(chartType, ChartClass) {
	        charts[chartType] = ChartClass;
	    }
	};

	module.exports = factory;


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Raw data handler.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var arrayUtil = __webpack_require__(10);
	var snippet = __webpack_require__(6);

	/**
	 * Raw data Handler.
	 * @module rawDataHandler
	 * @private */
	var rawDataHandler = {
	    /**
	     * Pick stacks.
	     * @param {Array.<{stack: string}>} seriesData - raw series data
	     * @param {boolean} [divergingOption] - diverging option
	     * @returns {Array.<string>} stacks
	     */
	    pickStacks: function(seriesData, divergingOption) {
	        var stacks, uniqStacks, filteredStack;

	        stacks = snippet.map(seriesData, function(seriesDatum) {
	            return seriesDatum.stack;
	        });

	        uniqStacks = arrayUtil.unique(stacks);

	        if (divergingOption) {
	            uniqStacks = uniqStacks.slice(0, 2);
	        }

	        filteredStack = snippet.filter(uniqStacks, function(stack) {
	            return !!stack;
	        });

	        if (filteredStack.length < uniqStacks.length) {
	            filteredStack.push(chartConst.DEFAULT_STACK);
	        }

	        return filteredStack;
	    },

	    /**
	     * Sort series data from stacks.
	     * @param {Array.<{stack: ?string}>} seriesData series data
	     * @param {Array.<string>} stacks stacks
	     * @returns {Array}
	     * @private
	     */
	    _sortSeriesData: function(seriesData, stacks) {
	        var newSeriesData = [];

	        if (!stacks) {
	            stacks = this.pickStacks(seriesData);
	        }

	        snippet.forEachArray(stacks, function(stack) {
	            var filtered = snippet.filter(seriesData, function(datum) {
	                return (datum.stack || chartConst.DEFAULT_STACK) === stack;
	            });
	            newSeriesData = newSeriesData.concat(filtered);
	        });

	        return newSeriesData;
	    },

	    /**
	     * Remove stack of series data.
	     * @param {Array.<{stack: ?string}>} seriesData series data
	     */
	    removeSeriesStack: function(seriesData) {
	        snippet.forEachArray(seriesData, function(datum) {
	            delete datum.stack;
	        });
	    },

	    /**
	     * Find char type from chart name.
	     * @param {object.<string, string>} seriesAlias - alias map
	     * @param {string} seriesType - series name
	     * @returns {*}
	     */
	    findChartType: function(seriesAlias, seriesType) {
	        var chartType;

	        if (seriesAlias) {
	            chartType = seriesAlias[seriesType];
	        }

	        return chartType || seriesType;
	    },

	    /**
	     * Get chart type map.
	     * @param {{series: (Array | object)}} rawData - raw data
	     * @returns {object.<string, string>}
	     */
	    getChartTypeMap: function(rawData) {
	        var self = this;
	        var chartTypeMap = {};

	        if (snippet.isObject(rawData.series)) {
	            snippet.forEach(rawData.series, function(data, seriesType) {
	                chartTypeMap[self.findChartType(rawData.seriesAlias, seriesType)] = true;
	            });
	        }

	        return chartTypeMap;
	    },

	    /**
	     * Create minus values.
	     * @param {Array.<number>} data number data
	     * @returns {Array} minus values
	     * @private
	     */
	    _createMinusValues: function(data) {
	        return snippet.map(data, function(value) {
	            return value < 0 ? 0 : -value;
	        });
	    },

	    /**
	     * Create plus values.
	     * @param {Array.<number>} data number data
	     * @returns {Array} plus values
	     * @private
	     */
	    _createPlusValues: function(data) {
	        return snippet.map(data, function(value) {
	            return value < 0 ? 0 : value;
	        });
	    },

	    /**
	     * Make normal diverging raw series data.
	     * @param {{data: Array.<number>}} rawSeriesData raw series data
	     * @returns {{data: Array.<number>}} changed raw series data
	     * @private
	     */
	    _makeNormalDivergingRawSeriesData: function(rawSeriesData) {
	        rawSeriesData.length = Math.min(rawSeriesData.length, 2);

	        rawSeriesData[0].data = this._createMinusValues(rawSeriesData[0].data);

	        if (rawSeriesData[1]) {
	            rawSeriesData[1].data = this._createPlusValues(rawSeriesData[1].data);
	        }

	        return rawSeriesData;
	    },

	    /**
	     * Make raw series data for stacked diverging option.
	     * @param {{data: Array.<number>, stack: string}} rawSeriesData raw series data
	     * @returns {{data: Array.<number>}} changed raw series data
	     * @private
	     */
	    _makeRawSeriesDataForStackedDiverging: function(rawSeriesData) {
	        var self = this;
	        var stacks = this.pickStacks(rawSeriesData, true);
	        var result = [];
	        var leftStack = stacks[0];
	        var rightStack = stacks[1];

	        rawSeriesData = this._sortSeriesData(rawSeriesData, stacks);

	        snippet.forEachArray(rawSeriesData, function(seriesDatum) {
	            var stack = seriesDatum.stack || chartConst.DEFAULT_STACK;
	            if (stack === leftStack) {
	                seriesDatum.data = self._createMinusValues(seriesDatum.data);
	                result.push(seriesDatum);
	            } else if (stack === rightStack) {
	                seriesDatum.data = self._createPlusValues(seriesDatum.data);
	                result.push(seriesDatum);
	            }
	        });

	        return result;
	    },

	    /**
	     * Make raw series data for diverging.
	     * @param {{data: Array.<number>, stack: string}} rawSeriesData raw series data
	     * @param {?string} stackTypeOption stackType option
	     * @returns {{data: Array.<number>}} changed raw series data
	     * @private
	     */
	    _makeRawSeriesDataForDiverging: function(rawSeriesData, stackTypeOption) {
	        if (predicate.isValidStackOption(stackTypeOption)) {
	            rawSeriesData = this._makeRawSeriesDataForStackedDiverging(rawSeriesData);
	        } else {
	            rawSeriesData = this._makeNormalDivergingRawSeriesData(rawSeriesData);
	        }

	        return rawSeriesData;
	    },

	    /**
	     * Update raw series data by options.
	     * @param {object} rawData - raw data
	     * @param {{stackType: ?string, diverging: ?boolean}} seriesOptions - series options
	     */
	    updateRawSeriesDataByOptions: function(rawData, seriesOptions) {
	        var self = this;

	        seriesOptions = seriesOptions || {};

	        if (predicate.isValidStackOption(seriesOptions.stackType)) {
	            snippet.forEach(rawData.series, function(seriesDatum, seriesType) {
	                rawData.series[seriesType] = self._sortSeriesData(rawData.series[seriesType]);
	            });
	        }

	        if (seriesOptions.diverging) {
	            snippet.forEach(rawData.series, function(seriesDatum, seriesType) {
	                rawData.series[seriesType] = self._makeRawSeriesDataForDiverging(seriesDatum, seriesOptions.stackType);
	            });
	        }
	    },

	    /**
	     * Append outlier value to boxplot series data end
	     * @param {object} rawData - raw data
	     */
	    appendOutliersToSeriesData: function(rawData) {
	        var boxplot = rawData.series.boxplot;
	        snippet.forEach(boxplot, function(seriesItem) {
	            var outliers = seriesItem.outliers;

	            if (outliers && outliers.length) {
	                snippet.forEach(outliers, function(outlier) {
	                    seriesItem.data[outlier[0]].push(outlier[1]);
	                });
	            }
	        });
	    },

	    /**
	     * Filter raw data belong to checked legend.
	     * @param {object} rawData raw data
	     * @param {Array.<?boolean> | {line: ?Array.<boolean>, column: ?Array.<boolean>}} checkedLegends checked legends
	     * @returns {object} rawData
	     */
	    filterCheckedRawData: function(rawData, checkedLegends) {
	        var cloneData = JSON.parse(JSON.stringify(rawData));
	        var filteredCategories;

	        if (checkedLegends) {
	            snippet.forEach(cloneData.series, function(serieses, chartType) {
	                if (!checkedLegends[chartType]) {
	                    cloneData.series[chartType] = [];
	                } else if (checkedLegends[chartType].length) {
	                    cloneData.series[chartType] = snippet.filter(serieses, function(series, index) {
	                        return checkedLegends[chartType][index];
	                    });
	                }
	            });
	        }

	        if (cloneData.series.bullet) {
	            filteredCategories = [];
	            snippet.forEach(checkedLegends.bullet, function(isChecked, index) {
	                if (isChecked) {
	                    filteredCategories.push(rawData.categories[index]);
	                }
	            });
	            cloneData.categories = filteredCategories;
	        }

	        return cloneData;
	    },

	    /**
	     * Modify rawData to fit chart format
	     * @param {object} rawData - raw data
	     * @private
	     */
	    _makeRawSeriesDataForBulletChart: function(rawData) {
	        var bullet = rawData.series.bullet;

	        rawData.categories = rawData.categories || [];

	        rawData.categories = snippet.map(bullet, function(seriesData) {
	            return seriesData.name || '';
	        });
	    }
	};

	module.exports = rawDataHandler;


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview  Plugin factory play role register rendering plugin.
	 *                Also, you can get plugin from this factory.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);

	var plugins = {},
	    factory = {
	        /**
	         * Get graph renderer.
	         * @param {string} libType type of graph library
	         * @param {string} chartType chart type
	         * @returns {object} renderer instance
	         */
	        get: function(libType, chartType) {
	            var plugin = plugins[libType || chartConst.DEFAULT_PLUGIN],
	                Renderer, renderer;

	            if (!plugin) {
	                throw new Error('Not exist ' + libType + ' plugin.');
	            }

	            Renderer = plugin[chartType];
	            if (!Renderer) {
	                throw new Error('Not exist ' + chartType + ' chart renderer.');
	            }

	            renderer = new Renderer();

	            return renderer;
	        },
	        /**
	         * Plugin register.
	         * @param {string} libType type of graph library
	         * @param {object} plugin plugin to control library
	         */
	        register: function(libType, plugin) {
	            plugins[libType] = plugin;
	        }
	    };

	module.exports = factory;


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @Fileoverview  Theme manager.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var defaultTheme = __webpack_require__(34);
	var snippet = __webpack_require__(6);

	var themes = {};

	module.exports = {
	    /**
	     * Theme register.
	     * @param {string} themeName theme name
	     * @param {object} theme theme
	     */
	    register: function(themeName, theme) {
	        theme = JSON.parse(JSON.stringify(theme));
	        themes[themeName] = theme;
	    },

	    /**
	     * Pick series types from raw series data.
	     * @param {string} chartType - chart type
	     * @param {object} rawSeriesData - raw series data
	     * @returns {Array}
	     * @private
	     */
	    _pickSeriesNames: function(chartType, rawSeriesData) {
	        var seriesTypes = [];
	        if (predicate.isComboChart(chartType)) {
	            snippet.forEach(rawSeriesData, function(data, seriesType) {
	                seriesTypes.push(seriesType);
	            });
	        } else {
	            seriesTypes.push(chartType);
	        }

	        return seriesTypes;
	    },

	    /**
	     * Overwrite theme
	     * @param {object} fromTheme - from theme
	     * @param {object} toTheme - to theme
	     * @private
	     */
	    _overwriteTheme: function(fromTheme, toTheme) {
	        var self = this;

	        snippet.forEach(toTheme, function(item, key) {
	            var fromItem = fromTheme[key];
	            if (!fromItem && fromItem !== 0) {
	                return;
	            }

	            if (snippet.isArray(fromItem)) {
	                toTheme[key] = fromItem.slice();
	            } else if (snippet.isObject(fromItem)) {
	                self._overwriteTheme(fromItem, item);
	            } else {
	                toTheme[key] = fromItem;
	            }
	        });
	    },

	    /**
	     * Pick valid theme properties.
	     * @param {object} theme - theme
	     * @param {string} componentType - component type (series or yAxis)
	     * @returns {object}
	     * @private
	     */
	    _pickValidTheme: function(theme, componentType) {
	        var validTheme = {};

	        snippet.forEachArray(chartConst.THEME_PROPS_MAP[componentType], function(propName) {
	            if (snippet.isExisty(theme[propName])) {
	                validTheme[propName] = theme[propName];
	            }
	        });

	        return validTheme;
	    },

	    /**
	     * Create component theme with series name
	     * @param {Array.<string>} seriesTypes - series types
	     * @param {object} fromTheme - from theme
	     * @param {object} toTheme - to theme
	     * @param {string} componentType - component type
	     * @returns {object}
	     * @private
	     */
	    _createComponentThemeWithSeriesName: function(seriesTypes, fromTheme, toTheme, componentType) {
	        var self = this;
	        var newTheme = {};

	        fromTheme = fromTheme || {};

	        snippet.forEachArray(seriesTypes, function(seriesType) {
	            var theme = fromTheme[seriesType] || self._pickValidTheme(fromTheme, componentType);

	            if (snippet.keys(theme).length) {
	                newTheme[seriesType] = JSON.parse(JSON.stringify(defaultTheme[componentType]));
	                self._overwriteTheme(theme, newTheme[seriesType]);
	            } else {
	                newTheme[seriesType] = JSON.parse(JSON.stringify(toTheme));
	            }
	        });

	        return newTheme;
	    },

	    /**
	     * Make each series's color
	     * @param {Array.<string>} themeColors Theme colors to use
	     * @param {number} seriesCount Series count
	     * @param {number} startColorIndex Start color index
	     * @returns {Array.<string>} colors
	     */
	    _makeEachSeriesColors: function(themeColors, seriesCount, startColorIndex) {
	        var colors = [];
	        var themeColorsLen = themeColors.length;
	        var colorIndex = startColorIndex || 0;
	        var i;

	        for (i = 0; i < seriesCount; i += 1) {
	            colors.push(themeColors[colorIndex]);

	            colorIndex += 1;

	            if (colorIndex >= themeColorsLen) {
	                colorIndex = 0;
	            }
	        }

	        return colors;
	    },

	    /**
	     * Set series colors theme.
	     * @param {Array.<string>} seriesTypes - series type
	     * @param {object} seriesThemes - series theme map
	     * @param {object} rawSeriesThemes - raw series theme map
	     * @param {object} rawSeriesData - raw series data
	     * @private
	     */
	    _setSeriesColors: function(seriesTypes, seriesThemes, rawSeriesThemes, rawSeriesData) {
	        var seriesColors, seriesCount, hasOwnColors;
	        var colorIndex = 0;

	        rawSeriesThemes = rawSeriesThemes || {}; // to simplify if/else statement

	        snippet.forEachArray(seriesTypes, function(seriesType) {
	            if (rawSeriesThemes[seriesType]) {
	                seriesColors = rawSeriesThemes[seriesType].colors;
	                hasOwnColors = true;
	            } else {
	                seriesColors = rawSeriesThemes.colors || defaultTheme.series.colors;
	                hasOwnColors = false;
	            }

	            seriesCount = this._getSeriesThemeColorCount(rawSeriesData[seriesType]);

	            seriesThemes[seriesType].colors = this._makeEachSeriesColors(seriesColors, seriesCount,
	                !hasOwnColors && colorIndex);

	            // To distinct between series that use default theme, we make the colors different
	            if (!hasOwnColors) {
	                colorIndex = (seriesCount + colorIndex) % seriesColors.length;
	            }
	        }, this);
	    },

	    /**
	     * Get number of series theme color from seriesData
	     * @param {object} rawSeriesDatum - raw series data contains series information
	     * @returns {number} number of series theme color
	     * @private
	     */
	    _getSeriesThemeColorCount: function(rawSeriesDatum) {
	        var seriesCount = 0;

	        if (rawSeriesDatum && rawSeriesDatum.length) {
	            if (rawSeriesDatum.colorLength) {
	                seriesCount = rawSeriesDatum.colorLength;
	            } else if (rawSeriesDatum[0] && rawSeriesDatum[0].data && rawSeriesDatum[0].data.length) {
	                seriesCount = Math.max(rawSeriesDatum.length, rawSeriesDatum[0].data.length);
	            } else {
	                seriesCount = rawSeriesDatum.length;
	            }
	        }

	        return seriesCount;
	    },

	    /**
	     * Init theme.
	     * @param {string} themeName - theme name
	     * @param {object} rawTheme - raw theme
	     * @param {Array.<string>} seriesTypes - series types
	     * @param {object} rawSeriesData - raw series data
	     * @returns {object}
	     * @private
	     * @ignore
	     */
	    _initTheme: function(themeName, rawTheme, seriesTypes, rawSeriesData) {
	        var theme;

	        if (themeName !== chartConst.DEFAULT_THEME_NAME) { // customized theme that overrides default theme
	            theme = JSON.parse(JSON.stringify(defaultTheme));
	            this._overwriteTheme(rawTheme, theme);
	        } else { // default theme
	            theme = JSON.parse(JSON.stringify(rawTheme));
	        }

	        // make each component theme have theme by series name. theme.yAxis.theme -> theme.yAxis.line.theme
	        theme.yAxis = this._createComponentThemeWithSeriesName(seriesTypes, rawTheme.yAxis, theme.yAxis, 'yAxis');
	        theme.series = this._createComponentThemeWithSeriesName(seriesTypes, rawTheme.series, theme.series, 'series');

	        this._setSeriesColors(seriesTypes, theme.series, rawTheme.series, rawSeriesData);

	        return theme;
	    },

	    /**
	     * Create target themes for font inherit.
	     * @param {object} theme - theme
	     * @returns {Array.<object>}
	     * @private
	     */
	    _createTargetThemesForFontInherit: function(theme) {
	        var items = [
	            theme.title,
	            theme.xAxis.title,
	            theme.xAxis.label,
	            theme.legend.label,
	            theme.plot.label
	        ];

	        snippet.forEach(theme.yAxis, function(_theme) {
	            items.push(_theme.title, _theme.label);
	        });

	        snippet.forEach(theme.series, function(_theme) {
	            items.push(_theme.label);
	        });

	        return items;
	    },

	    /**
	     * Inherit theme font.
	     * @param {object} theme theme
	     * @private
	     */
	    _inheritThemeFont: function(theme) {
	        var targetThemes = this._createTargetThemesForFontInherit(theme);
	        var baseFont = theme.chart.fontFamily;

	        snippet.forEachArray(targetThemes, function(item) {
	            if (!item.fontFamily) {
	                item.fontFamily = baseFont;
	            }
	        });
	    },

	    /**
	     * Copy color theme to otherTheme from seriesTheme.
	     * @param {object} seriesTheme - series theme
	     * @param {object} otherTheme - other theme
	     * @param {object} seriesType - series name
	     * @private
	     */
	    _copySeriesColorTheme: function(seriesTheme, otherTheme, seriesType) {
	        otherTheme[seriesType] = {
	            colors: seriesTheme.colors,
	            borderColor: seriesTheme.borderColor,
	            selectionColor: seriesTheme.selectionColor
	        };
	    },

	    /**
	     * Copy series color theme to other components.
	     * @param {object} theme theme
	     * @private
	     * @ignore
	     */
	    _copySeriesColorThemeToOther: function(theme) {
	        var self = this;

	        snippet.forEach(theme.series, function(seriesTheme, seriesType) {
	            self._copySeriesColorTheme(seriesTheme, theme.legend, seriesType);
	            self._copySeriesColorTheme(seriesTheme, theme.tooltip, seriesType);
	        });
	    },

	    /**
	     * Get theme.
	     * @param {string} themeName - theme name
	     * @param {string} chartType - chart type
	     * @param {object} rawSeriesData - raw series data
	     * @returns {object}
	     */
	    get: function(themeName, chartType, rawSeriesData) {
	        var rawTheme = themes[themeName];
	        var theme, seriesTypes;

	        if (!rawTheme) {
	            throw new Error('Not exist ' + themeName + ' theme.');
	        }

	        seriesTypes = this._pickSeriesNames(chartType, rawSeriesData);

	        theme = this._initTheme(themeName, rawTheme, seriesTypes, rawSeriesData);

	        this._inheritThemeFont(theme, seriesTypes);
	        this._copySeriesColorThemeToOther(theme);

	        return theme;
	    }
	};


/***/ }),
/* 34 */
/***/ (function(module, exports) {

	'use strict';

	var DEFAULT_COLOR = '#000000';
	var DEFAULT_BACKGROUND = '#ffffff';
	var DEFAULT_FONTWEIGHT = 'normal';
	var EMPTY = '';
	var DEFAULT_AXIS = {
	    tickColor: DEFAULT_COLOR,
	    title: {
	        fontSize: 12,
	        fontFamily: EMPTY,
	        color: DEFAULT_COLOR,
	        fontWeight: DEFAULT_FONTWEIGHT
	    },
	    label: {
	        fontSize: 12,
	        fontFamily: EMPTY,
	        color: DEFAULT_COLOR,
	        fontWeight: DEFAULT_FONTWEIGHT
	    }
	};

	var defaultTheme = {
	    chart: {
	        background: {
	            color: DEFAULT_BACKGROUND,
	            opacity: 1
	        },
	        fontFamily: 'Verdana'
	    },
	    title: {
	        fontSize: 18,
	        fontFamily: EMPTY,
	        color: DEFAULT_COLOR,
	        fontWeight: DEFAULT_FONTWEIGHT
	    },
	    yAxis: DEFAULT_AXIS,
	    xAxis: DEFAULT_AXIS,
	    plot: {
	        lineColor: '#dddddd',
	        background: '#ffffff',
	        label: {
	            fontSize: 11,
	            fontFamily: EMPTY,
	            color: '#888'
	        }
	    },
	    series: {
	        label: {
	            fontSize: 11,
	            fontFamily: EMPTY,
	            color: DEFAULT_COLOR,
	            fontWeight: DEFAULT_FONTWEIGHT
	        },
	        colors: ['#ac4142', '#d28445', '#f4bf75', '#90a959', '#75b5aa', '#6a9fb5', '#aa759f', '#8f5536'],
	        borderColor: EMPTY,
	        borderWidth: EMPTY,
	        selectionColor: EMPTY,
	        startColor: '#F4F4F4',
	        endColor: '#345391',
	        overColor: '#F0C952',
	        dot: {
	            fillColor: EMPTY,
	            fillOpacity: 1,
	            strokeColor: EMPTY,
	            strokeOpacity: 1,
	            strokeWidth: 2,
	            radius: 2,
	            hover: {
	                fillColor: EMPTY,
	                fillOpacity: 1,
	                strokeColor: EMPTY,
	                strokeOpacity: 0.8,
	                strokeWidth: 3,
	                radius: 4
	            }
	        },
	        ranges: []
	    },
	    legend: {
	        label: {
	            fontSize: 12,
	            fontFamily: EMPTY,
	            color: DEFAULT_COLOR,
	            fontWeight: DEFAULT_FONTWEIGHT
	        }
	    },
	    tooltip: {},
	    chartExportMenu: {
	        backgroundColor: '#fff',
	        borderRadius: 0,
	        borderWidth: 1,
	        color: '#000'
	    }
	};

	module.exports = defaultTheme;


/***/ }),
/* 35 */
/***/ (function(module, exports) {

	/**
	 * @fileoverview  Map Manager.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var maps = {};

	module.exports = {
	    /**
	     * Get map data.
	     * @param {string} mapName map name
	     * @returns {Array} map data
	     */
	    get: function(mapName) {
	        var data = maps[mapName];

	        if (!data) {
	            throw new Error('Not exist ' + mapName + ' map.');
	        }

	        return data;
	    },

	    /**
	     * Register Map.
	     * @param {string} mapName map name
	     * @param {Array} data map data
	     */
	    register: function(mapName, data) {
	        maps[mapName] = data;
	    }
	};


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview util for object
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);

	/**
	 * Deep copy.
	 * @memberOf module:objectUtil
	 * @param {object|Array|*} origin - original data
	 * @returns {*}
	 */
	var deepCopy = function(origin) {
	    var clone;

	    if (snippet.isArray(origin)) {
	        clone = [];
	        snippet.forEachArray(origin, function(value, index) {
	            clone[index] = deepCopy(value);
	        });
	    } else if (snippet.isFunction(origin) || snippet.isDate(origin)) {
	        clone = origin;
	    } else if (snippet.isObject(origin)) {
	        clone = {};
	        snippet.forEach(origin, function(value, key) {
	            clone[key] = deepCopy(value);
	        });
	    } else {
	        clone = origin;
	    }

	    return clone;
	};

	/**
	 * util for object
	 * @module objectUtil
	 * @private */
	var objectUtil = {
	    deepCopy: deepCopy
	};

	module.exports = objectUtil;


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileOverview Series data importer
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var arrayUtil = __webpack_require__(10);
	var snippet = __webpack_require__(6);

	/**
	 * Get series data from 2D array
	 * @param {Array.<Array>} table2DArray - extracted 2DArray from table element
	 * @returns {{
	 *     series: Array.<object>,
	 *     categories: Array.<string>
	 *         }}
	 * @private
	 */
	function getChartDataFrom2DArray(table2DArray) {
	    var chartData;

	    if (table2DArray.length > 0) {
	        chartData = {};
	        chartData.categories = [];
	        chartData.series = [];

	        chartData.categories = table2DArray.shift().slice(1);
	        snippet.forEach(table2DArray, function(tr) {
	            var seriesDatum = {};

	            seriesDatum.name = tr[0];
	            seriesDatum.data = tr.slice(1);

	            chartData.series.push(seriesDatum);
	        });
	    }

	    return chartData;
	}

	/**
	 * Get pivoted second dimension array from table to use element.innerText
	 * @param {HTMLElement} tableElement - table element for extract chart's raw data
	 * @returns {Array.<Array>}
	 * @private
	 */
	function get2DArray(tableElement) {
	    var trs = [];
	    var secondDimensionArray = [];
	    var resultArray = [];

	    if (tableElement) {
	        trs = snippet.toArray(tableElement.getElementsByTagName('TR'));

	        snippet.forEach(trs, function(tr, index) {
	            var tagName = index === 0 ? 'TH' : 'TD';
	            var cells = snippet.toArray(tr.getElementsByTagName(tagName));
	            var rows = snippet.pluck(cells, 'innerText');

	            secondDimensionArray.push(rows);
	        });

	        if (secondDimensionArray[0].length < secondDimensionArray[1].length) {
	            secondDimensionArray[0].unshift('');
	        }

	        resultArray = arrayUtil.pivot(secondDimensionArray);
	    }

	    return resultArray;
	}

	/**
	 * Make chart data with table element
	 * @param {({
	 *     elementId:string
	 * }|{
	 *     element:HTMLElement
	 * })} table - object for table data import
	 * @returns {rawData}
	 * @ignore
	 * @api
	 */
	function makeDataWithTable(table) {
	    var element, chartData;

	    if (table.element && table.element.tagName === 'TABLE') {
	        element = table.element;
	    } else if (table.elementId) {
	        element = document.getElementById(table.elementId);
	    }

	    chartData = getChartDataFrom2DArray(get2DArray(element));

	    return chartData;
	}

	module.exports = {
	    makeDataWithTable: makeDataWithTable
	};


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';

	var dom = __webpack_require__(9);
	var snippet = __webpack_require__(6);

	/**
	 * Get raphael paper
	 * @param {HTMLElement} container container element
	 * @param {{width:number, height:number}} dimension dimension
	 * @returns {object}
	 * @private
	 */

	/**
	 * Renderers
	 * @type {object}
	 * @ignore
	 */
	var renderers = {
	    DOM: function(container) {
	        var paper = dom.create('DIV');
	        dom.append(container, paper);

	        return paper;
	    }
	};

	var DrawingToolPicker = snippet.defineClass({
	    /**
	     * DrawingToolPicker initializer
	     * @param {{width:number, height:number}} dimension dimension
	     * @ignore
	     */
	    initDimension: function(dimension) {
	        this.dimension = dimension;
	    },

	    /**
	     * Get drawing tool paper
	     * @param {HTMLElement} container container element
	     * @param {string} rendererType component renderer type
	     * @returns {HTMLElement|object}
	     * @ignore
	     */
	    getPaper: function(container, rendererType) {
	        var paper = this[rendererType + 'Paper'];
	        var isNeedCreateNewPaper = snippet.isExisty(container)
	            && paper && dom.findParentByClass(paper.canvas, 'tui-chart') !== container;

	        if (!paper || isNeedCreateNewPaper) {
	            paper = renderers[rendererType].call(this, container, this.dimension);

	            if (rendererType !== 'DOM') {
	                this[rendererType + 'Paper'] = paper;
	            }
	        }

	        return paper;
	    }
	});

	/**
	 * Add renderer type
	 * @param {string} componentType component renderer type
	 * @param {function} callback callback function for get renderer's paper
	 */
	DrawingToolPicker.addRendererType = function(componentType, callback) {
	    renderers[componentType] = callback;
	};

	module.exports = DrawingToolPicker;


/***/ }),
/* 39 */
/***/ (function(module, exports) {

	// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/JSON
	// Any copyright is dedicated to the Public Domain. http://creativecommons.org/publicdomain/zero/1.0/
	if (!window.JSON) {
	    window.JSON = {
	        parse: function(sJSON) { return eval('(' + sJSON + ')'); },
	        stringify: (function () {
	            var toString = Object.prototype.toString;
	            var isArray = Array.isArray || function (a) { return toString.call(a) === '[object Array]'; };
	            var escMap = {'"': '\\"', '\\': '\\\\', '\b': '\\b', '\f': '\\f', '\n': '\\n', '\r': '\\r', '\t': '\\t'};
	            var escFunc = function (m) { return escMap[m] || '\\u' + (m.charCodeAt(0) + 0x10000).toString(16).substr(1); };
	            var escRE = /[\\"\u0000-\u001F\u2028\u2029]/g;
	            return function stringify(value) {
	                if (value == null) {
	                    return 'null';
	                } else if (typeof value === 'number') {
	                    return isFinite(value) ? value.toString() : 'null';
	                } else if (typeof value === 'boolean') {
	                    return value.toString();
	                } else if (typeof value === 'object') {
	                    if (typeof value.toJSON === 'function') {
	                        return stringify(value.toJSON());
	                    } else if (isArray(value)) {
	                        var res = '[';
	                        for (var i = 0; i < value.length; i++)
	                            res += (i ? ', ' : '') + stringify(value[i]);
	                        return res + ']';
	                    } else if (toString.call(value) === '[object Object]') {
	                        var tmp = [];
	                        for (var k in value) {
	                            if (value.hasOwnProperty(k))
	                                tmp.push(stringify(k) + ': ' + stringify(value[k]));
	                        }
	                        return '{' + tmp.join(', ') + '}';
	                    }
	                }
	                return '"' + value.toString().replace(escRE, escFunc) + '"';
	            };
	        })()
	    };
	}

	// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/create
	// Any copyright is dedicated to the Public Domain. http://creativecommons.org/publicdomain/zero/1.0/
	if (typeof Object.create != 'function') {
	    Object.create = (function(undefined) {
	        var Temp = function() {};
	        return function (prototype, propertiesObject) {
	            if(prototype !== Object(prototype) && prototype !== null) {
	                throw TypeError('Argument must be an object, or null');
	            }
	            Temp.prototype = prototype || {};
	            if (propertiesObject !== undefined) {
	                Object.defineProperties(Temp.prototype, propertiesObject);
	            }
	            var result = new Temp();
	            Temp.prototype = null;
	            // to imitate the case of Object.create(null)
	            if(prototype === null) {
	                result.__proto__ = null;
	            }
	            return result;
	        };
	    })();
	}

	// http://paulirish.com/2011/requestanimationframe-for-smart-animating/
	// http://my.opera.com/emoller/blog/2011/12/20/requestanimationframe-for-smart-er-animating
	// requestAnimationFrame polyfill by Erik Möller. fixes from Paul Irish and Tino Zijdel
	// MIT license

	(function () {
	    var lastTime = 0;
	    var vendors = ['ms', 'moz', 'webkit', 'o'];
	    for (var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
	        window.requestAnimationFrame = window[vendors[x] + 'RequestAnimationFrame'];
	        window.cancelAnimationFrame = window[vendors[x] + 'CancelAnimationFrame']
	            || window[vendors[x] + 'CancelRequestAnimationFrame'];
	    }

	    if (!window.requestAnimationFrame) {
	        window.requestAnimationFrame = function (callback) {
	            var currTime = new Date().getTime();
	            var timeToCall = Math.max(0, 16 - (currTime - lastTime));
	            var id = window.setTimeout(function () {
	                    callback(currTime + timeToCall);
	                },
	                timeToCall);
	            lastTime = currTime + timeToCall;
	            return id;
	        };
	    }

	    if (!window.cancelAnimationFrame) {
	        window.cancelAnimationFrame = function (id) {
	            clearTimeout(id);
	        };
	    }
	}());


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';

	var chartConst = __webpack_require__(8);
	var chartFactory = __webpack_require__(30);
	var BarChart = __webpack_require__(41);
	var ColumnChart = __webpack_require__(124);
	var LineChart = __webpack_require__(125);
	var AreaChart = __webpack_require__(127);
	var ColumnLineComboChart = __webpack_require__(128);
	var LineScatterComboChart = __webpack_require__(130);
	var LineAreaComboChart = __webpack_require__(131);
	var PieDonutComboChart = __webpack_require__(132);
	var PieChart = __webpack_require__(133);
	var BubbleChart = __webpack_require__(134);
	var ScatterChart = __webpack_require__(135);
	var HeatmapChart = __webpack_require__(136);
	var TreemapChart = __webpack_require__(139);
	var MapChart = __webpack_require__(140);
	var RadialChart = __webpack_require__(143);
	var BoxplotChart = __webpack_require__(144);
	var BulletChart = __webpack_require__(145);

	chartFactory.register(chartConst.CHART_TYPE_BAR, BarChart);
	chartFactory.register(chartConst.CHART_TYPE_COLUMN, ColumnChart);
	chartFactory.register(chartConst.CHART_TYPE_LINE, LineChart);
	chartFactory.register(chartConst.CHART_TYPE_AREA, AreaChart);
	chartFactory.register(chartConst.CHART_TYPE_COLUMN_LINE_COMBO, ColumnLineComboChart);
	chartFactory.register(chartConst.CHART_TYPE_LINE_SCATTER_COMBO, LineScatterComboChart);
	chartFactory.register(chartConst.CHART_TYPE_LINE_AREA_COMBO, LineAreaComboChart);
	chartFactory.register(chartConst.CHART_TYPE_PIE_DONUT_COMBO, PieDonutComboChart);
	chartFactory.register(chartConst.CHART_TYPE_PIE, PieChart);
	chartFactory.register(chartConst.CHART_TYPE_BUBBLE, BubbleChart);
	chartFactory.register(chartConst.CHART_TYPE_SCATTER, ScatterChart);
	chartFactory.register(chartConst.CHART_TYPE_HEATMAP, HeatmapChart);
	chartFactory.register(chartConst.CHART_TYPE_TREEMAP, TreemapChart);
	chartFactory.register(chartConst.CHART_TYPE_MAP, MapChart);
	chartFactory.register(chartConst.CHART_TYPE_RADIAL, RadialChart);
	chartFactory.register(chartConst.CHART_TYPE_BOXPLOT, BoxplotChart);
	chartFactory.register(chartConst.CHART_TYPE_BULLET, BulletChart);


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Bar chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var ChartBase = __webpack_require__(42);
	var chartConst = __webpack_require__(8);
	var rawDataHandler = __webpack_require__(31);
	var predicate = __webpack_require__(11);
	var snippet = __webpack_require__(6);

	var BarChart = snippet.defineClass(ChartBase, /** @lends BarChart.prototype */ {
	    /**
	     * className
	     * @type {string}
	     */
	    className: 'tui-bar-chart',
	    /**
	     * Bar chart.
	     * @constructs BarChart
	     * @extends ChartBase
	     * @mixes axisTypeMixer
	     * @param {Array.<Array>} rawData raw data
	     * @param {object} theme chart theme
	     * @param {object} options chart options
	     */
	    init: function(rawData, theme, options) {
	        rawDataHandler.updateRawSeriesDataByOptions(rawData, options.series);
	        this._updateOptionsRelatedDiverging(options);

	        ChartBase.call(this, {
	            rawData: rawData,
	            theme: theme,
	            options: options,
	            hasAxes: true
	        });
	    },

	    /**
	     * Update options related diverging option.
	     * @param {object} options - options
	     * @private
	     */
	    _updateOptionsRelatedDiverging: function(options) {
	        var isCenter;

	        options.series = options.series || {};

	        /**
	         * Whether has right y axis or not.
	         * @type {boolean}
	         */
	        this.hasRightYAxis = false;

	        if (options.series.diverging) {
	            options.yAxis = options.yAxis || {};
	            options.xAxis = options.xAxis || {};
	            options.plot = options.plot || {};

	            options.series.stackType = options.series.stackType || chartConst.NORMAL_STACK_TYPE;
	            this.hasRightYAxis = snippet.isArray(options.yAxis) && options.yAxis.length > 1;

	            isCenter = predicate.isYAxisAlignCenter(this.hasRightYAxis, options.yAxis.align);

	            options.yAxis.isCenter = isCenter;
	            options.xAxis.divided = isCenter;
	            options.series.divided = isCenter;
	            options.plot.divided = isCenter;
	        }
	    },

	    /**
	     * Add components
	     * @override
	     */
	    addComponents: function() {
	        this.componentManager.register('title', 'title');
	        this.componentManager.register('plot', 'plot');
	        this.componentManager.register('legend', 'legend');

	        this.componentManager.register('barSeries', 'barSeries');

	        this.componentManager.register('yAxis', 'axis');
	        this.componentManager.register('xAxis', 'axis');

	        if (this.hasRightYAxis) {
	            this.componentManager.register('rightYAxis', 'axis');
	        }

	        this.componentManager.register('chartExportMenu', 'chartExportMenu');
	        this.componentManager.register('tooltip', 'tooltip');
	        this.componentManager.register('mouseEventDetector', 'mouseEventDetector');
	    },

	    /**
	     * Get scale option.
	     * @returns {{xAxis: boolean}}
	     * @override
	     */
	    getScaleOption: function() {
	        return {
	            xAxis: true
	        };
	    },

	    /**
	     * On change selected legend.
	     * @param {Array.<?boolean> | {line: ?Array.<boolean>, column: ?Array.<boolean>}} checkedLegends checked legends
	     */
	    onChangeCheckedLegends: function(checkedLegends) {
	        var boundParams;

	        if (this.hasRightYAxis) {
	            boundParams = {
	                optionChartTypes: ['bar', 'bar']
	            };
	        }
	        ChartBase.prototype.onChangeCheckedLegends.call(this, checkedLegends, null, boundParams);
	    },
	    /**
	     * Add data ratios.
	     * @override
	     * modified from axisTypeMixer
	     */
	    addDataRatios: function(limitMap) {
	        var seriesOption = this.options.series || {};
	        var chartType = this.chartType;
	        var stackType = (seriesOption[chartType] || seriesOption).stackType;

	        this.dataProcessor.addDataRatios(limitMap[chartType], stackType, chartType);
	    }
	});

	module.exports = BarChart;


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview ChartBase
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var ComponentManager = __webpack_require__(43);
	var DefaultDataProcessor = __webpack_require__(101);
	var rawDataHandler = __webpack_require__(31);
	var dom = __webpack_require__(9);
	var renderUtil = __webpack_require__(7);
	var boundsAndScaleBuilder = __webpack_require__(112);
	var predicate = __webpack_require__(11);
	var snippet = __webpack_require__(6);

	var ChartBase = snippet.defineClass(/** @lends ChartBase.prototype */ {
	    /**
	     * Chart base.
	     * @constructs ChartBase
	     * @param {object} params parameters
	     *      @param {object} params.rawData raw data
	     *      @param {object} params.theme chart theme
	     *      @param {object} params.options chart options
	     *      @param {boolean} params.hasAxes whether has axes or not
	     *      @param {boolean} params.isVertical whether vertical or not
	     *      @param {DataProcessor} params.DataProcessor DataProcessor
	     */
	    init: function(params) {
	        /**
	         * theme
	         * @type {object}
	         */
	        this.theme = params.theme;

	        this._initializeOptions(params.options);

	        /**
	         * chart type
	         * @type {string}
	         */
	        this.chartType = this.options.chartType;

	        /**
	         * whether chart has axes or not
	         * @type {boolean}
	         */
	        this.hasAxes = params.hasAxes;

	        /**
	         * whether vertical or not
	         * @type {boolean}
	         */
	        this.isVertical = !!params.isVertical;

	        /**
	         * data processor
	         * @type {DataProcessor}
	         */
	        this.dataProcessor = this._createDataProcessor(params);

	        /**
	         * event bus for transmitting message
	         * @type {object}
	         */
	        this.eventBus = new snippet.CustomEvents();

	        /**
	         * previous xAxis data
	         * @type {null|object}
	         */
	        this.prevXAxisData = null;

	        /**
	         * component manager
	         * @type {ComponentManager}
	         */
	        this.componentManager = this._createComponentManager();

	        this.addComponents();

	        this._attachToEventBus();
	    },

	    /**
	     * Attach to event bus.
	     * @private
	     */
	    _attachToEventBus: function() {
	        this.eventBus.on('changeCheckedLegends', this.onChangeCheckedLegends, this);

	        if (this.onZoom) {
	            this.eventBus.on({
	                zoom: this.onZoom,
	                resetZoom: this.onResetZoom
	            }, this);
	        }
	    },

	    /**
	     * Set offset property
	     * @param {{offset: object}} options - options
	     * @param {string} fromProperty - from property name
	     * @param {string} toProperty - to property name
	     * @private
	     */
	    _setOffsetProperty: function(options, fromProperty, toProperty) {
	        if (!snippet.isExisty(options[fromProperty])) {
	            return;
	        }

	        options.offset = options.offset || {};
	        options.offset[toProperty] = options[fromProperty];
	        delete options[fromProperty];
	    },

	    /**
	     * Initialize offset.
	     * @param {{offsetX: ?number, offsetY: ?number}} options - offset options
	     * @private
	     */
	    _initializeOffset: function(options) {
	        if (!options) {
	            return;
	        }

	        this._setOffsetProperty(options, 'offsetX', 'x');
	        this._setOffsetProperty(options, 'offsetY', 'y');
	    },

	    /**
	     * Initialize title options.
	     * @param {
	     *      Array.<{title: (string | {text: string, offsetX: number, offsetY: number})}> |
	     *      {title: (string | {text: string, offsetX: number, offsetY: number})}
	     * } targetOptions - target options
	     * @private
	     */
	    _initializeTitleOptions: function(targetOptions) {
	        var self = this;
	        var optionsSet;

	        if (!targetOptions) {
	            return;
	        }

	        optionsSet = snippet.isArray(targetOptions) ? targetOptions : [targetOptions];
	        snippet.forEachArray(optionsSet, function(options) {
	            var title = options.title;

	            if (snippet.isString(title)) {
	                options.title = {
	                    text: title
	                };
	            }

	            self._initializeOffset(options.title);
	        });
	    },

	    /**
	     * Initialize tooltip options.
	     * @param {{grouped: ?boolean, offsetX: ?number, offsetY: ?number}} options - tooltip options
	     * @private
	     */
	    _initializeTooltipOptions: function(options) {
	        var position = options.position;

	        options.grouped = !!options.grouped;
	        this._initializeOffset(options);

	        if (!options.offset && position) {
	            options.offset = {
	                x: position.left,
	                y: position.top
	            };
	        }

	        delete options.position;
	    },

	    /**
	     * Initialize options.
	     * @param {object} options - options for chart
	     * @private
	     */
	    _initializeOptions: function(options) {
	        options.chartTypes = this.charTypes;
	        options.xAxis = options.xAxis || {};
	        options.series = options.series || {};
	        options.tooltip = options.tooltip || {};
	        options.legend = options.legend || {};
	        options.chartExportMenu = options.chartExportMenu || {};

	        this._initializeTitleOptions(options.chart);
	        this._initializeTitleOptions(options.xAxis);
	        this._initializeTitleOptions(options.yAxis);

	        if (snippet.isUndefined(options.legend.visible)) {
	            options.legend.visible = true;
	        }

	        if (snippet.isUndefined(options.chartExportMenu.visible)) {
	            options.chartExportMenu.visible = true;
	        }

	        this._initializeTooltipOptions(options.tooltip);

	        /**
	         * options
	         * @type {object}
	         */
	        this.options = options;
	    },

	    /**
	     * Create dataProcessor for processing raw data.
	     * @param {object} params parameters
	     *      @param {object} params.rawData - raw data
	     *      @param {DataProcessor} params.DataProcessor - DataProcessor class
	     *      @param {{chart: object, chartType: string}} params.options - chart options
	     *      @param {Array} params.seriesTypes series - chart types for rendering series
	     * @returns {object} data processor
	     * @private
	     */
	    _createDataProcessor: function(params) {
	        var DataProcessor, dataProcessor;

	        DataProcessor = params.DataProcessor || DefaultDataProcessor;
	        dataProcessor = new DataProcessor(params.rawData, this.chartType, params.options, this.seriesTypes);

	        return dataProcessor;
	    },

	    /**
	     * Create ComponentManager.
	     * @returns {ComponentManager}
	     * @private
	     */
	    _createComponentManager: function() {
	        return new ComponentManager({
	            options: this.options,
	            theme: this.theme,
	            dataProcessor: this.dataProcessor,
	            hasAxes: this.hasAxes,
	            eventBus: this.eventBus,
	            isVertical: this.isVertical,
	            seriesTypes: this.seriesTypes || [this.chartType]
	        });
	    },

	    /**
	     * Add components.
	     * @abstract
	     */
	    addComponents: function() {},

	    /**
	     * Get scale option.
	     * @abstract
	     */
	    getScaleOption: function() {},

	    /**
	     * Build bounds and scale data.
	     * @param {object} prevXAxisData - previous xAxis data
	     * @param {boolean} addingDataMode - whether adding data mode or not
	     * @returns {{
	     *      layoutBounds: {
	     *          dimensionMap: {
	     *              xAxis: {width: number, height: number},
	     *              yAxis: {width: number, height: number},
	     *              rightYAxis: {width: number, height: number},
	     *              series: {width: number, height: number},
	     *              extendedSeries: {width: number, height: number},
	     *              mouseEventDetector: {width: number, height: number},
	     *              legend: {width: number, height: number},
	     *              tooltip: {width: number, height: number}
	     *          },
	     *          positionMap: {
	     *              xAxis: {left: number, top: number},
	     *              yAxis: {left: number, top: number},
	     *              rightYAxis: {left: number, top: number},
	     *              series: {left: number, top: number},
	     *              extendedSeries: {left: number, top: number},
	     *              mouseEventDetector: {left: number, top: number},
	     *              legend: {left: number, top: number},
	     *              tooltip: {left: number, top: number}
	     *          }
	     *      },
	     *      limitMap: {
	     *          xAxis: {min: number, max: number},
	     *          yAxis: {min: number, max: number}
	     *      },
	     *      axisDataMap: {
	     *          xAxis: object,
	     *          yAxis: object,
	     *          yRightAxis: object
	     *      },
	     *      maxRadius: ?number
	     * }}
	     * @private
	     */
	    _buildBoundsAndScaleData: function(prevXAxisData, addingDataMode) {
	        return boundsAndScaleBuilder.build(this.dataProcessor, this.componentManager, {
	            chartType: this.chartType,
	            seriesTypes: this.seriesTypes,
	            options: this.options,
	            theme: this.theme,
	            hasAxes: this.hasAxes,
	            scaleOption: this.getScaleOption(),
	            isVertical: this.isVertical,
	            hasRightYAxis: this.hasRightYAxis,
	            addedDataCount: this._dynamicDataHelper ? this._dynamicDataHelper.addedDataCount : null,
	            prevXAxisData: prevXAxisData,
	            addingDataMode: addingDataMode
	        });
	    },

	    /**
	     * Add data ratios.
	     * @abstract
	     */
	    addDataRatios: function() {},

	    /**
	     * Make chart ready for render, it should be invoked before render, rerender, resize and zoom.
	     * @param {?boolean} addingDataMode - whether adding data mode or not
	     * @returns {object} Bounds and scale data
	     */
	    readyForRender: function(addingDataMode) {
	        var boundsAndScale = this._buildBoundsAndScaleData(this.prevXAxisData, addingDataMode);

	        if (boundsAndScale.axisDataMap.xAxis) {
	            this.prevXAxisData = boundsAndScale.axisDataMap.xAxis;
	        }

	        this.addDataRatios(boundsAndScale.limitMap);

	        return boundsAndScale;
	    },

	    /**
	     * Render chart.
	     * @param {HTMLElement} wrapper chart wrapper element
	     */
	    render: function(wrapper) {
	        var container = dom.create('DIV', 'tui-chart ' + this.className);
	        var componentManager = this.componentManager;
	        var dataProcessor = this.dataProcessor;
	        var seriesVisibilityMap = dataProcessor.getLegendVisibility();
	        var rawData = rawDataHandler.filterCheckedRawData(dataProcessor.rawData, seriesVisibilityMap);
	        var raphaelPaper = componentManager.drawingToolPicker.getPaper(container, chartConst.COMPONENT_TYPE_RAPHAEL);
	        var boundsAndScale;

	        this.dataProcessor.initData(rawData);

	        raphaelPaper.changeChartBackgroundColor(this.theme.chart.background.color);
	        raphaelPaper.changeChartBackgroundOpacity(this.theme.chart.background.opacity);
	        renderUtil.renderFontFamily(container, this.theme.chart.fontFamily);

	        dom.append(wrapper, container);

	        boundsAndScale = this.readyForRender();

	        renderUtil.renderDimension(container, boundsAndScale.dimensionMap.chart);
	        componentManager.render('render', boundsAndScale, {
	            checkedLegends: seriesVisibilityMap
	        }, container);

	        this.chartContainer = container;
	        this.paper = raphaelPaper;
	    },

	    /**
	     * Rerender.
	     * @param {Array.<?boolean> | {line: ?Array.<boolean>, column: ?Array.<boolean>}} checkedLegends checked legends
	     * @param {?object} rawData rawData
	     */
	    rerender: function(checkedLegends, rawData) {
	        var dataProcessor = this.dataProcessor;
	        var boundsAndScale;

	        if (!rawData) {
	            rawData = rawDataHandler.filterCheckedRawData(
	                dataProcessor.getZoomedRawData(),
	                checkedLegends
	            );
	        }

	        this.dataProcessor.initData(rawData);

	        boundsAndScale = this.readyForRender();

	        this.componentManager.render('rerender', boundsAndScale, {
	            checkedLegends: checkedLegends
	        }, this.chartContainer);
	    },

	    /**
	     * On change checked legend.
	     * @param {Array.<?boolean> | {line: ?Array.<boolean>, column: ?Array.<boolean>}} checkedLegends checked legends
	     * @param {?object} rawData rawData
	     * @param {?object} boundsParams addition params for calculating bounds
	     */
	    onChangeCheckedLegends: function(checkedLegends, rawData, boundsParams) {
	        this.rerender(checkedLegends, rawData, boundsParams);
	    },

	    /**
	     * Animate chart.
	     */
	    animateChart: function() {
	        this.componentManager.execute('animateComponent');
	    },

	    /**
	     * Register of user event.
	     * @param {string} eventName event name
	     * @param {function} func event callback
	     */
	    on: function(eventName, func) {
	        if (chartConst.PUBLIC_EVENT_MAP[eventName]) {
	            this.eventBus.on(chartConst.PUBLIC_EVENT_PREFIX + eventName, func);
	        }
	    },

	    /**
	     * Remove user event.
	     * @param {string} eventName event name
	     * @param {function} func event callback
	     */
	    off: function(eventName, func) {
	        if (chartConst.PUBLIC_EVENT_MAP[eventName]) {
	            this.eventBus.off(chartConst.PUBLIC_EVENT_PREFIX + eventName, func);
	        }
	    },

	    /**
	     * Update dimension of chart.
	     * @param {{width: number, height: number}} dimension dimension
	     * @returns {boolean} whether updated or not
	     * @private
	     */
	    _updateChartDimension: function(dimension) {
	        var updated = false;
	        var options = this.options;

	        options.chart = options.chart || {};

	        if (dimension.width && dimension.width > 0 && options.chart.width !== dimension.width) {
	            options.chart.width = dimension.width;
	            updated = true;
	        }

	        if (dimension.height && dimension.height > 0 && options.chart.height !== dimension.height) {
	            options.chart.height = dimension.height;
	            updated = true;
	        }

	        return updated;
	    },

	    /**
	     * Public API for resizable.
	     * @param {object} dimension dimension
	     *      @param {number} dimension.width width
	     *      @param {number} dimension.height height
	     * @api
	     */
	    resize: function(dimension) {
	        var updated, boundsAndScale, chartDimension;

	        if (!dimension) {
	            return;
	        }

	        updated = this._updateChartDimension(dimension);

	        if (!updated) {
	            return;
	        }

	        boundsAndScale = this.readyForRender();
	        chartDimension = boundsAndScale.dimensionMap.chart;

	        renderUtil.renderDimension(this.chartContainer, chartDimension);
	        this.paper.resizeBackground(chartDimension.width, chartDimension.height);

	        this.componentManager.render('resize', boundsAndScale);
	    },

	    /**
	     * Set tooltip align option.
	     * @param {string} align align (left|center|right, top|middle|bottom)
	     * @api
	     */
	    setTooltipAlign: function(align) {
	        this.componentManager.get('tooltip').setAlign(align);
	    },

	    /**
	     * Set tooltip offset option.
	     * @param {object} offset - tooltip offset
	     *      @param {number} offset.x - offset x
	     *      @param {number} offset.y - offset y
	     * @api
	     */
	    setTooltipOffset: function(offset) {
	        this.componentManager.get('tooltip').setOffset(offset);
	    },

	    /**
	     * Set position option.
	     * @param {object} position moving position
	     *      @param {number} position.left left
	     *      @param {number} position.top top
	     * @api
	     * @deprecated
	     */
	    setTooltipPosition: function(position) {
	        this.componentManager.get('tooltip').setPosition(position);
	    },

	    /**
	     * Reset tooltip align option.
	     * @api
	     */
	    resetTooltipAlign: function() {
	        this.componentManager.get('tooltip').resetAlign();
	    },

	    /**
	     * Reset tooltip position.
	     * @api
	     */
	    resetTooltipOffset: function() {
	        this.componentManager.get('tooltip').resetOffset();
	    },

	    /**
	     * Reset tooltip position.
	     * @api
	     * @deprecated
	     */
	    resetTooltipPosition: function() {
	        this.resetTooltipOffset();
	    },

	    /**
	     * Show series label.
	     * @api
	     */
	    showSeriesLabel: function() {
	        var seriesSet = this.componentManager.where({componentType: 'series'});

	        snippet.forEachArray(seriesSet, function(series) {
	            series.showLabel();
	        });
	    },

	    /**
	     * Hide series label.
	     * @api
	     */
	    hideSeriesLabel: function() {
	        var seriesSet = this.componentManager.where({componentType: 'series'});

	        snippet.forEachArray(seriesSet, function(series) {
	            series.hideLabel();
	        });
	    },

	    /**
	     * Add data.
	     * @abstract
	     */
	    addData: function() {},

	    /**
	     * Add plot line.
	     * @abstract
	     */
	    addPlotLine: function() {},

	    /**
	     * Add plot band.
	     * @abstract
	     */
	    addPlotBand: function() {},

	    /**
	     * Remove plot line.
	     * @abstract
	     */
	    removePlotLine: function() {},

	    /**
	     * Remove plot band.
	     * @abstract
	     */
	    removePlotBand: function() {},

	    /**
	     * Get series item bound by indexes
	     * @param {number} index - tooltip data's category index
	     * @param {number} seriesIndex - tooltip data's series index
	     * @param {number} [outlierIndex] - outlier index of tooltip, exists only hovered on boxplot chart's outlier point
	     *
	     * @returns {?object} - series item bound
	     * @private
	     */
	    _getSeriesData: function(index, seriesIndex, outlierIndex) {
	        var indexes = {
	            index: index,
	            seriesIndex: seriesIndex,
	            outlierIndex: outlierIndex
	        };

	        if (seriesIndex < 0) {
	            return null;
	        }

	        return this.componentManager.get('mouseEventDetector').findDataByIndexes(indexes);
	    },

	    /**
	     * find series index by legend label
	     * @param {string} chartType - chart tyoe
	     * @param {string} legendLabel - legend label
	     * @returns {number} - if not found return -1, else return found series index
	     * @private
	     */
	    _findSeriesIndexByLabel: function(chartType, legendLabel) {
	        var labels = this.dataProcessor.getLegendLabels(chartType);
	        var seriesIndex = -1;
	        var i = 0;
	        var len = labels ? labels.length : 0;

	        for (; i < len; i += 1) {
	            if (labels[i] === legendLabel) {
	                seriesIndex = i;
	                break;
	            }
	        }

	        return seriesIndex;
	    },

	    /**
	     * @param {number} index - category index
	     * @param {number} seriesIndex - series index
	     * @returns {object}
	     */
	    _findDataByIndexes: function(index, seriesIndex) {
	        return this.componentManager.get('mouseEventDetector').findDataByIndexes(index, seriesIndex);
	    },

	    /**
	     * show tooltip by index of series item
	     * @param {object} params - data needed for making a tooltip
	     * @ignore
	     */
	    showTooltip: function(params) {
	        var isGroupTooltip, mouseEventDetector, foundSeriesIndex, foundData;

	        if (!predicate.isSupportPublicShowTooptipAPI(this.chartType)) {
	            return;
	        }

	        isGroupTooltip = this.options.tooltip && this.options.tooltip.grouped;
	        mouseEventDetector = this.componentManager.get('mouseEventDetector');

	        if (isGroupTooltip) {
	            foundData = {indexes: {groupIndex: params.index}};
	        } else {
	            foundSeriesIndex = this._findSeriesIndexByLabel(params.chartType, params.legend);
	            foundData = this._getSeriesData(params.index, foundSeriesIndex, params.outlierIndex);
	        }

	        if (foundData) {
	            foundData.silent = true;
	            mouseEventDetector._showTooltip(foundData);
	        } else {
	            this.hideTooltip();
	        }
	    },

	    /**
	     * hide tooltip
	     * @ignore
	     */
	    hideTooltip: function() {
	        var isGroupTooltip, mouseEventDetector;

	        if (!predicate.isSupportPublicShowTooptipAPI(this.chartType)) {
	            return;
	        }

	        isGroupTooltip = this.options.tooltip && this.options.tooltip.grouped;
	        mouseEventDetector = this.componentManager.get('mouseEventDetector');

	        if ((isGroupTooltip && mouseEventDetector.prevIndex >= 0) ||
	            (!isGroupTooltip && mouseEventDetector.prevFoundData)) {
	            mouseEventDetector._hideTooltip({silent: true});
	        }
	    }
	});

	module.exports = ChartBase;


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview ComponentManager manages components of chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var dom = __webpack_require__(9);
	var Axis = __webpack_require__(44);
	var Plot = __webpack_require__(46);
	var title = __webpack_require__(47);
	var RadialPlot = __webpack_require__(48);
	var ChartExportMenu = __webpack_require__(50);
	var DrawingToolPicker = __webpack_require__(38);

	// legends
	var Legend = __webpack_require__(56);
	var SpectrumLegend = __webpack_require__(58);
	var CircleLegend = __webpack_require__(59);

	// tooltips
	var Tooltip = __webpack_require__(60);
	var GroupTooltip = __webpack_require__(66);
	var MapChartTooltip = __webpack_require__(68);

	// mouse event detectors
	var MapChartEventDetector = __webpack_require__(69);
	var mouseEventDetector = __webpack_require__(73);

	// series
	var BarSeries = __webpack_require__(80);
	var ColumnSeries = __webpack_require__(84);
	var LineSeries = __webpack_require__(85);
	var RadialSeries = __webpack_require__(87);
	var AreaSeries = __webpack_require__(88);
	var BubbleSeries = __webpack_require__(89);
	var ScatterSeries = __webpack_require__(91);
	var MapSeries = __webpack_require__(92);
	var PieSeries = __webpack_require__(93);
	var HeatmapSeries = __webpack_require__(94);
	var TreemapSeries = __webpack_require__(95);
	var BoxplotSeries = __webpack_require__(97);
	var BulletSeries = __webpack_require__(98);

	var Zoom = __webpack_require__(99);

	var snippet = __webpack_require__(6);

	var COMPONENT_FACTORY_MAP = {
	    axis: Axis,
	    plot: Plot,
	    radialPlot: RadialPlot,
	    legend: Legend,
	    spectrumLegend: SpectrumLegend,
	    circleLegend: CircleLegend,
	    tooltip: Tooltip,
	    groupTooltip: GroupTooltip,
	    mapChartTooltip: MapChartTooltip,
	    mapChartEventDetector: MapChartEventDetector,
	    mouseEventDetector: mouseEventDetector,
	    barSeries: BarSeries,
	    columnSeries: ColumnSeries,
	    lineSeries: LineSeries,
	    radialSeries: RadialSeries,
	    areaSeries: AreaSeries,
	    bubbleSeries: BubbleSeries,
	    scatterSeries: ScatterSeries,
	    mapSeries: MapSeries,
	    pieSeries: PieSeries,
	    heatmapSeries: HeatmapSeries,
	    treemapSeries: TreemapSeries,
	    boxplotSeries: BoxplotSeries,
	    bulletSeries: BulletSeries,
	    zoom: Zoom,
	    chartExportMenu: ChartExportMenu,
	    title: title
	};

	var ComponentManager = snippet.defineClass(/** @lends ComponentManager.prototype */ {
	    /**
	     * ComponentManager manages components of chart.
	     * @param {object} params parameters
	     *      @param {object} params.theme - theme
	     *      @param {object} params.options - options
	     *      @param {DataProcessor} params.dataProcessor - data processor
	     *      @param {boolean} params.hasAxes - whether has axes or not
	     * @constructs ComponentManager
	     * @private
	     */
	    init: function(params) {
	        var chartOption = params.options.chart;
	        var width = snippet.pick(chartOption, 'width') || chartConst.CHART_DEFAULT_WIDTH;
	        var height = snippet.pick(chartOption, 'height') || chartConst.CHART_DEFAULT_HEIGHT;

	        /**
	         * Components
	         * @type {Array.<object>}
	         */
	        this.components = [];

	        /**
	         * componentFactory map.
	         * @type {object}
	         */
	        this.componentMap = {};

	        /**
	         * theme
	         * @type {object}
	         */
	        this.theme = params.theme || {};

	        /**
	         * options
	         * @type {object}
	         */
	        this.options = params.options || {};

	        /**
	         * data processor
	         * @type {DataProcessor}
	         */
	        this.dataProcessor = params.dataProcessor;

	        /**
	         * whether chart has axes or not
	         * @type {boolean}
	         */
	        this.hasAxes = params.hasAxes;

	        /**
	         * whether chart is vertical or not
	         * @type {boolean}
	         */
	        this.isVertical = params.isVertical;

	        /**
	         * event bus for transmitting message
	         * @type {object}
	         */
	        this.eventBus = params.eventBus;

	        /**
	         * Drawing tool picker
	         * @type {object}
	         */
	        this.drawingToolPicker = new DrawingToolPicker();

	        this.drawingToolPicker.initDimension({
	            width: width,
	            height: height
	        });

	        /**
	         * seriesTypes of chart
	         * @type {Array.<string>}
	         */
	        this.seriesTypes = params.seriesTypes;
	    },

	    /**
	     * Make component options.
	     * @param {object} options options
	     * @param {string} optionKey component option key
	     * @param {string} componentName component name
	     * @param {number} index component index
	     * @returns {object} options
	     * @private
	     */
	    _makeComponentOptions: function(options, optionKey, componentName, index) {
	        options = options || this.options[optionKey];
	        options = snippet.isArray(options) ? options[index] : options || {};

	        return options;
	    },

	    /**
	     * Register component.
	     * The component refers to a component of the chart.
	     * The component types are axis, legend, plot, series and mouseEventDetector.
	     * Chart Component Description : https://i-msdn.sec.s-msft.com/dynimg/IC267997.gif
	     * @param {string} name component name
	     * @param {string} classType component factory name
	     * @param {object} params params that for alternative charts
	     */
	    register: function(name, classType, params) {
	        var index, component, componentType, componentFactory, optionKey;

	        params = params || {};

	        params.name = name;

	        index = params.index || 0;

	        componentFactory = COMPONENT_FACTORY_MAP[classType];
	        componentType = componentFactory.componentType;

	        params.chartTheme = this.theme;
	        params.chartOptions = this.options;
	        params.seriesTypes = this.seriesTypes;

	        if (componentType === 'axis') {
	            // Get theme and options by axis name
	            // As axis has 3 types(xAxis, yAxis, rightYAxis)
	            optionKey = name;
	        } else {
	            optionKey = componentType;
	        }

	        params.theme = this.theme[optionKey];
	        params.options = this.options[optionKey];

	        if (!params.theme && optionKey === 'rightYAxis') {
	            params.theme = this.theme.yAxis;
	        }

	        if (!params.options && optionKey === 'rightYAxis') {
	            params.options = this.options.yAxis;
	        }

	        if (optionKey === 'series') {
	            snippet.forEach(this.seriesTypes, function(seriesType) {
	                if (name.indexOf(seriesType) === 0) {
	                    params.options = params.options[seriesType] || params.options; // For combo chart, options are set for each chart
	                    params.theme = params.theme[seriesType]; // For combo, single chart, themes are set for each chart

	                    if (snippet.isArray(params.options)) {
	                        params.options = params.options[index] || {};
	                    }

	                    return false;
	                }

	                return true;
	            });
	        }

	        params.dataProcessor = this.dataProcessor;
	        params.hasAxes = this.hasAxes;
	        params.isVertical = this.isVertical;
	        params.eventBus = this.eventBus;

	        // alternative scale models for charts that do not use common scale models like maps
	        params.alternativeModel = this.alternativeModel;

	        component = componentFactory(params);

	        // component creation can be refused by factory, according to option data
	        if (component) {
	            component.componentName = name;
	            component.componentType = componentType;

	            this.components.push(component);
	            this.componentMap[name] = component;
	        }
	    },

	    /**
	     * Make data for rendering.
	     * @param {string} name - component name
	     * @param {string} type - component type
	     * @param {object} paper - raphael object
	     * @param {{
	     *      layoutBounds: {
	     *          dimensionMap: object,
	     *          positionMap: object
	     *      },
	     *      limitMap: object,
	     *      axisDataMap: object,
	     *      maxRadius: ?number
	     * }} boundsAndScale - bounds and scale data
	     * @param {?object} additionalData - additional data
	     * @returns {object}
	     * @private
	     */
	    _makeDataForRendering: function(name, type, paper, boundsAndScale, additionalData) {
	        var data = snippet.extend({
	            paper: paper
	        }, additionalData);

	        if (boundsAndScale) {
	            snippet.extend(data, boundsAndScale);

	            data.layout = {
	                dimension: data.dimensionMap[name] || data.dimensionMap[type],
	                position: data.positionMap[name] || data.positionMap[type]
	            };
	        }

	        return data;
	    },

	    /**
	     * Render components.
	     * @param {string} funcName - function name for executing
	     * @param {{
	     *      layoutBounds: {
	     *          dimensionMap: object,
	     *          positionMap: object
	     *      },
	     *      limitMap: object,
	     *      axisDataMap: object,
	     *      maxRadius: ?number
	     * }} boundsAndScale - bounds and scale data
	     * @param {?object} additionalData - additional data
	     * @param {?HTMLElement} container - container
	     */
	    render: function(funcName, boundsAndScale, additionalData, container) {
	        var self = this;
	        var name, type;

	        var elements = snippet.map(this.components, function(component) {
	            var element = null;
	            var data, result, paper;

	            if (component[funcName]) {
	                name = component.componentName;
	                type = component.componentType;
	                paper = self.drawingToolPicker.getPaper(container, component.drawingType);
	                data = self._makeDataForRendering(name, type, paper, boundsAndScale, additionalData);

	                result = component[funcName](data);

	                if (result && !result.paper) {
	                    element = result;
	                }
	            }

	            return element;
	        });

	        if (container) {
	            dom.append(container, elements);
	        }
	    },

	    /**
	     * Find components to conditionMap.
	     * @param {object} conditionMap condition map
	     * @returns {Array.<object>} filtered components
	     */
	    where: function(conditionMap) {
	        return snippet.filter(this.components, function(component) {
	            var contained = true;

	            snippet.forEach(conditionMap, function(value, key) {
	                if (component[key] !== value) {
	                    contained = false;
	                }

	                return contained;
	            });

	            return contained;
	        });
	    },

	    /**
	     * Execute components.
	     * @param {string} funcName - function name
	     */
	    execute: function(funcName) {
	        var args = Array.prototype.slice.call(arguments, 1);

	        snippet.forEachArray(this.components, function(component) {
	            if (component[funcName]) {
	                component[funcName].apply(component, args);
	            }
	        });
	    },

	    /**
	     * Get component.
	     * @param {string} name component name
	     * @returns {object} component instance
	     */
	    get: function(name) {
	        return this.componentMap[name];
	    },

	    /**
	     * Whether has component or not.
	     * @param {string} name - comopnent name
	     * @returns {boolean}
	     */
	    has: function(name) {
	        return !!this.get(name);
	    }
	});

	module.exports = ComponentManager;


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

	/**

	 * @fileoverview  Axis component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var calculator = __webpack_require__(45);
	var pluginFactory = __webpack_require__(32);
	var renderUtil = __webpack_require__(7);
	var snippet = __webpack_require__(6);

	var Axis = snippet.defineClass(/** @lends Axis.prototype */ {
	    /**
	     * Axis component.
	     * @constructs Axis
	     * @private
	     * @param {object} params parameters
	     *      @param {object} params.bound axis bound
	     *      @param {object} params.theme axis theme
	     *      @param {object} params.options axis options
	     *      @param {object} params.dataProcessor data processor of chart
	     *      @param {object} params.seriesType series type
	     *      @param {boolean} params.isYAxis boolean value for axis is vertical or not
	     */
	    init: function(params) {
	        /**
	         * Axis view className
	         * @type {string}
	         */
	        this.className = 'tui-chart-axis-area';

	        /**
	         * Data processor
	         * @type {DataProcessor}
	         */
	        this.dataProcessor = params.dataProcessor;

	        /**
	         * Options
	         * @type {object}
	         */
	        this.options = params.options || {};

	        /**
	         * Axis Theme
	         * Use chart background theme object for render yAxis background on dynamicDataShifting chart
	         * @type {object}
	         */
	        this.theme = snippet.extend({}, params.theme, {
	            background: params.chartTheme.chart.background
	        });

	        /**
	         * Whether label type axis or not.
	         * @type {boolean}
	         */
	        this.isLabelAxis = false;

	        /**
	         * Whether vertical type or not.
	         * @type {boolean}
	         */
	        this.isYAxis = params.isYAxis;

	        /**
	         * Whether data dynamic shifting or not.
	         * @type {boolean}
	         */
	        this.shifting = params.shifting;

	        /**
	         * cached axis data
	         * @type {object}
	         */
	        this.data = {};

	        /**
	         * layout bounds information for this components
	         * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number, ?right:number}}}
	         */
	        this.layout = null;

	        /**
	         * dimension map for layout of chart
	         * @type {null|object}
	         */
	        this.dimensionMap = null;

	        /**
	         * axis data map
	         * @type {null|object}
	         */
	        this.axisDataMap = null;

	        /**
	         * Renderer
	         * @type {object}
	         */
	        this.graphRenderer = pluginFactory.get(chartConst.COMPONENT_TYPE_RAPHAEL, 'axis');

	        /**
	         * Drawing type
	         * @type {string}
	         */
	        this.drawingType = chartConst.COMPONENT_TYPE_RAPHAEL;

	        /**
	         * Paper additional width
	         * @type {number}
	         */
	        this.paperAdditionalWidth = 0;

	        /**
	         * Paper additional height
	         * @type {number}
	         */
	        this.paperAdditionalHeight = 0;

	        /**
	         * Raphael Element for axis background
	         * We should caching this for prevent making background multiply
	         * @type {Raphael.Element}
	         */
	        this._elBg = null;
	    },

	    /**
	     * Render vertical axis background
	     * @private
	     */
	    _renderBackground: function() {
	        var dimension = snippet.extend({}, this.layout.dimension);
	        var position = snippet.extend({}, this.layout.position);

	        if (this.isYAxis) {
	            dimension.height = this.dimensionMap.chart.height;
	            position.top = 0;
	        }

	        if (this._elBg) {
	            this._elBg.remove();
	        }

	        this._elBg = this.graphRenderer.renderBackground(this.paper, position, dimension, this.theme.background);
	    },
	    /**
	     * Render child containers like title area, label area and tick area.
	     * @param {number} size xAxis width or yAxis height
	     * @param {number} tickCount tick count
	     * @param {Array.<number|string>} categories categories
	     * @param {number} additionalWidth additional width
	     * @private
	     */
	    _renderChildContainers: function(size, tickCount, categories, additionalWidth) {
	        var isYAxisLineType = this.isYAxis && this.data.aligned;

	        if (this.isYAxis && !this.data.isPositionRight && !this.options.isCenter && this.shifting) {
	            this._renderBackground();
	        }

	        this._renderTitleArea();

	        if (this.options.showLabel !== false) {
	            this._renderLabelArea(size, tickCount, categories, additionalWidth);
	        }

	        if (!isYAxisLineType) {
	            this._renderTickArea(size, tickCount, additionalWidth);
	        }
	    },
	    /**
	     * Render divided xAxis if yAxis rendered in the center.
	     * @param {{width: number, height:number}} dimension axis area width and height
	     * @private
	     */
	    _renderDividedAxis: function(dimension) {
	        var axisData = this.data;
	        var lSideWidth = Math.round(dimension.width / 2);
	        var rSideWidth = dimension.width - lSideWidth - 1;
	        var tickCount = axisData.tickCount;
	        var halfTickCount = parseInt(tickCount / 2, 10) + 1;
	        var categories = axisData.labels;
	        var lCategories = categories.slice(0, halfTickCount);
	        var rCategories = categories.slice(halfTickCount - 1, tickCount);
	        var tickInterval = lSideWidth / halfTickCount;
	        var secondXAxisAdditionalPosition = lSideWidth + this.dimensionMap.yAxis.width - 1;

	        this.paperAdditionalWidth = tickInterval;

	        this._renderChildContainers(lSideWidth, halfTickCount, lCategories, 0);
	        this._renderChildContainers(rSideWidth + 1, halfTickCount, rCategories,
	            secondXAxisAdditionalPosition);
	    },

	    /**
	     * Render single axis if not divided.
	     * @param {{width: number, height: number}} dimension axis area dimension
	     * @private
	     */
	    _renderNotDividedAxis: function(dimension) {
	        var axisData = this.data;
	        var isYAxis = this.isYAxis;
	        var size = isYAxis ? dimension.height : dimension.width;
	        var additionalSize = 0;

	        if (axisData.positionRatio) {
	            additionalSize = size * axisData.positionRatio;
	        }

	        this._renderChildContainers(size, axisData.tickCount, axisData.labels, additionalSize);
	    },

	    /**
	     * Render axis area.
	     * @private
	     */
	    _renderAxisArea: function() {
	        var dimension = this.layout.dimension;
	        var axisData = this.data;

	        this.isLabelAxis = axisData.isLabelAxis;

	        if (this.options.divided) {
	            this.containerWidth = dimension.width + this.dimensionMap.yAxis.width;
	            this._renderDividedAxis(dimension);
	            dimension.width = this.containerWidth;
	        } else {
	            dimension.width += this.options.isCenter ? 1 : 0;
	            this._renderNotDividedAxis(dimension);
	        }
	    },

	    /**
	     * Set data for rendering.
	     * @param {{
	     *      options: ?object,
	     *      layout: {
	     *          dimension: {width: number, height: number},
	     *          position: {left: number, top: number}
	     *      },
	     *      dimensionMap: object,
	     *      axisDataMap: object
	     * }} data - bounds and scale data
	     * @private
	     */
	    _setDataForRendering: function(data) {
	        this.layout = data.layout;
	        this.dimensionMap = data.dimensionMap;
	        this.data = data.axisDataMap[this.componentName];
	        this.options = this.data.options;
	    },

	    /**
	     * @param {object} data - bounds and scale data
	     */
	    render: function(data) {
	        this.paper = data.paper;
	        this.axisSet = data.paper.set();

	        this._setDataForRendering(data);
	        this._renderAxisArea();
	    },

	    /**
	     * Rerender axis component.
	     * @param {object} data - bounds and scale data
	     */
	    rerender: function(data) {
	        this.axisSet.remove();

	        this.render(data);
	    },

	    /**
	     * Resize axis component.
	     * @param {object} data - bounds and scale data
	     */
	    resize: function(data) {
	        this.rerender(data);
	    },

	    /**
	     * Zoom.
	     * @param {object} data - bounds and scale data
	     */
	    zoom: function(data) {
	        this.rerender(data);
	    },

	    /**
	     * Title area renderer
	     * @private
	     */
	    _renderTitleArea: function() {
	        var title = this.options.title || {};

	        if (title.text) {
	            this.graphRenderer.renderTitle(this.paper, {
	                text: title.text,
	                offset: title.offset,
	                theme: this.theme.title,
	                rotationInfo: {
	                    rotateTitle: this.options.rotateTitle,
	                    isVertical: this.isYAxis,
	                    isPositionRight: this.data.isPositionRight,
	                    isCenter: this.options.isCenter
	                },
	                layout: this.layout,
	                set: this.axisSet
	            });
	        }
	    },

	    /**
	     * Render tick line.
	     * @param {number} areaSize - width or height
	     * @param {boolean} isNotDividedXAxis - whether is not divided x axis or not.
	     * @param {number} additionalSize - additional size
	     * @private
	     */
	    _renderTickLine: function(areaSize, isNotDividedXAxis, additionalSize) {
	        this.graphRenderer.renderTickLine({
	            areaSize: areaSize,
	            additionalSize: additionalSize,
	            additionalWidth: this.paperAdditionalWidth,
	            additionalHeight: this.paperAdditionalHeight,
	            isPositionRight: this.data.isPositionRight,
	            isCenter: this.data.options.isCenter,
	            isNotDividedXAxis: isNotDividedXAxis,
	            isVertical: this.isYAxis,
	            tickColor: this.theme.tickColor,
	            layout: this.layout,
	            paper: this.paper,
	            set: this.axisSet
	        });
	    },

	    /**
	     * Render ticks.
	     * @param {number} size - width or height
	     * @param {number} tickCount - tick count
	     * @param {boolean} isNotDividedXAxis - whether is not divided x axis or not.
	     * @param {number} [additionalSize] - additional size
	     * @private
	     */
	    _renderTicks: function(size, tickCount, isNotDividedXAxis, additionalSize) {
	        var tickColor = this.theme.tickColor;
	        var axisData = this.data;
	        var sizeRatio = axisData.sizeRatio || 1;
	        var isYAxis = this.isYAxis;
	        var isCenter = this.data.options.isCenter;
	        var isPositionRight = this.data.isPositionRight;
	        var positions = calculator.makeTickPixelPositions((size * sizeRatio), tickCount);
	        var additionalHeight = this.paperAdditionalHeight + 1;
	        var additionalWidth = this.paperAdditionalWidth;

	        positions.length = axisData.tickCount;

	        this.graphRenderer.renderTicks({
	            paper: this.paper,
	            layout: this.layout,
	            positions: positions,
	            isVertical: isYAxis,
	            isCenter: isCenter,
	            additionalSize: additionalSize,
	            additionalWidth: additionalWidth,
	            additionalHeight: additionalHeight,
	            isPositionRight: isPositionRight,
	            tickColor: tickColor,
	            set: this.axisSet
	        });
	    },

	    /**
	     * Render tick area.
	     * @param {number} size - width or height
	     * @param {number} tickCount - tick count
	     * @param {number} [additionalSize] - additional size (width or height)
	     * @private
	     */
	    _renderTickArea: function(size, tickCount, additionalSize) {
	        var isNotDividedXAxis = !this.isYAxis && !this.options.divided;

	        this._renderTickLine(size, isNotDividedXAxis, (additionalSize || 0));

	        this._renderTicks(size, tickCount, isNotDividedXAxis, (additionalSize || 0));
	    },

	    /**
	     * Render label area.
	     * @param {number} size label area size
	     * @param {number} tickCount tick count
	     * @param {Array.<string>} categories categories
	     * @param {number} [additionalSize] additional size (width or height)
	     * @private
	     */
	    _renderLabelArea: function(size, tickCount, categories, additionalSize) {
	        var sizeRatio = this.data.sizeRatio || 1;
	        var tickPixelPositions = calculator.makeTickPixelPositions((size * sizeRatio), tickCount, 0);
	        var labelDistance = tickPixelPositions[1] - tickPixelPositions[0];

	        this._renderLabels(tickPixelPositions, categories, labelDistance, (additionalSize || 0));
	    },

	    /**
	     * Make html of rotation labels.
	     * @param {Array.<object>} positions label position array
	     * @param {string[]} categories categories
	     * @param {number} labelSize label size
	     * @param {number} additionalSize additional size
	     * @private
	     */
	    _renderRotationLabels: function(positions, categories, labelSize, additionalSize) {
	        var self = this;
	        var renderer = this.graphRenderer;
	        var isYAxis = this.isYAxis;
	        var theme = this.theme.label;
	        var degree = this.data.degree;
	        var halfWidth = labelSize / 2;
	        var horizontalTop = this.layout.position.top + chartConst.AXIS_LABEL_PADDING;
	        var baseLeft = this.layout.position.left;
	        var labelMargin = this.options.labelMargin || 0;

	        snippet.forEach(positions, function(position, index) {
	            var labelPosition = position + (additionalSize || 0);
	            var positionTopAndLeft = {};

	            if (isYAxis) {
	                positionTopAndLeft.top = labelPosition + halfWidth;
	                positionTopAndLeft.left = labelSize + labelMargin;
	            } else {
	                positionTopAndLeft.top = horizontalTop + labelMargin;
	                positionTopAndLeft.left = baseLeft + labelPosition;

	                if (self.isLabelAxis) {
	                    positionTopAndLeft.left += halfWidth;
	                }
	            }

	            renderer.renderRotatedLabel({
	                degree: degree,
	                labelText: categories[index],
	                paper: self.paper,
	                positionTopAndLeft: positionTopAndLeft,
	                set: self.axisSet,
	                theme: theme
	            });
	        });
	    },

	    /**
	     * Make html of normal labels.
	     * @param {Array.<object>} positions label position array
	     * @param {string[]} categories categories
	     * @param {number} labelSize label size
	     * @param {number} additionalSize additional size
	     * @private
	     */
	    _renderNormalLabels: function(positions, categories, labelSize, additionalSize) {
	        var self = this;
	        var renderer = this.graphRenderer;
	        var isYAxis = this.isYAxis;
	        var isPositionRight = this.data.isPositionRight;
	        var isCategoryLabel = this.isLabelAxis;
	        var theme = this.theme.label;
	        var dataProcessor = this.dataProcessor;
	        var isLineTypeChart = predicate.isLineTypeChart(dataProcessor.chartType, dataProcessor.seriesTypes);
	        var isPointOnColumn = isLineTypeChart && this.options.pointOnColumn;
	        var layout = this.layout;
	        var labelMargin = this.options.labelMargin || 0;

	        snippet.forEach(positions, function(position, index) {
	            var labelPosition = position + additionalSize;
	            var halfLabelDistance = labelSize / 2;
	            var positionTopAndLeft = {};
	            var labelTopPosition, labelLeftPosition;

	            /*
	             * to prevent printing `undefined` text, when category label is not set
	             */
	            if (labelPosition < 0) {
	                return;
	            }

	            if (isYAxis) {
	                labelTopPosition = labelPosition;

	                if (isCategoryLabel) {
	                    labelTopPosition += halfLabelDistance + layout.position.top;
	                } else {
	                    labelTopPosition = layout.dimension.height + layout.position.top - labelTopPosition;
	                }

	                if (isPositionRight) {
	                    labelLeftPosition = layout.position.left + chartConst.AXIS_LABEL_PADDING + labelMargin;
	                } else {
	                    labelLeftPosition = layout.position.left + layout.dimension.width -
	                                        chartConst.AXIS_LABEL_PADDING - labelMargin;
	                }
	            } else {
	                labelTopPosition = layout.position.top + chartConst.CHART_PADDING +
	                                   chartConst.AXIS_LABEL_PADDING + labelMargin;

	                labelLeftPosition = labelPosition + layout.position.left;

	                if (isCategoryLabel) {
	                    if (!isLineTypeChart || isPointOnColumn) {
	                        labelLeftPosition += halfLabelDistance;
	                    }
	                }
	            }

	            positionTopAndLeft.top = Math.round(labelTopPosition);
	            positionTopAndLeft.left = Math.round(labelLeftPosition);

	            renderer.renderLabel({
	                isPositionRight: isPositionRight,
	                isVertical: isYAxis,
	                labelSize: labelSize,
	                labelText: categories[index],
	                paper: self.paper,
	                positionTopAndLeft: positionTopAndLeft,
	                set: self.axisSet,
	                theme: theme
	            });
	        });
	    },

	    /**
	     * Make labels html.
	     * @param {Array.<object>} positions - positions for labels
	     * @param {Array.<string>} categories - categories
	     * @param {number} labelSize label size
	     * @param {number} additionalSize additional size
	     * @private
	     */
	    _renderLabels: function(positions, categories, labelSize, additionalSize) {
	        var isRotationlessXAxis = !this.isYAxis && this.isLabelAxis && (this.options.rotateLabel === false);
	        var hasRotatedXAxisLabel = this.componentName === 'xAxis' && this.data.degree;
	        var axisLabels;

	        if (isRotationlessXAxis) {
	            axisLabels = this.data.multilineLabels;
	        } else {
	            axisLabels = categories;
	        }

	        if (axisLabels.length) {
	            positions.length = axisLabels.length;
	        }

	        axisLabels = renderUtil.addPrefixSuffix(axisLabels, this.options.prefix, this.options.suffix);

	        if (hasRotatedXAxisLabel) {
	            this._renderRotationLabels(positions, axisLabels, labelSize, additionalSize);
	        } else {
	            this._renderNormalLabels(positions, axisLabels, labelSize, additionalSize);
	        }
	    },
	    /**
	     * Animate axis for adding data
	     * @param {object} data rendering data
	     */
	    animateForAddingData: function(data) {
	        if (!this.isYAxis) {
	            this.graphRenderer.animateForAddingData(data.tickSize);
	        }
	    }
	});

	/**
	 * Factory for Axis
	 * @param {object} axisParam parameter
	 * @returns {object}
	 * @ignore
	 */
	function axisFactory(axisParam) {
	    var chartType = axisParam.chartOptions.chartType;
	    var name = axisParam.name;

	    axisParam.isYAxis = (name === 'yAxis' || name === 'rightYAxis');
	    axisParam.shifting = axisParam.chartOptions.series.shifting;

	    // In combo chart, the theme is divided into series name considering two YAxis(yAxis and rightYAxis)
	    // @todo change theme structure so that access theme by axis type, not considering chart type
	    //     like theme.xAxis, theme.yAxis, theme.rightYAxis
	    if (chartType === 'combo') {
	        if (axisParam.isYAxis) {
	            axisParam.theme = axisParam.theme[axisParam.seriesTypes[0]];
	        } else if (name === 'rightYAxis') {
	            axisParam.componentType = 'yAxis';
	            axisParam.theme = axisParam.theme[axisParam.seriesTypes[1]];
	            axisParam.index = 1;
	        }
	    // @todo I do not know why the single type chart with yAxis branches once again as the chart name inside it. I feel inconsistent
	    } else if (axisParam.isYAxis) {
	        axisParam.theme = axisParam.theme[chartType];
	    // single chart, xAxis
	    } else {
	        axisParam.theme = axisParam.theme;
	    }

	    return new Axis(axisParam);
	}

	axisFactory.componentType = 'axis';
	axisFactory.Axis = Axis;

	module.exports = axisFactory;


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview calculator.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);
	var arrayUtil = __webpack_require__(10);
	var PERCENT_DIVISOR = 100;

	/**
	 * Calculator.
	 * @module calculator
	 * @private */
	var calculator = {
	    /**
	     * Calculate limit from chart min, max data.
	     *  - http://peltiertech.com/how-excel-calculates-automatic-chart-axis-limits/
	     * @memberOf module:calculator
	     * @param {number} min min minimum value of user data
	     * @param {number} max max maximum value of user data
	     * @returns {{min: number, max: number}} limit axis limit
	     */
	    calculateLimit: function(min, max) {
	        var saveMin = 0,
	            limit = {},
	            iodValue; // increase or decrease value;

	        if (min < 0) {
	            saveMin = min;
	            max -= min;
	            min = 0;
	        }

	        iodValue = (max - min) / 20;
	        limit.max = max + iodValue + saveMin;

	        if (max / 6 > min) {
	            limit.min = saveMin;
	        } else {
	            limit.min = min - iodValue + saveMin;
	        }

	        return limit;
	    },

	    /**
	     * Make tick positions of pixel type.
	     * @memberOf module:calculator
	     * @param {number} size area width or height
	     * @param {number} count tick count
	     * @param {?number} additionalPosition additional position
	     * @returns {Array.<number>} positions
	     */
	    makeTickPixelPositions: function(size, count, additionalPosition) {
	        var positions = [];

	        additionalPosition = additionalPosition || 0;

	        if (count > 0) {
	            positions = snippet.map(snippet.range(0, count), function(index) {
	                var ratio = index === 0 ? 0 : (index / (count - 1));

	                return (ratio * size) + additionalPosition;
	            });
	            positions[positions.length - 1] -= 1;
	        }

	        return positions;
	    },

	    /**
	     * Make labels from limit.
	     * @memberOf module:calculator
	     * @param {{min: number, max: number}} limit axis limit
	     * @param {number} step step between max and min
	     * @returns {string[]} labels
	     * @private
	     */
	    makeLabelsFromLimit: function(limit, step) {
	        var multipleNum = calculator.findMultipleNum(step);
	        var min = Math.round(limit.min * multipleNum);
	        var max = Math.round(limit.max * multipleNum);
	        var labels = snippet.range(min, max + 1, step * multipleNum);

	        return snippet.map(labels, function(label) {
	            return label / multipleNum;
	        });
	    },

	    /**
	     * Calculate step from limit.
	     * @memberOf module:calculator
	     * @param {{min: number, max: number}} limit axis limit
	     * @param {number} count value count
	     * @returns {number} step
	     */
	    calculateStepFromLimit: function(limit, count) {
	        return calculator.divide(calculator.subtract(limit.max, limit.min), (count - 1));
	    },

	    /**
	     * Sum plus values.
	     * @param {Array.<number>} values values
	     * @returns {number} sum
	     */
	    sumPlusValues: function(values) {
	        var plusValues = snippet.filter(values, function(value) {
	            return value > 0;
	        });

	        return calculator.sum(plusValues);
	    },

	    /**
	     * Sum minus values.
	     * @param {Array.<number>} values values
	     * @returns {number} sum
	     */
	    sumMinusValues: function(values) {
	        var minusValues = snippet.filter(values, function(value) {
	            return value < 0;
	        });

	        return calculator.sum(minusValues);
	    },

	    /**
	     * Make percentage value.
	     * @param {number} value - value
	     * @param {number} totalValue - total value
	     * @returns {number}
	     */
	    makePercentageValue: function(value, totalValue) {
	        return value / totalValue * PERCENT_DIVISOR;
	    },

	    /**
	     * Calculate ratio for making bound.
	     * @param {number} value - value
	     * @param {number} divNumber - number for division
	     * @param {number} subNumber - number for subtraction
	     * @param {number} baseRatio - base ratio
	     * @returns {number}
	     */
	    calculateRatio: function(value, divNumber, subNumber, baseRatio) {
	        return ((value - subNumber) / divNumber) * baseRatio;
	    }
	};

	/**
	 * Get length after decimal point.
	 * @memberOf module:calculator
	 * @param {string | number} value target value
	 * @returns {number} result length
	 */
	var getDecimalLength = function(value) {
	    var valueArr = String(value).split('.');

	    return valueArr.length === 2 ? valueArr[1].length : 0;
	};

	/**
	 * Find multiple num.
	 * @memberOf module:calculator
	 * @param {...Array} target values
	 * @returns {number} multiple num
	 */
	var findMultipleNum = function() {
	    var args = [].slice.call(arguments);
	    var underPointLens = snippet.map(args, function(value) {
	        return calculator.getDecimalLength(value);
	    });
	    var underPointLen = arrayUtil.max(underPointLens);

	    return Math.pow(10, underPointLen);
	};

	/**
	 * Modulo operation for floating point operation.
	 * @memberOf module:calculator
	 * @param {number} target target values
	 * @param {number} modNum mod num
	 * @returns {number} result mod
	 */
	var mod = function(target, modNum) {
	    var multipleNum = calculator.findMultipleNum(modNum);
	    var result;

	    if (multipleNum === 1) {
	        result = target % modNum;
	    } else {
	        result = ((target * multipleNum) % (modNum * multipleNum)) / multipleNum;
	    }

	    return result;
	};

	/**
	 * 'add' is function for add operation to floating point.
	 * @memberOf module:calculator
	 * @param {number} a target a
	 * @param {number} b target b
	 * @returns {number}
	 */
	var add = function(a, b) {
	    var multipleNum = calculator.findMultipleNum(a, b);

	    return ((a * multipleNum) + (b * multipleNum)) / multipleNum;
	};

	/**
	 * 'subtract' is function for subtract operation to floating point.
	 * @memberOf module:calculator
	 * @param {number} a target a
	 * @param {number} b target b
	 * @returns {number}
	 */
	var subtract = function(a, b) {
	    var multipleNum = calculator.findMultipleNum(a, b);

	    return ((a * multipleNum) - (b * multipleNum)) / multipleNum;
	};

	/**
	 * 'multiply' is function for multiply operation to floating point.
	 * @param {number} a target a
	 * @param {number} b target b
	 * @returns {number}
	 */
	var multiply = function(a, b) {
	    var multipleNum = calculator.findMultipleNum(a, b);

	    return ((a * multipleNum) * (b * multipleNum)) / (multipleNum * multipleNum);
	};

	/**
	 * 'divide' is function for divide operation to floating point.
	 * @memberOf module:calculator
	 * @param {number} a target a
	 * @param {number} b target b
	 * @returns {number}
	 */
	var divide = function(a, b) {
	    var multipleNum = calculator.findMultipleNum(a, b);

	    return (a * multipleNum) / (b * multipleNum);
	};

	/**
	 * Sum.
	 * @memberOf module:calculator
	 * @param {Array.<number>} values target values
	 * @returns {number} result value
	 */
	var sum = function(values) {
	    var copyArr = values.slice();
	    copyArr.unshift(0);

	    return snippet.reduce(copyArr, function(base, value) {
	        return calculator.add(parseFloat(base), parseFloat(value));
	    });
	};

	calculator.getDecimalLength = getDecimalLength;
	calculator.findMultipleNum = findMultipleNum;
	calculator.mod = mod;
	calculator.add = add;
	calculator.subtract = subtract;
	calculator.multiply = multiply;
	calculator.divide = divide;
	calculator.sum = sum;

	module.exports = calculator;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Plot component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var calculator = __webpack_require__(45);
	var snippet = __webpack_require__(6);
	var map = snippet.map;

	var Plot = snippet.defineClass(/** @lends Plot.prototype */ {
	    /**
	     * Plot component.
	     * @constructs Plot
	     * @private
	     * @param {object} params parameters
	     *      @param {number} params.vTickCount vertical tick count
	     *      @param {number} params.hTickCount horizontal tick count
	     *      @param {object} params.theme axis theme
	     */
	    init: function(params) {
	        /**
	         * Plot view className
	         * @type {string}
	         */
	        this.className = 'tui-chart-plot-area';

	        /**
	         * Data processor
	         * @type {DataProcessor}
	         */
	        this.dataProcessor = params.dataProcessor;

	        /**
	         * Options
	         * @type {object}
	         */
	        this.options = params.options || {};
	        this.options.showLine = snippet.isUndefined(this.options.showLine) ? true : this.options.showLine;
	        this.options.lines = this.options.lines || [];
	        this.options.bands = this.options.bands || [];

	        /**
	         * x axis type option
	         * @type {?string}
	         */
	        this.xAxisTypeOption = params.xAxisTypeOption;

	        /**
	         * Theme
	         * @type {object}
	         */
	        this.theme = params.theme || {};

	        /**
	         * chart type
	         * @type {string}
	         */
	        this.chartType = params.chartType;

	        /**
	         * sub charts type
	         * @type {Array.<string>}
	         */
	        this.chartTypes = params.chartTypes;

	        /**
	         * layout bounds information for this components
	         * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number}}}
	         */
	        this.layout = null;

	        /**
	         * axis data map
	         * @type {null|object}
	         */
	        this.axisDataMap = null;

	        this.drawingType = chartConst.COMPONENT_TYPE_RAPHAEL;
	    },

	    /**
	     * Render plot area.
	     * @param {object} paper paper object
	     * @private
	     */
	    _renderPlotArea: function(paper) {
	        var dimension;

	        dimension = this.layout.dimension;

	        if (predicate.isLineTypeChart(this.chartType, this.chartTypes)) {
	            this._renderOptionalLines(paper, dimension);
	        }

	        if (this.options.showLine) {
	            this._renderPlotLines(paper, dimension);
	        }
	    },

	    /**
	     * Set data for rendering.
	     * @param {{
	     *      layout: {
	     *          dimension: {width: number, height: number},
	     *          position: {left: number, top: number}
	     *      },
	     *      axisDataMap: object
	     * }} data - bounds and scale data
	     * @private
	     */
	    _setDataForRendering: function(data) {
	        if (data) {
	            this.layout = data.layout;
	            this.dimensionMap = data.dimensionMap;
	            this.axisDataMap = data.axisDataMap;
	            this.paper = data.paper;
	        }
	    },

	    /**
	     * Render plot component.
	     * @param {object} data - bounds and scale data
	     */
	    render: function(data) {
	        var paper = (data && data.paper) || this.paper;
	        this.plotSet = paper.set();
	        this.additionalPlotSet = paper.set();

	        this._setDataForRendering(data);
	        this._renderPlotArea(this.paper);

	        this.additionalPlotSet.toBack();
	        this.plotSet.toBack();
	        paper.pushDownBackgroundToBottom();
	    },

	    /**
	     * Rerender.
	     * @param {object} data - bounds and scale data
	     */
	    rerender: function(data) {
	        this.additionalPlotSet.remove();
	        this.plotSet.remove();
	        this.render(data);
	    },

	    /**
	     * Resize plot component.
	     * @param {object} data - bounds and scale data
	     */
	    resize: function(data) {
	        this.rerender(data);
	    },

	    /**
	     * Zoom.
	     * @param {object} data - bounds and scale data
	     */
	    zoom: function(data) {
	        this.rerender(data);
	    },

	    /**
	     * Make template params for vertical line.
	     * @param {object} additionalParams - additional params
	     * @returns {object}
	     * @private
	     */
	    _makeVerticalLineTemplateParams: function(additionalParams) {
	        return snippet.extend({
	            className: 'vertical',
	            positionType: 'left',
	            width: '1px'
	        }, additionalParams);
	    },

	    /**
	     * Make template params for horizontal line.
	     * @param {object} additionalParams - additional params
	     * @returns {object}
	     * @private
	     */
	    _makeHorizontalLineTemplateParams: function(additionalParams) {
	        return snippet.extend({
	            className: 'horizontal',
	            positionType: 'bottom',
	            height: '1px'
	        }, additionalParams);
	    },

	    /**
	     * Render line
	     * @param {number} offsetPosition - start percentage offsetPosition
	     * @param {object} attributes - line attributes
	     * @returns {object} path
	     * @private
	     */
	    _renderLine: function(offsetPosition, attributes) {
	        var top = this.layout.position.top;
	        var height = this.layout.dimension.height;
	        var pathString = 'M' + offsetPosition + ',' + top + 'V' + (top + height);
	        var path = this.paper.path(pathString);

	        path.attr({
	            opacity: attributes.opacity || 1,
	            stroke: attributes.color
	        });

	        this.additionalPlotSet.push(path);

	        return path;
	    },

	    /**
	     * Render band
	     * @param {number} offsetPosition - start percentage offsetPosition
	     * @param {number} plotWidth - plotWidth
	     * @param {object} attributes - band attributes
	     * @returns {object} band
	     * @private
	     */
	    _renderBand: function(offsetPosition, plotWidth, attributes) {
	        var position = this.layout.position;
	        var dimension = this.layout.dimension;
	        var remainingWidth = dimension.width - offsetPosition + position.left;
	        var bandWidth = plotWidth < 0 ? remainingWidth : plotWidth;
	        var rect = this.paper.rect(offsetPosition, position.top, bandWidth, dimension.height);

	        rect.attr({
	            fill: attributes.color,
	            opacity: attributes.opacity || 1,
	            stroke: attributes.color
	        });

	        this.additionalPlotSet.push(rect);

	        return rect;
	    },

	    /**
	     * Create value range for optional line.
	     * @param {{range: ?Array.<number>, value: ?number}} optionalLineData - optional line data
	     * @returns {Array.<number>}
	     * @private
	     */
	    _createOptionalLineValueRange: function(optionalLineData) {
	        var range = optionalLineData.range || [optionalLineData.value];

	        if (predicate.isDatetimeType(this.xAxisTypeOption)) {
	            range = map(range, function(value) {
	                var date = new Date(value);

	                return date.getTime() || value;
	            });
	        }

	        return range;
	    },

	    /**
	     * Create position for optional line, when value axis.
	     * @param {{dataMin: number, distance: number}} xAxisData - x axis data
	     * @param {number} width - width
	     * @param {number} value - value
	     * @returns {number|null}
	     * @private
	     */
	    _createOptionalLinePosition: function(xAxisData, width, value) {
	        var ratio = (value - xAxisData.dataMin) / xAxisData.distance;
	        var position = ratio * width;

	        if (ratio === 1) {
	            position -= 1;
	        }

	        if (position < 0) {
	            position = null;
	        }

	        return position;
	    },

	    /**
	     * Create position for optional line, when label axis.
	     * @param {number} width - width
	     * @param {number} value - value
	     * @returns {number|null}
	     * @private
	     */
	    _createOptionalLinePositionWhenLabelAxis: function(width, value) {
	        var dataProcessor = this.dataProcessor;
	        var index = dataProcessor.findCategoryIndex(value);
	        var position = null;
	        var ratio;

	        if (!snippet.isNull(index)) {
	            ratio = (index === 0) ? 0 : (index / (dataProcessor.getCategoryCount() - 1));
	            position = ratio * width;
	        }

	        if (ratio === 1) {
	            position -= 1;
	        }

	        return position;
	    },

	    /**
	     * Create position map for optional line.
	     * @param {{range: ?Array.<number>, value: ?number}} optionalLineData - optional line data
	     * @param {{isLabelAxis: boolean, dataMin: number, distance: number}} xAxisData - x axis data
	     * @param {number} width - width
	     * @returns {{start: number, end: number}}
	     * @private
	     */
	    _createOptionalLinePositionMap: function(optionalLineData, xAxisData, width) {
	        var categories = this.dataProcessor.getCategories();
	        var range = this._createOptionalLineValueRange(optionalLineData);
	        var startPosition, endPosition;

	        if (xAxisData.isLabelAxis) {
	            startPosition = this._createOptionalLinePositionWhenLabelAxis(width, range[0]);
	            endPosition = this._createOptionalLinePositionWhenLabelAxis(width, range[1]);
	        } else {
	            startPosition = this._createOptionalLinePosition(xAxisData, width, range[0]);
	            endPosition = range[1] && this._createOptionalLinePosition(xAxisData, width, range[1]);
	        }

	        if (snippet.isNull(startPosition)) {
	            startPosition = this._isBeforeVisibleCategories(range[0], categories[0]) ? 0 : -1;
	        }

	        if (snippet.isNull(endPosition)) {
	            endPosition = this._isAfterVisibleCatgories(range[1], categories[categories.length - 1]) ? width : -1;
	        }

	        return {
	            start: startPosition,
	            end: endPosition
	        };
	    },

	    /**
	     * @param {string} value - value of starting point
	     * @param {string} firstCategory - first visible category data
	     * @returns {boolean} - whether starting point value is at before first visible category data or not
	     * @private
	     */
	    _isBeforeVisibleCategories: function(value, firstCategory) {
	        var dataProcessor = this.dataProcessor;
	        var valueIndex, firstCategoryIndex;

	        if (!snippet.isExisty(value)) {
	            return false;
	        }

	        if (predicate.isDatetimeType(this.xAxisTypeOption)) {
	            return value < firstCategory;
	        }

	        valueIndex = dataProcessor.findAbsoluteCategoryIndex(value);
	        firstCategoryIndex = dataProcessor.findAbsoluteCategoryIndex(firstCategory);

	        return (valueIndex >= 0) && (valueIndex < firstCategoryIndex);
	    },

	    /**
	     * @param {string} value - value of end point
	     * @param {string} lastCategory - last visible category data
	     * @returns {boolean} - whether end point value is at after last visible category data or not
	     * @private
	     */
	    _isAfterVisibleCatgories: function(value, lastCategory) {
	        var dataProcessor = this.dataProcessor;
	        var valueIndex, lastCategoryIndex;

	        if (!snippet.isExisty(value)) {
	            return false;
	        }

	        if (predicate.isDatetimeType(this.xAxisTypeOption)) {
	            return value > lastCategory;
	        }

	        valueIndex = dataProcessor.findAbsoluteCategoryIndex(value);
	        lastCategoryIndex = dataProcessor.findAbsoluteCategoryIndex(lastCategory);

	        return (valueIndex >= 0) && (valueIndex > lastCategoryIndex);
	    },

	    /**
	     * Render optional line.
	     * @param {Array.<number>} xAxisData - positions
	     * @param {number} width - standard width
	     * @param {object} attributes - template parameters
	     * @param {object} optionalLineData - optional line information
	     * @returns {object}
	     * @private
	     */
	    _renderOptionalLine: function(xAxisData, width, attributes, optionalLineData) {
	        var positionMap = this._createOptionalLinePositionMap(optionalLineData, xAxisData, width);
	        var line;

	        if (positionMap.start >= 0 && positionMap.start <= width) {
	            attributes.width = 1;

	            attributes.color = optionalLineData.color || 'transparent';
	            attributes.opacity = optionalLineData.opacity;

	            line = this._renderLine(positionMap.start + this.layout.position.left, attributes);
	        }

	        return line;
	    },

	    /**
	     * Render optional band.
	     * @param {Array.<number>} xAxisData - positions
	     * @param {number} width - standard width
	     * @param {object} attributes - template parameters
	     * @param {object} optionalLineData - optional line information
	     * @returns {object}
	     * @private
	     */
	    _makeOptionalBand: function(xAxisData, width, attributes, optionalLineData) {
	        var range = optionalLineData.range;
	        var positionMaps;

	        if (range && range.length) {
	            this._makeRangeTo2DArray(optionalLineData);
	        }

	        positionMaps = map(optionalLineData.range, function(rangeItem) {
	            return this._createOptionalLinePositionMap({range: rangeItem}, xAxisData, width);
	        }, this);

	        if (optionalLineData.mergeOverlappingRanges) {
	            positionMaps.sort(compareByStartPosition);
	            positionMaps = this._mergeOverlappingPositionMaps(positionMaps);
	        }

	        return map(positionMaps, function(positionMap) {
	            var isStartPositionInsidePlotArea = (positionMap.start) >= 0 && (positionMap.start <= width);
	            var bandWidth, band;

	            if (isStartPositionInsidePlotArea && positionMap.end >= 0) {
	                attributes.color = optionalLineData.color || 'transparent';
	                attributes.opacity = optionalLineData.opacity;
	                bandWidth = positionMap.end - positionMap.start;
	                band = this._renderBand(positionMap.start + this.layout.position.left, bandWidth, attributes);
	            }

	            return band;
	        }, this);
	    },

	    /**
	     * Make optional lines html.
	     * @param {Array.<object>} lines - optional lines
	     * @param {{width: number, height: number}} dimension - dimension
	     * @returns {string}
	     * @private
	     */
	    _makeOptionalLines: function(lines, dimension) {
	        var width = dimension.width;
	        var xAxisData = this.axisDataMap.xAxis;
	        var templateParams = this._makeVerticalLineTemplateParams({
	            height: dimension.height + 'px'
	        });
	        var makeOptionalLineHtml = snippet.bind(this._renderOptionalLine, this, xAxisData, width, templateParams);

	        return map(lines, makeOptionalLineHtml);
	    },

	    /**
	     * Make optional lines html.
	     * @param {Array.<object>} lines - optional lines
	     * @param {{width: number, height: number}} dimension - dimension
	     * @returns {string}
	     * @private
	     */
	    _makeOptionalBands: function(lines, dimension) {
	        var width = dimension.width;
	        var xAxisData = this.axisDataMap.xAxis;
	        var templateParams = this._makeVerticalLineTemplateParams({
	            height: dimension.height + 'px'
	        });
	        var makeOptionalLineHtml = snippet.bind(this._makeOptionalBand, this, xAxisData, width, templateParams);

	        return map(lines, makeOptionalLineHtml);
	    },

	    /**
	     * Render optional lines and bands.
	     * @param {object} paper - paper
	     * @param {{width: number, height: number}} dimension - dimension
	     * @private
	     */
	    _renderOptionalLines: function(paper, dimension) {
	        this.optionalBands = this._makeOptionalBands(this.options.bands, dimension);
	        this.optionalLines = this._makeOptionalLines(this.options.lines, dimension);
	    },

	    /**
	     * Maker html for vertical lines
	     * @param {{width: number, height: number}} dimension - dimension
	     * @param {string} lineColor - line color
	     * @private
	     */
	    _renderVerticalLines: function(dimension, lineColor) {
	        var positions = this._makeHorizontalPositions(dimension.width);
	        var self = this;
	        var layout = this.layout;
	        var left = layout.position.left;
	        var top = layout.position.top;

	        snippet.forEach(positions, function(position) {
	            var pathString = 'M' + (position + left) + ',' + top + 'V' + (top + layout.dimension.height);

	            var path = self.paper.path(pathString);

	            path.attr({
	                stroke: lineColor,
	                'stroke-width': 1
	            });

	            self.plotSet.push(path);
	        });
	    },

	    /**
	     * Maker html for horizontal lines.
	     * @param {{width: number, height: number}} dimension - dimension
	     * @param {string} lineColor - line color
	     * @private
	     */
	    _renderHorizontalLines: function(dimension, lineColor) {
	        var positions = this._makeVerticalPositions(dimension.height);
	        var self = this;
	        var layout = this.layout;
	        var left = layout.position.left;
	        var top = layout.position.top;
	        var distance = positions[1] - positions[0];

	        snippet.forEach(positions, function(position, index) {
	            var pathString = 'M' + left + ',' + ((distance * index) + top) + 'H' + (left + layout.dimension.width);
	            var path = self.paper.path(pathString);

	            path.attr({
	                stroke: lineColor,
	                'stroke-width': 1
	            });

	            self.plotSet.push(path);
	        });
	    },

	    /**
	     * Render plot lines.
	     * @param {HTMLElement} container - container element
	     * @param {{width: number, height: number}} dimension plot area dimension
	     * @private
	     */
	    _renderPlotLines: function(container, dimension) {
	        var theme = this.theme;

	        if (!predicate.isLineTypeChart(this.chartType)) {
	            this._renderVerticalLines(dimension, theme.lineColor);
	        }

	        this._renderHorizontalLines(dimension, theme.lineColor);
	    },

	    /**
	     * Make positions for vertical line.
	     * @param {number} height plot height
	     * @returns {Array.<number>} positions
	     * @private
	     */
	    _makeVerticalPositions: function(height) {
	        var axisDataMap = this.axisDataMap;
	        var yAxis = axisDataMap.yAxis || axisDataMap.rightYAxis;
	        var positions = calculator.makeTickPixelPositions(height, yAxis.validTickCount);

	        positions.shift();

	        return positions;
	    },

	    /**
	     * Make divided positions of plot.
	     * @param {number} width - plot width
	     * @param {number} tickCount - tick count
	     * @returns {Array.<number>}
	     * @private
	     */
	    _makeDividedPlotPositions: function(width, tickCount) {
	        var yAxisWidth = this.dimensionMap.yAxis.width;
	        var leftWidth, rightWidth, leftPositions, rightPositions;

	        tickCount = parseInt(tickCount / 2, 10) + 1;
	        width -= yAxisWidth;
	        leftWidth = Math.round((width) / 2);
	        rightWidth = width - leftWidth;

	        leftPositions = calculator.makeTickPixelPositions(leftWidth, tickCount);
	        rightPositions = calculator.makeTickPixelPositions(rightWidth, tickCount, leftWidth + yAxisWidth);

	        leftPositions.pop();
	        rightPositions.shift();

	        return leftPositions.concat(rightPositions);
	    },

	    /**
	     * Make positions for horizontal line.
	     * @param {number} width plot width
	     * @returns {Array.<number>} positions
	     * @private
	     */
	    _makeHorizontalPositions: function(width) {
	        var tickCount = this.axisDataMap.xAxis.validTickCount;
	        var positions;

	        if (this.options.divided) {
	            positions = this._makeDividedPlotPositions(width, tickCount);
	        } else {
	            positions = calculator.makeTickPixelPositions(width, tickCount);
	            positions.shift();
	        }

	        return positions;
	    },

	    /**
	     * Add plot line.
	     * @param {{index: number, color: string, id: string}} data - data
	     */
	    addPlotLine: function(data) {
	        this.options.lines.push(data);
	        this.rerender();
	    },

	    /**
	     * Add plot band.
	     * @param {{range: Array.<number>, color: string, id: string}} data - data
	     */
	    addPlotBand: function(data) {
	        this.options.bands.push(data);
	        this.rerender();
	    },

	    /**
	     * Remove plot line.
	     * @param {string} id - line id
	     */
	    removePlotLine: function(id) {
	        this.options.lines = snippet.filter(this.options.lines, function(line) {
	            return line.id !== id;
	        });
	        this.rerender();
	    },

	    /**
	     * Remove plot band.
	     * @param {string} id - band id
	     */
	    removePlotBand: function(id) {
	        this.options.bands = snippet.filter(this.options.bands, function(band) {
	            return band.id !== id;
	        });
	        this.rerender();
	    },

	    /**
	     * Animate for adding data.
	     * @param {{tickSize: number, shifting: boolean}} data - data for animation
	     */
	    animateForAddingData: function(data) {
	        var optionLines = this.options.lines;
	        var optionBands = this.options.bands;

	        if (!this.dataProcessor.isCoordinateType()) {
	            if (data.shifting) {
	                this._animateItemForAddingData(this.optionalLines, data, function(itemIdx) {
	                    optionLines.splice(itemIdx, 1);
	                });
	                snippet.forEach(this.optionalBands, function(bandRanges, bandIdx) {
	                    this._animateItemForAddingData(bandRanges, data, function(itemIdx) {
	                        optionBands[bandIdx].range.splice(itemIdx, 1);
	                    });
	                }, this);
	            }
	        }
	    },

	    /**
	     * Animate Item for adding data.
	     * @private
	     * @param {Array.<object>} optionalItems - svg rect elements for animate
	     * @param {{tickSize: number, shifting: boolean}} data - data for animation
	     * @param {function} removePlotItem - function for optional plot delete
	     */
	    _animateItemForAddingData: function(optionalItems, data, removePlotItem) {
	        snippet.forEach(optionalItems, function(item, lineIdx) {
	            var bbox = item.getBBox();

	            if (bbox.x - data.tickSize < this.layout.position.left) {
	                item.animate({
	                    transform: 'T-' + data.tickSize + ',0',
	                    opacity: 0
	                }, 300, 'linear', function() {
	                    removePlotItem(lineIdx);
	                    item.remove();
	                });
	            } else {
	                item.animate({
	                    transform: 'T-' + data.tickSize + ',0'
	                }, 300);
	            }
	        }, this);
	    },

	    /**
	     * Check if  optionalLineData has range property and range property is 2D array
	     * @param {{range: ?Array.<number>}} optionalLineData - optional line data
	     * @private
	     */
	    _makeRangeTo2DArray: function(optionalLineData) {
	        var range = optionalLineData.range;
	        var isOneDimensionArray = range && snippet.isArray(range) &&
	            (range.length === 0 || !snippet.isArray(range[0]));

	        if (isOneDimensionArray) {
	            optionalLineData.range = [range];
	        }
	    },

	    /**
	     * check if some areas are overlapped, and then merge overlapping area
	     * @param {Array.<{start: number, end: number}>} positionMaps - original positionMaps
	     * @returns {Array.<{start: number, end: number}>} - inspected positionMaps
	     * @private
	     */
	    _mergeOverlappingPositionMaps: function(positionMaps) {
	        var i = 1;
	        var len = positionMaps.length;
	        var processedMap, previous, current;

	        if (len) {
	            processedMap = [positionMaps[0]];
	            previous = processedMap[0];
	        }

	        for (; i < len; i += 1) {
	            current = positionMaps[i];

	            if (current.start <= previous.end) {
	                previous.end = Math.max(current.end, previous.end);
	            } else {
	                processedMap.push(current);
	                previous = current;
	            }
	        }

	        return processedMap;
	    }
	});

	/**
	 * Compare positionMap by it's start value
	 * @param {{start: number, end: number}} previous - previouse plot band positionMap
	 * @param {{start: number, end: number}} current - current plot band positionMap
	 * @returns {number} - comparison of whether a is greater than b
	 * @ignore
	 */
	function compareByStartPosition(previous, current) {
	    return previous.start - current.start;
	}

	/**
	 * Factory for Plot
	 * @param {object} param parameter
	 * @returns {object}
	 * @ignore
	 */
	function plotFactory(param) {
	    var chartType = param.chartOptions.chartType;
	    var seriesTypes = param.seriesTypes;
	    var xAxisType = param.chartOptions.xAxis.type;

	    // same among bar, chart, line, area charts
	    param.chartType = chartType;
	    param.chartTypes = seriesTypes;
	    param.xAxisTypeOption = xAxisType;

	    return new Plot(param);
	}

	plotFactory.componentType = 'plot';
	plotFactory.Plot = Plot;

	module.exports = plotFactory;


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview  Title component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var pluginFactory = __webpack_require__(32);
	var snippet = __webpack_require__(6);

	var Title = snippet.defineClass(/** @lends Title.prototype */ {
	    /**
	     * Title component.
	     * @constructs Title
	     * @param {object} params parameters
	     *      @param {object} params.bound title bound
	     *      @param {object} params.theme title theme
	     *      @param {object} params.options title options
	     *      @param {object} params.text title text content
	     */
	    init: function(params) {
	        /**
	         * Theme
	         * @type {object}
	         */
	        this.theme = params.theme || {};

	        /**
	         * Title text content
	         * @type {string}
	         */
	        this.titleText = params.text;

	        /**
	         * Relative offset position
	         * @type {object}
	         */
	        this.offset = params.offset;

	        /**
	         * Graph renderer
	         * @type {object}
	         */
	        this.graphRenderer = pluginFactory.get(chartConst.COMPONENT_TYPE_RAPHAEL, 'title');

	        /**
	         * Drawing type
	         * @type {string}
	         */
	        this.drawingType = chartConst.COMPONENT_TYPE_RAPHAEL;
	    },

	    /**
	     * Render title component
	     * @param {object} data data for render title
	     */
	    render: function(data) {
	        this.titleSet = this._renderTitleArea(data.paper);
	    },

	    /**
	     * Render title component
	     * @param {object} data data for render title
	     */
	    resize: function(data) {
	        var dimensionMap = data.dimensionMap;
	        var legendWidth = dimensionMap.legend ? dimensionMap.legend.width : 0;
	        var width = dimensionMap.series.width + legendWidth;
	        this.graphRenderer.resize(width, this.titleSet);
	    },

	    /**
	     * Render title component
	     * @param {object} data data for render title
	     */
	    rerender: function(data) {
	        this.titleSet.remove();

	        this.render(data);
	    },

	    /**
	     * Render title on given paper
	     * @param {object} paper paper object
	     * @returns {object} raphael paper
	     * @private
	     */
	    _renderTitleArea: function(paper) {
	        return this.graphRenderer.render(paper, this.titleText, this.offset, this.theme);
	    }
	});

	/**
	 * Factory for Title
	 * @param {object} param parameter
	 * @returns {object|null}
	 * @ignore
	 */
	function titleFactory(param) {
	    var options = param.chartOptions.chart || {title: {}};
	    var title = null;

	    if (options.title && options.title.text) {
	        param.text = options.title.text;
	        param.offset = options.title.offset;

	        title = new Title(param);
	    }

	    return title;
	}

	titleFactory.componentType = 'title';
	titleFactory.Title = Title;

	module.exports = titleFactory;


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Radial plot component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var geom = __webpack_require__(49);
	var chartConst = __webpack_require__(8);
	var pluginFactory = __webpack_require__(32);
	var snippet = __webpack_require__(6);

	var RadialPlot = snippet.defineClass(/** @lends Plot.prototype */ {
	    /**
	     * plot component className
	     * @type {string}
	     */
	    className: 'tui-chart-plot-area',

	    /**
	     * Plot component.
	     * @constructs Plot
	     * @param {object} params parameters
	     *      @param {number} params.vTickCount vertical tick count
	     *      @param {number} params.hTickCount horizontal tick count
	     *      @param {object} params.theme axis theme
	     */
	    init: function(params) {
	        /**
	         * Options
	         * @type {object}
	         */
	        this.options = snippet.extend({
	            type: 'spiderweb'
	        }, params.options);

	        /**
	         * Theme
	         * @type {object}
	         */
	        this.theme = params.theme || {};

	        /**
	         * Graph renderer
	         * @type {object}
	         */
	        this.graphRenderer = pluginFactory.get(chartConst.COMPONENT_TYPE_RAPHAEL, 'radialPlot');

	        this.drawingType = chartConst.COMPONENT_TYPE_RAPHAEL;
	    },

	    /**
	     * Render plot area
	     * @param {object} paper paper object
	     * @param {object} layout layout
	     * @param {Array.<Array>} plotPositions plot positions
	     * @param {object} labelData label data
	     * @returns {Array.<object>} plotSet
	     */
	    _renderPlotArea: function(paper, layout, plotPositions, labelData) {
	        var renderParams = {
	            paper: paper,
	            layout: layout,
	            plotPositions: plotPositions,
	            labelData: labelData,
	            theme: this.theme,
	            options: this.options
	        };

	        return this.graphRenderer.render(renderParams);
	    },

	    /**
	     * Make plot positions for render
	     * @param {object} axisDataMap axisDataMap
	     * @param {object} layout layout
	     * @returns {Array.<Array>} plot positions
	     */
	    _makePositions: function(axisDataMap, layout) {
	        var width = layout.dimension.width - chartConst.RADIAL_PLOT_PADDING - chartConst.RADIAL_MARGIN_FOR_CATEGORY;
	        var height = layout.dimension.height - chartConst.RADIAL_PLOT_PADDING - chartConst.RADIAL_MARGIN_FOR_CATEGORY;
	        var centerX = (width / 2) + (chartConst.RADIAL_PLOT_PADDING / 2) + (chartConst.RADIAL_MARGIN_FOR_CATEGORY / 2)
	            + layout.position.left;
	        var centerY = (height / 2) - (chartConst.RADIAL_PLOT_PADDING / 2) - (chartConst.RADIAL_MARGIN_FOR_CATEGORY / 2)
	            - layout.position.top;
	        var stepCount = axisDataMap.yAxis.tickCount;
	        var angleStepCount = axisDataMap.xAxis.labels.length;

	        return makeSpiderWebPositions({
	            width: width,
	            height: height,
	            centerX: centerX,
	            centerY: centerY,
	            angleStepCount: angleStepCount,
	            stepCount: stepCount
	        });
	    },

	    /**
	     * Make category positions
	     * @param {object} axisDataMap axisDataMap
	     * @param {object} layout layout
	     * @returns {Array.<object>} category positions
	     */
	    _makeCategoryPositions: function(axisDataMap, layout) {
	        var width = layout.dimension.width - chartConst.RADIAL_PLOT_PADDING - chartConst.RADIAL_CATEGORY_PADDING;
	        var height = layout.dimension.height - chartConst.RADIAL_PLOT_PADDING - chartConst.RADIAL_CATEGORY_PADDING;
	        var centerX = (width / 2) + (chartConst.RADIAL_PLOT_PADDING / 2) + (chartConst.RADIAL_CATEGORY_PADDING / 2)
	            + layout.position.left;
	        var centerY = (height / 2) - (chartConst.RADIAL_PLOT_PADDING / 2) - (chartConst.RADIAL_CATEGORY_PADDING / 2)
	            - layout.position.top;
	        var angleStepCount = axisDataMap.xAxis.labels.length;

	        return makeRadialCategoryPositions({
	            width: width,
	            height: height,
	            centerX: centerX,
	            centerY: centerY,
	            angleStepCount: angleStepCount
	        });
	    },

	    /**
	     * Make label data
	     * @param {object} axisDataMap axisDataMap
	     * @param {object} dimension dimension
	     * @param {Array.<Array>} plotPositions plot positions
	     * @returns {object}
	     */
	    _makeLabelData: function(axisDataMap, dimension, plotPositions) {
	        var categories = axisDataMap.xAxis.labels;
	        var stepLabels = axisDataMap.yAxis.labels;
	        var categoryPositions = this._makeCategoryPositions(axisDataMap, dimension);
	        var categoryLabelData = [];
	        var stepLabelData = [];
	        var i, j;

	        for (i = 0; i < categories.length; i += 1) {
	            categoryLabelData.push({
	                text: categories[i],
	                position: categoryPositions[i]
	            });
	        }

	        // skip last step label. it could overlapped by category label
	        for (j = 0; j < (stepLabels.length - 1); j += 1) {
	            stepLabelData.push({
	                text: stepLabels[j],
	                position: plotPositions[j][0]
	            });
	        }

	        return {
	            category: categoryLabelData,
	            step: stepLabelData
	        };
	    },

	    /**
	     * Render plot component.
	     * @param {object} data - bounds and scale data
	     */
	    render: function(data) {
	        var plotPositions = this._makePositions(data.axisDataMap, data.layout);
	        var labelData = this._makeLabelData(data.axisDataMap, data.layout, plotPositions);

	        this.plotSet = this._renderPlotArea(data.paper, data.layout, plotPositions, labelData);
	    },

	    /**
	     * Re render plot component
	     * @param {object} data - bounds and scale data
	     */
	    rerender: function(data) {
	        this.plotSet.remove();

	        this.render(data);
	    },

	    /**
	     * Resize plot component.
	     * @param {object} data - bounds and scale data
	     */
	    resize: function(data) {
	        this.rerender(data);
	    }
	});

	/**
	 * Make Spider web positions
	 * @param {object} params parameters
	 *     @param {number} params.width width
	 *     @param {number} params.height height
	 *     @param {number} params.centerX center x coordinate
	 *     @param {number} params.centerY cneter y coordinate
	 *     @param {number} params.angleStepCount angle step count
	 *     @param {number} params.stepCount step count
	 * @returns {Array<Array>} positions
	 * @private
	 */
	function makeSpiderWebPositions(params) {
	    var width = params.width;
	    var height = params.height;
	    var centerX = params.centerX;
	    var centerY = params.centerY;
	    var angleStepCount = params.angleStepCount;
	    var stepCount = params.stepCount;
	    var radius = Math.min(width, height) / 2;
	    var angleStep = 360 / angleStepCount;
	    var points = [];
	    var stepPoints, pointY, point, stepPixel, i, j;

	    stepPixel = radius / (stepCount - 1); // As there is not size in step 0, one step is removed

	    for (i = 0; i < stepCount; i += 1) {
	        stepPoints = [];
	        // point Y of first pixel to rotate
	        pointY = centerY + (stepPixel * i);

	        for (j = 0; j < angleStepCount; j += 1) {
	            point = geom.rotatePointAroundOrigin(centerX, centerY, centerX, pointY, angleStep * j);

	            stepPoints.push({
	                left: point.x,
	                top: height - point.y // convert y to top
	            });
	        }

	        stepPoints.push(stepPoints[0]);

	        points[i] = stepPoints;
	    }

	    return points;
	}

	/**
	 * Make radial category positions
	 * @param {object} params parameters
	 *     @param {number} params.width width
	 *     @param {number} params.height height
	 *     @param {number} params.centerX center x coordinate
	 *     @param {number} params.centerY cneter y coordinate
	 *     @param {number} params.angleStepCount angle step count
	 * @returns {Array<object>} category positions
	 * @private
	 */
	function makeRadialCategoryPositions(params) {
	    var width = params.width;
	    var height = params.height;
	    var centerX = params.centerX;
	    var centerY = params.centerY;
	    var angleStepCount = params.angleStepCount;
	    var radius = Math.min(height, width) / 2;
	    var angleStep = 360 / angleStepCount;
	    var points = [];
	    var anchor, point, i, pointY, reversedAngle;

	    pointY = centerY + radius;

	    for (i = 0; i < angleStepCount; i += 1) {
	        reversedAngle = 360 - (angleStep * i);
	        point = geom.rotatePointAroundOrigin(centerX, centerY, centerX, pointY, reversedAngle);

	        if (reversedAngle > 0 && reversedAngle < 180) {
	            anchor = 'end';
	        } else if (reversedAngle > 180 && reversedAngle < 360) {
	            anchor = 'start';
	        } else {
	            anchor = 'middle';
	        }

	        points.push({
	            left: point.x,
	            top: height - point.y, // convert y to top
	            anchor: anchor
	        });
	    }

	    return points;
	}

	function RadialPlotFactory(param) {
	    return new RadialPlot(param);
	}

	RadialPlotFactory.componentType = 'plot';
	RadialPlotFactory.RadialPlot = RadialPlot;

	module.exports = RadialPlotFactory;


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview module for geometric operation
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);

	/**
	 * Rotate a point around the origin with an angle.
	 * @param {number} centerX center point x
	 * @param {number} centerY center point y
	 * @param {number} pointX point x to rotate
	 * @param {number} pointY point y to rotate
	 * @param {number} angle angle
	 * @returns {object} x, y
	 * @ignore
	 */
	function rotatePointAroundOrigin(centerX, centerY, pointX, pointY, angle) {
	    var rad = angle * (Math.PI / 180);

	    var newX = ((pointX - centerX) * Math.cos(rad)) - ((pointY - centerY) * Math.sin(rad));
	    var newY = ((pointX - centerX) * Math.sin(rad)) + ((pointY - centerY) * Math.cos(rad));

	    newX += centerX;
	    newY += centerY;

	    return {
	        x: newX,
	        y: newY
	    };
	}
	/**
	 * Calculate adjacent.
	 * @param {number} degree degree
	 * @param {number} hypotenuse hypotenuse
	 * @returns {number} adjacent
	 * @ignore
	 *
	 *   H : Hypotenuse
	 *   A : Adjacent
	 *   O : Opposite
	 *   D : Degree
	 *
	 *        /|
	 *       / |
	 *    H /  | O
	 *     /   |
	 *    /\ D |
	 *    -----
	 *       A
	 */
	function calculateAdjacent(degree, hypotenuse) {
	    return Math.cos(degree * chartConst.RAD) * hypotenuse;
	}

	/**
	 * Calculate opposite.
	 * @param {number} degree degree
	 * @param {number} hypotenuse hypotenuse
	 * @returns {number} opposite
	 * @ignore
	 */
	function calculateOpposite(degree, hypotenuse) {
	    return Math.sin(degree * chartConst.RAD) * hypotenuse;
	}

	/**
	 * Calculate rotated width.
	 * @param {number} degree - degree
	 * @param {number} width - width
	 * @param {number} height - height
	 * @returns {number}
	 * @ignore
	 */
	function calculateRotatedWidth(degree, width, height) {
	    var centerHalf = calculateAdjacent(degree, width / 2);
	    var sideHalf = calculateAdjacent(chartConst.ANGLE_90 - degree, height / 2);

	    return (centerHalf + sideHalf) * 2;
	}

	/**
	 * Calculate rotated height
	 * @param {number} degree - degree
	 * @param {number} width - width
	 * @param {number} height - height
	 * @returns {number}
	 * @ignore
	 */
	function calculateRotatedHeight(degree, width, height) {
	    var centerHalf = calculateOpposite(degree, width / 2);
	    var sideHalf = calculateOpposite(chartConst.ANGLE_90 - degree, height / 2);

	    return (centerHalf + sideHalf) * 2;
	}

	module.exports = {
	    rotatePointAroundOrigin: rotatePointAroundOrigin,
	    calculateAdjacent: calculateAdjacent,
	    calculateRotatedHeight: calculateRotatedHeight,
	    calculateRotatedWidth: calculateRotatedWidth,
	    calculateOpposite: calculateOpposite
	};


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview chartExportMenu component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var chartExporter = __webpack_require__(51);
	var dom = __webpack_require__(9);
	var eventListener = __webpack_require__(55);
	var predicate = __webpack_require__(11);
	var renderUtil = __webpack_require__(7);
	var snippet = __webpack_require__(6);

	var CHART_EXPORT_MENU_ITEMS = ['xls', 'csv', 'png', 'jpeg'];
	var CLASS_NAME_CHART_EXPORT_MENU_OPENED = 'menu-opened';

	var ChartExportMenu = snippet.defineClass(/** @lends ChartExportMenu.prototype */ {
	    /**
	     * ChartExportMenu component.
	     * @constructs ChartExportMenu
	     * @private
	     * @param {object} params parameters
	     */
	    init: function(params) {
	        /**
	         * ChartExportMenu view className
	         * @type {string}
	         */
	        this.className = 'tui-chart-chartExportMenu-area';

	        /**
	         * Data processor
	         * @type {DataProcessor}
	         */
	        this.dataProcessor = params.dataProcessor;

	        /**
	         * chart title
	         * @type {string}
	         */
	        this.chartTitle = params.chartTitle || 'tui-chart';

	        /**
	         * export filename
	         * @type {string}
	         */
	        this.exportFilename = params.exportFilename || this.chartTitle;

	        /**
	         * chart type
	         * @type {string}
	         */
	        this.chartType = params.chartType;

	        /**
	         * layout bounds information for this components
	         * @type {null|{dimension:{width:number, height:number}, position:{right:number, top:number}}}
	         */
	        this.layout = null;

	        /**
	         * chartExportMenu container
	         * @type {HTMLElement}
	         */
	        this.chartExportMenuContainer = null;

	        /**
	         * chartExportMenu element
	         * @type {HTMLElement}
	         */
	        this.chartExportMenu = null;

	        /**
	         * chartExportMenu options
	         */
	        this.options = params.options;

	        /**
	         * Event bus
	         * @type {EventBus}
	         */
	        this.eventBus = params.eventBus;

	        this.drawingType = chartConst.COMPONENT_TYPE_DOM;

	        this.theme = params.theme || null;
	    },

	    /**
	     * Create chartExportMenuButton
	     * @returns {HTMLElement}
	     * @private
	     */
	    _createChartExportMenuButton: function() {
	        var menuButton = dom.create('div', chartConst.CLASS_NAME_CHART_EXPORT_MENU_BUTTON);

	        if (this.options.buttonClass) {
	            dom.addClass(menuButton, this.options.buttonClass);
	        }

	        return menuButton;
	    },
	    /**
	     * Render chartExportMenu area.
	     * @param {HTMLElement} chartExportMenuContainer chartExportMenu area element
	     * @private
	     */
	    _renderChartExportMenuArea: function(chartExportMenuContainer) {
	        var menuButton = this._createChartExportMenuButton();
	        var dimension = this.layout.dimension;

	        chartExportMenuContainer.appendChild(menuButton);

	        renderUtil.renderDimension(chartExportMenuContainer, dimension);
	        renderUtil.renderPosition(chartExportMenuContainer, this.layout.position);
	    },

	    /**
	     * Render chartExportMenu area.
	     * @param {HTMLElement} chartExportMenuContainer chartExportMenu area element
	     * @private
	     */
	    _renderChartExportMenu: function(chartExportMenuContainer) {
	        var seriesDataModelMap = this.dataProcessor.seriesDataModelMap;
	        var isDataDownloadAvailable = this.isDataDownloadAvailable(seriesDataModelMap);
	        var isDownloadSupported = chartExporter.isDownloadSupported;
	        var isImageExtension = chartExporter.isImageExtension;
	        var isImageDownloadAvailable = chartExporter.isImageDownloadAvailable;
	        var menuElement = dom.create('ul', chartConst.CLASS_NAME_CHART_EXPORT_MENU);
	        var menuStyle = menuElement.style;
	        var menuTheme = this.theme;
	        var menuItems = [];

	        if (isDownloadSupported && (isDataDownloadAvailable || isImageDownloadAvailable)) {
	            menuItems = snippet.map(CHART_EXPORT_MENU_ITEMS, function(exportItemType) {
	                var itemElement;

	                if ((!isImageExtension(exportItemType) && isDataDownloadAvailable)
	                    || (isImageExtension(exportItemType) && isImageDownloadAvailable)
	                ) {
	                    itemElement = dom.create('li', chartConst.CLASS_NAME_CHART_EXPORT_MENU_ITEM);
	                    itemElement.id = exportItemType;
	                    itemElement.innerHTML = 'Export to .' + exportItemType;
	                }

	                return itemElement;
	            });
	        } else {
	            menuStyle.width = '200px';
	            menuItems[0] = dom.create('li', chartConst.CLASS_NAME_CHART_EXPORT_MENU_ITEM);
	            menuItems[0].innerHTML = 'Browser does not support client-side download.';
	        }

	        if (menuTheme) {
	            if (menuTheme.borderWidth) {
	                menuStyle.borderWidth = menuTheme.borderWidth;
	            }

	            if (menuTheme.borderRadius) {
	                menuStyle.borderRadius = menuTheme.borderRadius;
	            }

	            if (menuTheme.backgroundColor) {
	                menuStyle.backgroundColor = menuTheme.backgroundColor;
	            }

	            if (menuTheme.color) {
	                menuStyle.color = menuTheme.color;
	            }
	        }

	        if (this.options.menuClass) {
	            dom.addClass(menuElement, this.options.menuClass);
	        }

	        dom.append(menuElement, menuItems);

	        this.chartExportMenu = menuElement;

	        dom.append(chartExportMenuContainer, menuElement);
	    },

	    /**
	     * Set data for rendering.
	     * @param {{
	     *      layout: {
	     *          dimension: {width: number, height: number},
	     *          position: {left: number, top: number}
	     *      },
	     *      axisDataMap: object
	     * }} data - bounds and scale data
	     * @private
	     */
	    _setDataForRendering: function(data) {
	        if (data) {
	            this.layout = data.layout;
	            this.dimensionMap = data.dimensionMap;
	            this.axisDataMap = data.axisDataMap;
	        }
	    },

	    /**
	     * Render chartExportMenu component.
	     * @param {object} data - bounds and scale data
	     * @returns {HTMLElement} chartExportMenu element
	     */
	    render: function(data) {
	        var container = null;

	        if (chartExporter.isDownloadSupported) {
	            container = this.container = data.paper;

	            dom.addClass(container, this.className);

	            this._setDataForRendering(data);
	            this._renderChartExportMenuArea(container);
	            this._renderChartExportMenu(container);
	            this.chartExportMenuContainer = container;
	            this._attachEvent();
	        }

	        return container;
	    },

	    /**
	     * Rerender.
	     */
	    rerender: function() {
	        this._hideChartExportMenu();
	    },

	    /**
	     * Resize.
	     */
	    resize: function() {
	    },

	    /**
	     * Show chart export menu
	     * @private
	     */
	    _showChartExportMenu: function() {
	        dom.addClass(this.chartExportMenuContainer, CLASS_NAME_CHART_EXPORT_MENU_OPENED);
	        this.chartExportMenu.style.display = 'block';
	    },

	    /**
	     * Hide chart export menu
	     * @private
	     */
	    _hideChartExportMenu: function() {
	        if (this.chartExportMenuContainer) {
	            dom.removeClass(this.chartExportMenuContainer, CLASS_NAME_CHART_EXPORT_MENU_OPENED);
	            this.chartExportMenu.style.display = 'none';
	        }
	    },

	    /**
	     * onclick event handler
	     * @param {MouseEvent} e mouse event
	     * @private
	     */
	    _onClick: function(e) {
	        var elTarget = e.target || e.srcElement;
	        var svgElement = this.container.parentNode.getElementsByTagName('svg')[0];

	        if (dom.hasClass(elTarget, chartConst.CLASS_NAME_CHART_EXPORT_MENU_ITEM)) {
	            if (elTarget.id) {
	                this.eventBus.fire('beforeImageDownload');

	                chartExporter.exportChart(this.exportFilename, elTarget.id,
	                    this.dataProcessor.rawData, svgElement, this.options);

	                this.eventBus.fire('afterImageDownload');
	            }

	            this._hideChartExportMenu();
	        } else if (dom.hasClass(elTarget, chartConst.CLASS_NAME_CHART_EXPORT_MENU_BUTTON)
	            && (this.chartExportMenuContainer === elTarget.parentNode)
	            && !dom.hasClass(this.chartExportMenuContainer, CLASS_NAME_CHART_EXPORT_MENU_OPENED)) {
	            this._showChartExportMenu();
	        } else {
	            this._hideChartExportMenu();
	        }
	    },

	    /**
	     * Return boolean value for chart data is able to export
	     * @param {object} seriesDataModels series data model
	     * @returns {boolean}
	     */
	    isDataDownloadAvailable: function(seriesDataModels) {
	        var result = true;

	        if (predicate.isTreemapChart(this.chartType)) {
	            result = false;
	        } else {
	            snippet.forEach(seriesDataModels, function(seriesDataModel) {
	                if (seriesDataModel.isCoordinateType) {
	                    result = false;
	                }

	                return false;
	            });
	        }

	        return result;
	    },

	    /**
	     * Attach browser event.
	     * @private
	     */
	    _attachEvent: function() {
	        eventListener.on(this.chartExportMenuContainer.parentNode, 'click', this._onClick, this);
	    },

	    /**
	     * Detach browser event.
	     * @private
	     */
	    _detachEvent: function() {
	        eventListener.off(this.chartExportMenuContainer.parentNode, 'click', this._onClick);
	    }
	});

	/**
	 * Factory for ChartExportMenu
	 * @param {object} params parameter
	 * @returns {object|null}
	 * @ignore
	 */
	function chartExportMenuFactory(params) {
	    var isVisible = params.options.visible;
	    var chartExportMenu = null;
	    var chartOption = params.chartOptions.chart || {};
	    var exportingOption = params.chartOptions.chartExportMenu;

	    if (chartOption.title) {
	        params.chartTitle = chartOption.title.text;
	    }

	    if (exportingOption && exportingOption.filename) {
	        params.exportFilename = exportingOption.filename;
	    }

	    if (isVisible) {
	        chartExportMenu = new ChartExportMenu(params);
	    }

	    return chartExportMenu;
	}

	chartExportMenuFactory.componentType = 'chartExportMenu';

	module.exports = chartExportMenuFactory;


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileOverview Chart exporter
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var arrayUtil = __webpack_require__(10);
	var dataExporter = __webpack_require__(52);
	var imageExporter = __webpack_require__(54);
	var snippet = __webpack_require__(6);

	var browser = snippet.browser;

	var isIE10OrIE11 = browser.msie && (browser.version === 10 || browser.version === 11);
	var isImageDownloadAvailable = !isIE10OrIE11
	    || (isIE10OrIE11 && document.createElement('canvas').getContext('2d').drawSvg);
	var isDownloadAttributeSupported = snippet.isExisty(document.createElement('a').download);
	var isMsSaveOrOpenBlobSupported = window.Blob && window.navigator.msSaveOrOpenBlob;

	/**
	 * Return given extension type is image format
	 * @param {string} extension extension
	 * @returns {boolean}
	 * @ignore
	 */
	function isImageExtension(extension) {
	    return arrayUtil.any(imageExporter.getExtensions(), function(imageExtension) {
	        return extension === imageExtension;
	    });
	}
	/**
	 * Return given extension type is data format
	 * @param {string} extension extension
	 * @returns {boolean}
	 * @ignore
	 */
	function isDataExtension(extension) {
	    return arrayUtil.any(dataExporter.getExtensions(), function(dataExtension) {
	        return extension === dataExtension;
	    });
	}

	/**
	 * Download chart data with given export type
	 * @param {string} fileName - file name = chart title
	 * @param {string} extension - file extension
	 * @param {object} rawData - chart raw data
	 * @param {HTMLElement} svgElement - svg element
	 * @param {object} [downloadOptions] download option
	 * @ignore
	 */
	function exportChart(fileName, extension, rawData, svgElement, downloadOptions) {
	    var downloadOption = (downloadOptions && downloadOptions[extension] ? downloadOptions[extension] : {});

	    if (isImageExtension(extension)) {
	        imageExporter.downloadImage(fileName, extension, svgElement);
	    } else if (isDataExtension(extension)) {
	        dataExporter.downloadData(fileName, extension, rawData, downloadOption);
	    }
	}

	module.exports = {
	    exportChart: exportChart,
	    isDownloadSupported: isDownloadAttributeSupported || isMsSaveOrOpenBlobSupported,
	    isImageDownloadAvailable: isImageDownloadAvailable,
	    isImageExtension: isImageExtension,

	    /**
	     * Add file extension to dataExtension
	     * @param {string} type file extension type
	     * @param {string} extension file extension
	     */
	    addExtension: function(type, extension) {
	        var isValidExtension = extension && snippet.isString(extension);
	        var exporter, extensions;

	        if (type === 'data') {
	            exporter = dataExporter;
	        } else if (type === 'image') {
	            exporter = imageExporter;
	        }

	        if (exporter && isValidExtension) {
	            extensions = exporter.getExtensions();
	            extensions.push(extension);
	        }
	    }
	};


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileOverview Chart data exporter
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var downloader = __webpack_require__(53);
	var chartConst = __webpack_require__(8);
	var snippet = __webpack_require__(6);

	var DATA_URI_HEADERS = {
	    xls: 'data:application/vnd.ms-excel;base64,',
	    csv: 'data:text/csv;charset=utf-8,%EF%BB%BF' /* BOM for utf-8 */
	};
	var DATA_URI_BODY_MAKERS = {
	    xls: _makeXlsBodyWithRawData,
	    csv: _makeCsvBodyWithRawData
	};
	var dataExtensions = [].concat([], chartConst.DATA_EXTENSIONS);

	var dataExporter = {
	    /**
	     * Download chart data
	     * @param {string} fileName file name
	     * @param {string} extension file extension
	     * @param {object} rawData raw data of chart
	     * @param {object} [downloadOption] download option
	     */
	    downloadData: function(fileName, extension, rawData, downloadOption) {
	        var chartData2DArray = _get2DArrayFromRawData(rawData);
	        var content = DATA_URI_HEADERS[extension] + DATA_URI_BODY_MAKERS[extension](chartData2DArray, downloadOption);

	        downloader.execDownload(fileName, extension, content);
	    },

	    /**
	     * Returns data extensions
	     * @returns {Array.<string>}
	     */
	    getExtensions: function() {
	        return dataExtensions;
	    }
	};

	/**
	 * Get pivoted second dimension array from table to use element.innerText
	 * @param {rawData} rawData - chart's raw data
	 * @returns {Array.<Array>}
	 * @private
	 */
	function _get2DArrayFromRawData(rawData) {
	    var resultArray = [];
	    var categories;
	    var isHeatMap = (rawData.categories && snippet.isExisty(rawData.categories.x));
	    var isBullet = (rawData.series && snippet.isExisty(rawData.series.bullet));
	    var return2DArrayData = false;

	    if (rawData) {
	        if (isHeatMap) {
	            return2DArrayData = _get2DArrayFromHeatmapRawData(rawData);
	        } else if (isBullet) {
	            return2DArrayData = _get2DArrayFromBulletRawData(rawData);
	        } else if (rawData.categories) {
	            categories = rawData.categories;
	        }
	        if (return2DArrayData) {
	            return return2DArrayData;
	        }

	        resultArray.push([''].concat(categories));

	        snippet.forEach(rawData.series, function(seriesDatum) {
	            snippet.forEach(seriesDatum, function(seriesItem) {
	                var row = [seriesItem.name].concat(seriesItem.data);

	                resultArray.push(row);
	            });
	        });
	    }

	    return resultArray;
	}

	/**
	 * Make table head data for Excel
	 * @param {number} maxRangeCount - max range count
	 * @param {number} maxMarkerCount - max marker count
	 * @returns {Array.<string>} - table head data
	 * @private
	 */
	function _makeTHeadForBullet(maxRangeCount, maxMarkerCount) {
	    var tableHead = ['', chartConst.BULLET_TYPE_ACTUAL];
	    var i = 0;

	    for (; i < maxRangeCount; i += 1) {
	        tableHead.push(chartConst.BULLET_TYPE_RANGE + i);
	    }

	    i = 0;
	    for (; i < maxMarkerCount; i += 1) {
	        tableHead.push(chartConst.BULLET_TYPE_MARKER + i);
	    }

	    return tableHead;
	}

	/**
	 * Make table cells from bullet ranges
	 * @param {Array.<Array.<number>>} ranges - series item's ranges data
	 * @param {number} maxRangeCount - max range count
	 * @returns {Array.<number>} - cells containing range data
	 * @private
	 */
	function _makeTCellsFromBulletRanges(ranges, maxRangeCount) {
	    var cells = [];
	    var i = 0;
	    var dataText;

	    for (; i < maxRangeCount; i += 1) {
	        dataText = '';

	        if (ranges && ranges[i]) {
	            dataText = ((ranges[i].length > 0) ? ranges[i][0] : '') +
	             '~' + ((ranges[i].length > 1) ? ranges[i][1] : '');
	        }
	        cells.push(dataText);
	    }

	    return cells;
	}

	/**
	 * Make table cells from bullet markers
	 * @param {Array.<Array.<number>>} markers - series item's markers data
	 * @param {number} maxMarkerCount - max marker count
	 * @returns {Array.<number>} - cells containing marker data
	 * @private
	 */
	function _makeTCellsFromBulletMarkers(markers, maxMarkerCount) {
	    var cells = [];
	    var i = 0;
	    var dataText;

	    for (; i < maxMarkerCount; i += 1) {
	        dataText = markers && markers[i] ? markers[i] : '';
	        cells.push(dataText);
	    }

	    return cells;
	}

	/**
	 * Make table data for importing in excel, by using bullet chart raw data
	 * @param {object} rawData - raw data
	 * @param {object} [options] download option
	 * @returns {Array.<Array.<string>>} - table data for importing in excel
	 * @private
	 */
	function _get2DArrayFromBulletRawData(rawData) {
	    var resultArray = [];
	    var maxCounts = _calculateMaxCounts(rawData.series.bullet);
	    var maxRangeCount = maxCounts.maxRangeCount;
	    var maxMarkerCount = maxCounts.maxMarkerCount;

	    resultArray.push(_makeTHeadForBullet(maxRangeCount, maxMarkerCount));

	    snippet.forEach(rawData.series.bullet, function(seriesItem) {
	        var row = [seriesItem.name, seriesItem.data];

	        row = row.concat(_makeTCellsFromBulletRanges(seriesItem.ranges, maxRangeCount));
	        row = row.concat(_makeTCellsFromBulletMarkers(seriesItem.markers, maxMarkerCount));
	        resultArray.push(row);
	    });

	    return resultArray;
	}

	/**
	 * Calculate maxinum count of range and marker property
	 * @param {object} bulletSeries - raw series data of bullet chart
	 * @returns {object} - maximum count of range and marker property
	 * @private
	 */
	function _calculateMaxCounts(bulletSeries) {
	    var maxRangeCount = 0;
	    var maxMarkerCount = 0;

	    snippet.forEach(bulletSeries, function(series) {
	        maxRangeCount = Math.max(maxRangeCount, series.ranges.length);
	        maxMarkerCount = Math.max(maxMarkerCount, series.markers.length);
	    });

	    return {
	        maxRangeCount: maxRangeCount,
	        maxMarkerCount: maxMarkerCount
	    };
	}

	/**
	 * Make table data for importing in excel, by using heatmap chart raw data
	 * @param {object} rawData - raw data
	 * @returns {Array.<Array.<string>>} - table data for importing in excel
	 * @private
	 */
	function _get2DArrayFromHeatmapRawData(rawData) {
	    var resultArray = [];

	    resultArray.push([''].concat(rawData.categories.x));

	    snippet.forEach(rawData.series, function(seriesDatum) {
	        snippet.forEach(seriesDatum, function(seriesItem, index) {
	            var row = [rawData.categories.y[index]].concat(seriesItem);

	            resultArray.push(row);
	        });
	    });

	    return resultArray;
	}

	/**
	 * Get table element from chart data 2D array for xls content
	 * @param {Array.<Array<*>>} chartData2DArray - chart data 2D array
	 * @returns {string}
	 * @private
	 */
	function _getTableElementStringForXls(chartData2DArray) {
	    var tableElementString = '<table>';
	    snippet.forEach(chartData2DArray, function(row, rowIndex) {
	        var cellTagName = rowIndex === 0 ? 'th' : 'td';

	        tableElementString += '<tr>';

	        snippet.forEach(row, function(cell, cellIndex) {
	            var cellNumberClass = (rowIndex !== 0 || cellIndex === 0) ? ' class="number"' : '';
	            var cellString = '<' + cellTagName + cellNumberClass + '>' + cell + '</' + cellTagName + '>';

	            tableElementString += cellString;
	        });

	        tableElementString += '</tr>';
	    });

	    tableElementString += '</table>';

	    return tableElementString;
	}

	/**
	 * Make xls file with chart series data
	 * @param {Array.<Array.<object>>} chartData2DArray - chart chartData2DArray
	 * @returns {string} base64 xls file content
	 * @private
	 */
	function _makeXlsBodyWithRawData(chartData2DArray) {
	    var xlsString = '<html xmlns:o="urn:schemas-microsoft-com:office:office" ' +
	        'xmlns:x="urn:schemas-microsoft-com:office:excel" ' +
	        'xmlns="http://www.w3.org/TR/REC-html40">' +
	        '<head>' +
	            '<!--[if gte mso 9]>' +
	                '<xml>' +
	                    '<x:ExcelWorkbook>' +
	                        '<x:ExcelWorksheets>' +
	                            '<x:ExcelWorksheet>' +
	                                '<x:Name>Ark1</x:Name>' +
	                                '<x:WorksheetOptions>' +
	                                    '<x:DisplayGridlines/>' +
	                                '</x:WorksheetOptions>' +
	                            '</x:ExcelWorksheet>' +
	                        '</x:ExcelWorksheets>' +
	                        '</x:ExcelWorkbook>' +
	                '</xml>' +
	            '<![endif]-->' +
	            '<meta name=ProgId content=Excel.Sheet>' +
	            '<meta charset=UTF-8>' +
	        '</head>' +
	        '<body>' +
	            _getTableElementStringForXls(chartData2DArray) +
	        '</body>' +
	        '</html>';

	    return window.btoa(unescape(encodeURIComponent(xlsString)));
	}

	/**
	 * Make csv text with chart series data
	 * @param {Array.<Array.<object>>} chartData2DArray - chart chartData2DArray
	 * @param {object} [option] - download option
	 * @param {object} [option.itemDelimiter = ','] - item delimiter
	 * @param {object} [option.lineDelimiter = '\n'] - line delimiter
	 * @returns {string} URI encoded csv text
	 * @private
	 */
	function _makeCsvBodyWithRawData(chartData2DArray, option) {
	    var csvText = '';
	    var lineDelimiter = (option && option.lineDelimiter) || '\u000a';
	    var itemDelimiter = (option && option.itemDelimiter) || ',';
	    var lastRowIndex = chartData2DArray.length - 1;

	    snippet.forEachArray(chartData2DArray, function(row, rowIndex) {
	        var lastCellIndex = row.length - 1;

	        snippet.forEachArray(row, function(cell, cellIndex) {
	            var cellContent = (snippet.isNumber(cell) ? cell : '"' + cell + '"');

	            csvText += cellContent;

	            if (cellIndex < lastCellIndex) {
	                csvText += itemDelimiter;
	            }
	        });

	        if (rowIndex < lastRowIndex) {
	            csvText += lineDelimiter;
	        }
	    });

	    return encodeURIComponent(csvText);
	}

	// export private methods for Test
	dataExporter._makeCsvBodyWithRawData = _makeCsvBodyWithRawData;
	dataExporter._makeXlsBodyWithRawData = _makeXlsBodyWithRawData;
	dataExporter._get2DArrayFromRawData = _get2DArrayFromRawData;
	dataExporter._get2DArrayFromBulletRawData = _get2DArrayFromBulletRawData;
	dataExporter._get2DArrayFromHeatmapRawData = _get2DArrayFromHeatmapRawData;
	dataExporter._makeTCellsFromBulletRanges = _makeTCellsFromBulletRanges;
	dataExporter._makeTCellsFromBulletMarkers = _makeTCellsFromBulletMarkers;
	dataExporter._makeTHeadForBullet = _makeTHeadForBullet;

	module.exports = dataExporter;


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileOverview File downloader for client-side download
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);
	var arrayUtil = __webpack_require__(10);
	var chartConst = __webpack_require__(8);

	var DOWNLOAD_HANDLERS = {
	    downloadAttribute: downloadWithAnchorElementDownloadAttribute,
	    msSaveOrOpenBlob: downloadWithMsSaveOrOpenBlob
	};

	/**
	 * Return download method name of current browser supports
	 * @returns {string}
	 * @ignore
	 */
	function getDownloadMethod() {
	    var isDownloadAttributeSupported = snippet.isExisty(document.createElement('a').download);
	    var isMsSaveOrOpenBlobSupported = window.Blob && window.navigator.msSaveOrOpenBlob;
	    var method;

	    if (isMsSaveOrOpenBlobSupported) {
	        method = 'msSaveOrOpenBlob';
	    } else if (isDownloadAttributeSupported) {
	        method = 'downloadAttribute';
	    }

	    return method;
	}

	/**
	 * Base64 string to blob
	 * original source ref: https://github.com/miguelmota/base64toblob/blob/master/base64toblob.js
	 * Licence: MIT Licence
	 * @param {string} base64String - base64 string
	 * @returns {Blob}
	 * @ignore
	 */
	function base64toBlob(base64String) {
	    var contentType = base64String.substr(0, base64String.indexOf(';base64,')).substr(base64String.indexOf(':') + 1);
	    var sliceSize = 1024;
	    var byteCharacters = atob(base64String.substr(base64String.indexOf(',') + 1));
	    var byteArrays = [];
	    var offset, slice, byteNumbers, i, byteArray, resultBlob;

	    for (offset = 0; offset < byteCharacters.length; offset += sliceSize) {
	        slice = byteCharacters.slice(offset, offset + sliceSize);

	        byteNumbers = new Array(slice.length);

	        for (i = 0; i < slice.length; i += 1) {
	            byteNumbers[i] = slice.charCodeAt(i);
	        }

	        byteArray = new window.Uint8Array(byteNumbers);

	        byteArrays.push(byteArray);
	    }

	    resultBlob = new Blob(byteArrays, {type: contentType});

	    return resultBlob;
	}

	/**
	 * Return given extension type is image format
	 * @param {string} extension extension
	 * @returns {boolean}
	 * @ignore
	 */
	function isImageExtension(extension) {
	    return arrayUtil.any(chartConst.IMAGE_EXTENSIONS, function(imageExtension) {
	        return extension === imageExtension;
	    });
	}

	/**
	 * Download content to file with msSaveOrOpenBlob
	 * @param {string} fileName - file name
	 * @param {string} extension - file extension
	 * @param {string} content - file content
	 * @ignore
	 */
	function downloadWithMsSaveOrOpenBlob(fileName, extension, content) {
	    var blobObject = isImageExtension(extension) ? base64toBlob(content) : new Blob([content]);

	    window.navigator.msSaveOrOpenBlob(blobObject, fileName + '.' + extension);
	}

	/**
	 * Download content to file with anchor element's download attribute
	 * @param {string} fileName - file name
	 * @param {string} extension - file extension
	 * @param {string} content - file content
	 * @ignore
	 */
	function downloadWithAnchorElementDownloadAttribute(fileName, extension, content) {
	    var anchorElement;

	    if (content) {
	        anchorElement = document.createElement('a');

	        anchorElement.href = content;
	        anchorElement.target = '_blank';
	        anchorElement.download = fileName + '.' + extension;

	        document.body.appendChild(anchorElement);

	        anchorElement.click();
	        anchorElement.remove();
	    }
	}

	/**
	 * Download content to file with given filename and extension
	 * @param {string} fileName - file name
	 * @param {string} extension - file extension
	 * @param {string} content - file content
	 * @ignore
	 */
	function execDownload(fileName, extension, content) {
	    var downloadMethod = getDownloadMethod();

	    if (downloadMethod && snippet.isString(content)) {
	        DOWNLOAD_HANDLERS[downloadMethod](fileName, extension, content);
	    }
	}

	module.exports = {
	    execDownload: execDownload
	};


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileOverview Chart image exporter
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var downloader = __webpack_require__(53);
	var chartConst = __webpack_require__(8);
	var snippet = __webpack_require__(6);

	var browser = snippet.browser;
	var isIE10OrIE11 = browser.msie && (browser.version === 10 || browser.version === 11);
	var DOMURL = window.URL || window.webkitURL || window;
	var imageExtensions = [].concat([], chartConst.IMAGE_EXTENSIONS);

	/**
	 * Return svg outerHTML string
	 * @param {HTMLElement} svgElement svg element
	 * @returns {string}
	 * @ignore
	 */
	function getSvgString(svgElement) {
	    var svgParent = svgElement.parentNode;
	    var tempWrapper = document.createElement('DIV');
	    var svgString;

	    tempWrapper.appendChild(svgElement);
	    svgString = tempWrapper.innerHTML;
	    svgParent.appendChild(svgElement);

	    tempWrapper = null;
	    svgParent = null;

	    return svgString;
	}

	/**
	 * Download with SVG string and canvg
	 * @param {HTMLElement} canvas canvas element
	 * @param {string} svgString svg HTML string
	 * @param {string} fileName file name
	 * @param {string} extension file extension
	 * @ignore
	 */
	function downloadSvgWithCanvg(canvas, svgString, fileName, extension) {
	    var ctx = canvas.getContext('2d');

	    // remove name space for IE
	    if (isIE10OrIE11) {
	        svgString = svgString.replace(/xmlns:NS1=""/, '');
	        svgString = svgString.replace(/NS1:xmlns:xlink="http:\/\/www\.w3\.org\/1999\/xlink"/, '');
	        svgString = svgString.replace(/xmlns="http:\/\/www\.w3\.org\/2000\/svg"/, '');
	        svgString = svgString.replace(/xmlns:xlink="http:\/\/www\.w3\.org\/1999\/xlink"/, '');
	    }

	    ctx.drawSvg(svgString, 0, 0);

	    downloader.execDownload(fileName, extension, canvas.toDataURL('image/' + extension, 1));
	}

	/**
	 * Download with SVG string and blob URL
	 * @param {HTMLElement} canvas canvas element
	 * @param {string} svgString svg HTML string
	 * @param {string} fileName file name
	 * @param {string} extension file extension
	 * @ignore
	 */
	function downloadSvgWithBlobURL(canvas, svgString, fileName, extension) {
	    var ctx = canvas.getContext('2d');
	    var blob = new Blob([svgString], {type: 'image/svg+xml'});
	    var url = DOMURL.createObjectURL(blob);
	    var img = new Image();

	    img.onload = function() {
	        ctx.drawImage(img, 0, 0, canvas.width, canvas.height);

	        downloader.execDownload(fileName, extension, canvas.toDataURL('image/' + extension, 1));

	        DOMURL.revokeObjectURL(url);
	    };

	    img.src = url;
	}

	module.exports = {
	    /**
	     * Download image with png format
	     * @param {string} fileName - file name to save
	     * @param {string} extension - extension type
	     * @param {HTMLElement} imageSourceElement - image source element
	     */
	    downloadImage: function(fileName, extension, imageSourceElement) {
	        var svgString, parentNode, canvas;

	        if (imageSourceElement.tagName === 'svg') {
	            parentNode = imageSourceElement.parentNode;

	            canvas = document.createElement('canvas');

	            canvas.width = parentNode.offsetWidth;
	            canvas.height = parentNode.offsetHeight;

	            svgString = getSvgString(imageSourceElement);

	            if (isIE10OrIE11) {
	                downloadSvgWithCanvg(canvas, svgString, fileName, extension);
	            } else {
	                downloadSvgWithBlobURL(canvas, svgString, fileName, extension);
	            }
	        } else if (imageSourceElement.tagName === 'canvas') {
	            canvas = imageSourceElement;

	            downloader.execDownload(fileName, extension, canvas.toDataURL('image/' + extension, 1));
	        }
	    },

	    /**
	     * Returns data extensions
	     * @returns {Array.<string>}
	     */
	    getExtensions: function() {
	        return imageExtensions;
	    }
	};


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Event listener.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);

	var bindHandlerMap = {};

	/**
	 * Event listener.
	 * @module eventListener
	 * @private */
	var eventListener = {
	    /**
	     * Add event listener for IE.
	     * @memberOf module:eventListener
	     * @param {HTMLElement} target target element
	     * @param {string} type event type
	     * @param {function} handler callback function
	     * @param {?object} context context for callback
	     * @private
	     */
	    _attachEvent: function(target, type, handler, context) {
	        var bindHandler;

	        if (context) {
	            bindHandler = snippet.bind(handler, context);
	        } else {
	            bindHandler = handler;
	        }

	        bindHandlerMap[type + handler] = bindHandler;
	        target.attachEvent('on' + type, bindHandler);
	    },

	    /**
	     * Add event listener for other browsers.
	     * @memberOf module:eventListener
	     * @param {HTMLElement} target - target element
	     * @param {string} type - event type
	     * @param {function} handler - handler
	     * @param {object} [context] - context for handler
	     * @private
	     */
	    _addEventListener: function(target, type, handler, context) {
	        var bindHandler;

	        if (context) {
	            bindHandler = snippet.bind(handler, context);
	        } else {
	            bindHandler = handler;
	        }

	        bindHandlerMap[type + handler] = bindHandler;
	        target.addEventListener(type, bindHandler);
	    },

	    /**
	     * Bind DOM event.
	     * @memberOf module:eventListener
	     * @memberOf module:eventListener
	     * @param {HTMLElement} target target element
	     * @param {string} type event type
	     * @param {function} handler handler function
	     * @param {object} [context] - context for handler
	     * @private
	     */
	    _bindEvent: function(target, type, handler, context) {
	        var bindEvent;

	        if ('addEventListener' in target) {
	            bindEvent = this._addEventListener;
	        } else if ('attachEvent' in target) {
	            bindEvent = this._attachEvent;
	        }
	        eventListener._bindEvent = bindEvent;

	        bindEvent(target, type, handler, context);
	    },

	    /**
	     * Bind DOM events.
	     * @memberOf module:eventListener
	     * @param {HTMLElement} target - target element
	     * @param {string | object} types - type or map of type and handler
	     * @param {function | object} [handler] - handler or context
	     * @param {object} [context] - context
	     */
	    on: function(target, types, handler, context) {
	        var handlerMap = {};
	        if (snippet.isString(types)) {
	            handlerMap[types] = handler;
	        } else {
	            handlerMap = types;
	            context = handler;
	        }

	        snippet.forEach(handlerMap, function(_handler, type) {
	            eventListener._bindEvent(target, type, _handler, context);
	        });
	    },

	    /**
	     * Remove event listener for IE.
	     * @memberOf module:eventListener
	     * @param {HTMLElement} target - target element
	     * @param {string} type - event type
	     * @param {function} handler - handler
	     * @private
	     */
	    _detachEvent: function(target, type, handler) {
	        if (bindHandlerMap[type + handler]) {
	            target.detachEvent('on' + type, bindHandlerMap[type + handler]);
	            delete bindHandlerMap[type + handler];
	        }
	    },

	    /**
	     * Add event listener for other browsers.
	     * @memberOf module:eventListener
	     * @param {HTMLElement} target - target element
	     * @param {string} type - event type
	     * @param {function} handler - handler
	     * @private
	     */
	    _removeEventListener: function(target, type, handler) {
	        target.removeEventListener(type, bindHandlerMap[type + handler]);
	        delete bindHandlerMap[type + handler];
	    },

	    /**
	     * Unbind DOM event.
	     * @memberOf module:eventListener
	     * @param {HTMLElement} target - target element
	     * @param {string} type - event type
	     * @param {function} handler - handler
	     * @private
	     */
	    _unbindEvent: function(target, type, handler) {
	        var unbindEvent;
	        if ('removeEventListener' in target) {
	            unbindEvent = eventListener._removeEventListener;
	        } else if ('detachEvent' in target) {
	            unbindEvent = eventListener._detachEvent;
	        }
	        eventListener._unbindEvent = unbindEvent;

	        unbindEvent(target, type, handler);
	    },

	    /**
	     * Unbind DOM events.
	     * @memberOf module:eventListener
	     * @param {HTMLElement} target - target element
	     * @param {string | object} types - type or map of type and handler
	     * @param {function} [handler] - handler
	     */
	    off: function(target, types, handler) {
	        var handlerMap = {};
	        if (snippet.isString(types)) {
	            handlerMap[types] = handler;
	        } else {
	            handlerMap = types;
	        }

	        snippet.forEach(handlerMap, function(_handler, type) {
	            eventListener._unbindEvent(target, type, _handler);
	        });
	    }
	};

	module.exports = eventListener;


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview  Legend component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var LegendModel = __webpack_require__(57);
	var pluginFactory = __webpack_require__(32);
	var predicate = __webpack_require__(11);
	var raphaelRenderUtil = __webpack_require__(5);
	var snippet = __webpack_require__(6);

	var ICON_HEIGHT = chartConst.LEGEND_ICON_HEIGHT;

	var Legend = snippet.defineClass(/** @lends Legend.prototype */ {
	    /**
	     * Legend component.
	     * @constructs Legend
	     * @private
	     * @param {object} params parameters
	     *      @param {object} params.theme - axis theme
	     *      @param {?Array.<string>} params.seriesTypes - series types
	     *      @param {string} params.chart - chart type
	     *      @param {object} params.dataProcessor - data processor
	     *      @param {object} params.eventBus - chart event bus
	     */
	    init: function(params) {
	        /**
	         * legend theme
	         * @type {object}
	         */
	        this.theme = params.theme;

	        /**
	         * options
	         * @type {Object}
	         */
	        this.options = params.options || {};

	        /**
	         * chart type
	         * @type {string}
	         */
	        this.chartType = params.chartType;

	        /**
	         * series types
	         * @type {?Array.<string>}
	         */
	        this.seriesTypes = params.seriesTypes || [this.chartType];

	        /**
	         * event bus for transmitting message
	         * @type {object}
	         */
	        this.eventBus = params.eventBus;

	        /**
	         * Legend view className
	         */
	        this.className = 'tui-chart-legend-area';

	        /**
	         * DataProcessor instance
	         * @type {DataProcessor}
	         */
	        this.dataProcessor = params.dataProcessor;

	        /**
	         * legend model
	         */
	        this.legendModel = new LegendModel({
	            theme: this.theme,
	            labels: params.dataProcessor.getLegendLabels(),
	            legendData: params.dataProcessor.getLegendData(),
	            seriesTypes: this.seriesTypes,
	            chartType: this.chartType
	        });

	        /**
	         * layout bounds information for this components
	         * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number}}}
	         */
	        this.layout = null;

	        /**
	         * Graph renderer
	         * @type {object}
	         */
	        this.graphRenderer = pluginFactory.get(chartConst.COMPONENT_TYPE_RAPHAEL, 'legend');

	        /**
	         * Paper for rendering legend
	         * @type {object}
	         */
	        this.paper = null;

	        this.drawingType = chartConst.COMPONENT_TYPE_RAPHAEL;
	    },

	    /**
	     * Set data for rendering.
	     * @param {{
	     *      layout: {
	     *          dimension: {width: number, height: number},
	     *          position: {left: number, top: number}
	     *      }
	     * }} data - bounds data
	     * @private
	     */
	    _setDataForRendering: function(data) {
	        if (data) {
	            this.layout = data.layout;
	            this.paper = data.paper;
	        }
	    },

	    /**
	     * Render legend component.
	     * @param {object} data - bounds data
	     */
	    _render: function(data) {
	        this._setDataForRendering(data);
	        this.legendSet = this._renderLegendArea(data.paper);
	    },

	    /**
	     * Render legend component and listen legend event.
	     * @param {object} data - bounds data
	     */
	    render: function(data) {
	        this._render(data);

	        this._listenEvents();
	    },

	    /**
	     * Rerender.
	     * @param {object} data - bounds data
	     */
	    rerender: function(data) {
	        this.legendSet.remove();

	        this._render(data);
	    },

	    /**
	     * Rerender, when resizing chart.
	     * @param {object} data - bounds data
	     */
	    resize: function(data) {
	        this.rerender(data);
	    },

	    /**
	     * Get legend rendering data
	     * @param {object} legendData legned data
	     * @param {number} labelHeight lebel height
	     * @param {Array.<number>} labelWidths label widths
	     * @returns {Array.<object>}
	     * @private
	     */
	    _getLegendRenderingData: function(legendData, labelHeight, labelWidths) {
	        var maxWidth = this.options.maxWidth;
	        var colorByPoint = (predicate.isBarTypeChart(this.chartType) || predicate.isBoxplotChart(this.chartType))
	            && this.dataProcessor.options.series.colorByPoint;

	        return snippet.map(legendData, function(legendDatum, index) {
	            var checkbox = this.options.showCheckbox === false ? null : {
	                checked: this.legendModel.isCheckedIndex(index)
	            };
	            var legendLabel = legendDatum.label;

	            if (maxWidth) {
	                legendLabel = raphaelRenderUtil.getEllipsisText(legendLabel, maxWidth, this.theme.label);
	            }

	            return {
	                checkbox: checkbox,
	                iconType: legendDatum.chartType || 'rect',
	                colorByPoint: colorByPoint,
	                index: index,
	                theme: legendDatum.theme,
	                label: legendLabel,
	                labelHeight: labelHeight,
	                labelWidth: labelWidths[index],
	                isUnselected: this.legendModel.isUnselectedIndex(index)
	            };
	        }, this);
	    },

	    /**
	     * Render legend area.
	     * @param {object} paper paper object
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderLegendArea: function(paper) {
	        var legendData = this.legendModel.getData();
	        var graphRenderer = this.graphRenderer;
	        var isHorizontal = predicate.isHorizontalLegend(this.options.align);
	        var basePosition = this.layout.position;
	        var labelWidths = graphRenderer.makeLabelWidths(legendData, this.theme.label, this.options.maxWidth);
	        var labelTheme = legendData[0] ? legendData[0].theme : {};
	        var labelHeight = graphRenderer.getRenderedLabelHeight('DEFAULT_TEXT', labelTheme) - 1;
	        var labelCount = labelWidths.length;
	        var legendItemHeight = Math.max(ICON_HEIGHT, labelHeight);
	        var dimensionHeight = (chartConst.LINE_MARGIN_TOP + legendItemHeight) * (isHorizontal ? 1 : labelCount);
	        var left = basePosition.left;

	        if (!predicate.isLegendAlignLeft(this.options.align)) {
	            left += chartConst.LEGEND_AREA_PADDING;
	        }

	        return graphRenderer.render({
	            paper: paper,
	            legendData: this._getLegendRenderingData(legendData, labelHeight, labelWidths),
	            isHorizontal: isHorizontal,
	            position: {
	                left: left,
	                top: basePosition.top + chartConst.LEGEND_AREA_PADDING + chartConst.CHART_PADDING
	            },
	            dimension: {
	                height: dimensionHeight,
	                width: this.layout.dimension.width
	            },
	            labelTheme: this.theme.label,
	            labelWidths: labelWidths,
	            eventBus: this.eventBus
	        });
	    },

	    /**
	     * Fire onChangeCheckedLegends event.
	     * @private
	     */
	    _fireChangeCheckedLegendsEvent: function() {
	        this.eventBus.fire('changeCheckedLegends', this.legendModel.getCheckedIndexes());
	    },

	    /**
	     * Fire selectLegend event.
	     * @param {{chartType: string, index: number}} data data
	     * @private
	     */
	    _fireSelectLegendEvent: function(data) {
	        var index = this.legendModel.getSelectedIndex();
	        var legendIndex = !snippet.isNull(index) ? data.seriesIndex : index;

	        this.eventBus.fire('selectLegend', data.chartType, legendIndex);
	    },

	    /**
	     * Fire selectLegend public event.
	     * @param {{label: string, chartType: string, index: number}} data data
	     * @private
	     */
	    _fireSelectLegendPublicEvent: function(data) {
	        this.eventBus.fire(chartConst.PUBLIC_EVENT_PREFIX + 'selectLegend', {
	            legend: data.label,
	            chartType: data.chartType,
	            index: data.index
	        });
	    },

	    /**
	     * Select legend.
	     * @param {number} index index
	     * @private
	     */
	    _selectLegend: function(index) {
	        var data = this.legendModel.getDatum(index);

	        this.legendModel.toggleSelectedIndex(index);

	        if (!snippet.isNull(this.legendModel.getSelectedIndex()) && !this.legendModel.isCheckedSelectedIndex()) {
	            this.legendModel.checkSelectedIndex();
	            this._fireChangeCheckedLegendsEvent();
	        }

	        this.dataProcessor.selectLegendIndex = this.legendModel.getSelectedIndex();

	        this.graphRenderer.selectLegend(this.dataProcessor.selectLegendIndex, this.legendSet);

	        this._fireSelectLegendEvent(data);
	        this._fireSelectLegendPublicEvent(data);
	    },

	    /**
	     * Get checked indexes.
	     * @returns {Array} checked indexes
	     * @private
	     */
	    _getCheckedIndexes: function() {
	        var checkedIndexes = [];

	        snippet.forEachArray(this.legendModel.checkedWholeIndexes, function(checkbox, index) {
	            if (checkbox) {
	                checkedIndexes.push(index);
	            }
	        });

	        return checkedIndexes;
	    },

	    /**
	     * Check legend.
	     * @private
	     */
	    _checkLegend: function() {
	        var selectedData = this.legendModel.getSelectedDatum();

	        if (!this.legendModel.isCheckedSelectedIndex()) {
	            this.legendModel.updateSelectedIndex(null);
	        }

	        this._fireChangeCheckedLegendsEvent();

	        if (selectedData) {
	            this._fireSelectLegendEvent(selectedData);
	        }
	    },

	    /**
	     * On click event handler.
	     * @param {number} index checkbox index
	     * @private
	     */
	    _checkboxClick: function(index) {
	        var checkedIndexes;

	        this.legendModel.toggleCheckedIndex(index);

	        checkedIndexes = this._getCheckedIndexes();

	        if (checkedIndexes.length > 0) {
	            this.legendModel.updateCheckedLegendsWith(checkedIndexes);
	            this._checkLegend();
	        } else {
	            this.legendModel.toggleCheckedIndex(index);
	        }
	    },

	    /**
	     * On click event handler.
	     * @param {number} index selected index
	     * @private
	     */
	    _labelClick: function(index) {
	        this._selectLegend(index);
	    },

	    /**
	     * Listen legend events
	     * @private
	     */
	    _listenEvents: function() {
	        this.eventBus.on('checkboxClicked', this._checkboxClick, this);
	        this.eventBus.on('labelClicked', this._labelClick, this);
	    }
	});

	snippet.CustomEvents.mixin(Legend);

	/**
	 * Factory for Legend
	 * @param {object} params parameter
	 * @returns {object|null}
	 * @ignore
	 */
	function legendFactory(params) {
	    var isLegendVisible = snippet.isUndefined(params.options.visible) ? true : params.options.visible;
	    var seriesTypes = params.dataProcessor.seriesTypes;
	    var chartType = params.chartOptions.chartType;
	    var legend = null;

	    if (isLegendVisible) {
	        params.seriesTypes = seriesTypes;
	        params.chartType = chartType;

	        // @todo should extends additionalParams added when addComponents(), should grasp the omitted
	        legend = new Legend(params);
	    }

	    return legend;
	}

	legendFactory.componentType = 'legend';
	legendFactory.Legend = Legend;

	module.exports = legendFactory;


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview LegendModel is a model for legend area(checkbox, icon, label text)
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);

	var concat = Array.prototype.concat;
	var forEachArray = snippet.forEachArray;

	var LegendModel = snippet.defineClass(/** @lends LegendModel.prototype */ {
	    /**
	     * LegendModel is legend model.
	     * @constructs LegendModel
	     * @private
	     * @param {object} params parameters
	     *      @param {number} params.labels legend labels
	     *      @param {object} params.bound axis bound
	     *      @param {object} params.theme axis theme
	     */
	    init: function(params) {
	        /**
	         * legend theme
	         * @type {Object}
	         */
	        this.theme = params.theme;

	        /**
	         * legend labels
	         * @type {Array.<string> | {column: ?Array.<string>, line: ?Array.<string>}}
	         */
	        this.labels = params.labels;

	        /**
	         * label infos
	         * @type {Array.<{chartType: string, label: string, index: number}>}
	         */
	        this.legendData = params.legendData;

	        /**
	         * chart types
	         * @type {?Array.<string>}
	         */
	        this.seriesTypes = params.seriesTypes || [];

	        /**
	         * chart type
	         * @type {string}
	         */
	        this.chartType = params.chartType;

	        /**
	         * Legend data
	         * @type {?Array}
	         */
	        this.data = null;

	        /**
	         * Selected legend index.
	         * @type {?number}
	         */
	        this.selectedIndex = null;

	        /**
	         * sending data to series
	         * @type {object}
	         */
	        this.checkedIndexesMap = {};

	        /**
	         * checked indexes
	         * @type {Array}
	         */
	        this.checkedWholeIndexes = [];

	        this._setData();
	        this._initCheckedIndexes();
	    },

	    /**
	     * Initialize checked data.
	     * @private
	     */
	    _initCheckedIndexes: function() {
	        var self = this;
	        var checkedIndexes = [];
	        forEachArray(this.legendData, function(legendDatum, index) {
	            if (legendDatum.visible) {
	                checkedIndexes.push(index);
	            }
	            self.checkedWholeIndexes[index] = legendDatum.visible;
	        });

	        this.updateCheckedLegendsWith(checkedIndexes);
	    },

	    /**
	     * Set theme to legend data.
	     * @param {Array.<object>} legendData - legend data
	     * @param {{
	     *     colors: Array.<string>,
	     *     borderColor: ?string
	     *     }} colorTheme - legend theme
	     * @param {Array.<boolean>} [checkedIndexes] - checked indexes
	     * @private
	     */
	    _setThemeToLegendData: function(legendData, colorTheme, checkedIndexes) {
	        var seriesIndex = 0;

	        forEachArray(legendData, function(datum, index) {
	            var itemTheme = {
	                color: colorTheme.colors[index]
	            };

	            if (colorTheme.borderColor) {
	                itemTheme.borderColor = colorTheme.borderColor;
	            }

	            datum.theme = itemTheme;
	            datum.index = index;

	            if (!checkedIndexes || !snippet.isUndefined(checkedIndexes[index])) {
	                datum.seriesIndex = seriesIndex;
	                seriesIndex += 1;
	            } else {
	                datum.seriesIndex = -1;
	            }
	        });
	    },

	    /**
	     * Set legend data.
	     * @private
	     */
	    _setData: function() {
	        var self = this;
	        var theme = this.theme;
	        var chartType = this.chartType;
	        var seriesTypes = this.seriesTypes;
	        var legendData = this.legendData;
	        var checkedIndexesMap = this.checkedIndexesMap;
	        var data, startIndex;

	        if (!seriesTypes || seriesTypes.length < 2) {
	            this._setThemeToLegendData(legendData, theme[chartType], checkedIndexesMap[chartType]);
	            data = legendData;
	        } else {
	            startIndex = 0;
	            data = concat.apply([], snippet.map(seriesTypes, function(seriesType) {
	                var labelLen = self.labels[seriesType].length;
	                var endIndex = startIndex + labelLen;
	                var slicedLegendData, checkedIndexes;

	                slicedLegendData = legendData.slice(startIndex, endIndex);
	                checkedIndexes = checkedIndexesMap[seriesType];
	                startIndex = endIndex;
	                self._setThemeToLegendData(slicedLegendData, theme[seriesType], checkedIndexes);

	                return slicedLegendData;
	            }));
	        }

	        this.data = data;
	    },

	    /**
	     * Get legend data.
	     * @returns {Array.<{chartType: string, label: string, theme: object}>} legend data
	     */
	    getData: function() {
	        return this.data;
	    },

	    /**
	     * Get legend datum by index.
	     * @param {number} index legend index
	     * @returns {{chartType: string, label: string, theme: object}} legend datum
	     */
	    getDatum: function(index) {
	        return this.data[index];
	    },

	    /**
	     * Get legend datum by label
	     * @param {string} label - legend label
	     * @returns {{chartType: string, label: string, theme: object}} legend datum
	     */
	    getDatumByLabel: function(label) {
	        var foundDatum = null;
	        forEachArray(this.data, function(datum) {
	            if (datum.label === label) {
	                foundDatum = datum;
	            }

	            return !foundDatum;
	        });

	        return foundDatum;
	    },

	    /**
	     * Get selected datum.
	     * @returns {{chartType: string, label: string, theme: Object}} legend datum
	     */
	    getSelectedDatum: function() {
	        return this.getDatum(this.selectedIndex);
	    },

	    /**
	     * Update selected index.
	     * @param {?number} value value
	     */
	    updateSelectedIndex: function(value) {
	        this.selectedIndex = value;
	    },

	    /**
	     * Toggle selected index.
	     * @param {number} index legend index
	     */
	    toggleSelectedIndex: function(index) {
	        var selectedIndex;

	        if (this.selectedIndex === index) {
	            selectedIndex = null;
	        } else {
	            selectedIndex = index;
	        }

	        this.updateSelectedIndex(selectedIndex);
	    },

	    /**
	     * Get selected index.
	     * @returns {number} selected index
	     */
	    getSelectedIndex: function() {
	        return this.selectedIndex;
	    },

	    /**
	     * Whether unselected index or not.
	     * @param {number} index legend index
	     * @returns {boolean} true if selected
	     */
	    isUnselectedIndex: function(index) {
	        return !snippet.isNull(this.selectedIndex) && (this.selectedIndex !== index);
	    },

	    /**
	     * Whether checked selected index or not.
	     * @returns {boolean} true if checked
	     */
	    isCheckedSelectedIndex: function() {
	        return this.isCheckedIndex(this.selectedIndex);
	    },

	    /**
	     * Toggle checked index.
	     * @param {number} index legend index
	     */
	    toggleCheckedIndex: function(index) {
	        this.checkedWholeIndexes[index] = !this.checkedWholeIndexes[index];
	    },

	    /**
	     * Update checked index.
	     * @param {number} index legend index
	     * @private
	     */
	    _updateCheckedIndex: function(index) {
	        this.checkedWholeIndexes[index] = true;
	    },

	    /**
	     * Whether checked index.
	     * @param {number} index legend index
	     * @returns {boolean} true if checked
	     */
	    isCheckedIndex: function(index) {
	        return !!this.checkedWholeIndexes[index];
	    },

	    /**
	     * Add sending datum.
	     * @param {number} index legend index
	     */
	    _addSendingDatum: function(index) {
	        var legendDatum = this.getDatum(index);
	        if (!this.checkedIndexesMap[legendDatum.chartType]) {
	            this.checkedIndexesMap[legendDatum.chartType] = [];
	        }
	        this.checkedIndexesMap[legendDatum.chartType][legendDatum.index] = true;
	    },

	    /**
	     * Check selected index;
	     */
	    checkSelectedIndex: function() {
	        this._updateCheckedIndex(this.selectedIndex);
	        this._addSendingDatum(this.selectedIndex);
	        this._setData();
	    },

	    /**
	     * Get checked indexes.
	     * @returns {object} object data that whether series has checked or not
	     */
	    getCheckedIndexes: function() {
	        return this.checkedIndexesMap;
	    },

	    /**
	     * Reset checked data.
	     * @private
	     */
	    _resetCheckedData: function() {
	        this.checkedWholeIndexes = [];
	        this.checkedIndexesMap = {};
	    },

	    /**
	     * Update checked legend's indexes
	     * @param {Array.<number>} indexes indexes
	     */
	    updateCheckedLegendsWith: function(indexes) {
	        var self = this;

	        this._resetCheckedData();
	        forEachArray(indexes, function(index) {
	            self._updateCheckedIndex(index);
	            self._addSendingDatum(index);
	        });
	        this._setData();
	    }
	});

	module.exports = LegendModel;


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview  Spectrum Legend component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var pluginFactory = __webpack_require__(32);
	var snippet = __webpack_require__(6);

	var SpectrumLegend = snippet.defineClass(/** @lends SpectrumLegend.prototype */ {
	    /**
	     * Spectrum Legend component.
	     * @constructs SpectrumLegend
	     * @private
	     * @param {object} params parameters
	     *      @param {object} params.theme axis theme
	     *      @param {?Array.<string>} params.options legend options
	     *      @param {MapChartDataProcessor} params.dataProcessor data processor
	     */
	    init: function(params) {
	        var libType = params.libType;

	        /**
	         * chart type
	         * @type {string}
	         */
	        this.chartType = params.chartType;

	        /**
	         * legend theme
	         * @type {Object}
	         */
	        this.theme = params.theme;

	        /**
	         * options
	         * @type {object}
	         */
	        this.options = params.options || {};

	        /**
	         * data processor
	         * @type {DataProcessor}
	         */
	        this.dataProcessor = params.dataProcessor;

	        /**
	         * color spectrum
	         * @type {ColorSpectrum}
	         */
	        this.colorSpectrum = params.colorSpectrum;

	        /**
	         * event bus for transmitting message
	         * @type {object}
	         */
	        this.eventBus = params.eventBus;

	        /**
	         * Graph renderer
	         * @type {object}
	         */
	        this.graphRenderer = pluginFactory.get(libType, 'mapLegend');

	        /**
	         * Whether horizontal legend or not.
	         * @type {boolean}
	         */
	        this.isHorizontal = predicate.isHorizontalLegend(this.options.align);

	        /**
	         * scale data for legend
	         * @type {null|object}
	         */
	        this.scaleData = null;

	        this.drawingType = chartConst.COMPONENT_TYPE_RAPHAEL;

	        this._attachToEventBus();
	    },

	    /**
	     * Attach to event bus.
	     * @private
	     */
	    _attachToEventBus: function() {
	        this.eventBus.on({
	            showWedge: this.onShowWedge,
	            hideTooltip: this.onHideWedge
	        }, this);
	        this.eventBus.on('beforeImageDownload', snippet.bind(this._removeLocationURLFromFillAttribute, this));
	        this.eventBus.on('afterImageDownload', snippet.bind(this._restoreLocationURLToFillAttribute, this));
	    },

	    /**
	     * Remove location URL from fill attribute
	     * @private
	     */
	    _removeLocationURLFromFillAttribute: function() {
	        this.graphRenderer.removeLocationURLFromFillAttribute();
	    },

	    /**
	     * Restore location URL to fill attribute
	     * @private
	     */
	    _restoreLocationURLToFillAttribute: function() {
	        this.graphRenderer.restoreLocationURLToFillAttribute();
	    },

	    /**
	     * Make base data to make tick html.
	     * @returns {{startPositionValue: number, step: number, positionType: string, labelSize: ?number}} base data
	     * @private
	     */
	    _makeBaseDataToMakeTickArea: function() {
	        var dimension = this.layout.dimension;
	        var scaleData = this.scaleData;
	        var stepCount = scaleData.stepCount || scaleData.tickCount - 1;
	        var baseData = {};

	        baseData.position = this.layout.position;

	        if (this.isHorizontal) {
	            baseData.step = dimension.width / stepCount;
	            baseData.position.top += chartConst.MAP_LEGEND_GRAPH_SIZE + chartConst.MAP_LEGEND_LABEL_PADDING;
	        } else {
	            baseData.step = dimension.height / stepCount;
	            baseData.position.left += chartConst.MAP_LEGEND_GRAPH_SIZE + chartConst.MAP_LEGEND_LABEL_PADDING;
	        }

	        return baseData;
	    },

	    /**
	     * Render tick area.
	     * @param {Array.<object>} legendSet legend set
	     * @private
	     */
	    _renderTickArea: function(legendSet) {
	        if (this.options.reversed) {
	            this.scaleData.labels.sort(function(prev, next) {
	                return next - prev;
	            });
	        }
	        this.graphRenderer.renderTicksAndLabels(this.paper, this._makeBaseDataToMakeTickArea(),
	            this.scaleData.labels, this.isHorizontal, legendSet);
	    },

	    /**
	     * Make graph dimension of vertical legend
	     * @returns {{width: number, height: number}} dimension
	     * @private
	     */
	    _makeVerticalGraphDimension: function() {
	        return {
	            width: chartConst.MAP_LEGEND_GRAPH_SIZE,
	            height: this.layout.dimension.height
	        };
	    },

	    /**
	     * Make graph dimension of horizontal legend
	     * @returns {{width: number, height: number}} dimension
	     * @private
	     */
	    _makeHorizontalGraphDimension: function() {
	        return {
	            width: this.layout.dimension.width + 10,
	            height: chartConst.MAP_LEGEND_GRAPH_SIZE
	        };
	    },

	    /**
	     * Render graph.
	     * @param {Array.<object>} legendSet legend set
	     * @private
	     */
	    _renderGraph: function(legendSet) {
	        var dimension, startForSwap;

	        if (this.isHorizontal) {
	            dimension = this._makeHorizontalGraphDimension();
	        } else {
	            dimension = this._makeVerticalGraphDimension();
	        }

	        if (this.options.reversed) {
	            startForSwap = this.colorSpectrum.start;
	            this.colorSpectrum.start = this.colorSpectrum.end;
	            this.colorSpectrum.end = startForSwap;
	        }

	        this.graphRenderer.render(this.paper, {
	            dimension: dimension,
	            position: this.layout.position
	        }, this.colorSpectrum, this.isHorizontal, legendSet);
	    },

	    /**
	     * Render legend area.
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderLegendArea: function() {
	        var legendSet = this.paper.set();

	        this._renderGraph(legendSet);
	        this._renderTickArea(legendSet);

	        return legendSet;
	    },

	    /**
	     * Set data for rendering.
	     * @param {{
	     *      layout: object,
	     *      legendScaleData: object
	     * }} data - scale data
	     * @private
	     */
	    _setDataForRendering: function(data) {
	        this.layout = data.layout;
	        this.paper = data.paper;
	        this.scaleData = data.legendScaleData;
	    },

	    /**
	     * Render legend component.
	     * @param {object} data - scale data
	     */
	    render: function(data) {
	        this._setDataForRendering(data);
	        this.legnedSet = this._renderLegendArea();
	    },

	    /**
	     * Rerender legend component.
	     * @param {object} data - scale data
	     */
	    rerender: function(data) {
	        this.legnedSet.remove();
	        this.render(data);
	    },

	    /**
	     * Resize legend component.
	     * @param {object} data - scale data
	     */
	    resize: function(data) {
	        this.rerender(data);
	    },

	    /**
	     * On show wedge.
	     * @param {number} ratio ratio
	     */
	    onShowWedge: function(ratio) {
	        ratio = this.options.reversed ? 1 - ratio : ratio;
	        this.graphRenderer.showWedge(chartConst.MAP_LEGEND_SIZE * ratio);
	    },

	    /**
	     * On hide wedge.
	     */
	    onHideWedge: function() {
	        this.graphRenderer.hideWedge();
	    }
	});

	/**
	 * Factory for SpectrumLegend
	 * @param {object} params parameter
	 * @returns {object|null}
	 * @ignore
	 */
	function spectrumLegendFactory(params) {
	    var isLegendVisible = snippet.isUndefined(params.options.visible) ? true : params.options.visible;
	    var chartType = params.chartOptions.chartType;
	    var spectrumLegend = null;

	    if (isLegendVisible) {
	        params.chartType = chartType;

	        spectrumLegend = new SpectrumLegend(params);
	    }

	    return spectrumLegend;
	}

	spectrumLegendFactory.componentType = 'legend';
	spectrumLegendFactory.SpectrumLegend = SpectrumLegend;

	module.exports = spectrumLegendFactory;


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview  Circle legend component render a legend in the form of overlapping circles
	 *                  by representative radius values.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var calculator = __webpack_require__(45);
	var renderUtil = __webpack_require__(7);
	var pluginFactory = __webpack_require__(32);
	var snippet = __webpack_require__(6);

	var CircleLegend = snippet.defineClass(/** @lends CircleLegend.prototype */ {
	    /**
	     * ratios for rendering circle
	     * @type {Array.<number>}
	     */
	    circleRatios: [1, 0.5, 0.25],
	    /**
	     * Circle legend component render a legend in the form of overlapping circles by representative radius values.
	     * @constructs CircleLegend
	     * @private
	     * @param {object} params parameters
	     *      @param {?string} params.libType - library type for graph rendering
	     *      @param {string} params.chartType - chart type
	     *      @param {DataProcessor} params.dataProcessor - DataProcessor
	     *      @param {string} params.baseFontFamily - base fontFamily of chart
	     */
	    init: function(params) {
	        var libType = params.libType;

	        /**
	         * chart type
	         * @type {string}
	         */
	        this.chartType = params.chartType;

	        /**
	         * data processor
	         * @type {DataProcessor}
	         */
	        this.dataProcessor = params.dataProcessor;

	        /**
	         * theme for label of circle legend area
	         * @type {{fontSize: number, fontFamily: *}}
	         */
	        this.labelTheme = {
	            fontSize: chartConst.CIRCLE_LEGEND_LABEL_FONT_SIZE,
	            fontFamily: params.baseFontFamily
	        };

	        /**
	         * Graph renderer
	         * @type {object}
	         */
	        this.graphRenderer = pluginFactory.get(libType, 'circleLegend');

	        /**
	         * layout bounds information for this components
	         * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number}}}
	         */
	        this.layout = null;

	        /**
	         * max radius for rendering circle legend
	         * @type {null|number}
	         */
	        this.maxRadius = null;

	        this.drawingType = chartConst.COMPONENT_TYPE_RAPHAEL;
	    },

	    /**
	     * Format label.
	     * @param {number} label - label
	     * @param {number} decimalLength - decimal length
	     * @returns {string}
	     * @private
	     */
	    _formatLabel: function(label, decimalLength) {
	        var formatFunctions = this.dataProcessor.getFormatFunctions();
	        var formattedLabel;

	        if (decimalLength === 0) {
	            formattedLabel = String(parseInt(label, 10));
	        } else {
	            formattedLabel = renderUtil.formatToDecimal(String(label), decimalLength);
	        }

	        return renderUtil.formatValue({
	            value: formattedLabel,
	            formatFunctions: formatFunctions,
	            chartType: this.chartType,
	            areaType: 'circleLegend',
	            valueType: 'r'
	        });
	    },

	    /**
	     * Make label html.
	     * @returns {Array.<string>}
	     * @private
	     */
	    _makeLabels: function() {
	        var self = this;
	        var maxValueRadius = this.dataProcessor.getMaxValue(this.chartType, 'r');
	        var decimalLength = calculator.getDecimalLength(maxValueRadius);

	        return snippet.map(this.circleRatios, function(ratio) {
	            return self._formatLabel(maxValueRadius * ratio, decimalLength);
	        });
	    },

	    /**
	     * Render for circle legend area.
	     * @param {object} paper paper object
	     * @returns {Array.<object>}
	     * @private
	     */
	    _render: function(paper) {
	        return this.graphRenderer.render(paper, this.layout, this.maxRadius, this.circleRatios, this._makeLabels());
	    },

	    /**
	     * Set data for rendering.
	     * @param {{
	     *      layout: {
	     *          dimension: {width: number, height: number},
	     *          position: {left: number, top: number}
	     *      },
	     *      maxRadius: number
	     * }} data - bounds data
	     * @private
	     */
	    _setDataForRendering: function(data) {
	        this.layout = data.layout;
	        this.maxRadius = data.maxRadius;
	    },

	    /**
	     * Render.
	     * @param {object} data - bounds data
	     */
	    render: function(data) {
	        this._setDataForRendering(data);
	        this.circleLegendSet = this._render(data.paper);
	    },

	    /**
	     * Rerender.
	     * @param {object} data - bounds data
	     */
	    rerender: function(data) {
	        this.circleLegendSet.remove();

	        this._setDataForRendering(data);
	        this.circleLegendSet = this._render(data.paper);
	    },

	    /**
	     * Resize.
	     * @param {object} data - bounds data
	     */
	    resize: function(data) {
	        this.rerender(data);
	    }
	});

	/**
	 * Factory for CircleLegend
	 * @param {object} params parameter
	 * @returns {object|null}
	 * @ignore
	 */
	function circleLegendFactory(params) {
	    var chartType = params.chartOptions.chartType;
	    var chartTheme = params.chartTheme;
	    var visibleOption = snippet.pick(params.chartOptions, 'circleLegend', 'visible');
	    var circleLegend = null;
	    var isLegendVisible;

	    if (snippet.isUndefined(visibleOption)) {
	        isLegendVisible = true;
	    } else {
	        isLegendVisible = visibleOption;
	    }

	    if (isLegendVisible) {
	        params.chartType = chartType;
	        params.baseFontFamily = chartTheme.chart.fontFamily;

	        circleLegend = new CircleLegend(params);
	    }

	    return circleLegend;
	}

	circleLegendFactory.componentType = 'legend';
	circleLegendFactory.CircleLegend = CircleLegend;

	module.exports = circleLegendFactory;


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview NormalTooltip component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var normalTooltipFactory = __webpack_require__(61);
	var groupTooltipFactory = __webpack_require__(66);
	var mapChartTooltipFactory = __webpack_require__(68);
	var predicate = __webpack_require__(11);
	var snippet = __webpack_require__(6);

	/**
	 * Label formatter function for pie chart
	 * @param {object} seriesItem series item
	 * @param {object} tooltipDatum tooltip datum object
	 * @param {string} labelPrefix label prefix
	 * @returns {object}
	 * @ignore
	 */
	function pieTooltipLabelFormatter(seriesItem, tooltipDatum, labelPrefix) {
	    var ratioLabel;
	    var percentageString = (seriesItem.ratio * 100).toFixed(4);
	    var percent = parseFloat(percentageString);
	    var needSlice = (percent < 0.0009 || percentageString.length > 5);

	    percentageString = needSlice ? percentageString.substr(0, 4) : String(percent);
	    ratioLabel = percentageString + '&nbsp;%&nbsp;' || '';

	    tooltipDatum.ratioLabel = labelPrefix + ratioLabel;
	    tooltipDatum.label = seriesItem.tooltipLabel || (seriesItem.label ? seriesItem.label : '');

	    return tooltipDatum;
	}

	/**
	 * Factory for Tooltip
	 * @param {object} params parameter
	 * @returns {object|null}
	 * @ignore
	 */
	function tooltipFactory(params) {
	    var chartType = params.chartOptions.chartType;
	    var seriesTypes = params.seriesTypes;
	    var xAxisOptions = params.chartOptions.xAxis;
	    var colors = [];
	    var factory;

	    snippet.forEach(snippet.filter(params.chartTheme.legend, function(item) {
	        return snippet.isArray(item.colors);
	    }), function(series) {
	        colors = colors.concat(series.colors);
	    });

	    if (chartType === 'map') {
	        factory = mapChartTooltipFactory;
	    } else if (params.options.grouped) {
	        factory = groupTooltipFactory;
	    } else {
	        factory = normalTooltipFactory;
	    }

	    if (chartType === 'pie' || predicate.isPieDonutComboChart(chartType, seriesTypes)) {
	        params.labelFormatter = pieTooltipLabelFormatter;
	    }

	    params.chartType = chartType;
	    params.chartTypes = seriesTypes;
	    params.xAxisType = xAxisOptions.type;
	    params.dateFormat = xAxisOptions.dateFormat;
	    params.colors = colors;

	    return factory(params);
	}

	tooltipFactory.componentType = 'tooltip';

	module.exports = tooltipFactory;


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview NormalTooltip component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var TooltipBase = __webpack_require__(62);
	var singleTooltipMixer = __webpack_require__(63);
	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var tooltipTemplate = __webpack_require__(64);
	var snippet = __webpack_require__(6);

	/**
	 * @classdesc NormalTooltip component.
	 * @class NormalTooltip
	 * @private
	 */
	var NormalTooltip = snippet.defineClass(TooltipBase, /** @lends NormalTooltip.prototype */ {
	    /**
	     * NormalTooltip component.
	     * @constructs NormalTooltip
	     * @private
	     * @override
	     */
	    init: function() {
	        TooltipBase.apply(this, arguments);
	    },

	    /**
	     * Make tooltip html.
	     * @param {string} category category
	     * @param {{value: string, legend: string, chartType: string, suffix: ?string}} item item data
	     * @returns {string} tooltip html
	     * @private
	     */
	    _makeTooltipHtml: function(category, item) {
	        var template = this._getTooltipTemplate(item);

	        return template(snippet.extend({
	            categoryVisible: category ? 'show' : 'hide',
	            category: category
	        }, item));
	    },

	    /**
	     * get tooltip template from a templates collection
	     * @param {{value: string, legend: string, chartType: string, suffix: ?string}} item item data
	     * @returns {string} tooltip template
	     * @private
	     */
	    _getTooltipTemplate: function(item) {
	        var template = tooltipTemplate.tplDefault;

	        if (predicate.isBoxplotChart(this.chartType)) {
	            template = this._getBoxplotTooltipTemplate(item);
	        } else if (predicate.isPieChart(this.chartType) ||
	            predicate.isPieDonutComboChart(this.chartType, this.chartTypes)) {
	            template = tooltipTemplate.tplPieChart;
	        } else if (this.dataProcessor.coordinateType) {
	            template = tooltipTemplate.tplCoordinatetypeChart;
	        } else if (predicate.isBulletChart(this.chartType)) {
	            template = tooltipTemplate.tplBulletChartDefault;
	        }

	        return template;
	    },

	    /**
	     * Get tooltip template of box plot chart
	     * If item has outlierIndex, return outlier template
	     * Otherwise, return box plot default template
	     * @param {{value: string, legend: string, chartType: string, suffix: ?string}} item item data
	     * @returns {string} tooltip template
	     * @private
	     */
	    _getBoxplotTooltipTemplate: function(item) {
	        var template = tooltipTemplate.tplBoxplotChartDefault;

	        if (snippet.isNumber(item.outlierIndex)) {
	            template = tooltipTemplate.tplBoxplotChartOutlier;
	            item.label = item.outliers[item.outlierIndex].label;
	        }

	        return template;
	    },

	    /**
	     * Make html for value types like x, y, r
	     * @param {{x: ?number, y: ?number, r: ?number}} data - data
	     * @param {Array.<string>} valueTypes - types of value
	     * @returns {string}
	     * @private
	     */
	    _makeHtmlForValueTypes: function(data, valueTypes) {
	        return snippet.map(valueTypes, function(type) {
	            return (data[type]) ? '<div>' + type + ': ' + data[type] + '</div>' : '';
	        }).join('');
	    },

	    /**
	     * Make single tooltip html.
	     * @param {string} chartType chart type
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     * @returns {string} tooltip html
	     * @private
	     */
	    _makeSingleTooltipHtml: function(chartType, indexes) {
	        var groupIndex = indexes.groupIndex;
	        var data = snippet.extend({}, snippet.pick(this.data, chartType, indexes.groupIndex, indexes.index));

	        if (predicate.isBoxplotChart(this.chartType) && snippet.isNumber(indexes.outlierIndex)) {
	            data.outlierIndex = indexes.outlierIndex;
	        }

	        data = snippet.extend({
	            suffix: this.suffix
	        }, data);
	        data.valueTypes = this._makeHtmlForValueTypes(data, ['x', 'y', 'r']);

	        return this.templateFunc(data.category, data, this.getRawCategory(groupIndex));
	    },

	    /**
	     * Set default align option of tooltip.
	     * @private
	     * @override
	     */
	    _setDefaultTooltipPositionOption: function() {
	        if (this.options.align) {
	            return;
	        }

	        if (this.isVertical) {
	            this.options.align = chartConst.TOOLTIP_DEFAULT_ALIGN_OPTION;
	        } else {
	            this.options.align = chartConst.TOOLTIP_DEFAULT_HORIZONTAL_ALIGN_OPTION;
	        }
	    },

	    /**
	     * Make parameters for show tooltip user event.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     * @param {object} additionParams addition parameters
	     * @returns {{chartType: string, legend: string, legendIndex: number, index: number}} parameters for show tooltip
	     * @private
	     */
	    _makeShowTooltipParams: function(indexes, additionParams) {
	        var legendIndex = indexes.index;
	        var legendData = this.dataProcessor.getLegendItem(legendIndex);
	        var chartType;

	        var params;

	        if (!legendData) {
	            return null;
	        }

	        chartType = legendData.chartType;
	        params = snippet.extend({
	            chartType: chartType,
	            legend: legendData.label,
	            legendIndex: legendIndex,
	            index: indexes.groupIndex
	        }, additionParams);

	        if (predicate.isBoxplotChart(chartType) &&
	            snippet.isNumber(indexes.outlierIndex)) {
	            params.outlierIndex = indexes.outlierIndex;
	        }

	        return params;
	    },

	    /**
	     * Make tooltip datum.
	     * @param {string} legendLabel - legend label
	     * @param {string} category - category
	     * @param {SeriesItem} seriesItem - SeriesItem
	     * @returns {Object}
	     * @private
	     */
	    _makeTooltipDatum: function(legendLabel, category, seriesItem) {
	        var labelPrefix = (legendLabel && seriesItem.label) ? ':&nbsp;' : '';
	        var tooltipLabel = seriesItem.tooltipLabel;
	        var labelFormatter = this.labelFormatter;
	        var tooltipDatum = {
	            legend: legendLabel || '',
	            label: tooltipLabel || (seriesItem.label ? labelPrefix + seriesItem.label : ''),
	            category: category || ''
	        };

	        if (labelFormatter) {
	            tooltipDatum = labelFormatter(seriesItem, tooltipDatum, labelPrefix);
	        }

	        tooltipDatum.category = category || '';

	        return snippet.extend(tooltipDatum, seriesItem.pickValueMapForTooltip());
	    },

	    /**
	     * Make tooltip data.
	     * @returns {Array.<object>} tooltip data
	     * @override
	     */
	    makeTooltipData: function() {
	        var self = this;
	        var orgLegendLabels = this.dataProcessor.getLegendLabels();
	        var isPivot = predicate.isTreemapChart(this.chartType);
	        var legendLabels = {};
	        var tooltipData = {};

	        if (snippet.isArray(orgLegendLabels)) {
	            legendLabels[this.chartType] = orgLegendLabels;
	        } else {
	            legendLabels = orgLegendLabels;
	        }

	        this.dataProcessor.eachBySeriesGroup(function(seriesGroup, groupIndex, chartType) {
	            var data, isBulletChart;

	            chartType = chartType || self.chartType;
	            isBulletChart = predicate.isBulletChart(chartType);

	            data = seriesGroup.map(function(seriesItem, index) {
	                var category = self.dataProcessor.makeTooltipCategory(groupIndex, index, self.isVertical);
	                var legendIndex = isBulletChart ? groupIndex : index;

	                if (!seriesItem) {
	                    return null;
	                }

	                return self._makeTooltipDatum(legendLabels[chartType][legendIndex], category, seriesItem);
	            });

	            if (!tooltipData[chartType]) {
	                tooltipData[chartType] = [];
	            }

	            tooltipData[chartType].push(data);
	        }, isPivot);

	        return tooltipData;
	    }
	});

	singleTooltipMixer.mixin(NormalTooltip);

	function normalTooltipFactory(params) {
	    return new NormalTooltip(params);
	}

	normalTooltipFactory.componentType = 'tooltip';
	normalTooltipFactory.NormalTooltip = NormalTooltip;

	module.exports = normalTooltipFactory;


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview TooltipBase is base class of tooltip components.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);
	var chartConst = __webpack_require__(8),
	    dom = __webpack_require__(9),
	    predicate = __webpack_require__(11),
	    renderUtil = __webpack_require__(7);

	var TooltipBase = snippet.defineClass(/** @lends TooltipBase.prototype */ {
	    /**
	     * TooltipBase is base class of tooltip components.
	     * @constructs TooltipBase
	     * @private
	     * @param {object} params - parameters
	     *      @param {string} params.chartType - chart type
	     *      @param {Array.<string>} params.chartTypes - chart types
	     *      @param {DataProcessor} params.dataProcessor - DataProcessor instance
	     *      @param {object} params.options - tooltip options
	     *      @param {object} params.theme - tooltip theme
	     *      @param {boolean} params.isVertical - whether vertical or not
	     *      @param {object} params.eventBus - snippet.CustomEvents instance
	     *      @param {object} params.labelTheme - theme for label
	     *      @param {string} params.xAxisType - xAxis type
	     *      @param {string} params.dateFormat - date format
	     *      @param {object} params.labelFormatter - label formatter function
	     */
	    init: function(params) {
	        var isPieChart = predicate.isPieChart(params.chartType);

	        /**
	         * Chart type
	         * @type {string}
	         */
	        this.chartType = params.chartType;

	        /**
	         * Chart types
	         * @type {Array.<string>}
	         */
	        this.chartTypes = params.chartTypes;

	        /**
	         * Data processor
	         * @type {DataProcessor}
	         */
	        this.dataProcessor = params.dataProcessor;

	        /**
	         * Options
	         * @type {object}
	         */
	        this.options = params.options;
	        this.colors = params.colors;

	        /**
	         * Theme
	         * @type {object}
	         */
	        this.theme = params.theme;

	        /**
	         * whether vertical or not
	         * @type {boolean}
	         */
	        this.isVertical = params.isVertical;

	        /**
	         * event bus for transmitting message
	         * @type {object}
	         */
	        this.eventBus = params.eventBus;

	        /**
	         * label theme
	         * @type {object}
	         */
	        this.labelTheme = params.labelTheme;

	        /**
	         * x axis type
	         * @type {?string}
	         */
	        this.xAxisType = params.xAxisType;

	        /**
	         * dateFormat option for xAxis
	         * @type {?string}
	         */
	        this.dateFormat = params.dateFormat;

	        /**
	         * tooltip options for each chart
	         * @type {?function}
	         */
	        this.labelFormatter = params.labelFormatter;

	        /**
	         * className
	         * @type {string}
	         */
	        this.className = 'tui-chart-tooltip-area';

	        /**
	         * Tooltip container.
	         * @type {HTMLElement}
	         */
	        this.tooltipContainer = null;

	        /**
	         * Tooltip suffix.
	         * @type {string}
	         */
	        this.suffix = this.options.suffix ? '&nbsp;' + this.options.suffix : '';

	        /**
	         * Tooltip template function.
	         * @type {function}
	         */
	        this.templateFunc = this.options.template || snippet.bind(this._makeTooltipHtml, this);

	        /**
	         * Tooltip animation time.
	         * @type {number}
	         */
	        this.animationTime = isPieChart ? chartConst.TOOLTIP_PIE_ANIMATION_TIME : chartConst.TOOLTIP_ANIMATION_TIME;

	        /**
	         * TooltipBase base data.
	         * @type {Array.<Array.<object>>}
	         */
	        this.data = [];

	        /**
	         * layout bounds information for this components
	         * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number}}}
	         */
	        this.layout = null;

	        /**
	         * dimension map for layout of chart
	         * @type {null|object}
	         */
	        this.dimensionMap = null;

	        /**
	         * position map for layout of chart
	         * @type {null|object}
	         */
	        this.positionMap = null;

	        /**
	         * Drawing type
	         * @type {string}
	         */
	        this.drawingType = chartConst.COMPONENT_TYPE_DOM;

	        this._setDefaultTooltipPositionOption();
	        this._saveOriginalPositionOptions();

	        this._attachToEventBus();
	    },

	    /**
	     * Attach to event bus.
	     * @private
	     */
	    _attachToEventBus: function() {
	        this.eventBus.on({
	            showTooltip: this.onShowTooltip,
	            hideTooltip: this.onHideTooltip
	        }, this);

	        if (this.onShowTooltipContainer) {
	            this.eventBus.on({
	                showTooltipContainer: this.onShowTooltipContainer,
	                hideTooltipContainer: this.onHideTooltipContainer
	            }, this);
	        }
	    },

	    /**
	     * Make tooltip html.
	     * @private
	     * @abstract
	     */
	    _makeTooltipHtml: function() {},

	    /**
	     * Set default align option of tooltip.
	     * @private
	     * @abstract
	     */
	    _setDefaultTooltipPositionOption: function() {},

	    /**
	     * Save position options.
	     * @private
	     */
	    _saveOriginalPositionOptions: function() {
	        this.orgPositionOptions = {
	            align: this.options.align,
	            offset: this.options.offset
	        };
	    },

	    /**
	     * Make tooltip data.
	     * @private
	     * @abstract
	     */
	    makeTooltipData: function() {},

	    /**
	     * Set data for rendering.
	     * @param {{
	     *      layout: {
	     *          dimension: {width: number, height: number},
	     *          position: {left: number, top: number}
	     *      },
	     *      dimensionMap: object
	     * }} data - bounds data
	     * @private
	     */
	    _setDataForRendering: function(data) {
	        this.layout = data.layout;
	        this.dimensionMap = data.dimensionMap;
	        this.positionMap = data.positionMap;
	    },

	    /**
	     * Render tooltip component.
	     * @param {object} data - bounds data
	     * @returns {HTMLElement} tooltip element
	     */
	    render: function(data) {
	        var el = data.paper;

	        dom.addClass(el, this.className);

	        this._setDataForRendering(data);
	        this.data = this.makeTooltipData();

	        renderUtil.renderPosition(el, this.layout.position);

	        this.tooltipContainer = el;

	        return el;
	    },

	    /**
	     * Rerender.
	     * @param {object} data - bounds data
	     */
	    rerender: function(data) {
	        this.resize(data);
	        this.data = this.makeTooltipData();
	    },

	    /**
	     * Resize tooltip component.
	     * @param {object} data - bounds data
	     * @override
	     */
	    resize: function(data) {
	        this._setDataForRendering(data);

	        renderUtil.renderPosition(this.tooltipContainer, this.layout.position);
	        if (this.positionModel) {
	            this.positionModel.updateBound(this.layout);
	        }
	    },

	    /**
	     * Zoom.
	     */
	    zoom: function() {
	        this.data = this.makeTooltipData();
	    },

	    /**
	     * Get tooltip element.
	     * @returns {HTMLElement} tooltip element
	     * @private
	     */
	    _getTooltipElement: function() {
	        var tooltipElement;

	        if (!this.tooltipElement) {
	            this.tooltipElement = tooltipElement = dom.create('DIV', 'tui-chart-tooltip');
	            dom.append(this.tooltipContainer, tooltipElement);
	        }

	        return this.tooltipElement;
	    },

	    /**
	     * onShowTooltip is callback of mouse event detector showTooltip for SeriesView.
	     * @param {object} params coordinate event parameters
	     */
	    onShowTooltip: function(params) {
	        var tooltipElement = this._getTooltipElement();
	        var isScatterCombo = predicate.isComboChart(this.chartType) && predicate.isScatterChart(params.chartType);
	        var prevPosition;

	        if ((!predicate.isChartToDetectMouseEventOnSeries(params.chartType) || isScatterCombo)
	            && tooltipElement.offsetWidth) {
	            prevPosition = {
	                left: tooltipElement.offsetLeft,
	                top: tooltipElement.offsetTop
	            };
	        }

	        this._showTooltip(tooltipElement, params, prevPosition);
	    },

	    /**
	     * Get tooltip dimension
	     * @param {HTMLElement} tooltipElement tooltip element
	     * @returns {{width: number, height: number}} rendered tooltip dimension
	     */
	    getTooltipDimension: function(tooltipElement) {
	        return {
	            width: tooltipElement.offsetWidth,
	            height: tooltipElement.offsetHeight
	        };
	    },

	    /**
	     * Move to Position.
	     * @param {HTMLElement} tooltipElement tooltip element
	     * @param {{left: number, top: number}} position position
	     * @param {{left: number, top: number}} prevPosition prev position
	     * @private
	     */
	    _moveToPosition: function(tooltipElement, position, prevPosition) {
	        if (prevPosition) {
	            this._slideTooltip(tooltipElement, prevPosition, position);
	        } else {
	            renderUtil.renderPosition(tooltipElement, position);
	        }
	    },

	    /**
	     * Slide tooltip
	     * @param {HTMLElement} tooltipElement tooltip element
	     * @param {{left: number, top: number}} prevPosition prev position
	     * @param {{left: number, top: number}} position position
	     * @private
	     */
	    _slideTooltip: function(tooltipElement, prevPosition, position) {
	        var moveTop = position.top - prevPosition.top,
	            moveLeft = position.left - prevPosition.left;

	        renderUtil.cancelAnimation(this.slidingAnimation);

	        this.slidingAnimation = renderUtil.startAnimation(this.animationTime, function(ratio) {
	            var left = moveLeft * ratio,
	                top = moveTop * ratio;
	            tooltipElement.style.left = (prevPosition.left + left) + 'px';
	            tooltipElement.style.top = (prevPosition.top + top) + 'px';
	        });
	    },

	    /**
	     * onHideTooltip is callback of mouse event detector hideTooltip for SeriesView
	     * @param {number|object} prevFound - showing tooltip object in case single tooltip,
	     *                                  - showing tooltip index in case group tooltip
	     * @param {{silent: {boolean}}} [options] - hide tooltip options
	     */
	    onHideTooltip: function(prevFound, options) {
	        var tooltipElement = this._getTooltipElement();

	        this._hideTooltip(tooltipElement, prevFound, options);
	    },

	    /**
	     * Set align option.
	     * @param {string} align align
	     */
	    setAlign: function(align) {
	        this.options.align = align;
	        if (this.positionModel) {
	            this.positionModel.updateOptions(this.options);
	        }
	    },

	    /**
	     * Update offset option.
	     * @param {{x: number, y: number}} offset - offset
	     * @private
	     */
	    _updateOffsetOption: function(offset) {
	        this.options.offset = offset;

	        if (this.positionModel) {
	            this.positionModel.updateOptions(this.options);
	        }
	    },

	    /**
	     * Set offset.
	     * @param {{x: number, y: number}} offset - offset
	     */
	    setOffset: function(offset) {
	        var offsetOption = snippet.extend({}, this.options.offset);

	        if (snippet.isExisty(offset.x)) {
	            offsetOption.x = offset.x;
	        }

	        if (snippet.isExisty(offset.y)) {
	            offsetOption.y = offset.y;
	        }

	        this._updateOffsetOption(snippet.extend({}, this.options.offset, offsetOption));
	    },

	    /**
	     * Set position option.
	     * @param {{left: number, top: number}} position moving position
	     * @deprecated
	     */
	    setPosition: function(position) {
	        var offsetOption = snippet.extend({}, this.options.offset);

	        if (snippet.isExisty(position.left)) {
	            offsetOption.x = position.left;
	        }

	        if (snippet.isExisty(position.top)) {
	            offsetOption.y = position.y;
	        }

	        this._updateOffsetOption(offsetOption);
	    },

	    /**
	     * Reset align option.
	     */
	    resetAlign: function() {
	        var align = this.orgPositionOptions.align;

	        this.options.align = align;

	        if (this.positionModel) {
	            this.positionModel.updateOptions(this.options);
	        }
	    },

	    /**
	     * Reset offset option.
	     */
	    resetOffset: function() {
	        this.options.offset = this.orgPositionOptions.offset;
	        this._updateOffsetOption(this.options.offset);
	    },

	    /**
	     * Get category's raw data
	     * @param {number} index - index of categories
	     * @param {string} format - date format
	     * @returns {string} - category's raw data
	     */
	    getRawCategory: function(index, format) {
	        var axis = this.isVertical ? 'x' : 'y';
	        var categories = this.dataProcessor.categoriesMap ? this.dataProcessor.categoriesMap[axis] : null;
	        var rawCategory = '';

	        if (categories) {
	            rawCategory = categories[index];
	        }

	        if (format) {
	            rawCategory = renderUtil.formatDate(rawCategory, format);
	        }

	        return rawCategory;
	    }
	});

	module.exports = TooltipBase;


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview singleTooltipMixer is single tooltip mixer of map chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);
	var chartConst = __webpack_require__(8),
	    predicate = __webpack_require__(11),
	    dom = __webpack_require__(9),
	    renderUtil = __webpack_require__(7);

	/**
	 * singleTooltipMixer is single tooltip mixer of map chart.
	 * @mixin
	 * @private */
	var singleTooltipMixer = {
	    /**
	     * Set data indexes.
	     * @param {HTMLElement} elTooltip tooltip element
	     * @param {{groupIndex: number, index:number}} indexes indexes
	     * @private
	     */
	    _setIndexesCustomAttribute: function(elTooltip, indexes) {
	        elTooltip.setAttribute('data-groupIndex', indexes.groupIndex);
	        elTooltip.setAttribute('data-index', indexes.index);
	    },

	    /**
	     * Get data indexes
	     * @param {HTMLElement} elTooltip tooltip element
	     * @returns {{groupIndex: number, index: number}} indexes
	     * @private
	     */
	    _getIndexesCustomAttribute: function(elTooltip) {
	        var groupIndex = elTooltip.getAttribute('data-groupIndex');
	        var index = elTooltip.getAttribute('data-index');
	        var indexes = null;

	        if (!snippet.isNull(groupIndex) && !snippet.isNull(index)) {
	            indexes = {
	                groupIndex: parseInt(groupIndex, 10),
	                index: parseInt(index, 10)
	            };
	        }

	        return indexes;
	    },

	    /**
	     * Set showed custom attribute.
	     * @param {HTMLElement} elTooltip tooltip element
	     * @param {boolean} status whether showed or not
	     * @private
	     */
	    _setShowedCustomAttribute: function(elTooltip, status) {
	        elTooltip.setAttribute('data-showed', status);
	    },

	    /**
	     * Whether showed tooltip or not.
	     * @param {HTMLElement} elTooltip tooltip element
	     * @returns {boolean} whether showed tooltip or not
	     * @private
	     */
	    _isShowedTooltip: function(elTooltip) {
	        var isShowed = elTooltip.getAttribute('data-showed');

	        return isShowed === 'true' || isShowed === true; // true in ie7
	    },

	    /**
	     * Make tooltip position for bullet chart
	     * @param {object} params - mouse position
	     * @returns {object} - position of single tooltip
	     * @private
	     */
	    _makeTooltipPositionForBulletChart: function(params) {
	        var mousePosition = params.mousePosition;
	        var tooltipAreaPosition = this.layout.position;

	        return {
	            left: mousePosition.left - tooltipAreaPosition.left,
	            top: mousePosition.top - tooltipAreaPosition.top
	        };
	    },

	    /**
	     * Make left position of not bar chart.
	     * @param {number} baseLeft base left
	     * @param {string} alignOption align option
	     * @param {number} minusWidth minus width
	     * @param {number} lineGap line gap
	     * @returns {number} left position value
	     * @private
	     */
	    _makeLeftPositionOfNotBarChart: function(baseLeft, alignOption, minusWidth, lineGap) {
	        var left = baseLeft;
	        var offsetNegative = minusWidth || 0;
	        var lineGapOffset = lineGap || chartConst.TOOLTIP_GAP;

	        if (alignOption.indexOf('left') > -1) {
	            left -= offsetNegative + lineGapOffset;
	        } else if (alignOption.indexOf('center') > -1 && offsetNegative) {
	            left -= offsetNegative / 2;
	        } else {
	            left += lineGapOffset;
	        }

	        return left;
	    },

	    /**
	     * Make top position of not bar chart.
	     * @param {number} baseTop base top
	     * @param {string} alignOption align option
	     * @param {number} tooltipHeight tooltip height
	     * @param {number} lineGap line gap
	     * @returns {number} top position value
	     * @private
	     */
	    _makeTopPositionOfNotBarChart: function(baseTop, alignOption, tooltipHeight, lineGap) {
	        var top = baseTop;
	        var offsetNegative = tooltipHeight || 0;

	        if (alignOption.indexOf('bottom') > -1) {
	            top += offsetNegative + lineGap;
	        } else if (alignOption.indexOf('middle') > -1 && offsetNegative) {
	            top += offsetNegative / 2;
	        } else {
	            top -= offsetNegative + chartConst.TOOLTIP_GAP;
	        }

	        return top;
	    },

	    /**
	     * Make tooltip position for not bar chart.
	     * @param {object} params parameters
	     *      @param {{bound: object}} params.data graph information
	     *      @param {{width: number, height: number}} params.dimension tooltip dimension
	     *      @param {string} params.alignOption position option (ex: 'left top')
	     * @returns {{top: number, left: number}} position
	     * @private
	     */
	    _makeTooltipPositionForNotBarChart: function(params) {
	        var bound = params.bound,
	            positionOption = params.positionOption,
	            minusWidth = params.dimension.width - (bound.width || 0),
	            lineGap = bound.width ? 0 : chartConst.TOOLTIP_GAP,
	            alignOption = params.alignOption || '',
	            tooltipHeight = params.dimension.height,
	            baseLeft = bound.left - this.layout.position.left + positionOption.left,
	            baseTop = bound.top - this.layout.position.top + positionOption.top - chartConst.TOOLTIP_GAP;

	        return {
	            left: this._makeLeftPositionOfNotBarChart(baseLeft, alignOption, minusWidth, lineGap),
	            top: this._makeTopPositionOfNotBarChart(baseTop, alignOption, tooltipHeight, lineGap)
	        };
	    },

	    /**
	     * Make tooltip position to event position.
	     * @param {object} params parameters
	     *      @param {{left: number, top: number}} params.bound bound
	     *      @param {{left: number, top: number}} params.mousePosition mouse position
	     * @returns {{top: number, left: number}} position
	     * @private
	     */
	    _makeTooltipPositionToMousePosition: function(params) {
	        if (!params.bound) {
	            params.bound = params.bound || {};
	            snippet.extend(params.bound, params.mousePosition);
	        }

	        return this._makeTooltipPositionForNotBarChart(params);
	    },

	    /**
	     * Make left position for bar chart.
	     * @param {number} baseLeft base left
	     * @param {string} alignOption align option
	     * @param {number} tooltipWidth tooltip width
	     * @returns {number} left position value
	     * @private
	     */
	    _makeLeftPositionForBarChart: function(baseLeft, alignOption, tooltipWidth) {
	        var left = baseLeft;

	        if (alignOption.indexOf('left') > -1) {
	            left -= tooltipWidth;
	        } else if (alignOption.indexOf('center') > -1) {
	            left -= tooltipWidth / 2;
	        } else {
	            left += chartConst.TOOLTIP_GAP;
	        }

	        return left;
	    },

	    /**
	     * Make top position for bar chart.
	     * @param {number} baseTop base top
	     * @param {string} alignOption align option
	     * @param {number} minusHeight minus width
	     * @returns {number} top position value
	     * @private
	     */
	    _makeTopPositionForBarChart: function(baseTop, alignOption, minusHeight) {
	        var top = baseTop;

	        if (alignOption.indexOf('top') > -1) {
	            top -= minusHeight;
	        } else if (alignOption.indexOf('middle') > -1) {
	            top -= minusHeight / 2;
	        }

	        return top;
	    },

	    /**
	     * Make tooltip position for bar chart.
	     * @param {object} params parameters
	     *      @param {{bound: object}} params.data graph information
	     *      @param {{width: number, height: number}} params.dimension tooltip dimension
	     *      @param {string} params.alignOption position option (ex: 'left top')
	     * @returns {{top: number, left: number}} position
	     * @private
	     */
	    _makeTooltipPositionForBarChart: function(params) {
	        var position = this.layout.position;
	        var bound = params.bound,
	            positionOption = params.positionOption,
	            minusHeight = params.dimension.height - (bound.height || 0),
	            alignOption = params.alignOption || '',
	            tooltipWidth = params.dimension.width,
	            baseLeft = bound.left + bound.width + positionOption.left - position.left,
	            baseTop = bound.top + positionOption.top - position.top;

	        return {
	            left: this._makeLeftPositionForBarChart(baseLeft, alignOption, tooltipWidth),
	            top: this._makeTopPositionForBarChart(baseTop, alignOption, minusHeight)
	        };
	    },

	    /**
	     * Make tooltip position for treemap chart.
	     * @param {object} params parameters
	     *      @param {{bound: object}} params.data - graph information
	     *      @param {{width: number, height: number}} params.dimension - tooltip dimension
	     * @returns {{left: number, top: number}}
	     * @private
	     */
	    _makeTooltipPositionForTreemapChart: function(params) {
	        var position = this.layout.position;
	        var bound = params.bound;
	        var positionOption = params.positionOption;
	        var labelHeight = renderUtil.getRenderedLabelHeight(chartConst.MAX_HEIGHT_WORD, this.labelTheme);

	        return {
	            left: bound.left + ((bound.width - params.dimension.width) / 2) + positionOption.left - position.left,
	            top: bound.top + (bound.height / 2) - labelHeight + positionOption.top - position.top
	        };
	    },

	    /**
	     * Adjust position.
	     * @param {{width: number, height: number}} tooltipDimension tooltip dimension
	     * @param {{left: number, top: number}} position position
	     * @returns {{left: number, top: number}} adjusted position
	     * @private
	     */
	    _adjustPosition: function(tooltipDimension, position) {
	        var chartDimension = this.dimensionMap.chart;
	        var areaPosition = this.layout.position;

	        position.left = Math.max(position.left, -areaPosition.left);
	        position.left = Math.min(position.left, chartDimension.width - areaPosition.left - tooltipDimension.width);
	        position.top = Math.max(position.top, -areaPosition.top);
	        position.top = Math.min(position.top, chartDimension.height - areaPosition.top - tooltipDimension.height);

	        return position;
	    },

	    /**
	     * Make tooltip position.
	     * @param {object} params parameters
	     *      @param {{left: number, top: number, width: number, height: number}} params.bound graph bound
	     *      @param {string} params.chartType chart type
	     *      @param {boolean} params.allowNegativeTooltip whether allow negative tooltip or not
	     *      @param {{width: number, height: number}} params.dimension tooltip dimension
	     *      @param {string} params.alignOption position option (ex: 'left top')
	     * @returns {{top: number, left: number}} position
	     * @private
	     */
	    _makeTooltipPosition: function(params) {
	        var position = {},
	            sizeType, positionType, addPadding;

	        if (params.mousePosition) {
	            position = this._makeTooltipPositionToMousePosition(params);
	        } else {
	            if (predicate.isBarChart(params.chartType)) {
	                position = this._makeTooltipPositionForBarChart(params);
	                sizeType = 'width';
	                positionType = 'left';
	                addPadding = 1;
	            } else if (predicate.isTreemapChart(params.chartType)) {
	                position = this._makeTooltipPositionForTreemapChart(params);
	            } else {
	                position = this._makeTooltipPositionForNotBarChart(params);
	                sizeType = 'height';
	                positionType = 'top';
	                addPadding = -1;
	            }

	            if (params.allowNegativeTooltip) {
	                position = this._moveToSymmetry(position, {
	                    bound: params.bound,
	                    indexes: params.indexes,
	                    dimension: params.dimension,
	                    chartType: params.chartType,
	                    sizeType: sizeType,
	                    positionType: positionType,
	                    addPadding: addPadding
	                });
	            }

	            position = this._adjustPosition(params.dimension, position);
	        }

	        return position;
	    },

	    /**
	     * Move to symmetry.
	     * @param {{left: number, top: number}} position tooltip position
	     * @param {object} params parameters
	     *      @param {{left: number, top: number, width: number, height: number}} params.bound graph bound
	     *      @param {string} params.id tooltip id
	     *      @param {{width: number, height: number}} params.dimension tooltip dimension
	     *      @param {string} params.sizeType size type (width or height)
	     *      @param {string} params.positionType position type (left or top)
	     *      @param {number} params.addPadding add padding
	     * @returns {{left: number, top: number}} moved position
	     * @private
	     */
	    _moveToSymmetry: function(position, params) {
	        var bound = params.bound;
	        var sizeType = params.sizeType;
	        var positionType = params.positionType;
	        var seriesType = params.seriesType || params.chartType;
	        var value = this.dataProcessor.getValue(params.indexes.groupIndex, params.indexes.index, seriesType);
	        var direction = predicate.isBarChart(this.chartType) ? -1 : 1;
	        var tooltipSize, barSize, movedPositionValue;

	        if (value < 0) {
	            tooltipSize = params.dimension[sizeType];
	            barSize = bound[sizeType];
	            movedPositionValue = position[positionType]
	                + ((barSize + tooltipSize) * direction);
	            position[positionType] = movedPositionValue;
	        }

	        return position;
	    },

	    /**
	     * Whether changed indexes or not.
	     * @param {{groupIndex: number, index: number}} prevIndexes prev indexes
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     * @returns {boolean} whether changed or not
	     * @private
	     */
	    _isChangedIndexes: function(prevIndexes, indexes) {
	        return !!prevIndexes && (prevIndexes.groupIndex !== indexes.groupIndex || prevIndexes.index !== indexes.index);
	    },

	    /**
	     * Show tooltip.
	     * @param {HTMLElement} elTooltip tooltip element
	     * @param {{indexes: {groupIndex: number, index: number}, bound: object}} params tooltip data
	     * @param {{left: number, top: number}} prevPosition prev position
	     * @private
	     */
	    _showTooltip: function(elTooltip, params, prevPosition) {
	        var boundingClientRect = this.tooltipContainer.parentNode.getBoundingClientRect();
	        var indexes = params.indexes;
	        var prevIndexes = this._getIndexesCustomAttribute(elTooltip);
	        var offset = this.options.offset || {};
	        var positionOption = {};
	        var prevChartType = elTooltip && elTooltip.getAttribute('data-chart-type');
	        var position;

	        if (!params.bound && params.mousePosition) {
	            params.bound = {
	                left: params.mousePosition.left - boundingClientRect.left + chartConst.CHART_PADDING,
	                top: params.mousePosition.top - boundingClientRect.top + chartConst.CHART_PADDING
	            };
	        }

	        if (this._isChangedIndexes(prevIndexes, indexes) || prevChartType !== params.chartType) {
	            this.eventBus.fire('hoverOffSeries', prevIndexes, prevChartType);
	        }

	        elTooltip.innerHTML = this._makeSingleTooltipHtml(params.seriesType || params.chartType, indexes);

	        elTooltip.setAttribute('data-chart-type', params.chartType);
	        this._setIndexesCustomAttribute(elTooltip, indexes);
	        this._setShowedCustomAttribute(elTooltip, true);

	        this._fireBeforeShowTooltipPublicEvent(indexes, params.silent);

	        dom.addClass(elTooltip, 'show');

	        positionOption.left = offset.x || 0;
	        positionOption.top = offset.y || 0;

	        position = this._makeTooltipPosition(snippet.extend({
	            dimension: this.getTooltipDimension(elTooltip),
	            positionOption: positionOption,
	            alignOption: this.options.align || ''
	        }, params));

	        this._moveToPosition(elTooltip, position, prevPosition);
	        this.eventBus.fire('hoverSeries', indexes, params.chartType);
	        this._fireAfterShowTooltipPublicEvent(indexes, {
	            element: elTooltip,
	            position: position
	        }, params.silent);
	        delete params.silent;
	    },

	    /**
	     * To call beforeShowTooltip callback of public event.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     * @param {boolean} [silent] - whether invoke a public beforeHideTooltip event or not
	     * @private
	     */
	    _fireBeforeShowTooltipPublicEvent: function(indexes, silent) {
	        var params;

	        if (silent) {
	            return;
	        }

	        params = this._makeShowTooltipParams(indexes);
	        this.eventBus.fire(chartConst.PUBLIC_EVENT_PREFIX + 'beforeShowTooltip', params);
	    },

	    /**
	     * To call afterShowTooltip callback of public event.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     * @param {object} additionParams addition parameters
	     * @param {boolean} [silent] - whether invoke a public beforeHideTooltip event or not
	     * @private
	     */
	    _fireAfterShowTooltipPublicEvent: function(indexes, additionParams, silent) {
	        var params;

	        if (silent) {
	            return;
	        }

	        params = this._makeShowTooltipParams(indexes, additionParams);
	        this.eventBus.fire(chartConst.PUBLIC_EVENT_PREFIX + 'afterShowTooltip', params);
	    },

	    /**
	     * Execute hiding tooltip.
	     * @param {HTMLElement} tooltipElement tooltip element
	     * @private
	     */
	    _executeHidingTooltip: function(tooltipElement) {
	        dom.removeClass(tooltipElement, 'show');
	        tooltipElement.removeAttribute('data-groupIndex');
	        tooltipElement.removeAttribute('data-index');
	        tooltipElement.style.cssText = '';
	    },

	    /**
	     * Hide tooltip.
	     * @param {HTMLElement} tooltipElement - tooltip element
	     * @param {object} prevFoundData - data represented by tooltip elements
	     * @param {{silent: {boolean}}} [options] - options for hiding a tooltip element
	     * @private
	     */
	    _hideTooltip: function(tooltipElement, prevFoundData, options) {
	        var self = this;
	        var indexes = this._getIndexesCustomAttribute(tooltipElement);
	        var chartType = tooltipElement.getAttribute('data-chart-type');
	        var silent = !!(options && options.silent);

	        if (predicate.isChartToDetectMouseEventOnSeries(chartType)) {
	            this.eventBus.fire('hoverOffSeries', indexes, chartType);
	            this._fireBeforeHideTooltipPublicEvent(indexes, silent);
	            this._executeHidingTooltip(tooltipElement);
	        } else if (chartType) {
	            this._setShowedCustomAttribute(tooltipElement, false);
	            this.eventBus.fire('hoverOffSeries', indexes, chartType);

	            if (this._isChangedIndexes(this.prevIndexes, indexes)) {
	                delete this.prevIndexes;
	            }

	            setTimeout(function() {
	                if (self._isShowedTooltip(tooltipElement)) {
	                    return;
	                }
	                self._fireBeforeHideTooltipPublicEvent(indexes, silent);
	                self._executeHidingTooltip(tooltipElement);
	            }, chartConst.HIDE_DELAY);
	        }
	    },

	    /**
	     * To call afterShowTooltip callback of public event.
	     * @param {{groupIndex: number, index: number}} indexes indexes=
	     * @param {boolean} [silent] - whether invoke a public beforeHideTooltip event or not
	     * @private
	     */
	    _fireBeforeHideTooltipPublicEvent: function(indexes, silent) {
	        var params;
	        if (silent) {
	            return;
	        }

	        this.eventBus.fire(chartConst.PUBLIC_EVENT_PREFIX + 'beforeHideTooltip', params);
	    },

	    /**
	     * On show tooltip container.
	     */
	    onShowTooltipContainer: function() {
	        this.tooltipContainer.style.zIndex = chartConst.TOOLTIP_ZINDEX;
	    },

	    /**
	     * On hide tooltip container.
	     */
	    onHideTooltipContainer: function() {
	        this.tooltipContainer.style.zIndex = 0;
	    },

	    /**
	     * Mix in.
	     * @param {function} func target function
	     * @ignore
	     */
	    mixin: function(func) {
	        snippet.extend(func.prototype, this);
	    }
	};

	module.exports = singleTooltipMixer;


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview This is templates of tooltip.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var templateMaker = __webpack_require__(65);

	var htmls = {
	    HTML_DEFAULT_TEMPLATE: '<div class="tui-chart-default-tooltip">' +
	        '<div class="{{ categoryVisible }}">{{ category }}</div>' +
	        '<div>' +
	            '<span>{{ legend }}</span>' +
	            '<span>{{ label }}</span>' +
	            '<span>{{ suffix }}</span>' +
	        '</div>' +
	    '</div>',
	    HTML_PIE_TEMPLATE: '<div class="tui-chart-default-tooltip">' +
	        '<div class="{{ categoryVisible }}">{{ category }}</div>' +
	        '<div>' +
	            '<span>{{ legend }}</span>' +
	            '<span>{{ ratioLabel }}</span>' +
	            '<span>( {{ label }} {{ suffix }})</span>' +
	        '</div>' +
	    '</div>',
	    HTML_COORDINATE_TYPE_CHART_TEMPLATE: '<div class="tui-chart-default-tooltip">' +
	        '<div>{{ category }}</div>' +
	        '<div>' +
	            '<span>{{ legend }}</span>' +
	            '<span>{{ label }}</span>' +
	        '</div>{{ valueTypes }}' +
	    '</div>',
	    HTML_GROUP: '<div class="tui-chart-default-tooltip tui-chart-group-tooltip">' +
	        '<div>{{ category }}</div>' +
	        '{{ items }}' +
	    '</div>',
	    HTML_GROUP_TYPE: '<div class="tui-chart-tooltip-type">{{ type }}</div>',
	    HTML_GROUP_ITEM: '<div>' +
	        '<div class="tui-chart-legend-rect {{ chartType }}" style="{{ cssText }}"></div>' +
	        '&nbsp;<span>{{ legend }}</span>:&nbsp;<span>{{ value }}</span>' +
	        '<span>{{ suffix }}</span>' +
	    '</div>',
	    GROUP_CSS_TEXT: 'background-color:{{ color }}',
	    HTML_MAP_CHART_DEFAULT_TEMPLATE: '<div class="tui-chart-default-tooltip">' +
	        '<div>{{ name }}: {{ value }}{{ suffix }}</div>' +
	    '</div>',
	    HTML_BOXPLOT_TEMPLATE: '<div class="tui-chart-default-tooltip">' +
	        '<div class="{{ categoryVisible }}">{{ category }}</div>' +
	            '<div>' +
	                '<span>{{ legend }}</span>' +
	            '</div>' +
	            '<div>' +
	                '<span>Maximum: </span>' +
	                '<span>{{ maxLabel }}</span>' +
	                '<span>{{ suffix }}</span>' +
	            '</div>' +
	            '<div>' +
	                '<span>Upper Quartile: </span>' +
	                '<span>{{ uqLabel }}</span>' +
	                '<span>{{ suffix }}</span>' +
	            '</div>' +
	            '<div>' +
	                '<span>Median: </span>' +
	                '<span>{{ medianLabel }}</span>' +
	                '<span>{{ suffix }}</span>' +
	            '</div>' +
	            '<div>' +
	                '<span>Lower Quartile: </span>' +
	                '<span>{{ lqLabel }}</span>' +
	                '<span>{{ suffix }}</span>' +
	            '</div>' +
	            '<div>' +
	                '<span>Minimum: </span>' +
	                '<span>{{ minLabel }}</span>' +
	                '<span>{{ suffix }}</span>' +
	            '</div>' +
	    '</div>',
	    HTML_BOXPLOT_OUTLIER: '<div class="tui-chart-default-tooltip">' +
	        '<div class="{{ categoryVisible }}">{{ category }}</div>' +
	            '<div>' +
	                '<span>{{ legend }}</span>' +
	            '</div>' +
	            '<div>' +
	                '<span>Outlier: </span>' +
	                '<span>{{ label }}</span>' +
	                '<span>{{ suffix }}</span>' +
	            '</div>' +
	    '</div>',
	    HTML_BULLET_TEMPLATE: '<div class="tui-chart-default-tooltip">' +
	        '<div class="{{ categoryVisible }}">{{ category }}' +
	        '<span>{{ label }}</span><span>{{ suffix }}</span></div>' +
	    '</div>'
	};

	module.exports = {
	    tplDefault: templateMaker.template(htmls.HTML_DEFAULT_TEMPLATE),
	    tplPieChart: templateMaker.template(htmls.HTML_PIE_TEMPLATE),
	    tplCoordinatetypeChart: templateMaker.template(htmls.HTML_COORDINATE_TYPE_CHART_TEMPLATE),
	    tplGroup: templateMaker.template(htmls.HTML_GROUP),
	    tplGroupType: templateMaker.template(htmls.HTML_GROUP_TYPE),
	    tplGroupItem: templateMaker.template(htmls.HTML_GROUP_ITEM),
	    tplGroupCssText: templateMaker.template(htmls.GROUP_CSS_TEXT),
	    tplMapChartDefault: templateMaker.template(htmls.HTML_MAP_CHART_DEFAULT_TEMPLATE),
	    tplBoxplotChartDefault: templateMaker.template(htmls.HTML_BOXPLOT_TEMPLATE),
	    tplBoxplotChartOutlier: templateMaker.template(htmls.HTML_BOXPLOT_OUTLIER),
	    tplBulletChartDefault: templateMaker.template(htmls.HTML_BULLET_TEMPLATE)
	};


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview This is template maker.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);

	module.exports = {
	    /**
	     * This is template maker.
	     * @param {string} html html
	     * @returns {function} template function
	     * @eaxmple
	     *
	     *   var template = templateMaker.template('<span>{{ name }}</span>'),
	     *       result = template({name: 'John');
	     *   console.log(result); // <span>John</span>
	     *
	     */
	    template: function(html) {
	        return function(data) {
	            var result = html;
	            snippet.forEach(data, function(value, key) {
	                var regExp = new RegExp('{{\\s*' + key + '\\s*}}', 'g');
	                result = result.replace(regExp, String(value).replace('$', '＄'));
	            });

	            return result;
	        };
	    }
	};


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Group tooltip component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var TooltipBase = __webpack_require__(62);
	var GroupTooltipPositionModel = __webpack_require__(67);
	var chartConst = __webpack_require__(8);
	var dom = __webpack_require__(9);
	var renderUtil = __webpack_require__(7);
	var defaultTheme = __webpack_require__(34);
	var tooltipTemplate = __webpack_require__(64);
	var snippet = __webpack_require__(6);
	var predicate = __webpack_require__(11);

	/**
	 * @classdesc GroupTooltip component.
	 * @class GroupTooltip
	 * @private
	 */
	var GroupTooltip = snippet.defineClass(TooltipBase, /** @lends GroupTooltip.prototype */ {
	    /**
	     * Group tooltip component.
	     * @constructs GroupTooltip
	     * @private
	     * @override
	     */
	    init: function(params) {
	        this.prevIndex = null;
	        this.isBullet = predicate.isBulletChart(params.chartType);
	        TooltipBase.call(this, params);
	    },

	    /**
	     * Make tooltip html.
	     * @param {string} category category
	     * @param {Array.<{value: string, legend: string, chartType: string, suffix: ?string}>} items items data
	     * @param {string} rawCategory raw category
	     * @param {number} groupIndex group index
	     * @returns {string} tooltip html
	     * @private
	     */
	    _makeTooltipHtml: function(category, items, rawCategory, groupIndex) {
	        var template = tooltipTemplate.tplGroupItem;
	        var cssTextTemplate = tooltipTemplate.tplGroupCssText;
	        var colors = this._makeColors(this.theme, groupIndex);
	        var prevType, itemsHtml;

	        itemsHtml = snippet.map(items, function(item, index) {
	            var type = item.type;
	            var typeVisible = (type !== 'data') && (prevType !== type);
	            var itemHtml = '';

	            prevType = type;

	            if (!item.value) {
	                return null;
	            }

	            if (typeVisible) {
	                itemHtml = tooltipTemplate.tplGroupType({
	                    type: type
	                });
	            }

	            itemHtml += template(snippet.extend({
	                cssText: cssTextTemplate({color: colors[index]})
	            }, item));

	            return itemHtml;
	        }).join('');

	        return tooltipTemplate.tplGroup({
	            category: category,
	            items: itemsHtml
	        });
	    },

	    /**
	     * Set default align option of tooltip.
	     * @private
	     * @override
	     */
	    _setDefaultTooltipPositionOption: function() {
	        if (this.options.align) {
	            return;
	        }

	        if (this.isVertical) {
	            this.options.align = chartConst.TOOLTIP_DEFAULT_GROUP_ALIGN_OPTION;
	        } else {
	            this.options.align = chartConst.TOOLTIP_DEFAULT_GROUP_HORIZONTAL_ALIGN_OPTION;
	        }
	    },

	    /**
	     * Render tooltip component.
	     * @returns {HTMLElement}
	     * @override
	     */
	    render: function(data) {
	        var container = TooltipBase.prototype.render.call(this, data);
	        var chartDimension = this.dimensionMap.chart;
	        var bound = this.layout;

	        if (data.checkedLegends) {
	            this.theme = {
	                colors: this.colors
	            };
	        }

	        this.positionModel = new GroupTooltipPositionModel(chartDimension, bound, this.isVertical, this.options);

	        return container;
	    },

	    /**
	     * Rerender.
	     * @param {{checkedLegends: Array.<boolean>}} data rendering data
	     * @override
	     */
	    rerender: function(data) {
	        TooltipBase.prototype.rerender.call(this, data);
	        this.prevIndex = null;

	        if (data.checkedLegends) {
	            this.theme = this._updateLegendTheme(data.checkedLegends);
	        }
	    },

	    /**
	     * Zoom.
	     */
	    zoom: function() {
	        this.prevIndex = null;
	        TooltipBase.prototype.zoom.call(this);
	    },

	    /**
	     * Update legend theme.
	     * @param {object | Array.<boolean>}checkedLegends checked legends
	     * @returns {{colors: Array.<string>}} legend theme
	     * @private
	     */
	    _updateLegendTheme: function(checkedLegends) {
	        var colors = [];

	        snippet.forEachArray(this.dataProcessor.getOriginalLegendData(), function(item) {
	            var _checkedLegends = checkedLegends[item.chartType] || checkedLegends;
	            if (_checkedLegends[item.index]) {
	                colors.push(item.theme.color);
	            }
	        });

	        return {
	            colors: colors
	        };
	    },

	    /**
	     * Make tooltip data.
	     * @returns {Array.<object>} tooltip data
	     * @override
	     */
	    makeTooltipData: function() {
	        var length = this.dataProcessor.getCategoryCount(this.isVertical);

	        return snippet.map(this.dataProcessor.getSeriesGroups(), function(seriesGroup, index) {
	            var values = seriesGroup.map(function(item) {
	                return {
	                    type: item.type || 'data',
	                    label: item.label
	                };
	            });

	            return {
	                category: this.dataProcessor.makeTooltipCategory(index, length - index, this.isVertical),
	                values: values
	            };
	        }, this);
	    },

	    /**
	     * Make colors.
	     * @param {object} theme tooltip theme
	     * @param {number} [groupIndex] groupIndex
	     * @returns {Array.<string>} colors
	     * @private
	     */
	    _makeColors: function(theme, groupIndex) {
	        var colorIndex = 0,
	            legendLabels = this.dataProcessor.getLegendData(),
	            defaultColors, colors, prevChartType;

	        if (this.isBullet) {
	            return this.dataProcessor.getGraphColors()[groupIndex];
	        }

	        if (theme.colors) {
	            return theme.colors;
	        }

	        defaultColors = defaultTheme.series.colors.slice(0, legendLabels.length);

	        return snippet.map(snippet.pluck(legendLabels, 'chartType'), function(chartType) {
	            var color;

	            if (prevChartType !== chartType) {
	                colors = theme[chartType] ? theme[chartType].colors : defaultColors;
	                colorIndex = 0;
	            }

	            prevChartType = chartType;
	            color = colors[colorIndex];
	            colorIndex += 1;

	            return color;
	        });
	    },

	    /**
	     * Make rendering data about legend item.
	     * @param {Array.<string>} values values
	     * @param {number} groupIndex groupIndex
	     * @returns {Array.<{value: string, legend: string, chartType: string, suffix: ?string}>} legend item data.
	     * @private
	     */
	    _makeItemRenderingData: function(values, groupIndex) {
	        var dataProcessor = this.dataProcessor,
	            suffix = this.suffix;

	        return snippet.map(values, function(data, index) {
	            var item = {
	                value: data.label,
	                type: data.type,
	                suffix: suffix,
	                legend: ''
	            };
	            var legendLabel;

	            if (this.isBullet) {
	                legendLabel = dataProcessor.getLegendItem(groupIndex);
	            } else {
	                legendLabel = dataProcessor.getLegendItem(index);
	                item.legend = legendLabel.label;
	            }

	            item.chartType = legendLabel.chartType;

	            return item;
	        }, this);
	    },

	    /**
	     * Make tooltip.
	     * @param {number} groupIndex group index
	     * @returns {string} tooltip html
	     * @private
	     */
	    _makeGroupTooltipHtml: function(groupIndex) {
	        var data = this.data[groupIndex];
	        var items, htmlString = '';

	        if (data) {
	            items = this._makeItemRenderingData(data.values, groupIndex);
	            htmlString = this.templateFunc(data.category, items, this.getRawCategory(groupIndex), groupIndex);
	        }

	        return htmlString;
	    },

	    /**
	     * Get tooltip sector element.
	     * @returns {HTMLElement} sector element
	     * @private
	     */
	    _getTooltipSectorElement: function() {
	        var groupTooltipSector;

	        if (!this.groupTooltipSector) {
	            this.groupTooltipSector = groupTooltipSector = dom.create('DIV', 'tui-chart-group-tooltip-sector');
	            dom.append(this.tooltipContainer, groupTooltipSector);
	        }

	        return this.groupTooltipSector;
	    },

	    /**
	     * Make bound about tooltip sector of vertical type chart.
	     * @param {number} height height
	     * @param {{start: number, end: number}} range range
	     * @param {boolean} isLine whether line or not
	     * @returns {{dimension: {width: number, height: number}, position: {left: number, top: number}}} bound
	     * @private
	     */
	    _makeVerticalTooltipSectorBound: function(height, range, isLine) {
	        var width;

	        if (isLine) {
	            width = 1;
	        } else {
	            width = range.end - range.start;
	        }

	        return {
	            dimension: {
	                width: width,
	                height: height
	            },
	            position: {
	                left: range.start,
	                top: chartConst.SERIES_EXPAND_SIZE
	            }
	        };
	    },

	    /**
	     * Make bound about tooltip sector of horizontal type chart.
	     * @param {number} width width
	     * @param {{start: number, end:number}} range range
	     * @returns {{dimension: {width: number, height: number}, position: {left: number, top: number}}} bound
	     * @private
	     */
	    _makeHorizontalTooltipSectorBound: function(width, range) {
	        return {
	            dimension: {
	                width: width,
	                height: range.end - range.start
	            },
	            position: {
	                left: chartConst.SERIES_EXPAND_SIZE,
	                top: range.start
	            }
	        };
	    },

	    /**
	     * Make bound about tooltip sector.
	     * @param {number} size width or height
	     * @param {{start: number, end:number}} range range
	     * @param {boolean} isVertical whether vertical or not
	     * @param {boolean} isLine whether line type or not
	     * @returns {{dimension: {width: number, height: number}, position: {left: number, top: number}}} bound
	     * @private
	     */
	    _makeTooltipSectorBound: function(size, range, isVertical, isLine) {
	        var bound;

	        if (isVertical) {
	            bound = this._makeVerticalTooltipSectorBound(size, range, isLine);
	        } else {
	            bound = this._makeHorizontalTooltipSectorBound(size, range);
	        }

	        return bound;
	    },

	    /**
	     * Show tooltip sector.
	     * @param {number} size width or height
	     * @param {{start: number, end:number}} range range
	     * @param {boolean} isVertical whether vertical or not
	     * @param {number} index index
	     * @param {boolean} [isMoving] whether moving or not
	     * @private
	     */
	    _showTooltipSector: function(size, range, isVertical, index, isMoving) {
	        var groupTooltipSector = this._getTooltipSectorElement(),
	            isLine = (range.start === range.end),
	            bound = this._makeTooltipSectorBound(size, range, isVertical, isLine);

	        if (isLine) {
	            this.eventBus.fire('showGroupTooltipLine', bound);
	        } else {
	            renderUtil.renderDimension(groupTooltipSector, bound.dimension);
	            renderUtil.renderPosition(groupTooltipSector, bound.position);
	            dom.addClass(groupTooltipSector, 'show');
	        }

	        if (isMoving) {
	            index -= 1;
	        }

	        this.eventBus.fire('showGroupAnimation', index);
	    },

	    /**
	     * Hide tooltip sector.
	     * @param {number} index index
	     * @private
	     */
	    _hideTooltipSector: function(index) {
	        var groupTooltipSector = this._getTooltipSectorElement();

	        if (!dom.hasClass(groupTooltipSector, 'show')) {
	            this.eventBus.fire('hideGroupTooltipLine');
	        } else {
	            dom.removeClass(groupTooltipSector, 'show');
	        }
	        this.eventBus.fire('hideGroupAnimation', index);
	        this.eventBus.fire('hideGroupTooltipLine');
	    },

	    /**
	     * Show tooltip.
	     * @param {HTMLElement} elTooltip tooltip element
	     * @param {{index: number, range: {start: number, end: number},
	     *          size: number, direction: string, isVertical: boolean
	     *        }} params coordinate event parameters
	     * @param {{left: number, top: number}} prevPosition prev position
	     * @private
	     */
	    _showTooltip: function(elTooltip, params, prevPosition) {
	        var dimension, position;

	        if (!snippet.isNull(this.prevIndex)) {
	            this.eventBus.fire('hideGroupAnimation', this.prevIndex);
	        }

	        elTooltip.innerHTML = this._makeGroupTooltipHtml(params.index);

	        this._fireBeforeShowTooltipPublicEvent(params.index, params.range, params.silent);

	        dom.addClass(elTooltip, 'show');

	        this._showTooltipSector(params.size, params.range, params.isVertical, params.index, params.isMoving);

	        dimension = this.getTooltipDimension(elTooltip);
	        position = this.positionModel.calculatePosition(dimension, params.range);

	        this._moveToPosition(elTooltip, position, prevPosition);

	        this._fireAfterShowTooltipPublicEvent(params.index, params.range, {
	            element: elTooltip,
	            position: position
	        }, params.silent);

	        this.prevIndex = params.index;
	    },

	    /**
	     * To call beforeShowTooltip callback of public event.
	     * @param {number} index index
	     * @param {{start: number, end: number}} range range
	     * @param {boolean} [silent] - whether invoke a public beforeHideTooltip event or not
	     * @private
	     */
	    _fireBeforeShowTooltipPublicEvent: function(index, range, silent) {
	        if (silent) {
	            return;
	        }

	        this.eventBus.fire(chartConst.PUBLIC_EVENT_PREFIX + 'beforeShowTooltip', {
	            chartType: this.chartType,
	            index: index,
	            range: range
	        });
	    },

	    /**
	     * To call afterShowTooltip callback of public event.
	     * @param {number} index index
	     * @param {{start: number, end: number}} range range
	     * @param {object} additionParams addition parameters
	     * @param {boolean} [silent] - whether invoke a public beforeHideTooltip event or not
	     * @private
	     */
	    _fireAfterShowTooltipPublicEvent: function(index, range, additionParams, silent) {
	        if (silent) {
	            return;
	        }
	        this.eventBus.fire(chartConst.PUBLIC_EVENT_PREFIX + 'afterShowTooltip', snippet.extend({
	            chartType: this.chartType,
	            index: index,
	            range: range
	        }, additionParams));
	    },

	    /**
	     * Hide tooltip.
	     * @param {HTMLElement} tooltipElement tooltip element
	     * @param {number} prevFoundIndex - showing tooltip index
	     * @param {object} [options] - options for hiding tooltip
	     * @private
	     */
	    _hideTooltip: function(tooltipElement, prevFoundIndex, options) {
	        var silent = !!(options && options.silent);
	        this.prevIndex = null;
	        this._fireBeforeHideTooltipPublicEvent(prevFoundIndex, silent);
	        this._hideTooltipSector(prevFoundIndex);
	        dom.removeClass(tooltipElement, 'show');
	        tooltipElement.style.cssText = '';
	    },

	    /**
	     * To call beforeHideTooltip callback of public event.
	     * @param {number} index index
	     * @param {boolean} [silent] - options for hiding tooltip
	     * @private
	     */
	    _fireBeforeHideTooltipPublicEvent: function(index, silent) {
	        if (silent) {
	            return;
	        }

	        this.eventBus.fire(chartConst.PUBLIC_EVENT_PREFIX + 'beforeHideTooltip', {
	            chartType: this.chartType,
	            index: index
	        });
	    }
	});

	function groupTooltipFactory(params) {
	    return new GroupTooltip(params);
	}

	groupTooltipFactory.componentType = 'tooltip';
	groupTooltipFactory.GroupTooltip = GroupTooltip;

	module.exports = groupTooltipFactory;


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview GroupTooltipPositionModel is position model for group tooltip..
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var snippet = __webpack_require__(6);

	var GroupTooltipPositionModel = snippet.defineClass(/** @lends GroupTooltipPositionModel.prototype */ {
	    /**
	     * GroupTooltipPositionModel is position model for group tooltip.
	     * @constructs GroupTooltipPositionModel
	     * @private
	     * @param {{width: number, height: number}} chartDimension chart dimension
	     * @param {{
	     *      dimension: {width: number, height: number},
	     *      position: {left: number, top: number}
	     * }} areaBound tooltip area bound
	     * @param {boolean} isVertical whether vertical or not
	     * @param {{align: ?string, position: {left: number, top: number}}} options tooltip options
	     */
	    init: function(chartDimension, areaBound, isVertical, options) {
	        /**
	         * chart dimension
	         * @type {{width: number, height: number}}
	         */
	        this.chartDimension = chartDimension;

	        /**
	         * tooltip area bound
	         * @type {{dimension: {width: number, height: number}, position: {left: number, top: number}}}
	         */
	        this.areaBound = areaBound;

	        /**
	         * Whether vertical or not
	         * @type {boolean}
	         */
	        this.isVertical = isVertical;

	        /**
	         * tooltip options
	         * @type {{align: ?string, position: {left: number, top: number}}}
	         */
	        this.options = options;

	        /**
	         * For caching
	         * @type {object}
	         */
	        this.positions = {};

	        this._setData(chartDimension, areaBound, isVertical, options);
	    },

	    /**
	     * Get horizontal direction.
	     * @param {?string} alignOption align option
	     * @returns {string} direction
	     * @private
	     */
	    _getHorizontalDirection: function(alignOption) {
	        var direction;

	        alignOption = alignOption || '';
	        if (alignOption.indexOf('left') > -1) {
	            direction = chartConst.TOOLTIP_DIRECTION_BACKWARD;
	        } else if (alignOption.indexOf('center') > -1) {
	            direction = chartConst.TOOLTIP_DIRECTION_CENTER;
	        } else {
	            direction = chartConst.TOOLTIP_DIRECTION_FORWARD;
	        }

	        return direction;
	    },

	    /**
	     * Make vertical data.
	     * @param {{width: number, height: number}} chartDimension chart dimension
	     * @param {{
	     *      dimension: {width: number, height: number},
	     *      position: {left: number, top: number}
	     * }} areaBound tooltip area bound
	     * @param {?string} alignOption align option
	     * @returns {{
	     *      positionType: string, sizeType: string, direction: (string),
	     *      areaPosition: number, areaSize: number, chartSize: number,
	     *      basePosition: (number)
	     * }} vertical data
	     * @private
	     */
	    _makeVerticalData: function(chartDimension, areaBound, alignOption) {
	        var hDirection = this._getHorizontalDirection(alignOption);

	        return {
	            positionType: 'left',
	            sizeType: 'width',
	            direction: hDirection,
	            areaPosition: areaBound.position.left,
	            areaSize: areaBound.dimension.width,
	            chartSize: chartDimension.width,
	            basePosition: chartConst.SERIES_EXPAND_SIZE
	        };
	    },

	    /**
	     * Get vertical direction.
	     * @param {?string} alignOption align option
	     * @returns {string} direction
	     * @private
	     */
	    _getVerticalDirection: function(alignOption) {
	        var direction;

	        alignOption = alignOption || '';

	        if (alignOption.indexOf('top') > -1) {
	            direction = chartConst.TOOLTIP_DIRECTION_BACKWARD;
	        } else if (alignOption.indexOf('bottom') > -1) {
	            direction = chartConst.TOOLTIP_DIRECTION_FORWARD;
	        } else {
	            direction = chartConst.TOOLTIP_DIRECTION_CENTER;
	        }

	        return direction;
	    },

	    /**
	     * Make horizontal data.
	     * @param {{width: number, height: number}} chartDimension chart dimension
	     * @param {{
	     *      dimension: {width: number, height: number},
	     *      position: {left: number, top: number}
	     * }} areaBound tooltip area bound
	     * @param {?string} alignOption align option
	     * @returns {{
	     *      positionType: string, sizeType: string, direction: (string),
	     *      areaPosition: number, areaSize: number, chartSize: number,
	     *      basePosition: (number)
	     * }} horizontal data
	     * @private
	     */
	    _makeHorizontalData: function(chartDimension, areaBound, alignOption) {
	        var vDirection = this._getVerticalDirection(alignOption);

	        return {
	            positionType: 'top',
	            sizeType: 'height',
	            direction: vDirection,
	            areaPosition: areaBound.position.top,
	            areaSize: areaBound.dimension.height,
	            chartSize: chartDimension.height,
	            basePosition: chartConst.SERIES_EXPAND_SIZE
	        };
	    },

	    /**
	     * Set data.
	     * @param {{width: number, height: number}} chartDimension chart dimension
	     * @param {{
	     *      dimension: {width: number, height: number},
	     *      position: {left: number, top: number}
	     * }} areaBound tooltip area bound
	     * @param {boolean} isVertical whether vertical or not
	     * @param {{align: ?string, position: {left: number, top: number}}} options tooltip options
	     * @private
	     */
	    _setData: function(chartDimension, areaBound, isVertical, options) {
	        var verticalData = this._makeVerticalData(chartDimension, areaBound, options.align);
	        var horizontalData = this._makeHorizontalData(chartDimension, areaBound, options.align);
	        var offset = options.offset || {};

	        if (isVertical) {
	            this.mainData = verticalData;
	            this.subData = horizontalData;
	        } else {
	            this.mainData = horizontalData;
	            this.subData = verticalData;
	        }

	        this.positionOption = {};
	        this.positionOption.left = offset.x || 0;
	        this.positionOption.top = offset.y || 0;

	        this.positions = {};
	    },

	    /**
	     * Calculate main position value.
	     * @param {number} tooltipSize tooltip size (width or height)
	     * @param {{start: number, end: number}} range range
	     * @param {object} data data
	     *      @param {string} data.direction direction
	     *      @param {number} data.basePosition basePosition
	     * @returns {number} position value
	     * @private
	     */
	    _calculateMainPositionValue: function(tooltipSize, range, data) {
	        var isLine = (range.start === range.end),
	            lineTypePadding = 9,
	            otherTypePadding = 5,
	            padding = isLine ? lineTypePadding : otherTypePadding,
	            value = data.basePosition;

	        if (data.direction === chartConst.TOOLTIP_DIRECTION_FORWARD) {
	            value += range.end + padding;
	        } else if (data.direction === chartConst.TOOLTIP_DIRECTION_BACKWARD) {
	            value += range.start - tooltipSize - padding;
	        } else if (isLine) {
	            value += range.start - (tooltipSize / 2);
	        } else {
	            value += range.start + ((range.end - range.start - tooltipSize) / 2);
	        }

	        return value;
	    },

	    /**
	     * Calculate sub position value.
	     * @param {number} tooltipSize tooltip size (width or height)
	     * @param {object} data data
	     *      @param {number} data.areaSize tooltip area size (width or height)
	     *      @param {string} data.direction direction
	     *      @param {number} data.basePosition basePosition
	     * @returns {number} position value
	     * @private
	     */
	    _calculateSubPositionValue: function(tooltipSize, data) {
	        var middle = data.areaSize / 2,
	            value;

	        if (data.direction === chartConst.TOOLTIP_DIRECTION_FORWARD) {
	            value = middle + data.basePosition;
	        } else if (data.direction === chartConst.TOOLTIP_DIRECTION_BACKWARD) {
	            value = middle - tooltipSize + data.basePosition;
	        } else {
	            value = middle - (tooltipSize / 2) + data.basePosition;
	        }

	        return value;
	    },

	    /**
	     * Make position value diff.
	     * @param {number} value positoin value
	     * @param {number} tooltipSize tooltip size (width or height)
	     * @param {object} data data
	     *      @param {number} data.chartSize chart size (width or height)
	     *      @param {number} data.areaPosition tooltip area position (left or top)
	     * @returns {number} diff
	     * @private
	     */
	    _makePositionValueDiff: function(value, tooltipSize, data) {
	        return value + data.areaPosition + tooltipSize - data.chartSize;
	    },

	    /**
	     * Adjust backward position value.
	     * @param {number} value position value
	     * @param {{start: number, end: number}} range range
	     * @param {number} tooltipSize tooltip size (width or height)
	     * @param {object} data data
	     *      @param {number} data.chartSize chart size (width or height)
	     *      @param {number} data.areaPosition tooltip area position (left or top)
	     *      @param {number} data.basePosition basePosition
	     * @returns {number} position value
	     * @private
	     */
	    _adjustBackwardPositionValue: function(value, range, tooltipSize, data) {
	        var changedValue;

	        if (value < -data.areaPosition) {
	            changedValue = this._calculateMainPositionValue(tooltipSize, range, {
	                direction: chartConst.TOOLTIP_DIRECTION_FORWARD,
	                basePosition: data.basePosition
	            });
	            if (this._makePositionValueDiff(changedValue, tooltipSize, data) > 0) {
	                value = -data.areaPosition;
	            } else {
	                value = changedValue;
	            }
	        }

	        return value;
	    },

	    /**
	     * Adjust forward position value.
	     * @param {number} value position value
	     * @param {{start: number, end: number}} range range
	     * @param {number} tooltipSize tooltip size (width or height)
	     * @param {object} data data
	     *      @param {number} data.chartSize chart size (width or height)
	     *      @param {number} data.areaPosition tooltip area position (left or top)
	     *      @param {number} data.basePosition basePosition
	     * @returns {number} position value
	     * @private
	     */
	    _adjustForwardPositionValue: function(value, range, tooltipSize, data) {
	        var diff = this._makePositionValueDiff(value, tooltipSize, data),
	            changedValue;

	        if (diff > 0) {
	            changedValue = this._calculateMainPositionValue(tooltipSize, range, {
	                direction: chartConst.TOOLTIP_DIRECTION_BACKWARD,
	                basePosition: data.basePosition
	            });
	            if (changedValue < -data.areaPosition) {
	                value -= diff;
	            } else {
	                value = changedValue;
	            }
	        }

	        return value;
	    },

	    /**
	     * Adjust main position value
	     * @param {number} value position value
	     * @param {{start: number, end: number}} range range
	     * @param {number} tooltipSize tooltip size (width or height)
	     * @param {object} data data
	     *      @param {number} data.chartSize chart size (width or height)
	     *      @param {number} data.areaPosition tooltip area position (left or top)
	     * @returns {number} position value
	     * @private
	     */
	    _adjustMainPositionValue: function(value, range, tooltipSize, data) {
	        if (data.direction === chartConst.TOOLTIP_DIRECTION_BACKWARD) {
	            value = this._adjustBackwardPositionValue(value, range, tooltipSize, data);
	        } else if (data.direction === chartConst.TOOLTIP_DIRECTION_FORWARD) {
	            value = this._adjustForwardPositionValue(value, range, tooltipSize, data);
	        } else {
	            value = Math.max(value, -data.areaPosition);
	            value = Math.min(value, data.chartSize - data.areaPosition - tooltipSize);
	        }

	        return value;
	    },

	    /**
	     * Adjust sub position value.
	     * @param {number} value position value
	     * @param {number} tooltipSize tooltip size (width or height)
	     * @param {object} data data
	     *      @param {number} data.chartSize chart size (width or height)
	     *      @param {number} data.areaPosition tooltip area position (left or top)
	     *      @param {number} data.basePosition basePosition
	     * @returns {number} position value
	     * @private
	     */
	    _adjustSubPositionValue: function(value, tooltipSize, data) {
	        if (data.direction === chartConst.TOOLTIP_DIRECTION_FORWARD) {
	            value = Math.min(value, data.chartSize - data.areaPosition - tooltipSize);
	        } else {
	            value = Math.max(value, -data.areaPosition);
	        }

	        return value;
	    },

	    /**
	     * Make caching key.
	     * @param {{start: number, end: number}} range range
	     * @returns {string} key
	     * @private
	     */
	    _makeCachingKey: function(range) {
	        return range.start + '-' + range.end;
	    },

	    /**
	     * Add position option.
	     * @param {number} position position
	     * @param {string} positionType position type (left or top)
	     * @returns {number} position
	     * @private
	     */
	    _addPositionOptionValue: function(position, positionType) {
	        return position + this.positionOption[positionType];
	    },

	    /**
	     * Make main position value.
	     * @param {{width: number, height: number}} tooltipDimension tooltip dimension
	     * @param {{start: number, end: number}} range tooltip sector range
	     * @param {{
	     *      positionType: string, sizeType: string, direction: (string),
	     *      areaPosition: number, areaSize: number, chartSize: number,
	     *      basePosition: (number)
	     * }} main main data
	     * @returns {number} position value
	     * @private
	     */
	    _makeMainPositionValue: function(tooltipDimension, range, main) {
	        var value;

	        value = this._calculateMainPositionValue(tooltipDimension[main.sizeType], range, main);
	        value = this._addPositionOptionValue(value, main.positionType);
	        value = this._adjustMainPositionValue(value, range, tooltipDimension[main.sizeType], main);

	        return value;
	    },

	    /**
	     * Make sub position value.
	     * @param {{width: number, height: number}} tooltipDimension tooltip dimension
	     * @param {{
	     *      positionType: string, sizeType: string, direction: (string),
	     *      areaPosition: number, areaSize: number, chartSize: number,
	     *      basePosition: (number)
	     * }} sub sub data
	     * @returns {number} position value
	     * @private
	     */
	    _makeSubPositionValue: function(tooltipDimension, sub) {
	        var value;

	        value = this._calculateSubPositionValue(tooltipDimension[sub.sizeType], sub);
	        value = this._addPositionOptionValue(value, sub.positionType);
	        value = this._adjustSubPositionValue(value, tooltipDimension[sub.sizeType], sub);

	        return value;
	    },

	    /**
	     * Calculate group tooltip position.
	     * @param {{width: number, height: number}} tooltipDimension tooltip dimension
	     * @param {{start: number, end: number}} range tooltip sector range
	     * @returns {{left: number, top: number}} group tooltip position
	     */
	    calculatePosition: function(tooltipDimension, range) {
	        var key = this._makeCachingKey(range),
	            main = this.mainData,
	            sub = this.subData,
	            position = this.positions[key];

	        if (!position) {
	            position = {};
	            position[main.positionType] = this._makeMainPositionValue(tooltipDimension, range, main);
	            position[sub.positionType] = this._makeSubPositionValue(tooltipDimension, sub);
	            this.positions[key] = position;
	        }

	        return position;
	    },

	    /**
	     * Update tooltip options for position calculation.
	     * @param {{align: ?string, position: {left: number, top: number}}} options tooltip options
	     */
	    updateOptions: function(options) {
	        this.options = options;
	        this._setData(this.chartDimension, this.areaBound, this.isVertical, options);
	    },

	    /**
	     * Update tooltip bound for position calculation.
	     * @param {{
	     *      dimension: {width: number, height: number},
	     *      position: {left: number, top: number}
	     * }} bound tooltip area bound
	     */
	    updateBound: function(bound) {
	        this.areaBound = bound;
	        this._setData(this.chartDimension, bound, this.isVertical, this.options);
	    }
	});

	module.exports = GroupTooltipPositionModel;


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Tooltip component for map chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var TooltipBase = __webpack_require__(62);
	var singleTooltipMixer = __webpack_require__(63);
	var tooltipTemplate = __webpack_require__(64);
	var snippet = __webpack_require__(6);

	/**
	 * @classdesc MapChartTooltip component.
	 * @class MapChartTooltip
	 * @private
	 */
	var MapChartTooltip = snippet.defineClass(TooltipBase, /** @lends MapChartTooltip.prototype */ {
	    /**
	     * Map chart tooltip component.
	     * @constructs MapChartTooltip
	     * @private
	     * @override
	     */
	    init: function(params) {
	        /**
	         * Map model
	         * @type {MapChartMapModel}
	         */
	        this.mapModel = params.mapModel;

	        TooltipBase.apply(this, arguments);
	    },

	    /**
	     * Make tooltip html.
	     * @param {{name: string, value: number}} datum tooltip datum
	     * @returns {string} tooltip html
	     * @private
	     */
	    _makeTooltipHtml: function(datum) {
	        return tooltipTemplate.tplMapChartDefault(datum);
	    },

	    /**
	     * Make single tooltip html.
	     * @param {string} chartType chart type
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     * @returns {string} tooltip html
	     * @private
	     */
	    _makeSingleTooltipHtml: function(chartType, indexes) {
	        var datum = this.mapModel.getDatum(indexes.index),
	            suffix = this.options.suffix ? ' ' + this.options.suffix : '';

	        return this.templateFunc({
	            name: datum.name || datum.code,
	            value: datum.label,
	            suffix: suffix
	        });
	    },

	    /**
	     * Make parameters for show tooltip user event.
	     * @param {{groupIndex: number, index: number}} indexes indexes
	     * @param {object} additionParams addition parameters
	     * @returns {{chartType: string, legend: string, legendIndex: number, index: number}} parameters for show tooltip
	     * @private
	     */
	    _makeShowTooltipParams: function(indexes, additionParams) {
	        var datum = this.mapModel.getDatum(indexes.index),
	            params;

	        params = snippet.extend({
	            chartType: this.chartType,
	            code: datum.code,
	            name: datum.name,
	            value: datum.label,
	            index: indexes.index
	        }, additionParams);

	        return params;
	    },

	    /**
	     * Set default align option of tooltip.
	     * @private
	     * @override
	     */
	    _setDefaultTooltipPositionOption: function() {
	        if (!this.options.align) {
	            this.options.align = chartConst.TOOLTIP_DEFAULT_ALIGN_OPTION;
	        }
	    }
	});

	singleTooltipMixer.mixin(MapChartTooltip);

	function mapChartTooltipFactory(params) {
	    return new MapChartTooltip(params);
	}

	mapChartTooltipFactory.componentType = 'tooltip';

	module.exports = mapChartTooltipFactory;


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview MapChartEventDetector is mouse event detector for map chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var MouseEventDetectorBase = __webpack_require__(70);
	var chartConst = __webpack_require__(8);
	var eventListener = __webpack_require__(55);
	var dom = __webpack_require__(9);
	var renderUtil = __webpack_require__(7);
	var snippet = __webpack_require__(6);

	var MapChartEventDetector = snippet.defineClass(MouseEventDetectorBase, /** @lends MapChartEventDetector.prototype */ {
	    /**
	     * MapChartEventDetector is mouse event detector for map chart.
	     * @param {object} params parameters
	     *      @param {string} params.chartType - chart type
	     * @constructs MapChartEventDetector
	     * @private
	     * @extends MouseEventDetectorBase
	     */
	    init: function(params) {
	        /**
	         * chart type
	         * {string}
	         *
	         */
	        this.chartType = params.chartType;

	        /**
	         * event bus for transmitting message
	         * @type {object}
	         */
	        this.eventBus = params.eventBus;

	        /**
	         * whether mouse down or not
	         * @type {boolean}
	         */
	        this.isDown = false;

	        this.drawingType = chartConst.COMPONENT_TYPE_DOM;
	    },

	    /**
	     * Render event handle layer area
	     * @param {HTMLElement} mouseEventDetectorContainer mouse event detector container element
	     * @private
	     */
	    _renderMouseEventDetectorArea: function(mouseEventDetectorContainer) {
	        renderUtil.renderDimension(mouseEventDetectorContainer, this.layout.dimension);
	        renderUtil.renderPosition(mouseEventDetectorContainer, this.layout.position);
	    },

	    /**
	     * On click.
	     * @private
	     * @override
	     */
	    _onClick: function() {},

	    /**
	     * Call 'dragStartMapSeries' event, when occur mouse down event.
	     * @param {mouseevent} e mouse event
	     * @private
	     * @override
	     */
	    _onMousedown: function(e) {
	        this.isDown = true;
	        this.eventBus.fire('dragStartMapSeries', {
	            left: e.clientX,
	            top: e.clientY
	        });
	    },

	    /**
	     * Drag end.
	     * @private
	     */
	    _dragEnd: function() {
	        this.isDrag = false;
	        dom.removeClass(this.mouseEventDetectorContainer, 'drag');
	        this.eventBus.fire('dragEndMapSeries');
	    },

	    /**
	     * If drag, call dragEnd function.
	     * But if not drag, occur click event.
	     * @param {mouseevent} e mouse event
	     * @private
	     * @override
	     */
	    _onMouseup: function(e) {
	        this.isDown = false;

	        if (this.isDrag) {
	            this._dragEnd();
	        } else {
	            this._onMouseEvent('click', e);
	        }

	        this.isMove = false;
	    },

	    /**
	     * If mouse downed, set drag mode.
	     * But if not downed, set move mode.
	     * @param {mouseevent} e mouse event
	     * @private
	     * @override
	     */
	    _onMousemove: function(e) {
	        if (this.isDown) {
	            if (!this.isDrag) {
	                dom.addClass(this.mouseEventDetectorContainer, 'drag');
	            }
	            this.isDrag = true;
	            this.eventBus.fire('dragMapSeries', {
	                left: e.clientX,
	                top: e.clientY
	            });
	        } else {
	            this.isMove = true;
	            this._onMouseEvent('move', e);
	        }
	    },

	    /**
	     * If drag mode, call dragEnd.
	     * But if not drag mode, occur move event.
	     * @private
	     * @override
	     */
	    _onMouseout: function(e) {
	        if (this.isDrag) {
	            this._dragEnd();
	        } else {
	            this._onMouseEvent('move', e);
	        }
	        this.isDown = false;
	    },

	    /**
	     * On mouse wheel.
	     * @param {mouseevent} e mouse event
	     * @returns {?boolean}
	     * @private
	     */
	    _onMousewheel: function(e) {
	        var wheelDelta = e.wheelDelta || e.detail * chartConst.FF_WHEELDELTA_ADJUSTING_VALUE;

	        this.eventBus.fire('wheel', wheelDelta, {
	            left: e.clientX,
	            top: e.clientY
	        });

	        if (e.preventDefault) {
	            e.preventDefault();
	        }

	        return false;
	    },

	    /**
	     * Attach event.
	     * @param {HTMLElement} target target element
	     * @override
	     */
	    attachEvent: function(target) {
	        MouseEventDetectorBase.prototype.attachEvent.call(this, target);

	        if (snippet.browser.firefox) {
	            eventListener.on(target, 'DOMMouseScroll', this._onMousewheel, this);
	        } else {
	            eventListener.on(target, 'mousewheel', this._onMousewheel, this);
	        }
	    }
	});

	function mapChartEventDetectorFactory(params) {
	    return new MapChartEventDetector(params);
	}

	mapChartEventDetectorFactory.componentType = 'mouseEventDetector';

	module.exports = mapChartEventDetectorFactory;


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview MouseEventDetectorBase is base class for mouse event detector components.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var TickBaseCoordinateModel = __webpack_require__(71);
	var BoundsBaseCoordinateModel = __webpack_require__(72);
	var chartConst = __webpack_require__(8);
	var eventListener = __webpack_require__(55);
	var predicate = __webpack_require__(11);
	var dom = __webpack_require__(9);
	var renderUtil = __webpack_require__(7);
	var snippet = __webpack_require__(6);

	var MouseEventDetectorBase = snippet.defineClass(/** @lends MouseEventDetectorBase.prototype */ {
	    /**
	     * MouseEventDetectorBase is base class for mouse event detector components.
	     * @constructs MouseEventDetectorBase
	     * @private
	     * @param {object} params parameters
	     *      @param {string} params.chartType - chart type
	     *      @param {Array.<string>} params.chartTypes - chart types
	     *      @param {boolean} params.isVertical - whether vertical or not
	     *      @param {DataProcessor} params.dataProcessor - DataProcessor instance
	     *      @param {boolean} params.allowSelect - whether has allowSelect option or not
	     */
	    init: function(params) {
	        var isLineTypeChart;

	        /**
	         * type of chart
	         * @type {string}
	         */
	        this.chartType = params.chartType;

	        /**
	         * chartTypes is available in combo chart
	         * @type {Array.<string>}
	         */
	        this.chartTypes = params.chartTypes;

	        /**
	         * whether vertical or not
	         * @type {boolean}
	         */
	        this.isVertical = params.isVertical;

	        /**
	         * data processor
	         * @type {DataProcessor}
	         */
	        this.dataProcessor = params.dataProcessor;

	        /**
	         * whether allow select series or not
	         * @type {boolean}
	         */
	        this.allowSelect = params.allowSelect;

	        /**
	         * event bus for transmitting message
	         * @type {object}
	         */
	        this.eventBus = params.eventBus;

	        /**
	         * layout bounds information for this components
	         * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number}}}
	         */
	        this.layout = null;

	        /**
	         * selected series item.
	         * @type {null | object}
	         */
	        this.selectedData = null;

	        isLineTypeChart = predicate.isLineTypeChart(this.chartType, this.chartTypes);
	        /**
	         * expand size
	         * @type {number}
	         */
	        this.expandSize = isLineTypeChart ? chartConst.SERIES_EXPAND_SIZE : 0;

	        /**
	         * series item bounds data
	         * @type {Array}
	         */
	        this.seriesItemBoundsData = [];

	        /**
	         * series count
	         * @type {number}
	         */
	        this.seriesCount = predicate.isComboChart(this.chartType) ? 2 : 1;

	        this._attachToEventBus();

	        this.drawingType = chartConst.COMPONENT_TYPE_DOM;
	    },

	    /**
	     * Attach to event bus.
	     * @private
	     */
	    _attachToEventBus: function() {
	        this.eventBus.on('receiveSeriesData', this.onReceiveSeriesData, this);
	    },

	    /**
	     * Get bound for rendering.
	     * @returns {{
	     *      dimension: {width: number, height: number},
	     *      position: {left: number, top: number}
	     * }}
	     * @private
	     */
	    _getRenderingBound: function() {
	        var renderingBound = renderUtil.expandBound(this.layout);

	        return renderingBound;
	    },

	    /**
	     * Render event handle layer area.
	     * @param {HTMLElement} mouseEventDetectorContainer - container element for mouse event detector
	     * @param {number} tickCount - tick count
	     * @private
	     */
	    _renderMouseEventDetectorArea: function(mouseEventDetectorContainer, tickCount) {
	        var dimension = this.layout.dimension;
	        var renderingBound, tbcm;

	        this.dimension = dimension;
	        tbcm = new TickBaseCoordinateModel(this.layout, tickCount, this.chartType, this.isVertical, this.chartTypes);
	        this.tickBaseCoordinateModel = tbcm;
	        renderingBound = this._getRenderingBound();
	        renderUtil.renderDimension(mouseEventDetectorContainer, renderingBound.dimension);
	        renderUtil.renderPosition(mouseEventDetectorContainer, renderingBound.position);
	    },

	    /**
	     * Set data for rendering.
	     * @param {{
	     *      layout: {
	     *          dimension: {width: number, height: number},
	     *          position: {left: number, top: number}
	     *      }
	     * }} data - bounds data
	     * @private
	     */
	    _setDataForRendering: function(data) {
	        this.layout = data.layout;
	    },

	    /**
	     * Pick tick count.
	     * @param {{xAxis: object, yAxis: object}} axisDataMap - axis data map
	     * @returns {number}
	     * @private
	     */
	    _pickTickCount: function(axisDataMap) {
	        var tickCount;

	        if (this.isVertical) {
	            tickCount = axisDataMap.xAxis.eventTickCount || axisDataMap.xAxis.tickCount;
	        } else {
	            tickCount = axisDataMap.yAxis.tickCount;
	        }

	        return tickCount;
	    },

	    /**
	     * Render for mouseEventDetector component.
	     * @param {object} data - bounds data and tick count
	     * @returns {HTMLElement} container for mouse event detector
	     */
	    render: function(data) {
	        var container = data.paper;
	        var tickCount;
	        this.positionMap = data.positionMap;

	        dom.addClass(container, 'tui-chart-series-custom-event-area');

	        if (data.axisDataMap.xAxis) {
	            tickCount = this._pickTickCount(data.axisDataMap);
	        }

	        this._setDataForRendering(data);
	        this._renderMouseEventDetectorArea(container, tickCount);
	        this.attachEvent(container);
	        this.mouseEventDetectorContainer = container;

	        this.transparentChild = this._createTransparentChild();
	        dom.append(container, this.transparentChild);

	        return container;
	    },

	    /**
	     * Create a transparent element
	     * @param {string} height - value of css heigth property
	     * @returns {HTMLElement} transparent element
	     * @private
	     */
	    _createTransparentChild: function() {
	        var child = document.createElement('DIV');
	        var style = child.style;

	        style.backgroundColor = '#fff';
	        style.height = renderUtil.getStyle(this.mouseEventDetectorContainer).height;
	        renderUtil.setOpacity(child, 0);

	        return child;
	    },

	    /**
	     * Calculate layer position by client position.
	     * @param {number} clientX - clientX
	     * @param {number} [clientY] - clientY
	     * @param {boolean} [checkLimit] - whether check limit or not
	     * @returns {{x: number, y: ?number}}
	     * @private
	     */
	    _calculateLayerPosition: function(clientX, clientY, checkLimit) {
	        var bound = this.mouseEventDetectorContainer.getBoundingClientRect();
	        var seriesPosition = this.positionMap.series;
	        var expandSize = this.expandSize;
	        var layerPosition = {};
	        var maxLeft, minLeft;

	        checkLimit = snippet.isUndefined(checkLimit) ? true : checkLimit;

	        if (checkLimit) {
	            maxLeft = bound.right - expandSize;
	            minLeft = bound.left + expandSize;
	            clientX = Math.min(Math.max(clientX, minLeft), maxLeft);
	        }

	        layerPosition.x = clientX - bound.left + seriesPosition.left - chartConst.CHART_PADDING;

	        if (!snippet.isUndefined(clientY)) {
	            layerPosition.y = clientY - bound.top + seriesPosition.top - chartConst.CHART_PADDING;
	        }

	        return layerPosition;
	    },

	    /**
	     * Create BoundsBaseCoordinateModel from seriesItemBoundsData for mouse event detector.
	     * @param {{chartType: string, data: object}} seriesItemBoundsDatum - series item bounds datum
	     */
	    onReceiveSeriesData: function(seriesItemBoundsDatum) {
	        var seriesItemBoundsData = this.seriesItemBoundsData;
	        var seriesCount = this.seriesCount;

	        if (seriesItemBoundsData.length === seriesCount) {
	            seriesItemBoundsData = [];
	        }

	        seriesItemBoundsData.push(seriesItemBoundsDatum);

	        if (seriesItemBoundsData.length === seriesCount) {
	            this.boundsBaseCoordinateModel = new BoundsBaseCoordinateModel(seriesItemBoundsData);
	        }
	    },

	    /**
	     * Rerender mouse event detector component.
	     * @param {object} data - bounds data and tick count
	     */
	    rerender: function(data) {
	        var tickCount;

	        if (data.axisDataMap.xAxis) {
	            tickCount = this._pickTickCount(data.axisDataMap);
	        }

	        this.selectedData = null;
	        this._setDataForRendering(data);
	        this._renderMouseEventDetectorArea(this.mouseEventDetectorContainer, tickCount);

	        this.transparentChild.style.height = renderUtil.getStyle(this.mouseEventDetectorContainer).height;
	    },

	    /**
	     * Rerender, when resizing chart.
	     * @param {object} data - bounds data and tick count
	     */
	    resize: function(data) {
	        this.containerBound = null;
	        this.rerender(data);
	    },

	    /**
	     * Whether changed select data or not.
	     * @param {object} prev - previous data
	     * @param {object} cur - current data
	     * @returns {boolean}
	     * @private
	     */
	    _isChangedSelectData: function(prev, cur) {
	        return !prev || !cur || prev.chartType !== cur.chartType ||
	            prev.indexes.groupIndex !== cur.indexes.groupIndex || prev.indexes.index !== cur.indexes.index;
	    },

	    /**
	     * Find coordinate data from boundsCoordinateModel.
	     * @param {{x: number, y: number}} layerPosition - layer position
	     * @returns {object}
	     * @private
	     */
	    _findDataFromBoundsCoordinateModel: function(layerPosition) {
	        var layerX = layerPosition.x;
	        var layerY = layerPosition.y;
	        var groupIndex;

	        if (predicate.isTreemapChart(this.chartType)) {
	            groupIndex = 0;
	        } else {
	            groupIndex = this.tickBaseCoordinateModel.findIndex(this.isVertical ? layerX : layerY);
	        }

	        return this.boundsBaseCoordinateModel.findData(groupIndex, layerX, layerY);
	    },

	    /**
	     * Find data.
	     * @param {number} clientX - clientX
	     * @param {number} clientY - clientY
	     * @returns {object}
	     * @private
	     */
	    _findData: function(clientX, clientY) {
	        var layerPosition = this._calculateLayerPosition(clientX, clientY);

	        return this._findDataFromBoundsCoordinateModel(layerPosition);
	    },

	    /**
	     * Show tooltip
	     * @private
	     * @abstract
	     */
	    _showTooltip: function() {},

	    /**
	     * hide tooltip
	     * @private
	     * @abstract
	     */
	    _hideTooltip: function() {},

	    /**
	     * When mouse event happens,
	     * hide MouseEventDetector container so that detect event of series elements
	     * and send mouse position data to series component
	     * @param {string} eventType - mouse event detector type
	     * @param {MouseEvent} e - mouse event
	     * @private
	     */
	    _onMouseEvent: function(eventType, e) {
	        dom.addClass(this.mouseEventDetectorContainer, 'hide');
	        this.eventBus.fire(eventType + 'Series', {
	            left: e.clientX,
	            top: e.clientY
	        });
	        dom.removeClass(this.mouseEventDetectorContainer, 'hide');
	    },

	    /**
	     * Unselect selected data.
	     * @private
	     */
	    _unselectSelectedData: function() {
	        this.eventBus.fire('unselectSeries', this.selectedData);
	        this.selectedData = null;
	    },

	    /**
	     * Call 'selectSeries' event, when changed found position data.
	     * And call 'unselectSeries' event, when not changed found position data.
	     * @param {MouseEvent} e - mouse event
	     * @private
	     */
	    _onClick: function(e) {
	        var foundData = this._findData(e.clientX, e.clientY);

	        if (!this._isChangedSelectData(this.selectedData, foundData)) {
	            this._unselectSelectedData();
	        } else if (foundData) {
	            if (this.selectedData) {
	                this._unselectSelectedData();
	            }

	            this.eventBus.fire('selectSeries', foundData);
	            if (this.allowSelect) {
	                this.selectedData = foundData;
	            }
	        }
	    },

	    /**
	     * On mouse down
	     * @private
	     * @abstract
	     */
	    _onMousedown: function() {},

	    /**
	     * On mouse up
	     * @private
	     * @abstract
	     */
	    _onMouseup: function() {},

	    /**
	     * Store client position, when occur mouse move event.
	     * @param {MouseEvent} e - mouse event
	     * @abstract
	     * @private
	     */
	    _onMousemove: function() {},

	    /**
	     * Abstract mouseout handler
	     * @abstract
	     * @private
	     */
	    _onMouseout: function() {},

	    /**
	     * Attach mouse event.
	     * @param {HTMLElement} target - target element
	     */
	    attachEvent: function(target) {
	        eventListener.on(target, {
	            click: this._onClick,
	            mousedown: this._onMousedown,
	            mouseup: this._onMouseup,
	            mousemove: this._onMousemove,
	            mouseout: this._onMouseout
	        }, this);
	    },

	    /**
	     * find data by indexes
	     * @abstract
	     */
	    findDataByIndexes: function() {},

	    /**
	     * Set prevClientPosition by MouseEvent
	     * @param {?MouseEvent} event - mouse event
	     */
	    _setPrevClientPosition: function(event) {
	        if (!event) {
	            this.prevClientPosition = null;
	        } else {
	            this.prevClientPosition = {
	                x: event.clientX,
	                y: event.clientY
	            };
	        }
	    }
	});

	snippet.CustomEvents.mixin(MouseEventDetectorBase);

	module.exports = MouseEventDetectorBase;


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview TickBaseDataModel is tick base data model.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var predicate = __webpack_require__(11);
	var arrayUtil = __webpack_require__(10);
	var snippet = __webpack_require__(6);

	var TickBaseDataModel = snippet.defineClass(/** @lends TickBaseDataModel.prototype */ {
	    /**
	     * TickBaseDataModel is tick base data model.
	     * @param {{
	     *     dimension: {
	     *         width: number,
	     *         height: number
	     *     }, position: {
	     *         left: number,
	     *         top: number
	     *     }
	     * }} layout layout
	     * @param {number} tickCount tick count
	     * @param {string} chartType chart type
	     * @param {boolean} isVertical whether vertical or not
	     * @param {Array.<string>} [chartTypes] - chart types of combo chart
	     * @constructs TickBaseDataModel
	     * @private
	     */
	    init: function(layout, tickCount, chartType, isVertical, chartTypes) {
	        /**
	         * whether line type or not
	         * @type {boolean}
	         */
	        this.isLineType = predicate.isLineTypeChart(chartType, chartTypes);

	        this.data = this._makeData(layout, tickCount, isVertical);
	    },

	    /**
	     * Get each tick ranges
	     * @param {number} tickCount tick count
	     * @param {number} firstPosition first position value
	     * @param {number} tickInterval tick distance
	     * @returns {Array.<object>}
	     * @private
	     */
	    _getRanges: function(tickCount, firstPosition, tickInterval) {
	        var prev = firstPosition;
	        var halfInterval = tickInterval / 2;

	        return snippet.map(snippet.range(0, tickCount), function() {
	            var limit = {
	                min: prev - halfInterval,
	                max: prev + halfInterval
	            };

	            prev += tickInterval;

	            return limit;
	        });
	    },

	    /**
	     * Make tick base data about line type chart.
	     * @param {number} width width
	     * @param {number} tickCount tick count
	     * @param {number} firstPosition firstPosition of group
	     * @returns {Array} tick base data
	     * @private
	     */
	    _makeLineTypeData: function(width, tickCount, firstPosition) {
	        var tickInterval = (width + 1) / (tickCount - 1);
	        var ranges = this._getRanges(tickCount, (firstPosition || 0), tickInterval);

	        ranges[tickCount - 1].max -= 1;

	        return ranges;
	    },

	    /**
	     * Make tick base data about non line type chart.
	     * @param {number} size width or height
	     * @param {number} tickCount tick count
	     * @param {number} firstPosition firstPosition of group
	     * @returns {Array} tick base data
	     * @private
	     */
	    _makeNormalData: function(size, tickCount, firstPosition) {
	        var len = tickCount - 1;
	        var tickInterval = size / len;
	        var prev = (firstPosition || 0);

	        return snippet.map(snippet.range(0, len), function() {
	            var max = arrayUtil.min([size + prev, tickInterval + prev]);
	            var limit = {
	                min: prev,
	                max: max
	            };
	            prev = max;

	            return limit;
	        });
	    },

	    /**
	     * Make tick base data for mouse event detector.
	     * @param {{dimension: object, position: object}} layout layout
	     * @param {number} tickCount tick count
	     * @param {boolean} isVertical whether vertical or not
	     * @returns {Array.<object>} tick base data
	     * @private
	     */
	    _makeData: function(layout, tickCount, isVertical) {
	        var sizeType = isVertical ? 'width' : 'height';
	        var positionType = isVertical ? 'left' : 'top';
	        var data;

	        if (this.isLineType) {
	            data = this._makeLineTypeData(layout.dimension[sizeType], tickCount, layout.position[positionType]);
	        } else {
	            data = this._makeNormalData(layout.dimension[sizeType], tickCount, layout.position[positionType]);
	        }

	        return data;
	    },

	    /**
	     * Find index.
	     * @param {number} pointValue mouse position point value
	     * @returns {number} group index
	     */
	    findIndex: function(pointValue) {
	        var foundIndex = -1;

	        snippet.forEachArray(this.data, function(limit, index) {
	            if (limit.min < pointValue && limit.max >= pointValue) {
	                foundIndex = index;

	                return false;
	            }

	            return true;
	        });

	        return foundIndex;
	    },

	    /**
	     * Get last index.
	     * @returns {number}
	     */
	    getLastIndex: function() {
	        return this.data.length - 1;
	    },

	    /**
	     * Make range of tooltip position.
	     * @param {number} index index
	     * @param {number} positionValue positionValue
	     * @returns {{start: number, end: number}} range type value
	     * @private
	     */
	    makeRange: function(index, positionValue) {
	        var limit = this.data[index],
	            range, center;
	        if (this.isLineType) {
	            center = parseInt(limit.max - ((limit.max - limit.min) / 2), 10);
	            range = {
	                start: center,
	                end: center
	            };
	        } else {
	            range = {
	                start: limit.min - (positionValue || 0),
	                end: limit.max - (positionValue || 0)
	            };
	        }

	        return range;
	    }
	});

	module.exports = TickBaseDataModel;


/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview BoundsBaseCoordinateModel is data model for mouse event detector of bounds type.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	/**
	 * position
	 * @typedef {{left: number, top: number}} position
	 * @private
	 */

	/**
	 * bound
	 * @typedef {{
	 *      dimension: {width: number, height: number},
	 *      position: position
	 *}} bound
	 * @private
	 */

	/**
	 * group bound
	 *  @typedef {Array.<Array.<bound>>} groupBound
	 * @private
	 */

	/**
	 * group position
	 *  @typedef {Array.<Array.<position>>} groupPosition
	 * @private
	 */

	/**
	 * series info
	 * @typedef {{
	 *      chartType: {string},
	 *      data: {
	 *          groupBounds: ?groupBound,
	 *          groupValues: ?Array.<Array.<number>>,
	 *          groupPositions: ?groupPosition
	 *      }
	 *}} seriesInfo
	 * @private
	 */

	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var arrayUtil = __webpack_require__(10);
	var snippet = __webpack_require__(6);

	var BoundsBaseCoordinateModel = snippet.defineClass(/** @lends BoundsBaseCoordinateModel.prototype */ {
	    /**
	     * BoundsBaseCoordinateModel is data mode for mouse event detector of bounds type.
	     * @constructs BoundsBaseCoordinateModel
	     * @private
	     * @param {Array} seriesItemBoundsData - series item bounds data
	     */
	    init: function(seriesItemBoundsData) {
	        this.data = this._makeData(seriesItemBoundsData);
	    },

	    /**
	     * @param {string} chartType - chart type
	     * @param {object} indexes - index of SeriesDataModel
	     * @param {boolean} allowNegativeTooltip - whether allow negative tooltip or not
	     * @param {object} bound - coordinate data for rendering graph
	     * @returns {object} - `sendData`: tooltip contents, `bound`: for detecting hovered or not
	     * @private
	     */
	    _makeTooltipData: function(chartType, indexes, allowNegativeTooltip, bound) {
	        return {
	            sendData: {
	                chartType: chartType,
	                indexes: indexes,
	                allowNegativeTooltip: allowNegativeTooltip,
	                bound: bound
	            },
	            bound: {
	                left: bound.left,
	                top: bound.top,
	                right: bound.left + bound.width,
	                bottom: bound.top + bound.height
	            }
	        };
	    },

	    /**
	     * Make position data for rect type graph
	     * @param {groupBound} groupBounds group bounds
	     * @param {string} chartType chart type
	     * @returns {Array}
	     * @private
	     */
	    _makeRectTypePositionData: function(groupBounds, chartType) {
	        var allowNegativeTooltip = !predicate.isBoxTypeChart(chartType);

	        return snippet.map(groupBounds, function(bounds, groupIndex) {
	            return snippet.map(bounds, function(bound, index) {
	                if (!bound) {
	                    return null;
	                }

	                return this._makeTooltipData(
	                    chartType,
	                    {
	                        groupIndex: groupIndex,
	                        index: index
	                    },
	                    allowNegativeTooltip,
	                    bound.end || bound
	                );
	            }, this);
	        }, this);
	    },

	    /**
	     * Make position data for rect type graph
	     * @param {groupBound} groupBounds group bounds
	     * @param {string} chartType chart type
	     * @param {object} resultData resultData
	     * @private
	     */
	    _makeOutliersPositionDataForBoxplot: function(groupBounds, chartType, resultData) {
	        var allowNegativeTooltip = !predicate.isBoxTypeChart(chartType);
	        var _groupBounds = [].concat(groupBounds);

	        snippet.forEach(_groupBounds, function(bounds, groupIndex) {
	            snippet.forEach(bounds, function(bound, index) {
	                var outliers;

	                if (bound.outliers && bound.outliers.length) {
	                    outliers = snippet.map(bound.outliers, function(outlier, outlierIndex) {
	                        var outlierBound = {
	                            top: outlier.top - 3,
	                            left: outlier.left - 3,
	                            width: 6,
	                            height: 6
	                        };

	                        return this._makeTooltipData(
	                            chartType,
	                            {
	                                groupIndex: groupIndex,
	                                index: index,
	                                outlierIndex: outlierIndex
	                            },
	                            allowNegativeTooltip,
	                            outlierBound
	                        );
	                    }, this);

	                    resultData[groupIndex] = resultData[groupIndex].concat(outliers);
	                }
	            }, this);
	        }, this);
	    },

	    /**
	     * Make position data for dot type graph
	     * @param {groupPositions} groupPositions group positions
	     * @param {string} chartType chart type
	     * @returns {Array.<Array.<object>>}
	     * @private
	     */
	    _makeDotTypePositionData: function(groupPositions, chartType) {
	        if (!groupPositions) {
	            return [];
	        }

	        return snippet.map(arrayUtil.pivot(groupPositions), function(positions, groupIndex) {
	            return snippet.map(positions, function(position, index) {
	                if (!position) {
	                    return null;
	                }

	                return {
	                    sendData: {
	                        chartType: chartType,
	                        indexes: {
	                            groupIndex: groupIndex,
	                            index: index
	                        },
	                        bound: position
	                    },
	                    bound: {
	                        left: position.left - chartConst.DOT_RADIUS,
	                        top: position.top - chartConst.DOT_RADIUS,
	                        right: position.left + chartConst.DOT_RADIUS,
	                        bottom: position.top + chartConst.DOT_RADIUS
	                    }
	                };
	            });
	        });
	    },

	    /**
	     * Join data.
	     * @param {Array.<Array.<Array.<object>>>} dataGroupSet data group set
	     * @returns {Array.<Array.<object>>} joined data
	     * @private
	     */
	    _joinData: function(dataGroupSet) {
	        var results = [];
	        snippet.forEachArray(dataGroupSet, function(dataGroup) {
	            snippet.forEachArray(dataGroup, function(data, index) {
	                var additionalIndex;

	                if (!results[index]) {
	                    results[index] = data;
	                } else {
	                    additionalIndex = results[index].length;
	                    snippet.forEachArray(data, function(datum) {
	                        if (datum) {
	                            datum.sendData.indexes.legendIndex = datum.sendData.indexes.index + additionalIndex;
	                        }
	                    });
	                    results[index] = results[index].concat(data);
	                }
	            });
	        });

	        return results;
	    },

	    /**
	     * Make data for detecting mouse event.
	     * @param {Array} seriesItemBoundsData - series item bounds data
	     * @returns {Array.<Array.<object>>} coordinate data
	     * @private
	     */
	    _makeData: function(seriesItemBoundsData) {
	        var data = snippet.map(seriesItemBoundsData, function(info) {
	            var result;

	            if (predicate.isLineTypeChart(info.chartType)) {
	                result = this._makeDotTypePositionData(info.data.groupPositions, info.chartType);
	            } else {
	                result = this._makeRectTypePositionData(info.data.groupBounds, info.chartType);
	            }

	            if (predicate.isBoxplotChart(info.chartType)) {
	                this._makeOutliersPositionDataForBoxplot(info.data.groupBounds, info.chartType, result);
	            }

	            return result;
	        }, this);

	        return this._joinData(data);
	    },

	    /**
	     * Find candidates.
	     * @param {{bound: {left: number, top: number, right: number, bottom: number}}} data data
	     * @param {number} layerX layerX
	     * @param {number} layerY layerY
	     * @returns {Array.<{sendData: object}>} candidates
	     * @private
	     */
	    _findCandidates: function(data, layerX, layerY) {
	        return snippet.filter(data, function(datum) {
	            var bound = datum && datum.bound,
	                included = false,
	                includedX, includedY;

	            if (bound) {
	                if (bound.top === bound.bottom) {
	                    bound.top -= chartConst.SERIES_EXTRA_EVENT_AREA_FOR_ZERO;
	                    bound.bottom += chartConst.SERIES_EXTRA_EVENT_AREA_FOR_ZERO;
	                }
	                if (bound.left === bound.right) {
	                    bound.left -= chartConst.SERIES_EXTRA_EVENT_AREA_FOR_ZERO;
	                    bound.right += chartConst.SERIES_EXTRA_EVENT_AREA_FOR_ZERO;
	                }

	                includedX = bound.left <= layerX && bound.right >= layerX;
	                includedY = bound.top <= layerY && bound.bottom >= layerY;
	                included = includedX && includedY;
	            }

	            return included;
	        });
	    },

	    /**
	     * Find data.
	     * @param {number} groupIndex group index
	     * @param {number} layerX mouse position x
	     * @param {number} layerY mouse position y
	     * @returns {object} tooltip data
	     */
	    findData: function(groupIndex, layerX, layerY) {
	        var min = 10000;
	        var result = null;
	        var candidates;

	        if (groupIndex > -1 && this.data[groupIndex]) {
	            // extract data containing layerX, layerY
	            candidates = this._findCandidates(this.data[groupIndex], layerX, layerY);

	            // find nearest data to top position among extracted data
	            snippet.forEachArray(candidates, function(data) {
	                var diff = Math.abs(layerY - data.bound.top);

	                if (min > diff) {
	                    min = diff;
	                    result = data.sendData;
	                }
	            });
	        }

	        return result;
	    },

	    /**
	     * Find data by indexes.
	     * @param {{index: {number}, seriesIndex: {number}}} indexes - indexe of series item displaying a tooltip
	     * @param {number} [indexes.outlierIndex] - index of outlier of boxplot series, it only exists in boxplot chart
	     * @returns {object} tooltip data
	     */
	    findDataByIndexes: function(indexes) {
	        var foundData = this.data[indexes.index][indexes.seriesIndex].sendData;

	        if (snippet.isNumber(indexes.outlierIndex)) {
	            return this._findOutlierDataByIndexes(indexes);
	        }

	        return foundData;
	    },

	    /**
	     * find plot chart data by indexes
	     * @param {{
	     *  index: {number},
	     *  seriesIndex: {number},
	     *  outlierIndex: {number}
	     * }} indexes - indexe of series item displaying a tooltip
	     * @returns {object} - outlier tooltip data
	     */
	    _findOutlierDataByIndexes: function(indexes) {
	        var foundData = null;

	        snippet.forEachArray(this.data[indexes.index], function(datum) {
	            var datumIndexes = datum.sendData.indexes;
	            var found = (datumIndexes.index === indexes.seriesIndex) &&
	                (datumIndexes.outlierIndex === indexes.outlierIndex);

	            if (found) {
	                foundData = datum.sendData;
	            }

	            return !found;
	        });

	        return foundData;
	    }
	});

	module.exports = BoundsBaseCoordinateModel;


/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var predicate = __webpack_require__(11);
	var areaTypeEventDetectorFactory = __webpack_require__(74);
	var simpleEventDetectorFactory = __webpack_require__(77);
	var groupTypeEventDetectorFactory = __webpack_require__(78);
	var boundsTypeEventDetectorFactory = __webpack_require__(79);
	var mapChartEventDetectorFactory = __webpack_require__(69);

	/**
	 * Factory for MouseEventDetector
	 * @param {object} params parameter
	 * @returns {object}
	 * @ignore
	 */
	function mouseEventDetectorFactory(params) {
	    var chartType = params.chartOptions.chartType;
	    var seriesTypes = params.seriesTypes;
	    var zoomable = params.chartOptions.series.zoomable;
	    var seriesAllowSelect = params.chartOptions.series.allowSelect;
	    var factory;

	    if (params.chartOptions.tooltip.grouped) {
	        factory = groupTypeEventDetectorFactory;
	    } else if (predicate.isMapChart(chartType)) {
	        factory = mapChartEventDetectorFactory;
	    } else if (predicate.isBarTypeChart(chartType)
	        || predicate.isBoxplotChart(chartType)
	        || predicate.isHeatmapChart(chartType)
	        || predicate.isTreemapChart(chartType)
	        || predicate.isBulletChart(chartType)
	    ) {
	        factory = boundsTypeEventDetectorFactory;
	    } else if (predicate.isCoordinateTypeChart(chartType)
	        || predicate.isPieChart(chartType)
	        || predicate.isPieDonutComboChart(chartType, seriesTypes)
	    ) {
	        factory = simpleEventDetectorFactory;
	    } else {
	        factory = areaTypeEventDetectorFactory;
	    }

	    params.chartType = chartType;
	    // @todo replace chartType, chartTypes to seriesTypes, problem of the whole component
	    params.chartTypes = seriesTypes;
	    params.zoomable = zoomable;
	    params.allowSelect = seriesAllowSelect;

	    return factory(params);
	}

	mouseEventDetectorFactory.componentType = 'mouseEventDetector';

	module.exports = mouseEventDetectorFactory;


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview AreaTypeEventDetector is mouse event detector for line type chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var MouseEventDetectorBase = __webpack_require__(70);
	var zoomMixer = __webpack_require__(75);
	var AreaTypeDataModel = __webpack_require__(76);
	var snippet = __webpack_require__(6);

	var AREA_DETECT_DISTANCE_THRESHHOLD = 50;

	var AreaTypeEventDetector = snippet.defineClass(MouseEventDetectorBase, /** @lends AreaTypeEventDetector.prototype */ {
	    /**
	     * AreaTypeEventDetector is mouse event detector for line type chart.
	     * @param {object} params parameters
	     * @constructs AreaTypeEventDetector
	     * @private
	     * @extends MouseEventDetectorBase
	     */
	    init: function(params) {
	        MouseEventDetectorBase.call(this, params);

	        /**
	         * previous found data
	         * @type {null | object}
	         */
	        this.prevFoundData = null;

	        /**
	         * previous client position of mouse event (clientX, clientY)
	         * @type {null | object}
	         */
	        this.prevClientPosition = null;

	        /**
	         * whether zoomable or not
	         * @type {boolean}
	         */
	        this.zoomable = params.zoomable;

	        if (this.zoomable) {
	            snippet.extend(this, zoomMixer);
	            this._initForZoom(params.zoomable);
	        }
	    },

	    /**
	     * Animate for adding data.
	     */
	    animateForAddingData: function() {
	        var foundData, isMoving;

	        if (!this.prevClientPosition) {
	            return;
	        }

	        foundData = this._findData(this.prevClientPosition.x, this.prevClientPosition.y);

	        if (foundData) {
	            isMoving = this.prevFoundData && (this.prevFoundData.indexes.groupIndex === foundData.indexes.groupIndex);
	            this._showTooltip(foundData, isMoving);
	        }

	        this.prevFoundData = foundData;
	    },

	    /**
	     * Create areaTypeDataModel from seriesItemBoundsData for mouse event detector.
	     * @param {Array.<object>} seriesItemBoundsDatum - series item bounds datum
	     * @override
	     */
	    onReceiveSeriesData: function(seriesItemBoundsDatum) {
	        var seriesItemBoundsData = this.seriesItemBoundsData;
	        var seriesCount = this.seriesCount;

	        if (seriesItemBoundsData.length === seriesCount) {
	            seriesItemBoundsData = [];
	        }

	        seriesItemBoundsData.push(seriesItemBoundsDatum);

	        if (seriesItemBoundsData.length === seriesCount) {
	            this.dataModel = new AreaTypeDataModel(seriesItemBoundsData);
	        }

	        if (this.zoomable) {
	            this._showTooltipAfterZoom();
	        }
	    },

	    /**
	     * Find data by client position.
	     * @param {number} clientX - clientX
	     * @param {number} clientY - clientY
	     * @returns {object}
	     * @private
	     * @override
	     */
	    _findData: function(clientX, clientY) {
	        var layerPosition = this._calculateLayerPosition(clientX, clientY);
	        var selectLegendIndex = this.dataProcessor.selectLegendIndex;

	        return this.dataModel.findData(layerPosition, AREA_DETECT_DISTANCE_THRESHHOLD, selectLegendIndex);
	    },

	    /**
	     * Find data by client position for zoomable
	     * @param {number} clientX - clientX
	     * @param {number} clientY - clientY
	     * @returns {object}
	     * @private
	     */
	    _findDataForZoomable: function(clientX, clientY) {
	        var layerPosition = this._calculateLayerPosition(clientX, clientY);

	        return this.dataModel.findData(layerPosition);
	    },

	    /**
	     * Get first model data.
	     * @param {number} index - index
	     * @returns {object}
	     * @private
	     */
	    _getFirstData: function(index) {
	        return this.dataModel.getFirstData(index);
	    },

	    /**
	     * Get last model data.
	     * @param {number} index - index
	     * @returns {object}
	     * @private
	     */
	    _getLastData: function(index) {
	        return this.dataModel.getLastData(index);
	    },

	    /**
	     * Show tooltip.
	     * @param {object} foundData - model data
	     * @private
	     */
	    _showTooltip: function(foundData) {
	        this.eventBus.fire('showTooltip', foundData);
	        this.prevFoundData = foundData;
	    },

	    /**
	     * Hide tooltip.
	     * @param {{silent: {boolean}}} [options] - options for hiding tooltip
	     * @private
	     */
	    _hideTooltip: function(options) {
	        this.eventBus.fire('hideTooltip', this.prevFoundData, options);
	        this.prevFoundData = null;
	    },

	    /**
	     * On mousemove.
	     * @param {MouseEvent} e - mouse event
	     * @private
	     * @override
	     */
	    _onMousemove: function(e) {
	        var dragMoseupResult, foundData;

	        this._setPrevClientPosition(e);

	        foundData = this._findData(e.clientX, e.clientY);

	        if (this.zoomable) {
	            dragMoseupResult = this._isAfterDragMouseup();
	        }

	        if (dragMoseupResult || !this._isChangedSelectData(this.prevFoundData, foundData)) {
	            return;
	        }

	        if (foundData) {
	            this._showTooltip(foundData);
	        } else if (this.prevFoundData) {
	            this._hideTooltip();
	        }

	        this.prevFoundData = foundData;
	    },

	    /**
	     * On mouseout.
	     * @private
	     * @override
	     */
	    _onMouseout: function() {
	        if (this.prevFoundData) {
	            this._hideTooltip();
	        }

	        this.prevClientPosition = null;
	        this.prevFoundData = null;
	    },

	    /**
	     * find data by indexes
	     * @param {{index: {number}, seriesIndex: {number}}} indexes - indexe of series item displaying a tooltip
	     * @returns {object} - series item data
	     */
	    findDataByIndexes: function(indexes) {
	        return this.dataModel.findDataByIndexes(indexes);
	    },

	    /**
	     * Set prevClientPosition by MouseEvent
	     * @param {?MouseEvent} event - mouse event
	     */
	    _setPrevClientPosition: function(event) {
	        if (!event) {
	            this.prevClientPosition = null;
	        } else {
	            this.prevClientPosition = {
	                x: event.clientX,
	                y: event.clientY
	            };
	        }
	    }
	});

	function areaTypeEventDetectorFactory(params) {
	    return new AreaTypeEventDetector(params);
	}

	areaTypeEventDetectorFactory.componentType = 'mouseEventDetector';

	module.exports = areaTypeEventDetectorFactory;


/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview  Mixer for zoom event of area type mouse event detector.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var MouseEventDetectorBase = __webpack_require__(70);
	var chartConst = __webpack_require__(8);
	var dom = __webpack_require__(9);
	var renderUtil = __webpack_require__(7);
	var eventListener = __webpack_require__(55);
	var snippet = __webpack_require__(6);

	/**
	 * Mixer for zoom event of area type mouse event detector.
	 * @mixin
	 * @private */
	var zoomMixer = {
	    /**
	     * Initialize for zoom.
	     * @param {boolean} zoomable - whether zoomable or not
	     * @private
	     */
	    _initForZoom: function(zoomable) {
	        /**
	         * whether zoomable or not
	         * @type {boolean}
	         */
	        this.zoomable = zoomable;

	        /**
	         * drag start index.
	         * @type {null | object}
	         */
	        this.dragStartIndexes = null;

	        /**
	         * start client position(clientX, clientY) of mouse event.
	         * @type {null | {x: number, y: number}}
	         */
	        this.startClientPosition = null;

	        /**
	         * start layerX position
	         * @type {null | number}
	         */
	        this.startLayerX = null;

	        /**
	         * drag selection element
	         * @type {null | HTMLElement}
	         */
	        this.dragSelectionElement = null;

	        /**
	         * container bound
	         * @type {null | {left: number, right: number, top: number}}
	         */
	        this.containerBound = null;

	        /**
	         * whether show tooltip after zoom or not.
	         * @type {boolean}
	         */
	        this.isShowTooltipAfterZoom = false;

	        /**
	         * whether after mouseup or not.
	         * @type {boolean}
	         */
	        this.afterMouseup = false;

	        /**
	         * previouse distance of range
	         * @type {null | number}
	         */
	        this.prevDistanceOfRange = null;

	        /**
	         * whether reverse move or not.
	         * @type {null | number}
	         */
	        this.reverseMove = null;

	        /**
	         * reset zoom button element.
	         * @type {null | HTMLElement}
	         */
	        this.resetZoomBtn = null;
	    },

	    /**
	     * Show tooltip after zoom.
	     * @private
	     */
	    _showTooltipAfterZoom: function() {
	        var isShowTooltipAfterZoom = this.isShowTooltipAfterZoom;
	        var lastDataBeforeZoom;

	        this.isShowTooltipAfterZoom = false;

	        if (!isShowTooltipAfterZoom || !this.dragStartIndexes) {
	            return;
	        }

	        if (this.reverseMove) {
	            lastDataBeforeZoom = this._getFirstData(this.dragStartIndexes.index);
	        } else {
	            lastDataBeforeZoom = this._getLastData(this.dragEndIndexes.index);
	        }

	        if (lastDataBeforeZoom) {
	            this._showTooltip(lastDataBeforeZoom);
	        }
	    },

	    /**
	     * Update dimension for drag selection element.
	     * @param {HTMLElement} selectionElement - drag selection element
	     * @private
	     */
	    _updateDimensionForDragSelection: function(selectionElement) {
	        renderUtil.renderDimension(selectionElement, {
	            height: this.layout.dimension.height
	        });
	    },

	    /**
	     * Render drag selection.
	     * @returns {HTMLElement}
	     * @private
	     */
	    _renderDragSelection: function() {
	        var selectionElement = dom.create('DIV', 'tui-chart-drag-selection');

	        this._updateDimensionForDragSelection(selectionElement);

	        return selectionElement;
	    },

	    /**
	     * Render.
	     * @param {object} data - data for rendering
	     * @returns {HTMLElement}
	     * @override
	     */
	    render: function(data) {
	        var container = MouseEventDetectorBase.prototype.render.call(this, data);
	        var selectionElement = this._renderDragSelection();

	        dom.append(container, selectionElement);
	        this.dragSelectionElement = selectionElement;

	        return container;
	    },

	    /**
	     * Resize.
	     * @param {{tickCount: number}} data - data for resizing
	     * @override
	     */
	    resize: function(data) {
	        this.containerBound = null;
	        MouseEventDetectorBase.prototype.resize.call(this, data);
	        this._updateDimensionForDragSelection(this.dragSelectionElement);
	    },

	    /**
	     * On click
	     * @private
	     * @override
	     */
	    _onClick: function() {},

	    /**
	     * Whether after drag mouseup or not.
	     * @returns {boolean}
	     * @private
	     */
	    _isAfterDragMouseup: function() {
	        var afterMouseup = this.afterMouseup;

	        if (afterMouseup) {
	            this.afterMouseup = false;
	        }

	        return afterMouseup;
	    },

	    /**
	     * Bind drag event for zoom.
	     * @param {HTMLElement} target - target element
	     * @private
	     */
	    _bindDragEvent: function(target) {
	        if (target.setCapture) {
	            target.setCapture();
	        }

	        eventListener.on(document, 'mousemove', this._onDrag, this);
	        eventListener.off(this.mouseEventDetectorContainer, 'mouseup', this._onMouseup, this);
	        eventListener.on(document, 'mouseup', this._onMouseupAfterDrag, this);
	    },

	    /**
	     * Unbind drag event for zoom.
	     * @private
	     */
	    _unbindDragEvent: function() {
	        if (this.downTarget && this.downTarget.releaseCapture) {
	            this.downTarget.releaseCapture();
	        }

	        eventListener.off(document, 'mousemove', this._onDrag, this);
	        eventListener.off(document, 'mouseup', this._onMouseupAfterDrag, this);
	        eventListener.on(this.mouseEventDetectorContainer, 'mouseup', this._onMouseup, this);
	    },

	    /**
	     * On mouse down.
	     * @param {MouseEvent} e - mouse event
	     * @private
	     * @override
	     */
	    _onMousedown: function(e) {
	        var target;

	        if (!this.zoomable) {
	            return;
	        }

	        target = e.target || e.srcElement;

	        this.startClientPosition = {
	            x: e.clientX,
	            y: e.clientY
	        };
	        this.startLayerX = this._calculateLayerPosition(e.clientX).x;
	        this.downTarget = target;

	        this._bindDragEvent(target);
	    },

	    /**
	     * Show drag selection.
	     * @param {number} clientX - clientX
	     * @private
	     */
	    _showDragSelection: function(clientX) {
	        var layerX = this._calculateLayerPosition(clientX).x;
	        var left = Math.min(layerX, this.startLayerX) - this.layout.position.left;
	        var width = Math.abs(layerX - this.startLayerX);
	        var element = this.dragSelectionElement;

	        element.style.left = left + 'px';
	        element.style.width = width + 'px';

	        dom.addClass(element, 'show');
	    },

	    /**
	     * Hide drag selection.
	     * @private
	     */
	    _hideDragSelection: function() {
	        dom.removeClass(this.dragSelectionElement, 'show');
	    },

	    /**
	     * On mouse drag.
	     * @param {MouseEvent} e - mouse event
	     * @private
	     */
	    _onDrag: function(e) {
	        var clientPos = this.startClientPosition;
	        var target = e.target || e.srcElement;
	        var dataForZoomable;

	        if (clientPos) {
	            dataForZoomable = this._findDataForZoomable(clientPos.x, clientPos.y);

	            if (!dom.hasClass(target, chartConst.CLASS_NAME_RESET_ZOOM_BTN)) {
	                if (snippet.isNull(this.dragStartIndexes)) {
	                    this.dragStartIndexes = dataForZoomable ? dataForZoomable.indexes : {};
	                } else {
	                    this._showDragSelection(e.clientX);
	                }
	            }
	        }
	    },

	    /**
	     * Adjust index range for ensure three indexes.
	     * @param {number} startIndex - start index
	     * @param {number} endIndex - end index
	     * @returns {Array.<number>}
	     * @private
	     */
	    _adjustIndexRange: function(startIndex, endIndex) {
	        var indexRange = [startIndex, endIndex].sort(function(a, b) {
	            return a - b;
	        });
	        var distanceOfRange = indexRange[1] - indexRange[0];

	        if (distanceOfRange === 0) {
	            if (indexRange[0] === 0) {
	                indexRange[1] += 2;
	            } else {
	                indexRange[0] -= 1;
	                indexRange[1] += 1;
	            }
	        } else if (distanceOfRange === 1) {
	            if (indexRange[0] === 0) {
	                indexRange[1] += 1;
	            } else {
	                indexRange[0] -= 1;
	            }
	        }

	        return indexRange;
	    },

	    /**
	     * Fire zoom mouse event detector.
	     * @param {number} startIndex - start index
	     * @param {number} endIndex - end index
	     * @private
	     */
	    _fireZoom: function(startIndex, endIndex) {
	        var reverseMove = startIndex > endIndex;
	        var indexRange = this._adjustIndexRange(startIndex, endIndex);
	        var distanceOfRange = indexRange[1] - indexRange[0];

	        if (this.prevDistanceOfRange === distanceOfRange) {
	            return;
	        }

	        this.prevDistanceOfRange = distanceOfRange;
	        this.reverseMove = reverseMove;
	        this.eventBus.fire('zoom', indexRange);
	    },

	    /**
	     * Set flag about whether show tooltip after zoom or not.
	     * @param {number} clientX - clientX of mouse event
	     * @param {number} clientY - clientY of mouse event
	     * @private
	     */
	    _setIsShowTooltipAfterZoomFlag: function(clientX, clientY) {
	        var layerX = this._calculateLayerPosition(clientX, clientY, false).x;
	        var limitLayerX = this._calculateLayerPosition(clientX, clientY).x;

	        this.isShowTooltipAfterZoom = (layerX === limitLayerX);
	    },

	    /**
	     * On mouseup after drag event.
	     * @param {MouseEvent} e - mouse event
	     * @private
	     */
	    _onMouseupAfterDrag: function(e) {
	        // @TODO: define zoomable policy, when there is no data
	        // To find dragEndIndex for zoom, data should not be null.
	        // To avoid zooming avoid zooming with no data, check dragStartIndexes first
	        // Becault chart without data returns invalid dragStartIndexes
	        var foundedDragEndData = this._findDataForZoomable(e.clientX, e.clientY);
	        var target;

	        this._unbindDragEvent();

	        if (snippet.isNull(this.dragStartIndexes)) {
	            target = e.target || e.srcElement;
	            if (dom.hasClass(target, chartConst.CLASS_NAME_RESET_ZOOM_BTN)) {
	                this._hideTooltip();
	                this.prevDistanceOfRange = null;
	                this.eventBus.fire('resetZoom');
	            } else {
	                MouseEventDetectorBase.prototype._onClick.call(this, e);
	            }
	        } else if (this.dragStartIndexes && foundedDragEndData) {
	            this.dragEndIndexes = foundedDragEndData.indexes;
	            this._setIsShowTooltipAfterZoomFlag(e.clientX, e.clientY);
	            this._hideDragSelection();
	            this._fireZoom(this.dragStartIndexes.groupIndex, this.dragEndIndexes.groupIndex);
	        } else {
	            this._setIsShowTooltipAfterZoomFlag(e.clientX, e.clientY);
	            this._hideDragSelection();
	        }

	        this.startClientPosition = null;
	        this.dragStartIndexes = null;
	        this.startLayerX = null;
	        this.afterMouseup = true;
	    },

	    /**
	     * Render reset zoom button element.
	     * @returns {HTMLElement}
	     * @private
	     */
	    _renderResetZoomBtn: function() {
	        var resetBtn = dom.create('DIV', chartConst.CLASS_NAME_RESET_ZOOM_BTN);
	        resetBtn.innerHTML = 'Reset Zoom';

	        return resetBtn;
	    },

	    /**
	     * Zoom.
	     * @param {object} data - data for rendering
	     */
	    zoom: function(data) {
	        this.prevFoundData = null;
	        this.rerender(data);
	        this._updateDimensionForDragSelection(this.dragSelectionElement);

	        if (!this.resetZoomBtn) {
	            this.resetZoomBtn = this._renderResetZoomBtn();
	            dom.append(this.mouseEventDetectorContainer, this.resetZoomBtn);
	        } else if (data.isResetZoom) {
	            this.mouseEventDetectorContainer.removeChild(this.resetZoomBtn);
	            this.resetZoomBtn = null;
	        }
	    }
	};

	module.exports = zoomMixer;


/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview AreaTypeDataModel is data model for mouse event detector of area type.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var predicate = __webpack_require__(11);
	var arrayUtil = __webpack_require__(10);
	var snippet = __webpack_require__(6);

	var concat = Array.prototype.concat;

	var AreaTypeDataModel = snippet.defineClass(/** @lends AreaTypeDataModel.prototype */ {
	    /**
	     * AreaTypeDataModel is data mode for mouse event detector of area type.
	     * @constructs AreaTypeDataModel
	     * @private
	     * @param {Array} seriesItemBoundsData - series item bounds data
	     */
	    init: function(seriesItemBoundsData) {
	        this.data = this._makeData(seriesItemBoundsData);

	        /**
	         * last group index
	         * @type {number}
	         */
	        this.lastGroupIndex = 0;
	    },

	    /**
	     * Make data for detecting mouse event.
	     * @param {Array} seriesItemBoundsData - series item bounds data
	     * @returns {Array}
	     * @private
	     */
	    _makeData: function(seriesItemBoundsData) {
	        var lastGroupIndex = 0;
	        var seriesItemBoundsLength = seriesItemBoundsData.length;
	        var data = snippet.map(seriesItemBoundsData, function(seriesDatum, seriesIndex) {
	            var groupPositions = seriesDatum.data.groupPositions || seriesDatum.data.groupBounds;
	            var chartType = seriesDatum.chartType;

	            if (predicate.isLineTypeChart(chartType) || predicate.isRadialChart(chartType)) {
	                groupPositions = arrayUtil.pivot(groupPositions);
	            }

	            lastGroupIndex = Math.max(groupPositions.length - 1, lastGroupIndex);

	            return snippet.map(groupPositions, function(positions, groupIndex) {
	                return snippet.map(positions, function(position, index) {
	                    var datum = null;

	                    if (position) {
	                        datum = {
	                            chartType: chartType,
	                            indexes: {
	                                groupIndex: groupIndex,
	                                index: index
	                            },
	                            bound: position
	                        };
	                    }

	                    // Add legendIndex to datum on making multi series chart data, especially for LineScatterComboChart.
	                    if (seriesItemBoundsLength > 1) {
	                        datum.indexes.legendIndex = seriesIndex;
	                    }

	                    return datum;
	                });
	            });
	        });

	        data = concat.apply([], data);
	        this.lastGroupIndex = lastGroupIndex;

	        return snippet.filter(concat.apply([], data), function(datum) {
	            return !!datum;
	        });
	    },

	    /**
	     * Find Data by layer position.
	     * @param {{x: number, y: number}} layerPosition - layer position
	     * @param {number} [distanceLimit] distance limitation to find data
	     * @param {?number} selectLegendIndex select legend sereis index
	     * @returns {object}
	     */
	    findData: function(layerPosition, distanceLimit, selectLegendIndex) {
	        var min = 100000;
	        var findFoundMap = {};
	        var findFound;

	        distanceLimit = distanceLimit || Number.MAX_VALUE;
	        snippet.forEach(this.data, function(datum) {
	            var xDiff = layerPosition.x - datum.bound.left;
	            var yDiff = layerPosition.y - datum.bound.top;
	            var distance = Math.sqrt(Math.pow(xDiff, 2) + Math.pow(yDiff, 2));

	            if (distance < distanceLimit && distance <= min) {
	                min = distance;
	                findFound = datum;
	                findFoundMap[datum.indexes.index] = datum;
	            }
	        });

	        if (!snippet.isNull(selectLegendIndex) && findFoundMap[selectLegendIndex]) {
	            findFound = findFoundMap[selectLegendIndex];
	        }

	        return findFound;
	    },

	    /**
	     * Find data by indexes.
	     * @param {{index: {number}, seriesIndex: {number}}} indexes - indexe of series item displaying a tooltip
	     * @returns {object}
	     */
	    findDataByIndexes: function(indexes) {
	        var foundData = null;

	        snippet.forEachArray(this.data, function(datum) {
	            if (datum.indexes.groupIndex === indexes.index && datum.indexes.index === indexes.seriesIndex) {
	                foundData = datum;
	            }

	            return !foundData;
	        });

	        return foundData;
	    },

	    /**
	     * Get first data.
	     * @param {number} index - index
	     * @returns {object}
	     */
	    getFirstData: function(index) {
	        var indexes = {
	            index: 0,
	            seriesIndex: index
	        };

	        return this.findDataByIndexes(indexes);
	    },

	    /**
	     * Get last data.
	     * @param {number} index - index
	     * @returns {object}
	     */
	    getLastData: function(index) {
	        var indexes = {
	            index: this.lastGroupIndex,
	            seriesIndex: index
	        };

	        return this.findDataByIndexes(indexes);
	    }
	});

	module.exports = AreaTypeDataModel;


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview SimpleEventDetector is event handle layer for simply sending clientX, clientY.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var MouseEventDetectorBase = __webpack_require__(70);
	var renderUtil = __webpack_require__(7);
	var snippet = __webpack_require__(6);

	var SimpleEventDetector = snippet.defineClass(MouseEventDetectorBase, /** @lends SimpleEventDetector.prototype */ {
	    /**
	     * SimpleEventDetector is event handle layer for simply sending clientX, clientY.
	     * @constructs SimpleEventDetector
	     * @private
	     * @param {object} params parameters
	     *      @param {string} params.chartType - chart type
	     * @extends MouseEventDetectorBase
	     */
	    init: function(params) {
	        /**
	         * chart type
	         * @type {string}
	         */
	        this.chartType = params.chartType;

	        this.drawingType = chartConst.COMPONENT_TYPE_DOM;

	        /**
	         * event bus for transmitting message
	         * @type {object}
	         */
	        this.eventBus = params.eventBus;
	    },

	    /**
	     * Render mouse event detector area
	     * @param {HTMLElement} mouseEventDetectorContainer - container element for mouse event detector
	     * @private
	     */
	    _renderMouseEventDetectorArea: function(mouseEventDetectorContainer) {
	        renderUtil.renderDimension(mouseEventDetectorContainer, this.layout.dimension);
	        renderUtil.renderPosition(mouseEventDetectorContainer, this.layout.position);
	    },

	    /**
	     * Initialize data of mouse event detector
	     * @override
	     */
	    onReceiveSeriesData: function() {},

	    /**
	     * On click.
	     * @param {MouseEvent} e - mouse event
	     * @private
	     * @override
	     */
	    _onClick: function(e) {
	        this._onMouseEvent('click', e);
	    },

	    /**
	     * On mouse move.
	     * @param {MouseEvent} e - mouse event
	     * @private
	     * @override
	     */
	    _onMousemove: function(e) {
	        this._onMouseEvent('move', e);
	    },

	    /**
	     * On mouse out.
	     * @param {MouseEvent} e - mouse event
	     * @private
	     * @override
	     */
	    _onMouseout: function(e) {
	        this._onMouseEvent('move', e);
	    }
	});

	function simpleTypeEventDetectorFactory(params) {
	    return new SimpleEventDetector(params);
	}

	simpleTypeEventDetectorFactory.componentType = 'mouseEventDetector';

	module.exports = simpleTypeEventDetectorFactory;


/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview GroupTypeEventDetector is mouse event detector for grouped tooltip.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var EventDetectorBase = __webpack_require__(70);
	var zoomMixer = __webpack_require__(75);
	var snippet = __webpack_require__(6);

	var GroupTypeEventDetector = snippet.defineClass(EventDetectorBase, /** @lends GroupTypeEventDetector.prototype */ {
	    /**
	     * GroupTypeEventDetector is mouse event detector for grouped tooltip.
	     * @param {object} params parameters
	     * @constructs GroupTypeEventDetector
	     * @private
	     * @extends EventDetectorBase
	     */
	    init: function(params) {
	        EventDetectorBase.call(this, params);

	        /**
	         * previous index of group data
	         * @type {null}
	         */
	        this.prevIndex = null;

	        /**
	         * whether zoomable or not
	         * @type {boolean}
	         */
	        this.zoomable = params.zoomable;

	        /**
	         * type of size
	         * @type {string}
	         */
	        this.sizeType = this.isVertical ? 'height' : 'width';

	        if (this.zoomable) {
	            snippet.extend(this, zoomMixer);
	            this._initForZoom(params.zoomable);
	        }
	    },

	    /**
	     * Initialize data of mouse event detector
	     * @param {Array.<object>} seriesInfos series infos
	     * @override
	     */
	    initMouseEventDetectorData: function(seriesInfos) {
	        EventDetectorBase.prototype.initMouseEventDetectorData.call(this, seriesInfos);

	        if (this.zoomable) {
	            this._showTooltipAfterZoom();
	        }
	    },

	    /**
	     * Find data by client position.
	     * @param {number} clientX - clientX
	     * @param {number} clientY - clientY
	     * @returns {object}
	     * @private
	     */
	    _findGroupData: function(clientX, clientY) {
	        var layerPosition = this._calculateLayerPosition(clientX, clientY, true);
	        var pointValue;

	        if (this.isVertical) {
	            pointValue = layerPosition.x;
	        } else {
	            pointValue = layerPosition.y;
	        }

	        return {
	            indexes: {
	                groupIndex: this.tickBaseCoordinateModel.findIndex(pointValue)
	            }
	        };
	    },

	    /**
	     * Find data by client position for zoomable
	     * @param {number} clientX - clientX
	     * @param {number} clientY - clientY
	     * @returns {object}
	     * @private
	     */
	    _findDataForZoomable: function(clientX, clientY) {
	        return this._findGroupData(clientX, clientY);
	    },

	    /**
	     * Get first data.
	     * @returns {{indexes: {groupIndex: number}}} - data
	     * @private
	     */
	    _getFirstData: function() {
	        return {
	            indexes: {
	                groupIndex: 0
	            }
	        };
	    },

	    /**
	     * Get last data.
	     * @returns {{indexes: {groupIndex: number}}} - data
	     * @private
	     */
	    _getLastData: function() {
	        return {
	            indexes: {
	                groupIndex: this.tickBaseCoordinateModel.getLastIndex()
	            }
	        };
	    },

	    /**
	     * Whether outer position or not.
	     * @param {number} layerX layerX
	     * @param {number} layerY layerY
	     * @returns {boolean} result boolean
	     * @private
	     */
	    _isOuterPosition: function(layerX, layerY) {
	        var dimension = this.dimension;
	        var width = dimension.width;
	        var height = dimension.height;
	        var position = this.layout.position;
	        var top = position.top;
	        var left = position.left;

	        return layerX < left || layerX > left + width ||
	            layerY < top || layerY > top + height;
	    },

	    /**
	     * Show tooltip.
	     * @param {{indexes: {groupIndex: number}, silent: boolean}} foundData - data
	     * @param {boolean} [isMoving] - whether moving or not
	     * @private
	     */
	    _showTooltip: function(foundData, isMoving) {
	        var index = foundData.indexes.groupIndex;
	        var positionValue = (this.isVertical ? this.layout.position.left : this.layout.position.top)
	            - chartConst.CHART_PADDING;

	        /**
	         * Can be called with showTooltip function
	         * At this time, the index may be larger than the data size.
	         */
	        if (this.tickBaseCoordinateModel.data.length > index) {
	            this.eventBus.fire('showTooltip', {
	                index: index,
	                range: this.tickBaseCoordinateModel.makeRange(index, positionValue),
	                size: this.dimension[this.sizeType],
	                isVertical: this.isVertical,
	                isMoving: isMoving,
	                silent: foundData.silent
	            });
	            this.prevIndex = index;
	        }
	    },

	    /**
	     * Hide tooltip
	     * @param {{silent: {boolean}}} [options] - options for hiding tooltip
	     * @private
	     */
	    _hideTooltip: function(options) {
	        this.eventBus.fire('hideTooltip', this.prevIndex, options);
	        this.prevIndex = null;
	    },

	    /**
	     * If found position data by client position, show tooltip.
	     * And if not found, call onMouseout function.
	     * @param {MouseEvent} e mouse event object
	     * @private
	     * @override
	     */
	    _onMousemove: function(e) {
	        var foundData, index;

	        if (this.zoomable && this._isAfterDragMouseup()) {
	            return;
	        }

	        foundData = this._findGroupData(e.clientX, e.clientY);

	        index = foundData.indexes.groupIndex;

	        if (index === -1) {
	            this._onMouseout(e);
	        } else if (this.prevIndex !== index) {
	            this._showTooltip(foundData);
	        }
	    },

	    /**
	     * If mouse position gets out mouse event detector area, hide tooltip.
	     * @override
	     */
	    _onMouseout: function(e) {
	        var layerPosition;

	        layerPosition = this._calculateLayerPosition(e.clientX, e.clientY, false);

	        if (this._isOuterPosition(layerPosition.x, layerPosition.y) && !snippet.isNull(this.prevIndex)) {
	            this._hideTooltip();
	        }
	    }
	});

	function groupTypeEventDetectorFactory(params) {
	    return new GroupTypeEventDetector(params);
	}

	groupTypeEventDetectorFactory.componentType = 'mouseEventDetector';

	module.exports = groupTypeEventDetectorFactory;


/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview BoundsTypeEventDetector is mouse event detector for bounds type charts
	 *                                                                              like bar, column, heatmap, treemap.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var EventDetectorBase = __webpack_require__(70);
	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var dom = __webpack_require__(9);
	var snippet = __webpack_require__(6);

	var BoundsTypeEventDetector = snippet.defineClass(EventDetectorBase, /** @lends BoundsTypeEventDetector.prototype */ {
	    /**
	     * BoundsTypeEventDetector is mouse event detector for bounds type charts like bar, column, heatmap, treemap.
	     * @constructs BoundsTypeEventDetector
	     * @private
	     * @extends EventDetectorBase
	     */
	    init: function() {
	        EventDetectorBase.apply(this, arguments);

	        /**
	         * previous found data
	         * @type {null | object}
	         */
	        this.prevFoundData = null;

	        /**
	         * history array for treemap chart.
	         * @type {array}
	         */
	        this.zoomHistory = [-1];

	        /**
	         * button for zoom history back
	         * @type {null | HTMLElement}
	         */
	        this.historyBackBtn = null;
	    },

	    /**
	     * Attach to event bus.
	     * @private
	     * @override
	     */
	    _attachToEventBus: function() {
	        EventDetectorBase.prototype._attachToEventBus.call(this);

	        this.eventBus.on('afterZoom', this.onAfterZoom, this);
	    },

	    /**
	     * Show tooltip.
	     * @param {object} foundData - model data
	     * @private
	     */
	    _showTooltip: function(foundData) {
	        this.eventBus.fire('showTooltip', foundData);
	        this.prevFoundData = foundData;
	    },

	    /**
	     * Hide tooltip.
	     * @param {{silent: {boolean}}} [options] - options for hiding a tooltip
	     * @private
	     */
	    _hideTooltip: function(options) {
	        this.eventBus.fire('hideTooltip', this.prevFoundData, options);
	        this.prevFoundData = null;
	        this.styleCursor(false);
	    },

	    /**
	     * Style css cursor.
	     * @param {boolean} hasChild - whether has child or not
	     */
	    styleCursor: function(hasChild) {
	        var container = this.mouseEventDetectorContainer;
	        if (hasChild) {
	            container.style.cursor = 'pointer';
	        } else {
	            container.style.cursor = 'default';
	        }
	    },

	    /**
	     * On mousemove.
	     * @param {MouseEvent} e - mouse event
	     * @private
	     * @override
	     */
	    _onMousemove: function(e) {
	        var clientX = e.clientX;
	        var clientY = e.clientY;
	        var layerPosition = this._calculateLayerPosition(clientX, clientY);
	        var foundData = this._findDataFromBoundsCoordinateModel(layerPosition);
	        var seriesItem;

	        if (!this._isChangedSelectData(this.prevFoundData, foundData)) {
	            return;
	        }

	        if (this.prevFoundData) {
	            this._hideTooltip();
	        }

	        this.prevFoundData = foundData;

	        if (!foundData) {
	            return;
	        }

	        if (predicate.isTreemapChart(this.chartType)) {
	            seriesItem = this._getSeriesItemByIndexes(foundData.indexes);
	            this.styleCursor(seriesItem.hasChild);
	        } else if (predicate.isBulletChart(this.chartType)) {
	            foundData.mousePosition = {
	                left: clientX,
	                top: clientY
	            };
	        }
	        this._showTooltip(foundData);
	    },

	    /**
	     * Zoom history back.
	     * @private
	     */
	    _zoomHistoryBack: function() {
	        var index = this.zoomHistory[this.zoomHistory.length - 2];

	        this.zoomHistory.pop();
	        this.eventBus.fire('zoom', index);

	        if (this.zoomHistory.length === 1) {
	            this.mouseEventDetectorContainer.removeChild(this.historyBackBtn);
	            this.historyBackBtn = null;
	        }
	    },

	    /**
	     * Get seriesItem by indexes
	     * @param {{groupIndex: number, index: number}} indexes - indexes
	     * @returns {SeriesItem}
	     * @private
	     */
	    _getSeriesItemByIndexes: function(indexes) {
	        var seriesDataModel = this.dataProcessor.getSeriesDataModel(chartConst.CHART_TYPE_TREEMAP);

	        return seriesDataModel.getSeriesItem(indexes.groupIndex, indexes.index, true);
	    },

	    /**
	     * On mousemove.
	     * @param {MouseEvent} e - mouse event
	     * @private
	     * @override
	     */
	    _onClick: function(e) {
	        var target = e.target || e.srcElement;
	        var layerPosition, foundData, seriesItem;

	        EventDetectorBase.prototype._onClick.call(this, e);

	        if (!predicate.isTreemapChart(this.chartType)) {
	            return;
	        }

	        if (dom.hasClass(target, chartConst.CLASS_NAME_RESET_ZOOM_BTN)) {
	            this._hideTooltip();
	            this._zoomHistoryBack();

	            return;
	        }

	        layerPosition = this._calculateLayerPosition(e.clientX, e.clientY);
	        foundData = this._findDataFromBoundsCoordinateModel(layerPosition);

	        if (foundData) {
	            seriesItem = this._getSeriesItemByIndexes(foundData.indexes);

	            if (!seriesItem.hasChild) {
	                return;
	            }

	            this._hideTooltip();
	            this.eventBus.fire('zoom', foundData.indexes.index);
	        }
	    },

	    /**
	     * On mouseout.
	     * @override
	     */
	    _onMouseout: function(e) {
	        // do not cache getBoundingClientRect() - if not, it will cause error when chart location changed
	        var bound = this.mouseEventDetectorContainer.getBoundingClientRect();
	        var clientX = e.clientX;
	        var clientY = e.clientY;

	        if ((bound.left <= clientX) && (bound.top <= clientY) &&
	            (bound.right >= clientX) && (bound.bottom >= clientY)) {
	            return;
	        }

	        if (this.prevFoundData) {
	            this._hideTooltip();
	        }

	        this.prevFoundData = null;
	    },

	    /**
	     * On after zoom.
	     * @param {number} index - index of target seriesItem
	     */
	    onAfterZoom: function(index) {
	        if (!this.historyBackBtn) {
	            this.historyBackBtn = dom.create('DIV', chartConst.CLASS_NAME_RESET_ZOOM_BTN);
	            this.historyBackBtn.innerHTML = '< Back';
	            dom.append(this.mouseEventDetectorContainer, this.historyBackBtn);
	        }

	        if (this.zoomHistory[this.zoomHistory.length - 1] !== index) {
	            this.zoomHistory.push(index);
	        }
	    },

	    /**
	     * Find data by indexes.
	     * @param {{index: {number}, seriesIndex: {number}}} indexes - indexe of series item displaying a tooltip
	     * @param {number} [indexes.outlierIndex] - index of outlier of boxplot series, it only exists in boxplot chart
	     * @returns {object} - series item data
	     */
	    findDataByIndexes: function(indexes) {
	        return this.boundsBaseCoordinateModel.findDataByIndexes(indexes);
	    }
	});

	function boundsTypeEventDetectorFactory(params) {
	    return new BoundsTypeEventDetector(params);
	}

	boundsTypeEventDetectorFactory.componentType = 'mouseEventDetector';

	module.exports = boundsTypeEventDetectorFactory;


/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Bar chart series component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var BarTypeSeriesBase = __webpack_require__(82);
	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var snippet = __webpack_require__(6);

	var BarChartSeries = snippet.defineClass(Series, /** @lends BarChartSeries.prototype */ {
	    /**
	     * Bar chart series component.
	     * @constructs BarChartSeries
	     * @private
	     * @extends Series
	     * @param {object} params parameters
	     *      @param {object} params.model series model
	     *      @param {object} params.options series options
	     *      @param {object} params.theme series theme
	     */
	    init: function() {
	        Series.apply(this, arguments);
	    },

	    /**
	     * Make bound of bar chart.
	     * @param {number} width width
	     * @param {number} height height
	     * @param {number} top top position value
	     * @param {number} startLeft start left position value
	     * @param {number} endLeft end left position value
	     * @returns {{
	     *      start: {left: number, top: number, width: number, height: number},
	     *      end: {left: number, top: number, width: number, height: number}
	     * }} column chart bound
	     * @private
	     */
	    _makeBound: function(width, height, top, startLeft, endLeft) {
	        return {
	            start: {
	                top: top,
	                left: startLeft,
	                width: 0,
	                height: height
	            },
	            end: {
	                top: top,
	                left: endLeft,
	                width: width,
	                height: height
	            }
	        };
	    },

	    /**
	     * Calculate additional left for divided option.
	     * @param {number} value value
	     * @returns {number}
	     * @private
	     */
	    _calculateAdditionalLeft: function(value) {
	        var additionalLeft = 0;

	        if (this.options.divided && value > 0) {
	            additionalLeft = this.dimensionMap.yAxis.width + chartConst.OVERLAPPING_WIDTH;
	        }

	        return additionalLeft;
	    },

	    /**
	     * Make bar chart bound.
	     * @param {{
	     *      baseBarSize: number,
	     *      groupSize: number,
	     *      barSize: number,
	     *      pointInterval: number,
	     *      firstAdditionalPosition: number,
	     *      basePosition: number
	     * }} baseData base data for making bound
	     * @param {{
	     *      baseTop: number,
	     *      top: number,
	     *      plusLeft: number,
	     *      minusLeft: number,
	     *      prevStack: ?string
	     * }} iterationData iteration data
	     * @param {?boolean} isStackType whether stackType option or not.
	     * @param {SeriesItem} seriesItem series item
	     * @param {number} index index
	     * @returns {{
	     *      start: {left: number, top: number, width: number, height: number},
	     *      end: {left: number, top: number, width: number, height: number}
	     * }}
	     * @private
	     */
	    _makeBarChartBound: function(baseData, iterationData, isStackType, seriesItem, index) {
	        var barWidth = baseData.baseBarSize * seriesItem.ratioDistance;
	        var additionalLeft = this._calculateAdditionalLeft(seriesItem.value);
	        var barStartLeft = baseData.baseBarSize * seriesItem.startRatio;
	        var startLeft = baseData.basePosition + barStartLeft + additionalLeft;
	        var changedStack = (seriesItem.stack !== iterationData.prevStack);
	        var pointCount, endLeft, bound, boundTop;

	        if (!isStackType || (!this.options.diverging && changedStack)) {
	            pointCount = isStackType ? this.dataProcessor.findStackIndex(seriesItem.stack) : index;
	            iterationData.top = iterationData.baseTop + (baseData.pointInterval * pointCount);
	            iterationData.plusLeft = 0;
	            iterationData.minusLeft = 0;
	        }

	        if (seriesItem.value >= 0) {
	            endLeft = startLeft + iterationData.plusLeft;
	            iterationData.plusLeft += barWidth;
	        } else {
	            iterationData.minusLeft -= barWidth;
	            endLeft = startLeft + iterationData.minusLeft;
	        }

	        iterationData.prevStack = seriesItem.stack;
	        boundTop = iterationData.top + baseData.pointInterval - (baseData.barSize / 2);
	        bound = this._makeBound(barWidth, baseData.barSize, boundTop, startLeft, endLeft);

	        return bound;
	    },

	    /**
	     * Make series bounds for rendering
	     * @returns {Array.<Array.<object>>} bounds
	     * @private
	     */
	    _makeBounds: function() {
	        var self = this;
	        var seriesDataModel = this._getSeriesDataModel();
	        var isStacked = predicate.isValidStackOption(this.options.stackType);
	        var dimension = this.layout.dimension;
	        var baseData = this._makeBaseDataForMakingBound(dimension.height, dimension.width);

	        return seriesDataModel.map(function(seriesGroup, groupIndex) {
	            var baseTop = (groupIndex * baseData.groupSize) + self.layout.position.top;
	            var iterationData = {
	                baseTop: baseTop,
	                top: baseTop,
	                plusLeft: 0,
	                minusLeft: 0,
	                prevStack: null
	            };
	            var iteratee = snippet.bind(self._makeBarChartBound, self, baseData, iterationData, isStacked);

	            return seriesGroup.map(iteratee);
	        });
	    },

	    /**
	     * Calculate top position of sum label.
	     * @param {{left: number, top: number}} bound bound
	     * @param {number} labelHeight label height
	     * @returns {number} top position value
	     * @private
	     */
	    _calculateTopPositionOfSumLabel: function(bound, labelHeight) {
	        return bound.top + ((bound.height - labelHeight + chartConst.TEXT_PADDING) / 2);
	    }
	});

	BarTypeSeriesBase.mixin(BarChartSeries);

	function barSeriesFactory(params) {
	    var libType = params.chartOptions.libType;
	    var chartTheme = params.chartTheme;

	    params.libType = libType;
	    params.chartType = 'bar';
	    params.chartBackground = chartTheme.chart.background;

	    return new BarChartSeries(params);
	}

	// @todo let's find better way
	barSeriesFactory.componentType = 'series';
	barSeriesFactory.BarChartSeries = BarChartSeries;

	module.exports = barSeriesFactory;


/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Series base component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);

	var LABEL_FADE_IN_DURATION = 600;
	var browser = snippet.browser;
	var IS_IE7 = browser.msie && browser.version === 7;

	var chartConst = __webpack_require__(8);
	var dom = __webpack_require__(9);
	var predicate = __webpack_require__(11);
	var renderUtil = __webpack_require__(7);
	var pluginFactory = __webpack_require__(32);
	var raphaelRenderUtil = __webpack_require__(5);

	var Series = snippet.defineClass(/** @lends Series.prototype */ {
	    /**
	     * Series component className
	     * @type {string}
	     */
	    className: 'tui-chart-series-area',
	    /**
	     * Series base component.
	     * @constructs Series
	     * @private
	     * @param {object} params parameters
	     *      @param {object} params.options series options
	     *      @param {object} params.theme series theme
	     */
	    init: function(params) {
	        var libType = params.libType;

	        /**
	         * Chart type
	         * @type {string}
	         */
	        this.chartType = params.chartType;

	        /**
	         * Series name
	         * @tpye {string}
	         */
	        this.seriesType = params.seriesType || params.chartType;

	        /**
	         * Component type
	         * @type {string}
	         */
	        this.componentType = params.componentType;

	        /**
	         * Data processor
	         * @type {DataProcessor}
	         */
	        this.dataProcessor = params.dataProcessor;

	        /**
	         * event bus for transmitting message
	         * @type {object}
	         */
	        this.eventBus = params.eventBus;

	        /**
	         * chart background.
	         * @type {string}
	         */
	        this.chartBackground = params.chartBackground;

	        /**
	         * Options
	         * @type {object}
	         */
	        this.options = params.options || {};

	        /**
	         * Theme
	         * @type {object}
	         */

	        this.orgTheme = this.theme = params.theme;

	        /**
	         * Graph renderer
	         * @type {object}
	         */
	        this.graphRenderer = pluginFactory.get(libType, params.chartType);

	        /**
	         * series container
	         * @type {HTMLElement}
	         */
	        this.seriesContainer = null;

	        /**
	         * series label container
	         * @type {HTMLElement}
	         */
	        this.seriesLabelContainer = null;

	        /**
	         * series data
	         * @type {Array.<object>}
	         */
	        this.seriesData = [];

	        /**
	         * Selected legend index
	         * @type {?number}
	         */
	        this.selectedLegendIndex = null;

	        /**
	         * effector for show layer
	         * @type {object}
	         */
	        this.labelShowEffector = null;

	        /**
	         * raphael object
	         * @type {null|object}
	         */
	        this.paper = null;

	        /**
	         * limit(min, max) data for series
	         * @type {null|{min:number, max:number}}
	         */
	        this.limit = null;

	        /**
	         * aligned
	         * @type {null|boolean}
	         */
	        this.aligned = null;

	        /**
	         * layout bounds information for this components
	         * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number}}}
	         */
	        this.layout = null;

	        /**
	         * dimension map for layout of chart
	         * @type {null|object}
	         */
	        this.dimensionMap = null;

	        /**
	         * position map for layout of chart
	         * @type {null|object}
	         */
	        this.positionMap = null;

	        /**
	         * axis data map
	         * @type {null|object}
	         */
	        this.axisDataMap = null;

	        /**
	         * before axis data map
	         * @type {null|object}
	         */
	        this.beforeAxisDataMap = null;

	        /**
	         * Drawing type
	         * @type {string}
	         */
	        this.drawingType = chartConst.COMPONENT_TYPE_RAPHAEL;

	        /**
	         * whether series lable is supported
	         * @type {boolean}
	         */
	        this.supportSeriesLable = true;

	        this._attachToEventBus();
	    },

	    /**
	     * Attach to event bus.
	     * @private
	     */
	    _attachToEventBus: function() {
	        var firstRenderCheck = snippet.bind(function() {
	            this.isInitRenderCompleted = true;
	            this.eventBus.off('load', firstRenderCheck);
	        }, this);

	        this.eventBus.on(chartConst.PUBLIC_EVENT_PREFIX + 'load', firstRenderCheck);

	        this.eventBus.on({
	            selectLegend: this.onSelectLegend,
	            selectSeries: this.onSelectSeries,
	            unselectSeries: this.onUnselectSeries,
	            hoverSeries: this.onHoverSeries,
	            hoverOffSeries: this.onHoverOffSeries,
	            showGroupAnimation: this.onShowGroupAnimation,
	            hideGroupAnimation: this.onHideGroupAnimation
	        }, this);

	        if (this.onShowTooltip) {
	            this.eventBus.on('showTooltip', this.onShowTooltip, this);
	        }

	        if (this.onShowGroupTooltipLine) {
	            this.eventBus.on({
	                showGroupTooltipLine: this.onShowGroupTooltipLine,
	                hideGroupTooltipLine: this.onHideGroupTooltipLine
	            }, this);
	        }

	        if (this.onClickSeries) {
	            this.eventBus.on({
	                clickSeries: this.onClickSeries,
	                moveSeries: this.onMoveSeries
	            }, this);
	        }
	    },

	    /**
	     * Get seriesDataModel.
	     * @returns {SeriesDataModel}
	     * @private
	     */
	    _getSeriesDataModel: function() {
	        return this.dataProcessor.getSeriesDataModel(this.seriesType);
	    },

	    /**
	     * Make series data.
	     * @private
	     * @abstract
	     */
	    _makeSeriesData: function() {},

	    /**
	     * Get seriesData
	     * @returns {object} series data
	     */
	    getSeriesData: function() {
	        return this.seriesData;
	    },

	    /**
	     * Render series label.
	     * @private
	     * @abstract
	     */
	    _renderSeriesLabel: function() {},

	    /**
	     * Render series label area
	     * @param {object} paper series label area element
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderSeriesLabelArea: function(paper) {
	        return this._renderSeriesLabel(paper);
	    },

	    /**
	     * Send boudns to mouseEventDetector component.
	     * @param {object} seriesData - series data
	     * @private
	     */
	    _sendBoundsToMouseEventDetector: function(seriesData) {
	        this.eventBus.fire('receiveSeriesData', {
	            chartType: this.chartType,
	            data: seriesData
	        });
	    },

	    /**
	     * Render series area.
	     * @param {object} paper - raphael object
	     * @param {function} funcRenderGraph - function for graph rendering
	     * @private
	     */
	    _renderSeriesArea: function(paper, funcRenderGraph) {
	        var dimension, seriesData;

	        dimension = this.dimensionMap.extendedSeries;

	        this.seriesData = seriesData = this._makeSeriesData();

	        this._sendBoundsToMouseEventDetector(seriesData);

	        if (this.hasDataForRendering(seriesData) || this.chartType === 'map') {
	            if (funcRenderGraph) {
	                this.seriesSet = funcRenderGraph(dimension, seriesData, paper);
	            }

	            if (predicate.isShowLabel(this.options) && this.supportSeriesLable) {
	                this.labelSet = this._renderSeriesLabelArea(paper);
	            }
	        }
	    },

	    /**
	     * Make parameters for graph rendering.
	     * @param {{width: number, height: number}} dimension dimension
	     * @param {object} seriesData series data
	     * @returns {object} parameters for graph rendering
	     * @private
	     */
	    _makeParamsForGraphRendering: function(dimension, seriesData) {
	        return snippet.extend({
	            dimension: dimension,
	            position: this.layout.position,
	            chartType: this.seriesType,
	            theme: this.theme,
	            options: this.options
	        }, seriesData);
	    },

	    /**
	     * Render raphael graph.
	     * @param {{width: number, height: number}} dimension - dimension
	     * @param {object} seriesData - series data
	     * @param {object} [paper] - raphael paper
	     * @returns {object}
	     * @private
	     */
	    _renderGraph: function(dimension, seriesData, paper) {
	        var params = this._makeParamsForGraphRendering(dimension, seriesData);

	        return this.graphRenderer.render(paper, params);
	    },

	    /**
	     * Set data for rendering.
	     * @param {{
	     *      paper: ?object,
	     *      limit: {
	     *          min: number,
	     *          max: number
	     *      },
	     *      aligned: boolean,
	     *      layout: {
	     *          dimension: {width: number, height: number},
	     *          position: {left: number, top: number}
	     *      },
	     *      dimensionMap: object,
	     *      positionMap: object,
	     *      axisDataMap: object
	     * }} data - data for rendering
	     * @private
	     */
	    _setDataForRendering: function(data) {
	        this.paper = data.paper;
	        this.limit = data.limitMap[this.chartType];
	        if (data.axisDataMap && data.axisDataMap.xAxis) {
	            this.aligned = data.axisDataMap.xAxis.aligned;
	        }
	        this.layout = data.layout;
	        this.dimensionMap = data.dimensionMap;
	        this.positionMap = data.positionMap;
	        this.axisDataMap = data.axisDataMap;
	    },

	    /**
	     * Render series component.
	     * @param {object} data - data for rendering
	     */
	    render: function(data) {
	        var checkedLegends;
	        this.paper = data.paper;
	        this._setDataForRendering(data);
	        this._clearSeriesContainer();
	        this.beforeAxisDataMap = this.axisDataMap;

	        if (data.checkedLegends) {
	            checkedLegends = data.checkedLegends[this.seriesType];
	            if (!this.options.colorByPoint) {
	                this.theme = this._getCheckedSeriesTheme(this.orgTheme, checkedLegends);
	            }
	        }

	        this._renderSeriesArea(data.paper, snippet.bind(this._renderGraph, this));

	        if (this.paper.pushDownBackgroundToBottom) {
	            this.paper.pushDownBackgroundToBottom();
	        }
	    },

	    /**
	     * Get checked series theme.
	     * @param {object} theme legend theme
	     * @param {?Array.<?boolean>} checkedLegends checked legends
	     * @returns {object} checked series theme
	     * @private
	     */
	    _getCheckedSeriesTheme: function(theme, checkedLegends) {
	        var cloneTheme;

	        if (!checkedLegends.length) {
	            return theme;
	        }

	        cloneTheme = JSON.parse(JSON.stringify(theme));
	        cloneTheme.colors = snippet.filter(cloneTheme.colors, function(color, index) {
	            return checkedLegends[index];
	        });

	        return cloneTheme;
	    },

	    /**
	     * Clear series container.
	     * @private
	     */
	    _clearSeriesContainer: function() {
	        if (this.seriesSet && this.seriesSet.remove) {
	            this.seriesSet.forEach(function(series) {
	                series.remove();
	            }, this);
	            this.seriesSet.remove();
	        }
	        if (this.labelSet && this.labelSet.remove) {
	            this.labelSet.forEach(function(label) {
	                label.remove();
	            }, this);
	            this.labelSet.remove();
	        }

	        this.seriesData = [];
	    },

	    /**
	     * Rerender series
	     * @param {object} data - data for rendering
	     */
	    rerender: function(data) {
	        var checkedLegends;

	        if (this.dataProcessor.getGroupCount(this.seriesType)) {
	            if (data.checkedLegends) {
	                checkedLegends = data.checkedLegends[this.seriesType];
	                this.theme = this._getCheckedSeriesTheme(this.orgTheme, checkedLegends);
	            }

	            this._setDataForRendering(data);
	            this._clearSeriesContainer();
	            this._renderSeriesArea(data.paper, snippet.bind(this._renderGraph, this));

	            if (this.labelShowEffector) {
	                clearInterval(this.labelShowEffector.timerId);
	            }

	            // if rerender have excuted in the middle of animate,
	            // we should rerun animate
	            if (checkedLegends || !this.isInitRenderCompleted) {
	                this.animateComponent(true);
	            }

	            if (!snippet.isNull(this.selectedLegendIndex)) {
	                this.graphRenderer.selectLegend(this.selectedLegendIndex);
	            }
	        }
	    },

	    /**
	     * Return whether label visible or not.
	     * @returns {boolean}
	     * @private
	     */
	    _isLabelVisible: function() {
	        return !!(this.options.showLabel || this.options.showLegend);
	    },

	    /**
	     * Resize raphael graph by given dimension and series data
	     * @param {{width: number, height: number}} dimension - chart dimension
	     * @param {object} seriesData - series data
	     * @returns {Array.<object>}
	     * @private
	     */
	    _resizeGraph: function(dimension, seriesData) {
	        this.graphRenderer.resize(snippet.extend({
	            dimension: this.dimensionMap.chart
	        }, seriesData));

	        return this.seriesSet;
	    },

	    /**
	     * Resize series component.
	     * }} bound series bound
	     * @param {object} data data for rendering
	     */
	    resize: function(data) {
	        this._clearSeriesContainer();
	        this._setDataForRendering(data);
	        this._renderSeriesArea(data.paper, snippet.bind(this._resizeGraph, this));
	    },

	    /**
	     * Set element's top, left given top, left position
	     * @param {HTMLElement} el - series element
	     * @param {{top: number, left: number}} position - series top, left position
	     * @private
	     */
	    _renderPosition: function(el, position) {
	        var hiddenWidth = renderUtil.isOldBrowser() ? 1 : 0;

	        renderUtil.renderPosition(el, {
	            top: position.top - (hiddenWidth),
	            left: position.left - (hiddenWidth * 2)
	        });
	    },

	    /**
	     * Get limit distance from zero point.
	     * @param {number} size chart size (width or height)
	     * @param {{min: number, max: number}} limit limit
	     * @returns {{toMax: number, toMin: number}} pixel distance
	     * @private
	     */
	    _getLimitDistanceFromZeroPoint: function(size, limit) {
	        var min = limit.min,
	            max = limit.max,
	            distance = max - min,
	            toMax = 0,
	            toMin = 0;

	        if (min <= 0 && max >= 0) {
	            toMax = (distance + min) / distance * size;
	            toMin = (distance - max) / distance * size;
	        } else if (min > 0) {
	            toMax = size;
	        }

	        return {
	            toMax: toMax,
	            toMin: toMin
	        };
	    },

	    /**
	     * Find label element.
	     * @param {HTMLElement} elTarget target element
	     * @returns {HTMLElement} label element
	     * @private
	     */
	    _findLabelElement: function(elTarget) {
	        var elLabel = null;

	        if (dom.hasClass(elTarget, chartConst.CLASS_NAME_SERIES_LABEL)) {
	            elLabel = elTarget;
	        } else {
	            elLabel = dom.findParentByClass(elTarget, chartConst.CLASS_NAME_SERIES_LABEL);
	        }

	        return elLabel;
	    },

	    /**
	     * To call showAnimation function of graphRenderer.
	     * @param {{groupIndex: number, index: number}} data data
	     * @param {string} chartType - chart type
	     */
	    onHoverSeries: function(data, chartType) {
	        if (chartType !== this.chartType) {
	            return;
	        }

	        if (!this.graphRenderer.showAnimation) {
	            return;
	        }

	        this.graphRenderer.showAnimation(data);
	    },

	    /**
	     * To call hideAnimation function of graphRenderer.
	     * @param {{groupIndex: number, index: number}} data data
	     * @param {string} chartType - chart type
	     */
	    onHoverOffSeries: function(data, chartType) {
	        if (chartType !== this.chartType) {
	            return;
	        }

	        if (!this.graphRenderer.hideAnimation || !data) {
	            return;
	        }

	        this.graphRenderer.hideAnimation(data);
	    },

	    /**
	     * To call showGroupAnimation function of graphRenderer.
	     * @param {number} index index
	     */
	    onShowGroupAnimation: function(index) {
	        if (!this.graphRenderer.showGroupAnimation) {
	            return;
	        }
	        this.graphRenderer.showGroupAnimation(index);
	    },

	    /**
	     * To call hideGroupAnimation function of graphRenderer.
	     * @param {number} index index
	     */
	    onHideGroupAnimation: function(index) {
	        if (!this.graphRenderer.hideGroupAnimation) {
	            return;
	        }
	        this.graphRenderer.hideGroupAnimation(index);
	    },

	    /**
	     * Animate component.
	     * @param {boolean} [isRerendering] - whether rerendering or not
	     */
	    animateComponent: function(isRerendering) {
	        if (this.graphRenderer.animate && this.seriesSet) {
	            this.graphRenderer.animate(snippet.bind(this.animateSeriesLabelArea, this, isRerendering), this.seriesSet);
	        } else {
	            this.animateSeriesLabelArea(isRerendering);
	        }
	    },

	    /**
	     * Fire load event.
	     * @param {boolean} [isRerendering] - whether rerendering or not
	     * @private
	     */
	    _fireLoadEvent: function(isRerendering) {
	        if (!isRerendering) {
	            this.eventBus.fire(chartConst.PUBLIC_EVENT_PREFIX + 'load');
	        }
	    },

	    /**
	     * Animate series label area.
	     * @param {boolean} [isRerendering] - whether rerendering or not
	     */
	    animateSeriesLabelArea: function(isRerendering) {
	        if (!this._isLabelVisible()) {
	            this._fireLoadEvent(isRerendering);

	            return;
	        }

	        if (IS_IE7) {
	            this._fireLoadEvent(isRerendering);
	            this.labelSet.attr({
	                opacity: 1
	            });
	        } else if (this.labelSet && this.labelSet.length) {
	            raphaelRenderUtil.animateOpacity(this.labelSet, 0, 1, LABEL_FADE_IN_DURATION);
	        }
	    },

	    /**
	     * Make exportation data for public event of series type.
	     * @param {object} seriesData series data
	     * @returns {{chartType: string, legend: string, legendIndex: number, index: number}} export data
	     * @private
	     */
	    _makeExportationSeriesData: function(seriesData) {
	        var indexes = seriesData.indexes;
	        var legendIndex = snippet.isExisty(indexes.legendIndex) ? indexes.legendIndex : indexes.index;
	        var legendData = this.dataProcessor.getLegendItem(legendIndex);
	        var index = snippet.isExisty(indexes.groupIndex) ? indexes.groupIndex : 0;
	        var seriesItem = this._getSeriesDataModel().getSeriesItem(index, indexes.index);
	        var result;

	        if (snippet.isExisty(seriesItem)) {
	            result = {
	                chartType: legendData.chartType,
	                legend: legendData.label,
	                legendIndex: legendIndex
	            };
	            result.index = seriesItem.index;
	        }

	        return result;
	    },

	    /**
	     * Execute graph renderer.
	     * @param {{left: number, top: number}} position mouse position
	     * @param {string} funcName function name
	     * @returns {*} result.
	     * @private
	     */
	    _executeGraphRenderer: function(position, funcName) {
	        var isShowLabel = false;
	        var result;

	        this.eventBus.fire('hideTooltipContainer');
	        if (this.seriesLabelContainer && dom.hasClass(this.seriesLabelContainer, 'show')) {
	            dom.removeClass(this.seriesLabelContainer, 'show');
	            isShowLabel = true;
	        }

	        result = this.graphRenderer[funcName](position);

	        if (isShowLabel) {
	            dom.addClass(this.seriesLabelContainer, 'show');
	        }

	        this.eventBus.fire('showTooltipContainer');

	        return result;
	    },

	    /**
	     * To call selectSeries callback of public event.
	     * @param {object} seriesData - series data
	     * @param {?boolean} shouldSelect - whether should select or not
	     */
	    onSelectSeries: function(seriesData, shouldSelect) {
	        var eventName;

	        if (seriesData.chartType !== this.chartType) {
	            return;
	        }

	        eventName = chartConst.PUBLIC_EVENT_PREFIX + 'selectSeries';

	        this.eventBus.fire(eventName, this._makeExportationSeriesData(seriesData));
	        shouldSelect = snippet.isEmpty(shouldSelect) ? true : shouldSelect;

	        if (this.options.allowSelect && this.graphRenderer.selectSeries && shouldSelect) {
	            this.graphRenderer.selectSeries(seriesData.indexes);
	        }
	    },

	    /**
	     * To call unselectSeries callback of public event.
	     * @param {object} seriesData series data.
	     */
	    onUnselectSeries: function(seriesData) {
	        var eventName;

	        if (seriesData.chartType !== this.chartType) {
	            return;
	        }

	        eventName = chartConst.PUBLIC_EVENT_PREFIX + 'unselectSeries';

	        this.eventBus.fire(eventName, this._makeExportationSeriesData(seriesData));
	        if (this.options.allowSelect && this.graphRenderer.unselectSeries) {
	            this.graphRenderer.unselectSeries(seriesData.indexes);
	        }
	    },

	    /**
	     *On select legend.
	     * @param {string} seriesType - series name
	     * @param {?number} legendIndex - legend index
	     */
	    onSelectLegend: function(seriesType, legendIndex) {
	        if ((this.seriesType !== seriesType) && !snippet.isNull(legendIndex)) {
	            legendIndex = -1;
	        }

	        this.selectedLegendIndex = legendIndex;

	        if (this._getSeriesDataModel().getGroupCount()) {
	            this.graphRenderer.selectLegend(legendIndex);
	        }
	    },

	    /**
	     * Show label.
	     */
	    showLabel: function() {
	        this.options.showLabel = true;

	        if (!this.seriesLabelContainer && this.supportSeriesLable) {
	            this._renderSeriesLabelArea(this.paper);
	        }
	    },

	    /**
	     * Hide label.
	     */
	    hideLabel: function() {
	        this.options.showLabel = false;

	        if (this.seriesLabelContainer) {
	            dom.removeClass(this.seriesLabelContainer, 'show');
	            dom.removeClass(this.seriesLabelContainer, 'opacity');
	        }
	    },
	    /**
	     * Return boolean value whether seriesData contains data
	     * @param {object} seriesData seriesData object
	     * @returns {boolean}
	     */
	    hasDataForRendering: function(seriesData) {
	        return !!(seriesData && seriesData.isAvailable());
	    }
	});

	module.exports = Series;


/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview BarTypeSeriesBase is base class for bar type series.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var labelHelper = __webpack_require__(83);
	var predicate = __webpack_require__(11);
	var calculator = __webpack_require__(45);
	var renderUtil = __webpack_require__(7);
	var raphaelRenderUtil = __webpack_require__(5);
	var snippet = __webpack_require__(6);

	var DEFAULT_BAR_SIZE_RATIO_BY_POINT_INTERVAL = 0.8;

	var BarTypeSeriesBase = snippet.defineClass(/** @lends BarTypeSeriesBase.prototype */ {
	    /**
	     * Make series data.
	     * @returns {object} add data
	     * @private
	     * @override
	     */
	    _makeSeriesData: function() {
	        var groupBounds = this._makeBounds(this.layout.dimension);

	        this.groupBounds = groupBounds;

	        return {
	            groupBounds: groupBounds,
	            seriesDataModel: this._getSeriesDataModel(),
	            isAvailable: function() {
	                return groupBounds && groupBounds.length > 0;
	            }
	        };
	    },

	    /**
	     * Get bar width option size.
	     * @param {number} pointInterval point interval
	     * @param {number} [optionBarWidth] barWidth option
	     * @returns {number} option size
	     * @private
	     */
	    _getBarWidthOptionSize: function(pointInterval, optionBarWidth) {
	        var optionsSize = 0;

	        if (optionBarWidth) {
	            if ((optionBarWidth / 2) >= pointInterval) {
	                optionBarWidth = pointInterval * 2;
	            } else if (optionBarWidth < 0) {
	                optionBarWidth = 0;
	            }
	            optionsSize = optionBarWidth;
	        }

	        return optionsSize;
	    },

	    /**
	     * Calculate difference between optionSize and barSize.
	     * @param {number} barSize bar size
	     * @param {number} optionSize option size
	     * @param {number} itemCount item count
	     * @returns {number} addition padding
	     * @private
	     */
	    _calculateAdditionalPosition: function(barSize, optionSize, itemCount) {
	        var additionalPosition = 0;

	        if (optionSize && optionSize < barSize) {
	            additionalPosition = (barSize / 2) + ((barSize - optionSize) * itemCount / 2);
	        }

	        return additionalPosition;
	    },

	    /**
	     * Make base data for making bound.
	     * @param {number} baseGroupSize base group size
	     * @param {number} baseBarSize base bar size
	     * @returns {undefined|{
	     *      baseBarSize: number,
	     *      groupSize: number,
	     *      barSize: number,
	     *      pointInterval: number,
	     *      firstAdditionalPosition: number,
	     *      basePosition: number
	     * }}
	     * @private
	     */
	    _makeBaseDataForMakingBound: function(baseGroupSize, baseBarSize) {
	        var isStackType = predicate.isValidStackOption(this.options.stackType);
	        var seriesDataModel = this._getSeriesDataModel();
	        var groupSize = baseGroupSize / seriesDataModel.getGroupCount();
	        var columnTopOffset = -this.layout.position.top + chartConst.CHART_PADDING;
	        var positionValue, itemCount, barSize, optionSize, basePosition, pointInterval, baseBounds;
	        var zeroToMin = this._getLimitDistanceFromZeroPoint(baseBarSize, this.limit).toMin;

	        if (predicate.isColumnChart(this.chartType)) {
	            positionValue = columnTopOffset;
	        } else if (predicate.isBoxplotChart(this.chartType)) {
	            positionValue = this.layout.position.top - chartConst.CHART_PADDING;
	        } else {
	            positionValue = this.layout.position.left;
	        }

	        if (seriesDataModel.rawSeriesData.length > 0) {
	            if (!isStackType) {
	                itemCount = seriesDataModel.getFirstSeriesGroup().getSeriesItemCount();
	            } else {
	                itemCount = this.options.diverging ? 1 : this.dataProcessor.getStackCount(this.seriesType);
	            }

	            pointInterval = groupSize / (itemCount + 1);
	            barSize = pointInterval * DEFAULT_BAR_SIZE_RATIO_BY_POINT_INTERVAL;
	            optionSize = this.options.barWidth || this.options.pointWidth;
	            barSize = this._getBarWidthOptionSize(pointInterval, optionSize) || barSize;
	            basePosition = zeroToMin + positionValue;

	            if (predicate.isColumnChart(this.chartType)) {
	                basePosition = baseBarSize - basePosition;
	            }

	            if (predicate.isBoxplotChart(this.chartType) && zeroToMin) {
	                basePosition -= zeroToMin * 2;
	            }

	            baseBounds = {
	                baseBarSize: baseBarSize,
	                groupSize: groupSize,
	                barSize: barSize,
	                pointInterval: pointInterval,
	                firstAdditionalPosition: pointInterval,
	                basePosition: basePosition
	            };
	        }

	        return baseBounds;
	    },

	    /**
	     * Render normal series label.
	     * @param {object} paper paper
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderNormalSeriesLabel: function(paper) {
	        var graphRenderer = this.graphRenderer;
	        var seriesDataModel = this._getSeriesDataModel();
	        var boundsSet = this.seriesData.groupBounds;
	        var labelTheme = this.theme.label;
	        var selectedIndex = this.selectedLegendIndex;
	        var groupLabels = seriesDataModel.map(function(seriesGroup) {
	            return seriesGroup.map(function(seriesDatum) {
	                var label = {
	                    end: seriesDatum.endLabel
	                };

	                if (snippet.isExisty(seriesDatum.start)) {
	                    label.start = seriesDatum.startLabel;
	                }

	                return label;
	            });
	        });
	        var positionsSet;

	        if (predicate.isBarChart(this.chartType)) {
	            positionsSet = labelHelper.boundsToLabelPositionsForBarChart(seriesDataModel, boundsSet, labelTheme);
	        } else {
	            positionsSet = labelHelper.boundsToLabelPositionsForColumnChart(seriesDataModel, boundsSet, labelTheme);
	        }

	        return graphRenderer.renderSeriesLabel(paper, positionsSet, groupLabels, labelTheme, selectedIndex);
	    },

	    /**
	     * Make sum values.
	     * @param {Array.<number>} values values
	     * @returns {number} sum result.
	     */
	    _makeSumValues: function(values) {
	        var sum = calculator.sum(values);

	        return renderUtil.formatValue({
	            value: sum,
	            formatFunctions: this.dataProcessor.getFormatFunctions(),
	            chartType: this.chartType,
	            areaType: 'series'
	        });
	    },

	    /**
	     * Make stackType label position.
	     * @param {{width: number, height: number, left: number, top: number}} bound element bound
	     * @returns {{left: number, top: number}} position
	     * @private
	     */
	    _makeStackedLabelPosition: function(bound) {
	        var left = bound.left + (bound.width / 2);
	        var top = bound.top + (bound.height / 2);

	        return {
	            left: left,
	            top: top
	        };
	    },

	    /**
	     * Make labels html, when has stackType option.
	     * @param {object} params parameters
	     *      @param {number} params.groupIndex group index
	     *      @param {Array.<object>} params.bounds bounds,
	     * @returns {string} label positions
	     * @private
	     */
	    _makeStackedLabelPositions: function(params) {
	        var self = this;
	        var seriesGroup = params.seriesGroup;
	        var positions = seriesGroup.map(function(seriesItem, index) {
	            var bound = params.bounds[index];
	            var position;

	            if (bound && seriesItem) {
	                position = self._makeStackedLabelPosition(bound.end);
	            }

	            return {
	                end: position
	            };
	        });

	        return positions;
	    },

	    getGroupLabels: function(seriesDataModel, sumPlusValues, sumMinusValues) {
	        var isNormalStack = predicate.isNormalStack(this.options.stackType);

	        return seriesDataModel.map(function(seriesGroup) {
	            var labels = seriesGroup.map(function(seriesDatum) {
	                return {
	                    end: seriesDatum.endLabel
	                };
	            });
	            var minusSum;

	            if (isNormalStack) {
	                sumPlusValues.push(calculator.sumPlusValues(seriesGroup.pluck('value')));

	                minusSum = calculator.sumMinusValues(seriesGroup.pluck('value'));
	                if (minusSum < 0) {
	                    sumMinusValues.push(minusSum);
	                }
	            }

	            return labels;
	        });
	    },

	    getGroupPositions: function(seriesDataModel, groupBounds) {
	        var self = this;

	        return seriesDataModel.map(function(seriesGroup, index) {
	            return self._makeStackedLabelPositions({
	                seriesGroup: seriesGroup,
	                bounds: groupBounds[index]
	            });
	        });
	    },

	    /**
	     * Render series label, when has stackType option.
	     * @param {object} paper paper
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderStackedSeriesLabel: function(paper) {
	        var self = this;
	        var sumPlusValues = [];
	        var sumMinusValues = [];
	        var labelTheme = this.theme.label;
	        var groupBounds = this.seriesData.groupBounds;
	        var seriesDataModel = this._getSeriesDataModel();
	        var groupPositions = this.getGroupPositions(seriesDataModel, groupBounds);
	        var groupLabels = this.getGroupLabels(seriesDataModel, sumPlusValues, sumMinusValues);
	        var isStacked = true;
	        var isNormalStack = predicate.isNormalStack(this.options.stackType);
	        var isBarChart = predicate.isBarChart(this.chartType);
	        var dimensionType = isBarChart ? 'width' : 'height';
	        var positionType = isBarChart ? 'left' : 'top';
	        var direction = isBarChart ? 1 : -1;

	        if (isNormalStack) {
	            snippet.forEach(groupLabels, function(labels, index) {
	                var plusSumValue = sumPlusValues[index];
	                var minusSumValue = sumMinusValues[index];

	                if (minusSumValue < 0 && self.options.diverging) {
	                    minusSumValue *= -1;
	                }

	                labels.push({
	                    end: renderUtil.formatToComma(plusSumValue)
	                });

	                if (sumMinusValues.length) {
	                    labels.push({
	                        end: renderUtil.formatToComma(minusSumValue)
	                    });
	                }
	            });

	            snippet.forEach(groupPositions, function(positions, index) {
	                var bounds = groupBounds[index];
	                var lastBound = bounds[bounds.length - 1].end;
	                var firstBound = bounds[Math.max(parseInt(bounds.length / 2, 10), 1) - 1].end;
	                var plusEnd = self._makeStackedLabelPosition(lastBound);
	                var minusEnd = self._makeStackedLabelPosition(firstBound);
	                var plusLabel = sumPlusValues[index];
	                var minusLabel = sumMinusValues[index];
	                var plusLabelSize = raphaelRenderUtil.getRenderedTextSize(plusLabel, labelTheme.fontSize,
	                    labelTheme.fontFamily);
	                var minusLabelSize = raphaelRenderUtil.getRenderedTextSize(minusLabel, labelTheme.fontSize,
	                    labelTheme.fontFamily);
	                var lastBoundEndPosition = ((lastBound[dimensionType] + plusLabelSize[dimensionType]) / 2);
	                var firstBoundStartPosition = ((firstBound[dimensionType] + minusLabelSize[dimensionType]) / 2);

	                plusEnd[positionType] += (lastBoundEndPosition + chartConst.LEGEND_LABEL_LEFT_PADDING) * direction;
	                minusEnd[positionType] -= (firstBoundStartPosition + chartConst.LEGEND_LABEL_LEFT_PADDING) * direction;

	                positions.push({
	                    end: plusEnd
	                });
	                if (sumMinusValues.length) {
	                    positions.push({
	                        end: minusEnd
	                    });
	                }
	            });
	        }

	        return this.graphRenderer.renderSeriesLabel(paper, groupPositions, groupLabels, labelTheme, isStacked);
	    },

	    /**
	     * Render series label.
	     * @param {object} paper paper
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderSeriesLabel: function(paper) {
	        var labelSet;

	        if (this.options.stackType) {
	            labelSet = this._renderStackedSeriesLabel(paper);
	        } else {
	            labelSet = this._renderNormalSeriesLabel(paper);
	        }

	        return labelSet;
	    }
	});

	BarTypeSeriesBase.mixin = function(func) {
	    snippet.extend(func.prototype, BarTypeSeriesBase.prototype);
	};

	module.exports = BarTypeSeriesBase;


/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview  renderingLabelHelper is helper for rendering of series label.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var renderUtil = __webpack_require__(7);
	var snippet = __webpack_require__(6);

	/**
	 * renderingLabelHelper is helper for rendering of series label.
	 * @module renderingLabelHelper
	 * @private
	 */
	var renderingLabelHelper = {
	    /**
	     * Calculate left position for center align of series label.
	     * @param {{left: number, top: number, width:number, height: number}} bound - bound
	     * @returns {number}
	     * @private
	     */
	    _calculateLeftPositionForCenterAlign: function(bound) {
	        return bound.left + (bound.width / 2);
	    },

	    /**
	     * Calculate top position for middle align of series label.
	     * @param {{left: number, top: number, width:number, height: number}} bound - bound
	     * @returns {number}
	     * @private
	     */
	    _calculateTopPositionForMiddleAlign: function(bound) {
	        return bound.top + (bound.height / 2);
	    },

	    /**
	     * Make position for type of bound for rendering label.
	     * @param {{left: number, top: number, width:number, height: number}} bound - bound
	     * @returns {{left: number, top: number}}
	     * @private
	     */
	    _makePositionForBoundType: function(bound) {
	        return {
	            left: this._calculateLeftPositionForCenterAlign(bound),
	            top: this._calculateTopPositionForMiddleAlign(bound)
	        };
	    },

	    /**
	     * Make position map for rendering label.
	     * @param {SeriesItem} seriesItem - series itemyuio
	     * @param {{left: number, top: number, width: number, height: number}} bound - bound
	     * @param {number} labelHeight - label height
	     * @param {object} theme - theme for series label
	     * @param {function} makePosition - function for making position of label
	     * @returns {{end: *}}
	     * @private
	     */
	    _makePositionMap: function(seriesItem, bound, labelHeight, theme, makePosition) {
	        var value = seriesItem.value;
	        var isOppositeSide = value >= 0;
	        var positionMap = {
	            end: makePosition(bound, labelHeight, seriesItem.endLabel || seriesItem.label, theme, isOppositeSide)
	        };

	        if (seriesItem.isRange) {
	            isOppositeSide = value < 0;
	            positionMap.start = makePosition(bound, labelHeight, seriesItem.startLabel, theme, isOppositeSide);
	        }

	        return positionMap;
	    },

	    /**
	     * Bounds to label positions.
	     * @param {SeriesDataModel} seriesDataModel - series data model
	     * @param {Array.<Array.<{left: number, top: number, width: number, height: number}>>} boundsSet - bounds set
	     * @param {object} theme - theme for series label
	     * @param {function} [makePosition] - function for making position of label
	     * @param {boolean} [isPivot] - whether pivot or not
	     * @returns {Array.<Object>}
	     */
	    boundsToLabelPositions: function(seriesDataModel, boundsSet, theme, makePosition, isPivot) {
	        var self = this;
	        var labelHeight = renderUtil.getRenderedLabelHeight(chartConst.MAX_HEIGHT_WORD, theme);

	        makePosition = makePosition || snippet.bind(this._makePositionForBoundType, this);
	        isPivot = !!isPivot;

	        return seriesDataModel.map(function(seriesGroup, groupIndex) {
	            var bounds = boundsSet[groupIndex];

	            return seriesGroup.map(function(seriesItem, index) {
	                var bound = bounds[index].end;

	                return self._makePositionMap(seriesItem, bound, labelHeight, theme, makePosition);
	            });
	        }, isPivot);
	    },

	    /**
	     * Make label position for bar chart.
	     * @param {{left: number, top: number, width:number, height: number}} bound - bound
	     * @param {number} labelHeight - label height
	     * @param {string} label - label
	     * @param {object} theme - theme for series label
	     * @param {boolean} isOppositeSide - whether opossite side or not
	     * @returns {{left: number, top: number}}
	     * @private
	     */
	    _makePositionForBarChart: function(bound, labelHeight, label, theme, isOppositeSide) {
	        var labelWidth = renderUtil.getRenderedLabelWidth(label, theme);
	        var left = bound.left;

	        if (isOppositeSide) {
	            left += bound.width + chartConst.SERIES_LABEL_PADDING;
	        } else {
	            left -= labelWidth + chartConst.SERIES_LABEL_PADDING;
	        }

	        return {
	            left: left,
	            top: this._calculateTopPositionForMiddleAlign(bound)
	        };
	    },

	    /**
	     * Bounds to label positions for bar chart.
	     * @param {SeriesDataModel} seriesDataModel - series data model
	     * @param {Array.<Array.<{left: number, top: number, width: number, height: number}>>} boundsSet - bounds set
	     * @param {object} theme - theme for series label
	     * @returns {*|Array.<Object>|Array}
	     */
	    boundsToLabelPositionsForBarChart: function(seriesDataModel, boundsSet, theme) {
	        var makePositionFunction = snippet.bind(this._makePositionForBarChart, this);

	        return this.boundsToLabelPositions(seriesDataModel, boundsSet, theme, makePositionFunction);
	    },

	    /**
	     * Make label position for column chart.
	     * @param {{left: number, top: number, width:number, height: number}} bound - bound
	     * @param {number} labelHeight - label height
	     * @param {string} label - label
	     * @param {object} theme - theme for series label
	     * @param {boolean} isOppositeSide - whether opossite side or not
	     * @returns {{left: number, top: number}}
	     * @private
	     */
	    _makePositionForColumnChart: function(bound, labelHeight, label, theme, isOppositeSide) {
	        var top = bound.top;

	        if (isOppositeSide) {
	            top -= labelHeight + chartConst.SERIES_LABEL_PADDING;
	        } else {
	            top += bound.height + chartConst.SERIES_LABEL_PADDING;
	        }

	        return {
	            left: this._calculateLeftPositionForCenterAlign(bound),
	            top: top
	        };
	    },

	    /**
	     * Bounds to label positions for column chart.
	     * @param {SeriesDataModel} seriesDataModel - series data model
	     * @param {Array.<Array.<{left: number, top: number, width: number, height: number}>>} boundsSet - bounds set
	     * @param {object} theme - theme for series label
	     * @returns {*|Array.<Object>|Array}
	     */
	    boundsToLabelPositionsForColumnChart: function(seriesDataModel, boundsSet, theme) {
	        var makePositionFunction = snippet.bind(this._makePositionForColumnChart, this);

	        return this.boundsToLabelPositions(seriesDataModel, boundsSet, theme, makePositionFunction);
	    },

	    /**
	     * Make labels html for treemap chart.
	     * @param {Array.<SeriesItem>} seriesItems - seriesItems
	     * @param {object.<string, {left: number, top: number, width: number, height: number}>} boundMap - bound map
	     * @returns {string}
	     */
	    boundsToLabelPostionsForTreemap: function(seriesItems, boundMap) {
	        var self = this;
	        var positions = snippet.map(seriesItems, function(seriesItem) {
	            var bound = boundMap[seriesItem.id];
	            var position;

	            if (bound) {
	                position = self._makePositionForBoundType(bound);
	            }

	            return position;
	        });

	        return positions;
	    }
	};

	module.exports = renderingLabelHelper;


/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Column chart series component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var BarTypeSeriesBase = __webpack_require__(82);
	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var renderUtil = __webpack_require__(7);
	var snippet = __webpack_require__(6);

	var ColumnChartSeries = snippet.defineClass(Series, /** @lends ColumnChartSeries.prototype */ {
	    /**
	     * Column chart series component.
	     * @constructs ColumnChartSeries
	     * @private
	     * @extends Series
	     * @param {object} params parameters
	     *      @param {object} params.model series model
	     *      @param {object} params.options series options
	     *      @param {object} params.theme series theme
	     */
	    init: function() {
	        Series.apply(this, arguments);
	    },

	    /**
	     * Make bound of column chart.
	     * @param {number} width width
	     * @param {number} height height
	     * @param {number} left top position value
	     * @param {number} startTop start top position value
	     * @param {number} endTop end top position value
	     * @returns {{
	     *      start: {left: number, top: number, width: number, height: number},
	     *      end: {left: number, top: number, width: number, height: number}
	     * }} column chart bound
	     * @private
	     */
	    _makeBound: function(width, height, left, startTop, endTop) {
	        return {
	            start: {
	                top: startTop,
	                left: left,
	                width: width,
	                height: 0
	            },
	            end: {
	                top: endTop,
	                left: left,
	                width: width,
	                height: height
	            }
	        };
	    },

	    /**
	     * Make column chart bound.
	     * @param {{
	     *      baseBarSize: number,
	     *      groupSize: number,
	     *      barSize: number,
	     *      pointInterval: number,
	     *      firstAdditionalPosition: number,
	     *      basePosition: number
	     * }} baseData base data for making bound
	     * @param {{
	     *      baseLeft: number,
	     *      left: number,
	     *      plusTop: number,
	     *      minusTop: number,
	     *      prevStack: ?string
	     * }} iterationData iteration data
	     * @param {?boolean} isStackType whether stackType option or not.
	     * @param {SeriesItem} seriesItem series item
	     * @param {number} index index
	     * @returns {{
	     *      start: {left: number, top: number, width: number, height: number},
	     *      end: {left: number, top: number, width: number, height: number}
	     * }}
	     * @private
	     */
	    _makeColumnChartBound: function(baseData, iterationData, isStackType, seriesItem, index) {
	        var barHeight = Math.abs(baseData.baseBarSize * seriesItem.ratioDistance);
	        var barStartTop = baseData.baseBarSize * seriesItem.startRatio;
	        var startTop = baseData.basePosition + barStartTop + chartConst.SERIES_EXPAND_SIZE;
	        var changedStack = (seriesItem.stack !== iterationData.prevStack);
	        var pointCount, endTop, bound, boundLeft;

	        if (!isStackType || (!this.options.diverging && changedStack)) {
	            pointCount = isStackType ? this.dataProcessor.findStackIndex(seriesItem.stack) : index;
	            iterationData.left = iterationData.baseLeft + (baseData.pointInterval * pointCount);
	            iterationData.plusTop = 0;
	            iterationData.minusTop = 0;
	        }

	        if (seriesItem.value >= 0) {
	            iterationData.plusTop -= barHeight;
	            endTop = startTop + iterationData.plusTop;
	        } else {
	            endTop = startTop + iterationData.minusTop;
	            iterationData.minusTop += barHeight;
	        }

	        iterationData.prevStack = seriesItem.stack;
	        boundLeft = iterationData.left + baseData.pointInterval - (baseData.barSize / 2);
	        bound = this._makeBound(baseData.barSize, barHeight, boundLeft, startTop, endTop);

	        return bound;
	    },

	    /**
	     * Make bounds of column chart.
	     * @returns {Array.<Array.<object>>} bounds
	     * @private
	     */
	    _makeBounds: function() {
	        var self = this;
	        var seriesDataModel = this._getSeriesDataModel();
	        var isStackType = predicate.isValidStackOption(this.options.stackType);
	        var dimension = this.layout.dimension;
	        var baseData = this._makeBaseDataForMakingBound(dimension.width, dimension.height);

	        return seriesDataModel.map(function(seriesGroup, groupIndex) {
	            var baseLeft = (groupIndex * baseData.groupSize) + self.layout.position.left;
	            var iterationData = {
	                baseLeft: baseLeft,
	                left: baseLeft,
	                plusTop: 0,
	                minusTop: 0,
	                prevStack: null
	            };
	            var iteratee = snippet.bind(self._makeColumnChartBound, self, baseData, iterationData, isStackType);

	            return seriesGroup.map(iteratee);
	        });
	    },

	    /**
	     * Calculate left position of sum label.
	     * @param {{left: number, top: number}} bound bound
	     * @param {string} formattedSum formatted sum.
	     * @returns {number} left position value
	     * @private
	     */
	    _calculateLeftPositionOfSumLabel: function(bound, formattedSum) {
	        var labelWidth = renderUtil.getRenderedLabelWidth(formattedSum, this.theme.label);

	        return bound.left + ((bound.width - labelWidth + chartConst.TEXT_PADDING) / 2);
	    }
	});

	BarTypeSeriesBase.mixin(ColumnChartSeries);

	function columnSeriesFactory(params) {
	    var libType = params.chartOptions.libType;
	    var chartTheme = params.chartTheme;

	    params.libType = libType;
	    params.chartType = 'column';
	    params.chartBackground = chartTheme.chart.background;

	    return new ColumnChartSeries(params);
	}

	columnSeriesFactory.componentType = 'series';
	columnSeriesFactory.ColumnChartSeries = ColumnChartSeries;

	module.exports = columnSeriesFactory;


/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Line chart series component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var LineTypeSeriesBase = __webpack_require__(86);
	var snippet = __webpack_require__(6);

	var LineChartSeries = snippet.defineClass(Series, /** @lends LineChartSeries.prototype */ {
	    /**
	     * Line chart series component.
	     * @constructs LineChartSeries
	     * @private
	     * @extends Series
	     * @mixes LineTypeSeriesBase
	     * @param {object} params parameters
	     *      @param {object} params.model series model
	     *      @param {object} params.options series options
	     *      @param {object} params.theme series theme
	     */
	    init: function() {
	        Series.apply(this, arguments);

	        /**
	         * object for requestAnimationFrame
	         * @type {null | {id: number}}
	         */
	        this.movingAnimation = null;
	    },

	    /**
	     * Make positions for rendering graph and sending to mouse event detector.
	     * @param {number} [seriesWidth] - series width
	     * @returns {Array.<Array.<{left: number, top: number}>>} positions
	     * @private
	     */
	    _makePositions: function(seriesWidth) {
	        return this._makeBasicPositions(seriesWidth);
	    },

	    /**
	     * Make series data for rendering graph and sending to mouse event detector.
	     * @returns {object} series data
	     * @private
	     * @override
	     */
	    _makeSeriesData: function() {
	        var groupPositions = this._makePositions();

	        return {
	            chartBackground: this.chartBackground,
	            groupPositions: groupPositions,
	            isAvailable: function() {
	                return groupPositions && groupPositions.length > 0;
	            }
	        };
	    },

	    /**
	     * Rerender.
	     * @param {object} data - data for rerendering
	     * @override
	     */
	    rerender: function(data) {
	        var paper;

	        this._cancelMovingAnimation();

	        paper = Series.prototype.rerender.call(this, data);

	        return paper;
	    }
	});

	LineTypeSeriesBase.mixin(LineChartSeries);

	function lineSeriesFactory(params) {
	    var libType = params.chartOptions.libType;
	    var chartTheme = params.chartTheme;

	    params.libType = libType;
	    params.chartType = 'line';
	    params.chartBackground = chartTheme.chart.background;

	    return new LineChartSeries(params);
	}

	lineSeriesFactory.componentType = 'series';

	module.exports = lineSeriesFactory;


/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview LineTypeSeriesBase is base class for line type series.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var arrayUtil = __webpack_require__(10);
	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var calculator = __webpack_require__(45);
	var renderUtil = __webpack_require__(7);
	var snippet = __webpack_require__(6);

	/**
	 * @classdesc LineTypeSeriesBase is base class for line type series.
	 * @class LineTypeSeriesBase
	 * @private
	 * @mixin
	 * @private */
	var LineTypeSeriesBase = snippet.defineClass(/** @lends LineTypeSeriesBase.prototype */ {
	    /**
	     * Make positions for default data type.
	     * @param {number} [seriesWidth] - width of series area
	     * @returns {Array.<Array.<object>>}
	     * @private
	     */
	    _makePositionsForDefaultType: function(seriesWidth) {
	        var dimension = this.layout.dimension;
	        var seriesDataModel = this._getSeriesDataModel();
	        var width = seriesWidth || dimension.width || 0;
	        var height = dimension.height;
	        var len = seriesDataModel.getGroupCount();
	        var baseTop = this.layout.position.top;
	        var baseLeft = this.layout.position.left;
	        var step;

	        if (this.aligned) {
	            step = width / (len > 1 ? (len - 1) : len);
	        } else {
	            step = width / len;
	            baseLeft += (step / 2);
	        }

	        return seriesDataModel.map(function(seriesGroup) {
	            return seriesGroup.map(function(seriesItem, index) {
	                var position;

	                if (!snippet.isNull(seriesItem.end)) {
	                    position = {
	                        left: baseLeft + (step * index),
	                        top: baseTop + height - (seriesItem.ratio * height)
	                    };

	                    if (snippet.isExisty(seriesItem.startRatio)) {
	                        position.startTop = baseTop + height - (seriesItem.startRatio * height);
	                    }
	                }

	                return position;
	            });
	        }, true);
	    },

	    /**
	     * Make positions for coordinate data type.
	     * @param {number} [seriesWidth] - width of series area
	     * @returns {Array.<Array.<object>>}
	     * @private
	     */
	    _makePositionForCoordinateType: function(seriesWidth) {
	        var dimension = this.layout.dimension;
	        var seriesDataModel = this._getSeriesDataModel();
	        var width = seriesWidth || dimension.width || 0;
	        var height = dimension.height;
	        var xAxis = this.axisDataMap.xAxis;
	        var additionalLeft = 0;
	        var baseTop = this.layout.position.top;
	        var baseLeft = this.layout.position.left;

	        if (xAxis.sizeRatio) {
	            additionalLeft = calculator.multiply(width, xAxis.positionRatio);
	            width = calculator.multiply(width, xAxis.sizeRatio);
	        }

	        return seriesDataModel.map(function(seriesGroup) {
	            return seriesGroup.map(function(seriesItem) {
	                var position;

	                if (!snippet.isNull(seriesItem.end)) {
	                    position = {
	                        left: baseLeft + (seriesItem.ratioMap.x * width) + additionalLeft,
	                        top: baseTop + height - (seriesItem.ratioMap.y * height)
	                    };

	                    if (snippet.isExisty(seriesItem.ratioMap.start)) {
	                        position.startTop =
	                            height - (seriesItem.ratioMap.start * height) + chartConst.SERIES_EXPAND_SIZE;
	                    }
	                }

	                return position;
	            });
	        }, true);
	    },

	    /**
	     * Make basic positions for rendering line graph.
	     * @param {number} [seriesWidth] - width of series area
	     * @returns {Array.<Array.<object>>}
	     * @private
	     */
	    _makeBasicPositions: function(seriesWidth) {
	        var positions;

	        if (this.dataProcessor.isCoordinateType()) {
	            positions = this._makePositionForCoordinateType(seriesWidth);
	        } else {
	            positions = this._makePositionsForDefaultType(seriesWidth);
	        }

	        return positions;
	    },

	    /**
	     * Calculate label position top.
	     * @param {{top: number, startTop: number}} basePosition - base position
	     * @param {number} value - value of seriesItem
	     * @param {number} labelHeight - label height
	     * @param {boolean} [isStart] - whether start value of seriesItem or not
	     * @returns {number} position top
	     * @private
	     */
	    _calculateLabelPositionTop: function(basePosition, value, labelHeight, isStart) {
	        var baseTop = basePosition.top,
	            top;

	        if (predicate.isValidStackOption(this.options.stackType)) {
	            top = ((basePosition.startTop + baseTop - labelHeight) / 2) + 1;
	        } else if ((value >= 0 && !isStart) || (value < 0 && isStart)) {
	            top = baseTop - labelHeight - chartConst.SERIES_LABEL_PADDING;
	        } else {
	            top = baseTop + chartConst.SERIES_LABEL_PADDING;
	        }

	        return top;
	    },

	    /**
	     * Make label position for rendering label of series area.
	     * @param {{left: number, top: number, startTop: ?number}} basePosition - base position for calculating
	     * @param {number} labelHeight - label height
	     * @param {(string | number)} label - label of seriesItem
	     * @param {number} value - value of seriesItem
	     * @param {boolean} [isStart] - whether start label position or not
	     * @returns {{left: number, top: number}}
	     * @private
	     */
	    _makeLabelPosition: function(basePosition, labelHeight, label, value, isStart) {
	        return {
	            left: basePosition.left,
	            top: this._calculateLabelPositionTop(basePosition, value, labelHeight / 2, isStart)

	        };
	    },

	    /**
	     * Get label positions for line type chart
	     * @param {object} seriesDataModel series data model
	     * @param {object} theme label theme
	     * @returns {object}
	     * @private
	     */
	    _getLabelPositions: function(seriesDataModel, theme) {
	        var self = this;
	        var basePositions = arrayUtil.pivot(this.seriesData.groupPositions);
	        var labelHeight = renderUtil.getRenderedLabelHeight(chartConst.MAX_HEIGHT_WORD, theme);

	        return seriesDataModel.map(function(seriesGroup, groupIndex) {
	            return seriesGroup.map(function(seriesItem, index) {
	                var basePosition = basePositions[groupIndex][index];
	                var end = self._makeLabelPosition(basePosition, labelHeight, seriesItem.endLabel, seriesItem.end);
	                var position = {
	                    end: end
	                };

	                if (seriesItem.isRange) {
	                    basePosition.top = basePosition.startTop;
	                    position.start =
	                        self._makeLabelPosition(basePosition, labelHeight, seriesItem.startLabel, seriesItem.start);
	                }

	                return position;
	            });
	        });
	    },

	    /**
	     * Get label texts
	     * @param {object} seriesDataModel sereis data model
	     * @returns {Array.<string>}
	     * @private
	     */
	    _getLabelTexts: function(seriesDataModel) {
	        return seriesDataModel.map(function(seriesGroup) {
	            return seriesGroup.map(function(seriesDatum) {
	                var label = {
	                    end: seriesDatum.endLabel
	                };

	                if (seriesDatum.isRange) {
	                    label.start = seriesDatum.startLabel;
	                }

	                return label;
	            });
	        });
	    },

	    /**
	     * Render series label.
	     * @param {object} paper paper
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderSeriesLabel: function(paper) {
	        var theme = this.theme.label;
	        var seriesDataModel = this._getSeriesDataModel();
	        var groupLabels = this._getLabelTexts(seriesDataModel);
	        var positionsSet = this._getLabelPositions(seriesDataModel, theme);

	        return this.graphRenderer.renderSeriesLabel(paper, positionsSet, groupLabels, theme);
	    },

	    /**
	     * To call showGroupTooltipLine function of graphRenderer.
	     * @param {{
	     *      dimension: {width: number, height: number},
	     *      position: {left: number, top: number}
	     * }} bound bound
	     */
	    onShowGroupTooltipLine: function(bound) {
	        if (!this.graphRenderer.showGroupTooltipLine) {
	            return;
	        }

	        this.graphRenderer.showGroupTooltipLine(bound, this.layout);
	    },

	    /**
	     * To call hideGroupTooltipLine function of graphRenderer.
	     */
	    onHideGroupTooltipLine: function() {
	        if (!this.seriesData
	            || !this.seriesData.isAvailable()
	            || !this.graphRenderer.hideGroupTooltipLine
	        ) {
	            return;
	        }
	        this.graphRenderer.hideGroupTooltipLine();
	    },

	    /**
	     * Zoom by mouse drag.
	     * @param {object} data - data
	     */
	    zoom: function(data) {
	        this._cancelMovingAnimation();
	        this._clearSeriesContainer(data.paper);
	        this._setDataForRendering(data);
	        this._renderSeriesArea(data.paper, snippet.bind(this._renderGraph, this));
	        this.animateComponent(true);

	        if (!snippet.isNull(this.selectedLegendIndex)) {
	            this.graphRenderer.selectLegend(this.selectedLegendIndex);
	        }
	    },

	    /**
	     * Whether changed or not.
	     * @param {{min: number, max: number}} before - before limit
	     * @param {{min: number, max: number}} after - after limit
	     * @returns {boolean}
	     * @private
	     */
	    _isChangedLimit: function(before, after) {
	        return before.min !== after.min || before.max !== after.max;
	    },

	    /**
	     * Whether changed axis limit(min, max) or not.
	     * @returns {boolean}
	     * @private
	     */
	    _isChangedAxisLimit: function() {
	        var beforeAxisDataMap = this.beforeAxisDataMap;
	        var axisDataMap = this.axisDataMap;
	        var changed = true;

	        if (beforeAxisDataMap) {
	            changed = this._isChangedLimit(beforeAxisDataMap.yAxis.limit, axisDataMap.yAxis.limit);

	            if (axisDataMap.xAxis.limit) {
	                changed = changed || this._isChangedLimit(beforeAxisDataMap.xAxis.limit, axisDataMap.xAxis.limit);
	            }
	        }

	        this.beforeAxisDataMap = axisDataMap;

	        return changed;
	    },

	    /**
	     * Animate for motion of series area.
	     * @param {function} callback - callback function
	     * @private
	     */
	    _animate: function(callback) {
	        var self = this;
	        var duration = chartConst.ADDING_DATA_ANIMATION_DURATION;
	        var changedLimit = this._isChangedAxisLimit();

	        if (changedLimit && this.seriesLabelContainer) {
	            this.seriesLabelContainer.innerHTML = '';
	        }

	        if (!callback) {
	            return;
	        }

	        this.movingAnimation = renderUtil.startAnimation(duration, callback, function() {
	            self.movingAnimation = null;
	        });
	    },

	    /**
	     * Make top of zero point for adding data.
	     * @returns {number}
	     * @private
	     * @override
	     */
	    _makeZeroTopForAddingData: function() {
	        var seriesHeight = this.layout.dimension.height;
	        var limit = this.axisDataMap.yAxis.limit;

	        return this._getLimitDistanceFromZeroPoint(seriesHeight, limit).toMax + chartConst.SERIES_EXPAND_SIZE;
	    },

	    /**
	     * Animate for adding data.
	     * @param {{tickSize: number}} data - parameters for adding data.
	     */
	    animateForAddingData: function(data) {
	        var dimension = this.dimensionMap.extendedSeries;
	        var seriesWidth = this.layout.dimension.width;
	        var tickSize = data.tickSize;
	        var shiftingOption = this.options.shifting;
	        var seriesData, paramsForRendering, groupPositions, zeroTop;

	        this.limit = data.limitMap[this.chartType];
	        this.axisDataMap = data.axisDataMap;

	        seriesData = this._makeSeriesData();
	        paramsForRendering = this._makeParamsForGraphRendering(dimension, seriesData);

	        if (shiftingOption) {
	            seriesWidth += tickSize;
	        }

	        groupPositions = this._makePositions(seriesWidth);
	        zeroTop = this._makeZeroTopForAddingData();

	        this.graphRenderer.animateForAddingData(paramsForRendering, tickSize, groupPositions, shiftingOption, zeroTop);
	    },

	    /**
	     * Cancel moving animation.
	     * @private
	     */
	    _cancelMovingAnimation: function() {
	        if (this.movingAnimation) {
	            cancelAnimationFrame(this.movingAnimation.id);
	            this.movingAnimation = null;
	        }
	    }
	});

	LineTypeSeriesBase.mixin = function(func) {
	    snippet.extend(func.prototype, LineTypeSeriesBase.prototype);
	};

	module.exports = LineTypeSeriesBase;


/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Radial chart series component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var chartConst = __webpack_require__(8);
	var geom = __webpack_require__(49);
	var snippet = __webpack_require__(6);

	var RadialChartSeries = snippet.defineClass(Series, /** @lends RadialChartSeries.prototype */ {
	    /**
	     * Line chart series component.
	     * @constructs RadialChartSeries
	     * @private
	     * @extends Series
	     * @param {object} params parameters
	     *      @param {object} params.model series model
	     *      @param {object} params.options series options
	     *      @param {object} params.theme series theme
	     */
	    init: function() {
	        Series.apply(this, arguments);

	        this.options = snippet.extend({
	            showDot: true,
	            showArea: true
	        }, this.options);

	        /**
	         * object for requestAnimationFrame
	         * @type {null | {id: number}}
	         */
	        this.movingAnimation = null;

	        this.drawingType = chartConst.COMPONENT_TYPE_RAPHAEL;
	    },

	    /**
	     * Make positions data for radial series
	     * @param {Array.<Array>} seriesGroups series data per category
	     * @param {number} groupCount category count
	     * @returns {Array.<Array.<object>>}
	     * @private
	     */
	    _makePositionsForRadial: function(seriesGroups, groupCount) {
	        var layout = this.layout;
	        var dimension = layout.dimension;
	        var width = dimension.width - chartConst.RADIAL_PLOT_PADDING - chartConst.RADIAL_MARGIN_FOR_CATEGORY;
	        var height = dimension.height - chartConst.RADIAL_PLOT_PADDING - chartConst.RADIAL_MARGIN_FOR_CATEGORY;
	        var centerX = (width / 2) + (chartConst.RADIAL_PLOT_PADDING / 2) + (chartConst.RADIAL_MARGIN_FOR_CATEGORY / 2)
	            + layout.position.left;
	        var centerY = (height / 2) - (chartConst.RADIAL_PLOT_PADDING / 2) - (chartConst.RADIAL_MARGIN_FOR_CATEGORY / 2)
	            - layout.position.top;

	        var stepAngle = 360 / groupCount;
	        var radius;

	        radius = Math.min(width, height) / 2;

	        return snippet.map(seriesGroups, function(seriesGroup) {
	            var positions = snippet.map(seriesGroup, function(seriesItem, index) {
	                var position, y, angle, point, valueSize;

	                if (!snippet.isNull(seriesItem.end)) {
	                    valueSize = seriesItem.ratio * radius;

	                    // center y + real vaule size
	                    y = centerY + valueSize;

	                    // turn angle to clockwise
	                    angle = 360 - (stepAngle * index);

	                    point = geom.rotatePointAroundOrigin(centerX, centerY, centerX, y, angle);

	                    position = {
	                        left: point.x,
	                        top: height - point.y // convert y coordinate to top
	                    };
	                }

	                return position;
	            });

	            positions.push(positions[0]);

	            return positions;
	        }, true);
	    },

	    /**
	     * Get pivoted seriesGroups
	     * @returns {Array.<Array>} series group
	     * @private
	     */
	    _getSeriesGroups: function() {
	        var seriesDataModel = this._getSeriesDataModel();

	        return seriesDataModel.map(function(group) {
	            return group.map(function(item) {
	                return item;
	            });
	        }, true);
	    },

	    /**
	     * Make series data for rendering graph and sending to mouse event detector.
	     * @returns {object} series data
	     * @private
	     * @override
	     */
	    _makeSeriesData: function() {
	        var groups = this._getSeriesGroups();
	        var groupPositions = this._makePositionsForRadial(groups, this._getSeriesDataModel().getGroupCount());

	        return {
	            groupPositions: groupPositions,
	            isAvailable: function() {
	                return groupPositions && groupPositions.length > 0;
	            }
	        };
	    },

	    /**
	     * Rerender.
	     * @param {object} data - data for rerendering
	     * @returns {Raphael.Paper} raphael paper
	     * @override
	     */
	    rerender: function(data) {
	        return Series.prototype.rerender.call(this, data);
	    }
	});

	function radialSeriesFactory(params) {
	    var chartType = params.chartOptions.chartType;
	    var libType = params.chartOptions.libType;
	    var chartTheme = params.chartTheme;

	    params.libType = libType;
	    params.chartType = chartType;
	    params.chartBackground = chartTheme.background;

	    return new RadialChartSeries(params);
	}

	radialSeriesFactory.componentType = 'series';
	radialSeriesFactory.RadialChartSeries = RadialChartSeries;

	module.exports = radialSeriesFactory;


/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Area chart series component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var LineTypeSeriesBase = __webpack_require__(86);
	var predicate = __webpack_require__(11);
	var snippet = __webpack_require__(6);

	var AreaChartSeries = snippet.defineClass(Series, /** @lends AreaChartSeries.prototype */ {
	    /**
	     * Area chart series component.
	     * @constructs AreaChartSeries
	     * @private
	     * @extends Series
	     * @mixes LineTypeSeriesBase
	     */
	    init: function() {
	        Series.apply(this, arguments);

	        /**
	         * object for requestAnimationFrame
	         * @type {null | {id: number}}
	         */
	        this.movingAnimation = null;
	    },

	    /**
	     * Make position top of zero point.
	     * @returns {number} position top
	     * @private
	     */
	    _makePositionTopOfZeroPoint: function() {
	        var dimension = this.layout.dimension;
	        var limit = this.axisDataMap.yAxis.limit;
	        var baseTop = this.layout.position.top;
	        var top = this._getLimitDistanceFromZeroPoint(dimension.height, limit).toMax + baseTop;

	        if (limit.min >= 0 && !top) {
	            top = dimension.height;
	        }

	        return top;
	    },

	    /**
	     * Make positions, when has stackType option.
	     * @param {Array.<Array.<{left: number, top: number}>>} groupPositions group positions
	     * @returns {Array.<Array.<{left: number, top: number, startTop: number}>>} stackType positions
	     * @private
	     */
	    _makeStackedPositions: function(groupPositions) {
	        var height = this.layout.dimension.height;
	        var baseTop = this.layout.position.top;
	        var firstStartTop = this._makePositionTopOfZeroPoint();
	        var prevPositionTops = [];

	        return snippet.map(groupPositions, function(positions) {
	            return snippet.map(positions, function(position, index) {
	                var prevTop = prevPositionTops[index] || firstStartTop;
	                var positionTop = position ? position.top : 0;
	                var stackedHeight = height - positionTop + baseTop;
	                var top = position ? prevTop - stackedHeight : prevTop;

	                if (position) {
	                    position.startTop = prevTop;
	                    position.top = top;
	                }

	                prevPositionTops[index] = top;

	                return position;
	            });
	        });
	    },

	    /**
	     * Make series positions.
	     * @param {number} seriesWidth - width of series area
	     * @returns {Array.<Array.<{left: number, top: number, startTop: number}>>} stackType positions
	     * @private
	     */
	    _makePositions: function(seriesWidth) {
	        var groupPositions = this._makeBasicPositions(seriesWidth);

	        if (predicate.isValidStackOption(this.options.stackType)) {
	            groupPositions = this._makeStackedPositions(groupPositions);
	        }

	        return groupPositions;
	    },

	    /**
	     * Make series data.
	     * @returns {object} series data
	     * @private
	     * @override
	     */
	    _makeSeriesData: function() {
	        var dimension = this.layout.dimension;
	        var baseTop = this.layout.position.top;
	        var zeroTop = this._getLimitDistanceFromZeroPoint(dimension.height, this.limit).toMax + baseTop;
	        var groupPositions = this._makePositions();

	        return {
	            chartBackground: this.chartBackground,
	            groupPositions: groupPositions,
	            hasRangeData: this._getSeriesDataModel().hasRangeData(),
	            zeroTop: zeroTop,
	            isAvailable: function() {
	                return groupPositions && groupPositions.length > 0;
	            }
	        };
	    },

	    /**
	     * Rerender.
	     * @param {object} data - data for rerendering
	     * @override
	     */
	    rerender: function(data) {
	        var paper;

	        this._cancelMovingAnimation();

	        paper = Series.prototype.rerender.call(this, data);

	        return paper;
	    }
	});

	LineTypeSeriesBase.mixin(AreaChartSeries);

	function areaSeriesFactory(params) {
	    var libType = params.chartOptions.libType;
	    var chartTheme = params.chartTheme;

	    params.libType = libType;
	    params.chartType = 'area';
	    params.chartBackground = chartTheme.chart.background;

	    return new AreaChartSeries(params);
	}

	areaSeriesFactory.componentType = 'series';
	areaSeriesFactory.AreaChartSeries = AreaChartSeries;

	module.exports = areaSeriesFactory;


/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Bubble chart series component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var Series = __webpack_require__(81);
	var CoordinateTypeSeriesBase = __webpack_require__(90);
	var snippet = __webpack_require__(6);

	var BubbleChartSeries = snippet.defineClass(Series, /** @lends BubbleChartSeries.prototype */ {
	    /**
	     * Bubble chart series component.
	     * @constructs BubbleChartSeries
	     * @private
	     * @extends Series
	     */
	    init: function() {
	        /**
	         * previous clicked index.
	         * @type {?number}
	         */
	        this.prevClickedIndex = null;

	        /**
	         * max radius for rendering circle graph
	         * @type {null|number}
	         */
	        this.maxRadius = null;

	        this.drawingType = chartConst.COMPONENT_TYPE_RAPHAEL;

	        Series.apply(this, arguments);
	    },

	    /**
	     * Calculate step value for label axis.
	     * @returns {number}
	     * @private
	     */
	    _calculateStep: function() {
	        var step = 0;
	        var dimension, size, len;
	        var hasVerticalCategory = this.dataProcessor.isXCountGreaterThanYCount(this.chartType);

	        if (this.dataProcessor.hasCategories(hasVerticalCategory)) {
	            dimension = this.layout.dimension;
	            len = this.dataProcessor.getCategoryCount(hasVerticalCategory);

	            if (hasVerticalCategory) {
	                size = dimension.height;
	            } else {
	                size = dimension.width;
	            }

	            step = size / len;
	        }

	        return step;
	    },

	    /**
	     * Make bound for bubble chart.
	     * @param {{x: number, y: number, r: number}} ratioMap - ratio map
	     * @param {number} positionByStep - position value by step
	     * @param {number} maxRadius - max radius
	     * @returns {{left: number, top: number, radius: number}}
	     * @private
	     */
	    _makeBound: function(ratioMap, positionByStep, maxRadius) {
	        var dimension = this.layout.dimension;
	        var position = this.layout.position;
	        var left = snippet.isExisty(ratioMap.x) ? (ratioMap.x * dimension.width) : positionByStep;
	        var top = snippet.isExisty(ratioMap.y) ? (ratioMap.y * dimension.height) : positionByStep;

	        return {
	            left: position.left + left,
	            top: position.top + dimension.height - top,
	            radius: Math.max(maxRadius * ratioMap.r, 2)
	        };
	    },

	    /**
	     * Make bounds for bubble chart.
	     * @returns {Array.<Array.<{left: number, top: number, radius: number}>>} positions
	     * @private
	     */
	    _makeBounds: function() {
	        var self = this;
	        var seriesDataModel = this._getSeriesDataModel();
	        var maxRadius = this.maxRadius;
	        var step = this._calculateStep();
	        var start = step ? step / 2 : 0;

	        return seriesDataModel.map(function(seriesGroup, index) {
	            var positionByStep = start + (step * index);

	            return seriesGroup.map(function(seriesItem) {
	                var hasRationMap = (seriesItem && seriesItem.ratioMap);

	                return hasRationMap ? self._makeBound(seriesItem.ratioMap, positionByStep, maxRadius) : null;
	            });
	        });
	    },

	    /**
	     * Set data for rendering.
	     * @param {{
	     *      paper: ?object,
	     *      limit: {
	     *          min: number,
	     *          max: number
	     *      },
	     *      aligned: boolean,
	     *      layout: {
	     *          dimension: {width: number, height: number},
	     *          position: {left: number, top: number}
	     *      },
	     *      dimensionMap: object,
	     *      positionMap: object,
	     *      axisDataMap: object,
	     *      maxRadius: number
	     * }} data - data for rendering
	     * @private
	     */
	    _setDataForRendering: function(data) {
	        this.maxRadius = data.maxRadius;
	        Series.prototype._setDataForRendering.call(this, data);
	    }
	});

	CoordinateTypeSeriesBase.mixin(BubbleChartSeries);

	function bubbleSeriesFactory(params) {
	    var libType = params.chartOptions.libType;
	    var chartTheme = params.chartTheme;

	    params.libType = libType;
	    params.chartType = 'bubble';
	    params.chartBackground = chartTheme.chart.background;

	    return new BubbleChartSeries(params);
	}

	bubbleSeriesFactory.componentType = 'series';
	bubbleSeriesFactory.BubbleChartSeries = BubbleChartSeries;

	module.exports = bubbleSeriesFactory;


/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview CoordinateTypeSeriesBase is base class for coordinate type series.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);
	var CoordinateTypeSeriesBase = snippet.defineClass(/** @lends CoordinateTypeSeriesBase.prototype */ {
	    /**
	     * Make series data.
	     * @returns {{
	     *      groupBounds: Array.<Array.<{left: number, top: number, radius: number}>>,
	     *      seriesDataModel: SeriesDataModel
	     * }} series data
	     * @private
	     * @override
	     */
	    _makeSeriesData: function() {
	        var groupBounds = this._makeBounds();

	        return {
	            groupBounds: groupBounds,
	            seriesDataModel: this._getSeriesDataModel(),
	            isAvailable: function() {
	                return groupBounds && groupBounds.length > 0;
	            }
	        };
	    },

	    /**
	     * showTooltip is callback of mouseover event to series element.
	     * @param {object} params parameters
	     *      @param {boolean} params.allowNegativeTooltip whether allow negative tooltip or not
	     * @param {{top:number, left: number, width: number, height: number}} bound graph bound information
	     * @param {number} groupIndex group index
	     * @param {number} index index
	     * @param {{left: number, top: number}} mousePosition mouse position
	     */
	    showTooltip: function(params, bound, groupIndex, index, mousePosition) {
	        this.eventBus.fire('showTooltip', snippet.extend({
	            indexes: {
	                groupIndex: groupIndex,
	                index: index
	            },
	            mousePosition: mousePosition
	        }, params));
	    },

	    /**
	     * hideTooltip is callback of mouseout event to series element.
	     */
	    hideTooltip: function() {
	        this.eventBus.fire('hideTooltip');
	    },

	    /**
	     * Render raphael graph.
	     * @param {{width: number, height: number}} dimension dimension
	     * @param {object} seriesData series data
	     * @param {object} paper paper object
	     * @private
	     * @override
	     */
	    _renderGraph: function(dimension, seriesData, paper) {
	        var showTooltip = snippet.bind(this.showTooltip, this, {
	            chartType: this.chartType
	        });
	        var callbacks = {
	            showTooltip: showTooltip,
	            hideTooltip: snippet.bind(this.hideTooltip, this)
	        };
	        var params = this._makeParamsForGraphRendering(dimension, seriesData);

	        return this.graphRenderer.render(paper, params, callbacks);
	    },

	    /**
	     * If click series, showing selected state.
	     * @param {{left: number, top: number}} position - mouse position
	     */
	    onClickSeries: function(position) {
	        var indexes = this._executeGraphRenderer(position, 'findIndexes');
	        var prevIndexes = this.prevClickedIndexes;
	        var allowSelect = this.options.allowSelect;
	        var shouldSelect;

	        if (indexes && prevIndexes) {
	            this.onUnselectSeries({
	                indexes: prevIndexes
	            });
	            this.prevClickedIndexes = null;
	        }

	        if (!indexes) {
	            return;
	        }

	        shouldSelect = !prevIndexes ||
	            (indexes.index !== prevIndexes.index) || (indexes.groupIndex !== prevIndexes.groupIndex);

	        if (allowSelect && !shouldSelect) {
	            return;
	        }

	        this.onSelectSeries({
	            chartType: this.chartType,
	            indexes: indexes
	        }, shouldSelect);

	        if (allowSelect) {
	            this.prevClickedIndexes = indexes;
	        }
	    },

	    /**
	     * If mouse move series, call 'moveMouseOnSeries' of graph render.
	     * @param {{left: number, top: number}} position mouse position
	     */
	    onMoveSeries: function(position) {
	        this._executeGraphRenderer(position, 'moveMouseOnSeries');
	    }
	});

	CoordinateTypeSeriesBase.mixin = function(func) {
	    snippet.extend(func.prototype, CoordinateTypeSeriesBase.prototype);
	};

	module.exports = CoordinateTypeSeriesBase;


/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Scatter chart series component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var CoordinateTypeSeriesBase = __webpack_require__(90);
	var chartConst = __webpack_require__(8);
	var snippet = __webpack_require__(6);

	var ScatterChartSeries = snippet.defineClass(Series, /** @lends ScatterChartSeries.prototype */ {
	    /**
	     * Scatter chart series component.
	     * @constructs ScatterChartSeries
	     * @private
	     * @extends Series
	     */
	    init: function() {
	        /**
	         * previous clicked index.
	         * @type {?number}
	         */
	        this.prevClickedIndex = null;
	        Series.apply(this, arguments);
	    },

	    /**
	     * Make bound for scatter chart.
	     * @param {{x: number, y: number, r: number}} ratioMap - ratio map
	     * @returns {{left: number, top: number, raius: number}}
	     * @private
	     */
	    _makeBound: function(ratioMap) {
	        var dimension = this.layout.dimension;
	        var basePosition = this.layout.position;

	        return {
	            left: basePosition.left + (ratioMap.x * dimension.width),
	            top: dimension.height - (ratioMap.y * dimension.height) + basePosition.top,
	            radius: chartConst.SCATTER_RADIUS
	        };
	    },

	    /**
	     * Make bounds for scatter chart.
	     * @returns {Array.<Array.<{left: number, top: number, radius: number}>>} positions
	     * @private
	     */
	    _makeBounds: function() {
	        var self = this;
	        var seriesDataModel = this._getSeriesDataModel();

	        return seriesDataModel.map(function(seriesGroup) {
	            return seriesGroup.map(function(seriesItem) {
	                var hasRatioMap = (seriesItem && seriesItem.ratioMap);

	                return hasRatioMap ? self._makeBound(seriesItem.ratioMap) : null;
	            });
	        });
	    }
	});

	CoordinateTypeSeriesBase.mixin(ScatterChartSeries);

	function scatterSeriesFactory(params) {
	    var libType = params.chartOptions.libType;
	    var chartTheme = params.chartTheme;

	    params.libType = libType;
	    params.chartType = 'scatter';
	    params.chartBackground = chartTheme.chart.background;

	    return new ScatterChartSeries(params);
	}

	scatterSeriesFactory.componentType = 'series';
	scatterSeriesFactory.ScatterChartSeries = ScatterChartSeries;

	module.exports = scatterSeriesFactory;


/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Map chart series component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var chartConst = __webpack_require__(8);
	var snippet = __webpack_require__(6);

	var browser = snippet.browser;
	var IS_LTE_IE8 = browser.msie && browser.version <= 8;

	var MapChartSeries = snippet.defineClass(Series, /** @lends MapChartSeries.prototype */ {
	    /**
	     * Map chart series component.
	     * @constructs MapChartSeries
	     * @private
	     * @extends Series
	     * @param {object} params parameters
	     *      @param {object} params.options series options
	     *      @param {object} params.theme series theme
	     *      @param {MapChartDataProcessor} params.dataProcessor data processor for map chart
	     */
	    init: function(params) {
	        /**
	         * Base position.
	         * @type {{left: number, top: number}}
	         */
	        this.basePosition = {
	            left: 0,
	            top: 0
	        };

	        /**
	         * Zoom magnification.
	         * @type {number}
	         */
	        this.zoomMagn = 1;

	        /**
	         * Map ratio.
	         * @type {number}
	         */
	        this.mapRatio = 1;

	        /**
	         * Graph dimension.
	         * @type {{}}
	         */
	        this.graphDimension = {};

	        /**
	         * Limit position.
	         * @type {{}}
	         */
	        this.limitPosition = {};

	        /**
	         * Map model.
	         * @type {MapChartMapModel}
	         */
	        this.mapModel = params.mapModel;

	        /**
	         * Color spectrum
	         * @type {ColorSpectrum}
	         */
	        this.colorSpectrum = params.colorSpectrum;

	        /**
	         * Previous mouse position.
	         * @type {?{left: number, top: number}}
	         */
	        this.prevPosition = null;

	        /**
	         * Previous moved index.
	         * @type {?number}
	         */
	        this.prevMovedIndex = null;

	        /**
	         * Whether drag or not.
	         * @type {boolean}
	         */
	        this.isDrag = false;

	        /**
	         * Start position.
	         * @type {?{left: number, top: number}}
	         */
	        this.startPosition = null;

	        Series.call(this, params);
	    },

	    /**
	     * Attach to event bus.
	     * @private
	     */
	    _attachToEventBus: function() {
	        Series.prototype._attachToEventBus.call(this);

	        if (!IS_LTE_IE8) {
	            this.eventBus.on({
	                dragStartMapSeries: this.onDragStartMapSeries,
	                dragMapSeries: this.onDragMapSeries,
	                dragEndMapSeries: this.onDragEndMapSeries,
	                zoomMap: this.onZoomMap
	            }, this);
	        }
	    },

	    /**
	     * Set map ratio.
	     * @param {object} [graphDimension] graph dimension
	     * @private
	     */
	    _setMapRatio: function(graphDimension) {
	        var seriesDimension = this.layout.dimension;
	        var mapDimension = graphDimension || this.mapModel.getMapDimension();
	        var widthRatio = seriesDimension.width / mapDimension.width;
	        var heightRatio = seriesDimension.height / mapDimension.height;

	        this.mapRatio = Math.min(widthRatio, heightRatio);
	    },

	    /**
	     * Set graph dimension.
	     * @private
	     */
	    _setGraphDimension: function() {
	        var seriesDimension = this.layout.dimension;

	        this.graphDimension = {
	            width: seriesDimension.width * this.zoomMagn,
	            height: seriesDimension.height * this.zoomMagn
	        };
	    },

	    /**
	     * Render series component.
	     * @param {object} data data for rendering
	     */
	    render: function(data) {
	        Series.prototype.render.call(this, data);
	        this._setMapRatio();
	    },

	    /**
	     * Set limit position to move map.
	     * @private
	     */
	    _setLimitPositionToMoveMap: function() {
	        var seriesDimension = this.layout.dimension;
	        var graphDimension = this.graphDimension;

	        this.limitPosition = {
	            left: seriesDimension.width - graphDimension.width,
	            top: seriesDimension.height - graphDimension.height
	        };
	    },

	    /**
	     * Render raphael graph.
	     * @private
	     * @override
	     */
	    _renderGraph: function() {
	        this._setGraphDimension();

	        this._setLimitPositionToMoveMap();

	        this.graphRenderer.render(this.paper, {
	            colorSpectrum: this.colorSpectrum,
	            mapModel: this.mapModel,
	            layout: this.layout,
	            theme: this.theme
	        });
	    },

	    /**
	     * Render series label.
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderSeriesLabel: function() {
	        var labelData = this.mapModel.getLabelData(this.zoomMagn * this.mapRatio);

	        return this.graphRenderer.renderSeriesLabels(this.paper, labelData, this.theme.label);
	    },

	    /**
	     * Render series area.
	     * @param {HTMLElement} seriesContainer series area element
	     * @param {object} data data for rendering
	     * @param {function} funcRenderGraph function for graph rendering
	     * @private
	     */
	    _renderSeriesArea: function(seriesContainer, data, funcRenderGraph) {
	        Series.prototype._renderSeriesArea.call(this, seriesContainer, data, funcRenderGraph);
	    },

	    /**
	     * Adjust map position.
	     * @param {{left: number, top: number}} targetPosition target position
	     * @returns {{left: number, top: number}} adjusted position
	     * @private
	     */
	    _adjustMapPosition: function(targetPosition) {
	        return {
	            left: Math.max(Math.min(targetPosition.left, 0), this.limitPosition.left),
	            top: Math.max(Math.min(targetPosition.top, 0), this.limitPosition.top)
	        };
	    },

	    /**
	     * Update base position for zoom.
	     * @param {{width: number, height: number}} prevDimension previous dimension
	     * @param {{left: number, top: number}} prevLimitPosition previous limit position
	     * @param {number} changedRatio changed ratio
	     * @private
	     */
	    _updateBasePositionForZoom: function(prevDimension, prevLimitPosition, changedRatio) {
	        var prevBasePosition = this.basePosition,
	            prevLeft = prevBasePosition.left - (prevLimitPosition.left / 2),
	            prevTop = prevBasePosition.top - (prevLimitPosition.top / 2),
	            newBasePosition = {
	                left: (prevLeft * changedRatio) + (this.limitPosition.left / 2),
	                top: (prevTop * changedRatio) + (this.limitPosition.top / 2)
	            };

	        this.basePosition = this._adjustMapPosition(newBasePosition);
	    },

	    /**
	     * Zoom.
	     * @param {number} changedRatio changed ratio
	     * @param {object} position position
	     * @private
	     */
	    _zoom: function(changedRatio, position) {
	        var prevDimension = this.graphDimension,
	            prevLimitPosition = this.limitPosition;

	        this._setGraphDimension();

	        this._setLimitPositionToMoveMap();
	        this._updateBasePositionForZoom(prevDimension, prevLimitPosition, changedRatio);

	        this._setMapRatio(this.graphDimension);

	        this.graphRenderer.scaleMapPaths(changedRatio, position, this.mapRatio, prevDimension, prevDimension);
	    },

	    /**
	     * Update positions to resize.
	     * @param {number} prevMapRatio previous ratio
	     * @private
	     */
	    _updatePositionsToResize: function(prevMapRatio) {
	        var changedRatio = this.mapRatio / prevMapRatio;

	        this.basePosition.left *= changedRatio;
	        this.basePosition.top *= changedRatio;

	        this.limitPosition.left *= changedRatio;
	        this.limitPosition.top *= changedRatio;
	    },

	    /**
	     * If click series, showing selected state.
	     * @param {{left: number, top: number}} position - mouse position
	     */
	    onClickSeries: function(position) {
	        var foundIndex = this._executeGraphRenderer(position, 'findSectorIndex');

	        if (!snippet.isNull(foundIndex)) {
	            this.eventBus.fire('selectSeries', {
	                chartType: this.chartType,
	                index: foundIndex,
	                code: this.mapModel.getDatum(foundIndex).code
	            });
	        }
	    },

	    /**
	     * Whether changed position or not.
	     * @param {?{left: number, top: number}} prevPosition previous position
	     * @param {{left: number, top: number}} position position
	     * @returns {boolean} result boolean
	     * @private
	     */
	    _isChangedPosition: function(prevPosition, position) {
	        return !prevPosition || prevPosition.left !== position.left || prevPosition.top !== position.top;
	    },

	    /**
	     * Show wedge of spectrum legend.
	     * @param {number} index map data index
	     * @private
	     */
	    _showWedge: function(index) {
	        var datum = this.mapModel.getDatum(index);

	        if (!snippet.isUndefined(datum.ratio)) {
	            this.eventBus.fire('showWedge', datum.ratio);
	        }
	    },

	    /**
	     * Show tooltip.
	     * @param {number} index map data index
	     * @param {{left: number, top: number}} mousePosition mouse position
	     * @private
	     */
	    _showTooltip: function(index, mousePosition) {
	        this.eventBus.fire('showTooltip', {
	            chartType: this.chartType,
	            indexes: {
	                index: index
	            },
	            mousePosition: {
	                left: mousePosition.left,
	                top: mousePosition.top - chartConst.TOOLTIP_GAP
	            }
	        });
	    },

	    /**
	     * On move series.
	     * @param {{left: number, top: number}} position position
	     */
	    onMoveSeries: function(position) {
	        var foundIndex = this._executeGraphRenderer(position, 'findSectorIndex');

	        if (!snippet.isNull(foundIndex)) {
	            if (this.prevMovedIndex !== foundIndex) {
	                if (!snippet.isNull(this.prevMovedIndex)) {
	                    this.graphRenderer.restoreColor(this.prevMovedIndex);
	                    this.eventBus.fire('hideTooltip');
	                }

	                this.graphRenderer.changeColor(foundIndex);
	            }

	            if (this._isChangedPosition(this.prevPosition, position)) {
	                this._showTooltip(foundIndex, {
	                    left: position.left,
	                    top: position.top
	                });
	                this.prevMovedIndex = foundIndex;
	            }

	            this._showWedge(foundIndex);
	        } else if (!snippet.isNull(this.prevMovedIndex)) {
	            this.graphRenderer.restoreColor(this.prevMovedIndex);
	            this.eventBus.fire('hideTooltip');
	            this.prevMovedIndex = null;
	        }
	        this.prevPosition = position;
	    },

	    /**
	     * On drag start series.
	     * @param {{left: number, top: number}} position position
	     */
	    onDragStartMapSeries: function(position) {
	        this.startPosition = {
	            left: position.left,
	            top: position.top
	        };
	    },

	    /**
	     * Move position.
	     * @param {{left: number, top: number}} startPosition start position
	     * @param {{left: number, top: number}} endPosition end position
	     * @private
	     */
	    _movePosition: function(startPosition, endPosition) {
	        var movementPosition = {
	            x: (endPosition.left - startPosition.left) * this.mapRatio,
	            y: (endPosition.top - startPosition.top) * this.mapRatio
	        };

	        this.graphRenderer.moveMapPaths(movementPosition, this.graphDimension);
	    },

	    /**
	     * On drag series.
	     * @param {{left: number, top: number}} position position
	     */
	    onDragMapSeries: function(position) {
	        this._movePosition(this.startPosition, position);

	        this.startPosition = position;

	        if (!this.isDrag) {
	            this.isDrag = true;
	            this.eventBus.fire('hideTooltip');
	        }
	    },

	    /**
	     * On drag end series.
	     */
	    onDragEndMapSeries: function() {
	        this.isDrag = false;
	    },

	    /**
	     * On zoom map.
	     * @param {number} newMagn new zoom magnification
	     * @param {?{left: number, top: number}} position mouse position
	     */
	    onZoomMap: function(newMagn, position) {
	        var changedRatio = newMagn / this.zoomMagn;
	        var positions = this.layout.position;
	        var layerPosition = position ? position : {
	            left: this.layout.dimension.width / 2,
	            top: this.layout.dimension.height / 2
	        };

	        this.zoomMagn = newMagn;

	        this._zoom(changedRatio, {
	            left: layerPosition.left - positions.left,
	            top: layerPosition.top - positions.top
	        });

	        this.eventBus.fire(chartConst.PUBLIC_EVENT_PREFIX + 'zoom', newMagn);
	    },

	    /**
	     * Make exportation data for public event of series type.
	     * @param {object} seriesData - series data
	     * @returns {{
	     *     chartType: string,
	     *     code: string,
	     *     index: number
	     *     }}
	     * @private
	     */
	    _makeExportationSeriesData: function(seriesData) {
	        return seriesData;
	    }
	});

	function mapSeriesFactory(params) {
	    var libType = params.chartOptions.libType;

	    params.libType = libType;
	    params.chartType = 'map';

	    return new MapChartSeries(params);
	}

	mapSeriesFactory.componentType = 'series';
	mapSeriesFactory.MapChartSeries = MapChartSeries;

	module.exports = mapSeriesFactory;


/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Pie chart series component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var snippet = __webpack_require__(6);
	var raphaelRenderUtil = __webpack_require__(5);

	var PieChartSeries = snippet.defineClass(Series, /** @lends PieChartSeries.prototype */ {
	    /**
	     * Line chart series component.
	     * @constructs PieChartSeries
	     * @private
	     * @extends Series
	     * @param {object} params parameters
	     *      @param {object} params.model series model
	     *      @param {object} params.options series options
	     *      @param {object} params.theme series theme
	     */
	    init: function(params) {
	        Series.call(this, params);

	        this.isCombo = !!params.isCombo;

	        this.isShowOuterLabel = predicate.isShowOuterLabel(this.options);

	        /**
	         * range for quadrant.
	         * @type {?number}
	         */
	        this.quadrantRange = null;

	        /**
	         * previous clicked index.
	         * @type {?number}
	         */
	        this.prevClickedIndex = null;

	        this.drawingType = chartConst.COMPONENT_TYPE_RAPHAEL;

	        this.legendMaxWidth = params.legendMaxWidth;

	        this._setDefaultOptions();
	    },

	    /**
	     * Make valid angle.
	     * @param {number} angle - angle
	     * @param {number} defaultAngle - default angle
	     * @returns {number}
	     * @private
	     */
	    _makeValidAngle: function(angle, defaultAngle) {
	        if (snippet.isUndefined(angle)) {
	            angle = defaultAngle;
	        } else if (angle < 0) {
	            angle = chartConst.ANGLE_360 - (Math.abs(angle) % chartConst.ANGLE_360);
	        } else if (angle > 0) {
	            angle = angle % chartConst.ANGLE_360;
	        }

	        return angle;
	    },

	    /**
	     * Transform radius range.
	     * @param {Array.<number>} radiusRange - radius range
	     * @returns {Array}
	     * @private
	     */
	    _transformRadiusRange: function(radiusRange) {
	        radiusRange = radiusRange || ['0%', '100%'];

	        return snippet.map(radiusRange, function(percent) {
	            var ratio = parseInt(percent, 10) * 0.01;

	            return Math.max(Math.min(ratio, 1), 0);
	        });
	    },

	    /**
	     * Set default options for series of pie type chart.
	     * @private
	     */
	    _setDefaultOptions: function() {
	        var options = this.options;

	        options.startAngle = this._makeValidAngle(options.startAngle, 0);
	        options.endAngle = this._makeValidAngle(options.endAngle, options.startAngle);
	        options.radiusRange = this._transformRadiusRange(options.radiusRange);

	        if (options.radiusRange.length === 1) {
	            options.radiusRange.unshift(0);
	        }
	    },

	    /**
	     * Calculate angle for rendering.
	     * @returns {number}
	     * @private
	     */
	    _calculateAngleForRendering: function() {
	        var startAngle = this.options.startAngle;
	        var endAngle = this.options.endAngle;
	        var renderingAngle;

	        if (startAngle < endAngle) {
	            renderingAngle = endAngle - startAngle;
	        } else if (startAngle > endAngle) {
	            renderingAngle = chartConst.ANGLE_360 - (startAngle - endAngle);
	        } else {
	            renderingAngle = chartConst.ANGLE_360;
	        }

	        return renderingAngle;
	    },

	    /**
	     * Make sectors information.
	     * @param {{cx: number, cy: number, r: number}} circleBound circle bound
	     * @returns {Array.<object>} sectors information
	     * @private
	     */
	    _makeSectorData: function(circleBound) {
	        var self = this;
	        var seriesGroup = this._getSeriesDataModel().getFirstSeriesGroup();
	        var cx = circleBound.cx;
	        var cy = circleBound.cy;
	        var r = circleBound.r;
	        var angle = this.options.startAngle;
	        var angleForRendering = this._calculateAngleForRendering();
	        var delta = 10;
	        var holeRatio = this.options.radiusRange[0];
	        var centerR = r * 0.5;
	        var paths;

	        if (holeRatio) {
	            centerR += centerR * holeRatio;
	        }

	        if (!seriesGroup) {
	            return null;
	        }
	        paths = seriesGroup.map(function(seriesItem) {
	            var ratio = seriesItem ? seriesItem.ratio : 0;
	            var currentAngle = angleForRendering * ratio;
	            var endAngle = angle + currentAngle;
	            var popupAngle = angle + (currentAngle / 2);
	            var angles = {
	                start: {
	                    startAngle: angle,
	                    endAngle: angle
	                },
	                end: {
	                    startAngle: angle,
	                    endAngle: endAngle
	                }
	            };
	            var positionData = {
	                cx: cx,
	                cy: cy,
	                angle: popupAngle
	            };

	            angle = endAngle;

	            return {
	                ratio: ratio,
	                angles: angles,
	                centerPosition: self._getArcPosition(snippet.extend({
	                    r: centerR
	                }, positionData)),
	                outerPosition: {
	                    start: self._getArcPosition(snippet.extend({
	                        r: r
	                    }, positionData)),
	                    middle: self._getArcPosition(snippet.extend({
	                        r: r + delta
	                    }, positionData))
	                }
	            };
	        });

	        return paths;
	    },

	    /**
	     * Make series data.
	     * @returns {{
	     *      chartBackground: string,
	     *      circleBound: ({cx: number, cy: number, r: number}),
	     *      sectorData: Array.<object>
	     * }} add data for graph rendering
	     * @private
	     * @override
	     */
	    _makeSeriesData: function() {
	        var circleBound = this._makeCircleBound();
	        var sectorData = this._makeSectorData(circleBound);

	        return {
	            chartBackground: this.chartBackground,
	            circleBound: circleBound,
	            sectorData: sectorData,
	            isAvailable: function() {
	                return sectorData && sectorData.length > 0;
	            }
	        };
	    },

	    /**
	     * Get quadrant from angle.
	     * @param {number} angle - angle
	     * @param {boolean} isEnd whether end quadrant
	     * @returns {number}
	     * @private
	     */
	    _getQuadrantFromAngle: function(angle, isEnd) {
	        var quadrant = parseInt(angle / chartConst.ANGLE_90, 10) + 1;

	        if (isEnd && (angle % chartConst.ANGLE_90 === 0)) {
	            quadrant += (quadrant === 1) ? 3 : -1;
	        }

	        return quadrant;
	    },

	    /**
	     * Get range for quadrant.
	     * @returns {{start: number, end: number}}
	     * @private
	     */
	    _getRangeForQuadrant: function() {
	        if (!this.quadrantRange) {
	            this.quadrantRange = {
	                start: this._getQuadrantFromAngle(this.options.startAngle),
	                end: this._getQuadrantFromAngle(this.options.endAngle, true)
	            };
	        }

	        return this.quadrantRange;
	    },

	    /**
	     * Whether in range for quadrant.
	     * @param {number} start - start quadrant
	     * @param {number} end - end quadrant
	     * @returns {boolean}
	     * @private
	     */
	    _isInQuadrantRange: function(start, end) {
	        var quadrantRange = this._getRangeForQuadrant();

	        return quadrantRange.start === start && quadrantRange.end === end;
	    },

	    /**
	     * Calculate base size.
	     * @returns {number}
	     * @private
	     */
	    _calculateBaseSize: function() {
	        var dimension = this.layout.dimension;
	        var width = dimension.width;
	        var height = dimension.height;
	        var quadrantRange;

	        if (!this.isCombo) {
	            quadrantRange = this._getRangeForQuadrant();
	            if (this._isInQuadrantRange(2, 3) || this._isInQuadrantRange(4, 1)) {
	                height *= 2;
	            } else if (this._isInQuadrantRange(1, 2) || this._isInQuadrantRange(3, 4)) {
	                width *= 2;
	            } else if (quadrantRange.start === quadrantRange.end) {
	                width *= 2;
	                height *= 2;
	            }
	        }

	        return Math.min(width, height);
	    },

	    /**
	     * Calculate radius.
	     * @returns {number}
	     * @private
	     */
	    _calculateRadius: function() {
	        var radiusRatio = this.isShowOuterLabel ? chartConst.PIE_GRAPH_SMALL_RATIO : chartConst.PIE_GRAPH_DEFAULT_RATIO;
	        var baseSize = this._calculateBaseSize();

	        return baseSize * radiusRatio * this.options.radiusRange[1] / 2;
	    },

	    /**
	     * Calculate center x, y.
	     * @param {number} radius - radius
	     * @returns {{cx: number, cy: number}}
	     * @private
	     */
	    _calculateCenterXY: function(radius) {
	        var dimension = this.layout.dimension;
	        var position = this.layout.position;
	        var halfRadius = radius / 2;
	        var cx = (dimension.width / 2) + position.left;
	        var cy = (dimension.height / 2) + position.top;

	        if (!this.isCombo) {
	            if (this._isInQuadrantRange(1, 1)) {
	                cx -= halfRadius;
	                cy += halfRadius;
	            } else if (this._isInQuadrantRange(1, 2)) {
	                cx -= halfRadius;
	            } else if (this._isInQuadrantRange(2, 2)) {
	                cx -= halfRadius;
	                cy -= halfRadius;
	            } else if (this._isInQuadrantRange(2, 3)) {
	                cy -= halfRadius;
	            } else if (this._isInQuadrantRange(3, 3)) {
	                cx += halfRadius;
	                cy -= halfRadius;
	            } else if (this._isInQuadrantRange(3, 4)) {
	                cx += halfRadius;
	            } else if (this._isInQuadrantRange(4, 1)) {
	                cy += halfRadius;
	            } else if (this._isInQuadrantRange(4, 4)) {
	                cx += halfRadius;
	                cy += halfRadius;
	            }
	        }

	        return {
	            cx: cx,
	            cy: cy
	        };
	    },

	    /**
	     * Make circle bound
	     * @returns {{cx: number, cy: number, r: number}} circle bounds
	     * @private
	     */
	    _makeCircleBound: function() {
	        var radius = this._calculateRadius();
	        var centerXY = this._calculateCenterXY(radius);

	        return snippet.extend({
	            r: radius
	        }, centerXY);
	    },

	    /**
	     * Get arc position.
	     * @param {object} params parameters
	     *      @param {number} params.cx center x
	     *      @param {number} params.cy center y
	     *      @param {number} params.r radius
	     *      @param {number} params.angle angle(degree)
	     * @returns {{left: number, top: number}} arc position
	     * @private
	     */
	    _getArcPosition: function(params) {
	        return {
	            left: params.cx + (params.r * Math.sin(params.angle * chartConst.RAD)),
	            top: params.cy - (params.r * Math.cos(params.angle * chartConst.RAD))
	        };
	    },

	    /**
	     * Render raphael graph.
	     * @param {{width: number, height: number}} dimension dimension
	     * @param {object} seriesData series data
	     * @param {object} paper paper object
	     * @private
	     * @override
	     */
	    _renderGraph: function(dimension, seriesData, paper) {
	        var showTootltip = snippet.bind(this.showTooltip, this, {
	            allowNegativeTooltip: !!this.allowNegativeTooltip,
	            seriesType: this.seriesType,
	            chartType: this.chartType
	        });
	        var callbacks = {
	            showTooltip: showTootltip,
	            hideTooltip: snippet.bind(this.hideTooltip, this)
	        };
	        var params = this._makeParamsForGraphRendering(dimension, seriesData);
	        var currentSeriesName = this.seriesType;
	        var seriesDataModelMap = this.dataProcessor.seriesDataModelMap;
	        var pastSeriesNames = [];
	        var pastIndex = 0;

	        snippet.forEach(this.dataProcessor.seriesTypes, function(seriesType) {
	            var needNext = true;

	            if (seriesType !== currentSeriesName) {
	                pastSeriesNames.push(seriesType);
	            } else {
	                needNext = false;
	            }

	            return needNext;
	        });

	        snippet.forEach(pastSeriesNames, function(seriesType) {
	            pastIndex += seriesDataModelMap[seriesType].baseGroups.length;
	        });

	        params.additionalIndex = pastIndex;

	        return this.graphRenderer.render(paper, params, callbacks);
	    },

	    /**
	     * Resize.
	     * @override
	     */
	    resize: function() {
	        Series.prototype.resize.apply(this, arguments);
	        this._moveLegendLines();
	    },

	    /**
	     * showTooltip is mouseover event callback on series graph.
	     * @param {object} params parameters
	     *      @param {boolean} params.allowNegativeTooltip whether allow negative tooltip or not
	     * @param {{top:number, left: number, width: number, height: number}} bound graph bound information
	     * @param {number} groupIndex group index
	     * @param {number} index index
	     * @param {{left: number, top: number}} mousePosition mouse position
	     */
	    showTooltip: function(params, bound, groupIndex, index, mousePosition) {
	        this.eventBus.fire('showTooltip', snippet.extend({
	            indexes: {
	                groupIndex: groupIndex,
	                index: index
	            },
	            mousePosition: mousePosition
	        }, params));
	    },

	    /**
	     * hideTooltip is mouseout event callback on series graph.
	     */
	    hideTooltip: function() {
	        this.eventBus.fire('hideTooltip');
	    },

	    /**
	     * Make series data by selection.
	     * @param {number} index index
	     * @returns {{indexes: {index: number, groupIndex: number}}} series data
	     * @private
	     */
	    _makeSeriesDataBySelection: function(index) {
	        return {
	            indexes: {
	                index: index,
	                groupIndex: index
	            }
	        };
	    },
	    /**
	     * Get series label.
	     * @param {string} legend - legend name
	     * @param {string} label - label name
	     * @returns {string} series label
	     * @private
	     */
	    _getSeriesLabel: function(legend, label) {
	        var seriesLabel = '';

	        if (this.options.showLegend) {
	            seriesLabel = raphaelRenderUtil.getEllipsisText(legend, this.legendMaxWidth, this.theme.label);
	        }
	        if (this.options.showLabel) {
	            seriesLabel += (seriesLabel ? chartConst.LABEL_SEPARATOR : '') + label;
	        }

	        return seriesLabel;
	    },

	    /**
	     * Pick poistions from sector data.
	     * @param {string} positionType position type
	     * @returns {Array} positions
	     * @private
	     */
	    _pickPositionsFromSectorData: function(positionType) {
	        return snippet.map(this.seriesData.sectorData, function(datum) {
	            return datum.ratio ? datum[positionType] : null;
	        });
	    },

	    /**
	     * Add end position.
	     * @param {number} centerLeft center left
	     * @param {Array.<object>} positions positions
	     * @private
	     */
	    _addEndPosition: function(centerLeft, positions) {
	        snippet.forEachArray(positions, function(position) {
	            var end;

	            if (!position) {
	                return;
	            }

	            end = snippet.extend({}, position.middle);
	            if (end.left < centerLeft) {
	                end.left -= chartConst.SERIES_OUTER_LABEL_PADDING;
	            } else {
	                end.left += chartConst.SERIES_OUTER_LABEL_PADDING;
	            }
	            position.end = end;
	        });
	    },

	    /**
	     * Move to outer position.
	     * @param {number} centerLeft center left
	     * @param {object} position position
	     * @param {string} label label
	     * @returns {{left: number, top: number}} outer position
	     * @private
	     */
	    _moveToOuterPosition: function(centerLeft, position, label) {
	        var positionEnd = position.end;
	        var left = positionEnd.left;
	        var top = positionEnd.top;
	        var OffsetX = (this.graphRenderer.getRenderedLabelWidth(label, this.theme.label) / 2)
	            + chartConst.SERIES_LABEL_PADDING;

	        if (left < centerLeft) {
	            left -= OffsetX;
	        } else {
	            left += OffsetX;
	        }

	        return {
	            left: left,
	            top: top
	        };
	    },

	    /**
	     * get label position infos.
	     * @returns {{centerLeft: number, outerPositions: Array, filteredPositions: Array }} - positionInfo
	     * @private
	     */
	    _getFilterInfos: function() {
	        var centerLeft = this.getSeriesData().circleBound.cx;
	        var outerPositions = this._pickPositionsFromSectorData('outerPosition');
	        var filteredPositions = snippet.filter(outerPositions, function(position) {
	            return position;
	        });

	        return {
	            centerLeft: centerLeft,
	            outerPositions: outerPositions,
	            filteredPositions: filteredPositions
	        };
	    },

	    /**
	     * set series position
	     * @param {object} params position infos
	     * @param {Array.<string>} labels labels array
	     * @returns {Array.<number>}
	     * @private
	     */
	    _setSeriesPosition: function(params, labels) {
	        var positions = [];
	        if (params.funcMoveToPosition) {
	            positions = snippet.map(params.positions, function(position, index) {
	                var outerPosition = null;

	                if (position) {
	                    outerPosition = params.funcMoveToPosition(position, labels[index]);
	                }

	                return outerPosition;
	            });
	        } else {
	            positions = params.positions;
	        }

	        return positions;
	    },

	    /**
	     * Render series label.
	     * @param {object} paper paper
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderSeriesLabel: function(paper) {
	        var positionInfo;
	        var renderOption = {};
	        var positions = [];
	        var dataProcessor = this.dataProcessor;
	        var seriesDataModel = this._getSeriesDataModel();
	        var legendLabels = dataProcessor.getLegendLabels(this.seriesType);
	        var labels = snippet.map(legendLabels, function(legend, index) {
	            return this._getSeriesLabel(legend, seriesDataModel.getSeriesItem(0, index).label);
	        }, this);

	        if (predicate.isLabelAlignOuter(this.options.labelAlign)) {
	            positionInfo = this._getFilterInfos();

	            this._addEndPosition(positionInfo.centerLeft, positionInfo.filteredPositions);
	            this.graphRenderer.renderLegendLines(positionInfo.filteredPositions);

	            renderOption.positions = positionInfo.outerPositions;
	            renderOption.funcMoveToPosition = snippet.bind(this._moveToOuterPosition, this, positionInfo.centerLeft);
	        } else {
	            renderOption.positions = this._pickPositionsFromSectorData('centerPosition');
	        }

	        positions = this._setSeriesPosition(renderOption, labels);

	        return this.graphRenderer.renderLabels(paper, positions, labels, this.theme.label);
	    },

	    /**
	     * Animate series label area.
	     * @override
	     */
	    animateSeriesLabelArea: function() {
	        this.graphRenderer.animateLegendLines(this.selectedLegendIndex);
	        Series.prototype.animateSeriesLabelArea.call(this);
	    },

	    /**
	     * Move legend lines.
	     * @private
	     * @override
	     */
	    _moveLegendLines: function() {
	        var centerLeft = this.dimensionMap.chart.width / 2,
	            outerPositions = this._pickPositionsFromSectorData('outerPosition'),
	            filteredPositions = snippet.filter(outerPositions, function(position) {
	                return position;
	            });

	        this._addEndPosition(centerLeft, filteredPositions);
	        this.graphRenderer.moveLegendLines(filteredPositions);
	    },

	    /**
	     * Whether detected label element or not.
	     * @param {{left: number, top: number}} position - mouse position
	     * @returns {boolean}
	     * @private
	     */
	    _isDetectedLabel: function(position) {
	        var labelElement = document.elementFromPoint(position.left, position.top);

	        return snippet.isString(labelElement.className);
	    },

	    /**
	     * On click series.
	     * @param {{left: number, top: number}} position mouse position
	     */
	    onClickSeries: function(position) {
	        var sectorInfo = this._executeGraphRenderer(position, 'findSectorInfo');
	        var prevIndex = this.prevClickedIndex;
	        var allowSelect = this.options.allowSelect;
	        var foundIndex, shouldSelect;

	        if ((sectorInfo || this._isDetectedLabel(position)) && snippet.isExisty(prevIndex) && allowSelect) {
	            this.onUnselectSeries({
	                indexes: {
	                    index: prevIndex
	                }
	            });
	            this.prevClickedIndex = null;
	        }

	        if (!sectorInfo || sectorInfo.chartType !== this.seriesType) {
	            return;
	        }

	        foundIndex = sectorInfo.index;
	        shouldSelect = foundIndex > -1 && (foundIndex !== prevIndex);

	        if (allowSelect && !shouldSelect) {
	            return;
	        }

	        this.onSelectSeries({
	            chartType: this.chartType,
	            indexes: {
	                index: foundIndex,
	                legendIndex: sectorInfo.legendIndex
	            }
	        }, shouldSelect);

	        if (allowSelect && foundIndex > -1) {
	            this.prevClickedIndex = foundIndex;
	        }
	    },

	    /**
	     * On move series.
	     * @param {{left: number, top: number}} position mouse position
	     */
	    onMoveSeries: function(position) {
	        this._executeGraphRenderer(position, 'moveMouseOnSeries');
	    }
	});

	function pieSeriesFactory(params) {
	    var libType = params.chartOptions.libType;
	    var chartTheme = params.chartTheme;
	    var chartType = params.chartOptions.chartType;
	    var legendOption = params.chartOptions.legend;

	    params.libType = libType;
	    params.chartType = 'pie';

	    if (chartType === 'combo') {
	        // elias series mapping key is used as a seriesType(ex. pie1)
	        // It is now distinguished to follow current structure
	        // elias will not be needed after chart constructor is integrated
	        params.seriesType = params.name.split('Series')[0];
	        params.isCombo = true;
	    }

	    if (legendOption) {
	        params.legendMaxWidth = legendOption.maxWidth;
	    }

	    params.chartBackground = chartTheme.chart.background;

	    return new PieChartSeries(params);
	}

	pieSeriesFactory.componentType = 'series';
	pieSeriesFactory.PieChartSeries = PieChartSeries;

	module.exports = pieSeriesFactory;


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Series component for rendering graph of heatmap chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var labelHelper = __webpack_require__(83);
	var snippet = __webpack_require__(6);

	var HeatmapChartSeries = snippet.defineClass(Series, /** @lends HeatmapChartSeries.prototype */ {
	    /**
	     * Series component for rendering graph of heatmap chart.
	     * @constructs HeatmapChartSeries
	     * @private
	     * @param {object} params - parameters
	     * @extends Series
	     */
	    init: function(params) {
	        /**
	         * Color spectrum
	         * @type {ColorSpectrum}
	         */
	        this.colorSpectrum = params.colorSpectrum;

	        Series.call(this, params);
	    },

	    /**
	     * Make series data for rendering graph and sending to mouse event detector.
	     * @returns {{
	     *      groupBounds: Array.<Array.<{left: number, top: number, radius: number}>>,
	     *      seriesDataModel: SeriesDataModel
	     * }} series data
	     * @private
	     * @override
	     */
	    _makeSeriesData: function() {
	        var groupBounds = this._makeBounds();
	        var seriesDataModel = this._getSeriesDataModel();

	        return {
	            colorSpectrum: this.colorSpectrum,
	            groupBounds: groupBounds,
	            seriesDataModel: seriesDataModel,
	            isAvailable: function() {
	                return groupBounds && groupBounds.length > 0;
	            }
	        };
	    },

	    /**
	     * Make bound for graph rendering.
	     * @param {number} blockWidth - block width
	     * @param {number} blockHeight - block height
	     * @param {number} x - x index
	     * @param {number} y - y index
	     * @returns {{end: {left: number, top: number, width: number, height: number}}}
	     * @private
	     */
	    _makeBound: function(blockWidth, blockHeight, x, y) {
	        var height = this.layout.dimension.height;
	        var left = (blockWidth * x) + this.layout.position.left;
	        var top = height - (blockHeight * (y + 1)) + this.layout.position.top;

	        return {
	            end: {
	                left: left,
	                top: top,
	                width: blockWidth,
	                height: blockHeight
	            }
	        };
	    },

	    /**
	     * Make bounds for graph rendering.
	     * @returns {Array.<Array.<{left: number, top: number, radius: number}>>} positions
	     * @private
	     */
	    _makeBounds: function() {
	        var self = this;
	        var seriesDataModel = this._getSeriesDataModel();
	        var dimension = this.layout.dimension;
	        var blockWidth = dimension.width / this.dataProcessor.getCategoryCount(false);
	        var blockHeight = dimension.height / this.dataProcessor.getCategoryCount(true);

	        return seriesDataModel.map(function(seriesGroup, x) {
	            return seriesGroup.map(function(seriesItem, y) {
	                return self._makeBound(blockWidth, blockHeight, x, y);
	            });
	        });
	    },

	    /**
	     * Call showWedge event of spectrum legend, when call showTooltip event.
	     * @param {{indexes: {groupIndex: number, index: number}}} params - parameters
	     */
	    onShowTooltip: function(params) {
	        var seriesDataModel = this._getSeriesDataModel();
	        var indexes = params.indexes;
	        var ratio = seriesDataModel.getSeriesItem(indexes.groupIndex, indexes.index).ratio;

	        this.eventBus.fire('showWedge', ratio);
	    },

	    /**
	     * Render series label.
	     * @param {object} paper - paper
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderSeriesLabel: function(paper) {
	        var sdm = this._getSeriesDataModel();
	        var boundsSet = this.seriesData.groupBounds;
	        var labelTheme = this.theme.label;
	        var selectedIndex = this.selectedLegendIndex;
	        var positionsSet = labelHelper.boundsToLabelPositions(sdm, boundsSet, labelTheme);
	        var labels = sdm.map(function(datum) {
	            return datum.valuesMap.value;
	        });

	        return this.graphRenderer.renderSeriesLabel(paper, positionsSet, labels, labelTheme, selectedIndex);
	    },

	    /**
	     * Resize.
	     * @override
	     */
	    resize: function() {
	        this.boundMap = null;

	        Series.prototype.resize.apply(this, arguments);
	    },

	    /**
	     * Make exportation data for public event of series type.
	     * @param {object} seriesData - series data
	     * @returns {{x: number, y: number}}
	     * @private
	     */
	    _makeExportationSeriesData: function(seriesData) {
	        return {
	            x: seriesData.indexes.groupIndex,
	            y: seriesData.indexes.index
	        };
	    }
	});

	function heatmapChartSeriesFactory(params) {
	    var libType = params.chartOptions.libType;

	    params.libType = libType;
	    params.chartType = 'heatmap';

	    return new HeatmapChartSeries(params);
	}

	heatmapChartSeriesFactory.componentType = 'series';
	heatmapChartSeriesFactory.HeatmapChartSeries = HeatmapChartSeries;

	module.exports = heatmapChartSeriesFactory;


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Series component for rendering graph of treemap chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var squarifier = __webpack_require__(96);
	var labelHelper = __webpack_require__(83);
	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var snippet = __webpack_require__(6);

	var TreemapChartSeries = snippet.defineClass(Series, /** @lends TreemapChartSeries.prototype */ {
	    /**
	     * Series component for rendering graph of treemap chart.
	     * @constructs TreemapChartSeries
	     * @private
	     * @param {object} params - parameters
	     * @extends Series
	     */
	    init: function(params) {
	        Series.call(this, params);

	        this.theme.borderColor = this.theme.borderColor || chartConst.TREEMAP_DEFAULT_BORDER;

	        /**
	         * root id
	         * @type {string}
	         */
	        this.rootId = chartConst.TREEMAP_ROOT_ID;

	        /**
	         * start depth of seriesItem for rendering graph
	         * @type {number}
	         */
	        this.startDepth = 1;

	        /**
	         * selected group
	         * @type {null | number}
	         */
	        this.selectedGroup = null;

	        /**
	         * bound map
	         * @type {null|object.<string, object>}
	         */
	        this.boundMap = null;

	        /**
	         * color spectrum
	         * @type {ColorSpectrum}
	         */
	        this.colorSpectrum = params.colorSpectrum;

	        this._initOptions();
	    },

	    /**
	     * Initialize options.
	     * @private
	     */
	    _initOptions: function() {
	        this.options.useColorValue = !!this.options.useColorValue;

	        if (snippet.isUndefined(this.options.zoomable)) {
	            this.options.zoomable = !this.options.useColorValue;
	        }

	        if (snippet.isUndefined(this.options.useLeafLabel)) {
	            this.options.useLeafLabel = !this.options.zoomable;
	        }
	    },

	    /**
	     * Make series data.
	     * @returns {{
	     *      groupBounds: object.<string, {left: number, top: number, width: number, height: number}>,
	     *      seriesDataModel: SeriesDataModel
	     * }}
	     * @private
	     * @override
	     */
	    _makeSeriesData: function() {
	        var boundMap = this._getBoundMap();
	        var groupBounds = this._makeBounds(boundMap);

	        return {
	            boundMap: boundMap,
	            groupBounds: groupBounds,
	            seriesDataModel: this._getSeriesDataModel(),
	            startDepth: this.startDepth,
	            isPivot: true,
	            colorSpectrum: this.options.useColorValue ? this.colorSpectrum : null,
	            chartBackground: this.chartBackground,
	            zoomable: this.options.zoomable,
	            isAvailable: function() {
	                return groupBounds && groupBounds.length > 0;
	            }
	        };
	    },

	    /**
	     * Make bound map by dimension.
	     * @param {string | number} parent - parent id
	     * @param {object.<string, {left: number, top: number, width: number, height: number}>} boundMap - bound map
	     * @param {object} layout - layout
	     * @returns {object.<string, {left: number, top: number, width: number, height: number}>}
	     * @private
	     */
	    _makeBoundMap: function(parent, boundMap, layout) {
	        var self = this;
	        var seriesDataModel = this._getSeriesDataModel();
	        var defaultLayout = snippet.extend({}, this.layout.dimension, this.layout.position);
	        var seriesItems;

	        layout = layout || defaultLayout;
	        seriesItems = seriesDataModel.findSeriesItemsByParent(parent);
	        boundMap = snippet.extend(boundMap || {}, squarifier.squarify(layout, seriesItems));

	        snippet.forEachArray(seriesItems, function(seriesItem) {
	            boundMap = self._makeBoundMap(seriesItem.id, boundMap, boundMap[seriesItem.id]);
	        });

	        return boundMap;
	    },

	    /**
	     * Make bounds for rendering graph.
	     * @param {object.<string, {left: number, top: number, width: number, height: number}>} boundMap - bound map
	     * @returns {Array.<Array.<{left: number, top: number, width: number, height: number}>>}
	     * @private
	     */
	    _makeBounds: function(boundMap) {
	        var startDepth = this.startDepth;
	        var seriesDataModel = this._getSeriesDataModel();
	        var isValid;

	        if (this.options.zoomable) {
	            isValid = function(seriesItem) {
	                return seriesItem.depth === startDepth;
	            };
	        } else {
	            isValid = function(seriesItem) {
	                return !seriesItem.hasChild;
	            };
	        }

	        return seriesDataModel.map(function(seriesGroup) {
	            return seriesGroup.map(function(seriesItem) {
	                var bound = boundMap[seriesItem.id];
	                var result = null;

	                if (bound && isValid(seriesItem)) {
	                    result = {
	                        end: bound
	                    };
	                }

	                return result;
	            }, true);
	        }, true);
	    },

	    /**
	     * Get bound map for rendering graph.
	     * @returns {object.<string, {left: number, top: number, width: number, height: number}>}
	     * @private
	     */
	    _getBoundMap: function() {
	        if (!this.boundMap) {
	            this.boundMap = this._makeBoundMap(this.rootId);
	        }

	        return this.boundMap;
	    },

	    /**
	     * Whether should dimmed or not.
	     * @param {SeriesDataModel} seriesDataModel - SeriesDataModel for treemap
	     * @param {SeriesItem} hoverSeriesItem - hover SeriesItem
	     * @param {SeriesItem} seriesItem - target SeriesItem
	     * @returns {boolean}
	     * @private
	     */
	    _shouldDimmed: function(seriesDataModel, hoverSeriesItem, seriesItem) {
	        var shouldTransparent = false;
	        var parent;

	        if (hoverSeriesItem && seriesItem.id !== hoverSeriesItem.id && seriesItem.group === hoverSeriesItem.group) {
	            parent = seriesDataModel.findParentByDepth(seriesItem.id, hoverSeriesItem.depth + 1);

	            if (parent && parent.parent === hoverSeriesItem.id) {
	                shouldTransparent = true;
	            }
	        }

	        return shouldTransparent;
	    },

	    /**
	     * Render series label.
	     * @param {object} paper - paper
	     * @returns {Array.<object>}
	     * @private
	     */
	    _renderSeriesLabel: function(paper) {
	        var seriesDataModel = this._getSeriesDataModel();
	        var boundMap = this._getBoundMap();
	        var labelTheme = this.theme.label;
	        var labelTemplate = this.options.labelTemplate;
	        var positions, seriesItems, labels;

	        if (this.options.useLeafLabel) {
	            seriesItems = seriesDataModel.findLeafSeriesItems(this.selectedGroup);
	        } else {
	            seriesItems = seriesDataModel.findSeriesItemsByDepth(this.startDepth, this.selectedGroup);
	        }

	        labels = snippet.map(seriesItems, function(seriesItem) {
	            var labelText = labelTemplate ? labelTemplate(seriesItem.pickLabelTemplateData()) : seriesItem.label;

	            return labelText;
	        });

	        positions = labelHelper.boundsToLabelPostionsForTreemap(seriesItems, boundMap, labelTheme);

	        return this.graphRenderer.renderSeriesLabelForTreemap(paper, positions, labels, labelTheme);
	    },

	    /**
	     * Resize.
	     * @override
	     */
	    resize: function() {
	        this.boundMap = null;

	        Series.prototype.resize.apply(this, arguments);
	    },

	    /**
	     * Zoom.
	     * @param {string | number} rootId - root id
	     * @param {number} startDepth - start depth
	     * @param {number} group - group
	     * @private
	     */
	    _zoom: function(rootId, startDepth, group) {
	        this._clearSeriesContainer();
	        this.boundMap = null;
	        this.rootId = rootId;
	        this.startDepth = startDepth;
	        this.selectedGroup = group;
	        this._renderSeriesArea(this.paper, snippet.bind(this._renderGraph, this));
	        this.animateComponent(true);
	    },

	    /**
	     * Zoom
	     * @param {{index: number}} data - data for zoom
	     */
	    zoom: function(data) {
	        var detectedIndex = data.index;
	        var seriesDataModel, seriesItem;

	        this.labelSet.remove();

	        if (detectedIndex === -1) {
	            this._zoom(chartConst.TREEMAP_ROOT_ID, 1, null);

	            return;
	        }

	        seriesDataModel = this._getSeriesDataModel();
	        seriesItem = seriesDataModel.getSeriesItem(0, detectedIndex, true);

	        if (!seriesItem || !seriesItem.hasChild) {
	            return;
	        }

	        this._zoom(seriesItem.id, seriesItem.depth + 1, seriesItem.group);
	        this.eventBus.fire('afterZoom', detectedIndex);
	    },

	    /**
	     * Make exportation data for public event of series type.
	     * @param {object} seriesData series data
	     * @returns {{chartType: string, legend: string, legendIndex: number, index: number}} export data
	     * @private
	     */
	    _makeExportationSeriesData: function(seriesData) {
	        var indexes = seriesData.indexes;
	        var seriesItem = this._getSeriesDataModel().getSeriesItem(indexes.groupIndex, indexes.index, true);

	        return snippet.extend({
	            chartType: this.chartType,
	            indexes: seriesItem.indexes
	        });
	    },

	    /**
	     * To call showAnimation function of graphRenderer.
	     * @param {{groupIndex: number, index: number}} indexes - indexes
	     */
	    onHoverSeries: function(indexes) {
	        if (!predicate.isShowLabel(this.options)) {
	            return;
	        }

	        this.graphRenderer.showAnimation(indexes, this.options.useColorValue, 0.6);
	    },

	    /**
	     * To call hideAnimation function of graphRenderer.
	     * @param {{groupIndex: number, index: number}} indexes - indexes
	     */
	    onHoverOffSeries: function(indexes) {
	        if (!predicate.isShowLabel(this.options) || !indexes) {
	            return;
	        }

	        this.graphRenderer.hideAnimation(indexes, this.options.useColorValue);
	    },

	    /**
	     * On show tooltip for calling showWedge.
	     * @param {{indexes: {groupIndex: number, index: number}}} params - parameters
	     */
	    onShowTooltip: function(params) {
	        var seriesDataModel = this._getSeriesDataModel();
	        var indexes = params.indexes;
	        var ratio = seriesDataModel.getSeriesItem(indexes.groupIndex, indexes.index, true).colorRatio;

	        if (ratio > -1) {
	            this.eventBus.fire('showWedge', ratio);
	        }
	    }
	});

	function treemapChartSeriesFactory(params) {
	    var libType = params.chartOptions.libType;
	    var chartTheme = params.chartTheme;

	    params.libType = libType;
	    params.chartType = 'treemap';
	    params.chartBackground = chartTheme.chart.background;

	    return new TreemapChartSeries(params);
	}

	treemapChartSeriesFactory.componentType = 'series';
	treemapChartSeriesFactory.TreemapChartSeries = TreemapChartSeries;

	module.exports = treemapChartSeriesFactory;


/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview squarifier create squarified bounds for rendering graph of treemap chart.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var calculator = __webpack_require__(45);
	var arrayUtil = __webpack_require__(10);
	var snippet = __webpack_require__(6);

	var squarifier = {
	    /**
	     * bound map
	     * @type {object.<string, {width: number, height: number, left: number, top: number}>}
	     */
	    boundMap: {},

	    /**
	     * Make base bound for calculating bounds.
	     * @param {{width: number, height: number, left: number, top: number}} layout - layout
	     * @returns {{width: number, height: number, left: number, top: number}}
	     * @private
	     */
	    _makeBaseBound: function(layout) {
	        return snippet.extend({}, layout);
	    },

	    /**
	     * Calculate scale for calculating weight.
	     * @param {Array.<number>} values - values
	     * @param {number} width - width of series area
	     * @param {number} height - height of series area
	     * @returns {number}
	     * @private
	     */
	    _calculateScale: function(values, width, height) {
	        return (width * height) / calculator.sum(values);
	    },

	    /**
	     * Make base data for creating squarified bounds.
	     * @param {Array.<SeriesItem>} seriesItems - SeriesItems
	     * @param {number} width - width of series area
	     * @param {number} height - height of series area
	     * @returns {Array.<{itme: SeriesItem, weight: number}>}
	     * @private
	     */
	    _makeBaseData: function(seriesItems, width, height) {
	        var scale = this._calculateScale(snippet.pluck(seriesItems, 'value'), width, height);
	        var data = snippet.map(seriesItems, function(seriesItem) {
	            return {
	                id: seriesItem.id,
	                weight: seriesItem.value * scale
	            };
	        }).sort(function(a, b) {
	            return b.weight - a.weight;
	        });

	        return data;
	    },

	    /**
	     * Calculate worst aspect ratio.
	     * Referred function worst() in https://www.win.tue.nl/~vanwijk/stm.pdf
	     * @param {number} sum - sum for weights
	     * @param {number} min - minimum weight
	     * @param {number} max - maximum weight
	     * @param {number} baseSize - base size (width or height)
	     * @returns {number}
	     * @private
	     */
	    _worst: function(sum, min, max, baseSize) {
	        var sumSquare = sum * sum;
	        var sizeSquare = baseSize * baseSize;

	        return Math.max((sizeSquare * max) / sumSquare, sumSquare / (sizeSquare * min));
	    },

	    /**
	     * Whether changed stack direction or not.
	     * @param {number} sum - sum for weights
	     * @param {Array.<number>} weights - weights
	     * @param {number} baseSize - base size
	     * @param {number} newWeight - new weight
	     * @returns {boolean}
	     * @private
	     */
	    _changedStackDirection: function(sum, weights, baseSize, newWeight) {
	        var min = arrayUtil.min(weights);
	        var max = arrayUtil.max(weights);
	        var beforeWorst = this._worst(sum, min, max, baseSize);
	        var newWorst = this._worst(sum + newWeight, Math.min(min, newWeight), Math.max(max, newWeight), baseSize);

	        return newWorst >= beforeWorst;
	    },

	    /**
	     * Whether type of vertical stack or not.
	     * @param {{width: number, height: number}} baseBound - base bound
	     * @returns {boolean}
	     * @private
	     */
	    _isVerticalStack: function(baseBound) {
	        return baseBound.height < baseBound.width;
	    },

	    /**
	     * Select base size from baseBound.
	     * @param {{width: number, height: number}} baseBound - base bound
	     * @returns {number}
	     * @private
	     */
	    _selectBaseSize: function(baseBound) {
	        return this._isVerticalStack(baseBound) ? baseBound.height : baseBound.width;
	    },

	    /**
	     * Calculate fixed size.
	     * @param {number} baseSize - base size
	     * @param {number} sum - sum for weights
	     * @param {Array.<{weight: number}>} row - row
	     * @returns {number}
	     * @private
	     */
	    _calculateFixedSize: function(baseSize, sum, row) {
	        var weights;

	        if (!sum) {
	            weights = snippet.pluck(row, 'weight');
	            sum = calculator.sum(weights);
	        }

	        return sum / baseSize;
	    },

	    /**
	     * Add bounds.
	     * @param {number} startPosition - start position
	     * @param {Array.<{weight: number}>} row - row
	     * @param {number} fixedSize - fixed size
	     * @param {function} callback - callback function
	     * @private
	     */
	    _addBounds: function(startPosition, row, fixedSize, callback) {
	        snippet.reduce([startPosition].concat(row), function(storedPosition, rowDatum) {
	            var dynamicSize = rowDatum.weight / fixedSize;

	            callback(dynamicSize, storedPosition, rowDatum.id);

	            return storedPosition + dynamicSize;
	        });
	    },

	    /**
	     * Add bound.
	     * @param {number} left - left position
	     * @param {number} top - top position
	     * @param {number} width - width
	     * @param {number} height - height
	     * @param {string | number} id - id of seriesItem
	     * @private
	     */
	    _addBound: function(left, top, width, height, id) {
	        this.boundMap[id] = {
	            left: left,
	            top: top,
	            width: width,
	            height: height
	        };
	    },

	    /**
	     * Add bounds for type of vertical stack.
	     * @param {Array.<{weight: number}>} row - row
	     * @param {{left: number, top: number, width: number, height: number}} baseBound - base bound
	     * @param {number} baseSize - base size
	     * @param {number} sum - sum for weights of row
	     * @private
	     */
	    _addBoundsForVerticalStack: function(row, baseBound, baseSize, sum) {
	        var self = this;
	        var fixedWidth = this._calculateFixedSize(baseSize, sum, row);

	        this._addBounds(baseBound.top, row, fixedWidth, function(dynamicHeight, storedTop, id) {
	            self._addBound(baseBound.left, storedTop, fixedWidth, dynamicHeight, id);
	        });

	        baseBound.left += fixedWidth;
	        baseBound.width -= fixedWidth;
	    },

	    /**
	     * Add bounds for type of horizontal stack.
	     * @param {Array.<{weight: number}>} row - row
	     * @param {{left: number, top: number, width: number, height: number}} baseBound - base bound
	     * @param {number} baseSize - base size
	     * @param {number} sum - sum for weights of row
	     * @private
	     */
	    _addBoundsForHorizontalStack: function(row, baseBound, baseSize, sum) {
	        var self = this;
	        var fixedHeight = this._calculateFixedSize(baseSize, sum, row);

	        this._addBounds(baseBound.left, row, fixedHeight, function(dynamicWidth, storedLeft, id) {
	            self._addBound(storedLeft, baseBound.top, dynamicWidth, fixedHeight, id);
	        });

	        baseBound.top += fixedHeight;
	        baseBound.height -= fixedHeight;
	    },

	    /**
	     * Get adding bounds function.
	     * @param {{width: number, height: number}} baseBound - base bound
	     * @returns {*}
	     * @private
	     */
	    _getAddingBoundsFunction: function(baseBound) {
	        var addBound;

	        if (this._isVerticalStack(baseBound)) {
	            addBound = snippet.bind(this._addBoundsForVerticalStack, this);
	        } else {
	            addBound = snippet.bind(this._addBoundsForHorizontalStack, this);
	        }

	        return addBound;
	    },

	    /**
	     * Create squarified bound map for graph rendering.
	     * @param {object} layout - series area layout
	     * @param {Array.<SeriesItem>} seriesItems - seriesItems
	     * @returns {object.<string, {width: number, height: number, left: number, top: number}>}
	     */
	    squarify: function(layout, seriesItems) {
	        var self = this;
	        var baseBound = this._makeBaseBound(layout);
	        var baseData = this._makeBaseData(seriesItems, baseBound.width, baseBound.height);
	        var row = [];
	        var baseSize, addBounds;

	        this.boundMap = {};

	        snippet.forEachArray(baseData, function(datum) {
	            var weights = snippet.pluck(row, 'weight');
	            var sum = calculator.sum(weights);

	            if (row.length && self._changedStackDirection(sum, weights, baseSize, datum.weight)) {
	                addBounds(row, baseBound, baseSize, sum);
	                row = [];
	            }

	            if (!row.length) {
	                baseSize = self._selectBaseSize(baseBound);
	                addBounds = self._getAddingBoundsFunction(baseBound);
	            }

	            row.push(datum);
	        });

	        if (row.length) {
	            addBounds(row, baseBound, baseSize);
	        }

	        return this.boundMap;
	    }
	};

	module.exports = squarifier;


/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Boxplot chart series component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var BarTypeSeriesBase = __webpack_require__(82);
	var chartConst = __webpack_require__(8);
	var predicate = __webpack_require__(11);
	var renderUtil = __webpack_require__(7);
	var snippet = __webpack_require__(6);

	var BoxplotChartSeries = snippet.defineClass(Series, /** @lends BoxplotChartSeries.prototype */ {
	    /**
	     * Boxplot chart series component.
	     * @constructs BoxplotChartSeries
	     * @private
	     * @extends Series
	     * @param {object} params parameters
	     *      @param {object} params.model series model
	     *      @param {object} params.options series options
	     *      @param {object} params.theme series theme
	     */
	    init: function() {
	        Series.apply(this, arguments);

	        /**
	         * whether series label is supported
	         * @type {boolean}
	         */
	        this.supportSeriesLable = false;
	    },

	    /**
	     * Make boxplot chart bound.
	     * @param {{
	     *      baseBarSize: number,
	     *      groupSize: number,
	     *      barSize: number,
	     *      pointInterval: number,
	     *      firstAdditionalPosition: number,
	     *      basePosition: number
	     * }} baseData base data for making bound
	     * @param {{
	     *      baseLeft: number,
	     *      left: number,
	     *      plusTop: number,
	     *      minusTop: number,
	     *      prevStack: ?string
	     * }} iterationData iteration data
	     * @param {?boolean} isStackType whether stackType option or not.
	     * @param {SeriesItem} seriesItem series item
	     * @param {number} index index
	     * @returns {{
	     *      start: {left: number, top: number, width: number, height: number},
	     *      end: {left: number, top: number, width: number, height: number}
	     * }}
	     * @private
	     */
	    _makeBoxplotChartBound: function(baseData, iterationData, isStackType, seriesItem, index) {
	        var boxHeight = Math.abs(baseData.baseBarSize * seriesItem.ratioDistance);
	        var boxStartTop = baseData.baseBarSize * (1 - seriesItem.lqRatio);
	        var startTop = baseData.basePosition + boxStartTop + chartConst.SERIES_EXPAND_SIZE;
	        var baseTopPosition = baseData.basePosition + chartConst.SERIES_EXPAND_SIZE;
	        var pointCount, endTop, boundLeft, outliers;

	        pointCount = index;
	        iterationData.left = iterationData.baseLeft + (baseData.pointInterval * pointCount);
	        iterationData.plusTop = 0;
	        iterationData.minusTop = 0;

	        if (seriesItem.value >= 0) {
	            iterationData.plusTop -= boxHeight;
	            endTop = startTop + iterationData.plusTop;
	        } else {
	            endTop = startTop + iterationData.minusTop;
	            iterationData.minusTop += boxHeight;
	        }

	        boundLeft = iterationData.left + baseData.pointInterval - (baseData.barSize / 2);

	        outliers = snippet.map(seriesItem.outliers, function(outlier) {
	            return {
	                top: (baseData.baseBarSize * (1 - outlier.ratio)) + baseTopPosition,
	                left: boundLeft + (baseData.barSize / 2)
	            };
	        });

	        return {
	            start: {
	                top: startTop,
	                left: boundLeft,
	                width: baseData.barSize,
	                height: 0
	            },
	            end: {
	                top: endTop,
	                left: boundLeft,
	                width: baseData.barSize,
	                height: boxHeight
	            },
	            min: {
	                top: (baseData.baseBarSize * (1 - seriesItem.minRatio)) + baseTopPosition,
	                left: boundLeft,
	                width: baseData.barSize,
	                height: 0
	            },
	            max: {
	                top: (baseData.baseBarSize * (1 - seriesItem.maxRatio)) + baseTopPosition,
	                left: boundLeft,
	                width: baseData.barSize,
	                height: 0
	            },
	            median: {
	                top: (baseData.baseBarSize * (1 - seriesItem.medianRatio)) + baseTopPosition,
	                left: boundLeft,
	                width: baseData.barSize,
	                height: 0
	            },
	            outliers: outliers
	        };
	    },

	    /**
	     * Make bounds of boxplot chart.
	     * @returns {Array.<Array.<object>>} bounds
	     * @private
	     */
	    _makeBounds: function() {
	        var self = this;
	        var seriesDataModel = this._getSeriesDataModel();
	        var isStackType = predicate.isValidStackOption(this.options.stackType);
	        var dimension = this.layout.dimension;
	        var baseData = this._makeBaseDataForMakingBound(dimension.width, dimension.height);

	        return seriesDataModel.map(function(seriesGroup, groupIndex) {
	            var baseLeft = (groupIndex * baseData.groupSize) + self.layout.position.left;
	            var iterationData = {
	                baseLeft: baseLeft,
	                left: baseLeft,
	                plusTop: 0,
	                minusTop: 0,
	                prevStack: null
	            };
	            var iteratee = snippet.bind(self._makeBoxplotChartBound, self, baseData, iterationData, isStackType);

	            return seriesGroup.map(iteratee);
	        });
	    },

	    /**
	     * Calculate left position of sum label.
	     * @param {{left: number, top: number}} bound bound
	     * @param {string} formattedSum formatted sum.
	     * @returns {number} left position value
	     * @private
	     */
	    _calculateLeftPositionOfSumLabel: function(bound, formattedSum) {
	        var labelWidth = renderUtil.getRenderedLabelWidth(formattedSum, this.theme.label);

	        return bound.left + ((bound.width - labelWidth + chartConst.TEXT_PADDING) / 2);
	    }
	});

	BarTypeSeriesBase.mixin(BoxplotChartSeries);

	function boxplotSeriesFactory(params) {
	    var libType = params.chartOptions.libType;
	    var chartTheme = params.chartTheme;

	    params.libType = libType;
	    params.chartType = 'boxplot';
	    params.chartBackground = chartTheme.chart.background;

	    return new BoxplotChartSeries(params);
	}

	boxplotSeriesFactory.componentType = 'series';
	boxplotSeriesFactory.BoxplotChartSeries = BoxplotChartSeries;

	module.exports = boxplotSeriesFactory;


/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Bullet chart series component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var Series = __webpack_require__(81);
	var renderUtil = __webpack_require__(7);
	var chartConst = __webpack_require__(8);
	var snippet = __webpack_require__(6);

	var BulletChartSeries = snippet.defineClass(Series, /** @lends BulletChartSeries.prototype */ {
	    /**
	     * Bullet chart series component.
	     * @constructs BulletChartSeries
	     * @private
	     * @extends Series
	     * @param {object} params series initialization data
	     */
	    init: function(params) {
	        Series.call(this, params);

	        /**
	         * true if graph stratches vertically
	         * false if graph stratches horizontally
	         * @type {boolean}
	         */
	        this.isVertical = params.isVertical;
	    },

	    /**
	     * Create data for rendering series
	     * @returns {object} - data for rendering series
	     * @override
	     * @private
	     */
	    _makeSeriesData: function() {
	        var groupBounds = this._makeBounds();

	        return {
	            groupBounds: groupBounds,
	            seriesDataModel: this._getSeriesDataModel(),
	            isVertical: this.isVertical,
	            isAvailable: function() {
	                return groupBounds && groupBounds.length > 0;
	            }
	        };
	    },

	    /**
	     * Create bounds data
	     * @returns {Array.<Bound>} - bound data of bullet graph components
	     * @private
	     */
	    _makeBounds: function() {
	        var self = this;
	        var seriesDataModel = this._getSeriesDataModel();
	        var baseData = this._makeBaseDataForMakingBound();
	        var iterationData = {
	            renderedItemCount: 0,
	            top: baseData.categoryAxisTop,
	            left: baseData.categoryAxisLeft
	        };

	        return seriesDataModel.map(function(seriesGroup) {
	            var iteratee = snippet.bind(self._makeBulletChartBound, self, baseData, iterationData);
	            var bounds = seriesGroup.map(iteratee);

	            self._updateIterationData(iterationData, baseData.itemWidth);

	            return bounds;
	        });
	    },

	    /**
	     * prepare a base data before making a bound
	     * @returns {object} - base data
	     * @private
	     */
	    _makeBaseDataForMakingBound: function() {
	        var groupCount = this._getSeriesDataModel().getGroupCount();
	        var dimension = this.layout.dimension;
	        var width = dimension.width;
	        var height = dimension.height;
	        var position = this.layout.position;
	        var categoryAxisTop = position.top;
	        var categoryAxisLeft = position.left;
	        var categoryAxisWidth, valueAxisWidth, itemWidth;

	        if (this.isVertical) {
	            categoryAxisTop += height;
	            categoryAxisWidth = width;
	            valueAxisWidth = height;
	        } else {
	            categoryAxisWidth = height;
	            valueAxisWidth = width;
	        }

	        itemWidth = categoryAxisWidth / groupCount;

	        return {
	            categoryAxisTop: categoryAxisTop,
	            categoryAxisLeft: categoryAxisLeft,
	            categoryAxisWidth: categoryAxisWidth,
	            valueAxisWidth: valueAxisWidth,
	            itemWidth: itemWidth
	        };
	    },

	    /**
	     * Create a bullet chart bound before making a base data
	     * @param {object} baseData - base data for making a tooltip
	     * @param {object} iterationData - increasing data while generating a graph data: index of item, graph position
	     * @param {object} item - series item
	     * @returns {Bound} - bullet graph bound
	     * @private
	     */
	    _makeBulletChartBound: function(baseData, iterationData, item) {
	        var type = item.type;
	        var bound;

	        if (type === chartConst.BULLET_TYPE_ACTUAL) {
	            bound = this._makeBarBound(item, chartConst.BULLET_ACTUAL_HEIGHT_RATIO, baseData, iterationData);
	        } else if (type === chartConst.BULLET_TYPE_RANGE) {
	            bound = this._makeBarBound(item, chartConst.BULLET_RANGES_HEIGHT_RATIO, baseData, iterationData);
	        } else if (type === chartConst.BULLET_TYPE_MARKER) {
	            bound = this._makeLineBound(item, chartConst.BULLET_MARKERS_HEIGHT_RATIO, baseData, iterationData);
	        }

	        bound.type = type;

	        return bound;
	    },

	    /**
	     * Create bar type bound data
	     * @param {object} model - series item data
	     * @param {number} widthRatio - thickness compare to graph area
	     * @param {object} baseData - base data needed for making a bar bound
	     * @param {object} iterationData - data for setting up position
	     * @returns {object} - bar type bound data
	     * @private
	     */
	    _makeBarBound: function(model, widthRatio, baseData, iterationData) {
	        var barWidth = baseData.itemWidth * widthRatio;
	        var barHeight = baseData.valueAxisWidth * model.ratioDistance;
	        var barEndHeight = baseData.valueAxisWidth * model.endRatio;
	        var bound;

	        if (this.isVertical) {
	            bound = this._makeVerticalBarBound(iterationData, baseData, barWidth, barHeight, barEndHeight);
	        } else {
	            bound = this._makeHorizontalBarBound(iterationData, baseData, barWidth, barHeight, barEndHeight);
	        }

	        return bound;
	    },

	    /**
	     * create a bound of bar type component, when it is virtical chart
	     * @param {object} iterationData - increasing data while generating a graph data: graph position
	     * @param {object} baseData - base data
	     * @param {number} barWidth - width of bar
	     * @param {number} barHeight - bar size from start position to end position
	     * @param {number} barEndHeight - bar size from axis start point to end position
	     * @returns {object} - bound data
	     * @private
	     */
	    _makeVerticalBarBound: function(iterationData, baseData, barWidth, barHeight, barEndHeight) {
	        return {
	            top: iterationData.top - barEndHeight,
	            left: iterationData.left + ((baseData.itemWidth - barWidth) / 2),
	            width: barWidth,
	            height: barHeight
	        };
	    },

	    /**
	     * create a bound of bar type component, when it is a horizontal chart
	     * @param {object} iterationData - increasing data while generating a graph data: graph position
	     * @param {object} baseData - base data
	     * @param {number} barWidth - width of bar
	     * @param {number} barHeight - bar size from start position to end position
	     * @param {number} barEndHeight - bar size from axis start point to end position
	     * @returns {object} - bound data
	     * @private
	     */
	    _makeHorizontalBarBound: function(iterationData, baseData, barWidth, barHeight, barEndHeight) {
	        return {
	            top: iterationData.top + ((baseData.itemWidth - barWidth) / 2),
	            left: iterationData.left + barEndHeight - barHeight,
	            width: barHeight,
	            height: barWidth
	        };
	    },

	    /**
	     * Create line type bound data
	     * @param {object} model - series item data
	     * @param {number} widthRatio - graph thickness compare to graph area
	     * @param {object} baseData - base data needed for making a line bound
	     * @param {object} iterationData - data for setting up position
	     * @returns {object} - line type bound data
	     * @private
	     */
	    _makeLineBound: function(model, widthRatio, baseData, iterationData) {
	        var lineWidth = baseData.itemWidth * widthRatio;
	        var endHeight = baseData.valueAxisWidth * model.endRatio;
	        var width = chartConst.BULLET_MARKER_DETECT_PADDING;
	        var height = chartConst.BULLET_MARKER_DETECT_PADDING;
	        var top, left;

	        if (this.isVertical) {
	            top = iterationData.top - endHeight;
	            left = iterationData.left + ((baseData.itemWidth - lineWidth) / 2);
	            width = lineWidth;
	        } else {
	            top = iterationData.top + ((baseData.itemWidth - lineWidth) / 2);
	            left = iterationData.left + endHeight;
	            height = lineWidth;
	        }

	        return {
	            top: top,
	            left: left,
	            length: lineWidth,
	            width: width,
	            height: height
	        };
	    },

	    /**
	     * update iterationData after making a graph bound
	     * @param {object} iterationData - iteration data
	     * @param {number} itemWidth - size of category axis area
	     * @private
	     */
	    _updateIterationData: function(iterationData, itemWidth) {
	        iterationData.renderedItemCount += 1;

	        if (this.isVertical) {
	            iterationData.left += itemWidth;
	        } else {
	            iterationData.top += itemWidth;
	        }
	    },

	    /**
	    * Render series area.
	    * @param {object} paper - raphael object
	    * @param {function} funcRenderGraph - function for graph rendering
	    * @private
	    */
	    _renderSeriesArea: function(paper, funcRenderGraph) {
	        Series.prototype._renderSeriesArea.call(this, paper, funcRenderGraph);

	        this.dataProcessor.setGraphColors(this.graphRenderer.getGraphColors());
	    },

	    /**
	     * Render series labels
	     * Series labels are shown only when `options.series.showLabel` is enabled
	     * @param {object} paper paper
	     * @returns {Array.<SVGElement>} - svg label sets
	     * @override
	     * @private
	     */
	    _renderSeriesLabel: function(paper) {
	        var theme = this.theme.label;
	        var seriesDataModel = this._getSeriesDataModel();
	        var groupLabels = this._getLabelTexts(seriesDataModel);
	        var positionsSet = this._calculateLabelPositions(seriesDataModel, theme);

	        return this.graphRenderer.renderSeriesLabel(paper, positionsSet, groupLabels, theme);
	    },

	    /**
	     * Get label texts needed for enabling `options.series.showLabel` option
	     * @param {object} seriesDataModel - seriesDataModel
	     * @returns {Array.<string>} - actual data and marker data label
	     * @private
	     */
	    _getLabelTexts: function(seriesDataModel) {
	        return seriesDataModel.map(function(seriesGroup) {
	            var seriesLabels = [];

	            seriesGroup.each(function(seriesDatum) {
	                if (seriesDatum.type !== chartConst.BULLET_TYPE_RANGE) {
	                    seriesLabels.push(seriesDatum.endLabel);
	                }
	            });

	            return seriesLabels;
	        });
	    },

	    /**
	     * calculate a label position
	     * @param {object} seriesDataModel - bullet chart's series data model
	     * @param {object} theme - style needed to calculate the size of the text
	     * @returns {Array.<object>} - position of label text
	     * @private
	     */
	    _calculateLabelPositions: function(seriesDataModel, theme) {
	        var serieses = this.seriesData.groupBounds;
	        var labelHeight = renderUtil.getRenderedLabelHeight(chartConst.MAX_HEIGHT_WORD, theme);

	        return snippet.map(serieses, function(series) {
	            var bounds = [];

	            snippet.forEach(series, function(item) {
	                if (item.type !== chartConst.BULLET_TYPE_RANGE) {
	                    bounds.push(this._makePositionByBound(item, labelHeight));
	                }
	            }, this);

	            return bounds;
	        }, this);
	    },

	    /**
	     * make position top, left data using bound data and label height
	     * @param {object} bound - bound data
	     * @param {number} labelHeight - label's height
	     * @returns {object} - position top, left
	     * @private
	     */
	    _makePositionByBound: function(bound, labelHeight) {
	        var boundTop = bound.top;
	        var boundLeft = bound.left;
	        var width, height;
	        var position = {};

	        if (this.isVertical) {
	            width = bound.width || bound.length;
	            position.top = boundTop - labelHeight;
	            position.left = boundLeft + (width / 2);
	        } else {
	            width = bound.width || 0;
	            height = bound.height || bound.length;
	            position.top = boundTop + (height / 2);
	            position.left = boundLeft + 5 + (width || 0);
	        }

	        return position;
	    }
	});

	/**
	 * BulletChartSeries factory function
	 * @param {object} params - series initialization data
	 * @returns {BulletChartSeries} - bullet chart series
	 */
	function bulletSeriesFactory(params) {
	    var chartTheme = params.chartTheme;

	    params.libType = params.chartOptions.libType;
	    params.chartType = 'bullet';
	    params.chartBackground = chartTheme.chart.background;

	    return new BulletChartSeries(params);
	}

	bulletSeriesFactory.componentType = 'series';
	bulletSeriesFactory.BulletChartSeries = BulletChartSeries;

	module.exports = bulletSeriesFactory;


/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview Zoom component.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var snippet = __webpack_require__(6);
	var IS_MSIE_VERSION_LTE_THAN_8 = snippet.browser.msie && snippet.browser.version <= 8;

	var seriesTemplate = __webpack_require__(100);
	var chartConst = __webpack_require__(8);
	var dom = __webpack_require__(9);
	var renderUtil = __webpack_require__(7);
	var eventListener = __webpack_require__(55);

	var Zoom = snippet.defineClass(/** @lends Zoom.prototype */{
	    /**
	     * zoom component className
	     * @type {string}
	     */
	    className: 'tui-chart-zoom-area',
	    /**
	     * Zoom component.
	     * @param {{eventBus: object}} params - parameters
	     * @constructs Zoom
	     * @private
	     */
	    init: function(params) {
	        /**
	         * event bus for transmitting message
	         * @type {object}
	         */
	        this.eventBus = params.eventBus;

	        /**
	         * Magnification.
	         * @type {number}
	         */
	        this.magn = 1;

	        /**
	         * Stacked wheelDelta.
	         * @type {number}
	         */
	        this.stackedWheelDelta = 0;

	        this.drawingType = chartConst.COMPONENT_TYPE_DOM;

	        this._attachToEventBus();
	    },

	    /**
	     * Attach to event bus.
	     * @private
	     */
	    _attachToEventBus: function() {
	        this.eventBus.on('wheel', this.onWheel, this);
	    },

	    /**
	     * Render.
	     * @param {{positionMap: {series: {left: number, top: number}}}} data - data for rendering
	     * @returns {HTMLElement} zoom container
	     */
	    render: function(data) {
	        var container;

	        if (!IS_MSIE_VERSION_LTE_THAN_8) {
	            container = dom.create('DIV', this.className);

	            container.innerHTML += seriesTemplate.ZOOM_BUTTONS;
	            renderUtil.renderPosition(container, data.positionMap.series);
	            this._attachEvent(container);
	        }

	        return container;
	    },

	    /**
	     * Find button element.
	     * @param {HTMLElement} target target element.
	     * @returns {?HTMLElement} button element
	     * @private
	     */
	    _findBtnElement: function(target) {
	        var btnClassName = 'tui-chart-zoom-btn',
	            btnElement = target;

	        if (!dom.hasClass(target, btnClassName)) {
	            btnElement = dom.findParentByClass(target, btnClassName);
	        }

	        return btnElement;
	    },

	    /**
	     * Zoom
	     * @param {number} magn magnification
	     * @param {?{left: number, top: number}} position mouse position
	     * @private
	     */
	    _zoom: function(magn, position) {
	        this.eventBus.fire('zoomMap', magn, position);
	    },

	    /**
	     * On click.
	     * @param {MouseEvent} e mouse event
	     * @returns {?boolean} prevent default for ie
	     * @private
	     */
	    _onClick: function(e) {
	        var target = e.target || e.srcElement;
	        var btnElement = this._findBtnElement(target);
	        var zoomDirection = btnElement.getAttribute('data-magn');
	        var magn = this._calculateMagn(zoomDirection);

	        if (magn > 5) {
	            this.magn = 5;
	        } else if (magn < 1) {
	            this.magn = 1;
	        } else if (magn >= 1) {
	            this._zoom(magn);
	        }

	        if (e.preventDefault) {
	            e.preventDefault();
	        }

	        return false;
	    },

	    /**
	     * Attach event.
	     * @param {HTMLElement} target target element
	     * @private
	     */
	    _attachEvent: function(target) {
	        eventListener.on(target, 'click', this._onClick, this);
	    },

	    /**
	     * Calculate magnification from zoomDirection.
	     * @param {number} zoomDirection zoomDirection (positive is zoomIn)
	     * @returns {number} magnification
	     * @private
	     */
	    _calculateMagn: function(zoomDirection) {
	        if (zoomDirection > 0) {
	            this.magn += 0.1;
	        } else if (zoomDirection < 0) {
	            this.magn -= 0.1;
	        }

	        return this.magn;
	    },

	    /**
	     * On wheel.
	     * @param {number} wheelDelta wheelDelta
	     * @param {{left: number, top: number}} position mouse position
	     */
	    onWheel: function(wheelDelta, position) {
	        var magn = this._calculateMagn(wheelDelta);

	        if (magn > 5) {
	            this.magn = 5;
	        } else if (magn < 1) {
	            this.magn = 1;
	        } else if (magn >= 1) {
	            this._zoom(magn, position);
	        }
	    }
	});

	function zoomFactory(params) {
	    return new Zoom(params);
	}

	zoomFactory.componentType = 'zoom';

	module.exports = zoomFactory;


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview This is templates of series.
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var templateMaker = __webpack_require__(65);

	var htmls = {
	    HTML_SERIES_LABEL: '<div class="tui-chart-series-label" style="{{ cssText }}"{{ rangeLabelAttribute }}>' +
	        '{{ label }}</div>',
	    TEXT_CSS_TEXT: 'left:{{ left }}px;top:{{ top }}px;font-family:{{ fontFamily }};' +
	        'font-size:{{ fontSize }}px;font-weight:{{ fontWeight }}{{opacity}}',
	    TEXT_CSS_TEXT_FOR_LINE_TYPE: 'left:{{ left }}%;top:{{ top }}%;font-family:{{ fontFamily }};' +
	    'font-size:{{ fontSize }}px;font-weight:{{ fontWeight }}{{opacity}}',
	    HTML_ZOOM_BUTTONS: '<a class="tui-chart-zoom-btn" href="#" data-magn="1">' +
	            '<div class="horizontal-line"></div><div class="vertical-line"></div></a>' +
	        '<a class="tui-chart-zoom-btn" href="#" data-magn="-1"><div class="horizontal-line"></div></a>',
	    HTML_SERIES_BLOCK: '<div class="tui-chart-series-block" style="{{ cssText }}">{{ label }}</div>'
	};

	module.exports = {
	    tplSeriesLabel: templateMaker.template(htmls.HTML_SERIES_LABEL),
	    tplCssText: templateMaker.template(htmls.TEXT_CSS_TEXT),
	    tplCssTextForLineType: templateMaker.template(htmls.TEXT_CSS_TEXT_FOR_LINE_TYPE),
	    ZOOM_BUTTONS: htmls.HTML_ZOOM_BUTTONS,
	    tplSeriesBlock: templateMaker.template(htmls.HTML_SERIES_BLOCK)
	};


/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

	/**
	 * @fileoverview DataProcessor process rawData.
	 * rawData.categories --> categories
	 * rawData.series --> SeriesDataModel, legendLabels, legendData
	 * @author NHN Ent.
	 *         FE Development Lab <dl_javascript@nhnent.com>
	 */

	'use strict';

	var chartConst = __webpack_require__(8);
	var DataProcessorBase = __webpack_require__(102);
	var SeriesDataModel = __webpack_require__(103);
	var SeriesDataModelForBoxplot = __webpack_require__(107);
	var SeriesDataModelForBullet = __webpack_require__(109);
	var SeriesDataModelForTreemap = __webpack_require__(110);
	var SeriesGroup = __webpack_require__(104);
	var rawDataHandler = __webpack_require__(31);
	var predicate = __webpack_require__(11);
	var renderUtil = __webpack_require__(7);
	var calculator = __webpack_require__(45);
	var objectUtil = __webpack_require__(36);
	var snippet = __webpack_require__(6);

	var concat = Array.prototype.concat;

	var isUndefined = snippet.isUndefined;

	/*
	 * Raw series datum.
	 * @typedef {{name: ?string, data: Array.<number>, stack: ?string}} rawSeriesDatum
	 */

	/*
	 * Raw series data.
	 * @typedef {Array.<rawSeriesDatum>} rawSeriesData
	 */

	/*
	 * Raw data by user.
	 * @typedef {{
	 *      categories: ?Array.<string>,
	 *      series: (rawSeriesData|{line: ?rawSeriesData, column: ?rawSeriesData})
	 * }} rawData
	 */

	/*
	 * SeriesDataModel is base model for drawing graph of chart series area,
	 *      and create from rawSeriesData by user,
	 * SeriesDataModel.groups has SeriesGroups.
	 */

	/*
	 * SeriesGroup is a element of SeriesDataModel.groups.
	 * SeriesGroup.items has SeriesItem.
	 */

	var DataProcessor = snippet.defineClass(DataProcessorBase, /** @lends DataProcessor.prototype */{
	    /**
	     * Data processor.
	     * @constructs DataProcessor
	     * @private
	     * @param {rawData} rawData raw data
	     * @param {string} chartType chart type
	     * @param {object} options options
	     * @param {Array.<string>} seriesTypes chart types
	     */
	    init: function(rawData, chartType, options, seriesTypes) {
	        /**
	         * original raw data.
	         * @type {{categories: ?Array.<string>, series: Array.<object>}}
	         */
	        this.originalRawData = objectUtil.deepCopy(rawData);

	        /**
	         * chart type
	         * @type {string}
	         */
	        this.chartType = chartType;

	        /**
	         * chart options
	         * @type {Object}
	         */
	        this.options = options;

	        /**
	         * seriesTypes is sorted chart types for rendering series area of combo chart.
	         * @type {Array.<string>}
	         */
	        this.seriesTypes = seriesTypes;

	        /**
	         * legend data for rendering legend of group tooltip
	         * @type {Array.<{chartType: string, label: string}>}
	         */
	        this.originalLegendData = null;

	        /**
	         * select legend index
	         * @type {number}
	         */
	        this.selectLegendIndex = null;

	        /**
	         * dynamic data array for adding data.
	         * @type {Array.<{category: string | number, values: Array.<number>}>}
	         */
	        this.dynamicData = [];

	        this.defaultValues = [0, 500];

	        this.initData(rawData);
	        this.initZoomedRawData();
	        this.baseInit();
	    },

	    /**
	     * Get original raw data.
	     * @returns {rawData} raw data
	     */
	    getOriginalRawData: function() {
	        return objectUtil.deepCopy(this.originalRawData);
	    },

	    /**
	     * Get zoomed raw data.
	     * @returns {*|null}
	     */
	    getZoomedRawData: function() {
	        var zoomedRawData = this.zoomedRawData;

	        if (zoomedRawData) {
	            zoomedRawData = objectUtil.deepCopy(zoomedRawData);
	        } else {
	            zoomedRawData = this.getOriginalRawData();
	        }

	        return zoomedRawData;
	    },

	    /**
	     * Filter seriesData by index range.
	     * @param {Array.<{data: Array}>} seriesData - series data
	     * @param {number} startIndex - start index
	     * @param {number} endIndex - end index
	     * @returns {Array.<Array.<object>>}
	     * @private
	     */
	    _filterSeriesDataByIndexRange: function(seriesData, startIndex, endIndex) {
	        snippet.forEachArray(seriesData, function(seriesDatum) {
	            seriesDatum.data = seriesDatum.data.slice(startIndex, endIndex + 1);
	        });

	        return seriesData;
	    },

	    /**
	     * Filter raw data by index range.
	     * @param {{series: Array.<object>, categories: Array.<string>}} rawData - raw data
	     * @param {Array.<number>} indexRange - index range for zoom
	     * @returns {*}
	     * @private
	     */
	    _filterRawDataByIndexRange: function(rawData, indexRange) {
	        var self = this;
	        var startIndex = indexRange[0];
	        var endIndex = indexRange[1];

	        snippet.forEach(rawData.series, function(seriesDataSet, seriesType) {
	            rawData.series[seriesType] = self._filterSeriesDataByIndexRange(seriesDataSet, startIndex, endIndex);
	        });

	        if (rawData.categories) {
	            rawData.categories = rawData.categories.slice(startIndex, endIndex + 1);
	        }

	        return rawData;
	    },

	    /**
	     * Update raw data for zoom
	     * @param {Array.<number>} indexRange - index range for zoom
	     */
	    updateRawDataForZoom: function(indexRange) {
	        var rawData = this.getRawData();
	        var zoomedRawData = this.getZoomedRawData();

	        this.zoomedRawData = this._filterRawDataByIndexRange(zoomedRawData, indexRange);
	        rawData = this._filterRawDataByIndexRange(rawData, indexRange);
	        this.initData(rawData);
	    },

	    /**
	     * Init zoomed raw data.
	     */
	    initZoomedRawData: function() {
	        this.zoomedRawData = null;
	    },

	    /**
	     * Initialize data.
	     * @param {rawData} rawData raw data
	     */
	    initData: function(rawData) {
	        /**
	         * raw data
	         * @type {rawData}
	         */
	        this.rawData = rawData;

	        /**
	         * categoriesMap
	         * @type {null|object}
	         */
	        this.categoriesMap = null;

	        /**
	         * categories isDatetype true or false
	         * @type {null|object}
	         */
	        this.categoriesIsDateTime = {};

	        /**
	         * stacks
	         * @type {Array.<number>}
	         */
	        this.stacks = null;

	        /**
	         * seriesDataModel map
	         * @type {object.<string, SeriesDataModel>}
	         */
	        this.seriesDataModelMap = {};

	        /**
	         * SeriesGroups
	         * @type {Array.<SeriesGroup>}
	         */
	        this.seriesGroups = null;

	        /**
	         * map of values of SeriesItems
	         * @type {Object.<string, Array.<number>>}
	         */
	        this.valuesMap = {};

	        /**
	         * legend labels for rendering legend area
	         * @type {{column: Array.<string>, line: Array.<string> | Array.<string>}}
	         */
	        this.legendLabels = null;

	        /**
	         * legend data for rendering legend
	         * @type {Array.<{chartType: string, label: string}>}
	         */
	        this.legendData = null;

	        /**
	         * multiline categories
	         * @type {Array.<string>}
	         */
	        this.multilineCategories = null;

	        /**
	         * whether coordinate type data or not
	         * @type {null|boolean}
	         */
	        this.coordinateType = null;
	    },

	    /**
	     * Get raw data.
	     * @returns {rawData}
	     */
	    getRawData: function() {
	        return this.rawData;
	    },

	    /**
	     * Find chart type from series name.
	     * @param {string} seriesType - series name
	     * @returns {*}
	     */
	    findChartType: function(seriesType) {
	        return rawDataHandler.findChartType(this.rawData.seriesAlias, seriesType);
	    },

	    /**
	     * Escape categories.
	     * @param {Array.<string, number>} categories - cetegories
	     * @returns {*|Array.<Object>|Array}
	     * @private
	     */
	    _escapeCategories: function(categories) {
	        return snippet.map(categories, function(category) {
	            return snippet.encodeHTMLEntity(String(category));
	        });
	    },

	    /**
	     * Map categories.
	     * @param {Array.<string | number>} categories - categories
	     * @param {string} [axisName] - axis name like 'x' or 'y'
	     * @returns {Array.<string | number>}
	     * @private
	     */
	    _mapCategories: function(categories, axisName) {
	        var axisType = axisName + 'Axis';
	        var options = this.options[axisType] || {};
	        var isDateTime = false;

	        if (snippet.isArray(options)) {
	            isDateTime = snippet.filter(options, function(option) {
	                return option.type && predicate.isDatetimeType(option.type);
	            });
	        } else {
	            isDateTime = options.type && predicate.isDatetimeType(options.type);
	        }
	        if (isDateTime) {
	            categories = snippet.map(categories, function(value) {
	                var date = this.chageDatetypeToTimestamp(value);

	                return date;
	            }, this);
	        } else {
	            categories = this._escapeCategories(categories);
	        }

	        this.categoriesIsDateTime[axisName] = isDateTime;

	        return categories;
	    },

	    /**
	     * Process categories.
	     * @param {string} type - category type (x or y)
	     * @returns {null | Array.<string>} processed categories
	     * @private
	     */
	    _processCategories: function(type) {
	        var rawCategories = this.rawData.categories;
	        var categoriesMap = {};

	        if (snippet.isArray(rawCategories)) {
	            categoriesMap[type] = this._mapCategories(rawCategories, type);
	        } else if (rawCategories) {
	            if (rawCategories.x) {
	                categoriesMap.x = this._mapCategories(rawCategories.x, 'x');
	            }

	            if (rawCategories.y) {
	                categoriesMap.y = this._mapCategories(rawCategories.y, 'y').reverse();
	            }
	        }

	        return categoriesMap;
	    },

	    /**
	     * Get Categories
	     * @param {boolean} isVertical - whether vertical or not
	     * @returns {Array.<string>}}
	     */
	    getCategories: function(isVertical) {
	        var type = isVertical ? 'y' : 'x';
	        var foundCategories = [];

	        if (!this.categoriesMap) {
	            this.categoriesMap = this._processCategories(type);
	        }

	        if (snippet.isExisty(isVertical)) {
	            foundCategories = this.categoriesMap[type] || [];
	        } else {
	            snippet.forEach(this.categoriesMap, function(categories) {
	                foundCategories = categories;

	                return false;
	            });
	        }

	        return foundCategories;
	    },

	    /**
	     * Get Category date type
	     * @param {boolean} isVertical - whether vertical or not
	     * @returns {boolean}
	     */
	    getCategorieDateType: function(isVertical) {
	        var type = isVertical ? 'y' : 'x';

	        return this.categoriesIsDateTime[type];
	    },

	    /**
	     * value to timestamp of datetype category
	     * @param {string} dateTypeValue - datetype category value
	     * @returns {boolean}
	     */
	    chageDatetypeToTimestamp: function(dateTypeValue) {
	        var date = new Date(dateTypeValue);
	        if (!(date.getTime() > 0)) {
	            date = new Date(parseInt(dateTypeValue, 10));
	        }

	        return date.getTime() || dateTypeValue;
	    },

	    /**
	     * Get category count.
	     * @param {boolean} isVertical - whether vertical or not
	     * @returns {*}
	     */
	    getCategoryCount: function(isVertical) {
	        var categories = this.getCategories(isVertical);

	        return categories ? categories.length : 0;
	    },

	    /**
	     * Whether has categories or not.
	     * @param {boolean} isVertical - whether vertical or not
	     * @returns {boolean}
	     */
	    hasCategories: function(isVertical) {
	        return !!this.getCategoryCount(isVertical);
	    },

	    /**
	     * Whether count of x data grater than count of y data.
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    isXCountGreaterThanYCount: function(chartType) {
	        var seriesDataModel = this.getSeriesDataModel(chartType);

	        return seriesDataModel.isXCountGreaterThanYCount();
	    },

	    /**
	     * Whether has x value or not.
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    hasXValue: function(chartType) {
	        var hasVerticalCategory = this.isXCountGreaterThanYCount(chartType);

	        return !this.hasCategories(hasVerticalCategory) || hasVerticalCategory;
	    },

	    /**
	     * Whether has y value or not.
	     * @param {string} chartType - chart type
	     * @returns {boolean}
	     */
	    hasYValue: function(chartType) {
	        var hasVerticalCategory = this.isXCountGreaterThanYCount(chartType);

	        return !this.hasCategories(hasVerticalCategory) || !hasVerticalCategory;
	    },

	    /**
	     * Get category.
	     * @param {number} index index
	     * @param {boolean} isVertical - whether vertical or not
	     * @returns {string} category
	     */
	    getCategory: function(index, isVertical) {
	        return this.getCategories(isVertical)[index];
	    },

	    /**
	     * Find category index by value
	     * @param {string} value - category value
	     * @returns {null|number}
	     */
	    findCategoryIndex: function(value) {
	        var categories = this.getCategories();
	        var isDateType = this.getCategorieDateType();
	        var foundIndex = null;

	        snippet.forEachArray(categories, function(category, index) {
	            if (isDateType) {
	                value = this.chageDatetypeToTimestamp(value);
	            }

	            if (category === value) {
	                foundIndex = index;
	            }

	            return snippet.isNull(foundIndex);
	        }, this);

	        return foundIndex;
	    },

	    /**
	     * @param {string} value - category
	     * @returns {number} - found: category index, not found: -1
	     */
	    findAbsoluteCategoryIndex: function(value) {
	        var originalCategories = this.originalRawData ? this.originalRawData.categories : null;
	        var index = -1;

	        if (!originalCategories) {
	            return index;
	        }

	        snippet.forEach(originalCategories, function(category, categoryIndex) {
	            var found = category === value;
	            if (found) {
	                index = categoryIndex;
	            }

	            return !found;
	        });

	        return index;
	    },

	    /**
	     * Get tooltip category.
	     * @param {number} categoryIndex - category index
	     * @param {boolean} isVertical - whether vertical category or not
	     * @returns {string}
	     * @private
	     */
	    _getTooltipCategory: function(categoryIndex, isVertical) {
	        var category = this.getCategory(categoryIndex, isVertical);
	        var axisType = isVertical ? 'yAxis' : 'xAxis';
	        var axisOption = this.options[axisType] || {};
	        var tooltipOption = this.options.tooltip || {};

	        if (predicate.isDatetimeType(tooltipOption.type)) {
	            category = renderUtil.formatDate(category, tooltipOption.dateFormat);
	        } else if (predicate.isDatetimeType(axisOption.type)) {
	            category = renderUtil.formatDate(category, axisOption.dateFormat);
	        }

	        return category;
	    },

	    /**
	     * Make category for tooltip.
	     * @param {number} categoryIndex - category index
	     * @param {number} oppositeIndex - opposite index
	     * @param {boolean} isVerticalChart - whether vertical chart or not
	     * @returns {string}
	     */
	    makeTooltipCategory: function(categoryIndex, oppositeIndex, isVerticalChart) {
	        var isVertical = !isVerticalChart;
	        var category = this._getTooltipCategory(categoryIndex, isVertical);
	        var categoryCount = this.getCategoryCount(!isVertical);

	        if (categoryCount) {
	            category += ', ' + this._getTooltipCategory(categoryCount - oppositeIndex - 1, !isVertical);
	        }

	        return category;
	    },

	    /**
	     * Get stacks from raw series data.
	     * @param {string} seriesType seriesType to count stacks
	     * @returns {Array.<string>}
	     */
	    getStacks: function(seriesType) {
	        if (!this.stacks) {
	            this.stacks = rawDataHandler.pickStacks(this.rawData.series[seriesType]);
	        }

	        return this.stacks;
	    },

	    /**
	     * Get stack count.
	     * @param {string} seriesType - series type
	     * @returns {Number}
	     */
	    getStackCount: function(seriesType) {
	        return this.getStacks(seriesType).length;
	    },

	    /**
	     * Find stack index from stack list by stack value.
	     * @param {string} stack stack
	     * @returns {number}
	     */
	    findStackIndex: function(stack) {
	        return snippet.inArray(stack, this.getStacks());
	    },

	    /**
	     * Whether coordinate type or not.
	     * @returns {boolean}
	     */
	    isCoordinateType: function() {
	        var chartType = this.chartType;
	        var coordinateType = this.coordinateType;

	        if (!snippet.isExisty(coordinateType)) {
	            coordinateType = predicate.isCoordinateTypeChart(chartType);
	            coordinateType = coordinateType || predicate.isLineScatterComboChart(chartType, this.seriesTypes);
	            coordinateType = coordinateType || (predicate.isLineTypeChart(chartType) && !this.hasCategories());
	            this.coordinateType = coordinateType;
	        }

	        return coordinateType;
	    },

	    /**
	     * Get SeriesDataModel.
	     * @param {string} seriesType - series name
	     * @returns {SeriesDataModel}
	     */
	    getSeriesDataModel: function(seriesType) {
	        var rawSeriesData, chartType, SeriesDataModelClass;

	        if (!this.seriesDataModelMap[seriesType]) {
	            chartType = this.findChartType(seriesType);
	            rawSeriesData = this.rawData.series[seriesType];

	            if (predicate.isBoxplotChart(this.chartType)) {
	                SeriesDataModelClass = SeriesDataModelForBoxplot;
	            } else if (predicate.isTreemapChart(this.chartType)) {
	                SeriesDataModelClass = SeriesDataModelForTreemap;
	            } else if (predicate.isBulletChart(this.chartType)) {
	                SeriesDataModelClass = SeriesDataModelForBullet;
	            } else {
	                SeriesDataModelClass = SeriesDataModel;
	            }

	            this.seriesDataModelMap[seriesType] = new SeriesDataModelClass(rawSeriesData, chartType,
	                this.options, this.getFormatFunctions(), this.isCoordinateType());
	        }

	        return this.seriesDataModelMap[seriesType];
	    },

	    /**
	     * Get group count.
	     * @param {string} chartType chart type
	     * @returns {number}
	     */
	    getGroupCount: function(chartType) {
	        return this.getSeriesDataModel(chartType).getGroupCount();
	    },

	    /**
	     * Push category.
	     * @param {string} category - category
	     * @private
	     */
	    _pushCategory: function(category) {
	        if (this.rawData.categories) {
	            this.rawData.categories.push(category);
	            this.originalRawData.categories.push(category);
	        }
	    },

	    /**
	     * Shift category.
	     * @private
	     */
	    _shiftCategory: function() {
	        if (this.rawData.categories) {
	            this.rawData.categories.shift();
	            this.originalRawData.categories.shift();
	        }
	    },

	    /**
	     * Find raw series datum by name.
	     * @param {string} name - legend name
	     * @param {string} [seriesType] - series name
	     * @returns {object}
	     * @private
	     */
	    _findRawSeriesDatumByName: function(name, seriesType) {
	        var foundSeriesDatum = null;
	        var seriesData = this.rawData.series[seriesType];

	        snippet.forEachArray(seriesData, function(seriesDatum) {
	            var isEqual = seriesDatum.name === name;

	            if (isEqual) {
	                foundSeriesDatum = seriesDatum;
	            }

	            return !isEqual;
	        });

	        return foundSeriesDatum;
	    },

	    /**
	     * Push value to data property of series.
	     * @param {{name: string, data: Array}} seriesDatum - series datum
	     * @param {Array.<number>|{x: number, y: number, r: number}|number} value - value
	     * @param {string} seriesType - sereis name
	     * @private
	     */
	    _pushValue: function(seriesDatum, value, seriesType) {
	        var rawSeriesDatum = this._findRawSeriesDatumByName(seriesDatum.name, seriesType);

	        seriesDatum.data.push(value);

	        if (rawSeriesDatum) {
	            rawSeriesDatum.data.push(value);
	        }
	    },

	    /**
	     * Push values to series of originalRawData and series of rawData.
	     * @param {Array.<{name: string, data: Array}>} seriesData - series data
	     * @param {Array} values - values
	     * @param {string} [seriesType] - series name
	     * @private
	     */
	    _pushValues: function(seriesData, values, seriesType) {
	        var self = this;

	        snippet.forEachArray(seriesData, function(seriesDatum, index) {
	            self._pushValue(seriesDatum, values[index], seriesType);
	        });
	    },

	    /**
	     * Push series data.
	     * @param {Array.<number>} values - values
	     * @private
	     */
	    _pushSeriesData: function(values) {
	        var self = this;
	        var temp;

	        if (this.chartType !== 'combo' && snippet.isArray(values)) {
	            temp = values;
	            values = {};
	            values[this.chartType] = temp;
	        }

	        snippet.forEach(this.originalRawData.series, function(seriesData, seriesType) {
	            self._pushValues(seriesData, values[seriesType], seriesType);
	        });
	    },

	    /**
	     * Shift values.
	     * @param {Array.<{name: string, data: Array}>} seriesData - series data
	     * @param {string} seriesType - series name
	     * @private
	     */
	    _shiftValues: function(seriesData, seriesType) {
	        var self = this;

	        snippet.forEachArray(seriesData, function(seriesDatum) {
	            var rawSeriesDatum = self._findRawSeriesDatumByName(seriesDatum.name, seriesType);

	            seriesDatum.data.shift();
	            if (rawSeriesDatum) {
	                rawSeriesDatum.data.shift();
	            }
	        });
	    },

	    /**
	     * Shift series data.
	     * @private
	     */
	    _shiftSeriesData: function() {
	        var self = this;

	        snippet.forEach(this.originalRawData.series, function(seriesData, seriesType) {
	            self._shiftValues(seriesData, seriesType);
	        });
	    },

	    /**
	     * Add dynamic data.
	     * @param {string} category - category
	     * @param {Array.<number>} values - values
	     */
	    addDynamicData: function(category, values) {
	        this.dynamicData.push({
	            category: category,
	            values: values
	        });
	    },

	    /**
	     * Push dynamic data.
	     * @param {{category: string, values: Array.<number>}} data - adding data
	     * @private
	     */
	    _pushDynamicData: function(data) {
	        this._pushCategory(data.category);
	        this._pushSeriesData(data.values);
	    },

	    /**
	     * Push dynamic data for coordinate type.
	     * @param {object.<string, Array.<number>|object.<string, number>>} data - adding data
	     * @private
	     */
	    _pushDynamicDataForCoordinateType: function(data) {
	        var self = this;
	        snippet.forEachArray(this.originalRawData.series, function(seriesDatum) {
	            self._pushValue(seriesDatum, data[seriesDatum.name]);
	        });
	    },

	    /**
	     * Add data from dynamic data.
	     * @returns {boolean}
	     */
	    addDataFromDynamicData: function() {
	        var datum = this.dynamicData.shift();

	        if (datum) {
	            if (this.isCoordinateType()) {
	                this._pushDynamicDataForCoordinateType(datum.values);
	            } else {
	                this._pushDynamicData(datum);
	            }

	            this.initData(this.rawData);
	        }

	        return !!datum;
	    },

	    /**
	     * Shift data.
	     */
	    shiftData: function() {
	        this._shiftCategory();
	        this._shiftSeriesData();

	        this.initData(this.rawData);
	    },

	    /**
	     * Add data from remain dynamic data.
	     * @param {boolean} shiftingOption - whether has shifting option or not.
	     */
	    addDataFromRemainDynamicData: function(shiftingOption) {
	        var self = this;
	        var dynamicData = this.dynamicData;

	        this.dynamicData = [];

	        snippet.forEach(dynamicData, function(datum) {
	            self._pushCategory(datum.category);
	            self._pushSeriesData(datum.values);
	            if (shiftingOption) {
	                self._shiftCategory();
	                self._shiftSeriesData();
	            }
	        });

	        this.initData(this.rawData);
	    },

	    /**
	     * Traverse all SeriesDataModel by seriesTypes, and executes iteratee function.
	     * @param {function} iteratee iteratee function
	     * @private
	     */
	    _eachByAllSeriesDataModel: function(iteratee) {
	        var self = this,
	            seriesTypes = this.seriesTypes || [this.chartType];

	        snippet.forEachArray(seriesTypes, function(chartType) {
	            return iteratee(self.getSeriesDataModel(chartType), chartType);
	        });
	    },

	    /**
	     * Whether valid all SeriesDataModel or not.
	     * @returns {boolean}
	     */
	    isValidAllSeriesDataModel: function() {
	        var isValid = true;

	        this._eachByAllSeriesDataModel(function(seriesDataModel) {
	            isValid = !!seriesDataModel.getGroupCount();

	            return isValid;
	        });

	        return isValid;
	    },

	    /**
	     * Make SeriesGroups.
	     * @returns {Array.<SeriesGroup>}
	     * @private
	     */
	    _makeSeriesGroups: function() {
	        var joinedGroups = [],
	            seriesGroups;

	        this._eachByAllSeriesDataModel(function(seriesDataModel) {
	            seriesDataModel.each(function(seriesGroup, index) {
	                if (!joinedGroups[index]) {
	                    joinedGroups[index] = [];
	                }
	                joinedGroups[index] = joinedGroups[index].concat(seriesGroup.items);
	            });
	        });

	        seriesGroups = snippet.map(joinedGroups, function(items) {
	            return new SeriesGroup(items);
	        });

	        return seriesGroups;
	    },

	    /**
	     * Get SeriesGroups.
	     * @returns {Array.<SeriesGroup>}
	     */
	    getSeriesGroups: function() {
	        if (!this.seriesGroups) {
	            this.seriesGroups = this._makeSeriesGroups();
	        }

	        return this.seriesGroups;
	    },

	    /**
	     * Get value.
	     * @param {number} groupIndex group index
	     * @param {number} index index
	     * @param {?string} chartType chart type
	     * @returns {number} value
	     */
	    getValue: function(groupIndex, index, chartType) {
	        return this.getSeriesDataModel(chartType).getValue(groupIndex, index);
	    },

	    /**
	     * Get fallback datetime values
	     * @returns {number[]} milliseconds
	     */
	    getDefaultDatetimeValues: function() {
	        var hour = 60 * 60 * 1000;
	        var now = Date.now();

	        return [now - hour, now];
	    },

	    /**
	     * Return boolean value of whether seriesData empty or not
	     * @param {string} chartType Type string of chart
	     * @returns {boolean}
	     */
	    isSeriesDataEmpty: function(chartType) {
	        var rawData = this.rawData;
	        var seriesNotExist = rawData && !rawData.series;

	        return (
	            !rawData
	            || seriesNotExist
	            || (!(rawData.series[chartType])
	                || (rawData.series[chartType] && !(rawData.series[chartType].length)))
	        );
	    },

	    /**
	     * Return boolean value of whether axis limit option empty or not
	     * @param {string} axisType Type string of axis
	     * @returns {boolean}
	     */
	    isLimitOptionsEmpty: function(axisType) {
	        var axisOption = this.options[axisType] || {};

	        return isUndefined(axisOption.min) && isUndefined(axisOption.max);
	    },

	    /**
	     * Return boolean value of whether axis limit option empty or not
	     * @param {string} axisType Type string of axis
	     * @returns {boolean}
	     */
	    isLimitOptionsInsufficient: function(axisType) {
	        var axisOption = this.options[axisType] || {};

	        return isUndefined(axisOption.min) || isUndefined(axisOption.max);
	    },

	    /**
	     * Create values that picked value from SeriesItems of specific SeriesDataModel.
	     * @param {?string} chartType - type of chart
	     * @param {?string} valueType - type of value like value, x, y, r.
	     * @param {?string} axisName - name of axis value 'xAxis' 'yAxis'
	     * @returns {Array.<number>}
	     * @private
	     */
	    _createValues: function(chartType, valueType, axisName) {
	        var values, plotValues;
	        var options = this.options;
	        var plotOptions = options.plot;
	        var axisOption = options[axisName] || {};
	        var type = axisOption.type;
	        var isEmptyRawData = this.isSeriesDataEmpty(chartType);
	        var isEmptyLimitOptions = this.isLimitOptionsEmpty(axisName);

	        var isInsufficientLimitOptions = this.isLimitOptionsInsufficient(axisName);
	        var isLineOrAreaChart = (predicate.isLineChart(chartType) || predicate.isAreaChart(chartType)
	            || predicate.isLineAreaComboChart(chartType, this.seriesTypes));
	        var valueCandidate = this.defaultValues;

	        if (predicate.isComboChart(chartType)) {
	            values = [];
	            this._eachByAllSeriesDataModel(function(seriesDataModel) {
	                values = values.concat(seriesDataModel.getValues(valueType));
	            });
	        } else if (isEmptyRawData && isInsufficientLimitOptions) {
	            if (!isEmptyLimitOptions && isInsufficientLimitOptions) {
	                valueCandidate = valueCandidate.concat([(axisOption.min || axisOption.max)]);
	            }

	            if (valueType === 'x' && type === 'datetime') {
	                values = this.getDefaultDatetimeValues();

	                if (isLineOrAreaChart && plotOptions) {
	                    plotValues = this.getValuesFromPlotOptions(plotOptions, type);
	                    values = values.concat(plotValues);
	                }
	            } else {
	                values = valueCandidate;
	            }
	        } else {
	            values = this.getSeriesDataModel(chartType).getValues(valueType);
	        }

	        return values;
	    },

	    /**
	     * Get values of plot lines, and bands if it exist
	     * @param {{lines: Array.<object>, bands: Array.<object>}} plotOptions plot options
	     * @param {string} [axisType] axis value type 'value' 'datetime'
	     * @returns {Array.<number>}
	     */
	    getValuesFromPlotOptions: function(plotOptions, axisType) {
	        var values = [];

	        if (plotOptions.lines) {
	            snippet.forEach(plotOptions.lines, function(line) {
	                values.push(axisType !== 'datetime' ? line.value : new Date(line.value));
	            });
	        }

	        if (plotOptions.bands) {
	            snippet.forEach(plotOptions.bands, function(line) {
	                var ranges = snippet.map(line.range, function(range) {
	                    return axisType !== 'datetime' ? range : new Date(range);
	                });

	                values = values.concat(ranges);
	            });
	        }

	        return values;
	    },

	    /**
	     * Get values from valuesMap.
	     * @param {?string} chartType - type of chart
	     * @param {?string} valueType - type of value like value, x, y, r.
	     * @param {?string} axisType - type of axis value 'value', 'datetime'
	     * @returns {Array.<number>}
	     */
	    getValues: function(chartType, valueType, axisType) {
	        var mapKey;

	        // chartType = chartType || chartConst.DUMMY_KEY;
	        mapKey = chartType + valueType;

	        if (!this.valuesMap[mapKey]) {
	            this.valuesMap[mapKey] = this._createValues(chartType, valueType, axisType);
	        }

	        return this.valuesMap[mapKey];
	    },

	    /**
	     * Traverse SeriesGroup of all SeriesDataModel, and executes iteratee function.
	     * @param {function} iteratee iteratee function
	     * @param {boolean} [isPivot] - whether pivot or not
	     */
	    eachBySeriesGroup: function(iteratee, isPivot) {
	        this._eachByAllSeriesDataModel(function(seriesDataModel, chartType) {
	            seriesDataModel.each(function(seriesGroup, groupIndex) {
	                iteratee(seriesGroup, groupIndex, chartType);
	            }, isPivot);
	        });
	    },

	    /**
	     * Pick legend label.
	     * @param {object} item item
	     * @returns {string} label
	     * @private
	     */
	    _pickLegendLabel: function(item) {
	        return item.name ? snippet.encodeHTMLEntity(item.name) : null;
	    },

	    /**
	     * Pick legend visibility.
	     * @param {object} item item
	     * @returns {boolean}
	     * @private
	     */
	    _isVisibleLegend: function(item) {
	        var visibility = true;
	        if (snippet.isExisty(item.visible) && item.visible === false) {
	            visibility = false;
	        }

	        return visibility;
	    },

	    /**
	     * Pick legend labels or visibilities from raw data.
	     * @param {string} dataType data type of picking values
	     * @returns {string[]|boolean[]} labels or visibilities
	     * @private
	     */
	    _pickLegendData: function(dataType) {
	        var seriesData = this.rawData.series;
	        var result = {};
	        var pickerMethod;

	        if (dataType === 'visibility') {
	            pickerMethod = this._isVisibleLegend;
	        } else if (dataType === 'label') {
	            pickerMethod = this._pickLegendLabel;
	        }

	        if (pickerMethod) {
	            snippet.forEach(seriesData, function(seriesDatum, seriesType) {
	                result[seriesType] = snippet.map(seriesDatum, pickerMethod);
	            });

	            result = snippet.filter(result, snippet.isExisty);
	        }

	        return result;
	    },

	    /**
	     * Get legend labels.
	     * @param {?string} chartType chart type
	     * @returns {Array.<string> | {column: ?Array.<string>, line: ?Array.<string>}} legend labels
	     */
	    getLegendLabels: function(chartType) {
	        if (!this.legendLabels) {
	            this.legendLabels = this._pickLegendData('label');
	        }

	        return this.legendLabels[chartType] || this.legendLabels;
	    },

	    /**
	     * Get legend visibility.
	     * @param {?string} chartType chart type
	     * @returns {Array.<string> | {column: ?Array.<string>, line: ?Array.<string>}} legend labels
	     */
	    getLegendVisibility: function(chartType) {
	        if (!this.legendVisibilities) {
	            this.legendVisibilities = this._pickLegendData('visibility');
	        }

	        return this.legendVisibilities[chartType] || this.legendVisibilities;
	    },

	    /**
	     * Make legend data.
	     * @returns {Array} labels
	     * @private
	     */
	    _makeLegendData: function() {
	        var legendLabels = this.getLegendLabels(this.chartType);
	        var seriesTypes = this.seriesTypes || [this.chartType];
	        var legendLabelsMap, legendData;
	        var legendVisibilities = this.getLegendVisibility();

	        if (snippet.isArray(legendLabels)) {
	            legendLabelsMap = [this.chartType];
	            legendLabelsMap[this.chartType] = legendLabels;
	        } else {
	            seriesTypes = this.seriesTypes;
	            legendLabelsMap = legendLabels;
	        }

	        legendData = snippet.map(seriesTypes, function(chartType) {
	            return snippet.map(legendLabelsMap[chartType], function(label, index) {
	                var is2DArray = snippet.isArray(legendVisibilities[chartType]);

	                return {
	                    chartType: chartType,
	                    label: label,
	                    visible: is2DArray ? legendVisibilities[chartType][index] : legendVisibilities[index]
	                };
	            });
	        });

	        return concat.apply([], legendData);
	    },

	    /**
	     * Get legend data.
	     * @returns {Array.<{chartType: string, label: string}>} legend data
	     */
	    getLegendData: function() {
	        if (!this.legendData) {
	            this.legendData = this._makeLegendData();
	        }

	        if (!this.originalLegendData) {
	            this.originalLegendData = this.legendData;
	        }

	        return this.legendData;
	    },

	    /**
	     * get original legend data.
	     * @returns {Array.<{chartType: string, label: string}>}
	     */
	    getOriginalLegendData: function() {
	        return this.originalLegendData;
	    },

	    /**
	     * Get legend item.
	     * @param {number} index index
	     * @returns {{chartType: string, label: string}} legend data
	     */
	    getLegendItem: function(index) {
	        return this.getLegendData()[index];
	    },

	    /**
	     * Get first label of SeriesItem.
	     * @param {?string} chartType chartType
	     * @returns {string} formatted value
	     */
	    getFirstItemLabel: function(chartType) {
	        return this.getSeriesDataModel(chartType).getFirstItemLabel();
	    },

	    /**
	     * Add data ratios of pie chart.
	     * @param {string} chartType - type of chart.
	     */
	    addDataRatiosOfPieChart: function(chartType) {
	        this.getSeriesDataModel(chartType).addDataRatiosOfPieChart();
	    },

	    /**
	     * Add data ratios for chart of coordinate type.
	     * @param {string} chartType - type of chart.
	     * @param {{x: {min: number, max: number}, y: {min: number, max: number}}} limitMap - limit map
	     * @param {boolean} [hasRadius] - whether has radius or not
	     */
	    addDataRatiosForCoordinateType: function(chartType, limitMap, hasRadius) {
	        if (predicate.isLineTypeChart(chartType)) {
	            this._addStartValueToAllSeriesItem(limitMap.yAxis, chartType);
	        }
	        this.getSeriesDataModel(chartType).addDataRatiosForCoordinateType(limitMap, hasRadius);
	    },

	    /**
	     * Add start value to all series item.
	     * @param {{min: number, max: number}} limit - limit
	     * @param {string} chartType - chart type
	     * @private
	     */
	    _addStartValueToAllSeriesItem: function(limit, chartType) {
	        var start = 0;

	        if (limit.min >= 0) {
	            start = limit.min;
	        } else if (limit.max <= 0) {
	            start = limit.max;
	        }

	        this.getSeriesDataModel(chartType).addStartValueToAllSeriesItem(start);
	    },

	    /**
	     * Register percent values.
	     * @param {{min: number, max: number}} limit axis limit
	     * @param {string} stackType stackType option
	     * @param {string} chartType chart type
	     */
	    addDataRatios: function(limit, stackType, chartType) {
	        var seriesDataModel = this.getSeriesDataModel(chartType);

	        this._addStartValueToAllSeriesItem(limit, chartType);
	        seriesDataModel.addDataRatios(limit, stackType);
	    },

	    /**
	     * Add data ratios for treemap chart.
	     * @param {{min: number, max: number}} limit - limit
	     * @param {string} chartType - chart type
	     */
	    addDataRatiosForTreemapChart: function(limit, chartType) {
	        this.getSeriesDataModel(chartType).addDataRatios(limit);
	    },

	    /**
	     * Create base values for normal stackType chart.
	     * @param {string} chartType - chart type
	     * @returns {Array.<number>}
	     * @private
	     */
	    _createBaseValuesForNormalStackedChart: function(chartType) {
	        var seriesDataModel = this.getSeriesDataModel(chartType);
	        var baseValues = [];

	        seriesDataModel.each(function(seriesGroup) {
	            var valuesMap = seriesGroup._makeValuesMapPerStack();

	            snippet.forEach(valuesMap, function(values) {
	                var plusSum = calculator.sumPlusValues(values);
	                var minusSum = calculator.sumMinusValues(values);
	                baseValues = baseValues.concat([plusSum, minusSum]);
	            });
	        });

	        return baseValues;
	    },

	    /**
	     * Create base values for calculating limit
	     * @param {string} chartType - chart type
	     * @param {boolean} isSingleYAxis = whether single y axis or not
	     * @param {string} stackType - stack type
	     * @param {string} valueType - value type
	     * @param {string} axisType - value type
	     * @returns {Array.<number>}
	     */
	    createBaseValuesForLimit: function(chartType, isSingleYAxis, stackType, valueType, axisType) {
	        var baseValues;

	        if (predicate.isComboChart(this.chartType) && isSingleYAxis) {
	            baseValues = this.getValues(this.chartType, valueType);
	            if (predicate.isNormalStackChart(chartType, stackType)) {
	                baseValues = ba