/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Marker clusters module for Highcharts
 *
 * (c) 2010-2021 Wojciech Chmiel
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/marker-clusters",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,r){t.hasOwnProperty(e)||(t[e]=r.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Extensions/MarkerClusters/MarkerClusterDefaults.js",[],function(){return{cluster:{enabled:!1,allowOverlap:!0,animation:{duration:500},drillToCluster:!0,minimumClusterSize:2,layoutAlgorithm:{gridSize:50,distance:40,kmeansThreshold:100},marker:{symbol:"cluster",radius:15,lineWidth:0,lineColor:"#ffffff"},dataLabels:{enabled:!0,format:"{point.clusterPointsAmount}",verticalAlign:"middle",align:"center",style:{color:"contrast"},inside:!0}},tooltip:{clusterFormat:"<span>Clustered points: {point.clusterPointsAmount}</span><br/>"}}}),i(e,"Extensions/MarkerClusters/MarkerClusterScatter.js",[e["Core/Animation/AnimationUtilities.js"],e["Extensions/MarkerClusters/MarkerClusterDefaults.js"],e["Core/Utilities.js"]],function(t,e,i){var r,a=t.animObject,s=e.cluster,n=i.addEvent,o=i.defined,l=i.error,u=i.isArray,p=i.isFunction,d=i.isObject,h=i.isNumber,c=i.merge,m=i.objectEach,f=i.pushUnique,g=i.relativeLength,x=i.syncTimeout,y=[],C={grid:function(t,e,i,r){var a,s,n,o,l,u={},p=this.getGridOffset(),d=this.getScaledGridSize(r);for(l=0;l<t.length;l++){var h=Z(this,{x:t[l],y:e[l]});a=h.x-p.plotLeft,s=h.y-p.plotTop,n=Math.floor(a/d),u[o=Math.floor(s/d)+"-"+n]||(u[o]=[]),u[o].push({dataIndex:i[l],x:t[l],y:e[l]})}return u},kmeans:function(t,e,i,r){var a,n=[],o=[],l={},u=r.processedDistance||s.layoutAlgorithm.distance,p=r.iterations,d=0,h=!0,c=0,m=0,f=[];r.processedGridSize=r.processedDistance;var g=this.markerClusterAlgorithms?this.markerClusterAlgorithms.grid.call(this,t,e,i,r):{};for(var x in g)g[x].length>1&&(a=b(g[x]),n.push({posX:a.x,posY:a.y,oldX:0,oldY:0,startPointsLen:g[x].length,points:[]}));for(;h;){for(var y=0;y<n.length;y++)n[y].points.length=0;o.length=0;for(var C=0;C<t.length;C++)c=t[C],m=e[C],(f=this.getClusterDistancesFromPoint(n,c,m)).length&&f[0].distance<u?n[f[0].clusterIndex].points.push({x:c,y:m,dataIndex:i[C]}):o.push({x:c,y:m,dataIndex:i[C]});for(var C=0;C<n.length;C++)1===n[C].points.length&&(f=this.getClusterDistancesFromPoint(n,n[C].points[0].x,n[C].points[0].y))[1].distance<u&&(n[f[1].clusterIndex].points.push(n[C].points[0]),n[f[0].clusterIndex].points.length=0);h=!1;for(var C=0;C<n.length;C++)a=b(n[C].points),n[C].oldX=n[C].posX,n[C].oldY=n[C].posY,n[C].posX=a.x,n[C].posY=a.y,(n[C].posX>n[C].oldX+1||n[C].posX<n[C].oldX-1||n[C].posY>n[C].oldY+1||n[C].posY<n[C].oldY-1)&&(h=!0);p&&(h=d<p-1),d++}for(var C=0,k=n.length;C<k;++C)l["cluster"+C]=n[C].points;for(var C=0,k=o.length;C<k;++C)l["noise"+C]=[o[C]];return l},optimizedKmeans:function(t,e,i,r){var a,n,l,u=r.processedDistance||s.layoutAlgorithm.gridSize,p=this.getRealExtremes(),d=(this.options.cluster||{}).marker,h={};if(!this.markerClusterInfo||this.initMaxX&&this.initMaxX<p.maxX||this.initMinX&&this.initMinX>p.minX||this.initMaxY&&this.initMaxY<p.maxY||this.initMinY&&this.initMinY>p.minY)this.initMaxX=p.maxX,this.initMinX=p.minX,this.initMaxY=p.maxY,this.initMinY=p.minY,h=this.markerClusterAlgorithms?this.markerClusterAlgorithms.kmeans.call(this,t,e,i,r):{},this.baseClusters=null;else{this.baseClusters||(this.baseClusters={clusters:this.markerClusterInfo.clusters,noise:this.markerClusterInfo.noise});for(var c=0,m=this.baseClusters.clusters;c<m.length;c++){var f=m[c];f.pointsOutside=[],f.pointsInside=[];for(var g=0,x=f.data;g<x.length;g++){var y=x[g],C=Z(this,y),k=Z(this,f);a=Math.sqrt(Math.pow(C.x-k.x,2)+Math.pow(C.y-k.y,2)),n=u-(l=f.clusterZone&&f.clusterZone.marker&&f.clusterZone.marker.radius?f.clusterZone.marker.radius:d&&d.radius?d.radius:s.marker.radius)>=0?u-l:l,a>l+n&&o(f.pointsOutside)?f.pointsOutside.push(y):o(f.pointsInside)&&f.pointsInside.push(y)}f.pointsInside.length&&(h[f.id]=f.pointsInside);for(var v=0,M=0,I=f.pointsOutside;M<I.length;M++){var S=I[M];h[f.id+"_noise"+v++]=[S]}}for(var b=0,A=this.baseClusters.noise;b<A.length;b++){var X=A[b];h[X.id]=X.data}}return h}},k=[],v=0;function M(t,e,i){t.attr({opacity:e}).animate({opacity:1},i)}function I(t,e,i,r){S(t,r,i,!0,!0);for(var a=0;a<e.length;a++){var s=e[a];s.point&&s.point.destroy&&s.point.destroy()}}function S(t,e,i,r,a){t.point&&(r&&t.point.graphic&&(t.point.graphic.show(),M(t.point.graphic,e,i)),a&&t.point.dataLabel&&(t.point.dataLabel.show(),M(t.point.dataLabel,e,i)))}function b(t){for(var e=t.length,i=0,r=0,a=0;a<e;a++)i+=t[a].x,r+=t[a].y;return{x:i/e,y:r/e}}function A(t,e){var i=[];return i.length=e,t.clusters.forEach(function(t){t.data.forEach(function(t){i[t.dataIndex]=t})}),t.noise.forEach(function(t){i[t.data[0].dataIndex]=t.data[0]}),i}function X(){return Math.random().toString(36).substring(2,7)+"-"+v++}function Y(t,e,i){t.point&&(e&&t.point.graphic&&t.point.graphic.hide(),i&&t.point.dataLabel&&t.point.dataLabel.hide())}function D(t){(t.point||t.target).firePointEvent("drillToCluster",t,function(t){var e=t.point||t.target,i=e.series,r=e.series.xAxis,a=e.series.yAxis,s=e.series.chart,n=s.mapView;if((i.options.cluster||{}).drillToCluster&&e.clusteredData){var o=e.clusteredData.map(function(t){return t.x}).sort(function(t,e){return t-e}),l=e.clusteredData.map(function(t){return t.y}).sort(function(t,e){return t-e}),u=o[0],p=o[o.length-1],d=l[0],h=l[l.length-1],c=Math.abs((p-u)*.1),m=Math.abs((h-d)*.1),f=Math.min(u,p)-c,g=Math.max(u,p)+c,x=Math.min(d,h)-m,y=Math.max(d,h)+m;n?n.fitToBounds({x1:f,x2:g,y1:x,y2:y}):r&&a&&(s.pointer.zoomX=!0,s.pointer.zoomY=!0,s.zoom({originalEvent:t,xAxis:[{axis:r,min:f,max:g}],yAxis:[{axis:a,min:x,max:y}]}))}})}function L(t,e){var i=t.chart,r=t.xAxis,a=t.yAxis;return i.mapView?i.mapView.pixelsToProjectedUnits(e):{x:r?r.toValue(e.x):0,y:a?a.toValue(e.y):0}}function z(t){var e,i,r,s=this.chart,n=s.mapView,o=a((this.options.cluster||{}).animation),l=o.duration||500,u=(this.markerClusterInfo||{}).pointsState,p=(u||{}).newState,d=(u||{}).oldState,h=[],c=0,m=0,f=0,g=!1,y=!1;if(d&&p){var C=Z(this,i=p[t.stateId]);m=C.x-(n?0:s.plotLeft),f=C.y-(n?0:s.plotTop),1===i.parentsId.length?(e=d[(p||{})[t.stateId].parentsId[0]],i.point&&i.point.graphic&&e&&e.point&&e.point.plotX&&e.point.plotY&&e.point.plotX!==i.point.plotX&&e.point.plotY!==i.point.plotY&&(r=i.point.graphic.getBBox(),c=i.point.graphic&&i.point.graphic.isImg?0:r.width/2,i.point.graphic.attr({x:e.point.plotX-c,y:e.point.plotY-c}),i.point.graphic.animate({x:m-(i.point.graphic.radius||0),y:f-(i.point.graphic.radius||0)},o,function(){y=!0,e.point&&e.point.destroy&&e.point.destroy()}),i.point.dataLabel&&i.point.dataLabel.alignAttr&&e.point.dataLabel&&e.point.dataLabel.alignAttr&&(i.point.dataLabel.attr({x:e.point.dataLabel.alignAttr.x,y:e.point.dataLabel.alignAttr.y}),i.point.dataLabel.animate({x:i.point.dataLabel.alignAttr.x,y:i.point.dataLabel.alignAttr.y},o)))):0===i.parentsId.length?(Y(i,!0,!0),x(function(){S(i,.1,o,!0,!0)},l/2)):(Y(i,!0,!0),i.parentsId.forEach(function(t){d&&d[t]&&(e=d[t],h.push(e),e.point&&e.point.graphic&&(g=!0,e.point.graphic.show(),e.point.graphic.animate({x:m-(e.point.graphic.radius||0),y:f-(e.point.graphic.radius||0),opacity:.4},o,function(){y=!0,I(i,h,o,.7)}),e.point.dataLabel&&-9999!==e.point.dataLabel.y&&i.point&&i.point.dataLabel&&i.point.dataLabel.alignAttr&&(e.point.dataLabel.show(),e.point.dataLabel.animate({x:i.point.dataLabel.alignAttr.x,y:i.point.dataLabel.alignAttr.y,opacity:.4},o))))}),x(function(){y||I(i,h,o,.85)},l),g||x(function(){I(i,h,o,.1)},l/2))}}function P(){(this.markerClusterSeriesData||[]).forEach(function(t){t&&t.destroy&&t.destroy()}),this.markerClusterSeriesData=null}function E(){var t,e,i,a,l,u,d,c,m,f,x,y,C,k,v,M,I=this,S=I.chart,b=S.mapView,A=I.xData,X=I.yData,Y=I.options.cluster,z=I.getRealExtremes(),P=[],E=[],w=[];if(b&&I.is("mappoint")&&A&&X&&(I.options.data||[]).forEach(function(t,e){var i=I.projectPoint(t);i&&(A[e]=i.x,X[e]=i.y)}),Y&&Y.enabled&&A&&A.length&&X&&X.length&&!S.polar){x=Y.layoutAlgorithm.type,(k=Y.layoutAlgorithm).processedGridSize=g(k.gridSize||s.layoutAlgorithm.gridSize,S.plotWidth),k.processedDistance=g(k.distance||s.layoutAlgorithm.distance,S.plotWidth),a=k.kmeansThreshold||s.layoutAlgorithm.kmeansThreshold;var j=k.processedGridSize/2,O=L(I,{x:0,y:0}),T=L(I,{x:j,y:j});for(M=0,l=Math.abs(O.x-T.x),u=Math.abs(O.y-T.y);M<A.length;M++)!I.dataMaxX&&(o(c)&&o(d)&&o(f)&&o(m)?h(X[M])&&h(f)&&h(m)&&(c=Math.max(A[M],c),d=Math.min(A[M],d),f=Math.max(X[M]||f,f),m=Math.min(X[M]||m,m)):(c=d=A[M],f=m=X[M])),A[M]>=z.minX-l&&A[M]<=z.maxX+l&&(X[M]||z.minY)>=z.minY-u&&(X[M]||z.maxY)<=z.maxY+u&&(P.push(A[M]),E.push(X[M]),w.push(M));o(c)&&o(d)&&h(f)&&h(m)&&(I.dataMaxX=c,I.dataMinX=d,I.dataMaxY=f,I.dataMinY=m),y=(C=(p(x)?x:I.markerClusterAlgorithms?x&&I.markerClusterAlgorithms[x]?I.markerClusterAlgorithms[x]:P.length<a?I.markerClusterAlgorithms.kmeans:I.markerClusterAlgorithms.grid:function(){return!1}).call(this,P,E,w,k))?I.getClusteredData(C,Y):C,Y.animation&&I.markerClusterInfo&&I.markerClusterInfo.pointsState&&I.markerClusterInfo.pointsState.oldState?(function(t){if(t)for(var e=void 0,i=0,r=Object.keys(t);i<r.length;i++)(e=t[r[i]]).point&&e.point.destroy&&e.point.destroy()}(I.markerClusterInfo.pointsState.oldState),t=I.markerClusterInfo.pointsState.newState):t={},e=A.length,i=I.markerClusterInfo,y&&(I.processedXData=y.groupedXData,I.processedYData=y.groupedYData,I.hasGroupedData=!0,I.markerClusterInfo=y,I.groupMap=y.groupMap),r.apply(this),y&&I.markerClusterInfo&&((I.markerClusterInfo.clusters||[]).forEach(function(t){(v=I.points[t.index]).isCluster=!0,v.clusteredData=t.data,v.clusterPointsAmount=t.data.length,t.point=v,n(v,"click",D)}),(I.markerClusterInfo.noise||[]).forEach(function(t){t.point=I.points[t.index]}),Y.animation&&I.markerClusterInfo&&(I.markerClusterInfo.pointsState={oldState:t,newState:I.getPointsState(y,i,e)}),Y.animation?this.hideClusteredData():this.destroyClusteredData(),this.markerClusterSeriesData=this.hasGroupedData?this.points:null)}else r.apply(this)}function w(t,e,i){for(var r=[],a=0;a<t.length;a++){var s=Z(this,{x:e,y:i}),n=Z(this,{x:t[a].posX,y:t[a].posY}),o=Math.sqrt(Math.pow(s.x-n.x,2)+Math.pow(s.y-n.y,2));r.push({clusterIndex:a,distance:o})}return r.sort(function(t,e){return t.distance-e.distance})}function j(t,e){var i,r,a,n,o,h,m,f,g,x,y,C,k,v,M=[],I=[],S=[],A=[],Y=[],D=Math.max(2,e.minimumClusterSize||2),L=0;if(p(e.layoutAlgorithm.type)&&!this.isValidGroupedDataObject(t))return l("Highcharts marker-clusters module: The custom algorithm result is not valid!",!1,this.chart),!1;for(v in t)if(t[v].length>=D){if(a=t[v],i=X(),o=a.length,e.zones)for(k=0;k<e.zones.length;k++)o>=e.zones[k].from&&o<=e.zones[k].to&&((y=e.zones[k]).zoneIndex=k,x=e.zones[k].marker,C=e.zones[k].className);for(g=b(a),"grid"!==e.layoutAlgorithm.type||e.allowOverlap?m={x:g.x,y:g.y}:(h=this.options.marker||{},m=this.preventClusterCollisions({x:g.x,y:g.y,key:v,groupedData:t,gridSize:this.getScaledGridSize(e.layoutAlgorithm),defaultRadius:h.radius||3+(h.lineWidth||0),clusterRadius:x&&x.radius?x.radius:(e.marker||{}).radius||s.marker.radius})),k=0;k<o;k++)a[k].parentStateId=i;if(S.push({x:m.x,y:m.y,id:v,stateId:i,index:L,data:a,clusterZone:y,clusterZoneClassName:C}),M.push(m.x),I.push(m.y),Y.push({options:{formatPrefix:"cluster",dataLabels:e.dataLabels,marker:c(e.marker,{states:e.states},x||{})}}),this.options.data&&this.options.data.length)for(k=0;k<o;k++)d(this.options.data[a[k].dataIndex])&&(a[k].options=this.options.data[a[k].dataIndex]);L++,x=null}else for(k=0;k<t[v].length;k++)r=t[v][k],i=X(),f=null,n=((this.options||{}).data||[])[r.dataIndex],M.push(r.x),I.push(r.y),r.parentStateId=i,A.push({x:r.x,y:r.y,id:v,stateId:i,index:L,data:t[v]}),f=n&&"object"==typeof n&&!u(n)?c(n,{x:r.x,y:r.y}):{userOptions:n,x:r.x,y:r.y},Y.push({options:f}),L++;return{clusters:S,noise:A,groupedXData:M,groupedYData:I,groupMap:Y}}function O(){var t=this.chart,e=this.xAxis,i=this.yAxis,r=0;return{plotLeft:e&&this.dataMinX&&this.dataMaxX?e.reversed?e.toPixels(this.dataMaxX):e.toPixels(this.dataMinX):t.plotLeft,plotTop:i&&this.dataMinY&&this.dataMaxY?i.reversed?i.toPixels(this.dataMinY):i.toPixels(this.dataMaxY):t.plotTop}}function T(t,e,i){var r,a,s=e?A(e,i):[],n=A(t,i),o={};k=[],t.clusters.forEach(function(t){o[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}}),t.noise.forEach(function(t){o[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}});for(var l=0;l<n.length;l++)r=n[l],a=s[l],r&&a&&r.parentStateId&&a.parentStateId&&o[r.parentStateId]&&-1===o[r.parentStateId].parentsId.indexOf(a.parentStateId)&&(o[r.parentStateId].parentsId.push(a.parentStateId),-1===k.indexOf(a.parentStateId)&&k.push(a.parentStateId));return o}function V(){var t=this.chart,e=t.mapView?0:t.plotLeft,i=L(this,{x:e,y:t.mapView?0:t.plotTop}),r=L(this,{x:e+t.plotWidth,y:e+t.plotHeight}),a=i.x,s=r.x,n=i.y,o=r.y;return{minX:Math.min(a,s),maxX:Math.max(a,s),minY:Math.min(n,o),maxY:Math.max(n,o)}}function G(t){var e=this.xAxis,i=this.chart.mapView,r=t.processedGridSize||s.layoutAlgorithm.gridSize,a=!0,n=1,o=1;this.gridValueSize||(i?this.gridValueSize=r/i.getScale():this.gridValueSize=Math.abs(e.toValue(r)-e.toValue(0)));for(var l=+(r/(i?this.gridValueSize*i.getScale():e.toPixels(this.gridValueSize)-e.toPixels(0))).toFixed(14);a&&1!==l;){var u=Math.pow(2,n);l>.75&&l<1.25?a=!1:l>=1/u&&l<2*(1/u)?(a=!1,o=u):l<=u&&l>u/2&&(a=!1,o=1/u),n++}return r/o/l}function R(){var t=this.markerClusterSeriesData,e=((this.markerClusterInfo||{}).pointsState||{}).oldState||{},i=k.map(function(t){return(e[t].point||{}).id||""});(t||[]).forEach(function(t){t&&-1!==i.indexOf(t.id)?(t.graphic&&t.graphic.hide(),t.dataLabel&&t.dataLabel.hide()):t&&t.destroy&&t.destroy()})}function U(t){var e,i=!1;return!!d(t)&&(m(t,function(t){if(i=!0,!u(t)||!t.length){i=!1;return}for(e=0;e<t.length;e++)if(!d(t[e])||!t[e].x||!t[e].y){i=!1;return}}),i)}function F(t){var e,i,r,a,n,l,u,p,d,h,c,m,f,g,x=t.key.split("-").map(parseFloat),y=x[0],C=x[1],k=t.gridSize,v=t.groupedData,M=t.defaultRadius,I=t.clusterRadius,S=C*k,A=y*k,X=Z(this,t),Y=[],D=(this.options.cluster||{}).marker,z=(this.options.cluster||{}).zones,P=this.getGridOffset(),E=X.x,w=X.y,j=0,O=0;for(E-=P.plotLeft,w-=P.plotTop,p=1;p<5;p++)for(d=0,a=p%2?-1:1,n=p<3?-1:1,l=Math.floor((E+a*I)/k),g=[(u=Math.floor((w+n*I)/k))+"-"+l,u+"-"+C,y+"-"+l];d<g.length;d++)-1===Y.indexOf(g[d])&&g[d]!==t.key&&Y.push(g[d]);for(var T=0;T<Y.length;T++){var V=Y[T];if(v[V]){v[V].posX||(m=b(v[V]),v[V].posX=m.x,v[V].posY=m.y);var G=Z(this,{x:v[V].posX||0,y:v[V].posY||0});if(i=G.x-P.plotLeft,r=G.y-P.plotTop,c=(e=V.split("-").map(parseFloat))[0],h=e[1],z)for(p=0,j=v[V].length;p<z.length;p++)j>=z[p].from&&j<=z[p].to&&(O=o((z[p].marker||{}).radius)?z[p].marker.radius||0:D&&D.radius?D.radius:s.marker.radius);v[V].length>1&&0===O&&D&&D.radius?O=D.radius:1===v[V].length&&(O=M),f=I+O,O=0,h!==C&&Math.abs(E-i)<f&&(E=h-C<0?S+I:S+k-I),c!==y&&Math.abs(w-r)<f&&(w=c-y<0?A+I:A+k-I)}}var R=L(this,{x:E+P.plotLeft,y:w+P.plotTop});return v[t.key].posX=R.x,v[t.key].posY=R.y,R}function Z(t,e){var i=t.chart,r=t.xAxis,a=t.yAxis;return i.mapView?i.mapView.projectedUnitsToPixels(e):{x:r?r.toPixels(e.x):0,y:a?a.toPixels(e.y):0}}return{compose:function(t,i){if(f(y,i)){var a=i.prototype;r=a.generatePoints,a.markerClusterAlgorithms=C,a.animateClusterPoint=z,a.destroyClusteredData=P,a.generatePoints=E,a.getClusterDistancesFromPoint=w,a.getClusteredData=j,a.getGridOffset=O,a.getPointsState=T,a.getRealExtremes=V,a.getScaledGridSize=G,a.hideClusteredData=R,a.isValidGroupedDataObject=U,a.preventClusterCollisions=F,n(i,"destroy",a.destroyClusteredData)}f(y,t)&&((t.plotOptions||{}).series=c((t.plotOptions||{}).series,e))}}}),i(e,"Extensions/MarkerClusters/MarkerClusters.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Defaults.js"],e["Extensions/MarkerClusters/MarkerClusterDefaults.js"],e["Extensions/MarkerClusters/MarkerClusterScatter.js"],e["Core/Utilities.js"]],function(t,e,i,r,a){var s=t.animObject,n=e.defaultOptions,o=a.addEvent,l=a.defined,u=a.error,p=a.isFunction,d=a.merge,h=a.pushUnique,c=a.syncTimeout,m=[];function f(){for(var t=this.chart,e=0,i=0,r=t.series;i<r.length;i++){var a=r[i];a.markerClusterInfo&&(e=s((a.options.cluster||{}).animation).duration||0)}c(function(){t.tooltip&&t.tooltip.destroy()},e)}function g(){for(var t=0,e=this.series||[];t<e.length;t++){var i=e[t];if(i.markerClusterInfo){var r=i.options.cluster,a=((i.markerClusterInfo||{}).pointsState||{}).oldState;if((r||{}).animation&&i.markerClusterInfo&&0===i.chart.pointer.pinchDown.length&&"pan"!==((i.xAxis||{}).eventArgs||{}).trigger&&a&&Object.keys(a).length){for(var s=0,n=i.markerClusterInfo.clusters;s<n.length;s++){var o=n[s];i.animateClusterPoint(o)}for(var l=0,u=i.markerClusterInfo.noise;l<u.length;l++){var p=u[l];i.animateClusterPoint(p)}}}}}function x(t){var e=(((t.point||t.target).series.options.cluster||{}).events||{}).drillToCluster;p(e)&&e.call(this,t)}function y(){if(this.dataGroup)return u("Highcharts marker-clusters module: Running `Point.update` when point belongs to clustered series is not supported.",!1,this.series.chart),!1}function C(){var t=(this.options.cluster||{}).drillToCluster;if(this.markerClusterInfo&&this.markerClusterInfo.clusters)for(var e=0,i=this.markerClusterInfo.clusters;e<i.length;e++){var r=i[e];r.point&&r.point.graphic&&(r.point.graphic.addClass("highcharts-cluster-point"),t&&r.point&&(r.point.graphic.css({cursor:"pointer"}),r.point.dataLabel&&r.point.dataLabel.css({cursor:"pointer"})),l(r.clusterZone)&&r.point.graphic.addClass(r.clusterZoneClassName||"highcharts-cluster-zone-"+r.clusterZone.zoneIndex))}}return(n.plotOptions||{}).series=d((n.plotOptions||{}).series,i),{compose:function(t,e,i,a){var s=a.prototype.pointClass;h(m,t)&&o(t,"setExtremes",f),h(m,e)&&o(e,"render",g),h(m,s)&&(o(s,"drillToCluster",x),o(s,"update",y)),h(m,a)&&o(a,"afterRender",C);var n=a.types.scatter;n&&r.compose(i,n)}}}),i(e,"Extensions/MarkerClusters/MarkerClusterSymbols.js",[e["Core/Utilities.js"]],function(t){var e,i=t.pushUnique,r=[];function a(t,i,r,a){var s=r/2,n=a/2,o=e.arc(t+s,i+n,s-4,n-4,{start:.5*Math.PI,end:2.5*Math.PI,open:!1}),l=e.arc(t+s,i+n,s-3,n-3,{start:.5*Math.PI,end:2.5*Math.PI,innerR:s-2,open:!1});return e.arc(t+s,i+n,s-1,n-1,{start:.5*Math.PI,end:2.5*Math.PI,innerR:s,open:!1}).concat(l,o)}return{compose:function(t){i(r,t)&&((e=t.prototype.symbols).cluster=a)}}}),i(e,"masters/modules/marker-clusters.src.js",[e["Core/Globals.js"],e["Extensions/MarkerClusters/MarkerClusters.js"],e["Extensions/MarkerClusters/MarkerClusterSymbols.js"]],function(t,e,i){e.compose(t.Axis,t.Chart,t.defaultOptions,t.Series),i.compose(t.SVGRenderer)})});//# sourceMappingURL=marker-clusters.js.map