/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Marker clusters module for Highcharts
 *
 * (c) 2010-2021 Wojciech Chmiel
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/marker-clusters",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,s){t.hasOwnProperty(e)||(t[e]=s.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Extensions/MarkerClusters/MarkerClusterDefaults.js",[],function(){return{cluster:{enabled:!1,allowOverlap:!0,animation:{duration:500},drillToCluster:!0,minimumClusterSize:2,layoutAlgorithm:{gridSize:50,distance:40,kmeansThreshold:100},marker:{symbol:"cluster",radius:15,lineWidth:0,lineColor:"#ffffff"},dataLabels:{enabled:!0,format:"{point.clusterPointsAmount}",verticalAlign:"middle",align:"center",style:{color:"contrast"},inside:!0}},tooltip:{clusterFormat:"<span>Clustered points: {point.clusterPointsAmount}</span><br/>"}}}),i(e,"Extensions/MarkerClusters/MarkerClusterScatter.js",[e["Core/Animation/AnimationUtilities.js"],e["Extensions/MarkerClusters/MarkerClusterDefaults.js"],e["Core/Utilities.js"]],function(t,e,i){let s;let{animObject:a}=t,{cluster:r}=e,{addEvent:o,defined:n,error:l,isArray:p,isFunction:u,isObject:d,isNumber:h,merge:c,objectEach:f,pushUnique:m,relativeLength:g,syncTimeout:x}=i,y=[],C={grid:function(t,e,i,s){let a,r,o,n,l;let p={},u=this.getGridOffset(),d=this.getScaledGridSize(s);for(l=0;l<t.length;l++){let s=H(this,{x:t[l],y:e[l]});a=s.x-u.plotLeft,r=s.y-u.plotTop,o=Math.floor(a/d),p[n=Math.floor(r/d)+"-"+o]||(p[n]=[]),p[n].push({dataIndex:i[l],x:t[l],y:e[l]})}return p},kmeans:function(t,e,i,s){let a=[],o=[],n={},l=s.processedDistance||r.layoutAlgorithm.distance,p=s.iterations,u=0,d=!0,h=0,c=0,f,m=[];s.processedGridSize=s.processedDistance;let g=this.markerClusterAlgorithms?this.markerClusterAlgorithms.grid.call(this,t,e,i,s):{};for(let t in g)g[t].length>1&&(f=A(g[t]),a.push({posX:f.x,posY:f.y,oldX:0,oldY:0,startPointsLen:g[t].length,points:[]}));for(;d;){for(let t of a)t.points.length=0;o.length=0;for(let s=0;s<t.length;s++)h=t[s],c=e[s],(m=this.getClusterDistancesFromPoint(a,h,c)).length&&m[0].distance<l?a[m[0].clusterIndex].points.push({x:h,y:c,dataIndex:i[s]}):o.push({x:h,y:c,dataIndex:i[s]});for(let t=0;t<a.length;t++)1===a[t].points.length&&(m=this.getClusterDistancesFromPoint(a,a[t].points[0].x,a[t].points[0].y))[1].distance<l&&(a[m[1].clusterIndex].points.push(a[t].points[0]),a[m[0].clusterIndex].points.length=0);d=!1;for(let t=0;t<a.length;t++)f=A(a[t].points),a[t].oldX=a[t].posX,a[t].oldY=a[t].posY,a[t].posX=f.x,a[t].posY=f.y,(a[t].posX>a[t].oldX+1||a[t].posX<a[t].oldX-1||a[t].posY>a[t].oldY+1||a[t].posY<a[t].oldY-1)&&(d=!0);p&&(d=u<p-1),u++}for(let t=0,e=a.length;t<e;++t)n["cluster"+t]=a[t].points;for(let t=0,e=o.length;t<e;++t)n["noise"+t]=[o[t]];return n},optimizedKmeans:function(t,e,i,s){let a=s.processedDistance||r.layoutAlgorithm.gridSize,o=this.getRealExtremes(),l=(this.options.cluster||{}).marker,p,u={},d,h;if(!this.markerClusterInfo||this.initMaxX&&this.initMaxX<o.maxX||this.initMinX&&this.initMinX>o.minX||this.initMaxY&&this.initMaxY<o.maxY||this.initMinY&&this.initMinY>o.minY)this.initMaxX=o.maxX,this.initMinX=o.minX,this.initMaxY=o.maxY,this.initMinY=o.minY,u=this.markerClusterAlgorithms?this.markerClusterAlgorithms.kmeans.call(this,t,e,i,s):{},this.baseClusters=null;else{for(let t of(this.baseClusters||(this.baseClusters={clusters:this.markerClusterInfo.clusters,noise:this.markerClusterInfo.noise}),this.baseClusters.clusters)){for(let e of(t.pointsOutside=[],t.pointsInside=[],t.data)){let i=H(this,e),s=H(this,t);p=Math.sqrt(Math.pow(i.x-s.x,2)+Math.pow(i.y-s.y,2)),d=a-(h=t.clusterZone&&t.clusterZone.marker&&t.clusterZone.marker.radius?t.clusterZone.marker.radius:l&&l.radius?l.radius:r.marker.radius)>=0?a-h:h,p>h+d&&n(t.pointsOutside)?t.pointsOutside.push(e):n(t.pointsInside)&&t.pointsInside.push(e)}t.pointsInside.length&&(u[t.id]=t.pointsInside);let e=0;for(let i of t.pointsOutside)u[t.id+"_noise"+e++]=[i]}for(let t of this.baseClusters.noise)u[t.id]=t.data}return u}},k=[],M=0;function I(t,e,i){t.attr({opacity:e}).animate({opacity:1},i)}function S(t,e,i,s){for(let a of(b(t,s,i,!0,!0),e))a.point&&a.point.destroy&&a.point.destroy()}function b(t,e,i,s,a){t.point&&(s&&t.point.graphic&&(t.point.graphic.show(),I(t.point.graphic,e,i)),a&&t.point.dataLabel&&(t.point.dataLabel.show(),I(t.point.dataLabel,e,i)))}function A(t){let e=t.length,i=0,s=0;for(let a=0;a<e;a++)i+=t[a].x,s+=t[a].y;return{x:i/e,y:s/e}}function X(t,e){let i=[];return i.length=e,t.clusters.forEach(function(t){t.data.forEach(function(t){i[t.dataIndex]=t})}),t.noise.forEach(function(t){i[t.data[0].dataIndex]=t.data[0]}),i}function Y(){return Math.random().toString(36).substring(2,7)+"-"+M++}function D(t,e,i){t.point&&(e&&t.point.graphic&&t.point.graphic.hide(),i&&t.point.dataLabel&&t.point.dataLabel.hide())}function L(t){let e=t.point||t.target;e.firePointEvent("drillToCluster",t,function(t){let e=t.point||t.target,i=e.series,s=e.series.xAxis,a=e.series.yAxis,r=e.series.chart,o=r.mapView,n=i.options.cluster,l=(n||{}).drillToCluster;if(l&&e.clusteredData){let i=e.clusteredData.map(t=>t.x).sort((t,e)=>t-e),n=e.clusteredData.map(t=>t.y).sort((t,e)=>t-e),l=i[0],p=i[i.length-1],u=n[0],d=n[n.length-1],h=Math.abs((p-l)*.1),c=Math.abs((d-u)*.1),f=Math.min(l,p)-h,m=Math.max(l,p)+h,g=Math.min(u,d)-c,x=Math.max(u,d)+c;o?o.fitToBounds({x1:f,x2:m,y1:g,y2:x}):s&&a&&(r.pointer.zoomX=!0,r.pointer.zoomY=!0,r.zoom({originalEvent:t,xAxis:[{axis:s,min:f,max:m}],yAxis:[{axis:a,min:g,max:x}]}))}})}function z(t,e){let{chart:i,xAxis:s,yAxis:a}=t;return i.mapView?i.mapView.pixelsToProjectedUnits(e):{x:s?s.toValue(e.x):0,y:a?a.toValue(e.y):0}}function P(t){let e=this.chart,i=e.mapView,s=this.options.cluster,r=a((s||{}).animation),o=r.duration||500,n=(this.markerClusterInfo||{}).pointsState,l=(n||{}).newState,p=(n||{}).oldState,u=[],d,h,c,f=0,m=0,g=0,y=!1,C=!1;if(p&&l){h=l[t.stateId];let s=H(this,h);m=s.x-(i?0:e.plotLeft),g=s.y-(i?0:e.plotTop),1===h.parentsId.length?(d=p[(l||{})[t.stateId].parentsId[0]],h.point&&h.point.graphic&&d&&d.point&&d.point.plotX&&d.point.plotY&&d.point.plotX!==h.point.plotX&&d.point.plotY!==h.point.plotY&&(c=h.point.graphic.getBBox(),f=h.point.graphic&&h.point.graphic.isImg?0:c.width/2,h.point.graphic.attr({x:d.point.plotX-f,y:d.point.plotY-f}),h.point.graphic.animate({x:m-(h.point.graphic.radius||0),y:g-(h.point.graphic.radius||0)},r,function(){C=!0,d.point&&d.point.destroy&&d.point.destroy()}),h.point.dataLabel&&h.point.dataLabel.alignAttr&&d.point.dataLabel&&d.point.dataLabel.alignAttr&&(h.point.dataLabel.attr({x:d.point.dataLabel.alignAttr.x,y:d.point.dataLabel.alignAttr.y}),h.point.dataLabel.animate({x:h.point.dataLabel.alignAttr.x,y:h.point.dataLabel.alignAttr.y},r)))):0===h.parentsId.length?(D(h,!0,!0),x(function(){b(h,.1,r,!0,!0)},o/2)):(D(h,!0,!0),h.parentsId.forEach(function(t){p&&p[t]&&(d=p[t],u.push(d),d.point&&d.point.graphic&&(y=!0,d.point.graphic.show(),d.point.graphic.animate({x:m-(d.point.graphic.radius||0),y:g-(d.point.graphic.radius||0),opacity:.4},r,function(){C=!0,S(h,u,r,.7)}),d.point.dataLabel&&-9999!==d.point.dataLabel.y&&h.point&&h.point.dataLabel&&h.point.dataLabel.alignAttr&&(d.point.dataLabel.show(),d.point.dataLabel.animate({x:h.point.dataLabel.alignAttr.x,y:h.point.dataLabel.alignAttr.y,opacity:.4},r))))}),x(function(){C||S(h,u,r,.85)},o),y||x(function(){S(h,u,r,.1)},o/2))}}function w(){let t=this.markerClusterSeriesData;(t||[]).forEach(function(t){t&&t.destroy&&t.destroy()}),this.markerClusterSeriesData=null}function E(){let t,e,i,a,l,p,d,c,f,m,x,y,C,k,M,I;let S=this,b=S.chart,A=b.mapView,X=S.xData,Y=S.yData,D=S.options.cluster,P=S.getRealExtremes(),w=[],E=[],j=[];if(A&&S.is("mappoint")&&X&&Y&&(S.options.data||[]).forEach((t,e)=>{let i=S.projectPoint(t);i&&(X[e]=i.x,Y[e]=i.y)}),D&&D.enabled&&X&&X.length&&Y&&Y.length&&!b.polar){x=D.layoutAlgorithm.type,(k=D.layoutAlgorithm).processedGridSize=g(k.gridSize||r.layoutAlgorithm.gridSize,b.plotWidth),k.processedDistance=g(k.distance||r.layoutAlgorithm.distance,b.plotWidth),a=k.kmeansThreshold||r.layoutAlgorithm.kmeansThreshold;let A=k.processedGridSize/2,O=z(S,{x:0,y:0}),V=z(S,{x:A,y:A});for(I=0,l=Math.abs(O.x-V.x),p=Math.abs(O.y-V.y);I<X.length;I++)!S.dataMaxX&&(n(c)&&n(d)&&n(m)&&n(f)?h(Y[I])&&h(m)&&h(f)&&(c=Math.max(X[I],c),d=Math.min(X[I],d),m=Math.max(Y[I]||m,m),f=Math.min(Y[I]||f,f)):(c=d=X[I],m=f=Y[I])),X[I]>=P.minX-l&&X[I]<=P.maxX+l&&(Y[I]||P.minY)>=P.minY-p&&(Y[I]||P.maxY)<=P.maxY+p&&(w.push(X[I]),E.push(Y[I]),j.push(I));n(c)&&n(d)&&h(m)&&h(f)&&(S.dataMaxX=c,S.dataMinX=d,S.dataMaxY=m,S.dataMinY=f),y=(C=(u(x)?x:S.markerClusterAlgorithms?x&&S.markerClusterAlgorithms[x]?S.markerClusterAlgorithms[x]:w.length<a?S.markerClusterAlgorithms.kmeans:S.markerClusterAlgorithms.grid:function(){return!1}).call(this,w,E,j,k))?S.getClusteredData(C,D):C,D.animation&&S.markerClusterInfo&&S.markerClusterInfo.pointsState&&S.markerClusterInfo.pointsState.oldState?(function(t){if(t){let e;for(let i of Object.keys(t))(e=t[i]).point&&e.point.destroy&&e.point.destroy()}}(S.markerClusterInfo.pointsState.oldState),t=S.markerClusterInfo.pointsState.newState):t={},e=X.length,i=S.markerClusterInfo,y&&(S.processedXData=y.groupedXData,S.processedYData=y.groupedYData,S.hasGroupedData=!0,S.markerClusterInfo=y,S.groupMap=y.groupMap),s.apply(this),y&&S.markerClusterInfo&&((S.markerClusterInfo.clusters||[]).forEach(function(t){(M=S.points[t.index]).isCluster=!0,M.clusteredData=t.data,M.clusterPointsAmount=t.data.length,t.point=M,o(M,"click",L)}),(S.markerClusterInfo.noise||[]).forEach(function(t){t.point=S.points[t.index]}),D.animation&&S.markerClusterInfo&&(S.markerClusterInfo.pointsState={oldState:t,newState:S.getPointsState(y,i,e)}),D.animation?this.hideClusteredData():this.destroyClusteredData(),this.markerClusterSeriesData=this.hasGroupedData?this.points:null)}else s.apply(this)}function j(t,e,i){let s=[];for(let a=0;a<t.length;a++){let r=H(this,{x:e,y:i}),o=H(this,{x:t[a].posX,y:t[a].posY}),n=Math.sqrt(Math.pow(r.x-o.x,2)+Math.pow(r.y-o.y,2));s.push({clusterIndex:a,distance:n})}return s.sort((t,e)=>t.distance-e.distance)}function O(t,e){let i=[],s=[],a=[],o=[],n=[],h=Math.max(2,e.minimumClusterSize||2),f=0,m,g,x,y,C,k,M,I,S,b,X,D,L,z;if(u(e.layoutAlgorithm.type)&&!this.isValidGroupedDataObject(t))return l("Highcharts marker-clusters module: The custom algorithm result is not valid!",!1,this.chart),!1;for(z in t)if(t[z].length>=h){if(x=t[z],m=Y(),C=x.length,e.zones)for(L=0;L<e.zones.length;L++)C>=e.zones[L].from&&C<=e.zones[L].to&&((X=e.zones[L]).zoneIndex=L,b=e.zones[L].marker,D=e.zones[L].className);for(S=A(x),"grid"!==e.layoutAlgorithm.type||e.allowOverlap?M={x:S.x,y:S.y}:(k=this.options.marker||{},M=this.preventClusterCollisions({x:S.x,y:S.y,key:z,groupedData:t,gridSize:this.getScaledGridSize(e.layoutAlgorithm),defaultRadius:k.radius||3+(k.lineWidth||0),clusterRadius:b&&b.radius?b.radius:(e.marker||{}).radius||r.marker.radius})),L=0;L<C;L++)x[L].parentStateId=m;if(a.push({x:M.x,y:M.y,id:z,stateId:m,index:f,data:x,clusterZone:X,clusterZoneClassName:D}),i.push(M.x),s.push(M.y),n.push({options:{formatPrefix:"cluster",dataLabels:e.dataLabels,marker:c(e.marker,{states:e.states},b||{})}}),this.options.data&&this.options.data.length)for(L=0;L<C;L++)d(this.options.data[x[L].dataIndex])&&(x[L].options=this.options.data[x[L].dataIndex]);f++,b=null}else for(L=0;L<t[z].length;L++)g=t[z][L],m=Y(),I=null,y=((this.options||{}).data||[])[g.dataIndex],i.push(g.x),s.push(g.y),g.parentStateId=m,o.push({x:g.x,y:g.y,id:z,stateId:m,index:f,data:t[z]}),I=y&&"object"==typeof y&&!p(y)?c(y,{x:g.x,y:g.y}):{userOptions:y,x:g.x,y:g.y},n.push({options:I}),f++;return{clusters:a,noise:o,groupedXData:i,groupedYData:s,groupMap:n}}function V(){let t=this.chart,e=this.xAxis,i=this.yAxis,s=0;return{plotLeft:e&&this.dataMinX&&this.dataMaxX?e.reversed?e.toPixels(this.dataMaxX):e.toPixels(this.dataMinX):t.plotLeft,plotTop:i&&this.dataMinY&&this.dataMaxY?i.reversed?i.toPixels(this.dataMinY):i.toPixels(this.dataMaxY):t.plotTop}}function T(t,e,i){let s,a;let r=e?X(e,i):[],o=X(t,i),n={};k=[],t.clusters.forEach(function(t){n[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}}),t.noise.forEach(function(t){n[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}});for(let t=0;t<o.length;t++)s=o[t],a=r[t],s&&a&&s.parentStateId&&a.parentStateId&&n[s.parentStateId]&&-1===n[s.parentStateId].parentsId.indexOf(a.parentStateId)&&(n[s.parentStateId].parentsId.push(a.parentStateId),-1===k.indexOf(a.parentStateId)&&k.push(a.parentStateId));return n}function v(){let t=this.chart,e=t.mapView?0:t.plotLeft,i=t.mapView?0:t.plotTop,s=z(this,{x:e,y:i}),a=z(this,{x:e+t.plotWidth,y:e+t.plotHeight}),r=s.x,o=a.x,n=s.y,l=a.y;return{minX:Math.min(r,o),maxX:Math.max(r,o),minY:Math.min(n,l),maxY:Math.max(n,l)}}function G(t){let e=this.xAxis,i=this.chart.mapView,s=t.processedGridSize||r.layoutAlgorithm.gridSize,a=!0,o=1,n=1;this.gridValueSize||(i?this.gridValueSize=s/i.getScale():this.gridValueSize=Math.abs(e.toValue(s)-e.toValue(0)));let l=i?this.gridValueSize*i.getScale():e.toPixels(this.gridValueSize)-e.toPixels(0),p=+(s/l).toFixed(14);for(;a&&1!==p;){let t=Math.pow(2,o);p>.75&&p<1.25?a=!1:p>=1/t&&p<2*(1/t)?(a=!1,n=t):p<=t&&p>t/2&&(a=!1,n=1/t),o++}return s/n/p}function R(){let t=this.markerClusterSeriesData,e=((this.markerClusterInfo||{}).pointsState||{}).oldState||{},i=k.map(t=>(e[t].point||{}).id||"");(t||[]).forEach(function(t){t&&-1!==i.indexOf(t.id)?(t.graphic&&t.graphic.hide(),t.dataLabel&&t.dataLabel.hide()):t&&t.destroy&&t.destroy()})}function Z(t){let e=!1,i;return!!d(t)&&(f(t,function(t){if(e=!0,!p(t)||!t.length){e=!1;return}for(i=0;i<t.length;i++)if(!d(t[i])||!t[i].x||!t[i].y){e=!1;return}}),e)}function F(t){let[e,i]=t.key.split("-").map(parseFloat),s=t.gridSize,a=t.groupedData,o=t.defaultRadius,l=t.clusterRadius,p=i*s,u=e*s,d=H(this,t),h=[],c=(this.options.cluster||{}).marker,f=(this.options.cluster||{}).zones,m=this.getGridOffset(),g=d.x,x=d.y,y=0,C=0,k,M,I,S,b,X,Y,D,L,P,w,E,j;for(g-=m.plotLeft,x-=m.plotTop,Y=1;Y<5;Y++)for(D=0,I=Y%2?-1:1,S=Y<3?-1:1,b=Math.floor((g+I*l)/s),j=[(X=Math.floor((x+S*l)/s))+"-"+b,X+"-"+i,e+"-"+b];D<j.length;D++)-1===h.indexOf(j[D])&&j[D]!==t.key&&h.push(j[D]);for(let t of h)if(a[t]){a[t].posX||(w=A(a[t]),a[t].posX=w.x,a[t].posY=w.y);let d=H(this,{x:a[t].posX||0,y:a[t].posY||0});if(k=d.x-m.plotLeft,M=d.y-m.plotTop,[P,L]=t.split("-").map(parseFloat),f)for(Y=0,y=a[t].length;Y<f.length;Y++)y>=f[Y].from&&y<=f[Y].to&&(C=n((f[Y].marker||{}).radius)?f[Y].marker.radius||0:c&&c.radius?c.radius:r.marker.radius);a[t].length>1&&0===C&&c&&c.radius?C=c.radius:1===a[t].length&&(C=o),E=l+C,C=0,L!==i&&Math.abs(g-k)<E&&(g=L-i<0?p+l:p+s-l),P!==e&&Math.abs(x-M)<E&&(x=P-e<0?u+l:u+s-l)}let O=z(this,{x:g+m.plotLeft,y:x+m.plotTop});return a[t.key].posX=O.x,a[t.key].posY=O.y,O}function H(t,e){let{chart:i,xAxis:s,yAxis:a}=t;return i.mapView?i.mapView.projectedUnitsToPixels(e):{x:s?s.toPixels(e.x):0,y:a?a.toPixels(e.y):0}}return{compose:function(t,i){if(m(y,i)){let t=i.prototype;s=t.generatePoints,t.markerClusterAlgorithms=C,t.animateClusterPoint=P,t.destroyClusteredData=w,t.generatePoints=E,t.getClusterDistancesFromPoint=j,t.getClusteredData=O,t.getGridOffset=V,t.getPointsState=T,t.getRealExtremes=v,t.getScaledGridSize=G,t.hideClusteredData=R,t.isValidGroupedDataObject=Z,t.preventClusterCollisions=F,o(i,"destroy",t.destroyClusteredData)}m(y,t)&&((t.plotOptions||{}).series=c((t.plotOptions||{}).series,e))}}}),i(e,"Extensions/MarkerClusters/MarkerClusters.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Defaults.js"],e["Extensions/MarkerClusters/MarkerClusterDefaults.js"],e["Extensions/MarkerClusters/MarkerClusterScatter.js"],e["Core/Utilities.js"]],function(t,e,i,s,a){let{animObject:r}=t,{defaultOptions:o}=e,{addEvent:n,defined:l,error:p,isFunction:u,merge:d,pushUnique:h,syncTimeout:c}=a,f=[];function m(){let t=this.chart,e=0;for(let i of t.series)i.markerClusterInfo&&(e=r((i.options.cluster||{}).animation).duration||0);c(()=>{t.tooltip&&t.tooltip.destroy()},e)}function g(){for(let t of this.series||[])if(t.markerClusterInfo){let e=t.options.cluster,i=(t.markerClusterInfo||{}).pointsState,s=(i||{}).oldState;if((e||{}).animation&&t.markerClusterInfo&&0===t.chart.pointer.pinchDown.length&&"pan"!==((t.xAxis||{}).eventArgs||{}).trigger&&s&&Object.keys(s).length){for(let e of t.markerClusterInfo.clusters)t.animateClusterPoint(e);for(let e of t.markerClusterInfo.noise)t.animateClusterPoint(e)}}}function x(t){let e=t.point||t.target,i=e.series,s=i.options.cluster,a=((s||{}).events||{}).drillToCluster;u(a)&&a.call(this,t)}function y(){if(this.dataGroup)return p("Highcharts marker-clusters module: Running `Point.update` when point belongs to clustered series is not supported.",!1,this.series.chart),!1}function C(){let t=(this.options.cluster||{}).drillToCluster;if(this.markerClusterInfo&&this.markerClusterInfo.clusters)for(let e of this.markerClusterInfo.clusters)e.point&&e.point.graphic&&(e.point.graphic.addClass("highcharts-cluster-point"),t&&e.point&&(e.point.graphic.css({cursor:"pointer"}),e.point.dataLabel&&e.point.dataLabel.css({cursor:"pointer"})),l(e.clusterZone)&&e.point.graphic.addClass(e.clusterZoneClassName||"highcharts-cluster-zone-"+e.clusterZone.zoneIndex))}return(o.plotOptions||{}).series=d((o.plotOptions||{}).series,i),{compose:function(t,e,i,a){let r=a.prototype.pointClass;h(f,t)&&n(t,"setExtremes",m),h(f,e)&&n(e,"render",g),h(f,r)&&(n(r,"drillToCluster",x),n(r,"update",y)),h(f,a)&&n(a,"afterRender",C);let{scatter:o}=a.types;o&&s.compose(i,o)}}}),i(e,"Extensions/MarkerClusters/MarkerClusterSymbols.js",[e["Core/Utilities.js"]],function(t){let e;let{pushUnique:i}=t,s=[];function a(t,i,s,a){let r=s/2,o=a/2,n=e.arc(t+r,i+o,r-4,o-4,{start:.5*Math.PI,end:2.5*Math.PI,open:!1}),l=e.arc(t+r,i+o,r-3,o-3,{start:.5*Math.PI,end:2.5*Math.PI,innerR:r-2,open:!1}),p=e.arc(t+r,i+o,r-1,o-1,{start:.5*Math.PI,end:2.5*Math.PI,innerR:r,open:!1});return p.concat(l,n)}return{compose:function(t){i(s,t)&&((e=t.prototype.symbols).cluster=a)}}}),i(e,"masters/modules/marker-clusters.src.js",[e["Core/Globals.js"],e["Extensions/MarkerClusters/MarkerClusters.js"],e["Extensions/MarkerClusters/MarkerClusterSymbols.js"]],function(t,e,i){e.compose(t.Axis,t.Chart,t.defaultOptions,t.Series),i.compose(t.SVGRenderer)})});//# sourceMappingURL=marker-clusters.js.map