/**
 * Highcharts Gantt JS v11.2.0 (2023-10-30)
 *
 * Pathfinder
 *
 * (c) 2016-2021 Øystein Moseng
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/pathfinder",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function n(t,e,n,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,n),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}n(e,"Gantt/Connection.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){let{defined:n,error:i,merge:r,objectEach:o}=e,a=t.deg2rad,s=Math.max,h=Math.min;return class{constructor(t,e,n){this.chart=void 0,this.fromPoint=void 0,this.graphics=void 0,this.pathfinder=void 0,this.toPoint=void 0,this.init(t,e,n)}init(t,e,n){this.fromPoint=t,this.toPoint=e,this.options=n,this.chart=t.series.chart,this.pathfinder=this.chart.pathfinder}renderPath(t,e,n){let i=this.chart,r=i.styledMode,o=i.pathfinder,a=!i.options.chart.forExport&&!1!==n,s={},h=this.graphics&&this.graphics.path;o.group||(o.group=i.renderer.g().addClass("highcharts-pathfinder-group").attr({zIndex:-1}).add(i.seriesGroup)),o.group.translate(i.plotLeft,i.plotTop),h&&h.renderer||(h=i.renderer.path().add(o.group),r||h.attr({opacity:0})),h.attr(e),s.d=t,r||(s.opacity=1),h[a?"animate":"attr"](s,n),this.graphics=this.graphics||{},this.graphics.path=h}addMarker(t,e,n){let i,r,o,s,h,c,l,x;let M=this.fromPoint.series.chart,d=M.pathfinder,f=M.renderer,y="start"===t?this.fromPoint:this.toPoint,p=y.getPathfinderAnchorPoint(e);e.enabled&&((x="start"===t?n[1]:n[n.length-2])&&"M"===x[0]||"L"===x[0])&&(l={x:x[1],y:x[2]},r=y.getRadiansToVector(l,p),i=y.getMarkerVector(r,e.radius,p),o=-r/a,e.width&&e.height?(h=e.width,c=e.height):h=c=2*e.radius,this.graphics=this.graphics||{},s={x:i.x-h/2,y:i.y-c/2,width:h,height:c,rotation:o,rotationOriginX:i.x,rotationOriginY:i.y},this.graphics[t]?this.graphics[t].animate(s):(this.graphics[t]=f.symbol(e.symbol).addClass("highcharts-point-connecting-path-"+t+"-marker highcharts-color-"+this.fromPoint.colorIndex).attr(s).add(d.group),f.styledMode||this.graphics[t].attr({fill:e.color||this.fromPoint.color,stroke:e.lineColor,"stroke-width":e.lineWidth,opacity:0}).animate({opacity:1},y.series.options.animation)))}getPath(t){let e=this.pathfinder,n=this.chart,o=e.algorithms[t.type],a=e.chartObstacles;return"function"!=typeof o?(i('"'+t.type+'" is not a Pathfinder algorithm.'),{path:[],obstacles:[]}):(o.requiresObstacles&&!a&&(a=e.chartObstacles=e.getChartObstacles(t),n.options.connectors.algorithmMargin=t.algorithmMargin,e.chartObstacleMetrics=e.getObstacleMetrics(a)),o(this.fromPoint.getPathfinderAnchorPoint(t.startMarker),this.toPoint.getPathfinderAnchorPoint(t.endMarker),r({chartObstacles:a,lineObstacles:e.lineObstacles||[],obstacleMetrics:e.chartObstacleMetrics,hardBounds:{xMin:0,xMax:n.plotWidth,yMin:0,yMax:n.plotHeight},obstacleOptions:{margin:t.algorithmMargin},startDirectionX:e.getAlgorithmStartDirection(t.startMarker)},t)))}render(){let t=this.fromPoint,e=t.series,i=e.chart,o=i.pathfinder,a={},c=r(i.options.connectors,e.options.connectors,t.options.connectors,this.options);!i.styledMode&&(a.stroke=c.lineColor||t.color,a["stroke-width"]=c.lineWidth,c.dashStyle&&(a.dashstyle=c.dashStyle)),a.class="highcharts-point-connecting-path highcharts-color-"+t.colorIndex,n((c=r(a,c)).marker.radius)||(c.marker.radius=h(s(Math.ceil((c.algorithmMargin||8)/2)-1,1),5));let l=this.getPath(c),x=l.path;l.obstacles&&(o.lineObstacles=o.lineObstacles||[],o.lineObstacles=o.lineObstacles.concat(l.obstacles)),this.renderPath(x,a,e.options.animation),this.addMarker("start",r(c.marker,c.startMarker),x),this.addMarker("end",r(c.marker,c.endMarker),x)}destroy(){this.graphics&&(o(this.graphics,function(t){t.destroy()}),delete this.graphics)}}}),n(e,"Series/PathUtilities.js",[],function(){function t(t,e){let n=[];for(let i=0;i<t.length;i++){let r=t[i][1],o=t[i][2];if("number"==typeof r&&"number"==typeof o){if(0===i)n.push(["M",r,o]);else if(i===t.length-1)n.push(["L",r,o]);else if(e){let a=t[i-1],s=t[i+1];if(a&&s){let t=a[1],i=a[2],h=s[1],c=s[2];if("number"==typeof t&&"number"==typeof h&&"number"==typeof i&&"number"==typeof c&&t!==h&&i!==c){let a=t<h?1:-1,s=i<c?1:-1;n.push(["L",r-a*Math.min(Math.abs(r-t),e),o-s*Math.min(Math.abs(o-i),e)],["C",r,o,r,o,r+a*Math.min(Math.abs(r-h),e),o+s*Math.min(Math.abs(o-c),e)])}}}else n.push(["L",r,o])}}return n}return{applyRadius:t,getLinkPath:{default:function(e){let{x1:n,y1:i,x2:r,y2:o,width:a=0,inverted:s=!1,radius:h,parentVisible:c}=e,l=[["M",n,i],["L",n,i],["C",n,i,n,o,n,o],["L",n,o],["C",n,i,n,o,n,o],["L",n,o]];return c?t([["M",n,i],["L",n+a*(s?-.5:.5),i],["L",n+a*(s?-.5:.5),o],["L",r,o]],h):l},straight:function(t){let{x1:e,y1:n,x2:i,y2:r,width:o=0,inverted:a=!1,parentVisible:s}=t;return s?[["M",e,n],["L",e+o*(a?-1:1),r],["L",i,r]]:[["M",e,n],["L",e,r],["L",e,r]]},curved:function(t){let{x1:e,y1:n,x2:i,y2:r,offset:o=0,width:a=0,inverted:s=!1,parentVisible:h}=t;return h?[["M",e,n],["C",e+o,n,e-o+a*(s?-1:1),r,e+a*(s?-1:1),r],["L",i,r]]:[["M",e,n],["C",e,n,e,r,e,r],["L",i,r]]}}}}),n(e,"Gantt/PathfinderAlgorithms.js",[e["Series/PathUtilities.js"],e["Core/Utilities.js"]],function(t,e){let{pick:n}=e,{min:i,max:r,abs:o}=Math;function a(t,e,n){let i=e-1e-7,r=n||0,o=t.length-1,a,s;for(;r<=o;)if((s=i-t[a=o+r>>1].xMin)>0)r=a+1;else{if(!(s<0))return a;o=a-1}return r>0?r-1:0}function s(t,e){let n=a(t,e.x+1)+1;for(;n--;){var i;if(t[n].xMax>=e.x&&(i=t[n],e.x<=i.xMax&&e.x>=i.xMin&&e.y<=i.yMax&&e.y>=i.yMin))return n}return -1}function h(t){let e=[];if(t.length){e.push(["M",t[0].start.x,t[0].start.y]);for(let n=0;n<t.length;++n)e.push(["L",t[n].end.x,t[n].end.y])}return e}function c(t,e){t.yMin=r(t.yMin,e.yMin),t.yMax=i(t.yMax,e.yMax),t.xMin=r(t.xMin,e.xMin),t.xMax=i(t.xMax,e.xMax)}let l=function(e,i,r){let a=[],c=r.chartObstacles,l=s(c,e),x=s(c,i),M,d=n(r.startDirectionX,o(i.x-e.x)>o(i.y-e.y))?"x":"y",f,y,p,u;function g(t,e,n,i,r){let o={x:t.x,y:t.y};return o[e]=n[i||e]+(r||0),o}function m(t,e,n){let i=o(e[n]-t[n+"Min"])>o(e[n]-t[n+"Max"]);return g(e,n,t,n+(i?"Max":"Min"),i?1:-1)}x>-1?(M={start:y=m(c[x],i,d),end:i},u=y):u=i,l>-1&&(y=m(f=c[l],e,d),a.push({start:e,end:y}),y[d]>=e[d]==y[d]>=u[d]&&(p=e[d="y"===d?"x":"y"]<i[d],a.push({start:y,end:g(y,d,f,d+(p?"Max":"Min"),p?1:-1)}),d="y"===d?"x":"y"));let b=a.length?a[a.length-1].end:e;y=g(b,d,u),a.push({start:b,end:y}),d="y"===d?"x":"y";let P=g(y,d,u);a.push({start:y,end:P}),a.push(M);let v=t.applyRadius(h(a),r.radius);return{path:v,obstacles:a}};function x(t,e,l){let x=n(l.startDirectionX,o(e.x-t.x)>o(e.y-t.y)),M=x?"x":"y",d=[],f=l.obstacleMetrics,y=i(t.x,e.x)-f.maxWidth-10,p=r(t.x,e.x)+f.maxWidth+10,u=i(t.y,e.y)-f.maxHeight-10,g=r(t.y,e.y)+f.maxHeight+10,m,b,P,v=!1,C=l.chartObstacles,O=a(C,p),k=a(C,y);function w(t,e,n){let r,o,s,h;let c=t.x<e.x?1:-1;t.x<e.x?(r=t,o=e):(r=e,o=t),t.y<e.y?(h=t,s=e):(h=e,s=t);let l=c<0?i(a(C,o.x),C.length-1):0;for(;C[l]&&(c>0&&C[l].xMin<=o.x||c<0&&C[l].xMax>=r.x);){if(C[l].xMin<=o.x&&C[l].xMax>=r.x&&C[l].yMin<=s.y&&C[l].yMax>=h.y){if(n)return{y:t.y,x:t.x<e.x?C[l].xMin-1:C[l].xMax+1,obstacle:C[l]};return{x:t.x,y:t.y<e.y?C[l].yMin-1:C[l].yMax+1,obstacle:C[l]}}l+=c}return e}function L(t,e,n,i,r){let a=r.soft,s=r.hard,h=i?"x":"y",c={x:e.x,y:e.y},l={x:e.x,y:e.y},x=t[h+"Max"]>=a[h+"Max"],M=t[h+"Min"]<=a[h+"Min"],d=t[h+"Max"]>=s[h+"Max"],f=t[h+"Min"]<=s[h+"Min"],y=o(t[h+"Min"]-e[h]),p=o(t[h+"Max"]-e[h]),u=10>o(y-p)?e[h]<n[h]:p<y;l[h]=t[h+"Min"],c[h]=t[h+"Max"];let g=w(e,l,i)[h]!==l[h],m=w(e,c,i)[h]!==c[h];return u=g?!m||u:!m&&u,u=M?!x||u:!x&&u,u=f?!d||u:!d&&u}for((O=s(C=C.slice(k,O+1),e))>-1&&(P=function(t,e,n){let r=i(t.xMax-e.x,e.x-t.xMin)<i(t.yMax-e.y,e.y-t.yMin),o={soft:l.hardBounds,hard:l.hardBounds},a=L(t,e,n,r,o);return r?{y:e.y,x:t[a?"xMax":"xMin"]+(a?1:-1)}:{x:e.x,y:t[a?"yMax":"yMin"]+(a?1:-1)}}(C[O],e,t),d.push({end:e,start:P}),e=P);(O=s(C,e))>-1;)b=e[M]-t[M]<0,(P={x:e.x,y:e.y})[M]=C[O][b?M+"Max":M+"Min"]+(b?1:-1),d.push({end:e,start:P}),e=P;return{path:h(m=(m=function t(e,n,o){let a,h,x,M,d,f,m;if(e.x===n.x&&e.y===n.y)return[];let b=o?"x":"y",P=l.obstacleOptions.margin,O={soft:{xMin:y,xMax:p,yMin:u,yMax:g},hard:l.hardBounds};return(d=s(C,e))>-1?(M=L(d=C[d],e,n,o,O),c(d,l.hardBounds),m=o?{y:e.y,x:d[M?"xMax":"xMin"]+(M?1:-1)}:{x:e.x,y:d[M?"yMax":"yMin"]+(M?1:-1)},(f=s(C,m))>-1&&(c(f=C[f],l.hardBounds),m[b]=M?r(d[b+"Max"]-P+1,(f[b+"Min"]+d[b+"Max"])/2):i(d[b+"Min"]+P-1,(f[b+"Max"]+d[b+"Min"])/2),e.x===m.x&&e.y===m.y?(v&&(m[b]=M?r(d[b+"Max"],f[b+"Max"])+1:i(d[b+"Min"],f[b+"Min"])-1),v=!v):v=!1),h=[{start:e,end:m}]):(a=w(e,{x:o?n.x:e.x,y:o?e.y:n.y},o),h=[{start:e,end:{x:a.x,y:a.y}}],a[o?"x":"y"]!==n[o?"x":"y"]&&(M=L(a.obstacle,a,n,!o,O),c(a.obstacle,l.hardBounds),x={x:o?a.x:a.obstacle[M?"xMax":"xMin"]+(M?1:-1),y:o?a.obstacle[M?"yMax":"yMin"]+(M?1:-1):a.y},o=!o,h=h.concat(t({x:a.x,y:a.y},x,o)))),h=h.concat(t(h[h.length-1].end,n,!o))}(t,e,x)).concat(d.reverse())),obstacles:m}}return l.requiresObstacles=!0,x.requiresObstacles=!0,{fastAvoid:x,straight:function(t,e){return{path:[["M",t.x,t.y],["L",e.x,e.y]],obstacles:[{start:t,end:e}]}},simpleConnect:l}}),n(e,"Gantt/ConnectorsDefaults.js",[],function(){return{connectors:{type:"straight",radius:0,lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}}}),n(e,"Gantt/PathfinderComposition.js",[e["Gantt/ConnectorsDefaults.js"],e["Core/Defaults.js"],e["Core/Utilities.js"]],function(t,e,n){var i;let{setOptions:r}=e,{defined:o,error:a,merge:s,pushUnique:h}=n;function c(t){let e=t.shapeArgs;if(e)return{xMin:e.x||0,xMax:(e.x||0)+(e.width||0),yMin:e.y||0,yMax:(e.y||0)+(e.height||0)};let n=t.graphic&&t.graphic.getBBox();return n?{xMin:t.plotX-n.width/2,xMax:t.plotX+n.width/2,yMin:t.plotY-n.height/2,yMax:t.plotY+n.height/2}:null}return function(e){let n=[];function i(t){let e,n;let i=c(this);switch(t.align){case"right":e="xMax";break;case"left":e="xMin"}switch(t.verticalAlign){case"top":n="yMin";break;case"bottom":n="yMax"}return{x:e?i[e]:(i.xMin+i.xMax)/2,y:n?i[n]:(i.yMin+i.yMax)/2}}function l(t,e){let n;return!o(e)&&(n=c(this))&&(e={x:(n.xMin+n.xMax)/2,y:(n.yMin+n.yMax)/2}),Math.atan2(e.y-t.y,t.x-e.x)}function x(t,e,n){let i=2*Math.PI,r=c(this),o=r.xMax-r.xMin,a=r.yMax-r.yMin,s=Math.atan2(a,o),h=o/2,l=a/2,x=r.xMin+h,M=r.yMin+l,d={x:x,y:M},f=t,y=1,p=!1,u=1,g=1;for(;f<-Math.PI;)f+=i;for(;f>Math.PI;)f-=i;return y=Math.tan(f),f>-s&&f<=s?(g=-1,p=!0):f>s&&f<=Math.PI-s?g=-1:f>Math.PI-s||f<=-(Math.PI-s)?(u=-1,p=!0):u=-1,p?(d.x+=u*h,d.y+=g*h*y):(d.x+=u*(a/(2*y)),d.y+=g*l),n.x!==x&&(d.x=n.x),n.y!==M&&(d.y=n.y),{x:d.x+e*Math.cos(f),y:d.y-e*Math.sin(f)}}e.compose=function(e,o,c){if(h(n,e)&&e.prototype.callbacks.push(function(t){let e=t.options;!1!==e.connectors.enabled&&((t.options.pathfinder||t.series.reduce(function(t,e){return e.options&&s(!0,e.options.connectors=e.options.connectors||{},e.options.pathfinder),t||e.options&&e.options.pathfinder},!1))&&(s(!0,t.options.connectors=t.options.connectors||{},t.options.pathfinder),a('WARNING: Pathfinder options have been renamed. Use "chart.connectors" or "series.connectors" instead.')),this.pathfinder=new o(this),this.pathfinder.update(!0))}),h(n,c)){let t=c.prototype;t.getMarkerVector=x,t.getPathfinderAnchorPoint=i,t.getRadiansToVector=l}h(n,r)&&r(t)}}(i||(i={})),i}),n(e,"Gantt/Pathfinder.js",[e["Gantt/Connection.js"],e["Gantt/PathfinderAlgorithms.js"],e["Gantt/PathfinderComposition.js"],e["Core/Series/Point.js"],e["Core/Utilities.js"]],function(t,e,n,i,r){let{addEvent:o,defined:a,pick:s,splat:h}=r,c=Math.max,l=Math.min;class x{static compose(t,e){n.compose(t,x,e)}constructor(t){this.chart=void 0,this.chartObstacles=void 0,this.chartObstacleMetrics=void 0,this.connections=void 0,this.group=void 0,this.lineObstacles=void 0,this.init(t)}init(t){this.chart=t,this.connections=[],o(t,"redraw",function(){this.pathfinder.update()})}update(e){let n=this.chart,r=this,o=r.connections;r.connections=[],n.series.forEach(function(e){e.visible&&!e.options.isInternal&&e.points.forEach(function(e){let o;let a=e.options;a&&a.dependency&&(a.connect=a.dependency);let s=e.options?.connect&&h(e.options.connect);e.visible&&!1!==e.isInside&&s&&s.forEach(function(a){(o=n.get("string"==typeof a?a:a.to))instanceof i&&o.series.visible&&o.visible&&!1!==o.isInside&&r.connections.push(new t(e,o,"string"==typeof a?{}:a))})})});for(let t=0,e,n,i=o.length,a=r.connections.length;t<i;++t){n=!1;let i=o[t];for(e=0;e<a;++e){let t=r.connections[e];if((i.options&&i.options.type)===(t.options&&t.options.type)&&i.fromPoint===t.fromPoint&&i.toPoint===t.toPoint){t.graphics=i.graphics,n=!0;break}}n||i.destroy()}delete this.chartObstacles,delete this.lineObstacles,r.renderConnections(e)}renderConnections(t){t?this.chart.series.forEach(function(t){let e=function(){let e=t.chart.pathfinder,n=e&&e.connections||[];n.forEach(function(e){e.fromPoint&&e.fromPoint.series===t&&e.render()}),t.pathfinderRemoveRenderEvent&&(t.pathfinderRemoveRenderEvent(),delete t.pathfinderRemoveRenderEvent)};!1===t.options.animation?e():t.pathfinderRemoveRenderEvent=o(t,"afterAnimate",e)}):this.connections.forEach(function(t){t.render()})}getChartObstacles(t){let e=this.chart.series,n=s(t.algorithmMargin,0),i=[],r;for(let t=0,r=e.length;t<r;++t)if(e[t].visible&&!e[t].options.isInternal)for(let r=0,o=e[t].points.length,a,s;r<o;++r)(s=e[t].points[r]).visible&&(a=function(t){let e=t.shapeArgs;if(e)return{xMin:e.x||0,xMax:(e.x||0)+(e.width||0),yMin:e.y||0,yMax:(e.y||0)+(e.height||0)};let n=t.graphic&&t.graphic.getBBox();return n?{xMin:t.plotX-n.width/2,xMax:t.plotX+n.width/2,yMin:t.plotY-n.height/2,yMax:t.plotY+n.height/2}:null}(s))&&i.push({xMin:a.xMin-n,xMax:a.xMax+n,yMin:a.yMin-n,yMax:a.yMax+n});return i=i.sort(function(t,e){return t.xMin-e.xMin}),a(t.algorithmMargin)||(r=t.algorithmMargin=function(t){let e;let n=t.length,i=[];for(let r=0;r<n;++r)for(let o=r+1;o<n;++o)(e=function t(e,n,i){let r=s(i,10),o=e.yMax+r>n.yMin-r&&e.yMin-r<n.yMax+r,a=e.xMax+r>n.xMin-r&&e.xMin-r<n.xMax+r,h=o?e.xMin>n.xMax?e.xMin-n.xMax:n.xMin-e.xMax:1/0,c=a?e.yMin>n.yMax?e.yMin-n.yMax:n.yMin-e.yMax:1/0;return a&&o?r?t(e,n,Math.floor(r/2)):1/0:l(h,c)}(t[r],t[o]))<80&&i.push(e);return i.push(80),c(Math.floor(i.sort(function(t,e){return t-e})[Math.floor(i.length/10)]/2-1),1)}(i),i.forEach(function(t){t.xMin-=r,t.xMax+=r,t.yMin-=r,t.yMax+=r})),i}getObstacleMetrics(t){let e=0,n=0,i,r,o=t.length;for(;o--;)i=t[o].xMax-t[o].xMin,r=t[o].yMax-t[o].yMin,e<i&&(e=i),n<r&&(n=r);return{maxHeight:n,maxWidth:e}}getAlgorithmStartDirection(t){let e="left"!==t.align&&"right"!==t.align,n="top"!==t.verticalAlign&&"bottom"!==t.verticalAlign;return e?!!n&&void 0:!!n||void 0}}return x.prototype.algorithms=e,x}),n(e,"Extensions/ArrowSymbols.js",[e["Core/Utilities.js"]],function(t){let e=[];function n(t,e,n,i){return[["M",t,e+i/2],["L",t+n,e],["L",t,e+i/2],["L",t+n,e+i]]}function i(t,e,i,r){return n(t,e,i/2,r)}function r(t,e,n,i){return[["M",t+n,e],["L",t,e+i/2],["L",t+n,e+i],["Z"]]}function o(t,e,n,i){return r(t,e,n/2,i)}return{compose:function(a){if(t.pushUnique(e,a)){let t=a.prototype.symbols;t.arrow=n,t["arrow-filled"]=r,t["arrow-filled-half"]=o,t["arrow-half"]=i,t["triangle-left"]=r,t["triangle-left-half"]=o}}}}),n(e,"masters/modules/pathfinder.src.js",[e["Core/Globals.js"],e["Gantt/Pathfinder.js"],e["Extensions/ArrowSymbols.js"]],function(t,e,n){t.Pathfinder=e,n.compose(t.SVGRenderer),e.compose(t.Chart,t.Point)})});//# sourceMappingURL=pathfinder.js.map