/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Sankey diagram module
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/sankey",["highcharts"],function(o){return t(o),t.Highcharts=o,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var o=t?t._modules:{};function e(t,o,e,i){t.hasOwnProperty(o)||(t[o]=i.apply(null,e),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:o,module:t[o]}})))}e(o,"Series/NodesComposition.js",[o["Core/Series/SeriesRegistry.js"],o["Core/Utilities.js"]],function(t,o){var e;let{series:{prototype:i,prototype:{pointClass:{prototype:s}}}}=t,{defined:n,extend:r,find:l,merge:a,pick:d}=o;return function(t){let e=[];function h(){return this.data=[].concat(this.points||[],this.nodes),i.destroy.apply(this,arguments)}function p(){this.nodes&&(this.nodes.forEach(t=>{t.destroy()}),this.nodes.length=0),i.setData.apply(this,arguments)}function c(t){let o=arguments,e=this.isNode?this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];"select"!==t&&e.forEach(t=>{t&&t.series&&(s.setState.apply(t,o),!t.isNode&&(t.fromNode.graphic&&s.setState.apply(t.fromNode,o),t.toNode&&t.toNode.graphic&&s.setState.apply(t.toNode,o)))}),s.setState.apply(this,o)}function u(t,o,e,i){let n=this.series.options.nodes,r=this.series.options.data,l=r&&r.length||0,h=r&&r[this.index];if(s.update.call(this,t,!this.isNode&&o,e,i),this.isNode){let t=(n||[]).reduce((t,o,e)=>this.id===o.id?e:t,-1),i=a(n&&n[t]||{},r&&r[this.index]||{});r&&(h?r[this.index]=h:r.length=l),n?t>=0?n[t]=i:n.push(i):this.series.options.nodes=[i],d(o,!0)&&this.series.chart.redraw(e)}}t.compose=function(t,i){if(o.pushUnique(e,t)){let o=t.prototype;o.setNodeState=c,o.setState=c,o.update=u}if(o.pushUnique(e,i)){let t=i.prototype;t.destroy=h,t.setData=p}return i},t.createNode=function(t){let o=this.pointClass,e=(t,o)=>l(t,t=>t.id===o),i=e(this.nodes,t),s;if(!i){s=this.options.nodes&&e(this.options.nodes,t);let n=new o().init(this,r({className:"highcharts-node",isNode:!0,id:t,y:1},s));n.linksTo=[],n.linksFrom=[],n.getSum=function(){let t=0,o=0;return n.linksTo.forEach(o=>{t+=o.weight||0}),n.linksFrom.forEach(t=>{o+=t.weight||0}),Math.max(t,o)},n.offset=function(t,o){let e=0;for(let i=0;i<n[o].length;i++){if(n[o][i]===t)return e;e+=n[o][i].weight}},n.hasShape=function(){let t=0;return n.linksTo.forEach(o=>{o.outgoing&&t++}),!n.linksTo.length||t!==n.linksTo.length},n.index=this.nodes.push(n)-1,i=n}return i.formatPrefix="node",i.name=i.name||i.options.id||"",i.mass=d(i.options.mass,i.options.marker&&i.options.marker.radius,this.options.marker&&this.options.marker.radius,4),i},t.destroy=h,t.generatePoints=function(){let t=this.chart,o={};i.generatePoints.call(this),this.nodes||(this.nodes=[]),this.colorCounter=0,this.nodes.forEach(t=>{t.linksFrom.length=0,t.linksTo.length=0,t.level=t.options.level}),this.points.forEach(e=>{n(e.from)&&(o[e.from]||(o[e.from]=this.createNode(e.from)),o[e.from].linksFrom.push(e),e.fromNode=o[e.from],t.styledMode?e.colorIndex=d(e.options.colorIndex,o[e.from].colorIndex):e.color=e.options.color||o[e.from].color),n(e.to)&&(o[e.to]||(o[e.to]=this.createNode(e.to)),o[e.to].linksTo.push(e),e.toNode=o[e.to]),e.name=e.name||e.id},this),this.nodeLookup=o},t.setNodeState=c,t.updateNode=u}(e||(e={})),e}),e(o,"Series/Sankey/SankeyPoint.js",[o["Core/Series/Point.js"],o["Core/Series/SeriesRegistry.js"],o["Core/Utilities.js"]],function(t,o,e){let{column:i}=o.seriesTypes,{defined:s}=e;class n extends i.prototype.pointClass{constructor(){super(...arguments),this.className=void 0,this.fromNode=void 0,this.level=void 0,this.linkBase=void 0,this.linkColorMode=void 0,this.linksFrom=void 0,this.linksTo=void 0,this.mass=void 0,this.nodeX=void 0,this.nodeY=void 0,this.options=void 0,this.series=void 0,this.toNode=void 0}applyOptions(o,e){return t.prototype.applyOptions.call(this,o,e),s(this.options.level)&&(this.options.column=this.column=this.options.level),this}getClassName(){return(this.isNode?"highcharts-node ":"highcharts-link ")+t.prototype.getClassName.call(this)}getFromNode(){let t=-1,o;for(let e=0;e<this.linksTo.length;e++){let i=this.linksTo[e];i.fromNode.column>t&&i.fromNode!==this&&(t=(o=i.fromNode).column)}return{fromNode:o,fromColumn:t}}setNodeColumn(){s(this.options.column)||(0===this.linksTo.length?this.column=0:this.column=this.getFromNode().fromColumn+1)}isValid(){return this.isNode||"number"==typeof this.weight}}return n}),e(o,"Series/Sankey/SankeySeriesDefaults.js",[],function(){return{borderWidth:0,colorByPoint:!0,curveFactor:.33,dataLabels:{enabled:!0,backgroundColor:"none",crop:!1,nodeFormat:void 0,nodeFormatter:function(){return this.point.name},format:void 0,formatter:function(){},inside:!0},inactiveOtherPoints:!0,linkColorMode:"from",linkOpacity:.5,opacity:1,minLinkWidth:0,nodeAlignment:"center",nodeWidth:20,nodePadding:10,showInLegend:!1,states:{hover:{linkOpacity:1,opacity:1},inactive:{linkOpacity:.1,opacity:.1,animation:{duration:50}}},tooltip:{followPointer:!0,headerFormat:'<span style="font-size: 0.8em">{series.name}</span><br/>',pointFormat:"{point.fromNode.name} → {point.toNode.name}: <b>{point.weight}</b><br/>",nodeFormat:"{point.name}: <b>{point.sum}</b><br/>"}}}),e(o,"Series/Sankey/SankeyColumnComposition.js",[o["Core/Utilities.js"]],function(t){var o;let{defined:e,pushUnique:i,relativeLength:s}=t;return function(t){t.compose=function(t,e){return t.sankeyColumn=new o(t,e),t};class o{constructor(t,o){this.points=t,this.series=o}getTranslationFactor(t){let o=this.points,e=o.slice(),i=t.chart,s=t.options.minLinkWidth||0,n,r=0,l,a=(i.plotSizeY||0)-(t.options.borderWidth||0)-(o.length-1)*t.nodePadding;for(;o.length;){for(r=a/o.sankeyColumn.sum(),n=!1,l=o.length;l--;)o[l].getSum()*r<s&&(o.splice(l,1),a=Math.max(0,a-s),n=!0);if(!n)break}for(let t of(o.length=0,e))o.push(t);return r}top(t){let o=this.series,e=o.nodePadding,i=this.points.reduce((i,s)=>{i>0&&(i+=e);let n=Math.max(s.getSum()*t,o.options.minLinkWidth||0);return i+n},0);return({top:0,center:.5,bottom:1})[o.options.nodeAlignment||"center"]*((o.chart.plotSizeY||0)-i)}left(t){let o=this.series,e=o.chart,i=o.options.equalNodes,s=e.inverted?e.plotHeight:e.plotWidth,n=o.nodePadding,r=this.points.reduce((e,r)=>{e>0&&(e+=n);let l=i?s/r.series.nodes.length-n:Math.max(r.getSum()*t,o.options.minLinkWidth||0);return e+l},0);return((e.plotSizeX||0)-Math.round(r))/2}sum(){return this.points.reduce((t,o)=>t+o.getSum(),0)}offset(t,o){let i=this.points,n=this.series,r=n.nodePadding,l=0,a;if(n.is("organization")&&t.hangsFrom)return{absoluteTop:t.hangsFrom.nodeY};for(let d=0;d<i.length;d++){let h=i[d].getSum(),p=Math.max(h*o,n.options.minLinkWidth||0),c=t.options[n.chart.inverted?"offsetHorizontal":"offsetVertical"],u=t.options.offset||0;if(a=h?p+r:0,i[d]===t)return{relativeTop:l+(e(c)?s(c,p):s(u,a))};l+=a}}}t.SankeyColumnAdditions=o}(o||(o={})),o}),e(o,"Series/TreeUtilities.js",[o["Core/Color/Color.js"],o["Core/Utilities.js"]],function(t,o){let{extend:e,isArray:i,isNumber:s,isObject:n,merge:r,pick:l}=o;return{getColor:function(o,e){let i,s,n,r,a,d;let h=e.index,p=e.mapOptionsToLevel,c=e.parentColor,u=e.parentColorIndex,m=e.series,f=e.colors,g=e.siblings,y=m.points,v=m.chart.options.chart;return o&&(i=y[o.i],s=p[o.level]||{},i&&s.colorByPoint&&(r=i.index%(f?f.length:v.colorCount),n=f&&f[r]),m.chart.styledMode||(a=l(i&&i.options.color,s&&s.color,n,c&&(o=>{let e=s&&s.colorVariation;return e&&"brightness"===e.key&&h&&g?t.parse(o).brighten(e.to*(h/g)).get():o})(c),m.color)),d=l(i&&i.options.colorIndex,s&&s.colorIndex,r,u,e.colorIndex)),{color:a,colorIndex:d}},getLevelOptions:function(t){let o={},e,a,d,h,p,c;if(n(t))for(h=s(t.from)?t.from:1,c=t.levels,a={},e=n(t.defaults)?t.defaults:{},i(c)&&(a=c.reduce((t,o)=>{let i,a,d;return n(o)&&s(o.level)&&(a=l((d=r({},o)).levelIsConstant,e.levelIsConstant),delete d.levelIsConstant,delete d.level,n(t[i=o.level+(a?0:h-1)])?r(!0,t[i],d):t[i]=d),t},{})),p=s(t.to)?t.to:1,d=0;d<=p;d++)o[d]=r({},e,n(a[d])?a[d]:{});return o},setTreeValues:function t(o,i){let s=i.before,n=i.idRoot,r=i.mapIdToNode,a=r[n],d=!1!==i.levelIsConstant,h=i.points,p=h[o.i],c=p&&p.options||{},u=[],m=0;o.levelDynamic=o.level-(d?0:a.level),o.name=l(p&&p.name,""),o.visible=n===o.id||!0===i.visible,"function"==typeof s&&(o=s(o,i)),o.children.forEach((s,n)=>{let r=e({},i);e(r,{index:n,siblings:o.children.length,visible:o.visible}),s=t(s,r),u.push(s),s.visible&&(m+=s.val)});let f=l(c.value,m);return o.visible=f>=0&&(m>0||o.visible),o.children=u,o.childrenTotal=m,o.isLeaf=o.visible&&!m,o.val=f,o},updateRootId:function(t){let o,e;return n(t)&&(e=n(t.options)?t.options:{},o=l(t.rootNode,e.rootId,""),n(t.userOptions)&&(t.userOptions.rootId=o),t.rootNode=o),o}}}),e(o,"Series/Sankey/SankeySeries.js",[o["Core/Globals.js"],o["Series/NodesComposition.js"],o["Series/Sankey/SankeyPoint.js"],o["Series/Sankey/SankeySeriesDefaults.js"],o["Core/Series/SeriesRegistry.js"],o["Series/Sankey/SankeyColumnComposition.js"],o["Core/Color/Color.js"],o["Series/TreeUtilities.js"],o["Core/Utilities.js"]],function(t,o,e,i,s,n,r,l,a){let{column:d,line:h}=s.seriesTypes,{parse:p}=r,{getLevelOptions:c}=l,{clamp:u,extend:m,isObject:f,merge:g,pick:y,relativeLength:v,stableSort:k}=a;class C extends d{constructor(){super(...arguments),this.colDistance=void 0,this.data=void 0,this.group=void 0,this.nodeLookup=void 0,this.nodePadding=void 0,this.nodes=void 0,this.nodeWidth=void 0,this.options=void 0,this.points=void 0,this.translationFactor=void 0}static getDLOptions(t){let o=f(t.optionsPoint)?t.optionsPoint.dataLabels:{},e=f(t.level)?t.level.dataLabels:{},i=g({style:{}},e,o);return i}createNodeColumns(){let t=[];for(let o of this.nodes)o.setNodeColumn(),t[o.column]||(t[o.column]=n.compose([],this)),t[o.column].push(o);for(let o=0;o<t.length;o++)void 0===t[o]&&(t[o]=n.compose([],this));return t}order(t,o){if(void 0===t.level)for(let e of(t.level=o,t.linksFrom))e.toNode&&this.order(e.toNode,o+1)}generatePoints(){if(o.generatePoints.apply(this,arguments),this.orderNodes){for(let t of this.nodes)0===t.linksTo.length&&this.order(t,0);k(this.nodes,(t,o)=>t.level-o.level)}}getNodePadding(){let t=this.options.nodePadding||0;if(this.nodeColumns){let o=this.nodeColumns.reduce((t,o)=>Math.max(t,o.length),0);o*t>this.chart.plotSizeY&&(t=this.chart.plotSizeY/o)}return t}hasData(){return!!this.processedXData.length}pointAttribs(t,o){if(!t)return{};let e=this,i=t.isNode?t.level:t.fromNode.level,s=e.mapOptionsToLevel[i||0]||{},n=t.options,l=s.states&&s.states[o||""]||{},a=["colorByPoint","borderColor","borderWidth","linkOpacity","opacity"].reduce((t,o)=>(t[o]=y(l[o],n[o],s[o],e.options[o]),t),{}),d=y(l.color,n.color,a.colorByPoint?t.color:s.color);return t.isNode?{fill:d,stroke:a.borderColor,"stroke-width":a.borderWidth,opacity:a.opacity}:{fill:r.parse(d).setOpacity(a.linkOpacity).get()}}drawTracker(){d.prototype.drawTracker.call(this,this.points),d.prototype.drawTracker.call(this,this.nodes)}drawPoints(){d.prototype.drawPoints.call(this,this.points),d.prototype.drawPoints.call(this,this.nodes)}drawDataLabels(){d.prototype.drawDataLabels.call(this,this.points),d.prototype.drawDataLabels.call(this,this.nodes)}translate(){this.processedXData||this.processData(),this.generatePoints(),this.nodeColumns=this.createNodeColumns(),this.nodeWidth=v(this.options.nodeWidth,this.chart.plotSizeX);let t=this,o=this.chart,e=this.options,i=this.nodeWidth,s=this.nodeColumns;for(let n of(this.nodePadding=this.getNodePadding(),this.translationFactor=s.reduce((o,e)=>Math.min(o,e.sankeyColumn.getTranslationFactor(t)),1/0),this.colDistance=(o.plotSizeX-i-e.borderWidth)/Math.max(1,s.length-1),t.mapOptionsToLevel=c({from:1,levels:e.levels,to:s.length-1,defaults:{borderColor:e.borderColor,borderRadius:e.borderRadius,borderWidth:e.borderWidth,color:t.color,colorByPoint:e.colorByPoint,levelIsConstant:!0,linkColor:e.linkColor,linkLineWidth:e.linkLineWidth,linkOpacity:e.linkOpacity,states:e.states}}),s))for(let o of n)t.translateNode(o,n);for(let o of this.nodes)for(let e of o.linksFrom)(e.weight||e.isNull)&&e.to&&(t.translateLink(e),e.allowShadow=!1)}translateLink(t){let o=(o,e)=>{let i=o.offset(t,e)*r,s=Math.min(o.nodeY+i,o.nodeY+(o.shapeArgs&&o.shapeArgs.height||0)-m);return s},e=t.fromNode,i=t.toNode,s=this.chart,{inverted:n}=s,r=this.translationFactor,l=this.options,a=y(t.linkColorMode,l.linkColorMode),d=(s.inverted?-this.colDistance:this.colDistance)*l.curveFactor,h=e.nodeX,c=i.nodeX,u=t.outgoing,m=Math.max(t.weight*r,this.options.minLinkWidth),f=o(e,"linksFrom"),g=o(i,"linksTo"),v=this.nodeWidth,k=c>h+v;if(s.inverted&&(f=s.plotSizeY-f,g=(s.plotSizeY||0)-g,v=-v,m=-m,k=h>c),t.shapeType="path",t.linkBase=[f,f+m,g,g+m],k&&"number"==typeof g)t.shapeArgs={d:[["M",h+v,f],["C",h+v+d,f,c-d,g,c,g],["L",c+(u?v:0),g+m/2],["L",c,g+m],["C",c-d,g+m,h+v+d,f+m,h+v,f+m],["Z"]]};else if("number"==typeof g){let o=s.plotHeight-f-m,e=c-20-m,i=c-20,n=h+v,r=n+20,l=r+m,a=f,d=f+m,p=d+20,u=p+o,y=u+20,k=y+m,C=g,S=C+m,N=S+20,b=d-.7*m,x=y+.7*m,L=S-.7*m,T=c-.7*m,P=n+.7*m;t.shapeArgs={d:[["M",n,a],["C",P,a,l,b,l,p],["L",l,u],["C",l,x,P,k,n,k],["L",c,k],["C",T,k,e,x,e,u],["L",e,N],["C",e,L,T,C,c,C],["L",c,S],["C",i,S,i,S,i,N],["L",i,u],["C",i,y,i,y,c,y],["L",n,y],["C",r,y,r,y,r,u],["L",r,p],["C",r,d,r,d,n,d],["Z"]]}}if(t.dlBox={x:h+(c-h+v)/2,y:f+(g-f)/2,height:m,width:0},t.tooltipPos=s.inverted?[s.plotSizeY-t.dlBox.y-m/2,s.plotSizeX-t.dlBox.x]:[t.dlBox.x,t.dlBox.y+m/2],t.y=t.plotY=1,t.x=t.plotX=1,!t.options.color){if("from"===a)t.color=e.color;else if("to"===a)t.color=i.color;else if("gradient"===a){let o=p(e.color).get(),s=p(i.color).get();t.color={linearGradient:{x1:1,x2:0,y1:0,y2:0},stops:[[0,n?o:s],[1,n?s:o]]}}}}translateNode(t,o){let e=this.translationFactor,i=this.chart,s=this.options,{borderRadius:n,borderWidth:r=0}=s,l=t.getSum(),a=Math.max(Math.round(l*e),this.options.minLinkWidth),d=Math.round(this.nodeWidth),h=Math.round(r)%2/2,p=o.sankeyColumn.offset(t,e),c=Math.floor(y(p.absoluteTop,o.sankeyColumn.top(e)+p.relativeTop))+h,m=Math.floor(this.colDistance*t.column+r/2)+v(t.options[i.inverted?"offsetVertical":"offsetHorizontal"]||0,d)+h,f=i.inverted?i.plotSizeX-m:m;if(t.sum=l,l){t.shapeType="roundedRect",t.nodeX=f,t.nodeY=c;let o=f,e=c,r=t.options.width||s.width||d,l=t.options.height||s.height||a,h=u(v("object"==typeof n?n.radius:n||0,r),0,a/2);i.inverted&&(o=f-d,e=i.plotSizeY-c-a,r=t.options.height||s.height||d,l=t.options.width||s.width||a),t.dlOptions=C.getDLOptions({level:this.mapOptionsToLevel[t.level],optionsPoint:t.options}),t.plotX=1,t.plotY=1,t.tooltipPos=i.inverted?[i.plotSizeY-e-l/2,i.plotSizeX-o-r/2]:[o+r/2,e+l/2],t.shapeArgs={x:o,y:e,width:r,height:l,r:h,display:t.hasShape()?"":"none"}}else t.dlOptions={enabled:!1}}}return C.defaultOptions=g(d.defaultOptions,i),o.compose(e,C),m(C.prototype,{animate:h.prototype.animate,createNode:o.createNode,forceDL:!0,invertible:!0,isCartesian:!1,orderNodes:!0,noSharedTooltip:!0,pointArrayMap:["from","to","weight"],pointClass:e,searchPoint:t.noop}),s.registerSeriesType("sankey",C),C}),e(o,"masters/modules/sankey.src.js",[],function(){})});//# sourceMappingURL=sankey.js.map