/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Sonification module
 *
 * (c) 2010-2022 Highsoft AS
 * Author: Øystein Moseng
 *
 * License: www.highcharts.com/license
 */!function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/modules/sonification",["highcharts"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function i(e,t,i,n){e.hasOwnProperty(t)||(e[t]=n.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:e[t]}})))}i(t,"Extensions/Sonification/Options.js",[],function(){return{sonification:{enabled:!0,duration:6e3,afterSeriesWait:700,updateInterval:200,masterVolume:.7,order:"sequential",showTooltip:!0,showCrosshair:!0,pointGrouping:{enabled:!0,groupTimespan:15,algorithm:"minmax",prop:"y"},defaultInstrumentOptions:{roundToMusicalNotes:!0,instrument:"piano",mapping:{time:"x",pan:"x",noteDuration:200,pitch:{mapTo:"y",min:"c2",max:"c6",within:"yAxis"},gapBetweenNotes:100}},defaultSpeechOptions:{language:"en-US",mapping:{time:"x",rate:1.3,volume:.4},pointGrouping:{algorithm:"last"}}},exporting:{menuItemDefinitions:{downloadMIDI:{textKey:"downloadMIDI",onclick:function(){this.sonification&&this.sonification.downloadMIDI()}},playAsSound:{textKey:"playAsSound",onclick:function(){let e=this.sonification;e&&e.isPlaying()?e.cancel():this.sonify()}}}},lang:{downloadMIDI:"Download MIDI",playAsSound:"Play as sound"}}}),i(t,"Extensions/Sonification/SynthPatch.js",[t["Core/Utilities.js"]],function(e){let{clamp:t,defined:i,pick:n}=e;function s(e,t){return(.2414*e-.2414)*Math.log(t)+(3.5-1.7*e)/1.8}function o(e,t,i){e.gain.cancelScheduledValues(t),e.gain.setTargetAtTime(i,t,h.stopRampTime/4),e.gain.setValueAtTime(i,t+h.stopRampTime)}function a(e,t,i,n,s=1){let a="attack"===t,l=n.gain;if(l.cancelScheduledValues(i),!e.length){o(n,i,a?s:0);return}e[0].t>1&&e.unshift({t:0,vol:a?0:1}),e.forEach((t,n)=>{let o=e[n-1],a=o?(t.t-o.t)/1e3:0,r=i+(o?o.t/1e3+h.stopRampTime:0);l.setTargetAtTime(t.vol*s,r,Math.max(a,h.stopRampTime)/2)})}class l{constructor(e,t){this.pulseWidth=Math.min(Math.max(0,t.pulseWidth||.5));let i=()=>new OscillatorNode(e,{type:"sawtooth",detune:t.detune,frequency:Math.max(1,t.frequency||350)});this.sawOscA=i(),this.sawOscB=i(),this.phaseInverter=new GainNode(e,{gain:-1}),this.masterGain=new GainNode(e),this.delayNode=new DelayNode(e,{delayTime:this.pulseWidth/this.sawOscA.frequency.value}),this.sawOscA.connect(this.masterGain),this.sawOscB.connect(this.phaseInverter),this.phaseInverter.connect(this.delayNode),this.delayNode.connect(this.masterGain)}connect(e){this.masterGain.connect(e)}getFrequencyFacade(){let e=this;return{cancelScheduledValues:t=>(e.sawOscA.frequency.cancelScheduledValues(t),e.sawOscB.frequency.cancelScheduledValues(t),e.delayNode.delayTime.cancelScheduledValues(t),e.sawOscA.frequency),setValueAtTime(t,i){return this.cancelScheduledValues(i),e.sawOscA.frequency.setValueAtTime(t,i),e.sawOscB.frequency.setValueAtTime(t,i),e.delayNode.delayTime.setValueAtTime(Math.round(1e4*e.pulseWidth/t)/1e4,i),e.sawOscA.frequency},setTargetAtTime(t,i,n){return this.cancelScheduledValues(i),e.sawOscA.frequency.setTargetAtTime(t,i,n),e.sawOscB.frequency.setTargetAtTime(t,i,n),e.delayNode.delayTime.setTargetAtTime(Math.round(1e4*e.pulseWidth/t)/1e4,i,n),e.sawOscA.frequency}}}getPWMTarget(){return this.delayNode.delayTime}start(){this.sawOscA.start(),this.sawOscB.start()}stop(e){this.sawOscA.stop(e),this.sawOscB.stop(e)}}class r{constructor(e,t,i){this.audioContext=e,this.options=t,this.fmOscillatorIx=t.fmOscillator,this.vmOscillatorIx=t.vmOscillator,this.createSoundSource(),this.createGain(),this.createFilters(),this.createVolTracking(),i&&this.connect(i)}connect(e){[this.lowpassNode,this.highpassNode,this.volTrackingNode,this.vmNode,this.gainNode,this.whiteNoise,this.pulseNode,this.oscNode].reduce((e,t)=>t?(t.connect(e),t):e,e)}start(){this.oscNode&&this.oscNode.start(),this.whiteNoise&&this.whiteNoise.start(),this.pulseNode&&this.pulseNode.start()}stopAtTime(e){this.oscNode&&this.oscNode.stop(e),this.whiteNoise&&this.whiteNoise.stop(e),this.pulseNode&&this.pulseNode.stop(e)}setFreqAtTime(e,i,s=0){let o=this.options,a=t(n(o.fixedFrequency,i)*(o.freqMultiplier||1),0,21e3),l=this.getOscTarget(),r=s/5e3;l&&(l.cancelScheduledValues(e),s&&e-(this.lastUpdateTime||-1)>.01?(l.setTargetAtTime(a,e,r),l.setValueAtTime(a,e+r)):l.setValueAtTime(a,e)),this.scheduleVolTrackingChange(a,e,s),this.scheduleFilterTrackingChange(a,e,s),this.lastUpdateTime=e}getFMTarget(){return this.oscNode&&this.oscNode.detune||this.whiteNoise&&this.whiteNoise.detune||this.pulseNode&&this.pulseNode.getPWMTarget()}getVMTarget(){return this.vmNode&&this.vmNode.gain}runEnvelopeAtTime(e,t){if(!this.gainNode)return;let i=("attack"===e?this.options.attackEnvelope:this.options.releaseEnvelope)||[];a(i,e,t,this.gainNode,this.options.volume)}cancelScheduled(){this.gainNode&&this.gainNode.gain.cancelScheduledValues(this.audioContext.currentTime);let e=this.getOscTarget();e&&e.cancelScheduledValues(0),this.lowpassNode&&this.lowpassNode.frequency.cancelScheduledValues(0),this.highpassNode&&this.highpassNode.frequency.cancelScheduledValues(0),this.volTrackingNode&&this.volTrackingNode.gain.cancelScheduledValues(0)}scheduleVolTrackingChange(e,t,i){if(this.volTrackingNode){let n=s(this.options.volumePitchTrackingMultiplier||1,e),o=i?i/1e3:h.stopRampTime;this.volTrackingNode.gain.cancelScheduledValues(t),this.volTrackingNode.gain.setTargetAtTime(n,t,o/5),this.volTrackingNode.gain.setValueAtTime(n,t+o)}}scheduleFilterTrackingChange(e,i,n){let o=this.options,a=n?n/1e3:h.stopRampTime,l=(n,o)=>{let l=s(o.frequencyPitchTrackingMultiplier||1,e),r=t((o.frequency||1e3)*l,0,21e3);n.frequency.cancelScheduledValues(i),n.frequency.setTargetAtTime(r,i,a/5),n.frequency.setValueAtTime(r,i+a)};this.lowpassNode&&o.lowpass&&l(this.lowpassNode,o.lowpass),this.highpassNode&&o.highpass&&l(this.highpassNode,o.highpass)}createGain(){let e=this.options,t=i(e.volume)||e.attackEnvelope&&e.attackEnvelope.length||e.releaseEnvelope&&e.releaseEnvelope.length;t&&(this.gainNode=new GainNode(this.audioContext,{gain:n(e.volume,1)})),this.vmNode=new GainNode(this.audioContext)}createSoundSource(){let e=this.options,t=this.audioContext,i=(e.fixedFrequency||0)*(e.freqMultiplier||1);if("whitenoise"===e.type){let e=2*t.sampleRate,i=t.createBuffer(1,e,t.sampleRate),n=i.getChannelData(0);for(let t=0;t<e;++t)n[t]=1.2*Math.random()-.6;let s=this.whiteNoise=t.createBufferSource();s.buffer=i,s.loop=!0}else"pulse"===e.type?this.pulseNode=new l(t,{detune:e.detune,pulseWidth:e.pulseWidth,frequency:i}):this.oscNode=new OscillatorNode(t,{type:e.type||"sine",detune:e.detune,frequency:i})}createFilters(){let e=this.options;e.lowpass&&e.lowpass.frequency&&(this.lowpassNode=new BiquadFilterNode(this.audioContext,{type:"lowpass",Q:e.lowpass.Q||1,frequency:e.lowpass.frequency})),e.highpass&&e.highpass.frequency&&(this.highpassNode=new BiquadFilterNode(this.audioContext,{type:"highpass",Q:e.highpass.Q||1,frequency:e.highpass.frequency}))}createVolTracking(){let e=this.options;e.volumePitchTrackingMultiplier&&1!==e.volumePitchTrackingMultiplier&&(this.volTrackingNode=new GainNode(this.audioContext,{gain:1}))}getOscTarget(){return this.oscNode?this.oscNode.frequency:this.pulseNode&&this.pulseNode.getFrequencyFacade()}}class h{constructor(e,t){this.audioContext=e,this.options=t,this.eqNodes=[],this.midiInstrument=t.midiInstrument||1,this.outputNode=new GainNode(e,{gain:0}),this.createEqChain(this.outputNode);let n=this.eqNodes.length?this.eqNodes[0]:this.outputNode;this.oscillators=(this.options.oscillators||[]).map(t=>new r(e,t,i(t.fmOscillator)||i(t.vmOscillator)?void 0:n)),this.oscillators.forEach(e=>{let t=(t,i)=>{if(i){let n=i[t]();n&&e.connect(n)}};i(e.fmOscillatorIx)&&t("getFMTarget",this.oscillators[e.fmOscillatorIx]),i(e.vmOscillatorIx)&&t("getVMTarget",this.oscillators[e.vmOscillatorIx])})}startSilently(){this.outputNode.gain.value=0,this.oscillators.forEach(e=>e.start())}stop(){let e=this.audioContext.currentTime,t=e+h.stopRampTime;o(this.outputNode,e,0),this.oscillators.forEach(e=>e.stopAtTime(t)),this.outputNode.disconnect()}silenceAtTime(e){if(!e&&this.outputNode.gain.value<.01){this.outputNode.gain.value=0;return}this.releaseAtTime((e||0)+this.audioContext.currentTime)}mute(){this.cancelScheduled(),o(this.outputNode,this.audioContext.currentTime,0)}playFreqAtTime(e,t,i){let n=(e||0)+this.audioContext.currentTime,s=this.options;this.oscillators.forEach(e=>{e.setFreqAtTime(n,t,s.noteGlideDuration),e.runEnvelopeAtTime("attack",n)}),a(s.masterAttackEnvelope||[],"attack",n,this.outputNode,s.masterVolume),i&&this.releaseAtTime(n+i/1e3)}cancelScheduled(){this.outputNode.gain.cancelScheduledValues(this.audioContext.currentTime),this.oscillators.forEach(e=>e.cancelScheduled())}connect(e){return this.outputNode.connect(e)}createEqChain(e){this.eqNodes=(this.options.eq||[]).map(e=>new BiquadFilterNode(this.audioContext,{type:"peaking",...e})),this.eqNodes.reduceRight((e,t)=>(t.connect(e),t),e)}releaseAtTime(e){let t=0;this.oscillators.forEach(i=>{let n=i.options.releaseEnvelope;n&&n.length&&(t=Math.max(t,n[n.length-1].t),i.runEnvelopeAtTime("release",e))});let i=this.options.masterReleaseEnvelope||[];i.length&&(a(i,"release",e,this.outputNode,this.options.masterVolume),t=Math.max(t,i[i.length-1].t)),o(this.outputNode,e+t/1e3,0)}}return h.stopRampTime=.012,h}),i(t,"Extensions/Sonification/InstrumentPresets.js",[],function(){return{piano:{masterVolume:.45,masterAttackEnvelope:[{t:1,vol:.71},{t:40,vol:.79},{t:82,vol:.64},{t:147,vol:.29},{t:260,vol:.15},{t:417,vol:.05},{t:589,vol:0}],eq:[{frequency:200,Q:.7,gain:6},{frequency:450,gain:6},{frequency:1300,gain:2},{frequency:2600,Q:.8,gain:8},{frequency:3500,Q:.8,gain:6},{frequency:6200,Q:.8,gain:10},{frequency:8e3,gain:-23},{frequency:1e4,Q:.4,gain:-12}],oscillators:[{type:"pulse",volume:.5,pulseWidth:.55,volumePitchTrackingMultiplier:.1,lowpass:{frequency:4.5,frequencyPitchTrackingMultiplier:900,Q:-2},highpass:{frequency:270},attackEnvelope:[{t:1,vol:1}],releaseEnvelope:[{t:1,vol:1},{t:282,vol:.64},{t:597,vol:0}]},{type:"whitenoise",volume:.8,lowpass:{frequency:400},highpass:{frequency:300},attackEnvelope:[{t:1,vol:1},{t:19,vol:0}]}]},plucked:{masterVolume:.5,midiInstrument:25,masterAttackEnvelope:[{t:1,vol:.71},{t:4,vol:.71},{t:31,vol:.4},{t:109,vol:.12},{t:234,vol:.04},{t:442,vol:0}],eq:[{frequency:800,gain:-8},{frequency:1400,Q:4,gain:4},{frequency:1600,gain:-14},{frequency:2200,gain:-8},{frequency:3600,gain:-2},{frequency:6400,Q:2,gain:-6}],oscillators:[{type:"sawtooth",volume:.9,volumePitchTrackingMultiplier:.6,highpass:{frequency:100},lowpass:{frequency:8e3},releaseEnvelope:[{t:1,vol:1},{t:315,vol:.56},{t:550,vol:0}]}]},flute:{masterVolume:1.1,midiInstrument:74,noteGlideDuration:30,masterAttackEnvelope:[{t:0,vol:0},{t:29,vol:1},{t:76,vol:.48},{t:600,vol:.36}],masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,Q:.6,gain:-10},{frequency:500,gain:4},{frequency:1100,gain:-4},{frequency:2200,gain:-14},{frequency:5e3,gain:8},{frequency:6400,gain:10},{frequency:8e3,gain:12},{frequency:10800,gain:8}],oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.4,lowpass:{frequency:12,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"sine",fixedFrequency:5,volume:.2,vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:48,vol:0},{t:225,vol:.05},{t:600,vol:.77}]},{type:"whitenoise",volume:.13,lowpass:{frequency:9e3,Q:3},highpass:{frequency:6e3,Q:3},vmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:93,vol:.8}]}]},lead:{masterVolume:1,midiInstrument:20,masterAttackEnvelope:[{t:1,vol:.81},{t:98,vol:.5},{t:201,vol:.18},{t:377,vol:.04},{t:586,vol:0},{t:586,vol:0}],eq:[{frequency:200,gain:-6},{frequency:400,gain:-8},{frequency:800,Q:.5,gain:-10},{frequency:1200,gain:4},{frequency:3600,gain:-4},{frequency:4200,gain:-12},{frequency:7400,gain:-14},{frequency:1e4,gain:2}],oscillators:[{type:"triangle",volume:1.1,volumePitchTrackingMultiplier:.6,lowpass:{frequency:5e3},highpass:{frequency:100}},{type:"sawtooth",volume:.4,lowpass:{frequency:7e3},highpass:{frequency:800,Q:6},releaseEnvelope:[{t:0,vol:.99},{t:200,vol:.83},{t:495,vol:0}]}]},vibraphone:{masterVolume:1,midiInstrument:12,masterAttackEnvelope:[{t:1,vol:0},{t:10,vol:.63},{t:82,vol:.64},{t:149,vol:.26},{t:600,vol:0}],eq:[{frequency:200,Q:.8,gain:-12},{frequency:400,gain:-4},{frequency:1600,Q:.5,gain:6},{frequency:2200,Q:.5,gain:6},{frequency:6400,gain:4},{frequency:12800,gain:4}],oscillators:[{type:"sine",volume:1.5,volumePitchTrackingMultiplier:1e-7,attackEnvelope:[{t:1,vol:1}],releaseEnvelope:[{t:1,vol:1},{t:146,vol:.39},{t:597,vol:0}]},{type:"whitenoise",volume:.03,volumePitchTrackingMultiplier:1e-4,lowpass:{frequency:900},highpass:{frequency:800},attackEnvelope:[{t:1,vol:1},{t:9,vol:0}]},{type:"sine",freqMultiplier:4,volume:.15,volumePitchTrackingMultiplier:1e-4},{type:"sine",fixedFrequency:3,volume:6,fmOscillator:0,releaseEnvelope:[{t:1,vol:1},{t:190,vol:.41},{t:600,vol:0}]},{type:"sine",fixedFrequency:6,volume:3,fmOscillator:2},{type:"sine",freqMultiplier:9,volume:5e-4,volumePitchTrackingMultiplier:1e-4,releaseEnvelope:[{t:1,vol:.97},{t:530,vol:0}]}]},saxophone:{masterVolume:1,midiInstrument:67,noteGlideDuration:10,masterAttackEnvelope:[{t:1,vol:.57},{t:35,vol:1},{t:87,vol:.84},{t:111,vol:.6},{t:296,vol:.49},{t:600,vol:.58}],masterReleaseEnvelope:[{t:1,vol:.58},{t:47,vol:.16},{t:119,vol:0}],eq:[{frequency:200,gain:-2},{frequency:600,gain:2},{frequency:800,gain:-10},{frequency:1100,gain:-2},{frequency:2200,gain:-2},{frequency:3500,gain:10},{frequency:12800,gain:4}],oscillators:[{type:"sawtooth",volume:.45,volumePitchTrackingMultiplier:.06,lowpass:{frequency:18,frequencyPitchTrackingMultiplier:200},highpass:{frequency:300}},{type:"whitenoise",fixedFrequency:1,volume:.4,highpass:{frequency:7e3},vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:51,vol:1},{t:86,vol:.84},{t:500,vol:.78}]},{type:"sine",fixedFrequency:4,volume:2,fmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:15,vol:.94},{t:79,vol:1},{t:172,vol:.47},{t:500,vol:.26}]},{type:"sine",fixedFrequency:7,volume:6,fmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:25,vol:.99},{t:85,vol:0},{t:85,vol:0},{t:387,vol:.02},{t:511,vol:.43},{t:600,vol:0}]}]},trumpet:{masterVolume:.3,midiInstrument:57,noteGlideDuration:40,masterAttackEnvelope:[{t:1,vol:0},{t:17,vol:1},{t:42,vol:.85},{t:76,vol:1},{t:202,vol:.65},{t:226,vol:.86},{t:282,vol:.63}],masterReleaseEnvelope:[{t:1,vol:.62},{t:34,vol:.14},{t:63,vol:.21},{t:96,vol:0}],eq:[{frequency:200,Q:.6,gain:10},{frequency:600,Q:.5,gain:6},{frequency:1500,Q:.7,gain:14},{frequency:3200,Q:2,gain:8},{frequency:3800,Q:.8,gain:10},{frequency:6200,gain:12},{frequency:8400,gain:-20},{frequency:12800,Q:.5,gain:-18}],oscillators:[{type:"sawtooth",volume:.15,pulseWidth:.5,volumePitchTrackingMultiplier:.5,lowpass:{frequency:1900,Q:3}},{type:"sine",fixedFrequency:6,volume:.2,vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:102,vol:.13},{t:556,vol:.24}]},{type:"whitenoise",volume:.45,highpass:{frequency:7e3,Q:9},vmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:89,vol:.51},{t:577,vol:.29}]},{type:"sine",fixedFrequency:5.7,volume:20,fmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:89,vol:1},{t:137,vol:.46},{t:283,vol:.15},{t:600,vol:.28}]}]},sawsynth:{masterVolume:.3,midiInstrument:51,noteGlideDuration:40,masterAttackEnvelope:[{t:0,vol:.6},{t:9,vol:1},{t:102,vol:.48}],eq:[{frequency:200,gain:-6}],oscillators:[{type:"sawtooth",volume:.4,volumePitchTrackingMultiplier:.3},{type:"sawtooth",volume:.4,detune:11,volumePitchTrackingMultiplier:.3},{type:"sawtooth",volume:.4,detune:-11,volumePitchTrackingMultiplier:.3}]},basic1:{masterVolume:1,noteGlideDuration:0,masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,Q:.6,gain:-12},{frequency:1100,gain:-2},{frequency:2200,gain:-16},{frequency:5e3,gain:8},{frequency:6400,gain:10},{frequency:8e3,gain:12},{frequency:10800,gain:8}],oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.05,lowpass:{frequency:17,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"whitenoise",volume:.04,lowpass:{frequency:9e3,Q:3},highpass:{frequency:6e3,Q:3},vmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:71,vol:.73}]}]},basic2:{masterVolume:.3,eq:[{frequency:200,Q:.7,gain:6},{frequency:450,gain:2},{frequency:1300,gain:-2},{frequency:2600,Q:.8,gain:6},{frequency:3500,Q:.8,gain:6},{frequency:6200,Q:.8,gain:10},{frequency:8e3,gain:-18},{frequency:1e4,Q:.4,gain:-12}],oscillators:[{type:"pulse",volume:.4,pulseWidth:.55,volumePitchTrackingMultiplier:.1,lowpass:{frequency:4.5,frequencyPitchTrackingMultiplier:900,Q:-2},highpass:{frequency:270}}]},chord:{masterVolume:1,masterAttackEnvelope:[{t:1,vol:.79},{t:27,vol:.86},{t:62,vol:.81},{t:150,vol:.35},{t:408,vol:.04},{t:600,vol:0}],eq:[{frequency:200,gain:-8},{frequency:600,Q:2,gain:4},{frequency:800,gain:-10},{frequency:1600,gain:-2},{frequency:2200,gain:-6},{frequency:3600,Q:.7,gain:-2},{frequency:6400,gain:6},{frequency:12800,gain:6}],oscillators:[{type:"triangle",volume:1.1,volumePitchTrackingMultiplier:.05,lowpass:{frequency:8e3},highpass:{frequency:100},releaseEnvelope:[{t:1,vol:1},{t:315,vol:.56},{t:540,vol:0}]},{type:"triangle",freqMultiplier:1.17,volume:.4,volumePitchTrackingMultiplier:.07,lowpass:{frequency:5e3},highpass:{frequency:100},releaseEnvelope:[{t:0,vol:1},{t:476,vol:0}]},{type:"triangle",freqMultiplier:1.58333,volume:.7,volumePitchTrackingMultiplier:.02,highpass:{frequency:200},releaseEnvelope:[{t:0,vol:1},{t:422,vol:.56},{t:577,vol:0}]},{type:"sine",fixedFrequency:10,volume:4,fmOscillator:0,attackEnvelope:[{t:1,vol:1},{t:157,vol:.65}]},{type:"sine",fixedFrequency:5,volume:.3,vmOscillator:2,attackEnvelope:[{t:1,vol:1},{t:155,vol:.91},{t:289,vol:.78}]}]},wobble:{masterVolume:.9,masterReleaseEnvelope:[{t:1,vol:.36},{t:24,vol:.15},{t:119,vol:0}],eq:[{frequency:150,Q:.6,gain:-12},{frequency:1100,gain:-2},{frequency:2200,gain:-16},{frequency:5e3,gain:8},{frequency:6400,gain:10},{frequency:8e3,gain:12},{frequency:10800,gain:8}],oscillators:[{type:"triangle",volume:.9,volumePitchTrackingMultiplier:.1,lowpass:{frequency:17,frequencyPitchTrackingMultiplier:100},highpass:{frequency:200}},{type:"whitenoise",volume:.04,lowpass:{frequency:9e3,Q:3},highpass:{frequency:6e3,Q:3},vmOscillator:0,attackEnvelope:[{t:0,vol:0},{t:26,vol:1},{t:71,vol:.73}]},{type:"sine",freqMultiplier:.011,volume:30,fmOscillator:0}]},sine:{masterVolume:1,oscillators:[{type:"sine",volumePitchTrackingMultiplier:.07}]},sineGlide:{masterVolume:1,noteGlideDuration:100,oscillators:[{type:"sine",volumePitchTrackingMultiplier:.07}]},triangle:{masterVolume:.5,oscillators:[{type:"triangle",volume:1,volumePitchTrackingMultiplier:.07}]},sawtooth:{masterVolume:.25,midiInstrument:82,oscillators:[{type:"sawtooth",volume:.3,volumePitchTrackingMultiplier:.07}]},square:{masterVolume:.3,midiInstrument:81,oscillators:[{type:"square",volume:.2,volumePitchTrackingMultiplier:.07}]},chop:{masterVolume:1,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:600},highpass:{frequency:200}}]},shaker:{masterVolume:.4,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:6500},highpass:{frequency:5e3}}]},step:{masterVolume:1,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:44,vol:0}],eq:[{frequency:200,gain:-1},{frequency:400,gain:-14},{frequency:800,gain:8},{frequency:1e3,Q:5,gain:-24},{frequency:1600,gain:8},{frequency:2200,gain:-10},{frequency:5400,gain:4},{frequency:12800,gain:-36}],oscillators:[{type:"whitenoise",volume:1.5,lowpass:{frequency:300},highpass:{frequency:100,Q:6}}]},kick:{masterVolume:.55,masterAttackEnvelope:[{t:1,vol:.8},{t:15,vol:1},{t:45,vol:.35},{t:121,vol:.11},{t:242,vol:0}],eq:[{frequency:50,gain:6},{frequency:400,gain:-18},{frequency:1600,gain:18}],oscillators:[{type:"triangle",fixedFrequency:90,volume:1,lowpass:{frequency:300},attackEnvelope:[{t:1,vol:1},{t:6,vol:1},{t:45,vol:.01}]},{type:"whitenoise",volume:.4,lowpass:{frequency:200},attackEnvelope:[{t:1,vol:1},{t:30,vol:0}]},{type:"triangle",freqMultiplier:.1,volume:1,lowpass:{frequency:200}}]},shortnote:{masterVolume:.8,midiInstrument:116,masterAttackEnvelope:[{t:1,vol:1},{t:15,vol:0}],eq:[{frequency:400,gain:-4},{frequency:800,gain:-12},{frequency:2400,gain:4},{frequency:7200,gain:-20},{frequency:1e3,Q:5,gain:-12},{frequency:5400,gain:-32},{frequency:12800,gain:-14}],oscillators:[{type:"sawtooth",volume:.6,lowpass:{frequency:1e3}},{type:"whitenoise",volume:.2,lowpass:{frequency:1e4},highpass:{frequency:7e3},attackEnvelope:[{t:1,vol:1},{t:10,vol:0}]},{type:"whitenoise",volume:1.3,lowpass:{frequency:700,Q:4},highpass:{frequency:250}}]},noise:{masterVolume:.3,midiInstrument:122,oscillators:[{type:"whitenoise"}]},filteredNoise:{masterVolume:.3,midiInstrument:122,eq:[{frequency:1600,gain:-8},{frequency:2200,gain:-4}],oscillators:[{type:"whitenoise",lowpass:{frequency:5,frequencyPitchTrackingMultiplier:1300,Q:6},highpass:{frequency:5,frequencyPitchTrackingMultiplier:300,Q:6}}]},wind:{masterVolume:.75,midiInstrument:122,noteGlideDuration:150,masterReleaseEnvelope:[{t:0,vol:1},{t:124,vol:.24},{t:281,vol:0}],oscillators:[{type:"whitenoise",volume:1,lowpass:{frequency:100,frequencyPitchTrackingMultiplier:6,Q:23},highpass:{frequency:170,frequencyPitchTrackingMultiplier:6}},{type:"sine",freqMultiplier:.016,volume:1e3,fmOscillator:0}]}}}),i(t,"Extensions/Sonification/SonificationInstrument.js",[t["Extensions/Sonification/SynthPatch.js"],t["Extensions/Sonification/InstrumentPresets.js"],t["Core/Utilities.js"]],function(e,t,i){let{defined:n,extend:s}=i;class o{constructor(i,n,o){this.audioContext=i,this.curParams={},this.midiTrackName=o.midiTrackName,this.masterVolNode=new GainNode(i),this.masterVolNode.connect(n),this.volumeNode=new GainNode(i),this.createNodesFromCapabilities(s({pan:!0},o.capabilities||{})),this.connectCapabilityNodes(this.volumeNode,this.masterVolNode),this.synthPatch=new e(i,"string"==typeof o.synthPatch?t[o.synthPatch]:o.synthPatch),this.midiInstrument=this.synthPatch.midiInstrument||1,this.synthPatch.startSilently(),this.synthPatch.connect(this.volumeNode)}setMasterVolume(e){this.masterVolNode.gain.setTargetAtTime(e,0,o.rampTime)}scheduleEventAtTime(e,t){let i=s(this.curParams,t),a=n(t.frequency)?t.frequency:n(t.note)?o.musicalNoteToFrequency(t.note):220;n(a)&&this.synthPatch.playFreqAtTime(e,a,i.noteDuration),(n(i.tremoloDepth)||n(i.tremoloSpeed))&&this.setTremoloAtTime(e,i.tremoloDepth,i.tremoloSpeed),n(i.pan)&&this.setPanAtTime(e,i.pan),n(i.volume)&&this.setVolumeAtTime(e,i.volume),(n(i.lowpassFreq)||n(i.lowpassResonance))&&this.setFilterAtTime("lowpass",e,i.lowpassFreq,i.lowpassResonance),(n(i.highpassFreq)||n(i.highpassResonance))&&this.setFilterAtTime("highpass",e,i.highpassFreq,i.highpassResonance)}silenceAtTime(e){this.synthPatch.silenceAtTime(e)}cancel(){this.synthPatch.mute(),[this.tremoloDepth&&this.tremoloDepth.gain,this.tremoloOsc&&this.tremoloOsc.frequency,this.lowpassNode&&this.lowpassNode.frequency,this.lowpassNode&&this.lowpassNode.Q,this.highpassNode&&this.highpassNode.frequency,this.highpassNode&&this.highpassNode.Q,this.panNode&&this.panNode.pan,this.volumeNode.gain].forEach(e=>e&&e.cancelScheduledValues(0))}destroy(){this.cancel(),this.synthPatch.stop(),this.tremoloOsc&&this.tremoloOsc.stop(),[this.tremoloDepth,this.tremoloOsc,this.lowpassNode,this.highpassNode,this.panNode,this.volumeNode,this.masterVolNode].forEach(e=>e&&e.disconnect())}setPanAtTime(e,t){this.panNode&&this.panNode.pan.setTargetAtTime(t,e+this.audioContext.currentTime,o.rampTime)}setFilterAtTime(e,t,i,s){let a=this[e+"Node"],l=this.audioContext.currentTime+t;a&&(n(s)&&a.Q.setTargetAtTime(s,l,o.rampTime),n(i)&&a.frequency.setTargetAtTime(i,l,o.rampTime))}setVolumeAtTime(e,t){this.volumeNode&&this.volumeNode.gain.setTargetAtTime(t,e+this.audioContext.currentTime,o.rampTime)}setTremoloAtTime(e,t,i){let s=this.audioContext.currentTime+e;this.tremoloDepth&&n(t)&&this.tremoloDepth.gain.setTargetAtTime(t,s,o.rampTime),this.tremoloOsc&&n(i)&&this.tremoloOsc.frequency.setTargetAtTime(15*i,s,o.rampTime)}createNodesFromCapabilities(e){let t=this.audioContext;e.pan&&(this.panNode=new StereoPannerNode(t)),e.tremolo&&(this.tremoloOsc=new OscillatorNode(t,{type:"sine",frequency:3}),this.tremoloDepth=new GainNode(t),this.tremoloOsc.connect(this.tremoloDepth),this.tremoloDepth.connect(this.masterVolNode.gain),this.tremoloOsc.start()),e.filters&&(this.lowpassNode=new BiquadFilterNode(t,{type:"lowpass",frequency:2e4}),this.highpassNode=new BiquadFilterNode(t,{type:"highpass",frequency:0}))}connectCapabilityNodes(e,t){[this.panNode,this.lowpassNode,this.highpassNode,e].reduce((e,t)=>t?(t.connect(e),t):e,t)}static noteStringToC0Distance(e){let t=e.match(/^([a-g][#b]?)([0-8])$/i),i=t?t[1]:"a",n=i[0].toLowerCase(),s=i[1],o=t?parseInt(t[2],10):4;return(({c:0,d:2,e:4,f:5,g:7,a:9,b:11})[n]||0)+("#"===s?1:"b"===s?-1:0)+12*o}static musicalNoteToFrequency(e){let t="string"==typeof e?this.noteStringToC0Distance(e):e;return 16.3516*Math.pow(2,Math.min(t,107)/12)}}return o.rampTime=e.stopRampTime/4,o}),i(t,"Extensions/Sonification/SonificationSpeaker.js",[t["Core/Utilities.js"]],function(e){let{pick:t}=e;return class{constructor(e){this.options=e,this.masterVolume=1,this.synthesis=window.speechSynthesis,void 0!==speechSynthesis.onvoiceschanged&&(speechSynthesis.onvoiceschanged=this.setVoice.bind(this)),this.setVoice(),this.scheduled=[]}say(e,i){if(this.synthesis){this.synthesis.cancel();let n=new SpeechSynthesisUtterance(e);this.voice&&(n.voice=this.voice),n.rate=i&&i.rate||this.options.rate||1,n.pitch=i&&i.pitch||this.options.pitch||1,n.volume=t(i&&i.volume,this.options.volume,1)*this.masterVolume,this.synthesis.speak(n)}}sayAtTime(e,t,i){this.scheduled.push(setTimeout(this.say.bind(this,t,i),e))}cancel(){this.scheduled.forEach(clearTimeout),this.scheduled=[],this.synthesis.cancel()}destroy(){this.cancel()}setMasterVolume(e){this.masterVolume=e}setVoice(){if(this.synthesis){let e;let t=this.options.name,i=this.options.language||"en-US",n=this.synthesis.getVoices(),s=n.length;for(let o=0;o<s;++o){if(t&&n[o].name===t){this.voice=n[o];return}if(!e&&n[o].lang===i&&(e=n[o],!t))break}this.voice=e}}}}),i(t,"Extensions/Sonification/TimelineChannel.js",[],function(){return class{constructor(e,t,i=!1,n,s){this.type=e,this.engine=t,this.showPlayMarker=i,this.muted=s,this.events=n||[]}addEvent(e){let t=this.events[this.events.length-1];if(t&&e.time<t.time){let t=this.events.length;for(;t--&&this.events[t].time>e.time;);this.events.splice(t+1,0,e)}else this.events.push(e);return e}mute(){this.muted=!0}unmute(){this.muted=!1}cancel(){this.engine.cancel()}destroy(){this.engine.destroy()}}}),i(t,"Extensions/Sonification/MIDI.js",[t["Extensions/Sonification/SonificationInstrument.js"],t["Core/Utilities.js"]],function(e,t){let{pick:i}=t,n=e=>Math.round(12*Math.log(e)/Math.LN2-48.37632),s=(e,t)=>t>>>8*e&255,o=e=>[77,84,104,100,0,0,0,6,0,e>1?1:0,s(1,e),s(0,e),1,244],a=[0,255,81,3,7,161,32],l=e=>{let t=127&e,i=[];for(;e>>=7;)t<<=8,t|=127&e|128;for(;;)if(i.push(255&t),128&t)t>>=8;else break;return i},r=t=>{let s,o;let a=[],l=e=>{let t=a.length;for(;t--&&a[t].timeMS>e.timeMS;);a.splice(t+1,0,e)};return t.forEach(t=>{let a=t.instrumentEventOptions||{},r=t.time,h=o=i(a.noteDuration,o),c=h&&t.time+h,u=[{valMap:e=>64+63*e&127,data:{10:a.pan,92:a.tremoloDepth,93:a.tremoloSpeed}},{valMap:e=>127*e/2e4&127,data:{74:a.lowpassFreq,75:a.highpassFreq}},{valMap:e=>63*Math.min(18,Math.max(-18,e))/18+63&127,data:{71:a.lowpassResonance,76:a.highpassResonance}}],m=s=void 0===a.volume?i(s,127):127*a.volume&127,p=a.frequency,d=a.note||0,f=12+(p?n(p):"string"==typeof d?e.noteStringToC0Distance(d):d)&127;u.forEach(e=>Object.keys(e.data).forEach(t=>{let i=e.data[t];void 0!==i&&l({timeMS:r,type:"CTRL_CHG",data:[176,parseInt(t,10),e.valMap(i)]})})),c&&(l({timeMS:r,type:"NON",data:[144,f,m]}),l({timeMS:c,type:"NOF",data:[128,f,m]}))}),a},h=(e,t)=>{let i=[];if(t&&i.push(0,192,127&t),e){let t=[];for(let i=0;i<e.length;++i){let n=e.charCodeAt(i);n<128&&t.push(n)}return i.concat([0,255,3],l(t.length),t)}return i},c=(e,t,i,n)=>{let o=0,c=h(i,n),u=r(e).reduce((e,t)=>{let i=l(t.timeMS-o);return o=t.timeMS,e.concat(i,t.data)},[]),m=[0,255,47,0],p=(t?a.length:0)+c.length+u.length+m.length;return[77,84,114,107,s(3,p),s(2,p),s(1,p),s(0,p)].concat(t?a:[],c,u,m)};return function(e){let t=e.filter(e=>!!e.events.length),i=t.length,n=i>1;return new Uint8Array(o(n?i+1:i).concat(n?c([],!0):[],t.reduce((e,t)=>{let i=t.engine;return e.concat(c(t.events,!n,i.midiTrackName,i.midiInstrument))},[])))}}),i(t,"Extensions/DownloadURL.js",[t["Core/Globals.js"]],function(e){let{isSafari:t,win:i,win:{document:n}}=e,s=i.URL||i.webkitURL||i;function o(e){let t=e.replace(/filename=.*;/,"").match(/data:([^;]*)(;base64)?,([0-9A-Za-z+/]+)/);if(t&&t.length>3&&i.atob&&i.ArrayBuffer&&i.Uint8Array&&i.Blob&&s.createObjectURL){let e=i.atob(t[3]),n=new i.ArrayBuffer(e.length),o=new i.Uint8Array(n);for(let t=0;t<o.length;++t)o[t]=e.charCodeAt(t);return s.createObjectURL(new i.Blob([o],{type:t[1]}))}}return{dataURLtoBlob:o,downloadURL:function(e,s){let a=i.navigator,l=n.createElement("a");if("string"!=typeof e&&!(e instanceof String)&&a.msSaveOrOpenBlob){a.msSaveOrOpenBlob(e,s);return}e=""+e;let r=/Edge\/\d+/.test(a.userAgent),h=t&&"string"==typeof e&&0===e.indexOf("data:application/pdf");if((h||r||e.length>2e6)&&!(e=o(e)||""))throw Error("Failed to convert to blob");if(void 0!==l.download)l.href=e,l.download=s,n.body.appendChild(l),l.click(),n.body.removeChild(l);else try{if(!i.open(e,"chart"))throw Error("Failed to open window")}catch{i.location.href=e}}}}),i(t,"Extensions/Sonification/SonificationTimeline.js",[t["Extensions/Sonification/TimelineChannel.js"],t["Extensions/Sonification/MIDI.js"],t["Extensions/DownloadURL.js"],t["Core/Utilities.js"]],function(e,t,i,n){let{downloadURL:s}=i,{defined:o,find:a,merge:l}=n;return class{constructor(e,t){this.chart=t,this.isPaused=!1,this.isPlaying=!1,this.channels=[],this.scheduledCallbacks=[],this.playTimestamp=0,this.resumeFromTime=0,this.options=e||{}}addChannel(t,i,n=!1,s){if("instrument"===t&&!i.scheduleEventAtTime||"speech"===t&&!i.sayAtTime)throw Error("Highcharts Sonification: Invalid channel engine.");let o=new e(t,i,n,s);return this.channels.push(o),o}play(t,i=!0,n=!0,s){this.isPlaying?this.cancel():this.clearScheduledCallbacks(),this.onEndArgument=s,this.playTimestamp=Date.now(),this.resumeFromTime=0,this.isPaused=!1,this.isPlaying=!0;let o=this.options.skipThreshold||2,r=this.options.onPlay,h=this.options.showTooltip,c=this.options.showCrosshair,u=t?function(t,i){let n=i.map(e=>(e.cancel(),{channel:e,filteredEvents:e.muted?[]:e.events.filter(t)})),s=n.reduce((e,t)=>Math.min(e,t.filteredEvents.length?t.filteredEvents[0].time:1/0),1/0);return n.map(t=>new e(t.channel.type,t.channel.engine,t.channel.showPlayMarker,t.filteredEvents.map(e=>l(e,{time:e.time-s})),t.channel.muted))}(t,this.playingChannels||this.channels):this.channels,m=e=>Object.keys(e.speechOptions||{}).concat(Object.keys(e.instrumentEventOptions||{})).join(),p=[];i&&(this.playingChannels=u),r&&r({chart:this.chart,timeline:this});let d=0;u.forEach(e=>{if(e.muted)return;let t=e.events.length,i=-1/0,n=-1/0,s="";d=Math.max(e.events[t-1]&&e.events[t-1].time||0,d);for(let l=0;l<t;++l){let r=e.events[l],u=m(r);if(u===s&&r.time-n<o)continue;s=u,n=r.time,"instrument"===e.type?e.engine.scheduleEventAtTime(r.time/1e3,r.instrumentEventOptions||{}):e.engine.sayAtTime(r.time,r.message||"",r.speechOptions||{});let d=r.relatedPoint,f=d&&d.series&&d.series.chart,y=r.callback||d&&(h||c)&&!1!==e.showPlayMarker&&(r.time-i>50||l===t-1);d&&p.push(d),y&&(this.scheduledCallbacks.push(setTimeout(()=>{if(r.callback&&r.callback(),d){if(c){let e=d.series;e&&e.xAxis&&e.xAxis.crosshair&&e.xAxis.drawCrosshair(void 0,d),e&&e.yAxis&&e.yAxis.crosshair&&e.yAxis.drawCrosshair(void 0,d)}h&&!(f&&f.hoverPoints&&f.hoverPoints.length>1&&a(f.hoverPoints,e=>e===d)&&d.onMouseOver)&&d.onMouseOver()}},r.time)),i=r.time)}});let f=this.options.onEnd,y=this.options.onStop;this.scheduledCallbacks.push(setTimeout(()=>{let e=this.chart,t={chart:e,timeline:this,pointsPlayed:p};this.isPlaying=!1,n&&this.resetPlayState(),y&&y(t),f&&f(t),s&&s(t),e&&(e.tooltip&&e.tooltip.hide(0),e.hoverSeries&&e.hoverSeries.onMouseOut(),e.axes.forEach(e=>e.hideCrosshair()))},d+250)),this.resumeFromTime=i?d:this.getLength()}pause(){return this.isPaused=!0,this.cancel(),this.resumeFromTime=Date.now()-this.playTimestamp-10,this.resumeFromTime}getCurrentTime(){return this.isPlaying?Date.now()-this.playTimestamp:this.resumeFromTime}getLength(){return this.channels.reduce((e,t)=>{let i=t.events[t.events.length-1];return i?Math.max(i.time,e):e},0)}resume(){if(this.playingChannels){let e=this.resumeFromTime-50;this.play(t=>t.time>e,!1,!1,this.onEndArgument),this.playTimestamp-=e}else this.play(void 0,!1,!1,this.onEndArgument)}anchorPlayMoment(e,t){this.isPlaying&&this.pause();let i=0;this.play((t,n,s)=>{let o=e(t,n,s);return o&&t.time>i&&(i=t.time),o},!1,!1,t),this.playingChannels=this.playingChannels||this.channels,this.isPaused=!0,this.isPlaying=!1,this.resumeFromTime=i}playAdjacent(e,t,i,n){this.isPlaying&&this.pause();let s=this.resumeFromTime,o=this.channels.reduce((t,i)=>{let o=n?i.events.filter(n):i.events,a=0,l=o.length,r=t;for(;a<l;){let t=a+l>>1,i=o[t].time,n=i-s;n>0?(e&&i<r&&(r=i),l=t):n<0?(!e&&i>r&&(r=i),a=t+1):e?a=t+1:l=t}return r},e?1/0:-1/0);if(o===1/0||o===-1/0){i&&i({chart:this.chart,timeline:this,attemptedNext:e});return}this.anchorPlayMoment((t,i,a)=>{let l=e?t.time>s&&t.time<=o+.02:t.time<s&&t.time>=o-.02;return n?l&&n(t,i,a):l},t)}playClosestToPropValue(e,t,i,n,s){let a=(e,t,i)=>!!(s?s(e,t,i)&&e.relatedPoint:e.relatedPoint),l=1/0,r=null;(this.playingChannels||this.channels).forEach(i=>{let n=i.events,s=n.length;for(;s--;){if(!a(n[s],s,n))continue;let i=n[s].relatedPoint[e],h=o(i)&&Math.abs(t-i);!1!==h&&h<l&&(l=h,r=n[s])}}),r?(this.play(e=>!!(r&&e.time<r.time+1&&e.time>r.time-1&&e.relatedPoint===r.relatedPoint),!1,!1,i),this.playingChannels=this.playingChannels||this.channels,this.isPaused=!0,this.isPlaying=!1,this.resumeFromTime=r.time):n&&n({chart:this.chart,timeline:this})}getEventsForPoint(e){return this.channels.reduce((t,i)=>{let n=i.events.filter(t=>t.relatedPoint===e);return t.concat(n)},[])}playSegment(e,t){let i={first:1/0,last:-1/0};if(this.channels.forEach(e=>{e.events.length&&(i.first=Math.min(e.events[0].time,i.first),i.last=Math.max(e.events[e.events.length-1].time,i.last))}),i.first<1/0){let n=(i.last-i.first)/100,s=i.first+e*n,o=s+n;if(!this.channels.some(e=>{let t=e.events,i=0,n=t.length;for(;i<n;){let e=i+n>>1,a=t[e].time;if(a<s)i=e+1;else{if(!(a>o))return!0;n=e}}return!1}))return;this.play(e=>e.time>=s&&e.time<=o,!1,!1,t),this.playingChannels=this.playingChannels||this.channels,this.isPaused=!0,this.isPlaying=!1,this.resumeFromTime=o}}getLastPlayedPoint(e){let t=this.getCurrentTime(),i=this.playingChannels||this.channels,n=1/0,s=null;return i.forEach(i=>{let o=i.events.filter((i,n,s)=>!!(i.relatedPoint&&i.time<=t&&(!e||e(i,n,s)))),a=o[o.length-1];if(a){let e=a.time,i=Math.abs(e-t);i<n&&(n=i,s=a.relatedPoint)}}),s}reset(){this.isPlaying&&this.cancel(),this.resetPlayState()}cancel(){let e=this.options.onStop;e&&e({chart:this.chart,timeline:this}),this.isPlaying=!1,this.channels.forEach(e=>e.cancel()),this.playingChannels&&this.playingChannels!==this.channels&&this.playingChannels.forEach(e=>e.cancel()),this.clearScheduledCallbacks(),this.resumeFromTime=0}destroy(){this.cancel(),this.playingChannels&&this.playingChannels!==this.channels&&this.playingChannels.forEach(e=>e.destroy()),this.channels.forEach(e=>e.destroy())}setMasterVolume(e){this.channels.forEach(t=>t.engine.setMasterVolume(e))}getMIDIData(){return t(this.channels.filter(e=>"instrument"===e.type))}downloadMIDI(e){let t=this.getMIDIData(),i=(e||this.chart&&this.chart.options.title&&this.chart.options.title.text||"chart")+".mid",n=new Blob([t],{type:"application/octet-stream"}),o=window.URL.createObjectURL(n);s(o,i),window.URL.revokeObjectURL(o)}resetPlayState(){delete this.playingChannels,delete this.onEndArgument,this.playTimestamp=this.resumeFromTime=0,this.isPaused=!1}clearScheduledCallbacks(){this.scheduledCallbacks.forEach(clearTimeout),this.scheduledCallbacks=[]}}}),i(t,"Extensions/Sonification/TimelineFromChart.js",[t["Extensions/Sonification/SonificationTimeline.js"],t["Extensions/Sonification/SonificationInstrument.js"],t["Extensions/Sonification/SonificationSpeaker.js"],t["Core/Utilities.js"],t["Core/Templating.js"]],function(e,t,i,n,s){let{clamp:o,defined:a,extend:l,getNestedProperty:r,merge:h,pick:c}=n,{format:u}=s,m=e=>/^([a-g][#b]?)[0-8]$/i.test(e);function p(e,t){let i;if(t){if("number"==typeof(i=e[t]))return i;i=r(t,e)}return"number"==typeof i?i:void 0}function d(e,t,i,n,s){let a=t.max-t.min;if(a<=0)return i.min;let l=i.max-i.min,r=e-t.min,h=l*r/a;if(s){let i=t.min>0?e=>Math.log(e)/Math.LOG10E:e=>{let t=Math.abs(e);t<10&&(t+=(10-t)/10);let i=Math.log(t)/Math.LN10;return e<0?-i:i},n=i(t.min);h=l*(i(e)-n)/(i(t.max)-n)}let c=n?i.max-h:i.min+h;return o(c,i.min,i.max)}function f(e,t,i,n,s,o,h){return c(function(e,t,i,n,s,o){if("number"==typeof s)return s;if("function"==typeof s)return s(l({time:0},e));let h=s,u=n.mapFunction,m=n.min,p=n.max,f=n.within,y;if("object"==typeof s&&(h=s.mapTo,u=s.mapFunction||u,m=c(s.min,m),p=c(s.max,p),f=s.within||n.within,y=s.scale),!h)return null;let g="-"===h.charAt(0);g&&(h=h.slice(1));let v=e.value,q="value"===h&&void 0!==v&&o;if(!q){let t=s.value;if(void 0!==t)v=t;else{if(!e.point)return null;v=e.point[h]}void 0===v&&(v=r(h,e.point))}if("number"!=typeof v||null===v)return null;let T=null;if(e.point){if("xAxis"===f||"yAxis"===f){let t=e.point.series[f];t&&a(t.dataMin)&&a(t.dataMax)&&(T={min:t.dataMin,max:t.dataMax})}else("series"===f||i)&&e.point.series&&(T=t.seriesExtremes[e.point.series.index][q?o:h])}if(T||(T=t.globalExtremes[q?o:h]),y){let e=[],t=Math.floor(m/12),i=Math.ceil(p/12)+1,n=y.length;for(let s=t;s<i;++s)for(let t=0;t<n;++t){let i=12*s+y[t];i>=m&&i<=p&&e.push(i)}let s=d(v,T,{min:0,max:e.length-1},g,"logarithmic"===u);return e[Math.round(s)]}return d(v,T,{min:m,max:p},g,"logarithmic"===u)}(e,t,i,l({min:0,max:1,mapTo:"y",mapFunction:"linear",within:"chart"},o||{}),n,h),s)}function y(e,n,s,o){let a=o.mapping||{},l="speech"===o.type?new i({language:o.language,name:o.preferredVoice}):new t(n,s,{capabilities:{pan:!!a.pan,tremolo:!!a.tremolo,filters:!!(a.highpass||a.lowpass)},synthPatch:o.instrument,midiTrackName:o.midiName});return e.addChannel(o.type||"instrument",l,c(o.showPlayMarker,!0))}function g(e,i,n,s,o,a){let r=(t,i,o,l)=>f(e,s,!1,(l||n)[t],i,o,a),h=[],c={noteDuration:r("noteDuration",200,{min:40,max:1e3}),pan:r("pan",0,{min:-1,max:1}),volume:r("volume",1,{min:.1,max:1})};n.frequency&&(c.frequency=r("frequency",440,{min:50,max:6e3})),n.lowpass&&(c.lowpassFreq=r("frequency",2e4,{min:0,max:2e4},n.lowpass),c.lowpassResonance=r("resonance",0,{min:-6,max:12},n.lowpass)),n.highpass&&(c.highpassFreq=r("frequency",2e4,{min:0,max:2e4},n.highpass),c.highpassResonance=r("resonance",0,{min:-6,max:12},n.highpass)),n.tremolo&&(c.tremoloDepth=r("depth",0,{min:0,max:.8},n.tremolo),c.tremoloSpeed=r("speed",0,{min:0,max:.8},n.tremolo));let u=r("gapBetweenNotes",150,{min:50,max:1e3}),p=r("playDelay",0,{max:200}),d=(n,r=0)=>{let d=n;n.mapTo?("string"==typeof n.min&&(d.min=t.noteStringToC0Distance(n.min)),"string"==typeof n.max&&(d.max=t.noteStringToC0Distance(n.max))):"string"==typeof n&&m(n)&&(d=t.noteStringToC0Distance(n)),c.note=f(e,s,!1,d,-1,{min:0,max:107},a),c.note>-1&&(o&&(c.note=Math.round(c.note)),h.push(i.addEvent({time:e.time+p+u*r,relatedPoint:e.point,instrumentEventOptions:void 0!==r?l({},c):c})))};return n.pitch&&n.pitch.constructor===Array?n.pitch.forEach(d):n.pitch?d(n.pitch):n.frequency&&h.push(i.addEvent({time:e.time+p,relatedPoint:e.point,instrumentEventOptions:c})),h}function v(e,t,i,n,s){var o;let a=(t,o,a)=>f(e,n,!1,i[t],o,a,s),l=a("playDelay",0,{max:200}),r=a("pitch",1,{min:.3,max:2}),h=a("rate",1,{min:.4,max:4}),c=a("volume",1,{min:.1}),m=u("function"==typeof(o=i.text)?o(e):o,e,e.point&&e.point.series.chart);if(m)return t.addEvent({time:e.time+l,relatedPoint:e.point,speechOptions:{pitch:r,rate:h,volume:c},message:m})}function q(e,t,i){if("function"==typeof t)return t(e);if("object"==typeof t){let n=t.prop,s=c(e.value,e.point&&p(e.point,n));if("number"!=typeof s)return!1;let o=!0,a=t.crossingUp,l=t.crossingDown,r="number"==typeof i;o=a&&l?r&&(i<a&&s>=a||i>l&&s<=l):(void 0===a||r&&i<a&&s>=a)&&(void 0===l||r&&i>l&&s<=l);let h=c(t.max,1/0),u=c(t.min,-1/0);return s<=h&&s>=u&&o}return!0}return function(t,i,n){let s=n.options.sonification||{},o=s.defaultInstrumentOptions,a=s.defaultSpeechOptions,u=h({enabled:!0,groupTimespan:15,algorithm:"minmax",prop:"y"},s.pointGrouping),T=s.globalTracks||[],w=s.globalContextTracks||[],x="sequential"===s.order,E=Math.max(50,s.duration-300),N=s.afterSeriesWait,S=s.events||{},k=function(e){let t=e.options.sonification||{},i=(t.defaultInstrumentOptions||{}).mapping||{time:"x",pitch:"y"},n=t.defaultSpeechOptions&&t.defaultSpeechOptions.mapping||{},s=[],o={},a=(e,t)=>{null!==t?(s[t]=s[t]||{},s[t][e]=!0):o[e]=!0},l={},c={},u=(e,t,i)=>{let n=e=>"-"===e.charAt(0)?e.slice(1):e;if("string"==typeof t&&"text"!==e){if("pitch"===e&&m(t))return;"time"===e&&(c[t]=!0,a(t,i)),l[n(t)]=!0;return}if(t&&t.mapTo&&"string"==typeof t.mapTo){let s=n(t.mapTo);"time"===e&&a(s,i),("time"===e||"series"===t.within)&&(c[s]=!0),l[s]=!0;return}["tremolo","lowpass","highpass"].indexOf(e)>-1&&"object"==typeof t&&Object.keys(t).forEach(e=>u(e,t[e],i))},p=(e,t)=>{Object.keys(e).forEach(i=>u(i,e[i],t))},d=e=>e.forEach(e=>{l[e.valueProp||"x"]=c[e.valueProp||"x"]=!0});p(i,null),p(n,null),d(t.globalContextTracks||[]);let f=Object.keys(o).length;return e.series.forEach(e=>{let t=e.options.sonification;if(e.visible&&!(t&&!1===t.enabled)&&(f&&(s[e.index]=h(o)),t)){let i=(t.defaultInstrumentOptions||{}).mapping,n=(t.defaultSpeechOptions||{}).mapping;i&&p(i,e.index),n&&p(n,e.index),d(t.contextTracks||[]),(t.tracks||[]).concat(t.contextTracks||[]).forEach(t=>{t.mapping&&p(t.mapping,e.index)})}}),{seriesTimeProps:s,...function(e,t,i){let n=e.series,s=t.length,o=i.length,a=e=>e.reduce((e,t)=>(e[t]={min:1/0,max:-1/0},e),{}),l=(e,t,i)=>{let n=t[i];void 0===n&&(n=r(i,t)),"number"==typeof n&&(e[i].min=Math.min(e[i].min,n),e[i].max=Math.max(e[i].max,n))},h=a(t),c=n.length,u=Array(c);for(;c--;){let e=a(i),r=n[c].options;if(!n[c].visible||r&&r.sonification&&!1===r.sonification.enabled)continue;let m=n[c].points||[],p=m.length;for(;p--;){let n=s;for(;n--;)l(h,m[p],t[n]);for(n=o;n--;)l(e,m[p],i[n])}u[c]=e}return{globalExtremes:h,seriesExtremes:u}}(e,Object.keys(l),Object.keys(c))}}(n),P=new e({onPlay:S.onPlay,onEnd:S.onEnd,onStop:S.onStop,showCrosshair:s.showCrosshair,showTooltip:s.showTooltip},n);n.sonification&&(n.sonification.propMetrics=k);let M=0;return n.series.forEach((e,n)=>{let s=e.options.sonification||{};if(e.visible&&!1!==s.enabled){let r;let m=x?function(e,t,i,n){let s,o;let a=t-(e.chart.series.length-1)*n,l=i.seriesTimeProps.every(e=>{let t=Object.keys(e);return!(t.length>1)&&(s||(s=t[0]),s===t[0])});if(l){let t=i.seriesExtremes[e.index][s],n=t.max-t.min,l=i.seriesExtremes.reduce((e,t)=>t[s]?e+t[s].max-t[s].min:e,0);o=Math.round(n/l*a)}else{let t=e.chart.series.reduce((e,t)=>e+t.points.length,0);o=Math.round((e.points||[]).length/t*a)}return Math.max(50,o)}(e,E,k,N):E,C=h(o,s.defaultInstrumentOptions),b=h(a,s.defaultSpeechOptions),A=h(u,s.pointGrouping),O=(s.tracks||[C]).concat(T),I=!!P.channels.length,V=I&&!x?s.contextTracks||[]:(s.contextTracks||[]).concat(w),j=[];O.forEach(n=>{let s=h({pointGrouping:A,midiName:n.midiName||e.name},"speech"===n.type?b:C,n),o=s.pointGrouping,a=s.activeWhen,l=e=>{"object"==typeof a&&a.prop&&(r=p(e,a.prop))},u=y(P,t,i,s),d=e=>j.push(...function(e,t,i,n){let s=[];if("speech"===i.type&&i.mapping){let o=v(e,t,i.mapping,n);o&&(s=[o])}else i.mapping&&(s=g(e,t,i.mapping,n,c(i.roundToMusicalNotes,!0)));return s}(e,u,s,k)),T=[],w=0,E=e=>{if(1===T.length)d({point:T[0].point,time:w+e/2});else{let t=function(e,t){let i=e.algorithm||"minmax",n=e=>t[e]?[t[e].point]:[];if("first"===i)return n(0);if("last"===i)return n(t.length-1);if("middle"===i)return n(t.length>>1);if("firstlast"===i)return n(0).concat(n(t.length-1));if("minmax"===i){let i,n,s,o;let a=e.prop||"y";if(t.forEach(e=>{let t=p(e.point,a);void 0!==t&&((!i||t<s)&&(i=e,s=t),(!n||t>o)&&(n=e,o=t))}),i&&n)return i.point===n.point?[i.point]:i.time>n.time?[n.point,i.point]:[i.point,n.point]}return[]}(o,T),i=e/t.length;t.forEach((e,t)=>d({point:e,time:w+i/2+i*t}))}T=[]};(e.points||[]).forEach((t,i)=>{let n=i===e.points.length-1,h=function(e,t,i,n,s,o){let a=f({point:e,time:0},s,o,n,0,{min:0,max:i,mapTo:"x"});return a+t}(t,M,m,s.mapping&&s.mapping.time||0,k,x),c={point:t,time:h};if(!s.mapping||!q(c,a,r)){l(t),n&&T.length&&E(T[T.length-1].time-T[0].time);return}if(l(t),o.enabled){let e=h-w,t=o.groupTimespan,i=n&&e<=t?e:t;n||e>t?(e<=t&&T.push(c),E(i),w=Math.floor(h/t)*t,n&&e>t?d({point:c.point,time:w+i/2}):T=[c]):T.push(c)}else d(c)})});let F=j.reduce((e,t)=>t.time<e.time?t:e,{time:1/0}),D=j.reduce((e,t)=>t.time>e.time?t:e,{time:-1/0});F.callback=S.onSeriesStart?S.onSeriesStart.bind(null,{series:e,timeline:P}):void 0,D.callback=S.onSeriesEnd?S.onSeriesEnd.bind(null,{series:e,timeline:P}):void 0,V.forEach(e=>{let s="speech"===e.type?h(a,e):h(o,{mapping:{pitch:{mapTo:"value"}}},e),u=y(P,t,i,s);r=void 0;let{timeInterval:p,valueInterval:f}=s,T=s.valueProp||"x",w=s.activeWhen,x=k.seriesExtremes[n][T],E=(e,t)=>{if(!s.mapping||!q({time:e,value:t},"object"==typeof w?l({prop:T},w):w,r)){r=t;return}r=t,"speech"===s.type?v({time:e,value:t},u,s.mapping,k,T):g({time:e,value:t},u,s.mapping,k,c(s.roundToMusicalNotes,!0),T)};if(p){let e=0;for(;e<=m;){let t=d(e,{min:0,max:m},x);E(e+M,t),e+=p}}if(f){let e=x.min;for(;e<=x.max;){let t=d(e,x,{min:0,max:m},!1,"logarithmic"===s.valueMapFunction);E(t+M,e),e+=f}}}),x&&(M+=m+N)}}),P}}),i(t,"Extensions/Sonification/Sonification.js",[t["Core/Defaults.js"],t["Core/Utilities.js"],t["Core/Globals.js"],t["Extensions/Sonification/Options.js"],t["Extensions/Sonification/SonificationInstrument.js"],t["Extensions/Sonification/SonificationSpeaker.js"],t["Extensions/Sonification/SynthPatch.js"],t["Extensions/Sonification/InstrumentPresets.js"],t["Extensions/Sonification/TimelineFromChart.js"]],function(e,t,i,n,s,o,a,l,r){let{defaultOptions:h,getOptions:c}=e,{addEvent:u,extend:m,fireEvent:p,merge:d,pick:f}=t,{doc:y,win:g}=i;class v{constructor(e){this.chart=e,this.retryContextCounter=0,this.lastUpdate=0,this.unbindKeydown=u(y,"keydown",function(t){e&&e.sonification&&("Esc"===t.key||"Escape"===t.key)&&e.sonification.cancel()});try{this.audioContext=new g.AudioContext,this.audioContext.suspend(),this.audioDestination=this.audioContext.destination}catch(e){}}setAudioDestination(e){this.audioDestination=e,this.update()}isPlaying(){return!!this.timeline&&this.timeline.isPlaying}playSegment(e,t){this.ready(this.playSegment.bind(this,e,t))&&this.timeline&&this.timeline.playSegment(e,t)}playAdjacent(e,t,i){if(this.ready(this.playAdjacent.bind(this,e,t,i))&&this.timeline){let n=this.chart.options.sonification,s=n&&n.events&&n.events.onBoundaryHit;s||this.initBoundaryInstrument(),this.timeline.playAdjacent(e,t,s||(()=>{this.defaultBoundaryHit()}),i)}}playAdjacentSeries(e,t="x",i){let n=this.getLastPlayedPoint();if(n){let s=n.series.index+(e?1:-1);return this.playClosestToProp(t,n[t],e=>!!e.relatedPoint&&e.relatedPoint.series.index===s,i),this.chart.series[s]||null}return null}playClosestToProp(e,t,i,n){if(this.ready(this.playClosestToProp.bind(this,e,t,i,n))&&this.timeline){let s=this.chart.options.sonification,o=s&&s.events&&s.events.onBoundaryHit;o||this.initBoundaryInstrument(),this.timeline.playClosestToPropValue(e,t,n,o||(()=>this.defaultBoundaryHit()),i)}}getLastPlayedPoint(){return this.timeline?this.timeline.getLastPlayedPoint():null}playNote(e,t,i=0){if(!this.ready(this.playNote.bind(this,e,t)))return;let n=t.noteDuration=t.noteDuration||500,o=new s(this.audioContext,this.audioDestination,{synthPatch:e,capabilities:{filters:!0,tremolo:!0,pan:!0}});o.scheduleEventAtTime(i/1e3,t),setTimeout(()=>o&&o.destroy(),i+n+500)}speak(e,t,i=0){let n=new o(d({language:"en-US",rate:1.5,volume:.4},t||{}));n.sayAtTime(i,e)}cancel(){this.timeline&&this.timeline.cancel(),p(this,"cancel")}downloadMIDI(){this.ready(this.downloadMIDI.bind(this))&&this.timeline&&(this.timeline.reset(),this.timeline.downloadMIDI())}sonifyChart(e,t){this.ready(this.sonifyChart.bind(this,e,t))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),this.timeline.play(void 0,void 0,e,t))}sonifySeries(e,t,i){this.ready(this.sonifySeries.bind(this,e,t,i))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),this.timeline.play(t=>!!t.relatedPoint&&t.relatedPoint.series===e,void 0,t,i))}sonifyPoint(e,t){this.ready(this.sonifyPoint.bind(this,e,t))&&this.timeline&&(this.timeline.reset(),this.beforePlay(),this.timeline.anchorPlayMoment(t=>t.relatedPoint===e,t))}setMasterVolume(e){this.timeline&&this.timeline.setMasterVolume(e)}destroy(){this.unbindKeydown(),this.timeline&&(this.timeline.destroy(),delete this.timeline),this.boundaryInstrument&&this.boundaryInstrument.stop(),this.audioContext&&(this.audioContext.close(),delete this.audioContext)}update(){let e=this.chart.options&&this.chart.options.sonification;if(!this.ready(this.update.bind(this))||!e)return;let t=Date.now(),i=e.updateInterval;if(t-this.lastUpdate<i&&!this.forceReady){clearTimeout(this.scheduledUpdate),this.scheduledUpdate=setTimeout(this.update.bind(this),i/2);return}let n=e.events||{};if(n.beforeUpdate&&n.beforeUpdate({chart:this.chart,timeline:this.timeline}),this.lastUpdate=t,this.timeline&&this.timeline.destroy(),this.audioContext&&this.audioDestination){this.timeline=r(this.audioContext,this.audioDestination,this.chart);let e=this.chart.options.sonification;this.timeline.setMasterVolume(f(e&&e.masterVolume,1))}n.afterUpdate&&n.afterUpdate({chart:this.chart,timeline:this.timeline})}ready(e){return!!this.audioContext&&!!this.audioDestination&&!!this.chart.options&&(!this.chart.options.sonification||!1!==this.chart.options.sonification.enabled)&&("suspended"!==this.audioContext.state||this.forceReady?(this.retryContextCounter=0,!0):(this.retryContextCounter++<20&&setTimeout(()=>{this.audioContext&&"suspended"===this.audioContext.state?this.audioContext.resume().then(e):e()},5),!1))}beforePlay(){let e=this.chart.options.sonification,t=e&&e.events&&e.events.beforePlay;t&&t({chart:this.chart,timeline:this.timeline})}initBoundaryInstrument(){this.boundaryInstrument||(this.boundaryInstrument=new a(this.audioContext,d(l.chop,{masterVolume:.3})),this.boundaryInstrument.startSilently(),this.boundaryInstrument.connect(this.audioDestination))}defaultBoundaryHit(){this.boundaryInstrument&&(this.boundaryInstrument.playFreqAtTime(.1,1,200),this.boundaryInstrument.playFreqAtTime(.2,1,200))}}return function(e){let t=[];function i(){let t=this.sonification,i=this.options&&this.options.sonification;i&&i.enabled?t?t.update():(this.sonification=new e(this),this.sonification.update()):t&&(t.destroy(),delete this.sonification)}function n(){this&&this.sonification&&this.sonification.destroy()}function s(){this.updateSonificationEnabled&&this.updateSonificationEnabled()}function o(e){let t=e.options.sonification;t&&(d(!0,this.options.sonification,t),s.call(this))}e.compose=function(e,a,l){-1===t.indexOf(e)&&(t.push(e),m(e.prototype,{updateSonificationEnabled:i,sonify:function(e){this.sonification&&this.sonification.sonifyChart(!1,e)},toggleSonify:function(e=!0,t){if(!this.sonification)return;let i=this.sonification.timeline;g.speechSynthesis&&g.speechSynthesis.cancel(),i&&this.sonification.isPlaying()?e?this.sonification.cancel():i.pause():i&&i.isPaused?i.resume():this.sonification.sonifyChart(e,t)}}),u(e,"destroy",n),u(e,"render",s),u(e,"update",o)),-1===t.indexOf(a)&&(t.push(a),a.prototype.sonify=function(e){this.chart.sonification&&this.chart.sonification.sonifySeries(this,!1,e)}),-1===t.indexOf(l)&&(t.push(l),l.prototype.sonify=function(e){this.series.chart.sonification&&this.series.chart.sonification.sonifyPoint(this,e)});let r=c().exporting;r&&r.buttons&&r.buttons.contextButton.menuItems&&r.buttons.contextButton.menuItems.push("separator","downloadMIDI","playAsSound")}}(v||(v={})),d(!0,h,n),v}),i(t,"Extensions/Sonification/Scales.js",[],function(){return{minor:[0,2,3,5,7,8,10],dorian:[0,2,3,5,7,9,10],harmonicMinor:[0,2,3,5,7,8,11],phrygian:[0,1,3,5,7,8,11],major:[0,2,4,5,7,9,11],lydian:[0,2,4,6,7,9,11],mixolydian:[0,2,4,5,7,9,10],majorPentatonic:[0,2,4,7,9],minorPentatonic:[0,3,5,7,10]}}),i(t,"masters/modules/sonification.src.js",[t["Core/Globals.js"],t["Extensions/Sonification/Sonification.js"],t["Extensions/Sonification/SynthPatch.js"],t["Extensions/Sonification/InstrumentPresets.js"],t["Extensions/Sonification/Scales.js"],t["Extensions/Sonification/SonificationInstrument.js"],t["Extensions/Sonification/SonificationSpeaker.js"],t["Extensions/Sonification/SonificationTimeline.js"]],function(e,t,i,n,s,o,a,l){e.sonification={InstrumentPresets:n,Scales:s,SynthPatch:i,SonificationInstrument:o,SonificationSpeaker:a,SonificationTimeline:l,Sonification:t},t.compose(e.Chart,e.Series,e.Point)})});//# sourceMappingURL=sonification.js.map