"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProperty = exports.stringify = exports.str = exports._ = exports.nil = exports.Name = exports.IDENTIFIER = exports._Code = void 0;
class _Code {
    constructor(s) {
        this._str = s;
    }
    toString() {
        return this._str;
    }
    isQuoted() {
        const len = this._str.length;
        return len >= 2 && this._str[0] === '"' && this._str[len - 1] === '"';
    }
    add(c) {
        this._str += c._str;
    }
}
exports._Code = _Code;
exports.IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
class Name extends _Code {
    constructor(s) {
        super(s);
        if (!exports.IDENTIFIER.test(s))
            throw new Error("CodeGen: name must be a valid identifier");
    }
    isQuoted() {
        return false;
    }
    add(_c) {
        throw new Error("CodeGen: can't add to Name");
    }
}
exports.Name = Name;
exports.nil = new _Code("");
function _(strs, ...args) {
    // TODO benchmark if loop is faster than reduce
    // let res = strs[0]
    // for (let i = 0; i < args.length; i++) {
    //   res += interpolate(args[i]) + strs[i + 1]
    // }
    // return new _Code(res)
    return new _Code(strs.reduce((res, s, i) => `${res}${interpolate(args[i - 1])}${s}`));
}
exports._ = _;
function str(strs, ...args) {
    return new _Code(strs.map(safeStringify).reduce((res, s, i) => {
        let aStr = interpolateStr(args[i - 1]);
        if (aStr instanceof _Code && aStr.isQuoted())
            aStr = aStr.toString();
        return typeof aStr === "string"
            ? res.slice(0, -1) + aStr.slice(1, -1) + s.slice(1)
            : `${res} + ${aStr} + ${s}`;
    }));
}
exports.str = str;
function interpolate(x) {
    return x instanceof _Code || typeof x == "number" || typeof x == "boolean" || x === null
        ? x
        : safeStringify(x);
}
function interpolateStr(x) {
    if (Array.isArray(x))
        x = x.join(",");
    return interpolate(x);
}
function stringify(x) {
    return new _Code(safeStringify(x));
}
exports.stringify = stringify;
function safeStringify(x) {
    return JSON.stringify(x)
        .replace(/\u2028/g, "\\u2028")
        .replace(/\u2029/g, "\\u2029");
}
function getProperty(key) {
    return typeof key == "string" && exports.IDENTIFIER.test(key) ? new _Code(`.${key}`) : _ `[${key}]`;
}
exports.getProperty = getProperty;
//# sourceMappingURL=code.js.map