import type { ScopeValueSets, NameValue, ValueScope, ValueScopeName } from "./scope";
import { _Code, Code, Name } from "./code";
import { Scope } from "./scope";
export { _, str, nil, getProperty, stringify, Name, Code } from "./code";
export { Scope, ScopeStore, ValueScope } from "./scope";
declare enum BlockKind {
    If = 0,
    Else = 1,
    For = 2,
    Func = 3
}
export declare type SafeExpr = Code | number | boolean | null;
export declare type Block = Code | (() => void);
export declare const operators: {
    GT: _Code;
    GTE: _Code;
    LT: _Code;
    LTE: _Code;
    EQ: _Code;
    NEQ: _Code;
    NOT: _Code;
    OR: _Code;
    AND: _Code;
};
export declare const varKinds: {
    const: Name;
    let: Name;
    var: Name;
};
export interface CodeGenOptions {
    es5?: boolean;
    lines?: boolean;
    forInOwn?: boolean;
}
export declare class CodeGen {
    readonly _scope: Scope;
    readonly _extScope: ValueScope;
    readonly _values: ScopeValueSets;
    private readonly _blocks;
    private readonly _blockStarts;
    private readonly opts;
    private readonly _n;
    private _out;
    constructor(extScope: ValueScope, opts?: CodeGenOptions);
    toString(): string;
    name(prefix: string): Name;
    scopeName(prefix: string): ValueScopeName;
    scopeValue(prefixOrName: ValueScopeName | string, value: NameValue): Name;
    getScopeValue(prefix: string, keyOrRef: unknown): ValueScopeName | void;
    scopeRefs(scopeName: Name): Code;
    private _def;
    const(nameOrPrefix: Name | string, rhs?: SafeExpr): Name;
    let(nameOrPrefix: Name | string, rhs?: SafeExpr): Name;
    var(nameOrPrefix: Name | string, rhs?: SafeExpr): Name;
    assign(name: Code, rhs: SafeExpr): CodeGen;
    code(c: Block | SafeExpr): CodeGen;
    if(condition: Code | boolean, thenBody?: Block, elseBody?: Block): CodeGen;
    ifNot(condition: Code, thenBody?: Block, elseBody?: Block): CodeGen;
    elseIf(condition: Code): CodeGen;
    else(): CodeGen;
    endIf(): CodeGen;
    for(iteration: Code, forBody?: Block): CodeGen;
    forRange(nameOrPrefix: Name | string, from: SafeExpr, to: SafeExpr, forBody: (index: Name) => void, varKind?: Code): CodeGen;
    forOf(nameOrPrefix: Name | string, iterable: SafeExpr, forBody: (item: Name) => void, varKind?: Code): CodeGen;
    forIn(nameOrPrefix: Name | string, obj: SafeExpr, forBody: (item: Name) => void, varKind?: Code): CodeGen;
    private _loop;
    endFor(): CodeGen;
    label(label?: Code): CodeGen;
    break(label?: Code): CodeGen;
    return(value: Block | SafeExpr): CodeGen;
    try(tryBody: Block, catchCode?: (e: Name) => void, finallyCode?: Block): CodeGen;
    throw(err: Code): CodeGen;
    block(body?: Block, expectedToClose?: number): CodeGen;
    endBlock(expectedToClose?: number): CodeGen;
    func(name: Name, args?: Code, async?: boolean, funcBody?: Block): CodeGen;
    endFunc(): CodeGen;
    get _lastBlock(): BlockKind;
    set _lastBlock(b: BlockKind);
    _last(): number;
}
export declare function and(...args: Code[]): Code;
export declare function or(...args: Code[]): Code;
