import { Code, Name } from "./code";
interface NameGroup {
    prefix: string;
    index: number;
}
export interface NameValue {
    ref: ValueReference;
    key?: unknown;
    code?: Code;
}
export declare type ValueReference = unknown;
interface ScopeOptions {
    prefixes?: Set<string>;
    parent?: Scope;
}
interface ValueScopeOptions extends ScopeOptions {
    scope: ScopeStore;
}
export declare type ScopeStore = Record<string, ValueReference[] | undefined>;
interface ScopeValues {
    [prefix: string]: Map<unknown, ValueScopeName> | undefined;
}
export interface ScopeValueSets {
    [prefix: string]: Set<ValueScopeName> | undefined;
}
export declare class Scope {
    protected readonly _names: {
        [prefix: string]: NameGroup | undefined;
    };
    protected readonly _prefixes?: Set<string>;
    protected readonly _parent?: Scope;
    constructor({ prefixes, parent }?: ScopeOptions);
    toName(nameOrPrefix: Name | string): Name;
    name(prefix: string): Name;
    protected _newName(prefix: string): string;
    private _nameGroup;
}
interface ScopePath {
    property: string;
    itemIndex: number;
}
export declare class ValueScopeName extends Name {
    readonly prefix: string;
    value?: NameValue;
    scopePath?: Code;
    constructor(prefix: string, nameStr: string);
    setValue(value: NameValue, { property, itemIndex }: ScopePath): void;
}
export declare class ValueScope extends Scope {
    protected readonly _values: ScopeValues;
    protected readonly _scope: ScopeStore;
    constructor(opts: ValueScopeOptions);
    get(): ScopeStore;
    name(prefix: string): ValueScopeName;
    value(nameOrPrefix: ValueScopeName | string, value: NameValue): ValueScopeName;
    getValue(prefix: string, keyOrRef: unknown): ValueScopeName | void;
    scopeRefs(scopeName: Name, values?: ScopeValues | ScopeValueSets): Code;
    scopeCode(values?: ScopeValues | ScopeValueSets): Code;
    private _reduceValues;
}
export {};
