"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.extendErrors = exports.resetErrorsCount = exports.reportExtraError = exports.reportError = exports.keyword$DataError = exports.keywordError = void 0;
const codegen_1 = require("./codegen");
const names_1 = __importDefault(require("./names"));
exports.keywordError = {
    message: ({ keyword }) => codegen_1.str `should pass "${keyword}" keyword validation`,
};
exports.keyword$DataError = {
    message: ({ keyword, schemaType }) => schemaType
        ? codegen_1.str `"${keyword}" keyword must be ${schemaType} ($data)`
        : codegen_1.str `"${keyword}" keyword is invalid ($data)`,
};
function reportError(cxt, error, overrideAllErrors) {
    const { it } = cxt;
    const { gen, compositeRule, allErrors } = it;
    const errObj = errorObjectCode(cxt, error);
    if (overrideAllErrors !== null && overrideAllErrors !== void 0 ? overrideAllErrors : (compositeRule || allErrors)) {
        addError(gen, errObj);
    }
    else {
        returnErrors(it, codegen_1._ `[${errObj}]`);
    }
}
exports.reportError = reportError;
function reportExtraError(cxt, error) {
    const { it } = cxt;
    const { gen, compositeRule, allErrors } = it;
    const errObj = errorObjectCode(cxt, error);
    addError(gen, errObj);
    if (!(compositeRule || allErrors)) {
        returnErrors(it, names_1.default.vErrors);
    }
}
exports.reportExtraError = reportExtraError;
function resetErrorsCount(gen, errsCount) {
    gen.assign(names_1.default.errors, errsCount);
    gen.if(codegen_1._ `${names_1.default.vErrors} !== null`, () => gen.if(errsCount, codegen_1._ `${names_1.default.vErrors}.length = ${errsCount}`, codegen_1._ `${names_1.default.vErrors} = null`));
}
exports.resetErrorsCount = resetErrorsCount;
function extendErrors({ gen, keyword, schemaValue, data, errsCount, it, }) {
    if (errsCount === undefined)
        throw new Error("ajv implementation error");
    const err = gen.name("err");
    gen.forRange("i", errsCount, names_1.default.errors, (i) => {
        gen.const(err, codegen_1._ `${names_1.default.vErrors}[${i}]`);
        gen.if(codegen_1._ `${err}.dataPath === undefined`, codegen_1._ `${err}.dataPath = (${names_1.default.dataPath} || '') + ${it.errorPath}`);
        gen.code(codegen_1._ `${err}.schemaPath = ${codegen_1.str `${it.errSchemaPath}/${keyword}`}`);
        if (it.opts.verbose) {
            gen.code(codegen_1._ `${err}.schema = ${schemaValue}; ${err}.data = ${data}`);
        }
    });
}
exports.extendErrors = extendErrors;
function addError(gen, errObj) {
    const err = gen.const("err", errObj);
    gen.if(codegen_1._ `${names_1.default.vErrors} === null`, codegen_1._ `${names_1.default.vErrors} = [${err}]`, codegen_1._ `${names_1.default.vErrors}.push(${err})`);
    gen.code(codegen_1._ `${names_1.default.errors}++`);
}
function returnErrors(it, errs) {
    const { gen, validateName, schemaEnv } = it;
    if (schemaEnv.$async) {
        gen.code(codegen_1._ `throw new ${it.ValidationError}(${errs})`);
    }
    else {
        gen.assign(codegen_1._ `${validateName}.errors`, errs);
        gen.return(false);
    }
}
function errorObjectCode(cxt, error) {
    const { keyword, data, schemaValue, it: { createErrors, topSchemaRef, schemaPath, errorPath, errSchemaPath, propertyName, opts }, } = cxt;
    if (createErrors === false)
        return codegen_1._ `{}`;
    const { params, message } = error;
    const msg = typeof message == "string" ? message : message(cxt);
    const par = params ? params(cxt) : codegen_1._ `{}`;
    const out = codegen_1._ `{keyword: ${keyword}, dataPath: (${names_1.default.dataPath} || "") + ${errorPath}`;
    out.add(codegen_1._ `, schemaPath: ${codegen_1.str `${errSchemaPath}/${keyword}`}, params: ${par}`);
    if (propertyName) {
        out.add(codegen_1._ `, propertyName: ${propertyName}`);
    }
    if (opts.messages !== false) {
        out.add(codegen_1._ `, message: ${msg}`);
    }
    if (opts.verbose) {
        out.add(codegen_1._ `, schema: ${schemaValue}, parentSchema: ${topSchemaRef}${schemaPath}, data: ${data}`);
    }
    out.add(codegen_1._ `}`);
    return out;
}
//# sourceMappingURL=errors.js.map