import type { AnySchema, AnyValidateFunction } from "../types";
import type Ajv from "../ajv";
import { Name } from "./codegen";
import { LocalRefs } from "./resolve";
export interface SchemaRefs {
    [ref: string]: SchemaEnv | AnySchema | undefined;
}
interface SchemaEnvArgs {
    schema: AnySchema;
    root?: SchemaEnv;
    baseId?: string;
    localRefs?: LocalRefs;
    meta?: boolean;
    cacheKey?: unknown;
}
export declare class SchemaEnv implements SchemaEnvArgs {
    readonly schema: AnySchema;
    readonly root: SchemaEnv;
    baseId: string;
    localRefs?: LocalRefs;
    readonly meta?: boolean;
    readonly cacheKey?: unknown;
    readonly $async?: boolean;
    readonly refs: SchemaRefs;
    validate?: AnyValidateFunction;
    validateName?: Name;
    constructor(env: SchemaEnvArgs);
}
export declare function compileSchema(this: Ajv, sch: SchemaEnv): SchemaEnv;
export declare function resolveRef(this: Ajv, root: SchemaEnv, baseId: string, ref: string): AnySchema | AnyValidateFunction | SchemaEnv | undefined;
export declare function resolveSchema(this: Ajv, root: SchemaEnv, // root object with properties schema, refs TODO below SchemaEnv is assigned to it
ref: string): SchemaEnv | undefined;
export {};
