"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSchemaRefs = exports.resolveUrl = exports.normalizeId = exports._getFullPath = exports.getFullPath = exports.inlineRef = void 0;
const util_1 = require("./util");
const fast_deep_equal_1 = __importDefault(require("fast-deep-equal"));
const json_schema_traverse_1 = __importDefault(require("json-schema-traverse"));
const URI = require("uri-js");
// TODO refactor to use keyword definitions
const SIMPLE_INLINED = util_1.toHash([
    "type",
    "format",
    "pattern",
    "maxLength",
    "minLength",
    "maxProperties",
    "minProperties",
    "maxItems",
    "minItems",
    "maximum",
    "minimum",
    "uniqueItems",
    "multipleOf",
    "required",
    "enum",
    "const",
]);
function inlineRef(schema, limit = true) {
    if (typeof schema == "boolean")
        return true;
    if (limit === true)
        return !hasRef(schema);
    if (!limit)
        return false;
    return countKeys(schema) <= limit;
}
exports.inlineRef = inlineRef;
function hasRef(schema) {
    for (const key in schema) {
        if (key === "$ref")
            return true;
        const sch = schema[key];
        if (Array.isArray(sch) && sch.some(hasRef))
            return true;
        if (typeof sch == "object" && hasRef(sch))
            return true;
    }
    return false;
}
function countKeys(schema) {
    let count = 0;
    for (const key in schema) {
        if (key === "$ref")
            return Infinity;
        count++;
        if (SIMPLE_INLINED[key])
            continue;
        if (typeof schema[key] == "object") {
            util_1.eachItem(schema[key], (sch) => (count += countKeys(sch)));
        }
        if (count === Infinity)
            return Infinity;
    }
    return count;
}
function getFullPath(id = "", normalize) {
    if (normalize !== false)
        id = normalizeId(id);
    const p = URI.parse(id);
    return _getFullPath(p);
}
exports.getFullPath = getFullPath;
function _getFullPath(p) {
    return URI.serialize(p).split("#")[0] + "#";
}
exports._getFullPath = _getFullPath;
const TRAILING_SLASH_HASH = /#\/?$/;
function normalizeId(id) {
    return id ? id.replace(TRAILING_SLASH_HASH, "") : "";
}
exports.normalizeId = normalizeId;
function resolveUrl(baseId, id) {
    id = normalizeId(id);
    return URI.resolve(baseId, id);
}
exports.resolveUrl = resolveUrl;
function getSchemaRefs(schema) {
    if (typeof schema == "boolean")
        return {};
    const schemaId = normalizeId(schema.$id);
    const baseIds = { "": schemaId };
    const pathPrefix = getFullPath(schemaId, false);
    const localRefs = {};
    json_schema_traverse_1.default(schema, { allKeys: true }, (sch, jsonPtr, _, parentJsonPtr) => {
        if (parentJsonPtr === undefined)
            return;
        const fullPath = pathPrefix + jsonPtr;
        let id = sch.$id;
        let baseId = baseIds[parentJsonPtr];
        if (typeof id == "string") {
            id = baseId = normalizeId(baseId ? URI.resolve(baseId, id) : id);
            let schOrRef = this.refs[id];
            if (typeof schOrRef == "string")
                schOrRef = this.refs[schOrRef];
            if (typeof schOrRef == "object") {
                checkAmbiguosId(sch, schOrRef.schema, id);
            }
            else if (id !== normalizeId(fullPath)) {
                if (id[0] === "#") {
                    checkAmbiguosId(sch, localRefs[id], id);
                    localRefs[id] = sch;
                }
                else {
                    this.refs[id] = fullPath;
                }
            }
        }
        baseIds[jsonPtr] = baseId;
    });
    return localRefs;
    function checkAmbiguosId(sch1, sch2, id) {
        if (sch2 !== undefined && !fast_deep_equal_1.default(sch1, sch2)) {
            throw new Error(`id "${id}" resolves to more than one schema`);
        }
    }
}
exports.getSchemaRefs = getSchemaRefs;
//# sourceMappingURL=resolve.js.map