import type { KeywordDefinition } from "../types";
interface ValidationTypes {
    [key: string]: boolean | RuleGroup | undefined;
}
export interface ValidationRules {
    rules: RuleGroup[];
    all: {
        [key: string]: boolean | Rule | undefined;
    };
    keywords: {
        [key: string]: boolean | undefined;
    };
    types: ValidationTypes;
}
export interface RuleGroup {
    type?: string;
    rules: Rule[];
}
export interface Rule {
    keyword: string;
    definition: KeywordDefinition;
}
export declare function getRules(): ValidationRules;
export {};
