"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRules = void 0;
const util_1 = require("./util");
const ALL = ["type", "$comment"];
function getRules() {
    const groups = {
        number: { type: "number", rules: [] },
        string: { type: "string", rules: [] },
        array: { type: "array", rules: [] },
        object: { type: "object", rules: [] },
    };
    return {
        types: { ...groups, integer: true, boolean: true, null: true },
        rules: [groups.number, groups.string, groups.array, groups.object, { rules: [] }],
        all: util_1.toHash(ALL),
        keywords: util_1.toHash(ALL),
    };
}
exports.getRules = getRules;
//# sourceMappingURL=rules.js.map