import type { AnySchema, SchemaObjCxt } from "../types";
import { Code, Name } from "./codegen";
export interface SubschemaContext {
    schema: AnySchema;
    schemaPath: Code;
    errSchemaPath: string;
    topSchemaRef?: Code;
    errorPath?: Code;
    dataLevel?: number;
    data?: Name;
    parentData?: Name;
    parentDataProperty?: Code | number;
    dataNames?: Name[];
    dataPathArr?: (Code | number)[];
    propertyName?: Name;
    compositeRule?: true;
    createErrors?: boolean;
    allErrors?: boolean;
}
export declare enum Type {
    Num = 0,
    Str = 1
}
export declare type SubschemaApplication = Partial<SubschemaApplicationParams>;
interface SubschemaApplicationParams {
    keyword: string;
    schemaProp: string | number;
    schema: AnySchema;
    schemaPath: Code;
    errSchemaPath: string;
    topSchemaRef: Code;
    data: Name | Code;
    dataProp: Code | string | number;
    propertyName: Name;
    dataPropType: Type;
    compositeRule: true;
    createErrors: boolean;
    allErrors: boolean;
}
export declare function applySubschema(it: SchemaObjCxt, appl: SubschemaApplication, valid: Name): void;
export {};
