import { Code, Name } from "./codegen";
import type { SchemaCxt, AnySchema } from "../types";
import type { Rule, ValidationRules } from "./rules";
export declare enum DataType {
    Correct = 0,
    Wrong = 1
}
export declare function checkDataType(dataType: string, data: Name, strictNums?: boolean | "log", correct?: DataType): Code;
export declare function checkDataTypes(dataTypes: string[], data: Name, strictNums?: boolean | "log", correct?: DataType): Code;
export declare function toHash(arr: string[]): {
    [key: string]: true | undefined;
};
export declare function schemaHasRules(schema: AnySchema, rules: {
    [key: string]: boolean | Rule | undefined;
}): boolean;
export declare function schemaCxtHasRules({ schema, self }: SchemaCxt): boolean;
export declare function schemaHasRulesButRef(schema: AnySchema, RULES: ValidationRules): boolean;
export declare function getData($data: string, { dataLevel, dataNames, dataPathArr }: SchemaCxt): Code | number;
export declare function unescapeFragment(str: string): string;
export declare function escapeFragment(str: string | number): string;
export declare function escapeJsonPointer(str: string | number): string;
export declare function eachItem<T>(xs: T | T[], f: (x: T) => void): void;
