"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.schemaKeywords = void 0;
const applicability_1 = require("./applicability");
const util_1 = require("../util");
const keyword_1 = require("./keyword");
const defaults_1 = require("./defaults");
const dataType_1 = require("./dataType");
const codegen_1 = require("../codegen");
const names_1 = __importDefault(require("../names"));
function schemaKeywords(it, types, typeErrors, errsCount) {
    const { gen, schema, data, allErrors, opts, self } = it;
    const { RULES } = self;
    if (schema.$ref && !(opts.extendRefs === true && util_1.schemaHasRulesButRef(schema, RULES))) {
        gen.block(() => keyword_1.keywordCode(it, "$ref", RULES.all.$ref.definition)); // TODO typecast
        return;
    }
    gen.block(() => {
        for (const group of RULES.rules) {
            if (applicability_1.shouldUseGroup(schema, group)) {
                groupKeywords(group);
            }
        }
    });
    function groupKeywords(group) {
        if (group.type) {
            gen.if(util_1.checkDataType(group.type, data, opts.strict));
            iterateKeywords(it, group);
            if (types.length === 1 && types[0] === group.type && typeErrors) {
                gen.else();
                dataType_1.reportTypeError(it);
            }
            gen.endIf();
        }
        else {
            iterateKeywords(it, group);
        }
        // TODO make it "ok" call?
        if (!allErrors)
            gen.if(codegen_1._ `${names_1.default.errors} === ${errsCount || 0}`);
    }
}
exports.schemaKeywords = schemaKeywords;
function iterateKeywords(it, group) {
    const { gen, schema, opts: { useDefaults }, } = it;
    if (useDefaults)
        defaults_1.assignDefaults(it, group.type);
    gen.block(() => {
        for (const rule of group.rules) {
            if (applicability_1.shouldUseRule(schema, rule)) {
                keyword_1.keywordCode(it, rule.keyword, rule.definition, group.type);
            }
        }
    });
}
//# sourceMappingURL=iterate.js.map