"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
const subschema_1 = require("../../compile/subschema");
const codegen_1 = require("../../compile/codegen");
const def = {
    keyword: "additionalItems",
    type: "array",
    schemaType: ["boolean", "object"],
    before: "uniqueItems",
    code(cxt) {
        const { gen, schema, parentSchema, data, it } = cxt;
        const len = gen.const("len", codegen_1._ `${data}.length`);
        const { items } = parentSchema;
        if (!Array.isArray(items)) {
            util_1.checkStrictMode(it, '"additionalItems" without "items" is ignored');
            return;
        }
        if (schema === false) {
            cxt.setParams({ len: items.length });
            cxt.pass(codegen_1._ `${len} <= ${items.length}`);
        }
        else if (typeof schema == "object" && !util_1.alwaysValidSchema(it, schema)) {
            const valid = gen.var("valid", codegen_1._ `${len} <= ${items.length}`); // TODO var
            gen.ifNot(valid, () => validateItems(valid));
            cxt.ok(valid);
        }
        function validateItems(valid) {
            gen.forRange("i", items.length, len, (i) => {
                subschema_1.applySubschema(it, { keyword: "additionalItems", dataProp: i, dataPropType: subschema_1.Type.Num }, valid);
                if (!it.allErrors)
                    gen.ifNot(valid, codegen_1._ `break`);
            });
        }
    },
    error: {
        message: ({ params: { len } }) => codegen_1.str `should NOT have more than ${len} items`,
        params: ({ params: { len } }) => codegen_1._ `{limit: ${len}}`,
    },
};
module.exports = def;
//# sourceMappingURL=additionalItems.js.map