"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
const subschema_1 = require("../../compile/subschema");
const def = {
    keyword: "allOf",
    schemaType: "array",
    code(cxt) {
        const { gen, schema, it } = cxt;
        if (!Array.isArray(schema))
            throw new Error("ajv implementation error");
        const valid = gen.name("valid");
        schema.forEach((sch, i) => {
            if (util_1.alwaysValidSchema(it, sch))
                return;
            subschema_1.applySubschema(it, { keyword: "allOf", schemaProp: i }, valid);
            cxt.ok(valid);
        });
    },
};
module.exports = def;
//# sourceMappingURL=allOf.js.map