"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
const subschema_1 = require("../../compile/subschema");
const codegen_1 = require("../../compile/codegen");
const def = {
    keyword: "anyOf",
    schemaType: "array",
    trackErrors: true,
    code(cxt) {
        const { gen, schema, it } = cxt;
        if (!Array.isArray(schema))
            throw new Error("ajv implementation error");
        const alwaysValid = schema.some((sch) => util_1.alwaysValidSchema(it, sch));
        if (alwaysValid)
            return;
        const valid = gen.let("valid", false);
        const schValid = gen.name("_valid");
        gen.block(() => {
            schema.forEach((_sch, i) => {
                subschema_1.applySubschema(it, {
                    keyword: "anyOf",
                    schemaProp: i,
                    compositeRule: true,
                }, schValid);
                gen.assign(valid, codegen_1._ `${valid} || ${schValid}`);
                gen.ifNot(valid);
            });
        }, schema.length);
        cxt.result(valid, () => cxt.reset(), () => cxt.error(true));
    },
    error: {
        message: "should match some schema in anyOf",
    },
};
module.exports = def;
//# sourceMappingURL=anyOf.js.map