"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
const subschema_1 = require("../../compile/subschema");
const missing_1 = require("../missing");
const codegen_1 = require("../../compile/codegen");
const def = {
    keyword: "dependencies",
    type: "object",
    schemaType: "object",
    code(cxt) {
        const { gen, schema, data, it } = cxt;
        const [propDeps, schDeps] = splitDependencies();
        const valid = gen.name("valid");
        validatePropertyDeps(propDeps);
        validateSchemaDeps(schDeps);
        function splitDependencies() {
            const propertyDeps = {};
            const schemaDeps = {};
            for (const key in schema) {
                if (key === "__proto__")
                    continue;
                const deps = Array.isArray(schema[key]) ? propertyDeps : schemaDeps;
                deps[key] = schema[key];
            }
            return [propertyDeps, schemaDeps];
        }
        function validatePropertyDeps(propertyDeps) {
            if (Object.keys(propertyDeps).length === 0)
                return;
            const missing = gen.let("missing");
            for (const prop in propertyDeps) {
                const deps = propertyDeps[prop];
                if (deps.length === 0)
                    continue;
                const hasProperty = util_1.propertyInData(data, prop, it.opts.ownProperties);
                cxt.setParams({
                    property: prop,
                    depsCount: deps.length,
                    deps: deps.join(", "),
                });
                if (it.allErrors) {
                    gen.if(hasProperty, () => {
                        for (const depProp of deps) {
                            missing_1.checkReportMissingProp(cxt, depProp);
                        }
                    });
                }
                else {
                    gen.if(codegen_1._ `${hasProperty} && (${missing_1.checkMissingProp(cxt, deps, missing)})`);
                    missing_1.reportMissingProp(cxt, missing);
                    gen.else();
                }
            }
        }
        function validateSchemaDeps(schemaDeps) {
            for (const prop in schemaDeps) {
                if (util_1.alwaysValidSchema(it, schemaDeps[prop]))
                    continue;
                gen.if(util_1.propertyInData(data, prop, it.opts.ownProperties), () => subschema_1.applySubschema(it, { keyword: "dependencies", schemaProp: prop }, valid), () => gen.var(valid, true) // TODO var
                );
                cxt.ok(valid);
            }
        }
    },
    error: {
        message: ({ params: { property, depsCount, deps } }) => {
            const property_ies = depsCount === 1 ? "property" : "properties";
            return codegen_1.str `should have ${property_ies} ${deps} when property ${property} is present`;
        },
        params: ({ params: { property, depsCount, deps, missingProperty } }) => codegen_1._ `{property: ${property},
      missingProperty: ${missingProperty},
      depsCount: ${depsCount},
      deps: ${deps}}`,
    },
};
module.exports = def;
//# sourceMappingURL=dependencies.js.map