"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
const subschema_1 = require("../../compile/subschema");
const codegen_1 = require("../../compile/codegen");
const def = {
    keyword: "if",
    schemaType: ["object", "boolean"],
    trackErrors: true,
    code(cxt) {
        const { gen, parentSchema, it } = cxt;
        if (parentSchema.then === undefined && parentSchema.else === undefined) {
            util_1.checkStrictMode(it, '"if" without "then" and "else" is ignored');
        }
        const hasThen = hasSchema(it, "then");
        const hasElse = hasSchema(it, "else");
        if (!hasThen && !hasElse)
            return;
        const valid = gen.let("valid", true);
        const schValid = gen.name("_valid");
        validateIf();
        cxt.reset();
        if (hasThen && hasElse) {
            const ifClause = gen.let("ifClause");
            cxt.setParams({ ifClause });
            gen.if(schValid, validateClause("then", ifClause), validateClause("else", ifClause));
        }
        else if (hasThen) {
            gen.if(schValid, validateClause("then"));
        }
        else {
            gen.ifNot(schValid, validateClause("else"));
        }
        cxt.pass(valid, () => cxt.error(true));
        function validateIf() {
            subschema_1.applySubschema(it, {
                keyword: "if",
                compositeRule: true,
                createErrors: false,
                allErrors: false,
            }, schValid);
        }
        function validateClause(keyword, ifClause) {
            return () => {
                subschema_1.applySubschema(it, { keyword }, schValid);
                gen.assign(valid, schValid);
                if (ifClause)
                    gen.assign(ifClause, codegen_1._ `${keyword}`);
                else
                    cxt.setParams({ ifClause: keyword });
            };
        }
    },
    error: {
        message: ({ params }) => codegen_1.str `should match "${params.ifClause}" schema`,
        params: ({ params }) => codegen_1._ `{failingKeyword: ${params.ifClause}}`,
    },
};
module.exports = def;
function hasSchema(it, keyword) {
    const schema = it.schema[keyword];
    return schema !== undefined && !util_1.alwaysValidSchema(it, schema);
}
//# sourceMappingURL=if.js.map