"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
const subschema_1 = require("../../compile/subschema");
const codegen_1 = require("../../compile/codegen");
const def = {
    keyword: "items",
    type: "array",
    schemaType: ["object", "array", "boolean"],
    before: "uniqueItems",
    code(cxt) {
        const { gen, schema, data, it } = cxt;
        const len = gen.const("len", codegen_1._ `${data}.length`);
        if (Array.isArray(schema)) {
            validateDefinedItems(schema);
        }
        else if (!util_1.alwaysValidSchema(it, schema)) {
            validateItems();
        }
        function validateDefinedItems(schArr) {
            const valid = gen.name("valid");
            schArr.forEach((sch, i) => {
                if (util_1.alwaysValidSchema(it, sch))
                    return;
                gen.if(codegen_1._ `${len} > ${i}`, () => subschema_1.applySubschema(it, {
                    keyword: "items",
                    schemaProp: i,
                    dataProp: i,
                }, valid));
                cxt.ok(valid);
            });
        }
        function validateItems() {
            const valid = gen.name("valid");
            gen.forRange("i", 0, len, (i) => {
                subschema_1.applySubschema(it, { keyword: "items", dataProp: i, dataPropType: subschema_1.Type.Num }, valid);
                if (!it.allErrors)
                    gen.ifNot(valid, codegen_1._ `break`);
            });
            cxt.ok(valid);
        }
    },
};
module.exports = def;
//# sourceMappingURL=items.js.map