"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
const subschema_1 = require("../../compile/subschema");
const def = {
    keyword: "not",
    schemaType: ["object", "boolean"],
    trackErrors: true,
    code(cxt) {
        const { gen, schema, it } = cxt;
        if (util_1.alwaysValidSchema(it, schema)) {
            cxt.fail();
            return;
        }
        const valid = gen.name("valid");
        subschema_1.applySubschema(it, {
            keyword: "not",
            compositeRule: true,
            createErrors: false,
            allErrors: false,
        }, valid);
        cxt.result(valid, () => cxt.error(), () => cxt.reset());
    },
    error: {
        message: "should NOT be valid",
    },
};
module.exports = def;
//# sourceMappingURL=not.js.map