"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
const subschema_1 = require("../../compile/subschema");
const codegen_1 = require("../../compile/codegen");
const def = {
    keyword: "propertyNames",
    type: "object",
    schemaType: ["object", "boolean"],
    code(cxt) {
        const { gen, schema, data, it } = cxt;
        if (util_1.alwaysValidSchema(it, schema))
            return;
        const valid = gen.name("valid");
        gen.forIn("key", data, (key) => {
            cxt.setParams({ propertyName: key });
            subschema_1.applySubschema(it, { keyword: "propertyNames", data: key, propertyName: key, compositeRule: true }, valid);
            gen.ifNot(valid, () => {
                cxt.error(true);
                if (!it.allErrors)
                    gen.break();
            });
        });
        cxt.ok(valid);
    },
    error: {
        message: ({ params }) => codegen_1.str `property name '${params.propertyName}' is invalid`,
        params: ({ params }) => codegen_1._ `{propertyName: ${params.propertyName}}`,
    },
};
module.exports = def;
//# sourceMappingURL=propertyNames.js.map