"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reportMissingProp = exports.checkMissingProp = exports.checkReportMissingProp = void 0;
const util_1 = require("./util");
const codegen_1 = require("../compile/codegen");
function checkReportMissingProp(cxt, prop) {
    const { gen, data, it } = cxt;
    gen.if(util_1.noPropertyInData(data, prop, it.opts.ownProperties), () => {
        cxt.setParams({ missingProperty: codegen_1._ `${prop}` }, true);
        cxt.error();
    });
}
exports.checkReportMissingProp = checkReportMissingProp;
function checkMissingProp({ data, it: { opts } }, properties, missing) {
    return codegen_1.or(...properties.map((prop) => codegen_1._ `(${util_1.noPropertyInData(data, prop, opts.ownProperties)} && (${missing} = ${prop}))`));
}
exports.checkMissingProp = checkMissingProp;
function reportMissingProp(cxt, missing) {
    cxt.setParams({ missingProperty: missing }, true);
    cxt.error();
}
exports.reportMissingProp = reportMissingProp;
//# sourceMappingURL=missing.js.map