"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkStrictMode = exports.usePattern = exports.callValidateCode = exports.noPropertyInData = exports.propertyInData = exports.schemaProperties = exports.allSchemaProperties = exports.checkUnknownRules = exports.alwaysValidSchema = exports.schemaRefOrVal = void 0;
const util_1 = require("../compile/util");
const codegen_1 = require("../compile/codegen");
const names_1 = __importDefault(require("../compile/names"));
function schemaRefOrVal({ topSchemaRef, schemaPath }, schema, keyword, $data) {
    if (!$data) {
        if (typeof schema == "number" || typeof schema == "boolean")
            return schema;
        if (typeof schema == "string")
            return codegen_1._ `${schema}`;
    }
    return codegen_1._ `${topSchemaRef}${schemaPath}${codegen_1.getProperty(keyword)}`;
}
exports.schemaRefOrVal = schemaRefOrVal;
function alwaysValidSchema(it, schema) {
    if (typeof schema == "boolean")
        return schema;
    if (Object.keys(schema).length === 0)
        return true;
    checkUnknownRules(it, schema);
    return !util_1.schemaHasRules(schema, it.self.RULES.all);
}
exports.alwaysValidSchema = alwaysValidSchema;
function checkUnknownRules(it, schema = it.schema) {
    const { opts, self } = it;
    if (!opts.strict)
        return;
    if (typeof schema === "boolean")
        return;
    const rules = self.RULES.keywords;
    for (const key in schema) {
        if (!rules[key])
            checkStrictMode(it, `unknown keyword: "${key}"`);
    }
}
exports.checkUnknownRules = checkUnknownRules;
function allSchemaProperties(schemaMap) {
    return schemaMap ? Object.keys(schemaMap).filter((p) => p !== "__proto__") : [];
}
exports.allSchemaProperties = allSchemaProperties;
function schemaProperties(it, schemaMap) {
    return allSchemaProperties(schemaMap).filter((p) => !alwaysValidSchema(it, schemaMap[p]));
}
exports.schemaProperties = schemaProperties;
function isOwnProperty(data, property) {
    return codegen_1._ `Object.prototype.hasOwnProperty.call(${data}, ${property})`;
}
function propertyInData(data, property, ownProperties) {
    const cond = codegen_1._ `${data}${codegen_1.getProperty(property)} !== undefined`;
    return ownProperties ? codegen_1._ `${cond} && ${isOwnProperty(data, property)}` : cond;
}
exports.propertyInData = propertyInData;
function noPropertyInData(data, property, ownProperties) {
    const cond = codegen_1._ `${data}${codegen_1.getProperty(property)} === undefined`;
    return ownProperties ? codegen_1._ `${cond} || !${isOwnProperty(data, property)}` : cond;
}
exports.noPropertyInData = noPropertyInData;
function callValidateCode({ schemaCode, data, it }, func, context, passSchema) {
    const dataAndSchema = passSchema
        ? codegen_1._ `${schemaCode}, ${data}, ${it.topSchemaRef}${it.schemaPath}`
        : data;
    const dataPath = codegen_1._ `(${names_1.default.dataPath} || '') + ${it.errorPath}`; // TODO refactor other places
    const args = codegen_1._ `${dataAndSchema}, ${dataPath}, ${it.parentData}, ${it.parentDataProperty}, ${names_1.default.rootData}`;
    return context !== codegen_1.nil ? codegen_1._ `${func}.call(${context}, ${args})` : codegen_1._ `${func}(${args})`;
}
exports.callValidateCode = callValidateCode;
function usePattern(gen, pattern) {
    return gen.scopeValue("pattern", {
        key: pattern,
        ref: new RegExp(pattern, "u"),
        code: codegen_1._ `new RegExp(${pattern}, "u")`,
    });
}
exports.usePattern = usePattern;
function checkStrictMode(it, msg) {
    const { opts, self } = it;
    if (opts.strict) {
        if (opts.strict === "log")
            self.logger.warn(msg);
        else
            throw new Error(msg);
    }
}
exports.checkStrictMode = checkStrictMode;
//# sourceMappingURL=util.js.map