"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const fast_deep_equal_1 = __importDefault(require("fast-deep-equal"));
const def = {
    keyword: "const",
    $data: true,
    code(cxt) {
        const eql = cxt.gen.scopeValue("func", {
            ref: fast_deep_equal_1.default,
            code: codegen_1._ `require("ajv/dist/compile/equal")`,
        });
        cxt.fail$data(codegen_1._ `!${eql}(${cxt.data}, ${cxt.schemaCode})`);
    },
    error: {
        message: "should be equal to constant",
        params: ({ schemaCode }) => codegen_1._ `{allowedValue: ${schemaCode}}`,
    },
};
module.exports = def;
//# sourceMappingURL=const.js.map