"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const ops = codegen_1.operators;
const OPS = {
    maximum: { okStr: "<=", ok: ops.LTE, fail: ops.GT },
    minimum: { okStr: ">=", ok: ops.GTE, fail: ops.LT },
    exclusiveMaximum: { okStr: "<", ok: ops.LT, fail: ops.GTE },
    exclusiveMinimum: { okStr: ">", ok: ops.GT, fail: ops.LTE },
};
const def = {
    keyword: ["maximum", "minimum", "exclusiveMaximum", "exclusiveMinimum"],
    type: "number",
    schemaType: "number",
    $data: true,
    code(cxt) {
        const { keyword, data, schemaCode } = cxt;
        // const bdt = bad$DataType(schemaCode, <string>def.schemaType, $data)
        cxt.fail$data(codegen_1._ `(${data} ${OPS[keyword].fail} ${schemaCode} || isNaN(${data}))`);
    },
    error: {
        message: ({ keyword, schemaCode }) => codegen_1.str `should be ${OPS[keyword].okStr} ${schemaCode}`,
        params: ({ keyword, schemaCode }) => codegen_1._ `{comparison: ${OPS[keyword].okStr}, limit: ${schemaCode}}`,
    },
};
module.exports = def;
//# sourceMappingURL=limit.js.map