"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const ucs2length_1 = __importDefault(require("../../compile/ucs2length"));
const def = {
    keyword: ["maxLength", "minLength"],
    type: "string",
    schemaType: "number",
    $data: true,
    code(cxt) {
        const { keyword, data, schemaCode, it } = cxt;
        const op = keyword === "maxLength" ? codegen_1.operators.GT : codegen_1.operators.LT;
        let len;
        if (it.opts.unicode === false) {
            len = codegen_1._ `${data}.length`;
        }
        else {
            const u2l = cxt.gen.scopeValue("func", {
                ref: ucs2length_1.default,
                code: codegen_1._ `require("ajv/dist/compile/ucs2length")`,
            });
            len = codegen_1._ `${u2l}(${data})`;
        }
        cxt.fail$data(codegen_1._ `${len} ${op} ${schemaCode}`);
    },
    error: {
        message({ keyword, schemaCode }) {
            const comp = keyword === "maxLength" ? "more" : "fewer";
            return codegen_1.str `should NOT have ${comp} than ${schemaCode} items`;
        },
        params: ({ schemaCode }) => codegen_1._ `{limit: ${schemaCode}}`,
    },
};
module.exports = def;
//# sourceMappingURL=limitLength.js.map