"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codegen_1 = require("../../compile/codegen");
const def = {
    keyword: ["maxProperties", "minProperties"],
    type: "object",
    schemaType: "number",
    $data: true,
    code(cxt) {
        const { keyword, data, schemaCode } = cxt;
        const op = keyword === "maxProperties" ? codegen_1.operators.GT : codegen_1.operators.LT;
        cxt.fail$data(codegen_1._ `Object.keys(${data}).length ${op} ${schemaCode}`);
    },
    error: {
        message({ keyword, schemaCode }) {
            const comp = keyword === "maxProperties" ? "more" : "fewer";
            return codegen_1.str `should NOT have ${comp} than ${schemaCode} items`;
        },
        params: ({ schemaCode }) => codegen_1._ `{limit: ${schemaCode}}`,
    },
};
module.exports = def;
//# sourceMappingURL=limitProperties.js.map