"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
const codegen_1 = require("../../compile/codegen");
const def = {
    keyword: "pattern",
    type: "string",
    schemaType: "string",
    $data: true,
    code(cxt) {
        const { gen, data, $data, schema, schemaCode } = cxt;
        const regExp = $data ? codegen_1._ `(new RegExp(${schemaCode}, "u"))` : util_1.usePattern(gen, schema); // TODO regexp should be wrapped in try/catch
        cxt.fail$data(codegen_1._ `!${regExp}.test(${data})`);
    },
    error: {
        message: ({ schemaCode }) => codegen_1.str `should match pattern "${schemaCode}"`,
        params: ({ schemaCode }) => codegen_1._ `{pattern: ${schemaCode}}`,
    },
};
module.exports = def;
//# sourceMappingURL=pattern.js.map