"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("../util");
const missing_1 = require("../missing");
const codegen_1 = require("../../compile/codegen");
const def = {
    keyword: "required",
    type: "object",
    schemaType: "array",
    $data: true,
    code(cxt) {
        const { gen, schema, schemaCode, data, $data, it } = cxt;
        if (!$data && schema.length === 0)
            return;
        const useLoop = schema.length >= it.opts.loopRequired;
        if (it.allErrors)
            allErrorsMode();
        else
            exitOnErrorMode();
        function allErrorsMode() {
            if (useLoop || $data) {
                cxt.block$data(codegen_1.nil, loopAllRequired);
            }
            else {
                for (const prop of schema) {
                    missing_1.checkReportMissingProp(cxt, prop);
                }
            }
        }
        function exitOnErrorMode() {
            const missing = gen.let("missing");
            if (useLoop || $data) {
                const valid = gen.let("valid", true);
                cxt.block$data(valid, () => loopUntilMissing(missing, valid));
                cxt.ok(valid);
            }
            else {
                gen.if(missing_1.checkMissingProp(cxt, schema, missing));
                missing_1.reportMissingProp(cxt, missing);
                gen.else();
            }
        }
        function loopAllRequired() {
            gen.forOf("prop", schemaCode, (prop) => {
                cxt.setParams({ missingProperty: prop });
                gen.if(util_1.noPropertyInData(data, prop, it.opts.ownProperties), () => cxt.error());
            });
        }
        function loopUntilMissing(missing, valid) {
            cxt.setParams({ missingProperty: missing });
            gen.forOf(missing, schemaCode, () => {
                gen.assign(valid, util_1.propertyInData(data, missing, it.opts.ownProperties));
                gen.ifNot(valid, () => {
                    cxt.error();
                    gen.break();
                });
            }, codegen_1.nil);
        }
    },
    error: {
        message: ({ params: { missingProperty } }) => codegen_1.str `should have required property '${missingProperty}'`,
        params: ({ params: { missingProperty } }) => codegen_1._ `{missingProperty: ${missingProperty}}`,
    },
};
module.exports = def;
//# sourceMappingURL=required.js.map