import type { AnySchema } from "../types";
import type { SchemaCxt, SchemaObjCxt } from ".";
import { Code } from "./codegen";
import type { Rule, ValidationRules } from "./rules";
export declare function toHash<T extends string = string>(arr: T[]): {
    [K in T]?: true;
};
export declare function alwaysValidSchema(it: SchemaCxt, schema: AnySchema): boolean | void;
export declare function checkUnknownRules(it: SchemaCxt, schema?: AnySchema): void;
export declare function schemaHasRules(schema: AnySchema, rules: {
    [key: string]: boolean | Rule | undefined;
}): boolean;
export declare function schemaHasRulesButRef(schema: AnySchema, RULES: ValidationRules): boolean;
export declare function schemaRefOrVal({ topSchemaRef, schemaPath }: SchemaObjCxt, schema: unknown, keyword: string, $data?: string | false): Code | number | boolean;
export declare function unescapeFragment(str: string): string;
export declare function escapeFragment(str: string | number): string;
export declare function escapeJsonPointer(str: string | number): string;
export declare function unescapeJsonPointer(str: string): string;
export declare function eachItem<T>(xs: T | T[], f: (x: T) => void): void;
export declare function ucs2length(str: string): number;
