import type { AddedKeywordDefinition, KeywordErrorCxt, KeywordCxtParams, AnySchemaObject } from "../types";
import { SchemaCxt, SchemaObjCxt } from "./index";
import { JSONType } from "./rules";
import { CodeGen, Code, Name } from "./codegen";
import { SubschemaArgs } from "./subschema";
export default class KeywordCxt implements KeywordErrorCxt {
    readonly gen: CodeGen;
    readonly allErrors?: boolean;
    readonly keyword: string;
    readonly data: Name;
    readonly $data?: string | false;
    readonly schema: any;
    readonly schemaValue: Code | number | boolean;
    readonly schemaCode: Code | number | boolean;
    readonly schemaType: JSONType[];
    readonly parentSchema: AnySchemaObject;
    readonly errsCount?: Name;
    params: KeywordCxtParams;
    readonly it: SchemaObjCxt;
    readonly def: AddedKeywordDefinition;
    constructor(it: SchemaObjCxt, def: AddedKeywordDefinition, keyword: string);
    result(condition: Code, successAction?: () => void, failAction?: () => void): void;
    pass(condition: Code, failAction?: () => void): void;
    fail(condition?: Code): void;
    fail$data(condition: Code): void;
    error(append?: true): void;
    $dataError(): void;
    reset(): void;
    ok(cond: Code | boolean): void;
    setParams(obj: KeywordCxtParams, assign?: true): void;
    block$data(valid: Name, codeBlock: () => void, $dataValid?: Code): void;
    check$data(valid?: Name, $dataValid?: Code): void;
    invalid$data(): Code;
    subschema(appl: SubschemaArgs, valid: Name): SchemaCxt;
    mergeEvaluated(schemaCxt: SchemaCxt, toName?: typeof Name): void;
    mergeValidEvaluated(schemaCxt: SchemaCxt, valid: Name): boolean | void;
}
