import type { AddedKeywordDefinition } from "../types";
declare const _jsonTypes: readonly ["string", "number", "integer", "boolean", "null", "object", "array"];
export declare type JSONType = typeof _jsonTypes[number];
export declare function isJSONType(x: unknown): x is JSONType;
declare type ValidationTypes = {
    [K in JSONType]: boolean | RuleGroup | undefined;
};
export interface ValidationRules {
    rules: RuleGroup[];
    all: {
        [key: string]: boolean | Rule | undefined;
    };
    keywords: {
        [key: string]: boolean | undefined;
    };
    types: ValidationTypes;
}
export interface RuleGroup {
    type?: JSONType;
    rules: Rule[];
}
export interface Rule {
    keyword: string;
    definition: AddedKeywordDefinition;
}
export declare function getRules(): ValidationRules;
export {};
